/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugproxy.comm;

import com.oracle.tee.tools.util.Utils;
import com.sun.javacard.debugproxy.Commands;

public final class Packet {
    public static final short NO_FLAGS = 0;
    public static final short REPLY = 128;
    public static final short REPLY_NO_ERROR = 0;
    public static final short UNDEFINED_COMMAND_SET = 0;
    public static final short UNDEFINED_COMMAND = 0;
    private static int uID = -2147483647;
    static final byte[] nullData = new byte[0];
    int id;
    short flags;
    public short commandSet;
    public short command;
    short errorCode;
    byte[] data;
    volatile boolean replied = false;
    int readIndex;
    int writeIndex;

    public static synchronized int uniqID() {
        return uID++;
    }

    public Packet() {
        this(Packet.uniqID());
        this.flags = 0;
        this.data = new byte[1024];
        this.writeIndex = 0;
        this.readIndex = 0;
    }

    public Packet(int id) {
        this.id = id;
        this.flags = 0;
        this.data = new byte[1024];
        this.writeIndex = 0;
        this.readIndex = 0;
    }

    public Packet(int id, short flags, short errorCode, byte[] data) {
        this.id = id;
        this.errorCode = errorCode;
        this.flags = flags;
        this.data = data;
    }

    public Packet(int commandSet, int command, byte[] data) {
        this.id = Packet.uniqID();
        this.commandSet = (short)commandSet;
        this.command = (short)command;
        this.data = data;
    }

    public Packet(int id, short commandSet, short command, short flags, short errorCode, byte[] data) {
        this.id = id == 0 ? Packet.uniqID() : id;
        this.commandSet = commandSet;
        this.command = command;
        this.flags = flags;
        this.errorCode = errorCode;
        this.data = data == null ? new byte[1024] : data;
    }

    public void setId(int id) {
        this.id = id;
    }

    public boolean hasFlags() {
        return this.flags != 0;
    }

    public boolean isReplyPacket() {
        return (this.flags & 0x80) != 0;
    }

    public int getLength() {
        return this.writeIndex;
    }

    public void setData(byte[] data) {
        this.data = new byte[data.length];
        System.arraycopy(data, 0, this.data, 0, data.length);
        this.writeIndex = data.length;
        this.readIndex = 0;
    }

    public String toString() {
        StringBuffer s;
        try {
            s = new StringBuffer();
            s.append("ID=").append(this.id).append("/");
            s.append(Commands.getVMCommands()[this.commandSet][0]).append("(").append(this.commandSet).append(")/");
            s.append(Commands.getVMCommands()[this.commandSet][this.command]).append("(").append(this.command).append(")/").append(this.errorCode).append("/");
        }
        catch (Exception e) {
            s = new StringBuffer();
            s.append("ID=").append(this.id).append("/");
            s.append(this.commandSet).append("/").append(this.command).append("/").append(this.errorCode).append("/");
        }
        s.append(Utils.canonize(this.data));
        return s.toString();
    }

    public byte[] getData() {
        return this.data;
    }

    public int getId() {
        return this.id;
    }
}

