/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.mask.jrefmask;

import com.sun.javacard.jcasm.Msg;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

class SymbolTable {
    private static int numEntries;
    private static short count;
    private Hashtable<String, String> table;

    public SymbolTable(int n) {
        count = 0;
        numEntries = n;
        this.table = new Hashtable(numEntries);
    }

    public void addField(String name, String addr) {
        if ((count = (short)(count + 1)) > numEntries) {
            // empty if block
        }
        this.table.put(name, addr);
    }

    public Hashtable<String, String> getTable() {
        return this.table;
    }

    public byte[] toByteArray() {
        byte[] dummy = new byte[]{0, 0};
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeShort((short)this.table.size());
            Enumeration<String> e = this.table.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                String value = this.table.get(key);
                dos.writeShort(0);
                dos.writeUTF(key);
                dos.writeShort(0);
                dos.writeUTF(value);
            }
            dos.flush();
        }
        catch (IOException e) {
            Msg.error("jref.2", null);
            e.printStackTrace();
            System.exit(1);
        }
        return bos.toByteArray();
    }

    public void write(DataOutputStream os) throws IOException {
        byte[] data = this.toByteArray();
        if (data != null) {
            os.write(data);
        }
    }
}

