/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.ExnHandlerInfo;
import com.sun.javacard.offcardverifier.Instr;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import com.sun.javacard.offcardverifier.MethodInfo;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.offcardverifier.VerifierError;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;

class RefLocComponent
extends Safeptr {
    RefLocComponent(byte[] data) {
        super(data, "ReferenceLocation");
    }

    int byteIndexCount() {
        return this.u2(0);
    }

    Safeptr offsetsToByteIndices() {
        return this.offset(2);
    }

    int byte2_indexCount() {
        return this.u2(2 + this.byteIndexCount());
    }

    Safeptr offsetsToByte2Indices() {
        return this.offset(4 + this.byteIndexCount());
    }

    void verify() {
        int i;
        if (Verifier.verbose >= 2) {
            Messages.println("RefLocComponent.100");
        }
        Vector<Integer> byteRefloc = new Vector<Integer>();
        Vector<Integer> byte2_refloc = new Vector<Integer>();
        this.addReflocs(byteRefloc, this.byteIndexCount(), this.offsetsToByteIndices());
        this.addReflocs(byte2_refloc, this.byte2_indexCount(), this.offsetsToByte2Indices());
        TreeSet<Integer> byteRefs = new TreeSet<Integer>();
        TreeSet<Integer> byte2_refs = new TreeSet<Integer>();
        ClassDescriptor c = Cap.Descriptor.firstClassDescriptor();
        for (i = Cap.Descriptor.classCount(); i > 0; --i) {
            if ((c.flags() & 0x40) == 0) {
                for (int j = 0; j < c.methodCount(); ++j) {
                    MethodDescriptor mdesc = c.methodDescr(j);
                    this.addReferencesInMethod(byteRefs, byte2_refs, mdesc);
                }
            }
            c.next();
        }
        for (i = 0; i < Cap.Method.handlerCount(); ++i) {
            ExnHandlerInfo exn = Cap.Method.exceptionHandler(i);
            if (exn.catchType() == 0) continue;
            byte2_refs.add(new Integer(exn.ofs + 6));
        }
        this.checkReflocEqual(byteRefloc, byteRefs, 1);
        this.checkReflocEqual(byte2_refloc, byte2_refs, 2);
        if (4 + this.byteIndexCount() + this.byte2_indexCount() != Cap.ReferenceLocation.size()) {
            throw new VerifierError("RefLocComponent.1");
        }
    }

    private void addReflocs(Vector<Integer> refs, int numRefs, Safeptr p) {
        int ofs = 0;
        for (int i = 0; i < numRefs; ++i) {
            int delta = p.u1(i);
            ofs += delta;
            if (delta == 255) continue;
            refs.add(new Integer(ofs));
        }
    }

    private void addReferencesInMethod(TreeSet<Integer> byteRefs, TreeSet<Integer> byte2_refs, MethodDescriptor mdesc) {
        MethodInfo minfo = Cap.Method.methodInfo(mdesc.methodOffset());
        int flags = minfo.flags();
        if ((flags & 4) != 0) {
            return;
        }
        Safeptr pc = (flags & 8) == 0 ? minfo.bytecodeCompact() : minfo.bytecodeExtended();
        int endCode = pc.ofs + mdesc.bytecodeCount();
        while (pc.ofs < endCode) {
            Instr i = Instr.instrAt(pc);
            block0 : switch (i.opcode) {
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 139: 
                case 140: 
                case 141: 
                case 143: 
                case 145: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 177: 
                case 178: 
                case 179: 
                case 180: {
                    byte2_refs.add(new Integer(pc.ofs + 1));
                    break;
                }
                case 131: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 181: 
                case 182: 
                case 183: 
                case 184: {
                    byteRefs.add(new Integer(pc.ofs + 1));
                    break;
                }
                case 142: {
                    byte2_refs.add(new Integer(pc.ofs + 2));
                    break;
                }
                case 148: 
                case 149: {
                    switch (pc.u1(1)) {
                        case 0: 
                        case 14: {
                            byte2_refs.add(new Integer(pc.ofs + 2));
                            break block0;
                        }
                    }
                }
            }
            pc.advance(i.length());
        }
    }

    private void checkReflocEqual(Vector<Integer> loc1, TreeSet<Integer> loc2, int len) {
        Enumeration<Integer> e1 = loc1.elements();
        Iterator<Integer> i2 = loc2.iterator();
        while (e1.hasMoreElements() && i2.hasNext()) {
            int ofs2;
            int ofs1 = e1.nextElement();
            if (ofs1 < (ofs2 = i2.next().intValue())) {
                throw new VerifierError("RefLocComponent.2", len, ofs1);
            }
            if (ofs1 <= ofs2) continue;
            throw new VerifierError("RefLocComponent.3", len, ofs2);
        }
        if (e1.hasMoreElements()) {
            throw new VerifierError("RefLocComponent.4", len);
        }
        if (i2.hasNext()) {
            throw new VerifierError("RefLocComponent.5", len);
        }
    }
}

