/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.packager;

import com.sun.javacard.converter.ConverterHarness;
import com.sun.javacard.packager.ErrorKey;
import com.sun.javacard.packager.model.AppletXML;
import com.sun.javacard.packager.model.ClassicLibrary;
import com.sun.javacard.packager.model.ClassicModule;
import com.sun.javacard.packager.model.ClassicModuleJCRD;
import com.sun.javacard.packager.model.FolderOrJar;
import com.sun.javacard.packager.model.PackageItem;
import com.sun.javacard.packager.model.Signer;
import com.sun.javacard.tools.util.JCToolsLogger;
import com.sun.javacard.util.AIDUtils;
import com.sun.javacard.util.FileUtils;
import com.sun.javacard.util.ZipUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class Packager
extends PackageItem {
    private static Packager packager = new Packager();
    private boolean verbose;
    private String type;
    private String packageAID;
    private String exportPath;
    private File out;
    private boolean force = false;
    private boolean compress = false;
    private boolean useProxyClass = false;
    private FolderOrJar packageItem;
    private Signer signer = new Signer();
    private File workDir = null;
    private File converterWorkSpace = null;
    private String keepDir = null;

    public static Packager getPackager() {
        return packager;
    }

    private Packager() {
    }

    @Override
    public String getItemDisplayName() {
        return "Packager";
    }

    @Override
    public void initialize() {
        this.createWorkDir();
        if (this.isSign()) {
            this.addItem(this.signer);
            this.signer.initialize();
        }
        if (this.packageItem == null) {
            this.addError(ErrorKey.NoPackageItemSpecified, new Object[0]);
        } else {
            this.addItem(this.packageItem);
            this.packageItem.initialize();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processInternal() {
        String packageAID;
        String packageName;
        Vector<Object> appletInfo;
        String jcHome = "";
        JCToolsLogger toolsLogger = JCToolsLogger.getLogger("test");
        if (this.packageItem != null) {
            this.packageItem.process();
        }
        if (!this.isOk(true)) {
            return;
        }
        if (this.out.exists()) {
            if (this.isForce()) {
                this.addWarning(ErrorKey.OutputFileWillBeOverWritten, this.out.getAbsolutePath());
            } else {
                this.addError(ErrorKey.CanNotOverWriteOutputFile, this.out.getAbsolutePath());
                return;
            }
        }
        if (this.type.equals("classic-applet")) {
            this.converterWorkSpace = null;
            appletInfo = new Vector();
            packageName = "";
            packageAID = "";
            for (PackageItem item : this.items) {
                if (!(item instanceof ClassicModule)) continue;
                Vector<File> vf = FileUtils.listAllFilesInFolder(((ClassicModule)item).getFolder(), ".class");
                HashSet<String> set = new HashSet<String>();
                for (int i = 0; i < vf.size(); ++i) {
                    void var11_24;
                    File file = vf.elementAt(i).getParentFile();
                    if (file.getName().equals("proxy")) {
                        File file2 = file.getParentFile();
                    }
                    set.add(var11_24.getAbsolutePath());
                }
                if (set.size() > 1) {
                    this.addError(ErrorKey.OnlyOnePackageInClassicAppOrLib, new Object[0]);
                    return;
                }
                for (PackageItem packageItem : item.getItems()) {
                    if (packageItem instanceof AppletXML) {
                        packageName = ((AppletXML)packageItem).getPackageName();
                        appletInfo = ((AppletXML)packageItem).getAppletInfo();
                        continue;
                    }
                    if (!(packageItem instanceof ClassicModuleJCRD)) continue;
                    packageAID = ((ClassicModuleJCRD)packageItem).getAID();
                }
            }
            this.converterWorkSpace = new File(System.getProperty("java.io.tmpdir") + "converterWorkSpace_" + System.currentTimeMillis()).getAbsoluteFile();
            if (!this.converterWorkSpace.mkdirs()) {
                this.addError(ErrorKey.UnableToCreateWorkingFolder, this.converterWorkSpace);
                return;
            }
            Vector<Object> args = new Vector<Object>();
            args.add("-i");
            if (packager.isUseProxyClass()) {
                args.add("-useproxyclass");
            }
            args.add("-exportpath");
            jcHome = System.getProperty("jc.home");
            if (jcHome == null) {
                this.addError(ErrorKey.JCHomeNotSet, new Object[0]);
                return;
            }
            args.add(jcHome + "/api_export_files" + (this.getExportPath() != null ? ";" + this.getExportPath() : ""));
            args.add("-classdir");
            args.add(this.getWorkDir() + "/APPLET-INF/classes");
            args.add("-d");
            args.add(this.converterWorkSpace.getAbsolutePath());
            if (packager.getKeepDir() != null) {
                args.add("-keepproxysource");
                args.add(packager.getKeepDir());
            }
            int i = 0;
            while (i < appletInfo.size()) {
                args.add("-applet");
                String s = (String)appletInfo.elementAt(i++);
                args.add(AIDUtils.getAsPrintableHex(s));
                args.add(appletInfo.elementAt(i++));
            }
            args.add(packageName);
            args.add(AIDUtils.getAsPrintableHex(packageAID));
            args.add("1.0");
            String[] argv = new String[args.size()];
            ConverterHarness.startConversion(args.toArray(argv), null);
            StringBuffer in = new StringBuffer();
            StringBuffer inExp = new StringBuffer();
            StringBuffer inProxy = new StringBuffer();
            in.append(this.converterWorkSpace.getAbsolutePath());
            in.append("/");
            in.append(packageName.replace('.', '/'));
            inProxy.append(in);
            inProxy.append("/proxy");
            in.append("/javacard/");
            int n = packageName.lastIndexOf(".");
            if (n == -1) {
                in.append(packageName);
            } else {
                in.append(packageName.substring(n + 1));
            }
            inExp.append(in);
            in.append(".cap");
            inExp.append(".exp");
            try {
                FileUtils.copyFile(new File(in.toString()), this.out.getAbsoluteFile());
                String expFile = this.out.getAbsolutePath();
                int idx = expFile.lastIndexOf(".cap");
                if (idx != -1) {
                    expFile = expFile.substring(0, idx);
                }
                File outDir = this.out.getParentFile();
                File expDir = new File(outDir, packageName.replace('.', File.separatorChar));
                expDir = new File(expDir, "javacard");
                expDir.mkdirs();
                FileUtils.copyFile(new File(inExp.toString()), new File(expDir, new File(inExp.toString()).getName()));
                this.extractClassesAndPutAlongWithExpFile(this.out.getParentFile(), this.out, false);
            }
            catch (Exception e) {
                this.addError(ErrorKey.UnableToWriteTheContents, e.getMessage());
                return;
            }
        }
        if (this.type.equals("classic-lib")) {
            this.converterWorkSpace = null;
            appletInfo = new Vector();
            packageName = "";
            packageAID = this.getPackageAID();
            if (packageAID == null) {
                this.addError(ErrorKey.PackageAIDNotSpecified, new Object[0]);
                return;
            }
            for (PackageItem item : this.items) {
                if (!(item instanceof ClassicLibrary)) continue;
                ClassicLibrary clib = (ClassicLibrary)item;
                Vector<File> vf = FileUtils.listAllFilesInFolder(clib.getFolder(), ".class");
                HashSet<String> set = new HashSet<String>();
                for (int i = 0; i < vf.size(); ++i) {
                    File f = vf.elementAt(i).getParentFile();
                    if (f.getName().equals("proxy")) {
                        f = f.getParentFile();
                    }
                    set.add(f.getAbsolutePath());
                }
                if (set.size() > 1) {
                    this.addError(ErrorKey.OnlyOnePackageInClassicAppOrLib, new Object[0]);
                    return;
                }
                packageName = this.findPackage(clib.getFolder());
            }
            this.converterWorkSpace = new File(System.getProperty("java.io.tmpdir") + "converterWorkSpace_" + System.currentTimeMillis()).getAbsoluteFile();
            if (!this.converterWorkSpace.mkdirs()) {
                this.addError(ErrorKey.UnableToCreateWorkingFolder, this.converterWorkSpace);
                return;
            }
            Vector<String> args = new Vector<String>();
            args.add("-i");
            args.add("-exportpath");
            jcHome = System.getProperty("jc.home");
            if (jcHome == null) {
                this.addError(ErrorKey.JCHomeNotSet, new Object[0]);
                return;
            }
            args.add(jcHome + "/api_export_files" + (this.getExportPath() != null ? ";" + this.getExportPath() : ""));
            args.add("-classdir");
            args.add(this.getWorkDir().getAbsolutePath());
            args.add("-d");
            if (packager.getKeepDir() != null) {
                args.add(packager.getKeepDir());
            } else {
                args.add(this.converterWorkSpace.getAbsolutePath());
            }
            args.add(packageName);
            args.add(AIDUtils.getAsPrintableHex(packageAID));
            args.add("1.0");
            String[] argv = new String[args.size()];
            ConverterHarness.startConversion(args.toArray(argv), null);
            StringBuffer in = new StringBuffer();
            StringBuffer inExp = new StringBuffer();
            StringBuffer inProxy = new StringBuffer();
            if (packager.getKeepDir() != null) {
                in.append(packager.getKeepDir());
            } else {
                in.append(this.converterWorkSpace.getAbsolutePath());
            }
            in.append("/");
            in.append(packageName.replace('.', '/'));
            inProxy.append(in);
            inProxy.append("/proxy");
            in.append("/javacard/");
            int n = packageName.lastIndexOf(".");
            if (n == -1) {
                in.append(packageName);
            } else {
                in.append(packageName.substring(n + 1));
            }
            inExp.append(in);
            in.append(".cap");
            inExp.append(".exp");
            try {
                FileUtils.copyFile(new File(in.toString()), this.out.getAbsoluteFile());
                String expFile = this.out.getAbsolutePath();
                int idx = expFile.lastIndexOf(".cap");
                if (idx != -1) {
                    expFile = expFile.substring(0, idx);
                }
                File outDir = this.out.getParentFile();
                File expDir = new File(outDir, packageName.replace('.', File.separatorChar));
                expDir = new File(expDir, "javacard");
                expDir.mkdirs();
                FileUtils.copyFile(new File(inExp.toString()), new File(expDir, new File(inExp.toString()).getName()));
                this.extractClassesAndPutAlongWithExpFile(this.out.getParentFile(), this.out, true);
            }
            catch (Exception e) {
                this.addError(ErrorKey.UnableToWriteTheContents, e.getMessage());
                return;
            }
        }
        try {
            ZipUtils.zip(this.workDir, this.out, this.isCompress());
        }
        catch (Exception e) {
            if (this.out.exists()) {
                this.out.delete();
            }
            this.addError(ErrorKey.UnableToZipTheContents, e.getMessage());
            return;
        }
        if (this.workDir != null) {
            FileUtils.deleteDir(this.workDir);
        }
        if (this.converterWorkSpace != null) {
            FileUtils.deleteDir(this.converterWorkSpace);
        }
        if (this.isOk() && this.isSign()) {
            this.signer.process();
        }
        if (!this.isOk()) {
            String signatureFileName = this.out.getAbsolutePath();
            int lastIndex = signatureFileName.lastIndexOf(46);
            signatureFileName = signatureFileName.substring(0, lastIndex) + ".signature";
            File signatureFile = new File(signatureFileName);
            if (this.out.exists()) {
                this.out.delete();
            }
            if (signatureFile.exists()) {
                signatureFile.delete();
            }
        }
    }

    public void setPackageItem(FolderOrJar packageItem) {
        this.packageItem = packageItem;
    }

    public FolderOrJar getPackageItem() {
        return this.packageItem;
    }

    public String getType() {
        return this.type != null ? this.type.toLowerCase() : null;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getPackageAID() {
        return this.packageAID;
    }

    public void setPackageAID(String packageAID) {
        this.packageAID = packageAID;
    }

    public String getExportPath() {
        return this.exportPath;
    }

    public void setExportPath(String exportPath) {
        this.exportPath = exportPath;
    }

    public File getOut() {
        return this.out;
    }

    public void setOut(File out) {
        this.out = out;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public boolean isUseProxyClass() {
        return this.useProxyClass;
    }

    public void setUseProxyClass() {
        this.useProxyClass = true;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public boolean isSign() {
        return this.signer.isRequired();
    }

    public void setSign(boolean sign) {
        this.signer.setRequired(sign);
    }

    public String getKeystore() {
        return this.signer.getKeystore();
    }

    public void setKeystore(String keystore) {
        this.signer.setKeystore(keystore);
    }

    public String getStorepass() {
        return this.signer.getStorepass();
    }

    public void setStorepass(String storepass) {
        this.signer.setStorepass(storepass);
    }

    public String getPasskey() {
        return this.signer.getPasskey();
    }

    public void setPasskey(String passkey) {
        this.signer.setPasskey(passkey);
    }

    public String getAlias() {
        return this.signer.getAlias();
    }

    public void setAlias(String alias) {
        this.signer.setAlias(alias);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(File workDir) {
        this.workDir = workDir;
    }

    public String getKeepDir() {
        return this.keepDir;
    }

    public void setKeepDir(String keepDir) {
        this.keepDir = keepDir;
    }

    public void addXtraOption(String str) {
        if (str == null) {
            return;
        }
        if ((str = str.trim()).length() <= 0) {
            return;
        }
        String name = null;
        String value = null;
        int eqIndex = str.indexOf("=");
        if (eqIndex == -1) {
            name = str;
        } else {
            name = str.substring(0, eqIndex).trim();
            value = str.substring(eqIndex + 1).trim();
            if (value.length() <= 0) {
                value = null;
            }
        }
        if (name.equalsIgnoreCase("workdir") && value != null) {
            this.workDir = new File(value).getAbsoluteFile();
        }
    }

    private void createWorkDir() {
        if (this.workDir == null) {
            this.workDir = new File(System.getProperty("java.io.tmpdir") + "packager_temp_root_" + System.currentTimeMillis()).getAbsoluteFile();
        }
        if (!this.workDir.mkdirs()) {
            this.addError(ErrorKey.UnableToCreateWorkingFolder, this.workDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractClassesAndPutAlongWithExpFile(File destination, File capFile, boolean lib) throws Exception {
        ZipFile zipFile = new ZipFile(capFile);
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            File entryFile;
            ZipEntry zipEntry = zipEntries.nextElement();
            String entryName = zipEntry.getName();
            boolean isDir = zipEntry.isDirectory();
            if (isDir || !entryName.endsWith(".class")) continue;
            if (!lib) {
                if (!entryName.startsWith("APPLET-INF/classes/")) continue;
                entryName = entryName.substring(19);
            }
            if (!(entryFile = new File(destination, entryName)).getParentFile().exists()) {
                entryFile.getParentFile().mkdirs();
            }
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(entryFile);
                int read = 0;
                byte[] buffer = new byte[1024];
                InputStream is = zipFile.getInputStream(zipEntry);
                while ((read = is.read(buffer, 0, 1024)) > 0) {
                    fos.write(buffer, 0, read);
                }
            }
            finally {
                if (fos == null) continue;
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
        zipFile.close();
    }

    private String findPackage(File folder) {
        return this.findPackageFromRoot(folder, folder);
    }

    private String findPackageFromRoot(File root, File current) {
        if (current.isFile()) {
            if (current.getName().endsWith(".class")) {
                String pname = current.getAbsoluteFile().getParentFile().getAbsolutePath();
                String rn = root.getAbsolutePath();
                return pname.substring(rn.length() + 1).replace(File.separatorChar, '.');
            }
            return null;
        }
        File[] fs = current.listFiles(new FileFilter(){

            @Override
            public boolean accept(File fx) {
                return fx.isDirectory() || fx.getName().endsWith(".class");
            }
        });
        if (fs != null) {
            for (File ff : fs) {
                String pn = this.findPackageFromRoot(root, ff);
                if (pn == null) continue;
                return pn;
            }
        }
        return null;
    }

    private void copyJavaFiles(File dir1, File dir2) throws Exception {
        try {
            dir1 = dir1.getCanonicalFile().getAbsoluteFile();
            dir2 = dir2.getCanonicalFile().getAbsoluteFile();
            String dirPath = dir1.getAbsolutePath();
            String path = null;
            Vector<File> javaFiles = FileUtils.listAllFilesInFolder(dir1, ".java");
            for (File jf : javaFiles) {
                jf = jf.getCanonicalFile().getAbsoluteFile();
                path = jf.getAbsolutePath();
                if ((path = path.substring(dirPath.length())).startsWith(File.separator)) {
                    path = path.substring(1);
                }
                FileUtils.copyFile(jf, new File(dir2, path));
            }
        }
        catch (Exception ex) {
            throw new Exception("Unable to keep java files. Error: " + ex.getMessage());
        }
    }
}

