/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.packager.model;

import com.sun.javacard.packager.ErrorKey;
import com.sun.javacard.packager.model.Module;
import com.sun.javacard.packager.model.PackageItem;
import java.io.File;
import java.io.FileInputStream;
import java.util.Hashtable;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public abstract class ModuleJCRD
extends PackageItem {
    protected Attributes attributes;
    protected Vector<String> jcrdKeyList = new Vector();
    protected static final String MAPPED_TO_CLIENT_URI = "-Mapped-To-Client-URI";
    protected static final String MAPPED_TO_DOMAIN_NAME = "-Mapped-To-Domain-Name";
    protected static final String MAPPED_TO_AUTH_CREDENTIAL = "-Mapped-To-Auth-Credential";
    protected static final String CLIENT_CREDENTIAL_AUTH_TYPE = "-Credential-Auth-Type";
    protected static final String CLIENT_CREDENTIAL_AUTH_DURATION = "-Credential-Auth-Duration";
    protected static final String MAPPED_TO_AUTH_URI = "-Mapped-To-Auth-URI";
    protected static final String[] CLIENT_MAPPING_ATTRIBUTES_LIST = new String[]{"-Mapped-To-Client-URI", "-Mapped-To-Domain-Name", "-Mapped-To-Auth-Credential", "-Credential-Auth-Type", "-Credential-Auth-Duration"};
    protected Module module;
    protected File file;
    protected Vector<String> oncardClientRoleList = new Vector();
    protected Vector<String> userRoleList = new Vector();
    protected String oncardClientsCredentialAuthType;
    protected String oncardClientsCredentialAuthDuration;
    protected Hashtable<String, Vector<String>> clientRoleMappedToClientURI = new Hashtable();
    protected Hashtable<String, Vector<String>> clientRoleMappedToDomainName = new Hashtable();
    protected Hashtable<String, Vector<String>> clientRoleMappedToAuthCredential = new Hashtable();
    protected Hashtable<String, String> clientRoleCredentialAuthType = new Hashtable();
    protected Hashtable<String, String> clientRoleCredentialAuthDuration = new Hashtable();
    protected Hashtable<String, Vector<String>> userRoleMappedToAuthURI = new Hashtable();
    protected String applicationType;
    private String runtimeDescriptorVersion;

    public ModuleJCRD(Module module, File file) {
        this.module = module;
        this.file = file;
    }

    @Override
    public void initialize() {
        Manifest manifest = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.file);
            manifest = new Manifest(fis);
            fis.close();
        }
        catch (Exception e) {
            this.addError(ErrorKey.UnableToParseManifestFile, new Object[0]);
            this.proceed = false;
            return;
        }
        this.attributes = manifest.getMainAttributes();
        Object[] manifestKeysObjArray = this.attributes.keySet().toArray();
        for (int i = 0; i < manifestKeysObjArray.length; ++i) {
            this.jcrdKeyList.add(manifestKeysObjArray[i].toString());
        }
    }

    @Override
    public void processInternal() {
    }

    @Override
    public String getItemDisplayName() {
        return "JCRD";
    }

    protected String getAttributeValue(String name) {
        return this.getAttributeValue(name, true);
    }

    protected String getAttributeValue(String name, boolean emptyAsNull) {
        String value = null;
        value = this.attributes.getValue(name);
        if (value != null) {
            value = value.trim();
            if (emptyAsNull && value.length() <= 0) {
                value = null;
            }
        }
        return value;
    }
}

