/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.util;

public class AIDUtils {
    private static final String aidAuthority = "//aid/";

    public static byte[] getAIDAsByteArray(String aid) {
        if (!aid.toUpperCase().startsWith(aidAuthority.toUpperCase())) {
            return null;
        }
        String aidSubStr = aid.substring(aidAuthority.length());
        int lastIndexofSlash = aidSubStr.lastIndexOf(47);
        String RID = aidSubStr.substring(0, lastIndexofSlash);
        String PIX = aidSubStr.substring(lastIndexofSlash + 1);
        if (PIX.equals("-")) {
            PIX = "";
        }
        byte[] aidArray = new byte[RID.length() / 2 + PIX.length() / 2];
        int offset = AIDUtils.getByteArrayForString(RID, aidArray, 0);
        AIDUtils.getByteArrayForString(PIX, aidArray, offset);
        return aidArray;
    }

    public static int getByteArrayForString(String number, byte[] outputArray, int offset) {
        int length = number.length();
        if (length % 2 != 0) {
            System.out.println("Invalid hexadecimal number  " + number);
            throw new NumberFormatException();
        }
        for (int startIndex = 0; startIndex < number.length(); startIndex += 2) {
            String smallNumber = number.substring(startIndex, startIndex + 2);
            outputArray[offset++] = (byte)Integer.parseInt(smallNumber, 16);
        }
        return offset;
    }

    public static String getAsPrintableHex(String uri) {
        byte[] input = AIDUtils.getAIDAsByteArray(uri);
        StringBuffer sb = new StringBuffer("0x");
        int noSignExtension = input[0] & 0xFF;
        if (noSignExtension < 16) {
            sb.append("0");
        }
        sb.append(Integer.toHexString(noSignExtension));
        for (int i = 1; i < input.length; ++i) {
            sb.append(":");
            sb.append("0x");
            noSignExtension = input[i] & 0xFF;
            if (noSignExtension < 16) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(noSignExtension));
        }
        return sb.toString();
    }
}

