/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.util;

import com.sun.javacard.util.FolderCrawler;
import com.sun.javacard.util.FolderCrawlerListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Vector;

public class FileUtils {
    public static Vector<File> listAllFilesInFolder(File folder, final String ext) {
        final Vector<File> list = new Vector<File>();
        FolderCrawler fc = new FolderCrawler(folder, new FolderCrawlerListener(){

            @Override
            public void fileFound(File file) {
                if (file.isFile() && (ext == null || file.getName().endsWith(ext))) {
                    list.addElement(file);
                }
            }
        });
        fc.crawl();
        return list;
    }

    public static Vector<File> listAllFoldersInFolder(File folder) {
        final Vector<File> list = new Vector<File>();
        FolderCrawler fc = new FolderCrawler(folder, new FolderCrawlerListener(){

            @Override
            public void fileFound(File file) {
                if (file.isDirectory()) {
                    list.addElement(file);
                }
            }
        });
        fc.crawl();
        return list;
    }

    public static boolean deleteDir(File dir) {
        if (!dir.exists()) {
            return false;
        }
        boolean deleted = true;
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                deleted = file.isDirectory() ? deleted && FileUtils.deleteDir(file) : deleted && file.delete();
            }
        }
        deleted = deleted && dir.delete();
        return deleted;
    }

    public static void copyDir(File srcDir, File destDir) throws Exception {
        if (!srcDir.exists()) {
            throw new Exception("Source dir " + srcDir + " does not exists.");
        }
        if (srcDir.isFile()) {
            throw new Exception("Source " + srcDir + " is not a drectory.");
        }
        if (destDir.exists() && !destDir.isDirectory()) {
            throw new Exception("Destination " + destDir + " exists. And, it is a file.");
        }
        destDir.mkdirs();
        File[] files = srcDir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isFile()) {
                    FileUtils.copyFile(file, new File(destDir, file.getName()));
                    continue;
                }
                FileUtils.copyDir(file, new File(destDir, file.getName()));
            }
        }
    }

    public static void copyFile(File srcFile, File destFileOrDir) throws Exception {
        if (srcFile.isDirectory()) {
            throw new Exception("Source is not a file");
        }
        if (destFileOrDir.exists() && destFileOrDir.isDirectory()) {
            destFileOrDir = new File(destFileOrDir, srcFile.getName());
        }
        destFileOrDir.getParentFile().mkdirs();
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(srcFile);
            fos = new FileOutputStream(destFileOrDir);
            byte[] buf = new byte[1024];
            int read = 0;
            while ((read = fis.read(buf)) > 0) {
                fos.write(buf, 0, read);
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

