// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 11.1.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2025 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "PFCP_Types.hh"

namespace PFCP__Types {

/* Member functions of C++ classes */

Ethernet__Packet__Filter::Ethernet__Packet__Filter()
{
}

Ethernet__Packet__Filter::Ethernet__Packet__Filter(const INTEGER& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const Ethernet__Packet__Filter_grouped__ie& par_grouped__ie)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_grouped__ie(par_grouped__ie)
{
}

Ethernet__Packet__Filter::Ethernet__Packet__Filter(const Ethernet__Packet__Filter& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @PFCP_Types.Ethernet_Packet_Filter.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.grouped__ie().is_bound()) field_grouped__ie = other_value.grouped__ie();
else field_grouped__ie.clean_up();
}

void Ethernet__Packet__Filter::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_grouped__ie.clean_up();
}

const TTCN_Typedescriptor_t* Ethernet__Packet__Filter::get_descriptor() const { return &Ethernet__Packet__Filter_descr_; }
Ethernet__Packet__Filter& Ethernet__Packet__Filter::operator=(const Ethernet__Packet__Filter& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @PFCP_Types.Ethernet_Packet_Filter.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.grouped__ie().is_bound()) field_grouped__ie = other_value.grouped__ie();
  else field_grouped__ie.clean_up();
}
return *this;
}

boolean Ethernet__Packet__Filter::operator==(const Ethernet__Packet__Filter& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_grouped__ie==other_value.field_grouped__ie;
}

boolean Ethernet__Packet__Filter::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_grouped__ie.is_bound());
}
boolean Ethernet__Packet__Filter::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_grouped__ie.is_value();
}
void Ethernet__Packet__Filter::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", grouped_ie := ");
field_grouped__ie.log();
TTCN_Logger::log_event_str(" }");
}

void Ethernet__Packet__Filter::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (grouped__ie().is_bound()) grouped__ie().set_implicit_omit();
}

void Ethernet__Packet__Filter::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @PFCP_Types.Ethernet_Packet_Filter has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) grouped__ie().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "grouped_ie")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          grouped__ie().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @PFCP_Types.Ethernet_Packet_Filter: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@PFCP_Types.Ethernet_Packet_Filter");
  }
}

void Ethernet__Packet__Filter::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_grouped__ie.encode_text(text_buf);
}

void Ethernet__Packet__Filter::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_grouped__ie.decode_text(text_buf);
}

void Ethernet__Packet__Filter::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Ethernet__Packet__Filter::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int Ethernet__Packet__Filter::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::LIN2__BO__LAST_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::LIN2__BO__LAST_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, Ethernet__Packet__Filter_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(Ethernet__Packet__Filter_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(Ethernet__Packet__Filter_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, Ethernet__Packet__Filter_grouped__ie_descr_.raw->forceomit);
  decoded_field_length = field_grouped__ie.RAW_decode(Ethernet__Packet__Filter_grouped__ie_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_elementIdentifier != 132) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int Ethernet__Packet__Filter::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::LIN2__BO__LAST_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, Ethernet__Packet__Filter_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, Ethernet__Packet__Filter_grouped__ie_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::LIN2__BO__LAST_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 16;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &Ethernet__Packet__Filter_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[1]->length = 16;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_grouped__ie.RAW_encode(Ethernet__Packet__Filter_grouped__ie_descr_, *myleaf.body.node.nodes[2]);
  if (field_elementIdentifier != 132) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
  INTEGER new_val = 132;
  new_val.RAW_encode(General__Types::LIN2__BO__LAST_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct Ethernet__Packet__Filter_template::single_value_struct {
INTEGER_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
Ethernet__Packet__Filter_grouped__ie_template field_grouped__ie;
};

void Ethernet__Packet__Filter_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_grouped__ie = ANY_VALUE;
}
}
}

void Ethernet__Packet__Filter_template::copy_value(const Ethernet__Packet__Filter& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.grouped__ie().is_bound()) {
  single_value->field_grouped__ie = other_value.grouped__ie();
} else {
  single_value->field_grouped__ie.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void Ethernet__Packet__Filter_template::copy_template(const Ethernet__Packet__Filter_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.grouped__ie().get_selection()) {
single_value->field_grouped__ie = other_value.grouped__ie();
} else {
single_value->field_grouped__ie.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Ethernet__Packet__Filter_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Ethernet__Packet__Filter_template(*other_value.implication_.precondition);
implication_.implied_template = new Ethernet__Packet__Filter_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @PFCP_Types.Ethernet_Packet_Filter.");
break;
}
set_selection(other_value);
}

Ethernet__Packet__Filter_template::Ethernet__Packet__Filter_template()
{
}

Ethernet__Packet__Filter_template::Ethernet__Packet__Filter_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

Ethernet__Packet__Filter_template::Ethernet__Packet__Filter_template(const Ethernet__Packet__Filter& other_value)
{
copy_value(other_value);
}

Ethernet__Packet__Filter_template::Ethernet__Packet__Filter_template(const OPTIONAL<Ethernet__Packet__Filter>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Ethernet__Packet__Filter&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @PFCP_Types.Ethernet_Packet_Filter from an unbound optional field.");
}
}

Ethernet__Packet__Filter_template::Ethernet__Packet__Filter_template(Ethernet__Packet__Filter_template* p_precondition, Ethernet__Packet__Filter_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

Ethernet__Packet__Filter_template::Ethernet__Packet__Filter_template(Dynamic_Match_Interface<Ethernet__Packet__Filter>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<Ethernet__Packet__Filter>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

Ethernet__Packet__Filter_template::Ethernet__Packet__Filter_template(const Ethernet__Packet__Filter_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

Ethernet__Packet__Filter_template::~Ethernet__Packet__Filter_template()
{
clean_up();
}

Ethernet__Packet__Filter_template& Ethernet__Packet__Filter_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

Ethernet__Packet__Filter_template& Ethernet__Packet__Filter_template::operator=(const Ethernet__Packet__Filter& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

Ethernet__Packet__Filter_template& Ethernet__Packet__Filter_template::operator=(const OPTIONAL<Ethernet__Packet__Filter>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Ethernet__Packet__Filter&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @PFCP_Types.Ethernet_Packet_Filter.");
}
return *this;
}

Ethernet__Packet__Filter_template& Ethernet__Packet__Filter_template::operator=(const Ethernet__Packet__Filter_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean Ethernet__Packet__Filter_template::match(const Ethernet__Packet__Filter& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.grouped__ie().is_bound()) return FALSE;
if(!single_value->field_grouped__ie.match(other_value.grouped__ie(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @PFCP_Types.Ethernet_Packet_Filter.");
}
return FALSE;
}

boolean Ethernet__Packet__Filter_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_grouped__ie.is_bound();
}

boolean Ethernet__Packet__Filter_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_grouped__ie.is_value();
}

void Ethernet__Packet__Filter_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

Ethernet__Packet__Filter Ethernet__Packet__Filter_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @PFCP_Types.Ethernet_Packet_Filter.");
Ethernet__Packet__Filter ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_grouped__ie.is_bound()) {
ret_val.grouped__ie() = single_value->field_grouped__ie.valueof();
}
return ret_val;
}

void Ethernet__Packet__Filter_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @PFCP_Types.Ethernet_Packet_Filter.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new Ethernet__Packet__Filter_template[list_length];
}

Ethernet__Packet__Filter_template& Ethernet__Packet__Filter_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @PFCP_Types.Ethernet_Packet_Filter.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @PFCP_Types.Ethernet_Packet_Filter.");
return value_list.list_value[list_index];
}

INTEGER_template& Ethernet__Packet__Filter_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const INTEGER_template& Ethernet__Packet__Filter_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @PFCP_Types.Ethernet_Packet_Filter.");
return single_value->field_elementIdentifier;
}

INTEGER_template& Ethernet__Packet__Filter_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& Ethernet__Packet__Filter_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @PFCP_Types.Ethernet_Packet_Filter.");
return single_value->field_lengthIndicator;
}

Ethernet__Packet__Filter_grouped__ie_template& Ethernet__Packet__Filter_template::grouped__ie()
{
set_specific();
return single_value->field_grouped__ie;
}

const Ethernet__Packet__Filter_grouped__ie_template& Ethernet__Packet__Filter_template::grouped__ie() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field grouped_ie of a non-specific template of type @PFCP_Types.Ethernet_Packet_Filter.");
return single_value->field_grouped__ie;
}

int Ethernet__Packet__Filter_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Ethernet_Packet_Filter which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @PFCP_Types.Ethernet_Packet_Filter containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Ethernet_Packet_Filter containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Ethernet_Packet_Filter containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Ethernet_Packet_Filter containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Ethernet_Packet_Filter containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Ethernet_Packet_Filter containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Ethernet_Packet_Filter containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Ethernet_Packet_Filter containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @PFCP_Types.Ethernet_Packet_Filter.");
  }
  return 0;
}

void Ethernet__Packet__Filter_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", grouped_ie := ");
single_value->field_grouped__ie.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void Ethernet__Packet__Filter_template::log_match(const Ethernet__Packet__Filter& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_grouped__ie.match(match_value.grouped__ie(), legacy)){
TTCN_Logger::log_logmatch_info(".grouped_ie");
single_value->field_grouped__ie.log_match(match_value.grouped__ie(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", grouped_ie := ");
single_value->field_grouped__ie.log_match(match_value.grouped__ie(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void Ethernet__Packet__Filter_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (grouped__ie().is_bound()) grouped__ie().set_implicit_omit();
}

void Ethernet__Packet__Filter_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_grouped__ie.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @PFCP_Types.Ethernet_Packet_Filter.");
}
}

void Ethernet__Packet__Filter_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_grouped__ie.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new Ethernet__Packet__Filter_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @PFCP_Types.Ethernet_Packet_Filter.");
}
}

void Ethernet__Packet__Filter_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    Ethernet__Packet__Filter_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @PFCP_Types.Ethernet_Packet_Filter has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) grouped__ie().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "grouped_ie")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          grouped__ie().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @PFCP_Types.Ethernet_Packet_Filter: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    Ethernet__Packet__Filter_template* precondition = new Ethernet__Packet__Filter_template;
    precondition->set_param(*param.get_elem(0));
    Ethernet__Packet__Filter_template* implied_template = new Ethernet__Packet__Filter_template;
    implied_template->set_param(*param.get_elem(1));
    *this = Ethernet__Packet__Filter_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@PFCP_Types.Ethernet_Packet_Filter");
  }
  is_ifpresent = param.get_ifpresent();
}

void Ethernet__Packet__Filter_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Ethernet_Packet_Filter");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Ethernet_Packet_Filter");
single_value->field_grouped__ie.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Ethernet_Packet_Filter");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@PFCP_Types.Ethernet_Packet_Filter");
}

boolean Ethernet__Packet__Filter_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean Ethernet__Packet__Filter_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const QFI PDI__IE_grouped__ie_qfi__list::UNBOUND_ELEM;
PDI__IE_grouped__ie_qfi__list::PDI__IE_grouped__ie_qfi__list()
{
val_ptr = NULL;
}

PDI__IE_grouped__ie_qfi__list::PDI__IE_grouped__ie_qfi__list(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

PDI__IE_grouped__ie_qfi__list::PDI__IE_grouped__ie_qfi__list(const PDI__IE_grouped__ie_qfi__list& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

PDI__IE_grouped__ie_qfi__list::~PDI__IE_grouped__ie_qfi__list()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void PDI__IE_grouped__ie_qfi__list::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

PDI__IE_grouped__ie_qfi__list& PDI__IE_grouped__ie_qfi__list::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

PDI__IE_grouped__ie_qfi__list& PDI__IE_grouped__ie_qfi__list::operator=(const PDI__IE_grouped__ie_qfi__list& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean PDI__IE_grouped__ie_qfi__list::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list.");
return val_ptr->n_elements == 0 ;
}

boolean PDI__IE_grouped__ie_qfi__list::operator==(const PDI__IE_grouped__ie_qfi__list& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

QFI& PDI__IE_grouped__ie_qfi__list::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (QFI**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new QFI(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new QFI;
}
return *val_ptr->value_elements[index_value];
}

QFI& PDI__IE_grouped__ie_qfi__list::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list.");
return (*this)[(int)index_value];
}

const QFI& PDI__IE_grouped__ie_qfi__list::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list.");
if (index_value < 0) TTCN_error("Accessing an element of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const QFI& PDI__IE_grouped__ie_qfi__list::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list.");
return (*this)[(int)index_value];
}

PDI__IE_grouped__ie_qfi__list PDI__IE_grouped__ie_qfi__list::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

PDI__IE_grouped__ie_qfi__list PDI__IE_grouped__ie_qfi__list::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

PDI__IE_grouped__ie_qfi__list PDI__IE_grouped__ie_qfi__list::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

PDI__IE_grouped__ie_qfi__list PDI__IE_grouped__ie_qfi__list::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
PDI__IE_grouped__ie_qfi__list ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new QFI(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

PDI__IE_grouped__ie_qfi__list PDI__IE_grouped__ie_qfi__list::operator+(const PDI__IE_grouped__ie_qfi__list& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @PFCP_Types.PDI_IE.grouped_ie.qfi_list concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
PDI__IE_grouped__ie_qfi__list ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new QFI(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new QFI(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

PDI__IE_grouped__ie_qfi__list PDI__IE_grouped__ie_qfi__list::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@PFCP_Types.PDI_IE.grouped_ie.qfi_list","element");
PDI__IE_grouped__ie_qfi__list ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new QFI(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

PDI__IE_grouped__ie_qfi__list PDI__IE_grouped__ie_qfi__list::replace(int index, int len, const PDI__IE_grouped__ie_qfi__list& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list.");
check_replace_arguments(val_ptr->n_elements, index, len, "@PFCP_Types.PDI_IE.grouped_ie.qfi_list","element");
PDI__IE_grouped__ie_qfi__list ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new QFI(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new QFI(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new QFI(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

PDI__IE_grouped__ie_qfi__list PDI__IE_grouped__ie_qfi__list::replace(int index, int len, const PDI__IE_grouped__ie_qfi__list_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void PDI__IE_grouped__ie_qfi__list::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (QFI**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new QFI(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (QFI**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (QFI**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean PDI__IE_grouped__ie_qfi__list::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int PDI__IE_grouped__ie_qfi__list::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list.");
return val_ptr->n_elements;
}

int PDI__IE_grouped__ie_qfi__list::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void PDI__IE_grouped__ie_qfi__list::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void PDI__IE_grouped__ie_qfi__list::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void PDI__IE_grouped__ie_qfi__list::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@PFCP_Types.PDI_IE.grouped_ie.qfi_list");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@PFCP_Types.PDI_IE.grouped_ie.qfi_list");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void PDI__IE_grouped__ie_qfi__list::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void PDI__IE_grouped__ie_qfi__list::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list.");
val_ptr->value_elements = (QFI**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new QFI;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void PDI__IE_grouped__ie_qfi__list::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDI__IE_grouped__ie_qfi__list::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDI__IE_grouped__ie_qfi__list::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean /*no_err*/, int sel_field, boolean first_call, const RAW_Force_Omit*){
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int decoded_field_length=0;
  size_t start_of_field=0;
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int start_field=val_ptr->n_elements;
  if(p_td.raw->fieldlength || sel_field!=-1){
    int a=0;
    if(sel_field==-1) sel_field=p_td.raw->fieldlength;
    start_of_field=p_buf.get_pos_bit();
    for(a=0;a<sel_field;a++){
      decoded_field_length=(*this)[a+start_field].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        while(a>=0){
          delete &(*this)[a+start_field];
          a--;
          val_ptr->n_elements--;
        }
        p_buf.set_pos_bit(start_of_field);
        return decoded_field_length;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
    }
    if(a==0) val_ptr->n_elements=0;
  } else {
    if(limit==0){
      if(!first_call) return -1;
      val_ptr->n_elements=0;
      return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
    }
    int a=start_field;
    while(limit>0){
      start_of_field=p_buf.get_pos_bit();
      decoded_field_length=(*this)[a].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        delete &(*this)[a];
        val_ptr->n_elements--;
        p_buf.set_pos_bit(start_of_field);
        if(a>start_field){
        return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
        } else return -1;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
      a++;
    }
  }
 return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
}

int PDI__IE_grouped__ie_qfi__list::RAW_encode(const TTCN_Typedescriptor_t& p_td,RAW_enc_tree& myleaf) const{
  int encoded_length=0;
  int encoded_num_of_records=p_td.raw->fieldlength?smaller(val_ptr->n_elements, p_td.raw->fieldlength):val_ptr->n_elements;
  myleaf.isleaf=FALSE;
  myleaf.rec_of=TRUE;
  myleaf.body.node.num_of_nodes=encoded_num_of_records;
  myleaf.body.node.nodes=init_nodes_of_enc_tree(encoded_num_of_records);
  for(int a=0;a<encoded_num_of_records;a++){
    myleaf.body.node.nodes[a]=new RAW_enc_tree(TRUE,&myleaf,&(myleaf.curr_pos),a,p_td.oftype_descr->raw);
    encoded_length+=(*this)[a].RAW_encode(*p_td.oftype_descr,*myleaf.body.node.nodes[a]);
  }
 return myleaf.length=encoded_length;
}

void PDI__IE_grouped__ie_qfi__list_template::copy_value(const PDI__IE_grouped__ie_qfi__list& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (QFI_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new QFI_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new QFI_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void PDI__IE_grouped__ie_qfi__list_template::copy_template(const PDI__IE_grouped__ie_qfi__list_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (QFI_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new QFI_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new QFI_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDI__IE_grouped__ie_qfi__list_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDI__IE_grouped__ie_qfi__list_template(*other_value.implication_.precondition);
implication_.implied_template = new PDI__IE_grouped__ie_qfi__list_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list.");
break;
}
set_selection(other_value);
}

boolean PDI__IE_grouped__ie_qfi__list_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const PDI__IE_grouped__ie_qfi__list_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const PDI__IE_grouped__ie_qfi__list*)value_ptr)[value_index], legacy);
else return ((const PDI__IE_grouped__ie_qfi__list_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

PDI__IE_grouped__ie_qfi__list_template::PDI__IE_grouped__ie_qfi__list_template()
{
}

PDI__IE_grouped__ie_qfi__list_template::PDI__IE_grouped__ie_qfi__list_template(template_sel other_value)
 : Base_Record_Of_Template(other_value)
{
check_single_selection(other_value);
}

PDI__IE_grouped__ie_qfi__list_template::PDI__IE_grouped__ie_qfi__list_template(null_type)
 : Base_Record_Of_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

PDI__IE_grouped__ie_qfi__list_template::PDI__IE_grouped__ie_qfi__list_template(const PDI__IE_grouped__ie_qfi__list& other_value)
{
copy_value(other_value);
}

PDI__IE_grouped__ie_qfi__list_template::PDI__IE_grouped__ie_qfi__list_template(const OPTIONAL<PDI__IE_grouped__ie_qfi__list>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDI__IE_grouped__ie_qfi__list&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list from an unbound optional field.");
}
}

PDI__IE_grouped__ie_qfi__list_template::PDI__IE_grouped__ie_qfi__list_template(PDI__IE_grouped__ie_qfi__list_template* p_precondition, PDI__IE_grouped__ie_qfi__list_template* p_implied_template)
 : Base_Record_Of_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDI__IE_grouped__ie_qfi__list_template::PDI__IE_grouped__ie_qfi__list_template(Dynamic_Match_Interface<PDI__IE_grouped__ie_qfi__list>* p_dyn_match)
 : Base_Record_Of_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDI__IE_grouped__ie_qfi__list>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDI__IE_grouped__ie_qfi__list_template::PDI__IE_grouped__ie_qfi__list_template(const PDI__IE_grouped__ie_qfi__list_template& other_value)
 : Base_Record_Of_Template()
{
copy_template(other_value);
}

PDI__IE_grouped__ie_qfi__list_template::~PDI__IE_grouped__ie_qfi__list_template()
{
clean_up();
}

void PDI__IE_grouped__ie_qfi__list_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDI__IE_grouped__ie_qfi__list_template& PDI__IE_grouped__ie_qfi__list_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDI__IE_grouped__ie_qfi__list_template& PDI__IE_grouped__ie_qfi__list_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

PDI__IE_grouped__ie_qfi__list_template& PDI__IE_grouped__ie_qfi__list_template::operator=(const PDI__IE_grouped__ie_qfi__list& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDI__IE_grouped__ie_qfi__list_template& PDI__IE_grouped__ie_qfi__list_template::operator=(const OPTIONAL<PDI__IE_grouped__ie_qfi__list>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDI__IE_grouped__ie_qfi__list&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list.");
}
return *this;
}

PDI__IE_grouped__ie_qfi__list_template& PDI__IE_grouped__ie_qfi__list_template::operator=(const PDI__IE_grouped__ie_qfi__list_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

QFI_template& PDI__IE_grouped__ie_qfi__list_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @PFCP_Types.PDI_IE.grouped_ie.qfi_list using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @PFCP_Types.PDI_IE.grouped_ie.qfi_list.");
    break;
}
return *single_value.value_elements[index_value];
}

QFI_template& PDI__IE_grouped__ie_qfi__list_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list.");
return (*this)[(int)index_value];
}

const QFI_template& PDI__IE_grouped__ie_qfi__list_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @PFCP_Types.PDI_IE.grouped_ie.qfi_list using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @PFCP_Types.PDI_IE.grouped_ie.qfi_list.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const QFI_template& PDI__IE_grouped__ie_qfi__list_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list.");
return (*this)[(int)index_value];
}

void PDI__IE_grouped__ie_qfi__list_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (QFI_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new QFI_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new QFI_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (QFI_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int PDI__IE_grouped__ie_qfi__list_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int PDI__IE_grouped__ie_qfi__list_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list");
}

boolean PDI__IE_grouped__ie_qfi__list_template::match(const PDI__IE_grouped__ie_qfi__list& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_record_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list.");
}
return FALSE;
}

boolean PDI__IE_grouped__ie_qfi__list_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

PDI__IE_grouped__ie_qfi__list PDI__IE_grouped__ie_qfi__list_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list.");
PDI__IE_grouped__ie_qfi__list ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

PDI__IE_grouped__ie_qfi__list PDI__IE_grouped__ie_qfi__list_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

PDI__IE_grouped__ie_qfi__list PDI__IE_grouped__ie_qfi__list_template::replace(int index, int len, const PDI__IE_grouped__ie_qfi__list_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

PDI__IE_grouped__ie_qfi__list PDI__IE_grouped__ie_qfi__list_template::replace(int index, int len, const PDI__IE_grouped__ie_qfi__list& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void PDI__IE_grouped__ie_qfi__list_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new PDI__IE_grouped__ie_qfi__list_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list.");
}
set_selection(template_type);
}

PDI__IE_grouped__ie_qfi__list_template& PDI__IE_grouped__ie_qfi__list_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list.");
return value_list.list_value[list_index];
}

void PDI__IE_grouped__ie_qfi__list_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
if (permutation_starts_at(elem_count)) TTCN_Logger::log_event_str("permutation(");
single_value.value_elements[elem_count]->log();
if (permutation_ends_at(elem_count)) TTCN_Logger::log_char(')');
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void PDI__IE_grouped__ie_qfi__list_template::log_match(const PDI__IE_grouped__ie_qfi__list& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if(!single_value.value_elements[elem_count]->match(match_value[elem_count], legacy)){
TTCN_Logger::log_logmatch_info("[%d]", elem_count);
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
log_match_length(single_value.n_elements);
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
}
TTCN_Logger::log_event_str(" }");
log_match_length(single_value.n_elements);
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDI__IE_grouped__ie_qfi__list_template::encode_text(Text_Buf& text_buf) const
{
encode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list.");
}
}

void PDI__IE_grouped__ie_qfi__list_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list.");
single_value.value_elements = (QFI_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new QFI_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDI__IE_grouped__ie_qfi__list_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @PFCP_Types.PDI_IE.grouped_ie.qfi_list.");
}
}

boolean PDI__IE_grouped__ie_qfi__list_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDI__IE_grouped__ie_qfi__list_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void PDI__IE_grouped__ie_qfi__list_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void PDI__IE_grouped__ie_qfi__list_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "record of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDI__IE_grouped__ie_qfi__list_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List: {
    set_size(param.get_size());
    int curr_idx = 0;
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      switch (param.get_elem(p_i)->get_type()) {
      case Module_Param::MP_NotUsed:
        curr_idx++;
        break;
      case Module_Param::MP_Permutation_Template: {
        int perm_start_idx = curr_idx;
        Module_Param* param_i = param.get_elem(p_i);
        for (size_t perm_i=0; perm_i<param_i->get_size(); perm_i++) {
          (*this)[curr_idx].set_param(*(param_i->get_elem(perm_i)));
          curr_idx++;
        }
        int perm_end_idx = curr_idx - 1;
        add_permutation(perm_start_idx, perm_end_idx);
      } break;
      default:
        (*this)[curr_idx].set_param(*param.get_elem(p_i));
        curr_idx++;
      }
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDI__IE_grouped__ie_qfi__list_template* precondition = new PDI__IE_grouped__ie_qfi__list_template;
    precondition->set_param(*param.get_elem(0));
    PDI__IE_grouped__ie_qfi__list_template* implied_template = new PDI__IE_grouped__ie_qfi__list_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDI__IE_grouped__ie_qfi__list_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record of template", "@PFCP_Types.PDI_IE.grouped_ie.qfi_list");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void PDI__IE_grouped__ie_qfi__list_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@PFCP_Types.PDI_IE.grouped_ie.qfi_list");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@PFCP_Types.PDI_IE.grouped_ie.qfi_list");
}

boolean PDI__IE_grouped__ie_qfi__list_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return number_of_permutations;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
PDI__IE::PDI__IE()
{
}

PDI__IE::PDI__IE(const INTEGER& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const PDI__IE_grouped__ie& par_grouped__ie)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_grouped__ie(par_grouped__ie)
{
}

PDI__IE::PDI__IE(const PDI__IE& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @PFCP_Types.PDI_IE.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.grouped__ie().is_bound()) field_grouped__ie = other_value.grouped__ie();
else field_grouped__ie.clean_up();
}

void PDI__IE::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_grouped__ie.clean_up();
}

const TTCN_Typedescriptor_t* PDI__IE::get_descriptor() const { return &PDI__IE_descr_; }
PDI__IE& PDI__IE::operator=(const PDI__IE& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @PFCP_Types.PDI_IE.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.grouped__ie().is_bound()) field_grouped__ie = other_value.grouped__ie();
  else field_grouped__ie.clean_up();
}
return *this;
}

boolean PDI__IE::operator==(const PDI__IE& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_grouped__ie==other_value.field_grouped__ie;
}

boolean PDI__IE::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_grouped__ie.is_bound());
}
boolean PDI__IE::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_grouped__ie.is_value();
}
void PDI__IE::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", grouped_ie := ");
field_grouped__ie.log();
TTCN_Logger::log_event_str(" }");
}

void PDI__IE::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (grouped__ie().is_bound()) grouped__ie().set_implicit_omit();
}

void PDI__IE::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @PFCP_Types.PDI_IE has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) grouped__ie().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "grouped_ie")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          grouped__ie().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @PFCP_Types.PDI_IE: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@PFCP_Types.PDI_IE");
  }
}

void PDI__IE::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_grouped__ie.encode_text(text_buf);
}

void PDI__IE::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_grouped__ie.decode_text(text_buf);
}

void PDI__IE::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDI__IE::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDI__IE::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::LIN2__BO__LAST_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::LIN2__BO__LAST_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, PDI__IE_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(PDI__IE_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(PDI__IE_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, PDI__IE_grouped__ie_descr_.raw->forceomit);
  decoded_field_length = field_grouped__ie.RAW_decode(PDI__IE_grouped__ie_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_elementIdentifier != 2) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDI__IE::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::LIN2__BO__LAST_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, PDI__IE_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, PDI__IE_grouped__ie_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::LIN2__BO__LAST_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 16;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &PDI__IE_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[1]->length = 16;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_grouped__ie.RAW_encode(PDI__IE_grouped__ie_descr_, *myleaf.body.node.nodes[2]);
  if (field_elementIdentifier != 2) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
  INTEGER new_val = 2;
  new_val.RAW_encode(General__Types::LIN2__BO__LAST_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDI__IE_template::single_value_struct {
INTEGER_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
PDI__IE_grouped__ie_template field_grouped__ie;
};

void PDI__IE_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_grouped__ie = ANY_VALUE;
}
}
}

void PDI__IE_template::copy_value(const PDI__IE& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.grouped__ie().is_bound()) {
  single_value->field_grouped__ie = other_value.grouped__ie();
} else {
  single_value->field_grouped__ie.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDI__IE_template::copy_template(const PDI__IE_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.grouped__ie().get_selection()) {
single_value->field_grouped__ie = other_value.grouped__ie();
} else {
single_value->field_grouped__ie.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDI__IE_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDI__IE_template(*other_value.implication_.precondition);
implication_.implied_template = new PDI__IE_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @PFCP_Types.PDI_IE.");
break;
}
set_selection(other_value);
}

PDI__IE_template::PDI__IE_template()
{
}

PDI__IE_template::PDI__IE_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDI__IE_template::PDI__IE_template(const PDI__IE& other_value)
{
copy_value(other_value);
}

PDI__IE_template::PDI__IE_template(const OPTIONAL<PDI__IE>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDI__IE&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @PFCP_Types.PDI_IE from an unbound optional field.");
}
}

PDI__IE_template::PDI__IE_template(PDI__IE_template* p_precondition, PDI__IE_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDI__IE_template::PDI__IE_template(Dynamic_Match_Interface<PDI__IE>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDI__IE>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDI__IE_template::PDI__IE_template(const PDI__IE_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDI__IE_template::~PDI__IE_template()
{
clean_up();
}

PDI__IE_template& PDI__IE_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDI__IE_template& PDI__IE_template::operator=(const PDI__IE& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDI__IE_template& PDI__IE_template::operator=(const OPTIONAL<PDI__IE>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDI__IE&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @PFCP_Types.PDI_IE.");
}
return *this;
}

PDI__IE_template& PDI__IE_template::operator=(const PDI__IE_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDI__IE_template::match(const PDI__IE& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.grouped__ie().is_bound()) return FALSE;
if(!single_value->field_grouped__ie.match(other_value.grouped__ie(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @PFCP_Types.PDI_IE.");
}
return FALSE;
}

boolean PDI__IE_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_grouped__ie.is_bound();
}

boolean PDI__IE_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_grouped__ie.is_value();
}

void PDI__IE_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDI__IE PDI__IE_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @PFCP_Types.PDI_IE.");
PDI__IE ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_grouped__ie.is_bound()) {
ret_val.grouped__ie() = single_value->field_grouped__ie.valueof();
}
return ret_val;
}

void PDI__IE_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @PFCP_Types.PDI_IE.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDI__IE_template[list_length];
}

PDI__IE_template& PDI__IE_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @PFCP_Types.PDI_IE.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @PFCP_Types.PDI_IE.");
return value_list.list_value[list_index];
}

INTEGER_template& PDI__IE_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const INTEGER_template& PDI__IE_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @PFCP_Types.PDI_IE.");
return single_value->field_elementIdentifier;
}

INTEGER_template& PDI__IE_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& PDI__IE_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @PFCP_Types.PDI_IE.");
return single_value->field_lengthIndicator;
}

PDI__IE_grouped__ie_template& PDI__IE_template::grouped__ie()
{
set_specific();
return single_value->field_grouped__ie;
}

const PDI__IE_grouped__ie_template& PDI__IE_template::grouped__ie() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field grouped_ie of a non-specific template of type @PFCP_Types.PDI_IE.");
return single_value->field_grouped__ie;
}

int PDI__IE_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.PDI_IE which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @PFCP_Types.PDI_IE containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.PDI_IE containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.PDI_IE containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.PDI_IE containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.PDI_IE containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.PDI_IE containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.PDI_IE containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.PDI_IE containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @PFCP_Types.PDI_IE.");
  }
  return 0;
}

void PDI__IE_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", grouped_ie := ");
single_value->field_grouped__ie.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDI__IE_template::log_match(const PDI__IE& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_grouped__ie.match(match_value.grouped__ie(), legacy)){
TTCN_Logger::log_logmatch_info(".grouped_ie");
single_value->field_grouped__ie.log_match(match_value.grouped__ie(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", grouped_ie := ");
single_value->field_grouped__ie.log_match(match_value.grouped__ie(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDI__IE_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (grouped__ie().is_bound()) grouped__ie().set_implicit_omit();
}

void PDI__IE_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_grouped__ie.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @PFCP_Types.PDI_IE.");
}
}

void PDI__IE_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_grouped__ie.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDI__IE_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @PFCP_Types.PDI_IE.");
}
}

void PDI__IE_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDI__IE_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @PFCP_Types.PDI_IE has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) grouped__ie().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "grouped_ie")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          grouped__ie().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @PFCP_Types.PDI_IE: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDI__IE_template* precondition = new PDI__IE_template;
    precondition->set_param(*param.get_elem(0));
    PDI__IE_template* implied_template = new PDI__IE_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDI__IE_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@PFCP_Types.PDI_IE");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDI__IE_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.PDI_IE");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.PDI_IE");
single_value->field_grouped__ie.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.PDI_IE");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@PFCP_Types.PDI_IE");
}

boolean PDI__IE_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDI__IE_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

Create__PDR_grouped__ie::Create__PDR_grouped__ie()
{
}

Create__PDR_grouped__ie::Create__PDR_grouped__ie(const PDR__ID& par_pdr__id,
    const OPTIONAL< Precedence >& par_precedence,
    const PDI__IE& par_pdi,
    const OPTIONAL< Outer__Header__Removal >& par_outer__header__removal,
    const OPTIONAL< Create__PDR_grouped__ie_FAR__ID__list >& par_FAR__ID__list,
    const OPTIONAL< URR__ID__list >& par_uRR__ID__list,
    const OPTIONAL< QER__ID__list >& par_qER__ID__list,
    const OPTIONAL< Activate__Predefined__Rules >& par_activate__predefined__rules)
  :   field_pdr__id(par_pdr__id),
  field_precedence(par_precedence),
  field_pdi(par_pdi),
  field_outer__header__removal(par_outer__header__removal),
  field_FAR__ID__list(par_FAR__ID__list),
  field_uRR__ID__list(par_uRR__ID__list),
  field_qER__ID__list(par_qER__ID__list),
  field_activate__predefined__rules(par_activate__predefined__rules)
{
}

Create__PDR_grouped__ie::Create__PDR_grouped__ie(const Create__PDR_grouped__ie& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @PFCP_Types.Create_PDR.grouped_ie.");
if (other_value.pdr__id().is_bound()) field_pdr__id = other_value.pdr__id();
else field_pdr__id.clean_up();
if (other_value.precedence().is_bound()) field_precedence = other_value.precedence();
else field_precedence.clean_up();
if (other_value.pdi().is_bound()) field_pdi = other_value.pdi();
else field_pdi.clean_up();
if (other_value.outer__header__removal().is_bound()) field_outer__header__removal = other_value.outer__header__removal();
else field_outer__header__removal.clean_up();
if (other_value.FAR__ID__list().is_bound()) field_FAR__ID__list = other_value.FAR__ID__list();
else field_FAR__ID__list.clean_up();
if (other_value.uRR__ID__list().is_bound()) field_uRR__ID__list = other_value.uRR__ID__list();
else field_uRR__ID__list.clean_up();
if (other_value.qER__ID__list().is_bound()) field_qER__ID__list = other_value.qER__ID__list();
else field_qER__ID__list.clean_up();
if (other_value.activate__predefined__rules().is_bound()) field_activate__predefined__rules = other_value.activate__predefined__rules();
else field_activate__predefined__rules.clean_up();
}

void Create__PDR_grouped__ie::clean_up()
{
field_pdr__id.clean_up();
field_precedence.clean_up();
field_pdi.clean_up();
field_outer__header__removal.clean_up();
field_FAR__ID__list.clean_up();
field_uRR__ID__list.clean_up();
field_qER__ID__list.clean_up();
field_activate__predefined__rules.clean_up();
}

const TTCN_Typedescriptor_t* Create__PDR_grouped__ie::get_descriptor() const { return &Create__PDR_grouped__ie_descr_; }
Create__PDR_grouped__ie& Create__PDR_grouped__ie::operator=(const Create__PDR_grouped__ie& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @PFCP_Types.Create_PDR.grouped_ie.");
  if (other_value.pdr__id().is_bound()) field_pdr__id = other_value.pdr__id();
  else field_pdr__id.clean_up();
  if (other_value.precedence().is_bound()) field_precedence = other_value.precedence();
  else field_precedence.clean_up();
  if (other_value.pdi().is_bound()) field_pdi = other_value.pdi();
  else field_pdi.clean_up();
  if (other_value.outer__header__removal().is_bound()) field_outer__header__removal = other_value.outer__header__removal();
  else field_outer__header__removal.clean_up();
  if (other_value.FAR__ID__list().is_bound()) field_FAR__ID__list = other_value.FAR__ID__list();
  else field_FAR__ID__list.clean_up();
  if (other_value.uRR__ID__list().is_bound()) field_uRR__ID__list = other_value.uRR__ID__list();
  else field_uRR__ID__list.clean_up();
  if (other_value.qER__ID__list().is_bound()) field_qER__ID__list = other_value.qER__ID__list();
  else field_qER__ID__list.clean_up();
  if (other_value.activate__predefined__rules().is_bound()) field_activate__predefined__rules = other_value.activate__predefined__rules();
  else field_activate__predefined__rules.clean_up();
}
return *this;
}

boolean Create__PDR_grouped__ie::operator==(const Create__PDR_grouped__ie& other_value) const
{
return field_pdr__id==other_value.field_pdr__id
  && field_precedence==other_value.field_precedence
  && field_pdi==other_value.field_pdi
  && field_outer__header__removal==other_value.field_outer__header__removal
  && field_FAR__ID__list==other_value.field_FAR__ID__list
  && field_uRR__ID__list==other_value.field_uRR__ID__list
  && field_qER__ID__list==other_value.field_qER__ID__list
  && field_activate__predefined__rules==other_value.field_activate__predefined__rules;
}

boolean Create__PDR_grouped__ie::is_bound() const
{
return (field_pdr__id.is_bound())
  || (OPTIONAL_OMIT == field_precedence.get_selection() || field_precedence.is_bound())
  || (field_pdi.is_bound())
  || (OPTIONAL_OMIT == field_outer__header__removal.get_selection() || field_outer__header__removal.is_bound())
  || (OPTIONAL_OMIT == field_FAR__ID__list.get_selection() || field_FAR__ID__list.is_bound())
  || (OPTIONAL_OMIT == field_uRR__ID__list.get_selection() || field_uRR__ID__list.is_bound())
  || (OPTIONAL_OMIT == field_qER__ID__list.get_selection() || field_qER__ID__list.is_bound())
  || (OPTIONAL_OMIT == field_activate__predefined__rules.get_selection() || field_activate__predefined__rules.is_bound());
}
boolean Create__PDR_grouped__ie::is_value() const
{
return field_pdr__id.is_value()
  && (OPTIONAL_OMIT == field_precedence.get_selection() || field_precedence.is_value())
  && field_pdi.is_value()
  && (OPTIONAL_OMIT == field_outer__header__removal.get_selection() || field_outer__header__removal.is_value())
  && (OPTIONAL_OMIT == field_FAR__ID__list.get_selection() || field_FAR__ID__list.is_value())
  && (OPTIONAL_OMIT == field_uRR__ID__list.get_selection() || field_uRR__ID__list.is_value())
  && (OPTIONAL_OMIT == field_qER__ID__list.get_selection() || field_qER__ID__list.is_value())
  && (OPTIONAL_OMIT == field_activate__predefined__rules.get_selection() || field_activate__predefined__rules.is_value());
}
int Create__PDR_grouped__ie::size_of() const
{
  int ret_val = 2;
  if (field_precedence.ispresent()) ret_val++;
  if (field_outer__header__removal.ispresent()) ret_val++;
  if (field_FAR__ID__list.ispresent()) ret_val++;
  if (field_uRR__ID__list.ispresent()) ret_val++;
  if (field_qER__ID__list.ispresent()) ret_val++;
  if (field_activate__predefined__rules.ispresent()) ret_val++;
  return ret_val;
}

void Create__PDR_grouped__ie::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ pdr_id := ");
field_pdr__id.log();
TTCN_Logger::log_event_str(", precedence := ");
field_precedence.log();
TTCN_Logger::log_event_str(", pdi := ");
field_pdi.log();
TTCN_Logger::log_event_str(", outer_header_removal := ");
field_outer__header__removal.log();
TTCN_Logger::log_event_str(", FAR_ID_list := ");
field_FAR__ID__list.log();
TTCN_Logger::log_event_str(", uRR_ID_list := ");
field_uRR__ID__list.log();
TTCN_Logger::log_event_str(", qER_ID_list := ");
field_qER__ID__list.log();
TTCN_Logger::log_event_str(", activate_predefined_rules := ");
field_activate__predefined__rules.log();
TTCN_Logger::log_event_str(" }");
}

void Create__PDR_grouped__ie::set_implicit_omit()
{
if (pdr__id().is_bound()) pdr__id().set_implicit_omit();
if (!precedence().is_bound()) precedence() = OMIT_VALUE;
else precedence().set_implicit_omit();
if (pdi().is_bound()) pdi().set_implicit_omit();
if (!outer__header__removal().is_bound()) outer__header__removal() = OMIT_VALUE;
else outer__header__removal().set_implicit_omit();
if (!FAR__ID__list().is_bound()) FAR__ID__list() = OMIT_VALUE;
else FAR__ID__list().set_implicit_omit();
if (!uRR__ID__list().is_bound()) uRR__ID__list() = OMIT_VALUE;
else uRR__ID__list().set_implicit_omit();
if (!qER__ID__list().is_bound()) qER__ID__list() = OMIT_VALUE;
else qER__ID__list().set_implicit_omit();
if (!activate__predefined__rules().is_bound()) activate__predefined__rules() = OMIT_VALUE;
else activate__predefined__rules().set_implicit_omit();
}

void Create__PDR_grouped__ie::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "set value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (8<param.get_size()) {
      param.error("set value of type @PFCP_Types.Create_PDR.grouped_ie has 8 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) pdr__id().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) precedence().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) pdi().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) outer__header__removal().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) FAR__ID__list().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) uRR__ID__list().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) qER__ID__list().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) activate__predefined__rules().set_param(*param.get_elem(7));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pdr_id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pdr__id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "precedence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          precedence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pdi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pdi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "outer_header_removal")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          outer__header__removal().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "FAR_ID_list")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          FAR__ID__list().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "uRR_ID_list")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          uRR__ID__list().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "qER_ID_list")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          qER__ID__list().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "activate_predefined_rules")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          activate__predefined__rules().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @PFCP_Types.Create_PDR.grouped_ie: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("set value", "@PFCP_Types.Create_PDR.grouped_ie");
  }
}

void Create__PDR_grouped__ie::encode_text(Text_Buf& text_buf) const
{
field_pdr__id.encode_text(text_buf);
field_precedence.encode_text(text_buf);
field_pdi.encode_text(text_buf);
field_outer__header__removal.encode_text(text_buf);
field_FAR__ID__list.encode_text(text_buf);
field_uRR__ID__list.encode_text(text_buf);
field_qER__ID__list.encode_text(text_buf);
field_activate__predefined__rules.encode_text(text_buf);
}

void Create__PDR_grouped__ie::decode_text(Text_Buf& text_buf)
{
field_pdr__id.decode_text(text_buf);
field_precedence.decode_text(text_buf);
field_pdi.decode_text(text_buf);
field_outer__header__removal.decode_text(text_buf);
field_FAR__ID__list.decode_text(text_buf);
field_uRR__ID__list.decode_text(text_buf);
field_qER__ID__list.decode_text(text_buf);
field_activate__predefined__rules.decode_text(text_buf);
}

void Create__PDR_grouped__ie::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Create__PDR_grouped__ie::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int Create__PDR_grouped__ie::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean, int, boolean, const RAW_Force_Omit* force_omit)
{
int prepaddlength = p_buf.increase_pos_padd(p_td.raw->prepadding);
limit -= prepaddlength;
int decoded_length = 0;
int field_map[8];
memset(field_map, 0, sizeof(field_map));
size_t nof_mand_fields = 0;
field_precedence = OMIT_VALUE;
field_outer__header__removal = OMIT_VALUE;
field_FAR__ID__list = OMIT_VALUE;
field_uRR__ID__list = OMIT_VALUE;
field_qER__ID__list = OMIT_VALUE;
field_activate__predefined__rules = OMIT_VALUE;
raw_order_t local_top_order;
if (p_td.raw->top_bit_order == TOP_BIT_INHERITED) local_top_order = top_bit_ord;
else if (p_td.raw->top_bit_order == TOP_BIT_RIGHT) local_top_order = ORDER_MSB;
else local_top_order = ORDER_LSB;
while (limit > 0) {
size_t fl_start_pos = p_buf.get_pos_bit();
if (field_map[0] == 0) {
RAW_Force_Omit field_0_force_omit(0, force_omit, PDR__ID_descr_.raw->forceomit);
int decoded_field_length = field_pdr__id.RAW_decode(PDR__ID_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_0_force_omit);
if (decoded_field_length >= 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
nof_mand_fields++;
field_map[0] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
}
}
if (field_map[1] == 0 && (force_omit == NULL || !(*force_omit)(1))) {
RAW_Force_Omit field_1_force_omit(1, force_omit, Precedence_descr_.raw->forceomit);
int decoded_field_length = field_precedence().RAW_decode(Precedence_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_1_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[1] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_precedence = OMIT_VALUE;
}
}
if (field_map[2] == 0) {
RAW_Force_Omit field_2_force_omit(2, force_omit, PDI__IE_descr_.raw->forceomit);
int decoded_field_length = field_pdi.RAW_decode(PDI__IE_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
if (decoded_field_length >= 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
nof_mand_fields++;
field_map[2] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
}
}
if (field_map[3] == 0 && (force_omit == NULL || !(*force_omit)(3))) {
RAW_Force_Omit field_3_force_omit(3, force_omit, Outer__Header__Removal_descr_.raw->forceomit);
int decoded_field_length = field_outer__header__removal().RAW_decode(Outer__Header__Removal_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[3] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_outer__header__removal = OMIT_VALUE;
}
}
if (force_omit == NULL || !(*force_omit)(4)) {
RAW_Force_Omit field_4_force_omit(4, force_omit, Create__PDR_grouped__ie_FAR__ID__list_descr_.raw->forceomit);
int decoded_field_length = field_FAR__ID__list().RAW_decode(Create__PDR_grouped__ie_FAR__ID__list_descr_, p_buf, limit, local_top_order, TRUE, 1, field_map[4] == 0, &field_4_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[4]++;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
if (field_map[4] == 0) field_FAR__ID__list = OMIT_VALUE;
}
}
if (force_omit == NULL || !(*force_omit)(5)) {
RAW_Force_Omit field_5_force_omit(5, force_omit, Create__PDR_grouped__ie_uRR__ID__list_descr_.raw->forceomit);
int decoded_field_length = field_uRR__ID__list().RAW_decode(Create__PDR_grouped__ie_uRR__ID__list_descr_, p_buf, limit, local_top_order, TRUE, 1, field_map[5] == 0, &field_5_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[5]++;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
if (field_map[5] == 0) field_uRR__ID__list = OMIT_VALUE;
}
}
if (force_omit == NULL || !(*force_omit)(6)) {
RAW_Force_Omit field_6_force_omit(6, force_omit, Create__PDR_grouped__ie_qER__ID__list_descr_.raw->forceomit);
int decoded_field_length = field_qER__ID__list().RAW_decode(Create__PDR_grouped__ie_qER__ID__list_descr_, p_buf, limit, local_top_order, TRUE, 1, field_map[6] == 0, &field_6_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[6]++;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
if (field_map[6] == 0) field_qER__ID__list = OMIT_VALUE;
}
}
if (field_map[7] == 0 && (force_omit == NULL || !(*force_omit)(7))) {
RAW_Force_Omit field_7_force_omit(7, force_omit, Activate__Predefined__Rules_descr_.raw->forceomit);
int decoded_field_length = field_activate__predefined__rules().RAW_decode(Activate__Predefined__Rules_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_7_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[7] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_activate__predefined__rules = OMIT_VALUE;
}
}
break;
}
if (nof_mand_fields != 2) return limit ? -1 : -TTCN_EncDec::ET_INCOMPL_MSG;
return decoded_length + prepaddlength + p_buf.increase_pos_padd(p_td.raw->padding);
}

int Create__PDR_grouped__ie::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 8;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(8);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, PDR__ID_descr_.raw);
  if (field_precedence.ispresent()) {
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, Precedence_descr_.raw);
  }
  else myleaf.body.node.nodes[1] = NULL;
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, PDI__IE_descr_.raw);
  if (field_outer__header__removal.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, Outer__Header__Removal_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  if (field_FAR__ID__list.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, Create__PDR_grouped__ie_FAR__ID__list_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  if (field_uRR__ID__list.ispresent()) {
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, Create__PDR_grouped__ie_uRR__ID__list_descr_.raw);
  }
  else myleaf.body.node.nodes[5] = NULL;
  if (field_qER__ID__list.ispresent()) {
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, Create__PDR_grouped__ie_qER__ID__list_descr_.raw);
  }
  else myleaf.body.node.nodes[6] = NULL;
  if (field_activate__predefined__rules.ispresent()) {
  myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 7, Activate__Predefined__Rules_descr_.raw);
  }
  else myleaf.body.node.nodes[7] = NULL;
  encoded_length += field_pdr__id.RAW_encode(PDR__ID_descr_, *myleaf.body.node.nodes[0]);
  if (field_precedence.ispresent()) {
  encoded_length += field_precedence().RAW_encode(Precedence_descr_, *myleaf.body.node.nodes[1]);
  }
  encoded_length += field_pdi.RAW_encode(PDI__IE_descr_, *myleaf.body.node.nodes[2]);
  if (field_outer__header__removal.ispresent()) {
  encoded_length += field_outer__header__removal().RAW_encode(Outer__Header__Removal_descr_, *myleaf.body.node.nodes[3]);
  }
  if (field_FAR__ID__list.ispresent()) {
  encoded_length += field_FAR__ID__list().RAW_encode(Create__PDR_grouped__ie_FAR__ID__list_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_uRR__ID__list.ispresent()) {
  encoded_length += field_uRR__ID__list().RAW_encode(Create__PDR_grouped__ie_uRR__ID__list_descr_, *myleaf.body.node.nodes[5]);
  }
  if (field_qER__ID__list.ispresent()) {
  encoded_length += field_qER__ID__list().RAW_encode(Create__PDR_grouped__ie_qER__ID__list_descr_, *myleaf.body.node.nodes[6]);
  }
  if (field_activate__predefined__rules.ispresent()) {
  encoded_length += field_activate__predefined__rules().RAW_encode(Activate__Predefined__Rules_descr_, *myleaf.body.node.nodes[7]);
  }
  return myleaf.length = encoded_length;
}

struct Create__PDR_grouped__ie_template::single_value_struct {
PDR__ID_template field_pdr__id;
Precedence_template field_precedence;
PDI__IE_template field_pdi;
Outer__Header__Removal_template field_outer__header__removal;
Create__PDR_grouped__ie_FAR__ID__list_template field_FAR__ID__list;
URR__ID__list_template field_uRR__ID__list;
QER__ID__list_template field_qER__ID__list;
Activate__Predefined__Rules_template field_activate__predefined__rules;
};

void Create__PDR_grouped__ie_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_pdr__id = ANY_VALUE;
single_value->field_precedence = ANY_OR_OMIT;
single_value->field_pdi = ANY_VALUE;
single_value->field_outer__header__removal = ANY_OR_OMIT;
single_value->field_FAR__ID__list = ANY_OR_OMIT;
single_value->field_uRR__ID__list = ANY_OR_OMIT;
single_value->field_qER__ID__list = ANY_OR_OMIT;
single_value->field_activate__predefined__rules = ANY_OR_OMIT;
}
}
}

void Create__PDR_grouped__ie_template::copy_value(const Create__PDR_grouped__ie& other_value)
{
single_value = new single_value_struct;
if (other_value.pdr__id().is_bound()) {
  single_value->field_pdr__id = other_value.pdr__id();
} else {
  single_value->field_pdr__id.clean_up();
}
if (other_value.precedence().is_bound()) {
  if (other_value.precedence().ispresent()) single_value->field_precedence = other_value.precedence()();
  else single_value->field_precedence = OMIT_VALUE;
} else {
  single_value->field_precedence.clean_up();
}
if (other_value.pdi().is_bound()) {
  single_value->field_pdi = other_value.pdi();
} else {
  single_value->field_pdi.clean_up();
}
if (other_value.outer__header__removal().is_bound()) {
  if (other_value.outer__header__removal().ispresent()) single_value->field_outer__header__removal = other_value.outer__header__removal()();
  else single_value->field_outer__header__removal = OMIT_VALUE;
} else {
  single_value->field_outer__header__removal.clean_up();
}
if (other_value.FAR__ID__list().is_bound()) {
  if (other_value.FAR__ID__list().ispresent()) single_value->field_FAR__ID__list = other_value.FAR__ID__list()();
  else single_value->field_FAR__ID__list = OMIT_VALUE;
} else {
  single_value->field_FAR__ID__list.clean_up();
}
if (other_value.uRR__ID__list().is_bound()) {
  if (other_value.uRR__ID__list().ispresent()) single_value->field_uRR__ID__list = other_value.uRR__ID__list()();
  else single_value->field_uRR__ID__list = OMIT_VALUE;
} else {
  single_value->field_uRR__ID__list.clean_up();
}
if (other_value.qER__ID__list().is_bound()) {
  if (other_value.qER__ID__list().ispresent()) single_value->field_qER__ID__list = other_value.qER__ID__list()();
  else single_value->field_qER__ID__list = OMIT_VALUE;
} else {
  single_value->field_qER__ID__list.clean_up();
}
if (other_value.activate__predefined__rules().is_bound()) {
  if (other_value.activate__predefined__rules().ispresent()) single_value->field_activate__predefined__rules = other_value.activate__predefined__rules()();
  else single_value->field_activate__predefined__rules = OMIT_VALUE;
} else {
  single_value->field_activate__predefined__rules.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void Create__PDR_grouped__ie_template::copy_template(const Create__PDR_grouped__ie_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.pdr__id().get_selection()) {
single_value->field_pdr__id = other_value.pdr__id();
} else {
single_value->field_pdr__id.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.precedence().get_selection()) {
single_value->field_precedence = other_value.precedence();
} else {
single_value->field_precedence.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.pdi().get_selection()) {
single_value->field_pdi = other_value.pdi();
} else {
single_value->field_pdi.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.outer__header__removal().get_selection()) {
single_value->field_outer__header__removal = other_value.outer__header__removal();
} else {
single_value->field_outer__header__removal.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.FAR__ID__list().get_selection()) {
single_value->field_FAR__ID__list = other_value.FAR__ID__list();
} else {
single_value->field_FAR__ID__list.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.uRR__ID__list().get_selection()) {
single_value->field_uRR__ID__list = other_value.uRR__ID__list();
} else {
single_value->field_uRR__ID__list.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.qER__ID__list().get_selection()) {
single_value->field_qER__ID__list = other_value.qER__ID__list();
} else {
single_value->field_qER__ID__list.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.activate__predefined__rules().get_selection()) {
single_value->field_activate__predefined__rules = other_value.activate__predefined__rules();
} else {
single_value->field_activate__predefined__rules.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Create__PDR_grouped__ie_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Create__PDR_grouped__ie_template(*other_value.implication_.precondition);
implication_.implied_template = new Create__PDR_grouped__ie_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @PFCP_Types.Create_PDR.grouped_ie.");
break;
}
set_selection(other_value);
}

Create__PDR_grouped__ie_template::Create__PDR_grouped__ie_template()
{
}

Create__PDR_grouped__ie_template::Create__PDR_grouped__ie_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

Create__PDR_grouped__ie_template::Create__PDR_grouped__ie_template(const Create__PDR_grouped__ie& other_value)
{
copy_value(other_value);
}

Create__PDR_grouped__ie_template::Create__PDR_grouped__ie_template(const OPTIONAL<Create__PDR_grouped__ie>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Create__PDR_grouped__ie&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @PFCP_Types.Create_PDR.grouped_ie from an unbound optional field.");
}
}

Create__PDR_grouped__ie_template::Create__PDR_grouped__ie_template(Create__PDR_grouped__ie_template* p_precondition, Create__PDR_grouped__ie_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

Create__PDR_grouped__ie_template::Create__PDR_grouped__ie_template(Dynamic_Match_Interface<Create__PDR_grouped__ie>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<Create__PDR_grouped__ie>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

Create__PDR_grouped__ie_template::Create__PDR_grouped__ie_template(const Create__PDR_grouped__ie_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

Create__PDR_grouped__ie_template::~Create__PDR_grouped__ie_template()
{
clean_up();
}

Create__PDR_grouped__ie_template& Create__PDR_grouped__ie_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

Create__PDR_grouped__ie_template& Create__PDR_grouped__ie_template::operator=(const Create__PDR_grouped__ie& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

Create__PDR_grouped__ie_template& Create__PDR_grouped__ie_template::operator=(const OPTIONAL<Create__PDR_grouped__ie>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Create__PDR_grouped__ie&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @PFCP_Types.Create_PDR.grouped_ie.");
}
return *this;
}

Create__PDR_grouped__ie_template& Create__PDR_grouped__ie_template::operator=(const Create__PDR_grouped__ie_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean Create__PDR_grouped__ie_template::match(const Create__PDR_grouped__ie& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.pdr__id().is_bound()) return FALSE;
if(!single_value->field_pdr__id.match(other_value.pdr__id(), legacy))return FALSE;
if(!other_value.precedence().is_bound()) return FALSE;
if((other_value.precedence().ispresent() ? !single_value->field_precedence.match((const Precedence&)other_value.precedence(), legacy) : !single_value->field_precedence.match_omit(legacy)))return FALSE;
if(!other_value.pdi().is_bound()) return FALSE;
if(!single_value->field_pdi.match(other_value.pdi(), legacy))return FALSE;
if(!other_value.outer__header__removal().is_bound()) return FALSE;
if((other_value.outer__header__removal().ispresent() ? !single_value->field_outer__header__removal.match((const Outer__Header__Removal&)other_value.outer__header__removal(), legacy) : !single_value->field_outer__header__removal.match_omit(legacy)))return FALSE;
if(!other_value.FAR__ID__list().is_bound()) return FALSE;
if((other_value.FAR__ID__list().ispresent() ? !single_value->field_FAR__ID__list.match((const Create__PDR_grouped__ie_FAR__ID__list&)other_value.FAR__ID__list(), legacy) : !single_value->field_FAR__ID__list.match_omit(legacy)))return FALSE;
if(!other_value.uRR__ID__list().is_bound()) return FALSE;
if((other_value.uRR__ID__list().ispresent() ? !single_value->field_uRR__ID__list.match((const URR__ID__list&)other_value.uRR__ID__list(), legacy) : !single_value->field_uRR__ID__list.match_omit(legacy)))return FALSE;
if(!other_value.qER__ID__list().is_bound()) return FALSE;
if((other_value.qER__ID__list().ispresent() ? !single_value->field_qER__ID__list.match((const QER__ID__list&)other_value.qER__ID__list(), legacy) : !single_value->field_qER__ID__list.match_omit(legacy)))return FALSE;
if(!other_value.activate__predefined__rules().is_bound()) return FALSE;
if((other_value.activate__predefined__rules().ispresent() ? !single_value->field_activate__predefined__rules.match((const Activate__Predefined__Rules&)other_value.activate__predefined__rules(), legacy) : !single_value->field_activate__predefined__rules.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @PFCP_Types.Create_PDR.grouped_ie.");
}
return FALSE;
}

boolean Create__PDR_grouped__ie_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_pdr__id.is_bound()
 || (single_value->field_precedence.is_omit() || single_value->field_precedence.is_bound())
 || single_value->field_pdi.is_bound()
 || (single_value->field_outer__header__removal.is_omit() || single_value->field_outer__header__removal.is_bound())
 || (single_value->field_FAR__ID__list.is_omit() || single_value->field_FAR__ID__list.is_bound())
 || (single_value->field_uRR__ID__list.is_omit() || single_value->field_uRR__ID__list.is_bound())
 || (single_value->field_qER__ID__list.is_omit() || single_value->field_qER__ID__list.is_bound())
 || (single_value->field_activate__predefined__rules.is_omit() || single_value->field_activate__predefined__rules.is_bound());
}

boolean Create__PDR_grouped__ie_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_pdr__id.is_value()
 && (single_value->field_precedence.is_omit() || single_value->field_precedence.is_value())
 && single_value->field_pdi.is_value()
 && (single_value->field_outer__header__removal.is_omit() || single_value->field_outer__header__removal.is_value())
 && (single_value->field_FAR__ID__list.is_omit() || single_value->field_FAR__ID__list.is_value())
 && (single_value->field_uRR__ID__list.is_omit() || single_value->field_uRR__ID__list.is_value())
 && (single_value->field_qER__ID__list.is_omit() || single_value->field_qER__ID__list.is_value())
 && (single_value->field_activate__predefined__rules.is_omit() || single_value->field_activate__predefined__rules.is_value());
}

void Create__PDR_grouped__ie_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

Create__PDR_grouped__ie Create__PDR_grouped__ie_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @PFCP_Types.Create_PDR.grouped_ie.");
Create__PDR_grouped__ie ret_val;
if (single_value->field_pdr__id.is_bound()) {
ret_val.pdr__id() = single_value->field_pdr__id.valueof();
}
if (single_value->field_precedence.is_omit()) ret_val.precedence() = OMIT_VALUE;
else if (single_value->field_precedence.is_bound()) {
ret_val.precedence() = single_value->field_precedence.valueof();
}
if (single_value->field_pdi.is_bound()) {
ret_val.pdi() = single_value->field_pdi.valueof();
}
if (single_value->field_outer__header__removal.is_omit()) ret_val.outer__header__removal() = OMIT_VALUE;
else if (single_value->field_outer__header__removal.is_bound()) {
ret_val.outer__header__removal() = single_value->field_outer__header__removal.valueof();
}
if (single_value->field_FAR__ID__list.is_omit()) ret_val.FAR__ID__list() = OMIT_VALUE;
else if (single_value->field_FAR__ID__list.is_bound()) {
ret_val.FAR__ID__list() = single_value->field_FAR__ID__list.valueof();
}
if (single_value->field_uRR__ID__list.is_omit()) ret_val.uRR__ID__list() = OMIT_VALUE;
else if (single_value->field_uRR__ID__list.is_bound()) {
ret_val.uRR__ID__list() = single_value->field_uRR__ID__list.valueof();
}
if (single_value->field_qER__ID__list.is_omit()) ret_val.qER__ID__list() = OMIT_VALUE;
else if (single_value->field_qER__ID__list.is_bound()) {
ret_val.qER__ID__list() = single_value->field_qER__ID__list.valueof();
}
if (single_value->field_activate__predefined__rules.is_omit()) ret_val.activate__predefined__rules() = OMIT_VALUE;
else if (single_value->field_activate__predefined__rules.is_bound()) {
ret_val.activate__predefined__rules() = single_value->field_activate__predefined__rules.valueof();
}
return ret_val;
}

void Create__PDR_grouped__ie_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @PFCP_Types.Create_PDR.grouped_ie.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new Create__PDR_grouped__ie_template[list_length];
}

Create__PDR_grouped__ie_template& Create__PDR_grouped__ie_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @PFCP_Types.Create_PDR.grouped_ie.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @PFCP_Types.Create_PDR.grouped_ie.");
return value_list.list_value[list_index];
}

PDR__ID_template& Create__PDR_grouped__ie_template::pdr__id()
{
set_specific();
return single_value->field_pdr__id;
}

const PDR__ID_template& Create__PDR_grouped__ie_template::pdr__id() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field pdr_id of a non-specific template of type @PFCP_Types.Create_PDR.grouped_ie.");
return single_value->field_pdr__id;
}

Precedence_template& Create__PDR_grouped__ie_template::precedence()
{
set_specific();
return single_value->field_precedence;
}

const Precedence_template& Create__PDR_grouped__ie_template::precedence() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field precedence of a non-specific template of type @PFCP_Types.Create_PDR.grouped_ie.");
return single_value->field_precedence;
}

PDI__IE_template& Create__PDR_grouped__ie_template::pdi()
{
set_specific();
return single_value->field_pdi;
}

const PDI__IE_template& Create__PDR_grouped__ie_template::pdi() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field pdi of a non-specific template of type @PFCP_Types.Create_PDR.grouped_ie.");
return single_value->field_pdi;
}

Outer__Header__Removal_template& Create__PDR_grouped__ie_template::outer__header__removal()
{
set_specific();
return single_value->field_outer__header__removal;
}

const Outer__Header__Removal_template& Create__PDR_grouped__ie_template::outer__header__removal() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field outer_header_removal of a non-specific template of type @PFCP_Types.Create_PDR.grouped_ie.");
return single_value->field_outer__header__removal;
}

Create__PDR_grouped__ie_FAR__ID__list_template& Create__PDR_grouped__ie_template::FAR__ID__list()
{
set_specific();
return single_value->field_FAR__ID__list;
}

const Create__PDR_grouped__ie_FAR__ID__list_template& Create__PDR_grouped__ie_template::FAR__ID__list() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field FAR_ID_list of a non-specific template of type @PFCP_Types.Create_PDR.grouped_ie.");
return single_value->field_FAR__ID__list;
}

URR__ID__list_template& Create__PDR_grouped__ie_template::uRR__ID__list()
{
set_specific();
return single_value->field_uRR__ID__list;
}

const URR__ID__list_template& Create__PDR_grouped__ie_template::uRR__ID__list() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field uRR_ID_list of a non-specific template of type @PFCP_Types.Create_PDR.grouped_ie.");
return single_value->field_uRR__ID__list;
}

QER__ID__list_template& Create__PDR_grouped__ie_template::qER__ID__list()
{
set_specific();
return single_value->field_qER__ID__list;
}

const QER__ID__list_template& Create__PDR_grouped__ie_template::qER__ID__list() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field qER_ID_list of a non-specific template of type @PFCP_Types.Create_PDR.grouped_ie.");
return single_value->field_qER__ID__list;
}

Activate__Predefined__Rules_template& Create__PDR_grouped__ie_template::activate__predefined__rules()
{
set_specific();
return single_value->field_activate__predefined__rules;
}

const Activate__Predefined__Rules_template& Create__PDR_grouped__ie_template::activate__predefined__rules() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field activate_predefined_rules of a non-specific template of type @PFCP_Types.Create_PDR.grouped_ie.");
return single_value->field_activate__predefined__rules;
}

int Create__PDR_grouped__ie_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_PDR.grouped_ie which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 2;
      if (single_value->field_precedence.is_present()) ret_val++;
      if (single_value->field_outer__header__removal.is_present()) ret_val++;
      if (single_value->field_FAR__ID__list.is_present()) ret_val++;
      if (single_value->field_uRR__ID__list.is_present()) ret_val++;
      if (single_value->field_qER__ID__list.is_present()) ret_val++;
      if (single_value->field_activate__predefined__rules.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @PFCP_Types.Create_PDR.grouped_ie containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_PDR.grouped_ie containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_PDR.grouped_ie containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_PDR.grouped_ie containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_PDR.grouped_ie containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_PDR.grouped_ie containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_PDR.grouped_ie containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_PDR.grouped_ie containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @PFCP_Types.Create_PDR.grouped_ie.");
  }
  return 0;
}

void Create__PDR_grouped__ie_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ pdr_id := ");
single_value->field_pdr__id.log();
TTCN_Logger::log_event_str(", precedence := ");
single_value->field_precedence.log();
TTCN_Logger::log_event_str(", pdi := ");
single_value->field_pdi.log();
TTCN_Logger::log_event_str(", outer_header_removal := ");
single_value->field_outer__header__removal.log();
TTCN_Logger::log_event_str(", FAR_ID_list := ");
single_value->field_FAR__ID__list.log();
TTCN_Logger::log_event_str(", uRR_ID_list := ");
single_value->field_uRR__ID__list.log();
TTCN_Logger::log_event_str(", qER_ID_list := ");
single_value->field_qER__ID__list.log();
TTCN_Logger::log_event_str(", activate_predefined_rules := ");
single_value->field_activate__predefined__rules.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void Create__PDR_grouped__ie_template::log_match(const Create__PDR_grouped__ie& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_pdr__id.match(match_value.pdr__id(), legacy)){
TTCN_Logger::log_logmatch_info(".pdr_id");
single_value->field_pdr__id.log_match(match_value.pdr__id(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.precedence().ispresent()){
if(!single_value->field_precedence.match(match_value.precedence(), legacy)){
TTCN_Logger::log_logmatch_info(".precedence");
single_value->field_precedence.log_match(match_value.precedence(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_precedence.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".precedence := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_precedence.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_pdi.match(match_value.pdi(), legacy)){
TTCN_Logger::log_logmatch_info(".pdi");
single_value->field_pdi.log_match(match_value.pdi(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.outer__header__removal().ispresent()){
if(!single_value->field_outer__header__removal.match(match_value.outer__header__removal(), legacy)){
TTCN_Logger::log_logmatch_info(".outer_header_removal");
single_value->field_outer__header__removal.log_match(match_value.outer__header__removal(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_outer__header__removal.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".outer_header_removal := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_outer__header__removal.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.FAR__ID__list().ispresent()){
if(!single_value->field_FAR__ID__list.match(match_value.FAR__ID__list(), legacy)){
TTCN_Logger::log_logmatch_info(".FAR_ID_list");
single_value->field_FAR__ID__list.log_match(match_value.FAR__ID__list(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_FAR__ID__list.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".FAR_ID_list := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_FAR__ID__list.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.uRR__ID__list().ispresent()){
if(!single_value->field_uRR__ID__list.match(match_value.uRR__ID__list(), legacy)){
TTCN_Logger::log_logmatch_info(".uRR_ID_list");
single_value->field_uRR__ID__list.log_match(match_value.uRR__ID__list(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_uRR__ID__list.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".uRR_ID_list := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_uRR__ID__list.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.qER__ID__list().ispresent()){
if(!single_value->field_qER__ID__list.match(match_value.qER__ID__list(), legacy)){
TTCN_Logger::log_logmatch_info(".qER_ID_list");
single_value->field_qER__ID__list.log_match(match_value.qER__ID__list(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_qER__ID__list.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".qER_ID_list := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_qER__ID__list.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.activate__predefined__rules().ispresent()){
if(!single_value->field_activate__predefined__rules.match(match_value.activate__predefined__rules(), legacy)){
TTCN_Logger::log_logmatch_info(".activate_predefined_rules");
single_value->field_activate__predefined__rules.log_match(match_value.activate__predefined__rules(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_activate__predefined__rules.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".activate_predefined_rules := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_activate__predefined__rules.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ pdr_id := ");
single_value->field_pdr__id.log_match(match_value.pdr__id(), legacy);
TTCN_Logger::log_event_str(", precedence := ");
if (match_value.precedence().ispresent()) {
single_value->field_precedence.log_match(match_value.precedence(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_precedence.log();
if (single_value->field_precedence.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", pdi := ");
single_value->field_pdi.log_match(match_value.pdi(), legacy);
TTCN_Logger::log_event_str(", outer_header_removal := ");
if (match_value.outer__header__removal().ispresent()) {
single_value->field_outer__header__removal.log_match(match_value.outer__header__removal(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_outer__header__removal.log();
if (single_value->field_outer__header__removal.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", FAR_ID_list := ");
if (match_value.FAR__ID__list().ispresent()) {
single_value->field_FAR__ID__list.log_match(match_value.FAR__ID__list(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_FAR__ID__list.log();
if (single_value->field_FAR__ID__list.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", uRR_ID_list := ");
if (match_value.uRR__ID__list().ispresent()) {
single_value->field_uRR__ID__list.log_match(match_value.uRR__ID__list(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_uRR__ID__list.log();
if (single_value->field_uRR__ID__list.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", qER_ID_list := ");
if (match_value.qER__ID__list().ispresent()) {
single_value->field_qER__ID__list.log_match(match_value.qER__ID__list(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_qER__ID__list.log();
if (single_value->field_qER__ID__list.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", activate_predefined_rules := ");
if (match_value.activate__predefined__rules().ispresent()) {
single_value->field_activate__predefined__rules.log_match(match_value.activate__predefined__rules(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_activate__predefined__rules.log();
if (single_value->field_activate__predefined__rules.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void Create__PDR_grouped__ie_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (pdr__id().is_bound()) pdr__id().set_implicit_omit();
if (!precedence().is_bound()) precedence() = OMIT_VALUE;
else precedence().set_implicit_omit();
if (pdi().is_bound()) pdi().set_implicit_omit();
if (!outer__header__removal().is_bound()) outer__header__removal() = OMIT_VALUE;
else outer__header__removal().set_implicit_omit();
if (!FAR__ID__list().is_bound()) FAR__ID__list() = OMIT_VALUE;
else FAR__ID__list().set_implicit_omit();
if (!uRR__ID__list().is_bound()) uRR__ID__list() = OMIT_VALUE;
else uRR__ID__list().set_implicit_omit();
if (!qER__ID__list().is_bound()) qER__ID__list() = OMIT_VALUE;
else qER__ID__list().set_implicit_omit();
if (!activate__predefined__rules().is_bound()) activate__predefined__rules() = OMIT_VALUE;
else activate__predefined__rules().set_implicit_omit();
}

void Create__PDR_grouped__ie_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_pdr__id.encode_text(text_buf);
single_value->field_precedence.encode_text(text_buf);
single_value->field_pdi.encode_text(text_buf);
single_value->field_outer__header__removal.encode_text(text_buf);
single_value->field_FAR__ID__list.encode_text(text_buf);
single_value->field_uRR__ID__list.encode_text(text_buf);
single_value->field_qER__ID__list.encode_text(text_buf);
single_value->field_activate__predefined__rules.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @PFCP_Types.Create_PDR.grouped_ie.");
}
}

void Create__PDR_grouped__ie_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_pdr__id.decode_text(text_buf);
single_value->field_precedence.decode_text(text_buf);
single_value->field_pdi.decode_text(text_buf);
single_value->field_outer__header__removal.decode_text(text_buf);
single_value->field_FAR__ID__list.decode_text(text_buf);
single_value->field_uRR__ID__list.decode_text(text_buf);
single_value->field_qER__ID__list.decode_text(text_buf);
single_value->field_activate__predefined__rules.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new Create__PDR_grouped__ie_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @PFCP_Types.Create_PDR.grouped_ie.");
}
}

void Create__PDR_grouped__ie_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "set template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    Create__PDR_grouped__ie_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (8<param.get_size()) {
      param.error("set template of type @PFCP_Types.Create_PDR.grouped_ie has 8 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) pdr__id().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) precedence().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) pdi().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) outer__header__removal().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) FAR__ID__list().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) uRR__ID__list().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) qER__ID__list().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) activate__predefined__rules().set_param(*param.get_elem(7));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pdr_id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pdr__id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "precedence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          precedence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pdi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pdi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "outer_header_removal")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          outer__header__removal().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "FAR_ID_list")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          FAR__ID__list().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "uRR_ID_list")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          uRR__ID__list().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "qER_ID_list")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          qER__ID__list().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "activate_predefined_rules")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          activate__predefined__rules().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @PFCP_Types.Create_PDR.grouped_ie: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    Create__PDR_grouped__ie_template* precondition = new Create__PDR_grouped__ie_template;
    precondition->set_param(*param.get_elem(0));
    Create__PDR_grouped__ie_template* implied_template = new Create__PDR_grouped__ie_template;
    implied_template->set_param(*param.get_elem(1));
    *this = Create__PDR_grouped__ie_template(precondition, implied_template);
  } break;
  default:
    param.type_error("set template", "@PFCP_Types.Create_PDR.grouped_ie");
  }
  is_ifpresent = param.get_ifpresent();
}

void Create__PDR_grouped__ie_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_pdr__id.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_PDR.grouped_ie");
single_value->field_precedence.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_PDR.grouped_ie");
single_value->field_pdi.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_PDR.grouped_ie");
single_value->field_outer__header__removal.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_PDR.grouped_ie");
single_value->field_FAR__ID__list.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_PDR.grouped_ie");
single_value->field_uRR__ID__list.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_PDR.grouped_ie");
single_value->field_qER__ID__list.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_PDR.grouped_ie");
single_value->field_activate__predefined__rules.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_PDR.grouped_ie");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@PFCP_Types.Create_PDR.grouped_ie");
}

boolean Create__PDR_grouped__ie_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean Create__PDR_grouped__ie_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const FAR__ID Create__PDR_grouped__ie_FAR__ID__list::UNBOUND_ELEM;
Create__PDR_grouped__ie_FAR__ID__list::Create__PDR_grouped__ie_FAR__ID__list()
{
val_ptr = NULL;
}

Create__PDR_grouped__ie_FAR__ID__list::Create__PDR_grouped__ie_FAR__ID__list(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

Create__PDR_grouped__ie_FAR__ID__list::Create__PDR_grouped__ie_FAR__ID__list(const Create__PDR_grouped__ie_FAR__ID__list& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

Create__PDR_grouped__ie_FAR__ID__list::~Create__PDR_grouped__ie_FAR__ID__list()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void Create__PDR_grouped__ie_FAR__ID__list::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

Create__PDR_grouped__ie_FAR__ID__list& Create__PDR_grouped__ie_FAR__ID__list::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

Create__PDR_grouped__ie_FAR__ID__list& Create__PDR_grouped__ie_FAR__ID__list::operator=(const Create__PDR_grouped__ie_FAR__ID__list& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean Create__PDR_grouped__ie_FAR__ID__list::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list.");
return val_ptr->n_elements == 0 ;
}

boolean Create__PDR_grouped__ie_FAR__ID__list::operator==(const Create__PDR_grouped__ie_FAR__ID__list& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

FAR__ID& Create__PDR_grouped__ie_FAR__ID__list::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (FAR__ID**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new FAR__ID(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new FAR__ID;
}
return *val_ptr->value_elements[index_value];
}

FAR__ID& Create__PDR_grouped__ie_FAR__ID__list::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list.");
return (*this)[(int)index_value];
}

const FAR__ID& Create__PDR_grouped__ie_FAR__ID__list::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list.");
if (index_value < 0) TTCN_error("Accessing an element of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const FAR__ID& Create__PDR_grouped__ie_FAR__ID__list::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list.");
return (*this)[(int)index_value];
}

Create__PDR_grouped__ie_FAR__ID__list Create__PDR_grouped__ie_FAR__ID__list::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

Create__PDR_grouped__ie_FAR__ID__list Create__PDR_grouped__ie_FAR__ID__list::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

Create__PDR_grouped__ie_FAR__ID__list Create__PDR_grouped__ie_FAR__ID__list::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

Create__PDR_grouped__ie_FAR__ID__list Create__PDR_grouped__ie_FAR__ID__list::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
Create__PDR_grouped__ie_FAR__ID__list ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new FAR__ID(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

Create__PDR_grouped__ie_FAR__ID__list Create__PDR_grouped__ie_FAR__ID__list::operator+(const Create__PDR_grouped__ie_FAR__ID__list& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
Create__PDR_grouped__ie_FAR__ID__list ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new FAR__ID(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new FAR__ID(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

Create__PDR_grouped__ie_FAR__ID__list Create__PDR_grouped__ie_FAR__ID__list::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list","element");
Create__PDR_grouped__ie_FAR__ID__list ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new FAR__ID(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

Create__PDR_grouped__ie_FAR__ID__list Create__PDR_grouped__ie_FAR__ID__list::replace(int index, int len, const Create__PDR_grouped__ie_FAR__ID__list& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list.");
check_replace_arguments(val_ptr->n_elements, index, len, "@PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list","element");
Create__PDR_grouped__ie_FAR__ID__list ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new FAR__ID(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new FAR__ID(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new FAR__ID(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

Create__PDR_grouped__ie_FAR__ID__list Create__PDR_grouped__ie_FAR__ID__list::replace(int index, int len, const Create__PDR_grouped__ie_FAR__ID__list_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void Create__PDR_grouped__ie_FAR__ID__list::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (FAR__ID**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new FAR__ID(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (FAR__ID**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (FAR__ID**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean Create__PDR_grouped__ie_FAR__ID__list::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int Create__PDR_grouped__ie_FAR__ID__list::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list.");
return val_ptr->n_elements;
}

int Create__PDR_grouped__ie_FAR__ID__list::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void Create__PDR_grouped__ie_FAR__ID__list::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void Create__PDR_grouped__ie_FAR__ID__list::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void Create__PDR_grouped__ie_FAR__ID__list::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void Create__PDR_grouped__ie_FAR__ID__list::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void Create__PDR_grouped__ie_FAR__ID__list::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list.");
val_ptr->value_elements = (FAR__ID**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new FAR__ID;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void Create__PDR_grouped__ie_FAR__ID__list::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Create__PDR_grouped__ie_FAR__ID__list::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int Create__PDR_grouped__ie_FAR__ID__list::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean /*no_err*/, int sel_field, boolean first_call, const RAW_Force_Omit*){
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int decoded_field_length=0;
  size_t start_of_field=0;
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int start_field=val_ptr->n_elements;
  if(p_td.raw->fieldlength || sel_field!=-1){
    int a=0;
    if(sel_field==-1) sel_field=p_td.raw->fieldlength;
    start_of_field=p_buf.get_pos_bit();
    for(a=0;a<sel_field;a++){
      decoded_field_length=(*this)[a+start_field].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        while(a>=0){
          delete &(*this)[a+start_field];
          a--;
          val_ptr->n_elements--;
        }
        p_buf.set_pos_bit(start_of_field);
        return decoded_field_length;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
    }
    if(a==0) val_ptr->n_elements=0;
  } else {
    if(limit==0){
      if(!first_call) return -1;
      val_ptr->n_elements=0;
      return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
    }
    int a=start_field;
    while(limit>0){
      start_of_field=p_buf.get_pos_bit();
      decoded_field_length=(*this)[a].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        delete &(*this)[a];
        val_ptr->n_elements--;
        p_buf.set_pos_bit(start_of_field);
        if(a>start_field){
        return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
        } else return -1;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
      a++;
    }
  }
 return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
}

int Create__PDR_grouped__ie_FAR__ID__list::RAW_encode(const TTCN_Typedescriptor_t& p_td,RAW_enc_tree& myleaf) const{
  int encoded_length=0;
  int encoded_num_of_records=p_td.raw->fieldlength?smaller(val_ptr->n_elements, p_td.raw->fieldlength):val_ptr->n_elements;
  myleaf.isleaf=FALSE;
  myleaf.rec_of=TRUE;
  myleaf.body.node.num_of_nodes=encoded_num_of_records;
  myleaf.body.node.nodes=init_nodes_of_enc_tree(encoded_num_of_records);
  for(int a=0;a<encoded_num_of_records;a++){
    myleaf.body.node.nodes[a]=new RAW_enc_tree(TRUE,&myleaf,&(myleaf.curr_pos),a,p_td.oftype_descr->raw);
    encoded_length+=(*this)[a].RAW_encode(*p_td.oftype_descr,*myleaf.body.node.nodes[a]);
  }
 return myleaf.length=encoded_length;
}

void Create__PDR_grouped__ie_FAR__ID__list_template::copy_value(const Create__PDR_grouped__ie_FAR__ID__list& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (FAR__ID_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new FAR__ID_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new FAR__ID_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void Create__PDR_grouped__ie_FAR__ID__list_template::copy_template(const Create__PDR_grouped__ie_FAR__ID__list_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (FAR__ID_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new FAR__ID_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new FAR__ID_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Create__PDR_grouped__ie_FAR__ID__list_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Create__PDR_grouped__ie_FAR__ID__list_template(*other_value.implication_.precondition);
implication_.implied_template = new Create__PDR_grouped__ie_FAR__ID__list_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list.");
break;
}
set_selection(other_value);
}

boolean Create__PDR_grouped__ie_FAR__ID__list_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const Create__PDR_grouped__ie_FAR__ID__list_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const Create__PDR_grouped__ie_FAR__ID__list*)value_ptr)[value_index], legacy);
else return ((const Create__PDR_grouped__ie_FAR__ID__list_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

Create__PDR_grouped__ie_FAR__ID__list_template::Create__PDR_grouped__ie_FAR__ID__list_template()
{
}

Create__PDR_grouped__ie_FAR__ID__list_template::Create__PDR_grouped__ie_FAR__ID__list_template(template_sel other_value)
 : Base_Record_Of_Template(other_value)
{
check_single_selection(other_value);
}

Create__PDR_grouped__ie_FAR__ID__list_template::Create__PDR_grouped__ie_FAR__ID__list_template(null_type)
 : Base_Record_Of_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

Create__PDR_grouped__ie_FAR__ID__list_template::Create__PDR_grouped__ie_FAR__ID__list_template(const Create__PDR_grouped__ie_FAR__ID__list& other_value)
{
copy_value(other_value);
}

Create__PDR_grouped__ie_FAR__ID__list_template::Create__PDR_grouped__ie_FAR__ID__list_template(const OPTIONAL<Create__PDR_grouped__ie_FAR__ID__list>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Create__PDR_grouped__ie_FAR__ID__list&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list from an unbound optional field.");
}
}

Create__PDR_grouped__ie_FAR__ID__list_template::Create__PDR_grouped__ie_FAR__ID__list_template(Create__PDR_grouped__ie_FAR__ID__list_template* p_precondition, Create__PDR_grouped__ie_FAR__ID__list_template* p_implied_template)
 : Base_Record_Of_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

Create__PDR_grouped__ie_FAR__ID__list_template::Create__PDR_grouped__ie_FAR__ID__list_template(Dynamic_Match_Interface<Create__PDR_grouped__ie_FAR__ID__list>* p_dyn_match)
 : Base_Record_Of_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<Create__PDR_grouped__ie_FAR__ID__list>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

Create__PDR_grouped__ie_FAR__ID__list_template::Create__PDR_grouped__ie_FAR__ID__list_template(const Create__PDR_grouped__ie_FAR__ID__list_template& other_value)
 : Base_Record_Of_Template()
{
copy_template(other_value);
}

Create__PDR_grouped__ie_FAR__ID__list_template::~Create__PDR_grouped__ie_FAR__ID__list_template()
{
clean_up();
}

void Create__PDR_grouped__ie_FAR__ID__list_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

Create__PDR_grouped__ie_FAR__ID__list_template& Create__PDR_grouped__ie_FAR__ID__list_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

Create__PDR_grouped__ie_FAR__ID__list_template& Create__PDR_grouped__ie_FAR__ID__list_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

Create__PDR_grouped__ie_FAR__ID__list_template& Create__PDR_grouped__ie_FAR__ID__list_template::operator=(const Create__PDR_grouped__ie_FAR__ID__list& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

Create__PDR_grouped__ie_FAR__ID__list_template& Create__PDR_grouped__ie_FAR__ID__list_template::operator=(const OPTIONAL<Create__PDR_grouped__ie_FAR__ID__list>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Create__PDR_grouped__ie_FAR__ID__list&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list.");
}
return *this;
}

Create__PDR_grouped__ie_FAR__ID__list_template& Create__PDR_grouped__ie_FAR__ID__list_template::operator=(const Create__PDR_grouped__ie_FAR__ID__list_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

FAR__ID_template& Create__PDR_grouped__ie_FAR__ID__list_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list.");
    break;
}
return *single_value.value_elements[index_value];
}

FAR__ID_template& Create__PDR_grouped__ie_FAR__ID__list_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list.");
return (*this)[(int)index_value];
}

const FAR__ID_template& Create__PDR_grouped__ie_FAR__ID__list_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const FAR__ID_template& Create__PDR_grouped__ie_FAR__ID__list_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list.");
return (*this)[(int)index_value];
}

void Create__PDR_grouped__ie_FAR__ID__list_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (FAR__ID_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new FAR__ID_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new FAR__ID_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (FAR__ID_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int Create__PDR_grouped__ie_FAR__ID__list_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int Create__PDR_grouped__ie_FAR__ID__list_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list");
}

boolean Create__PDR_grouped__ie_FAR__ID__list_template::match(const Create__PDR_grouped__ie_FAR__ID__list& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_record_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list.");
}
return FALSE;
}

boolean Create__PDR_grouped__ie_FAR__ID__list_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

Create__PDR_grouped__ie_FAR__ID__list Create__PDR_grouped__ie_FAR__ID__list_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list.");
Create__PDR_grouped__ie_FAR__ID__list ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

Create__PDR_grouped__ie_FAR__ID__list Create__PDR_grouped__ie_FAR__ID__list_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

Create__PDR_grouped__ie_FAR__ID__list Create__PDR_grouped__ie_FAR__ID__list_template::replace(int index, int len, const Create__PDR_grouped__ie_FAR__ID__list_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

Create__PDR_grouped__ie_FAR__ID__list Create__PDR_grouped__ie_FAR__ID__list_template::replace(int index, int len, const Create__PDR_grouped__ie_FAR__ID__list& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void Create__PDR_grouped__ie_FAR__ID__list_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new Create__PDR_grouped__ie_FAR__ID__list_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list.");
}
set_selection(template_type);
}

Create__PDR_grouped__ie_FAR__ID__list_template& Create__PDR_grouped__ie_FAR__ID__list_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list.");
return value_list.list_value[list_index];
}

void Create__PDR_grouped__ie_FAR__ID__list_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
if (permutation_starts_at(elem_count)) TTCN_Logger::log_event_str("permutation(");
single_value.value_elements[elem_count]->log();
if (permutation_ends_at(elem_count)) TTCN_Logger::log_char(')');
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void Create__PDR_grouped__ie_FAR__ID__list_template::log_match(const Create__PDR_grouped__ie_FAR__ID__list& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if(!single_value.value_elements[elem_count]->match(match_value[elem_count], legacy)){
TTCN_Logger::log_logmatch_info("[%d]", elem_count);
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
log_match_length(single_value.n_elements);
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
}
TTCN_Logger::log_event_str(" }");
log_match_length(single_value.n_elements);
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void Create__PDR_grouped__ie_FAR__ID__list_template::encode_text(Text_Buf& text_buf) const
{
encode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list.");
}
}

void Create__PDR_grouped__ie_FAR__ID__list_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list.");
single_value.value_elements = (FAR__ID_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new FAR__ID_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new Create__PDR_grouped__ie_FAR__ID__list_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list.");
}
}

boolean Create__PDR_grouped__ie_FAR__ID__list_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean Create__PDR_grouped__ie_FAR__ID__list_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void Create__PDR_grouped__ie_FAR__ID__list_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void Create__PDR_grouped__ie_FAR__ID__list_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "record of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    Create__PDR_grouped__ie_FAR__ID__list_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List: {
    set_size(param.get_size());
    int curr_idx = 0;
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      switch (param.get_elem(p_i)->get_type()) {
      case Module_Param::MP_NotUsed:
        curr_idx++;
        break;
      case Module_Param::MP_Permutation_Template: {
        int perm_start_idx = curr_idx;
        Module_Param* param_i = param.get_elem(p_i);
        for (size_t perm_i=0; perm_i<param_i->get_size(); perm_i++) {
          (*this)[curr_idx].set_param(*(param_i->get_elem(perm_i)));
          curr_idx++;
        }
        int perm_end_idx = curr_idx - 1;
        add_permutation(perm_start_idx, perm_end_idx);
      } break;
      default:
        (*this)[curr_idx].set_param(*param.get_elem(p_i));
        curr_idx++;
      }
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    Create__PDR_grouped__ie_FAR__ID__list_template* precondition = new Create__PDR_grouped__ie_FAR__ID__list_template;
    precondition->set_param(*param.get_elem(0));
    Create__PDR_grouped__ie_FAR__ID__list_template* implied_template = new Create__PDR_grouped__ie_FAR__ID__list_template;
    implied_template->set_param(*param.get_elem(1));
    *this = Create__PDR_grouped__ie_FAR__ID__list_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record of template", "@PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void Create__PDR_grouped__ie_FAR__ID__list_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@PFCP_Types.Create_PDR.grouped_ie.FAR_ID_list");
}

boolean Create__PDR_grouped__ie_FAR__ID__list_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return number_of_permutations;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
Create__PDR::Create__PDR()
{
}

Create__PDR::Create__PDR(const INTEGER& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const Create__PDR_grouped__ie& par_grouped__ie)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_grouped__ie(par_grouped__ie)
{
}

Create__PDR::Create__PDR(const Create__PDR& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @PFCP_Types.Create_PDR.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.grouped__ie().is_bound()) field_grouped__ie = other_value.grouped__ie();
else field_grouped__ie.clean_up();
}

void Create__PDR::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_grouped__ie.clean_up();
}

const TTCN_Typedescriptor_t* Create__PDR::get_descriptor() const { return &Create__PDR_descr_; }
Create__PDR& Create__PDR::operator=(const Create__PDR& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @PFCP_Types.Create_PDR.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.grouped__ie().is_bound()) field_grouped__ie = other_value.grouped__ie();
  else field_grouped__ie.clean_up();
}
return *this;
}

boolean Create__PDR::operator==(const Create__PDR& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_grouped__ie==other_value.field_grouped__ie;
}

boolean Create__PDR::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_grouped__ie.is_bound());
}
boolean Create__PDR::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_grouped__ie.is_value();
}
void Create__PDR::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", grouped_ie := ");
field_grouped__ie.log();
TTCN_Logger::log_event_str(" }");
}

void Create__PDR::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (grouped__ie().is_bound()) grouped__ie().set_implicit_omit();
}

void Create__PDR::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @PFCP_Types.Create_PDR has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) grouped__ie().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "grouped_ie")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          grouped__ie().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @PFCP_Types.Create_PDR: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@PFCP_Types.Create_PDR");
  }
}

void Create__PDR::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_grouped__ie.encode_text(text_buf);
}

void Create__PDR::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_grouped__ie.decode_text(text_buf);
}

void Create__PDR::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Create__PDR::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int Create__PDR::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::LIN2__BO__LAST_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::LIN2__BO__LAST_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, Create__PDR_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(Create__PDR_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(Create__PDR_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, Create__PDR_grouped__ie_descr_.raw->forceomit);
  decoded_field_length = field_grouped__ie.RAW_decode(Create__PDR_grouped__ie_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_elementIdentifier != 1) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int Create__PDR::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::LIN2__BO__LAST_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, Create__PDR_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, Create__PDR_grouped__ie_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::LIN2__BO__LAST_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 16;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &Create__PDR_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[1]->length = 16;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_grouped__ie.RAW_encode(Create__PDR_grouped__ie_descr_, *myleaf.body.node.nodes[2]);
  if (field_elementIdentifier != 1) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
  INTEGER new_val = 1;
  new_val.RAW_encode(General__Types::LIN2__BO__LAST_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct Create__PDR_template::single_value_struct {
INTEGER_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
Create__PDR_grouped__ie_template field_grouped__ie;
};

void Create__PDR_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_grouped__ie = ANY_VALUE;
}
}
}

void Create__PDR_template::copy_value(const Create__PDR& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.grouped__ie().is_bound()) {
  single_value->field_grouped__ie = other_value.grouped__ie();
} else {
  single_value->field_grouped__ie.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void Create__PDR_template::copy_template(const Create__PDR_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.grouped__ie().get_selection()) {
single_value->field_grouped__ie = other_value.grouped__ie();
} else {
single_value->field_grouped__ie.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Create__PDR_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Create__PDR_template(*other_value.implication_.precondition);
implication_.implied_template = new Create__PDR_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @PFCP_Types.Create_PDR.");
break;
}
set_selection(other_value);
}

Create__PDR_template::Create__PDR_template()
{
}

Create__PDR_template::Create__PDR_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

Create__PDR_template::Create__PDR_template(const Create__PDR& other_value)
{
copy_value(other_value);
}

Create__PDR_template::Create__PDR_template(const OPTIONAL<Create__PDR>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Create__PDR&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @PFCP_Types.Create_PDR from an unbound optional field.");
}
}

Create__PDR_template::Create__PDR_template(Create__PDR_template* p_precondition, Create__PDR_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

Create__PDR_template::Create__PDR_template(Dynamic_Match_Interface<Create__PDR>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<Create__PDR>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

Create__PDR_template::Create__PDR_template(const Create__PDR_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

Create__PDR_template::~Create__PDR_template()
{
clean_up();
}

Create__PDR_template& Create__PDR_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

Create__PDR_template& Create__PDR_template::operator=(const Create__PDR& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

Create__PDR_template& Create__PDR_template::operator=(const OPTIONAL<Create__PDR>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Create__PDR&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @PFCP_Types.Create_PDR.");
}
return *this;
}

Create__PDR_template& Create__PDR_template::operator=(const Create__PDR_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean Create__PDR_template::match(const Create__PDR& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.grouped__ie().is_bound()) return FALSE;
if(!single_value->field_grouped__ie.match(other_value.grouped__ie(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @PFCP_Types.Create_PDR.");
}
return FALSE;
}

boolean Create__PDR_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_grouped__ie.is_bound();
}

boolean Create__PDR_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_grouped__ie.is_value();
}

void Create__PDR_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

Create__PDR Create__PDR_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @PFCP_Types.Create_PDR.");
Create__PDR ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_grouped__ie.is_bound()) {
ret_val.grouped__ie() = single_value->field_grouped__ie.valueof();
}
return ret_val;
}

void Create__PDR_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @PFCP_Types.Create_PDR.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new Create__PDR_template[list_length];
}

Create__PDR_template& Create__PDR_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @PFCP_Types.Create_PDR.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @PFCP_Types.Create_PDR.");
return value_list.list_value[list_index];
}

INTEGER_template& Create__PDR_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const INTEGER_template& Create__PDR_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @PFCP_Types.Create_PDR.");
return single_value->field_elementIdentifier;
}

INTEGER_template& Create__PDR_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& Create__PDR_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @PFCP_Types.Create_PDR.");
return single_value->field_lengthIndicator;
}

Create__PDR_grouped__ie_template& Create__PDR_template::grouped__ie()
{
set_specific();
return single_value->field_grouped__ie;
}

const Create__PDR_grouped__ie_template& Create__PDR_template::grouped__ie() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field grouped_ie of a non-specific template of type @PFCP_Types.Create_PDR.");
return single_value->field_grouped__ie;
}

int Create__PDR_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_PDR which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @PFCP_Types.Create_PDR containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_PDR containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_PDR containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_PDR containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_PDR containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_PDR containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_PDR containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_PDR containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @PFCP_Types.Create_PDR.");
  }
  return 0;
}

void Create__PDR_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", grouped_ie := ");
single_value->field_grouped__ie.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void Create__PDR_template::log_match(const Create__PDR& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_grouped__ie.match(match_value.grouped__ie(), legacy)){
TTCN_Logger::log_logmatch_info(".grouped_ie");
single_value->field_grouped__ie.log_match(match_value.grouped__ie(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", grouped_ie := ");
single_value->field_grouped__ie.log_match(match_value.grouped__ie(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void Create__PDR_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (grouped__ie().is_bound()) grouped__ie().set_implicit_omit();
}

void Create__PDR_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_grouped__ie.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @PFCP_Types.Create_PDR.");
}
}

void Create__PDR_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_grouped__ie.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new Create__PDR_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @PFCP_Types.Create_PDR.");
}
}

void Create__PDR_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    Create__PDR_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @PFCP_Types.Create_PDR has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) grouped__ie().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "grouped_ie")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          grouped__ie().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @PFCP_Types.Create_PDR: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    Create__PDR_template* precondition = new Create__PDR_template;
    precondition->set_param(*param.get_elem(0));
    Create__PDR_template* implied_template = new Create__PDR_template;
    implied_template->set_param(*param.get_elem(1));
    *this = Create__PDR_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@PFCP_Types.Create_PDR");
  }
  is_ifpresent = param.get_ifpresent();
}

void Create__PDR_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_PDR");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_PDR");
single_value->field_grouped__ie.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_PDR");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@PFCP_Types.Create_PDR");
}

boolean Create__PDR_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean Create__PDR_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const Create__FAR Create__FAR__list::UNBOUND_ELEM;
Create__FAR__list::Create__FAR__list()
{
val_ptr = NULL;
}

Create__FAR__list::Create__FAR__list(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

Create__FAR__list::Create__FAR__list(const Create__FAR__list& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @PFCP_Types.Create_FAR_list.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

Create__FAR__list::~Create__FAR__list()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void Create__FAR__list::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

Create__FAR__list& Create__FAR__list::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

Create__FAR__list& Create__FAR__list::operator=(const Create__FAR__list& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @PFCP_Types.Create_FAR_list.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean Create__FAR__list::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @PFCP_Types.Create_FAR_list.");
return val_ptr->n_elements == 0 ;
}

boolean Create__FAR__list::operator==(const Create__FAR__list& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @PFCP_Types.Create_FAR_list.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @PFCP_Types.Create_FAR_list.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

Create__FAR& Create__FAR__list::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @PFCP_Types.Create_FAR_list using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (Create__FAR**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new Create__FAR(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new Create__FAR;
}
return *val_ptr->value_elements[index_value];
}

Create__FAR& Create__FAR__list::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @PFCP_Types.Create_FAR_list.");
return (*this)[(int)index_value];
}

const Create__FAR& Create__FAR__list::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @PFCP_Types.Create_FAR_list.");
if (index_value < 0) TTCN_error("Accessing an element of type @PFCP_Types.Create_FAR_list using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @PFCP_Types.Create_FAR_list: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const Create__FAR& Create__FAR__list::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @PFCP_Types.Create_FAR_list.");
return (*this)[(int)index_value];
}

Create__FAR__list Create__FAR__list::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

Create__FAR__list Create__FAR__list::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

Create__FAR__list Create__FAR__list::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

Create__FAR__list Create__FAR__list::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @PFCP_Types.Create_FAR_list.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
Create__FAR__list ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new Create__FAR(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

Create__FAR__list Create__FAR__list::operator+(const Create__FAR__list& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @PFCP_Types.Create_FAR_list concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
Create__FAR__list ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new Create__FAR(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new Create__FAR(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

Create__FAR__list Create__FAR__list::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @PFCP_Types.Create_FAR_list.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@PFCP_Types.Create_FAR_list","element");
Create__FAR__list ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new Create__FAR(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

Create__FAR__list Create__FAR__list::replace(int index, int len, const Create__FAR__list& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @PFCP_Types.Create_FAR_list.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @PFCP_Types.Create_FAR_list.");
check_replace_arguments(val_ptr->n_elements, index, len, "@PFCP_Types.Create_FAR_list","element");
Create__FAR__list ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new Create__FAR(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new Create__FAR(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new Create__FAR(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

Create__FAR__list Create__FAR__list::replace(int index, int len, const Create__FAR__list_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void Create__FAR__list::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @PFCP_Types.Create_FAR_list.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (Create__FAR**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new Create__FAR(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (Create__FAR**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @PFCP_Types.Create_FAR_list: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (Create__FAR**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean Create__FAR__list::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int Create__FAR__list::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @PFCP_Types.Create_FAR_list.");
return val_ptr->n_elements;
}

int Create__FAR__list::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @PFCP_Types.Create_FAR_list.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void Create__FAR__list::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void Create__FAR__list::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void Create__FAR__list::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@PFCP_Types.Create_FAR_list");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@PFCP_Types.Create_FAR_list");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void Create__FAR__list::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @PFCP_Types.Create_FAR_list.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void Create__FAR__list::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @PFCP_Types.Create_FAR_list.");
val_ptr->value_elements = (Create__FAR**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new Create__FAR;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void Create__FAR__list::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Create__FAR__list::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int Create__FAR__list::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean /*no_err*/, int sel_field, boolean first_call, const RAW_Force_Omit*){
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int decoded_field_length=0;
  size_t start_of_field=0;
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int start_field=val_ptr->n_elements;
  if(p_td.raw->fieldlength || sel_field!=-1){
    int a=0;
    if(sel_field==-1) sel_field=p_td.raw->fieldlength;
    start_of_field=p_buf.get_pos_bit();
    for(a=0;a<sel_field;a++){
      decoded_field_length=(*this)[a+start_field].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        while(a>=0){
          delete &(*this)[a+start_field];
          a--;
          val_ptr->n_elements--;
        }
        p_buf.set_pos_bit(start_of_field);
        return decoded_field_length;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
    }
    if(a==0) val_ptr->n_elements=0;
  } else {
    if(limit==0){
      if(!first_call) return -1;
      val_ptr->n_elements=0;
      return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
    }
    int a=start_field;
    while(limit>0){
      start_of_field=p_buf.get_pos_bit();
      decoded_field_length=(*this)[a].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        delete &(*this)[a];
        val_ptr->n_elements--;
        p_buf.set_pos_bit(start_of_field);
        if(a>start_field){
        return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
        } else return -1;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
      a++;
    }
  }
 return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
}

int Create__FAR__list::RAW_encode(const TTCN_Typedescriptor_t& p_td,RAW_enc_tree& myleaf) const{
  int encoded_length=0;
  int encoded_num_of_records=p_td.raw->fieldlength?smaller(val_ptr->n_elements, p_td.raw->fieldlength):val_ptr->n_elements;
  myleaf.isleaf=FALSE;
  myleaf.rec_of=TRUE;
  myleaf.body.node.num_of_nodes=encoded_num_of_records;
  myleaf.body.node.nodes=init_nodes_of_enc_tree(encoded_num_of_records);
  for(int a=0;a<encoded_num_of_records;a++){
    myleaf.body.node.nodes[a]=new RAW_enc_tree(TRUE,&myleaf,&(myleaf.curr_pos),a,p_td.oftype_descr->raw);
    encoded_length+=(*this)[a].RAW_encode(*p_td.oftype_descr,*myleaf.body.node.nodes[a]);
  }
 return myleaf.length=encoded_length;
}

void Create__FAR__list_template::copy_value(const Create__FAR__list& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @PFCP_Types.Create_FAR_list with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (Create__FAR_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new Create__FAR_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new Create__FAR_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void Create__FAR__list_template::copy_template(const Create__FAR__list_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (Create__FAR_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new Create__FAR_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new Create__FAR_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Create__FAR__list_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Create__FAR__list_template(*other_value.implication_.precondition);
implication_.implied_template = new Create__FAR__list_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @PFCP_Types.Create_FAR_list.");
break;
}
set_selection(other_value);
}

boolean Create__FAR__list_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const Create__FAR__list_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const Create__FAR__list*)value_ptr)[value_index], legacy);
else return ((const Create__FAR__list_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

Create__FAR__list_template::Create__FAR__list_template()
{
}

Create__FAR__list_template::Create__FAR__list_template(template_sel other_value)
 : Base_Record_Of_Template(other_value)
{
check_single_selection(other_value);
}

Create__FAR__list_template::Create__FAR__list_template(null_type)
 : Base_Record_Of_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

Create__FAR__list_template::Create__FAR__list_template(const Create__FAR__list& other_value)
{
copy_value(other_value);
}

Create__FAR__list_template::Create__FAR__list_template(const OPTIONAL<Create__FAR__list>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Create__FAR__list&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @PFCP_Types.Create_FAR_list from an unbound optional field.");
}
}

Create__FAR__list_template::Create__FAR__list_template(Create__FAR__list_template* p_precondition, Create__FAR__list_template* p_implied_template)
 : Base_Record_Of_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

Create__FAR__list_template::Create__FAR__list_template(Dynamic_Match_Interface<Create__FAR__list>* p_dyn_match)
 : Base_Record_Of_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<Create__FAR__list>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

Create__FAR__list_template::Create__FAR__list_template(const Create__FAR__list_template& other_value)
 : Base_Record_Of_Template()
{
copy_template(other_value);
}

Create__FAR__list_template::~Create__FAR__list_template()
{
clean_up();
}

void Create__FAR__list_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

Create__FAR__list_template& Create__FAR__list_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

Create__FAR__list_template& Create__FAR__list_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

Create__FAR__list_template& Create__FAR__list_template::operator=(const Create__FAR__list& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

Create__FAR__list_template& Create__FAR__list_template::operator=(const OPTIONAL<Create__FAR__list>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Create__FAR__list&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @PFCP_Types.Create_FAR_list.");
}
return *this;
}

Create__FAR__list_template& Create__FAR__list_template::operator=(const Create__FAR__list_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

Create__FAR_template& Create__FAR__list_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @PFCP_Types.Create_FAR_list using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @PFCP_Types.Create_FAR_list.");
    break;
}
return *single_value.value_elements[index_value];
}

Create__FAR_template& Create__FAR__list_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @PFCP_Types.Create_FAR_list.");
return (*this)[(int)index_value];
}

const Create__FAR_template& Create__FAR__list_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @PFCP_Types.Create_FAR_list using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @PFCP_Types.Create_FAR_list.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @PFCP_Types.Create_FAR_list: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const Create__FAR_template& Create__FAR__list_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @PFCP_Types.Create_FAR_list.");
return (*this)[(int)index_value];
}

void Create__FAR__list_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @PFCP_Types.Create_FAR_list.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (Create__FAR_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new Create__FAR_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new Create__FAR_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (Create__FAR_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int Create__FAR__list_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int Create__FAR__list_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @PFCP_Types.Create_FAR_list which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @PFCP_Types.Create_FAR_list containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @PFCP_Types.Create_FAR_list containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @PFCP_Types.Create_FAR_list containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @PFCP_Types.Create_FAR_list containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @PFCP_Types.Create_FAR_list containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @PFCP_Types.Create_FAR_list.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @PFCP_Types.Create_FAR_list");
}

boolean Create__FAR__list_template::match(const Create__FAR__list& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_record_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @PFCP_Types.Create_FAR_list.");
}
return FALSE;
}

boolean Create__FAR__list_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

Create__FAR__list Create__FAR__list_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @PFCP_Types.Create_FAR_list.");
Create__FAR__list ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

Create__FAR__list Create__FAR__list_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

Create__FAR__list Create__FAR__list_template::replace(int index, int len, const Create__FAR__list_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

Create__FAR__list Create__FAR__list_template::replace(int index, int len, const Create__FAR__list& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void Create__FAR__list_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new Create__FAR__list_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @PFCP_Types.Create_FAR_list.");
}
set_selection(template_type);
}

Create__FAR__list_template& Create__FAR__list_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @PFCP_Types.Create_FAR_list.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @PFCP_Types.Create_FAR_list.");
return value_list.list_value[list_index];
}

void Create__FAR__list_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
if (permutation_starts_at(elem_count)) TTCN_Logger::log_event_str("permutation(");
single_value.value_elements[elem_count]->log();
if (permutation_ends_at(elem_count)) TTCN_Logger::log_char(')');
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void Create__FAR__list_template::log_match(const Create__FAR__list& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if(!single_value.value_elements[elem_count]->match(match_value[elem_count], legacy)){
TTCN_Logger::log_logmatch_info("[%d]", elem_count);
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
log_match_length(single_value.n_elements);
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
}
TTCN_Logger::log_event_str(" }");
log_match_length(single_value.n_elements);
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void Create__FAR__list_template::encode_text(Text_Buf& text_buf) const
{
encode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @PFCP_Types.Create_FAR_list.");
}
}

void Create__FAR__list_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @PFCP_Types.Create_FAR_list.");
single_value.value_elements = (Create__FAR_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new Create__FAR_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new Create__FAR__list_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @PFCP_Types.Create_FAR_list.");
}
}

boolean Create__FAR__list_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean Create__FAR__list_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void Create__FAR__list_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void Create__FAR__list_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "record of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    Create__FAR__list_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List: {
    set_size(param.get_size());
    int curr_idx = 0;
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      switch (param.get_elem(p_i)->get_type()) {
      case Module_Param::MP_NotUsed:
        curr_idx++;
        break;
      case Module_Param::MP_Permutation_Template: {
        int perm_start_idx = curr_idx;
        Module_Param* param_i = param.get_elem(p_i);
        for (size_t perm_i=0; perm_i<param_i->get_size(); perm_i++) {
          (*this)[curr_idx].set_param(*(param_i->get_elem(perm_i)));
          curr_idx++;
        }
        int perm_end_idx = curr_idx - 1;
        add_permutation(perm_start_idx, perm_end_idx);
      } break;
      default:
        (*this)[curr_idx].set_param(*param.get_elem(p_i));
        curr_idx++;
      }
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    Create__FAR__list_template* precondition = new Create__FAR__list_template;
    precondition->set_param(*param.get_elem(0));
    Create__FAR__list_template* implied_template = new Create__FAR__list_template;
    implied_template->set_param(*param.get_elem(1));
    *this = Create__FAR__list_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record of template", "@PFCP_Types.Create_FAR_list");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void Create__FAR__list_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_FAR_list");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@PFCP_Types.Create_FAR_list");
}

boolean Create__FAR__list_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return number_of_permutations;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
Create__FAR_grouped__ie::Create__FAR_grouped__ie()
{
}

Create__FAR_grouped__ie::Create__FAR_grouped__ie(const FAR__ID& par_far__id,
    const Apply__Action& par_apply__action,
    const OPTIONAL< Forwarding__Parameters >& par_forwarding__parameters,
    const OPTIONAL< Duplicating__Parameters >& par_duplicating__parameters,
    const OPTIONAL< BAR__ID >& par_bar__id)
  :   field_far__id(par_far__id),
  field_apply__action(par_apply__action),
  field_forwarding__parameters(par_forwarding__parameters),
  field_duplicating__parameters(par_duplicating__parameters),
  field_bar__id(par_bar__id)
{
}

Create__FAR_grouped__ie::Create__FAR_grouped__ie(const Create__FAR_grouped__ie& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @PFCP_Types.Create_FAR.grouped_ie.");
if (other_value.far__id().is_bound()) field_far__id = other_value.far__id();
else field_far__id.clean_up();
if (other_value.apply__action().is_bound()) field_apply__action = other_value.apply__action();
else field_apply__action.clean_up();
if (other_value.forwarding__parameters().is_bound()) field_forwarding__parameters = other_value.forwarding__parameters();
else field_forwarding__parameters.clean_up();
if (other_value.duplicating__parameters().is_bound()) field_duplicating__parameters = other_value.duplicating__parameters();
else field_duplicating__parameters.clean_up();
if (other_value.bar__id().is_bound()) field_bar__id = other_value.bar__id();
else field_bar__id.clean_up();
}

void Create__FAR_grouped__ie::clean_up()
{
field_far__id.clean_up();
field_apply__action.clean_up();
field_forwarding__parameters.clean_up();
field_duplicating__parameters.clean_up();
field_bar__id.clean_up();
}

const TTCN_Typedescriptor_t* Create__FAR_grouped__ie::get_descriptor() const { return &Create__FAR_grouped__ie_descr_; }
Create__FAR_grouped__ie& Create__FAR_grouped__ie::operator=(const Create__FAR_grouped__ie& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @PFCP_Types.Create_FAR.grouped_ie.");
  if (other_value.far__id().is_bound()) field_far__id = other_value.far__id();
  else field_far__id.clean_up();
  if (other_value.apply__action().is_bound()) field_apply__action = other_value.apply__action();
  else field_apply__action.clean_up();
  if (other_value.forwarding__parameters().is_bound()) field_forwarding__parameters = other_value.forwarding__parameters();
  else field_forwarding__parameters.clean_up();
  if (other_value.duplicating__parameters().is_bound()) field_duplicating__parameters = other_value.duplicating__parameters();
  else field_duplicating__parameters.clean_up();
  if (other_value.bar__id().is_bound()) field_bar__id = other_value.bar__id();
  else field_bar__id.clean_up();
}
return *this;
}

boolean Create__FAR_grouped__ie::operator==(const Create__FAR_grouped__ie& other_value) const
{
return field_far__id==other_value.field_far__id
  && field_apply__action==other_value.field_apply__action
  && field_forwarding__parameters==other_value.field_forwarding__parameters
  && field_duplicating__parameters==other_value.field_duplicating__parameters
  && field_bar__id==other_value.field_bar__id;
}

boolean Create__FAR_grouped__ie::is_bound() const
{
return (field_far__id.is_bound())
  || (field_apply__action.is_bound())
  || (OPTIONAL_OMIT == field_forwarding__parameters.get_selection() || field_forwarding__parameters.is_bound())
  || (OPTIONAL_OMIT == field_duplicating__parameters.get_selection() || field_duplicating__parameters.is_bound())
  || (OPTIONAL_OMIT == field_bar__id.get_selection() || field_bar__id.is_bound());
}
boolean Create__FAR_grouped__ie::is_value() const
{
return field_far__id.is_value()
  && field_apply__action.is_value()
  && (OPTIONAL_OMIT == field_forwarding__parameters.get_selection() || field_forwarding__parameters.is_value())
  && (OPTIONAL_OMIT == field_duplicating__parameters.get_selection() || field_duplicating__parameters.is_value())
  && (OPTIONAL_OMIT == field_bar__id.get_selection() || field_bar__id.is_value());
}
int Create__FAR_grouped__ie::size_of() const
{
  int ret_val = 2;
  if (field_forwarding__parameters.ispresent()) ret_val++;
  if (field_duplicating__parameters.ispresent()) ret_val++;
  if (field_bar__id.ispresent()) ret_val++;
  return ret_val;
}

void Create__FAR_grouped__ie::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ far_id := ");
field_far__id.log();
TTCN_Logger::log_event_str(", apply_action := ");
field_apply__action.log();
TTCN_Logger::log_event_str(", forwarding_parameters := ");
field_forwarding__parameters.log();
TTCN_Logger::log_event_str(", duplicating_parameters := ");
field_duplicating__parameters.log();
TTCN_Logger::log_event_str(", bar_id := ");
field_bar__id.log();
TTCN_Logger::log_event_str(" }");
}

void Create__FAR_grouped__ie::set_implicit_omit()
{
if (far__id().is_bound()) far__id().set_implicit_omit();
if (apply__action().is_bound()) apply__action().set_implicit_omit();
if (!forwarding__parameters().is_bound()) forwarding__parameters() = OMIT_VALUE;
else forwarding__parameters().set_implicit_omit();
if (!duplicating__parameters().is_bound()) duplicating__parameters() = OMIT_VALUE;
else duplicating__parameters().set_implicit_omit();
if (!bar__id().is_bound()) bar__id() = OMIT_VALUE;
else bar__id().set_implicit_omit();
}

void Create__FAR_grouped__ie::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "set value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("set value of type @PFCP_Types.Create_FAR.grouped_ie has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) far__id().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) apply__action().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) forwarding__parameters().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) duplicating__parameters().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) bar__id().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "far_id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          far__id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "apply_action")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          apply__action().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "forwarding_parameters")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          forwarding__parameters().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "duplicating_parameters")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          duplicating__parameters().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bar_id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bar__id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @PFCP_Types.Create_FAR.grouped_ie: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("set value", "@PFCP_Types.Create_FAR.grouped_ie");
  }
}

void Create__FAR_grouped__ie::encode_text(Text_Buf& text_buf) const
{
field_far__id.encode_text(text_buf);
field_apply__action.encode_text(text_buf);
field_forwarding__parameters.encode_text(text_buf);
field_duplicating__parameters.encode_text(text_buf);
field_bar__id.encode_text(text_buf);
}

void Create__FAR_grouped__ie::decode_text(Text_Buf& text_buf)
{
field_far__id.decode_text(text_buf);
field_apply__action.decode_text(text_buf);
field_forwarding__parameters.decode_text(text_buf);
field_duplicating__parameters.decode_text(text_buf);
field_bar__id.decode_text(text_buf);
}

void Create__FAR_grouped__ie::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Create__FAR_grouped__ie::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int Create__FAR_grouped__ie::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean, int, boolean, const RAW_Force_Omit* force_omit)
{
int prepaddlength = p_buf.increase_pos_padd(p_td.raw->prepadding);
limit -= prepaddlength;
int decoded_length = 0;
int field_map[5];
memset(field_map, 0, sizeof(field_map));
size_t nof_mand_fields = 0;
field_forwarding__parameters = OMIT_VALUE;
field_duplicating__parameters = OMIT_VALUE;
field_bar__id = OMIT_VALUE;
raw_order_t local_top_order;
if (p_td.raw->top_bit_order == TOP_BIT_INHERITED) local_top_order = top_bit_ord;
else if (p_td.raw->top_bit_order == TOP_BIT_RIGHT) local_top_order = ORDER_MSB;
else local_top_order = ORDER_LSB;
while (limit > 0) {
size_t fl_start_pos = p_buf.get_pos_bit();
if (field_map[0] == 0) {
RAW_Force_Omit field_0_force_omit(0, force_omit, FAR__ID_descr_.raw->forceomit);
int decoded_field_length = field_far__id.RAW_decode(FAR__ID_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_0_force_omit);
if (decoded_field_length >= 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
nof_mand_fields++;
field_map[0] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
}
}
if (field_map[1] == 0) {
RAW_Force_Omit field_1_force_omit(1, force_omit, Apply__Action_descr_.raw->forceomit);
int decoded_field_length = field_apply__action.RAW_decode(Apply__Action_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_1_force_omit);
if (decoded_field_length >= 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
nof_mand_fields++;
field_map[1] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
}
}
if (field_map[2] == 0 && (force_omit == NULL || !(*force_omit)(2))) {
RAW_Force_Omit field_2_force_omit(2, force_omit, Forwarding__Parameters_descr_.raw->forceomit);
int decoded_field_length = field_forwarding__parameters().RAW_decode(Forwarding__Parameters_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[2] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_forwarding__parameters = OMIT_VALUE;
}
}
if (field_map[3] == 0 && (force_omit == NULL || !(*force_omit)(3))) {
RAW_Force_Omit field_3_force_omit(3, force_omit, Duplicating__Parameters_descr_.raw->forceomit);
int decoded_field_length = field_duplicating__parameters().RAW_decode(Duplicating__Parameters_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[3] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_duplicating__parameters = OMIT_VALUE;
}
}
if (field_map[4] == 0 && (force_omit == NULL || !(*force_omit)(4))) {
RAW_Force_Omit field_4_force_omit(4, force_omit, BAR__ID_descr_.raw->forceomit);
int decoded_field_length = field_bar__id().RAW_decode(BAR__ID_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_4_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[4] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_bar__id = OMIT_VALUE;
}
}
break;
}
if (nof_mand_fields != 2) return limit ? -1 : -TTCN_EncDec::ET_INCOMPL_MSG;
return decoded_length + prepaddlength + p_buf.increase_pos_padd(p_td.raw->padding);
}

int Create__FAR_grouped__ie::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, FAR__ID_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, Apply__Action_descr_.raw);
  if (field_forwarding__parameters.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, Forwarding__Parameters_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  if (field_duplicating__parameters.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, Duplicating__Parameters_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  if (field_bar__id.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, BAR__ID_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  encoded_length += field_far__id.RAW_encode(FAR__ID_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_apply__action.RAW_encode(Apply__Action_descr_, *myleaf.body.node.nodes[1]);
  if (field_forwarding__parameters.ispresent()) {
  encoded_length += field_forwarding__parameters().RAW_encode(Forwarding__Parameters_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_duplicating__parameters.ispresent()) {
  encoded_length += field_duplicating__parameters().RAW_encode(Duplicating__Parameters_descr_, *myleaf.body.node.nodes[3]);
  }
  if (field_bar__id.ispresent()) {
  encoded_length += field_bar__id().RAW_encode(BAR__ID_descr_, *myleaf.body.node.nodes[4]);
  }
  return myleaf.length = encoded_length;
}

struct Create__FAR_grouped__ie_template::single_value_struct {
FAR__ID_template field_far__id;
Apply__Action_template field_apply__action;
Forwarding__Parameters_template field_forwarding__parameters;
Duplicating__Parameters_template field_duplicating__parameters;
BAR__ID_template field_bar__id;
};

void Create__FAR_grouped__ie_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_far__id = ANY_VALUE;
single_value->field_apply__action = ANY_VALUE;
single_value->field_forwarding__parameters = ANY_OR_OMIT;
single_value->field_duplicating__parameters = ANY_OR_OMIT;
single_value->field_bar__id = ANY_OR_OMIT;
}
}
}

void Create__FAR_grouped__ie_template::copy_value(const Create__FAR_grouped__ie& other_value)
{
single_value = new single_value_struct;
if (other_value.far__id().is_bound()) {
  single_value->field_far__id = other_value.far__id();
} else {
  single_value->field_far__id.clean_up();
}
if (other_value.apply__action().is_bound()) {
  single_value->field_apply__action = other_value.apply__action();
} else {
  single_value->field_apply__action.clean_up();
}
if (other_value.forwarding__parameters().is_bound()) {
  if (other_value.forwarding__parameters().ispresent()) single_value->field_forwarding__parameters = other_value.forwarding__parameters()();
  else single_value->field_forwarding__parameters = OMIT_VALUE;
} else {
  single_value->field_forwarding__parameters.clean_up();
}
if (other_value.duplicating__parameters().is_bound()) {
  if (other_value.duplicating__parameters().ispresent()) single_value->field_duplicating__parameters = other_value.duplicating__parameters()();
  else single_value->field_duplicating__parameters = OMIT_VALUE;
} else {
  single_value->field_duplicating__parameters.clean_up();
}
if (other_value.bar__id().is_bound()) {
  if (other_value.bar__id().ispresent()) single_value->field_bar__id = other_value.bar__id()();
  else single_value->field_bar__id = OMIT_VALUE;
} else {
  single_value->field_bar__id.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void Create__FAR_grouped__ie_template::copy_template(const Create__FAR_grouped__ie_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.far__id().get_selection()) {
single_value->field_far__id = other_value.far__id();
} else {
single_value->field_far__id.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.apply__action().get_selection()) {
single_value->field_apply__action = other_value.apply__action();
} else {
single_value->field_apply__action.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.forwarding__parameters().get_selection()) {
single_value->field_forwarding__parameters = other_value.forwarding__parameters();
} else {
single_value->field_forwarding__parameters.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.duplicating__parameters().get_selection()) {
single_value->field_duplicating__parameters = other_value.duplicating__parameters();
} else {
single_value->field_duplicating__parameters.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.bar__id().get_selection()) {
single_value->field_bar__id = other_value.bar__id();
} else {
single_value->field_bar__id.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Create__FAR_grouped__ie_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Create__FAR_grouped__ie_template(*other_value.implication_.precondition);
implication_.implied_template = new Create__FAR_grouped__ie_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @PFCP_Types.Create_FAR.grouped_ie.");
break;
}
set_selection(other_value);
}

Create__FAR_grouped__ie_template::Create__FAR_grouped__ie_template()
{
}

Create__FAR_grouped__ie_template::Create__FAR_grouped__ie_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

Create__FAR_grouped__ie_template::Create__FAR_grouped__ie_template(const Create__FAR_grouped__ie& other_value)
{
copy_value(other_value);
}

Create__FAR_grouped__ie_template::Create__FAR_grouped__ie_template(const OPTIONAL<Create__FAR_grouped__ie>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Create__FAR_grouped__ie&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @PFCP_Types.Create_FAR.grouped_ie from an unbound optional field.");
}
}

Create__FAR_grouped__ie_template::Create__FAR_grouped__ie_template(Create__FAR_grouped__ie_template* p_precondition, Create__FAR_grouped__ie_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

Create__FAR_grouped__ie_template::Create__FAR_grouped__ie_template(Dynamic_Match_Interface<Create__FAR_grouped__ie>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<Create__FAR_grouped__ie>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

Create__FAR_grouped__ie_template::Create__FAR_grouped__ie_template(const Create__FAR_grouped__ie_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

Create__FAR_grouped__ie_template::~Create__FAR_grouped__ie_template()
{
clean_up();
}

Create__FAR_grouped__ie_template& Create__FAR_grouped__ie_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

Create__FAR_grouped__ie_template& Create__FAR_grouped__ie_template::operator=(const Create__FAR_grouped__ie& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

Create__FAR_grouped__ie_template& Create__FAR_grouped__ie_template::operator=(const OPTIONAL<Create__FAR_grouped__ie>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Create__FAR_grouped__ie&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @PFCP_Types.Create_FAR.grouped_ie.");
}
return *this;
}

Create__FAR_grouped__ie_template& Create__FAR_grouped__ie_template::operator=(const Create__FAR_grouped__ie_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean Create__FAR_grouped__ie_template::match(const Create__FAR_grouped__ie& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.far__id().is_bound()) return FALSE;
if(!single_value->field_far__id.match(other_value.far__id(), legacy))return FALSE;
if(!other_value.apply__action().is_bound()) return FALSE;
if(!single_value->field_apply__action.match(other_value.apply__action(), legacy))return FALSE;
if(!other_value.forwarding__parameters().is_bound()) return FALSE;
if((other_value.forwarding__parameters().ispresent() ? !single_value->field_forwarding__parameters.match((const Forwarding__Parameters&)other_value.forwarding__parameters(), legacy) : !single_value->field_forwarding__parameters.match_omit(legacy)))return FALSE;
if(!other_value.duplicating__parameters().is_bound()) return FALSE;
if((other_value.duplicating__parameters().ispresent() ? !single_value->field_duplicating__parameters.match((const Duplicating__Parameters&)other_value.duplicating__parameters(), legacy) : !single_value->field_duplicating__parameters.match_omit(legacy)))return FALSE;
if(!other_value.bar__id().is_bound()) return FALSE;
if((other_value.bar__id().ispresent() ? !single_value->field_bar__id.match((const BAR__ID&)other_value.bar__id(), legacy) : !single_value->field_bar__id.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @PFCP_Types.Create_FAR.grouped_ie.");
}
return FALSE;
}

boolean Create__FAR_grouped__ie_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_far__id.is_bound()
 || single_value->field_apply__action.is_bound()
 || (single_value->field_forwarding__parameters.is_omit() || single_value->field_forwarding__parameters.is_bound())
 || (single_value->field_duplicating__parameters.is_omit() || single_value->field_duplicating__parameters.is_bound())
 || (single_value->field_bar__id.is_omit() || single_value->field_bar__id.is_bound());
}

boolean Create__FAR_grouped__ie_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_far__id.is_value()
 && single_value->field_apply__action.is_value()
 && (single_value->field_forwarding__parameters.is_omit() || single_value->field_forwarding__parameters.is_value())
 && (single_value->field_duplicating__parameters.is_omit() || single_value->field_duplicating__parameters.is_value())
 && (single_value->field_bar__id.is_omit() || single_value->field_bar__id.is_value());
}

void Create__FAR_grouped__ie_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

Create__FAR_grouped__ie Create__FAR_grouped__ie_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @PFCP_Types.Create_FAR.grouped_ie.");
Create__FAR_grouped__ie ret_val;
if (single_value->field_far__id.is_bound()) {
ret_val.far__id() = single_value->field_far__id.valueof();
}
if (single_value->field_apply__action.is_bound()) {
ret_val.apply__action() = single_value->field_apply__action.valueof();
}
if (single_value->field_forwarding__parameters.is_omit()) ret_val.forwarding__parameters() = OMIT_VALUE;
else if (single_value->field_forwarding__parameters.is_bound()) {
ret_val.forwarding__parameters() = single_value->field_forwarding__parameters.valueof();
}
if (single_value->field_duplicating__parameters.is_omit()) ret_val.duplicating__parameters() = OMIT_VALUE;
else if (single_value->field_duplicating__parameters.is_bound()) {
ret_val.duplicating__parameters() = single_value->field_duplicating__parameters.valueof();
}
if (single_value->field_bar__id.is_omit()) ret_val.bar__id() = OMIT_VALUE;
else if (single_value->field_bar__id.is_bound()) {
ret_val.bar__id() = single_value->field_bar__id.valueof();
}
return ret_val;
}

void Create__FAR_grouped__ie_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @PFCP_Types.Create_FAR.grouped_ie.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new Create__FAR_grouped__ie_template[list_length];
}

Create__FAR_grouped__ie_template& Create__FAR_grouped__ie_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @PFCP_Types.Create_FAR.grouped_ie.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @PFCP_Types.Create_FAR.grouped_ie.");
return value_list.list_value[list_index];
}

FAR__ID_template& Create__FAR_grouped__ie_template::far__id()
{
set_specific();
return single_value->field_far__id;
}

const FAR__ID_template& Create__FAR_grouped__ie_template::far__id() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field far_id of a non-specific template of type @PFCP_Types.Create_FAR.grouped_ie.");
return single_value->field_far__id;
}

Apply__Action_template& Create__FAR_grouped__ie_template::apply__action()
{
set_specific();
return single_value->field_apply__action;
}

const Apply__Action_template& Create__FAR_grouped__ie_template::apply__action() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field apply_action of a non-specific template of type @PFCP_Types.Create_FAR.grouped_ie.");
return single_value->field_apply__action;
}

Forwarding__Parameters_template& Create__FAR_grouped__ie_template::forwarding__parameters()
{
set_specific();
return single_value->field_forwarding__parameters;
}

const Forwarding__Parameters_template& Create__FAR_grouped__ie_template::forwarding__parameters() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field forwarding_parameters of a non-specific template of type @PFCP_Types.Create_FAR.grouped_ie.");
return single_value->field_forwarding__parameters;
}

Duplicating__Parameters_template& Create__FAR_grouped__ie_template::duplicating__parameters()
{
set_specific();
return single_value->field_duplicating__parameters;
}

const Duplicating__Parameters_template& Create__FAR_grouped__ie_template::duplicating__parameters() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field duplicating_parameters of a non-specific template of type @PFCP_Types.Create_FAR.grouped_ie.");
return single_value->field_duplicating__parameters;
}

BAR__ID_template& Create__FAR_grouped__ie_template::bar__id()
{
set_specific();
return single_value->field_bar__id;
}

const BAR__ID_template& Create__FAR_grouped__ie_template::bar__id() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field bar_id of a non-specific template of type @PFCP_Types.Create_FAR.grouped_ie.");
return single_value->field_bar__id;
}

int Create__FAR_grouped__ie_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_FAR.grouped_ie which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 2;
      if (single_value->field_forwarding__parameters.is_present()) ret_val++;
      if (single_value->field_duplicating__parameters.is_present()) ret_val++;
      if (single_value->field_bar__id.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @PFCP_Types.Create_FAR.grouped_ie containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_FAR.grouped_ie containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_FAR.grouped_ie containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_FAR.grouped_ie containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_FAR.grouped_ie containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_FAR.grouped_ie containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_FAR.grouped_ie containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_FAR.grouped_ie containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @PFCP_Types.Create_FAR.grouped_ie.");
  }
  return 0;
}

void Create__FAR_grouped__ie_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ far_id := ");
single_value->field_far__id.log();
TTCN_Logger::log_event_str(", apply_action := ");
single_value->field_apply__action.log();
TTCN_Logger::log_event_str(", forwarding_parameters := ");
single_value->field_forwarding__parameters.log();
TTCN_Logger::log_event_str(", duplicating_parameters := ");
single_value->field_duplicating__parameters.log();
TTCN_Logger::log_event_str(", bar_id := ");
single_value->field_bar__id.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void Create__FAR_grouped__ie_template::log_match(const Create__FAR_grouped__ie& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_far__id.match(match_value.far__id(), legacy)){
TTCN_Logger::log_logmatch_info(".far_id");
single_value->field_far__id.log_match(match_value.far__id(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_apply__action.match(match_value.apply__action(), legacy)){
TTCN_Logger::log_logmatch_info(".apply_action");
single_value->field_apply__action.log_match(match_value.apply__action(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.forwarding__parameters().ispresent()){
if(!single_value->field_forwarding__parameters.match(match_value.forwarding__parameters(), legacy)){
TTCN_Logger::log_logmatch_info(".forwarding_parameters");
single_value->field_forwarding__parameters.log_match(match_value.forwarding__parameters(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_forwarding__parameters.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".forwarding_parameters := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_forwarding__parameters.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.duplicating__parameters().ispresent()){
if(!single_value->field_duplicating__parameters.match(match_value.duplicating__parameters(), legacy)){
TTCN_Logger::log_logmatch_info(".duplicating_parameters");
single_value->field_duplicating__parameters.log_match(match_value.duplicating__parameters(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_duplicating__parameters.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".duplicating_parameters := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_duplicating__parameters.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.bar__id().ispresent()){
if(!single_value->field_bar__id.match(match_value.bar__id(), legacy)){
TTCN_Logger::log_logmatch_info(".bar_id");
single_value->field_bar__id.log_match(match_value.bar__id(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_bar__id.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".bar_id := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_bar__id.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ far_id := ");
single_value->field_far__id.log_match(match_value.far__id(), legacy);
TTCN_Logger::log_event_str(", apply_action := ");
single_value->field_apply__action.log_match(match_value.apply__action(), legacy);
TTCN_Logger::log_event_str(", forwarding_parameters := ");
if (match_value.forwarding__parameters().ispresent()) {
single_value->field_forwarding__parameters.log_match(match_value.forwarding__parameters(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_forwarding__parameters.log();
if (single_value->field_forwarding__parameters.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", duplicating_parameters := ");
if (match_value.duplicating__parameters().ispresent()) {
single_value->field_duplicating__parameters.log_match(match_value.duplicating__parameters(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_duplicating__parameters.log();
if (single_value->field_duplicating__parameters.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", bar_id := ");
if (match_value.bar__id().ispresent()) {
single_value->field_bar__id.log_match(match_value.bar__id(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_bar__id.log();
if (single_value->field_bar__id.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void Create__FAR_grouped__ie_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (far__id().is_bound()) far__id().set_implicit_omit();
if (apply__action().is_bound()) apply__action().set_implicit_omit();
if (!forwarding__parameters().is_bound()) forwarding__parameters() = OMIT_VALUE;
else forwarding__parameters().set_implicit_omit();
if (!duplicating__parameters().is_bound()) duplicating__parameters() = OMIT_VALUE;
else duplicating__parameters().set_implicit_omit();
if (!bar__id().is_bound()) bar__id() = OMIT_VALUE;
else bar__id().set_implicit_omit();
}

void Create__FAR_grouped__ie_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_far__id.encode_text(text_buf);
single_value->field_apply__action.encode_text(text_buf);
single_value->field_forwarding__parameters.encode_text(text_buf);
single_value->field_duplicating__parameters.encode_text(text_buf);
single_value->field_bar__id.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @PFCP_Types.Create_FAR.grouped_ie.");
}
}

void Create__FAR_grouped__ie_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_far__id.decode_text(text_buf);
single_value->field_apply__action.decode_text(text_buf);
single_value->field_forwarding__parameters.decode_text(text_buf);
single_value->field_duplicating__parameters.decode_text(text_buf);
single_value->field_bar__id.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new Create__FAR_grouped__ie_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @PFCP_Types.Create_FAR.grouped_ie.");
}
}

void Create__FAR_grouped__ie_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "set template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    Create__FAR_grouped__ie_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("set template of type @PFCP_Types.Create_FAR.grouped_ie has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) far__id().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) apply__action().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) forwarding__parameters().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) duplicating__parameters().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) bar__id().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "far_id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          far__id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "apply_action")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          apply__action().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "forwarding_parameters")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          forwarding__parameters().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "duplicating_parameters")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          duplicating__parameters().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bar_id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bar__id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @PFCP_Types.Create_FAR.grouped_ie: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    Create__FAR_grouped__ie_template* precondition = new Create__FAR_grouped__ie_template;
    precondition->set_param(*param.get_elem(0));
    Create__FAR_grouped__ie_template* implied_template = new Create__FAR_grouped__ie_template;
    implied_template->set_param(*param.get_elem(1));
    *this = Create__FAR_grouped__ie_template(precondition, implied_template);
  } break;
  default:
    param.type_error("set template", "@PFCP_Types.Create_FAR.grouped_ie");
  }
  is_ifpresent = param.get_ifpresent();
}

void Create__FAR_grouped__ie_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_far__id.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_FAR.grouped_ie");
single_value->field_apply__action.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_FAR.grouped_ie");
single_value->field_forwarding__parameters.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_FAR.grouped_ie");
single_value->field_duplicating__parameters.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_FAR.grouped_ie");
single_value->field_bar__id.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_FAR.grouped_ie");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@PFCP_Types.Create_FAR.grouped_ie");
}

boolean Create__FAR_grouped__ie_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean Create__FAR_grouped__ie_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

Forwarding__Parameters_grouped__ie::Forwarding__Parameters_grouped__ie()
{
}

Forwarding__Parameters_grouped__ie::Forwarding__Parameters_grouped__ie(const Destination__Interface& par_destination__interface,
    const OPTIONAL< Network__Instance >& par_pdn__Instance,
    const OPTIONAL< Redirect__Information >& par_redirect__information,
    const OPTIONAL< Outer__Header__Creation >& par_outer__header__creation,
    const OPTIONAL< DL__Transport__Level__Marking >& par_transport__level__marking,
    const OPTIONAL< Forwarding__Policy >& par_forwarding__policy,
    const OPTIONAL< Header__Enrichment >& par_header__enrichment,
    const OPTIONAL< Traffic__Endpoint__ID >& par_traffic__endpoint__ID)
  :   field_destination__interface(par_destination__interface),
  field_pdn__Instance(par_pdn__Instance),
  field_redirect__information(par_redirect__information),
  field_outer__header__creation(par_outer__header__creation),
  field_transport__level__marking(par_transport__level__marking),
  field_forwarding__policy(par_forwarding__policy),
  field_header__enrichment(par_header__enrichment),
  field_traffic__endpoint__ID(par_traffic__endpoint__ID)
{
}

Forwarding__Parameters_grouped__ie::Forwarding__Parameters_grouped__ie(const Forwarding__Parameters_grouped__ie& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @PFCP_Types.Forwarding_Parameters.grouped_ie.");
if (other_value.destination__interface().is_bound()) field_destination__interface = other_value.destination__interface();
else field_destination__interface.clean_up();
if (other_value.pdn__Instance().is_bound()) field_pdn__Instance = other_value.pdn__Instance();
else field_pdn__Instance.clean_up();
if (other_value.redirect__information().is_bound()) field_redirect__information = other_value.redirect__information();
else field_redirect__information.clean_up();
if (other_value.outer__header__creation().is_bound()) field_outer__header__creation = other_value.outer__header__creation();
else field_outer__header__creation.clean_up();
if (other_value.transport__level__marking().is_bound()) field_transport__level__marking = other_value.transport__level__marking();
else field_transport__level__marking.clean_up();
if (other_value.forwarding__policy().is_bound()) field_forwarding__policy = other_value.forwarding__policy();
else field_forwarding__policy.clean_up();
if (other_value.header__enrichment().is_bound()) field_header__enrichment = other_value.header__enrichment();
else field_header__enrichment.clean_up();
if (other_value.traffic__endpoint__ID().is_bound()) field_traffic__endpoint__ID = other_value.traffic__endpoint__ID();
else field_traffic__endpoint__ID.clean_up();
}

void Forwarding__Parameters_grouped__ie::clean_up()
{
field_destination__interface.clean_up();
field_pdn__Instance.clean_up();
field_redirect__information.clean_up();
field_outer__header__creation.clean_up();
field_transport__level__marking.clean_up();
field_forwarding__policy.clean_up();
field_header__enrichment.clean_up();
field_traffic__endpoint__ID.clean_up();
}

const TTCN_Typedescriptor_t* Forwarding__Parameters_grouped__ie::get_descriptor() const { return &Forwarding__Parameters_grouped__ie_descr_; }
Forwarding__Parameters_grouped__ie& Forwarding__Parameters_grouped__ie::operator=(const Forwarding__Parameters_grouped__ie& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @PFCP_Types.Forwarding_Parameters.grouped_ie.");
  if (other_value.destination__interface().is_bound()) field_destination__interface = other_value.destination__interface();
  else field_destination__interface.clean_up();
  if (other_value.pdn__Instance().is_bound()) field_pdn__Instance = other_value.pdn__Instance();
  else field_pdn__Instance.clean_up();
  if (other_value.redirect__information().is_bound()) field_redirect__information = other_value.redirect__information();
  else field_redirect__information.clean_up();
  if (other_value.outer__header__creation().is_bound()) field_outer__header__creation = other_value.outer__header__creation();
  else field_outer__header__creation.clean_up();
  if (other_value.transport__level__marking().is_bound()) field_transport__level__marking = other_value.transport__level__marking();
  else field_transport__level__marking.clean_up();
  if (other_value.forwarding__policy().is_bound()) field_forwarding__policy = other_value.forwarding__policy();
  else field_forwarding__policy.clean_up();
  if (other_value.header__enrichment().is_bound()) field_header__enrichment = other_value.header__enrichment();
  else field_header__enrichment.clean_up();
  if (other_value.traffic__endpoint__ID().is_bound()) field_traffic__endpoint__ID = other_value.traffic__endpoint__ID();
  else field_traffic__endpoint__ID.clean_up();
}
return *this;
}

boolean Forwarding__Parameters_grouped__ie::operator==(const Forwarding__Parameters_grouped__ie& other_value) const
{
return field_destination__interface==other_value.field_destination__interface
  && field_pdn__Instance==other_value.field_pdn__Instance
  && field_redirect__information==other_value.field_redirect__information
  && field_outer__header__creation==other_value.field_outer__header__creation
  && field_transport__level__marking==other_value.field_transport__level__marking
  && field_forwarding__policy==other_value.field_forwarding__policy
  && field_header__enrichment==other_value.field_header__enrichment
  && field_traffic__endpoint__ID==other_value.field_traffic__endpoint__ID;
}

boolean Forwarding__Parameters_grouped__ie::is_bound() const
{
return (field_destination__interface.is_bound())
  || (OPTIONAL_OMIT == field_pdn__Instance.get_selection() || field_pdn__Instance.is_bound())
  || (OPTIONAL_OMIT == field_redirect__information.get_selection() || field_redirect__information.is_bound())
  || (OPTIONAL_OMIT == field_outer__header__creation.get_selection() || field_outer__header__creation.is_bound())
  || (OPTIONAL_OMIT == field_transport__level__marking.get_selection() || field_transport__level__marking.is_bound())
  || (OPTIONAL_OMIT == field_forwarding__policy.get_selection() || field_forwarding__policy.is_bound())
  || (OPTIONAL_OMIT == field_header__enrichment.get_selection() || field_header__enrichment.is_bound())
  || (OPTIONAL_OMIT == field_traffic__endpoint__ID.get_selection() || field_traffic__endpoint__ID.is_bound());
}
boolean Forwarding__Parameters_grouped__ie::is_value() const
{
return field_destination__interface.is_value()
  && (OPTIONAL_OMIT == field_pdn__Instance.get_selection() || field_pdn__Instance.is_value())
  && (OPTIONAL_OMIT == field_redirect__information.get_selection() || field_redirect__information.is_value())
  && (OPTIONAL_OMIT == field_outer__header__creation.get_selection() || field_outer__header__creation.is_value())
  && (OPTIONAL_OMIT == field_transport__level__marking.get_selection() || field_transport__level__marking.is_value())
  && (OPTIONAL_OMIT == field_forwarding__policy.get_selection() || field_forwarding__policy.is_value())
  && (OPTIONAL_OMIT == field_header__enrichment.get_selection() || field_header__enrichment.is_value())
  && (OPTIONAL_OMIT == field_traffic__endpoint__ID.get_selection() || field_traffic__endpoint__ID.is_value());
}
int Forwarding__Parameters_grouped__ie::size_of() const
{
  int ret_val = 1;
  if (field_pdn__Instance.ispresent()) ret_val++;
  if (field_redirect__information.ispresent()) ret_val++;
  if (field_outer__header__creation.ispresent()) ret_val++;
  if (field_transport__level__marking.ispresent()) ret_val++;
  if (field_forwarding__policy.ispresent()) ret_val++;
  if (field_header__enrichment.ispresent()) ret_val++;
  if (field_traffic__endpoint__ID.ispresent()) ret_val++;
  return ret_val;
}

void Forwarding__Parameters_grouped__ie::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ destination_interface := ");
field_destination__interface.log();
TTCN_Logger::log_event_str(", pdn_Instance := ");
field_pdn__Instance.log();
TTCN_Logger::log_event_str(", redirect_information := ");
field_redirect__information.log();
TTCN_Logger::log_event_str(", outer_header_creation := ");
field_outer__header__creation.log();
TTCN_Logger::log_event_str(", transport_level_marking := ");
field_transport__level__marking.log();
TTCN_Logger::log_event_str(", forwarding_policy := ");
field_forwarding__policy.log();
TTCN_Logger::log_event_str(", header_enrichment := ");
field_header__enrichment.log();
TTCN_Logger::log_event_str(", traffic_endpoint_ID := ");
field_traffic__endpoint__ID.log();
TTCN_Logger::log_event_str(" }");
}

void Forwarding__Parameters_grouped__ie::set_implicit_omit()
{
if (destination__interface().is_bound()) destination__interface().set_implicit_omit();
if (!pdn__Instance().is_bound()) pdn__Instance() = OMIT_VALUE;
else pdn__Instance().set_implicit_omit();
if (!redirect__information().is_bound()) redirect__information() = OMIT_VALUE;
else redirect__information().set_implicit_omit();
if (!outer__header__creation().is_bound()) outer__header__creation() = OMIT_VALUE;
else outer__header__creation().set_implicit_omit();
if (!transport__level__marking().is_bound()) transport__level__marking() = OMIT_VALUE;
else transport__level__marking().set_implicit_omit();
if (!forwarding__policy().is_bound()) forwarding__policy() = OMIT_VALUE;
else forwarding__policy().set_implicit_omit();
if (!header__enrichment().is_bound()) header__enrichment() = OMIT_VALUE;
else header__enrichment().set_implicit_omit();
if (!traffic__endpoint__ID().is_bound()) traffic__endpoint__ID() = OMIT_VALUE;
else traffic__endpoint__ID().set_implicit_omit();
}

void Forwarding__Parameters_grouped__ie::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "set value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (8<param.get_size()) {
      param.error("set value of type @PFCP_Types.Forwarding_Parameters.grouped_ie has 8 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) destination__interface().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) pdn__Instance().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) redirect__information().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) outer__header__creation().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) transport__level__marking().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) forwarding__policy().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) header__enrichment().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) traffic__endpoint__ID().set_param(*param.get_elem(7));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "destination_interface")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          destination__interface().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pdn_Instance")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pdn__Instance().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "redirect_information")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          redirect__information().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "outer_header_creation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          outer__header__creation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "transport_level_marking")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          transport__level__marking().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "forwarding_policy")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          forwarding__policy().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "header_enrichment")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          header__enrichment().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "traffic_endpoint_ID")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          traffic__endpoint__ID().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @PFCP_Types.Forwarding_Parameters.grouped_ie: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("set value", "@PFCP_Types.Forwarding_Parameters.grouped_ie");
  }
}

void Forwarding__Parameters_grouped__ie::encode_text(Text_Buf& text_buf) const
{
field_destination__interface.encode_text(text_buf);
field_pdn__Instance.encode_text(text_buf);
field_redirect__information.encode_text(text_buf);
field_outer__header__creation.encode_text(text_buf);
field_transport__level__marking.encode_text(text_buf);
field_forwarding__policy.encode_text(text_buf);
field_header__enrichment.encode_text(text_buf);
field_traffic__endpoint__ID.encode_text(text_buf);
}

void Forwarding__Parameters_grouped__ie::decode_text(Text_Buf& text_buf)
{
field_destination__interface.decode_text(text_buf);
field_pdn__Instance.decode_text(text_buf);
field_redirect__information.decode_text(text_buf);
field_outer__header__creation.decode_text(text_buf);
field_transport__level__marking.decode_text(text_buf);
field_forwarding__policy.decode_text(text_buf);
field_header__enrichment.decode_text(text_buf);
field_traffic__endpoint__ID.decode_text(text_buf);
}

void Forwarding__Parameters_grouped__ie::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Forwarding__Parameters_grouped__ie::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int Forwarding__Parameters_grouped__ie::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean, int, boolean, const RAW_Force_Omit* force_omit)
{
int prepaddlength = p_buf.increase_pos_padd(p_td.raw->prepadding);
limit -= prepaddlength;
int decoded_length = 0;
int field_map[8];
memset(field_map, 0, sizeof(field_map));
size_t nof_mand_fields = 0;
field_pdn__Instance = OMIT_VALUE;
field_redirect__information = OMIT_VALUE;
field_outer__header__creation = OMIT_VALUE;
field_transport__level__marking = OMIT_VALUE;
field_forwarding__policy = OMIT_VALUE;
field_header__enrichment = OMIT_VALUE;
field_traffic__endpoint__ID = OMIT_VALUE;
raw_order_t local_top_order;
if (p_td.raw->top_bit_order == TOP_BIT_INHERITED) local_top_order = top_bit_ord;
else if (p_td.raw->top_bit_order == TOP_BIT_RIGHT) local_top_order = ORDER_MSB;
else local_top_order = ORDER_LSB;
while (limit > 0) {
size_t fl_start_pos = p_buf.get_pos_bit();
if (field_map[0] == 0) {
RAW_Force_Omit field_0_force_omit(0, force_omit, Destination__Interface_descr_.raw->forceomit);
int decoded_field_length = field_destination__interface.RAW_decode(Destination__Interface_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_0_force_omit);
if (decoded_field_length >= 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
nof_mand_fields++;
field_map[0] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
}
}
if (field_map[1] == 0 && (force_omit == NULL || !(*force_omit)(1))) {
RAW_Force_Omit field_1_force_omit(1, force_omit, Network__Instance_descr_.raw->forceomit);
int decoded_field_length = field_pdn__Instance().RAW_decode(Network__Instance_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_1_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[1] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_pdn__Instance = OMIT_VALUE;
}
}
if (field_map[2] == 0 && (force_omit == NULL || !(*force_omit)(2))) {
RAW_Force_Omit field_2_force_omit(2, force_omit, Redirect__Information_descr_.raw->forceomit);
int decoded_field_length = field_redirect__information().RAW_decode(Redirect__Information_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[2] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_redirect__information = OMIT_VALUE;
}
}
if (field_map[3] == 0 && (force_omit == NULL || !(*force_omit)(3))) {
RAW_Force_Omit field_3_force_omit(3, force_omit, Outer__Header__Creation_descr_.raw->forceomit);
int decoded_field_length = field_outer__header__creation().RAW_decode(Outer__Header__Creation_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[3] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_outer__header__creation = OMIT_VALUE;
}
}
if (field_map[4] == 0 && (force_omit == NULL || !(*force_omit)(4))) {
RAW_Force_Omit field_4_force_omit(4, force_omit, DL__Transport__Level__Marking_descr_.raw->forceomit);
int decoded_field_length = field_transport__level__marking().RAW_decode(DL__Transport__Level__Marking_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_4_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[4] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_transport__level__marking = OMIT_VALUE;
}
}
if (field_map[5] == 0 && (force_omit == NULL || !(*force_omit)(5))) {
RAW_Force_Omit field_5_force_omit(5, force_omit, Forwarding__Policy_descr_.raw->forceomit);
int decoded_field_length = field_forwarding__policy().RAW_decode(Forwarding__Policy_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_5_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[5] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_forwarding__policy = OMIT_VALUE;
}
}
if (field_map[6] == 0 && (force_omit == NULL || !(*force_omit)(6))) {
RAW_Force_Omit field_6_force_omit(6, force_omit, Header__Enrichment_descr_.raw->forceomit);
int decoded_field_length = field_header__enrichment().RAW_decode(Header__Enrichment_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_6_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[6] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_header__enrichment = OMIT_VALUE;
}
}
if (field_map[7] == 0 && (force_omit == NULL || !(*force_omit)(7))) {
RAW_Force_Omit field_7_force_omit(7, force_omit, Traffic__Endpoint__ID_descr_.raw->forceomit);
int decoded_field_length = field_traffic__endpoint__ID().RAW_decode(Traffic__Endpoint__ID_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_7_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[7] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_traffic__endpoint__ID = OMIT_VALUE;
}
}
break;
}
if (nof_mand_fields != 1) return limit ? -1 : -TTCN_EncDec::ET_INCOMPL_MSG;
return decoded_length + prepaddlength + p_buf.increase_pos_padd(p_td.raw->padding);
}

int Forwarding__Parameters_grouped__ie::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 8;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(8);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, Destination__Interface_descr_.raw);
  if (field_pdn__Instance.ispresent()) {
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, Network__Instance_descr_.raw);
  }
  else myleaf.body.node.nodes[1] = NULL;
  if (field_redirect__information.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, Redirect__Information_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  if (field_outer__header__creation.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, Outer__Header__Creation_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  if (field_transport__level__marking.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, DL__Transport__Level__Marking_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  if (field_forwarding__policy.ispresent()) {
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, Forwarding__Policy_descr_.raw);
  }
  else myleaf.body.node.nodes[5] = NULL;
  if (field_header__enrichment.ispresent()) {
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, Header__Enrichment_descr_.raw);
  }
  else myleaf.body.node.nodes[6] = NULL;
  if (field_traffic__endpoint__ID.ispresent()) {
  myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 7, Traffic__Endpoint__ID_descr_.raw);
  }
  else myleaf.body.node.nodes[7] = NULL;
  encoded_length += field_destination__interface.RAW_encode(Destination__Interface_descr_, *myleaf.body.node.nodes[0]);
  if (field_pdn__Instance.ispresent()) {
  encoded_length += field_pdn__Instance().RAW_encode(Network__Instance_descr_, *myleaf.body.node.nodes[1]);
  }
  if (field_redirect__information.ispresent()) {
  encoded_length += field_redirect__information().RAW_encode(Redirect__Information_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_outer__header__creation.ispresent()) {
  encoded_length += field_outer__header__creation().RAW_encode(Outer__Header__Creation_descr_, *myleaf.body.node.nodes[3]);
  }
  if (field_transport__level__marking.ispresent()) {
  encoded_length += field_transport__level__marking().RAW_encode(DL__Transport__Level__Marking_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_forwarding__policy.ispresent()) {
  encoded_length += field_forwarding__policy().RAW_encode(Forwarding__Policy_descr_, *myleaf.body.node.nodes[5]);
  }
  if (field_header__enrichment.ispresent()) {
  encoded_length += field_header__enrichment().RAW_encode(Header__Enrichment_descr_, *myleaf.body.node.nodes[6]);
  }
  if (field_traffic__endpoint__ID.ispresent()) {
  encoded_length += field_traffic__endpoint__ID().RAW_encode(Traffic__Endpoint__ID_descr_, *myleaf.body.node.nodes[7]);
  }
  return myleaf.length = encoded_length;
}

struct Forwarding__Parameters_grouped__ie_template::single_value_struct {
Destination__Interface_template field_destination__interface;
Network__Instance_template field_pdn__Instance;
Redirect__Information_template field_redirect__information;
Outer__Header__Creation_template field_outer__header__creation;
DL__Transport__Level__Marking_template field_transport__level__marking;
Forwarding__Policy_template field_forwarding__policy;
Header__Enrichment_template field_header__enrichment;
Traffic__Endpoint__ID_template field_traffic__endpoint__ID;
};

void Forwarding__Parameters_grouped__ie_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_destination__interface = ANY_VALUE;
single_value->field_pdn__Instance = ANY_OR_OMIT;
single_value->field_redirect__information = ANY_OR_OMIT;
single_value->field_outer__header__creation = ANY_OR_OMIT;
single_value->field_transport__level__marking = ANY_OR_OMIT;
single_value->field_forwarding__policy = ANY_OR_OMIT;
single_value->field_header__enrichment = ANY_OR_OMIT;
single_value->field_traffic__endpoint__ID = ANY_OR_OMIT;
}
}
}

void Forwarding__Parameters_grouped__ie_template::copy_value(const Forwarding__Parameters_grouped__ie& other_value)
{
single_value = new single_value_struct;
if (other_value.destination__interface().is_bound()) {
  single_value->field_destination__interface = other_value.destination__interface();
} else {
  single_value->field_destination__interface.clean_up();
}
if (other_value.pdn__Instance().is_bound()) {
  if (other_value.pdn__Instance().ispresent()) single_value->field_pdn__Instance = other_value.pdn__Instance()();
  else single_value->field_pdn__Instance = OMIT_VALUE;
} else {
  single_value->field_pdn__Instance.clean_up();
}
if (other_value.redirect__information().is_bound()) {
  if (other_value.redirect__information().ispresent()) single_value->field_redirect__information = other_value.redirect__information()();
  else single_value->field_redirect__information = OMIT_VALUE;
} else {
  single_value->field_redirect__information.clean_up();
}
if (other_value.outer__header__creation().is_bound()) {
  if (other_value.outer__header__creation().ispresent()) single_value->field_outer__header__creation = other_value.outer__header__creation()();
  else single_value->field_outer__header__creation = OMIT_VALUE;
} else {
  single_value->field_outer__header__creation.clean_up();
}
if (other_value.transport__level__marking().is_bound()) {
  if (other_value.transport__level__marking().ispresent()) single_value->field_transport__level__marking = other_value.transport__level__marking()();
  else single_value->field_transport__level__marking = OMIT_VALUE;
} else {
  single_value->field_transport__level__marking.clean_up();
}
if (other_value.forwarding__policy().is_bound()) {
  if (other_value.forwarding__policy().ispresent()) single_value->field_forwarding__policy = other_value.forwarding__policy()();
  else single_value->field_forwarding__policy = OMIT_VALUE;
} else {
  single_value->field_forwarding__policy.clean_up();
}
if (other_value.header__enrichment().is_bound()) {
  if (other_value.header__enrichment().ispresent()) single_value->field_header__enrichment = other_value.header__enrichment()();
  else single_value->field_header__enrichment = OMIT_VALUE;
} else {
  single_value->field_header__enrichment.clean_up();
}
if (other_value.traffic__endpoint__ID().is_bound()) {
  if (other_value.traffic__endpoint__ID().ispresent()) single_value->field_traffic__endpoint__ID = other_value.traffic__endpoint__ID()();
  else single_value->field_traffic__endpoint__ID = OMIT_VALUE;
} else {
  single_value->field_traffic__endpoint__ID.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void Forwarding__Parameters_grouped__ie_template::copy_template(const Forwarding__Parameters_grouped__ie_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.destination__interface().get_selection()) {
single_value->field_destination__interface = other_value.destination__interface();
} else {
single_value->field_destination__interface.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.pdn__Instance().get_selection()) {
single_value->field_pdn__Instance = other_value.pdn__Instance();
} else {
single_value->field_pdn__Instance.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.redirect__information().get_selection()) {
single_value->field_redirect__information = other_value.redirect__information();
} else {
single_value->field_redirect__information.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.outer__header__creation().get_selection()) {
single_value->field_outer__header__creation = other_value.outer__header__creation();
} else {
single_value->field_outer__header__creation.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.transport__level__marking().get_selection()) {
single_value->field_transport__level__marking = other_value.transport__level__marking();
} else {
single_value->field_transport__level__marking.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.forwarding__policy().get_selection()) {
single_value->field_forwarding__policy = other_value.forwarding__policy();
} else {
single_value->field_forwarding__policy.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.header__enrichment().get_selection()) {
single_value->field_header__enrichment = other_value.header__enrichment();
} else {
single_value->field_header__enrichment.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.traffic__endpoint__ID().get_selection()) {
single_value->field_traffic__endpoint__ID = other_value.traffic__endpoint__ID();
} else {
single_value->field_traffic__endpoint__ID.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Forwarding__Parameters_grouped__ie_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Forwarding__Parameters_grouped__ie_template(*other_value.implication_.precondition);
implication_.implied_template = new Forwarding__Parameters_grouped__ie_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @PFCP_Types.Forwarding_Parameters.grouped_ie.");
break;
}
set_selection(other_value);
}

Forwarding__Parameters_grouped__ie_template::Forwarding__Parameters_grouped__ie_template()
{
}

Forwarding__Parameters_grouped__ie_template::Forwarding__Parameters_grouped__ie_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

Forwarding__Parameters_grouped__ie_template::Forwarding__Parameters_grouped__ie_template(const Forwarding__Parameters_grouped__ie& other_value)
{
copy_value(other_value);
}

Forwarding__Parameters_grouped__ie_template::Forwarding__Parameters_grouped__ie_template(const OPTIONAL<Forwarding__Parameters_grouped__ie>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Forwarding__Parameters_grouped__ie&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @PFCP_Types.Forwarding_Parameters.grouped_ie from an unbound optional field.");
}
}

Forwarding__Parameters_grouped__ie_template::Forwarding__Parameters_grouped__ie_template(Forwarding__Parameters_grouped__ie_template* p_precondition, Forwarding__Parameters_grouped__ie_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

Forwarding__Parameters_grouped__ie_template::Forwarding__Parameters_grouped__ie_template(Dynamic_Match_Interface<Forwarding__Parameters_grouped__ie>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<Forwarding__Parameters_grouped__ie>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

Forwarding__Parameters_grouped__ie_template::Forwarding__Parameters_grouped__ie_template(const Forwarding__Parameters_grouped__ie_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

Forwarding__Parameters_grouped__ie_template::~Forwarding__Parameters_grouped__ie_template()
{
clean_up();
}

Forwarding__Parameters_grouped__ie_template& Forwarding__Parameters_grouped__ie_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

Forwarding__Parameters_grouped__ie_template& Forwarding__Parameters_grouped__ie_template::operator=(const Forwarding__Parameters_grouped__ie& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

Forwarding__Parameters_grouped__ie_template& Forwarding__Parameters_grouped__ie_template::operator=(const OPTIONAL<Forwarding__Parameters_grouped__ie>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Forwarding__Parameters_grouped__ie&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @PFCP_Types.Forwarding_Parameters.grouped_ie.");
}
return *this;
}

Forwarding__Parameters_grouped__ie_template& Forwarding__Parameters_grouped__ie_template::operator=(const Forwarding__Parameters_grouped__ie_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean Forwarding__Parameters_grouped__ie_template::match(const Forwarding__Parameters_grouped__ie& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.destination__interface().is_bound()) return FALSE;
if(!single_value->field_destination__interface.match(other_value.destination__interface(), legacy))return FALSE;
if(!other_value.pdn__Instance().is_bound()) return FALSE;
if((other_value.pdn__Instance().ispresent() ? !single_value->field_pdn__Instance.match((const Network__Instance&)other_value.pdn__Instance(), legacy) : !single_value->field_pdn__Instance.match_omit(legacy)))return FALSE;
if(!other_value.redirect__information().is_bound()) return FALSE;
if((other_value.redirect__information().ispresent() ? !single_value->field_redirect__information.match((const Redirect__Information&)other_value.redirect__information(), legacy) : !single_value->field_redirect__information.match_omit(legacy)))return FALSE;
if(!other_value.outer__header__creation().is_bound()) return FALSE;
if((other_value.outer__header__creation().ispresent() ? !single_value->field_outer__header__creation.match((const Outer__Header__Creation&)other_value.outer__header__creation(), legacy) : !single_value->field_outer__header__creation.match_omit(legacy)))return FALSE;
if(!other_value.transport__level__marking().is_bound()) return FALSE;
if((other_value.transport__level__marking().ispresent() ? !single_value->field_transport__level__marking.match((const DL__Transport__Level__Marking&)other_value.transport__level__marking(), legacy) : !single_value->field_transport__level__marking.match_omit(legacy)))return FALSE;
if(!other_value.forwarding__policy().is_bound()) return FALSE;
if((other_value.forwarding__policy().ispresent() ? !single_value->field_forwarding__policy.match((const Forwarding__Policy&)other_value.forwarding__policy(), legacy) : !single_value->field_forwarding__policy.match_omit(legacy)))return FALSE;
if(!other_value.header__enrichment().is_bound()) return FALSE;
if((other_value.header__enrichment().ispresent() ? !single_value->field_header__enrichment.match((const Header__Enrichment&)other_value.header__enrichment(), legacy) : !single_value->field_header__enrichment.match_omit(legacy)))return FALSE;
if(!other_value.traffic__endpoint__ID().is_bound()) return FALSE;
if((other_value.traffic__endpoint__ID().ispresent() ? !single_value->field_traffic__endpoint__ID.match((const Traffic__Endpoint__ID&)other_value.traffic__endpoint__ID(), legacy) : !single_value->field_traffic__endpoint__ID.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @PFCP_Types.Forwarding_Parameters.grouped_ie.");
}
return FALSE;
}

boolean Forwarding__Parameters_grouped__ie_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_destination__interface.is_bound()
 || (single_value->field_pdn__Instance.is_omit() || single_value->field_pdn__Instance.is_bound())
 || (single_value->field_redirect__information.is_omit() || single_value->field_redirect__information.is_bound())
 || (single_value->field_outer__header__creation.is_omit() || single_value->field_outer__header__creation.is_bound())
 || (single_value->field_transport__level__marking.is_omit() || single_value->field_transport__level__marking.is_bound())
 || (single_value->field_forwarding__policy.is_omit() || single_value->field_forwarding__policy.is_bound())
 || (single_value->field_header__enrichment.is_omit() || single_value->field_header__enrichment.is_bound())
 || (single_value->field_traffic__endpoint__ID.is_omit() || single_value->field_traffic__endpoint__ID.is_bound());
}

boolean Forwarding__Parameters_grouped__ie_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_destination__interface.is_value()
 && (single_value->field_pdn__Instance.is_omit() || single_value->field_pdn__Instance.is_value())
 && (single_value->field_redirect__information.is_omit() || single_value->field_redirect__information.is_value())
 && (single_value->field_outer__header__creation.is_omit() || single_value->field_outer__header__creation.is_value())
 && (single_value->field_transport__level__marking.is_omit() || single_value->field_transport__level__marking.is_value())
 && (single_value->field_forwarding__policy.is_omit() || single_value->field_forwarding__policy.is_value())
 && (single_value->field_header__enrichment.is_omit() || single_value->field_header__enrichment.is_value())
 && (single_value->field_traffic__endpoint__ID.is_omit() || single_value->field_traffic__endpoint__ID.is_value());
}

void Forwarding__Parameters_grouped__ie_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

Forwarding__Parameters_grouped__ie Forwarding__Parameters_grouped__ie_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @PFCP_Types.Forwarding_Parameters.grouped_ie.");
Forwarding__Parameters_grouped__ie ret_val;
if (single_value->field_destination__interface.is_bound()) {
ret_val.destination__interface() = single_value->field_destination__interface.valueof();
}
if (single_value->field_pdn__Instance.is_omit()) ret_val.pdn__Instance() = OMIT_VALUE;
else if (single_value->field_pdn__Instance.is_bound()) {
ret_val.pdn__Instance() = single_value->field_pdn__Instance.valueof();
}
if (single_value->field_redirect__information.is_omit()) ret_val.redirect__information() = OMIT_VALUE;
else if (single_value->field_redirect__information.is_bound()) {
ret_val.redirect__information() = single_value->field_redirect__information.valueof();
}
if (single_value->field_outer__header__creation.is_omit()) ret_val.outer__header__creation() = OMIT_VALUE;
else if (single_value->field_outer__header__creation.is_bound()) {
ret_val.outer__header__creation() = single_value->field_outer__header__creation.valueof();
}
if (single_value->field_transport__level__marking.is_omit()) ret_val.transport__level__marking() = OMIT_VALUE;
else if (single_value->field_transport__level__marking.is_bound()) {
ret_val.transport__level__marking() = single_value->field_transport__level__marking.valueof();
}
if (single_value->field_forwarding__policy.is_omit()) ret_val.forwarding__policy() = OMIT_VALUE;
else if (single_value->field_forwarding__policy.is_bound()) {
ret_val.forwarding__policy() = single_value->field_forwarding__policy.valueof();
}
if (single_value->field_header__enrichment.is_omit()) ret_val.header__enrichment() = OMIT_VALUE;
else if (single_value->field_header__enrichment.is_bound()) {
ret_val.header__enrichment() = single_value->field_header__enrichment.valueof();
}
if (single_value->field_traffic__endpoint__ID.is_omit()) ret_val.traffic__endpoint__ID() = OMIT_VALUE;
else if (single_value->field_traffic__endpoint__ID.is_bound()) {
ret_val.traffic__endpoint__ID() = single_value->field_traffic__endpoint__ID.valueof();
}
return ret_val;
}

void Forwarding__Parameters_grouped__ie_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @PFCP_Types.Forwarding_Parameters.grouped_ie.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new Forwarding__Parameters_grouped__ie_template[list_length];
}

Forwarding__Parameters_grouped__ie_template& Forwarding__Parameters_grouped__ie_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @PFCP_Types.Forwarding_Parameters.grouped_ie.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @PFCP_Types.Forwarding_Parameters.grouped_ie.");
return value_list.list_value[list_index];
}

Destination__Interface_template& Forwarding__Parameters_grouped__ie_template::destination__interface()
{
set_specific();
return single_value->field_destination__interface;
}

const Destination__Interface_template& Forwarding__Parameters_grouped__ie_template::destination__interface() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field destination_interface of a non-specific template of type @PFCP_Types.Forwarding_Parameters.grouped_ie.");
return single_value->field_destination__interface;
}

Network__Instance_template& Forwarding__Parameters_grouped__ie_template::pdn__Instance()
{
set_specific();
return single_value->field_pdn__Instance;
}

const Network__Instance_template& Forwarding__Parameters_grouped__ie_template::pdn__Instance() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field pdn_Instance of a non-specific template of type @PFCP_Types.Forwarding_Parameters.grouped_ie.");
return single_value->field_pdn__Instance;
}

Redirect__Information_template& Forwarding__Parameters_grouped__ie_template::redirect__information()
{
set_specific();
return single_value->field_redirect__information;
}

const Redirect__Information_template& Forwarding__Parameters_grouped__ie_template::redirect__information() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field redirect_information of a non-specific template of type @PFCP_Types.Forwarding_Parameters.grouped_ie.");
return single_value->field_redirect__information;
}

Outer__Header__Creation_template& Forwarding__Parameters_grouped__ie_template::outer__header__creation()
{
set_specific();
return single_value->field_outer__header__creation;
}

const Outer__Header__Creation_template& Forwarding__Parameters_grouped__ie_template::outer__header__creation() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field outer_header_creation of a non-specific template of type @PFCP_Types.Forwarding_Parameters.grouped_ie.");
return single_value->field_outer__header__creation;
}

DL__Transport__Level__Marking_template& Forwarding__Parameters_grouped__ie_template::transport__level__marking()
{
set_specific();
return single_value->field_transport__level__marking;
}

const DL__Transport__Level__Marking_template& Forwarding__Parameters_grouped__ie_template::transport__level__marking() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field transport_level_marking of a non-specific template of type @PFCP_Types.Forwarding_Parameters.grouped_ie.");
return single_value->field_transport__level__marking;
}

Forwarding__Policy_template& Forwarding__Parameters_grouped__ie_template::forwarding__policy()
{
set_specific();
return single_value->field_forwarding__policy;
}

const Forwarding__Policy_template& Forwarding__Parameters_grouped__ie_template::forwarding__policy() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field forwarding_policy of a non-specific template of type @PFCP_Types.Forwarding_Parameters.grouped_ie.");
return single_value->field_forwarding__policy;
}

Header__Enrichment_template& Forwarding__Parameters_grouped__ie_template::header__enrichment()
{
set_specific();
return single_value->field_header__enrichment;
}

const Header__Enrichment_template& Forwarding__Parameters_grouped__ie_template::header__enrichment() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field header_enrichment of a non-specific template of type @PFCP_Types.Forwarding_Parameters.grouped_ie.");
return single_value->field_header__enrichment;
}

Traffic__Endpoint__ID_template& Forwarding__Parameters_grouped__ie_template::traffic__endpoint__ID()
{
set_specific();
return single_value->field_traffic__endpoint__ID;
}

const Traffic__Endpoint__ID_template& Forwarding__Parameters_grouped__ie_template::traffic__endpoint__ID() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field traffic_endpoint_ID of a non-specific template of type @PFCP_Types.Forwarding_Parameters.grouped_ie.");
return single_value->field_traffic__endpoint__ID;
}

int Forwarding__Parameters_grouped__ie_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Forwarding_Parameters.grouped_ie which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_pdn__Instance.is_present()) ret_val++;
      if (single_value->field_redirect__information.is_present()) ret_val++;
      if (single_value->field_outer__header__creation.is_present()) ret_val++;
      if (single_value->field_transport__level__marking.is_present()) ret_val++;
      if (single_value->field_forwarding__policy.is_present()) ret_val++;
      if (single_value->field_header__enrichment.is_present()) ret_val++;
      if (single_value->field_traffic__endpoint__ID.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @PFCP_Types.Forwarding_Parameters.grouped_ie containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Forwarding_Parameters.grouped_ie containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Forwarding_Parameters.grouped_ie containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Forwarding_Parameters.grouped_ie containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Forwarding_Parameters.grouped_ie containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Forwarding_Parameters.grouped_ie containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Forwarding_Parameters.grouped_ie containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Forwarding_Parameters.grouped_ie containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @PFCP_Types.Forwarding_Parameters.grouped_ie.");
  }
  return 0;
}

void Forwarding__Parameters_grouped__ie_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ destination_interface := ");
single_value->field_destination__interface.log();
TTCN_Logger::log_event_str(", pdn_Instance := ");
single_value->field_pdn__Instance.log();
TTCN_Logger::log_event_str(", redirect_information := ");
single_value->field_redirect__information.log();
TTCN_Logger::log_event_str(", outer_header_creation := ");
single_value->field_outer__header__creation.log();
TTCN_Logger::log_event_str(", transport_level_marking := ");
single_value->field_transport__level__marking.log();
TTCN_Logger::log_event_str(", forwarding_policy := ");
single_value->field_forwarding__policy.log();
TTCN_Logger::log_event_str(", header_enrichment := ");
single_value->field_header__enrichment.log();
TTCN_Logger::log_event_str(", traffic_endpoint_ID := ");
single_value->field_traffic__endpoint__ID.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void Forwarding__Parameters_grouped__ie_template::log_match(const Forwarding__Parameters_grouped__ie& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_destination__interface.match(match_value.destination__interface(), legacy)){
TTCN_Logger::log_logmatch_info(".destination_interface");
single_value->field_destination__interface.log_match(match_value.destination__interface(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.pdn__Instance().ispresent()){
if(!single_value->field_pdn__Instance.match(match_value.pdn__Instance(), legacy)){
TTCN_Logger::log_logmatch_info(".pdn_Instance");
single_value->field_pdn__Instance.log_match(match_value.pdn__Instance(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_pdn__Instance.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".pdn_Instance := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_pdn__Instance.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.redirect__information().ispresent()){
if(!single_value->field_redirect__information.match(match_value.redirect__information(), legacy)){
TTCN_Logger::log_logmatch_info(".redirect_information");
single_value->field_redirect__information.log_match(match_value.redirect__information(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_redirect__information.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".redirect_information := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_redirect__information.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.outer__header__creation().ispresent()){
if(!single_value->field_outer__header__creation.match(match_value.outer__header__creation(), legacy)){
TTCN_Logger::log_logmatch_info(".outer_header_creation");
single_value->field_outer__header__creation.log_match(match_value.outer__header__creation(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_outer__header__creation.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".outer_header_creation := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_outer__header__creation.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.transport__level__marking().ispresent()){
if(!single_value->field_transport__level__marking.match(match_value.transport__level__marking(), legacy)){
TTCN_Logger::log_logmatch_info(".transport_level_marking");
single_value->field_transport__level__marking.log_match(match_value.transport__level__marking(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_transport__level__marking.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".transport_level_marking := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_transport__level__marking.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.forwarding__policy().ispresent()){
if(!single_value->field_forwarding__policy.match(match_value.forwarding__policy(), legacy)){
TTCN_Logger::log_logmatch_info(".forwarding_policy");
single_value->field_forwarding__policy.log_match(match_value.forwarding__policy(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_forwarding__policy.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".forwarding_policy := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_forwarding__policy.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.header__enrichment().ispresent()){
if(!single_value->field_header__enrichment.match(match_value.header__enrichment(), legacy)){
TTCN_Logger::log_logmatch_info(".header_enrichment");
single_value->field_header__enrichment.log_match(match_value.header__enrichment(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_header__enrichment.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".header_enrichment := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_header__enrichment.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.traffic__endpoint__ID().ispresent()){
if(!single_value->field_traffic__endpoint__ID.match(match_value.traffic__endpoint__ID(), legacy)){
TTCN_Logger::log_logmatch_info(".traffic_endpoint_ID");
single_value->field_traffic__endpoint__ID.log_match(match_value.traffic__endpoint__ID(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_traffic__endpoint__ID.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".traffic_endpoint_ID := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_traffic__endpoint__ID.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ destination_interface := ");
single_value->field_destination__interface.log_match(match_value.destination__interface(), legacy);
TTCN_Logger::log_event_str(", pdn_Instance := ");
if (match_value.pdn__Instance().ispresent()) {
single_value->field_pdn__Instance.log_match(match_value.pdn__Instance(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_pdn__Instance.log();
if (single_value->field_pdn__Instance.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", redirect_information := ");
if (match_value.redirect__information().ispresent()) {
single_value->field_redirect__information.log_match(match_value.redirect__information(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_redirect__information.log();
if (single_value->field_redirect__information.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", outer_header_creation := ");
if (match_value.outer__header__creation().ispresent()) {
single_value->field_outer__header__creation.log_match(match_value.outer__header__creation(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_outer__header__creation.log();
if (single_value->field_outer__header__creation.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", transport_level_marking := ");
if (match_value.transport__level__marking().ispresent()) {
single_value->field_transport__level__marking.log_match(match_value.transport__level__marking(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_transport__level__marking.log();
if (single_value->field_transport__level__marking.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", forwarding_policy := ");
if (match_value.forwarding__policy().ispresent()) {
single_value->field_forwarding__policy.log_match(match_value.forwarding__policy(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_forwarding__policy.log();
if (single_value->field_forwarding__policy.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", header_enrichment := ");
if (match_value.header__enrichment().ispresent()) {
single_value->field_header__enrichment.log_match(match_value.header__enrichment(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_header__enrichment.log();
if (single_value->field_header__enrichment.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", traffic_endpoint_ID := ");
if (match_value.traffic__endpoint__ID().ispresent()) {
single_value->field_traffic__endpoint__ID.log_match(match_value.traffic__endpoint__ID(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_traffic__endpoint__ID.log();
if (single_value->field_traffic__endpoint__ID.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void Forwarding__Parameters_grouped__ie_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (destination__interface().is_bound()) destination__interface().set_implicit_omit();
if (!pdn__Instance().is_bound()) pdn__Instance() = OMIT_VALUE;
else pdn__Instance().set_implicit_omit();
if (!redirect__information().is_bound()) redirect__information() = OMIT_VALUE;
else redirect__information().set_implicit_omit();
if (!outer__header__creation().is_bound()) outer__header__creation() = OMIT_VALUE;
else outer__header__creation().set_implicit_omit();
if (!transport__level__marking().is_bound()) transport__level__marking() = OMIT_VALUE;
else transport__level__marking().set_implicit_omit();
if (!forwarding__policy().is_bound()) forwarding__policy() = OMIT_VALUE;
else forwarding__policy().set_implicit_omit();
if (!header__enrichment().is_bound()) header__enrichment() = OMIT_VALUE;
else header__enrichment().set_implicit_omit();
if (!traffic__endpoint__ID().is_bound()) traffic__endpoint__ID() = OMIT_VALUE;
else traffic__endpoint__ID().set_implicit_omit();
}

void Forwarding__Parameters_grouped__ie_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_destination__interface.encode_text(text_buf);
single_value->field_pdn__Instance.encode_text(text_buf);
single_value->field_redirect__information.encode_text(text_buf);
single_value->field_outer__header__creation.encode_text(text_buf);
single_value->field_transport__level__marking.encode_text(text_buf);
single_value->field_forwarding__policy.encode_text(text_buf);
single_value->field_header__enrichment.encode_text(text_buf);
single_value->field_traffic__endpoint__ID.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @PFCP_Types.Forwarding_Parameters.grouped_ie.");
}
}

void Forwarding__Parameters_grouped__ie_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_destination__interface.decode_text(text_buf);
single_value->field_pdn__Instance.decode_text(text_buf);
single_value->field_redirect__information.decode_text(text_buf);
single_value->field_outer__header__creation.decode_text(text_buf);
single_value->field_transport__level__marking.decode_text(text_buf);
single_value->field_forwarding__policy.decode_text(text_buf);
single_value->field_header__enrichment.decode_text(text_buf);
single_value->field_traffic__endpoint__ID.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new Forwarding__Parameters_grouped__ie_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @PFCP_Types.Forwarding_Parameters.grouped_ie.");
}
}

void Forwarding__Parameters_grouped__ie_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "set template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    Forwarding__Parameters_grouped__ie_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (8<param.get_size()) {
      param.error("set template of type @PFCP_Types.Forwarding_Parameters.grouped_ie has 8 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) destination__interface().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) pdn__Instance().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) redirect__information().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) outer__header__creation().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) transport__level__marking().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) forwarding__policy().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) header__enrichment().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) traffic__endpoint__ID().set_param(*param.get_elem(7));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "destination_interface")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          destination__interface().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pdn_Instance")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pdn__Instance().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "redirect_information")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          redirect__information().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "outer_header_creation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          outer__header__creation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "transport_level_marking")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          transport__level__marking().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "forwarding_policy")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          forwarding__policy().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "header_enrichment")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          header__enrichment().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "traffic_endpoint_ID")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          traffic__endpoint__ID().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @PFCP_Types.Forwarding_Parameters.grouped_ie: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    Forwarding__Parameters_grouped__ie_template* precondition = new Forwarding__Parameters_grouped__ie_template;
    precondition->set_param(*param.get_elem(0));
    Forwarding__Parameters_grouped__ie_template* implied_template = new Forwarding__Parameters_grouped__ie_template;
    implied_template->set_param(*param.get_elem(1));
    *this = Forwarding__Parameters_grouped__ie_template(precondition, implied_template);
  } break;
  default:
    param.type_error("set template", "@PFCP_Types.Forwarding_Parameters.grouped_ie");
  }
  is_ifpresent = param.get_ifpresent();
}

void Forwarding__Parameters_grouped__ie_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_destination__interface.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Forwarding_Parameters.grouped_ie");
single_value->field_pdn__Instance.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Forwarding_Parameters.grouped_ie");
single_value->field_redirect__information.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Forwarding_Parameters.grouped_ie");
single_value->field_outer__header__creation.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Forwarding_Parameters.grouped_ie");
single_value->field_transport__level__marking.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Forwarding_Parameters.grouped_ie");
single_value->field_forwarding__policy.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Forwarding_Parameters.grouped_ie");
single_value->field_header__enrichment.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Forwarding_Parameters.grouped_ie");
single_value->field_traffic__endpoint__ID.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Forwarding_Parameters.grouped_ie");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@PFCP_Types.Forwarding_Parameters.grouped_ie");
}

boolean Forwarding__Parameters_grouped__ie_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean Forwarding__Parameters_grouped__ie_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

Forwarding__Parameters::Forwarding__Parameters()
{
}

Forwarding__Parameters::Forwarding__Parameters(const INTEGER& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const Forwarding__Parameters_grouped__ie& par_grouped__ie)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_grouped__ie(par_grouped__ie)
{
}

Forwarding__Parameters::Forwarding__Parameters(const Forwarding__Parameters& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @PFCP_Types.Forwarding_Parameters.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.grouped__ie().is_bound()) field_grouped__ie = other_value.grouped__ie();
else field_grouped__ie.clean_up();
}

void Forwarding__Parameters::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_grouped__ie.clean_up();
}

const TTCN_Typedescriptor_t* Forwarding__Parameters::get_descriptor() const { return &Forwarding__Parameters_descr_; }
Forwarding__Parameters& Forwarding__Parameters::operator=(const Forwarding__Parameters& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @PFCP_Types.Forwarding_Parameters.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.grouped__ie().is_bound()) field_grouped__ie = other_value.grouped__ie();
  else field_grouped__ie.clean_up();
}
return *this;
}

boolean Forwarding__Parameters::operator==(const Forwarding__Parameters& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_grouped__ie==other_value.field_grouped__ie;
}

boolean Forwarding__Parameters::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_grouped__ie.is_bound());
}
boolean Forwarding__Parameters::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_grouped__ie.is_value();
}
void Forwarding__Parameters::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", grouped_ie := ");
field_grouped__ie.log();
TTCN_Logger::log_event_str(" }");
}

void Forwarding__Parameters::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (grouped__ie().is_bound()) grouped__ie().set_implicit_omit();
}

void Forwarding__Parameters::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @PFCP_Types.Forwarding_Parameters has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) grouped__ie().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "grouped_ie")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          grouped__ie().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @PFCP_Types.Forwarding_Parameters: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@PFCP_Types.Forwarding_Parameters");
  }
}

void Forwarding__Parameters::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_grouped__ie.encode_text(text_buf);
}

void Forwarding__Parameters::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_grouped__ie.decode_text(text_buf);
}

void Forwarding__Parameters::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Forwarding__Parameters::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int Forwarding__Parameters::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::LIN2__BO__LAST_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::LIN2__BO__LAST_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, Forwarding__Parameters_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(Forwarding__Parameters_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(Forwarding__Parameters_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, Forwarding__Parameters_grouped__ie_descr_.raw->forceomit);
  decoded_field_length = field_grouped__ie.RAW_decode(Forwarding__Parameters_grouped__ie_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_elementIdentifier != 4) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int Forwarding__Parameters::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::LIN2__BO__LAST_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, Forwarding__Parameters_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, Forwarding__Parameters_grouped__ie_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::LIN2__BO__LAST_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 16;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &Forwarding__Parameters_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[1]->length = 16;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_grouped__ie.RAW_encode(Forwarding__Parameters_grouped__ie_descr_, *myleaf.body.node.nodes[2]);
  if (field_elementIdentifier != 4) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
  INTEGER new_val = 4;
  new_val.RAW_encode(General__Types::LIN2__BO__LAST_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct Forwarding__Parameters_template::single_value_struct {
INTEGER_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
Forwarding__Parameters_grouped__ie_template field_grouped__ie;
};

void Forwarding__Parameters_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_grouped__ie = ANY_VALUE;
}
}
}

void Forwarding__Parameters_template::copy_value(const Forwarding__Parameters& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.grouped__ie().is_bound()) {
  single_value->field_grouped__ie = other_value.grouped__ie();
} else {
  single_value->field_grouped__ie.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void Forwarding__Parameters_template::copy_template(const Forwarding__Parameters_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.grouped__ie().get_selection()) {
single_value->field_grouped__ie = other_value.grouped__ie();
} else {
single_value->field_grouped__ie.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Forwarding__Parameters_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Forwarding__Parameters_template(*other_value.implication_.precondition);
implication_.implied_template = new Forwarding__Parameters_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @PFCP_Types.Forwarding_Parameters.");
break;
}
set_selection(other_value);
}

Forwarding__Parameters_template::Forwarding__Parameters_template()
{
}

Forwarding__Parameters_template::Forwarding__Parameters_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

Forwarding__Parameters_template::Forwarding__Parameters_template(const Forwarding__Parameters& other_value)
{
copy_value(other_value);
}

Forwarding__Parameters_template::Forwarding__Parameters_template(const OPTIONAL<Forwarding__Parameters>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Forwarding__Parameters&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @PFCP_Types.Forwarding_Parameters from an unbound optional field.");
}
}

Forwarding__Parameters_template::Forwarding__Parameters_template(Forwarding__Parameters_template* p_precondition, Forwarding__Parameters_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

Forwarding__Parameters_template::Forwarding__Parameters_template(Dynamic_Match_Interface<Forwarding__Parameters>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<Forwarding__Parameters>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

Forwarding__Parameters_template::Forwarding__Parameters_template(const Forwarding__Parameters_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

Forwarding__Parameters_template::~Forwarding__Parameters_template()
{
clean_up();
}

Forwarding__Parameters_template& Forwarding__Parameters_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

Forwarding__Parameters_template& Forwarding__Parameters_template::operator=(const Forwarding__Parameters& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

Forwarding__Parameters_template& Forwarding__Parameters_template::operator=(const OPTIONAL<Forwarding__Parameters>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Forwarding__Parameters&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @PFCP_Types.Forwarding_Parameters.");
}
return *this;
}

Forwarding__Parameters_template& Forwarding__Parameters_template::operator=(const Forwarding__Parameters_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean Forwarding__Parameters_template::match(const Forwarding__Parameters& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.grouped__ie().is_bound()) return FALSE;
if(!single_value->field_grouped__ie.match(other_value.grouped__ie(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @PFCP_Types.Forwarding_Parameters.");
}
return FALSE;
}

boolean Forwarding__Parameters_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_grouped__ie.is_bound();
}

boolean Forwarding__Parameters_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_grouped__ie.is_value();
}

void Forwarding__Parameters_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

Forwarding__Parameters Forwarding__Parameters_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @PFCP_Types.Forwarding_Parameters.");
Forwarding__Parameters ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_grouped__ie.is_bound()) {
ret_val.grouped__ie() = single_value->field_grouped__ie.valueof();
}
return ret_val;
}

void Forwarding__Parameters_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @PFCP_Types.Forwarding_Parameters.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new Forwarding__Parameters_template[list_length];
}

Forwarding__Parameters_template& Forwarding__Parameters_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @PFCP_Types.Forwarding_Parameters.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @PFCP_Types.Forwarding_Parameters.");
return value_list.list_value[list_index];
}

INTEGER_template& Forwarding__Parameters_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const INTEGER_template& Forwarding__Parameters_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @PFCP_Types.Forwarding_Parameters.");
return single_value->field_elementIdentifier;
}

INTEGER_template& Forwarding__Parameters_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& Forwarding__Parameters_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @PFCP_Types.Forwarding_Parameters.");
return single_value->field_lengthIndicator;
}

Forwarding__Parameters_grouped__ie_template& Forwarding__Parameters_template::grouped__ie()
{
set_specific();
return single_value->field_grouped__ie;
}

const Forwarding__Parameters_grouped__ie_template& Forwarding__Parameters_template::grouped__ie() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field grouped_ie of a non-specific template of type @PFCP_Types.Forwarding_Parameters.");
return single_value->field_grouped__ie;
}

int Forwarding__Parameters_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Forwarding_Parameters which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @PFCP_Types.Forwarding_Parameters containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Forwarding_Parameters containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Forwarding_Parameters containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Forwarding_Parameters containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Forwarding_Parameters containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Forwarding_Parameters containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Forwarding_Parameters containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Forwarding_Parameters containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @PFCP_Types.Forwarding_Parameters.");
  }
  return 0;
}

void Forwarding__Parameters_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", grouped_ie := ");
single_value->field_grouped__ie.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void Forwarding__Parameters_template::log_match(const Forwarding__Parameters& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_grouped__ie.match(match_value.grouped__ie(), legacy)){
TTCN_Logger::log_logmatch_info(".grouped_ie");
single_value->field_grouped__ie.log_match(match_value.grouped__ie(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", grouped_ie := ");
single_value->field_grouped__ie.log_match(match_value.grouped__ie(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void Forwarding__Parameters_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (grouped__ie().is_bound()) grouped__ie().set_implicit_omit();
}

void Forwarding__Parameters_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_grouped__ie.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @PFCP_Types.Forwarding_Parameters.");
}
}

void Forwarding__Parameters_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_grouped__ie.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new Forwarding__Parameters_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @PFCP_Types.Forwarding_Parameters.");
}
}

void Forwarding__Parameters_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    Forwarding__Parameters_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @PFCP_Types.Forwarding_Parameters has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) grouped__ie().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "grouped_ie")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          grouped__ie().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @PFCP_Types.Forwarding_Parameters: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    Forwarding__Parameters_template* precondition = new Forwarding__Parameters_template;
    precondition->set_param(*param.get_elem(0));
    Forwarding__Parameters_template* implied_template = new Forwarding__Parameters_template;
    implied_template->set_param(*param.get_elem(1));
    *this = Forwarding__Parameters_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@PFCP_Types.Forwarding_Parameters");
  }
  is_ifpresent = param.get_ifpresent();
}

void Forwarding__Parameters_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Forwarding_Parameters");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Forwarding_Parameters");
single_value->field_grouped__ie.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Forwarding_Parameters");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@PFCP_Types.Forwarding_Parameters");
}

boolean Forwarding__Parameters_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean Forwarding__Parameters_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

Duplicating__Parameters_grouped__ie::Duplicating__Parameters_grouped__ie()
{
}

Duplicating__Parameters_grouped__ie::Duplicating__Parameters_grouped__ie(const Destination__Interface& par_destination__interface,
    const OPTIONAL< Outer__Header__Creation >& par_outer__header__creation,
    const OPTIONAL< DL__Transport__Level__Marking >& par_transport__level__marking,
    const OPTIONAL< Forwarding__Policy >& par_forwarding__policy)
  :   field_destination__interface(par_destination__interface),
  field_outer__header__creation(par_outer__header__creation),
  field_transport__level__marking(par_transport__level__marking),
  field_forwarding__policy(par_forwarding__policy)
{
}

Duplicating__Parameters_grouped__ie::Duplicating__Parameters_grouped__ie(const Duplicating__Parameters_grouped__ie& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @PFCP_Types.Duplicating_Parameters.grouped_ie.");
if (other_value.destination__interface().is_bound()) field_destination__interface = other_value.destination__interface();
else field_destination__interface.clean_up();
if (other_value.outer__header__creation().is_bound()) field_outer__header__creation = other_value.outer__header__creation();
else field_outer__header__creation.clean_up();
if (other_value.transport__level__marking().is_bound()) field_transport__level__marking = other_value.transport__level__marking();
else field_transport__level__marking.clean_up();
if (other_value.forwarding__policy().is_bound()) field_forwarding__policy = other_value.forwarding__policy();
else field_forwarding__policy.clean_up();
}

void Duplicating__Parameters_grouped__ie::clean_up()
{
field_destination__interface.clean_up();
field_outer__header__creation.clean_up();
field_transport__level__marking.clean_up();
field_forwarding__policy.clean_up();
}

const TTCN_Typedescriptor_t* Duplicating__Parameters_grouped__ie::get_descriptor() const { return &Duplicating__Parameters_grouped__ie_descr_; }
Duplicating__Parameters_grouped__ie& Duplicating__Parameters_grouped__ie::operator=(const Duplicating__Parameters_grouped__ie& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @PFCP_Types.Duplicating_Parameters.grouped_ie.");
  if (other_value.destination__interface().is_bound()) field_destination__interface = other_value.destination__interface();
  else field_destination__interface.clean_up();
  if (other_value.outer__header__creation().is_bound()) field_outer__header__creation = other_value.outer__header__creation();
  else field_outer__header__creation.clean_up();
  if (other_value.transport__level__marking().is_bound()) field_transport__level__marking = other_value.transport__level__marking();
  else field_transport__level__marking.clean_up();
  if (other_value.forwarding__policy().is_bound()) field_forwarding__policy = other_value.forwarding__policy();
  else field_forwarding__policy.clean_up();
}
return *this;
}

boolean Duplicating__Parameters_grouped__ie::operator==(const Duplicating__Parameters_grouped__ie& other_value) const
{
return field_destination__interface==other_value.field_destination__interface
  && field_outer__header__creation==other_value.field_outer__header__creation
  && field_transport__level__marking==other_value.field_transport__level__marking
  && field_forwarding__policy==other_value.field_forwarding__policy;
}

boolean Duplicating__Parameters_grouped__ie::is_bound() const
{
return (field_destination__interface.is_bound())
  || (OPTIONAL_OMIT == field_outer__header__creation.get_selection() || field_outer__header__creation.is_bound())
  || (OPTIONAL_OMIT == field_transport__level__marking.get_selection() || field_transport__level__marking.is_bound())
  || (OPTIONAL_OMIT == field_forwarding__policy.get_selection() || field_forwarding__policy.is_bound());
}
boolean Duplicating__Parameters_grouped__ie::is_value() const
{
return field_destination__interface.is_value()
  && (OPTIONAL_OMIT == field_outer__header__creation.get_selection() || field_outer__header__creation.is_value())
  && (OPTIONAL_OMIT == field_transport__level__marking.get_selection() || field_transport__level__marking.is_value())
  && (OPTIONAL_OMIT == field_forwarding__policy.get_selection() || field_forwarding__policy.is_value());
}
int Duplicating__Parameters_grouped__ie::size_of() const
{
  int ret_val = 1;
  if (field_outer__header__creation.ispresent()) ret_val++;
  if (field_transport__level__marking.ispresent()) ret_val++;
  if (field_forwarding__policy.ispresent()) ret_val++;
  return ret_val;
}

void Duplicating__Parameters_grouped__ie::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ destination_interface := ");
field_destination__interface.log();
TTCN_Logger::log_event_str(", outer_header_creation := ");
field_outer__header__creation.log();
TTCN_Logger::log_event_str(", transport_level_marking := ");
field_transport__level__marking.log();
TTCN_Logger::log_event_str(", forwarding_policy := ");
field_forwarding__policy.log();
TTCN_Logger::log_event_str(" }");
}

void Duplicating__Parameters_grouped__ie::set_implicit_omit()
{
if (destination__interface().is_bound()) destination__interface().set_implicit_omit();
if (!outer__header__creation().is_bound()) outer__header__creation() = OMIT_VALUE;
else outer__header__creation().set_implicit_omit();
if (!transport__level__marking().is_bound()) transport__level__marking() = OMIT_VALUE;
else transport__level__marking().set_implicit_omit();
if (!forwarding__policy().is_bound()) forwarding__policy() = OMIT_VALUE;
else forwarding__policy().set_implicit_omit();
}

void Duplicating__Parameters_grouped__ie::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "set value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("set value of type @PFCP_Types.Duplicating_Parameters.grouped_ie has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) destination__interface().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) outer__header__creation().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) transport__level__marking().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) forwarding__policy().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "destination_interface")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          destination__interface().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "outer_header_creation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          outer__header__creation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "transport_level_marking")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          transport__level__marking().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "forwarding_policy")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          forwarding__policy().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @PFCP_Types.Duplicating_Parameters.grouped_ie: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("set value", "@PFCP_Types.Duplicating_Parameters.grouped_ie");
  }
}

void Duplicating__Parameters_grouped__ie::encode_text(Text_Buf& text_buf) const
{
field_destination__interface.encode_text(text_buf);
field_outer__header__creation.encode_text(text_buf);
field_transport__level__marking.encode_text(text_buf);
field_forwarding__policy.encode_text(text_buf);
}

void Duplicating__Parameters_grouped__ie::decode_text(Text_Buf& text_buf)
{
field_destination__interface.decode_text(text_buf);
field_outer__header__creation.decode_text(text_buf);
field_transport__level__marking.decode_text(text_buf);
field_forwarding__policy.decode_text(text_buf);
}

void Duplicating__Parameters_grouped__ie::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Duplicating__Parameters_grouped__ie::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int Duplicating__Parameters_grouped__ie::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean, int, boolean, const RAW_Force_Omit* force_omit)
{
int prepaddlength = p_buf.increase_pos_padd(p_td.raw->prepadding);
limit -= prepaddlength;
int decoded_length = 0;
int field_map[4];
memset(field_map, 0, sizeof(field_map));
size_t nof_mand_fields = 0;
field_outer__header__creation = OMIT_VALUE;
field_transport__level__marking = OMIT_VALUE;
field_forwarding__policy = OMIT_VALUE;
raw_order_t local_top_order;
if (p_td.raw->top_bit_order == TOP_BIT_INHERITED) local_top_order = top_bit_ord;
else if (p_td.raw->top_bit_order == TOP_BIT_RIGHT) local_top_order = ORDER_MSB;
else local_top_order = ORDER_LSB;
while (limit > 0) {
size_t fl_start_pos = p_buf.get_pos_bit();
if (field_map[0] == 0) {
RAW_Force_Omit field_0_force_omit(0, force_omit, Destination__Interface_descr_.raw->forceomit);
int decoded_field_length = field_destination__interface.RAW_decode(Destination__Interface_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_0_force_omit);
if (decoded_field_length >= 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
nof_mand_fields++;
field_map[0] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
}
}
if (field_map[1] == 0 && (force_omit == NULL || !(*force_omit)(1))) {
RAW_Force_Omit field_1_force_omit(1, force_omit, Outer__Header__Creation_descr_.raw->forceomit);
int decoded_field_length = field_outer__header__creation().RAW_decode(Outer__Header__Creation_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_1_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[1] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_outer__header__creation = OMIT_VALUE;
}
}
if (field_map[2] == 0 && (force_omit == NULL || !(*force_omit)(2))) {
RAW_Force_Omit field_2_force_omit(2, force_omit, DL__Transport__Level__Marking_descr_.raw->forceomit);
int decoded_field_length = field_transport__level__marking().RAW_decode(DL__Transport__Level__Marking_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[2] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_transport__level__marking = OMIT_VALUE;
}
}
if (field_map[3] == 0 && (force_omit == NULL || !(*force_omit)(3))) {
RAW_Force_Omit field_3_force_omit(3, force_omit, Forwarding__Policy_descr_.raw->forceomit);
int decoded_field_length = field_forwarding__policy().RAW_decode(Forwarding__Policy_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[3] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_forwarding__policy = OMIT_VALUE;
}
}
break;
}
if (nof_mand_fields != 1) return limit ? -1 : -TTCN_EncDec::ET_INCOMPL_MSG;
return decoded_length + prepaddlength + p_buf.increase_pos_padd(p_td.raw->padding);
}

int Duplicating__Parameters_grouped__ie::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, Destination__Interface_descr_.raw);
  if (field_outer__header__creation.ispresent()) {
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, Outer__Header__Creation_descr_.raw);
  }
  else myleaf.body.node.nodes[1] = NULL;
  if (field_transport__level__marking.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, DL__Transport__Level__Marking_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  if (field_forwarding__policy.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, Forwarding__Policy_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  encoded_length += field_destination__interface.RAW_encode(Destination__Interface_descr_, *myleaf.body.node.nodes[0]);
  if (field_outer__header__creation.ispresent()) {
  encoded_length += field_outer__header__creation().RAW_encode(Outer__Header__Creation_descr_, *myleaf.body.node.nodes[1]);
  }
  if (field_transport__level__marking.ispresent()) {
  encoded_length += field_transport__level__marking().RAW_encode(DL__Transport__Level__Marking_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_forwarding__policy.ispresent()) {
  encoded_length += field_forwarding__policy().RAW_encode(Forwarding__Policy_descr_, *myleaf.body.node.nodes[3]);
  }
  return myleaf.length = encoded_length;
}

struct Duplicating__Parameters_grouped__ie_template::single_value_struct {
Destination__Interface_template field_destination__interface;
Outer__Header__Creation_template field_outer__header__creation;
DL__Transport__Level__Marking_template field_transport__level__marking;
Forwarding__Policy_template field_forwarding__policy;
};

void Duplicating__Parameters_grouped__ie_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_destination__interface = ANY_VALUE;
single_value->field_outer__header__creation = ANY_OR_OMIT;
single_value->field_transport__level__marking = ANY_OR_OMIT;
single_value->field_forwarding__policy = ANY_OR_OMIT;
}
}
}

void Duplicating__Parameters_grouped__ie_template::copy_value(const Duplicating__Parameters_grouped__ie& other_value)
{
single_value = new single_value_struct;
if (other_value.destination__interface().is_bound()) {
  single_value->field_destination__interface = other_value.destination__interface();
} else {
  single_value->field_destination__interface.clean_up();
}
if (other_value.outer__header__creation().is_bound()) {
  if (other_value.outer__header__creation().ispresent()) single_value->field_outer__header__creation = other_value.outer__header__creation()();
  else single_value->field_outer__header__creation = OMIT_VALUE;
} else {
  single_value->field_outer__header__creation.clean_up();
}
if (other_value.transport__level__marking().is_bound()) {
  if (other_value.transport__level__marking().ispresent()) single_value->field_transport__level__marking = other_value.transport__level__marking()();
  else single_value->field_transport__level__marking = OMIT_VALUE;
} else {
  single_value->field_transport__level__marking.clean_up();
}
if (other_value.forwarding__policy().is_bound()) {
  if (other_value.forwarding__policy().ispresent()) single_value->field_forwarding__policy = other_value.forwarding__policy()();
  else single_value->field_forwarding__policy = OMIT_VALUE;
} else {
  single_value->field_forwarding__policy.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void Duplicating__Parameters_grouped__ie_template::copy_template(const Duplicating__Parameters_grouped__ie_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.destination__interface().get_selection()) {
single_value->field_destination__interface = other_value.destination__interface();
} else {
single_value->field_destination__interface.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.outer__header__creation().get_selection()) {
single_value->field_outer__header__creation = other_value.outer__header__creation();
} else {
single_value->field_outer__header__creation.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.transport__level__marking().get_selection()) {
single_value->field_transport__level__marking = other_value.transport__level__marking();
} else {
single_value->field_transport__level__marking.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.forwarding__policy().get_selection()) {
single_value->field_forwarding__policy = other_value.forwarding__policy();
} else {
single_value->field_forwarding__policy.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Duplicating__Parameters_grouped__ie_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Duplicating__Parameters_grouped__ie_template(*other_value.implication_.precondition);
implication_.implied_template = new Duplicating__Parameters_grouped__ie_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @PFCP_Types.Duplicating_Parameters.grouped_ie.");
break;
}
set_selection(other_value);
}

Duplicating__Parameters_grouped__ie_template::Duplicating__Parameters_grouped__ie_template()
{
}

Duplicating__Parameters_grouped__ie_template::Duplicating__Parameters_grouped__ie_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

Duplicating__Parameters_grouped__ie_template::Duplicating__Parameters_grouped__ie_template(const Duplicating__Parameters_grouped__ie& other_value)
{
copy_value(other_value);
}

Duplicating__Parameters_grouped__ie_template::Duplicating__Parameters_grouped__ie_template(const OPTIONAL<Duplicating__Parameters_grouped__ie>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Duplicating__Parameters_grouped__ie&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @PFCP_Types.Duplicating_Parameters.grouped_ie from an unbound optional field.");
}
}

Duplicating__Parameters_grouped__ie_template::Duplicating__Parameters_grouped__ie_template(Duplicating__Parameters_grouped__ie_template* p_precondition, Duplicating__Parameters_grouped__ie_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

Duplicating__Parameters_grouped__ie_template::Duplicating__Parameters_grouped__ie_template(Dynamic_Match_Interface<Duplicating__Parameters_grouped__ie>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<Duplicating__Parameters_grouped__ie>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

Duplicating__Parameters_grouped__ie_template::Duplicating__Parameters_grouped__ie_template(const Duplicating__Parameters_grouped__ie_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

Duplicating__Parameters_grouped__ie_template::~Duplicating__Parameters_grouped__ie_template()
{
clean_up();
}

Duplicating__Parameters_grouped__ie_template& Duplicating__Parameters_grouped__ie_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

Duplicating__Parameters_grouped__ie_template& Duplicating__Parameters_grouped__ie_template::operator=(const Duplicating__Parameters_grouped__ie& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

Duplicating__Parameters_grouped__ie_template& Duplicating__Parameters_grouped__ie_template::operator=(const OPTIONAL<Duplicating__Parameters_grouped__ie>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Duplicating__Parameters_grouped__ie&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @PFCP_Types.Duplicating_Parameters.grouped_ie.");
}
return *this;
}

Duplicating__Parameters_grouped__ie_template& Duplicating__Parameters_grouped__ie_template::operator=(const Duplicating__Parameters_grouped__ie_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean Duplicating__Parameters_grouped__ie_template::match(const Duplicating__Parameters_grouped__ie& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.destination__interface().is_bound()) return FALSE;
if(!single_value->field_destination__interface.match(other_value.destination__interface(), legacy))return FALSE;
if(!other_value.outer__header__creation().is_bound()) return FALSE;
if((other_value.outer__header__creation().ispresent() ? !single_value->field_outer__header__creation.match((const Outer__Header__Creation&)other_value.outer__header__creation(), legacy) : !single_value->field_outer__header__creation.match_omit(legacy)))return FALSE;
if(!other_value.transport__level__marking().is_bound()) return FALSE;
if((other_value.transport__level__marking().ispresent() ? !single_value->field_transport__level__marking.match((const DL__Transport__Level__Marking&)other_value.transport__level__marking(), legacy) : !single_value->field_transport__level__marking.match_omit(legacy)))return FALSE;
if(!other_value.forwarding__policy().is_bound()) return FALSE;
if((other_value.forwarding__policy().ispresent() ? !single_value->field_forwarding__policy.match((const Forwarding__Policy&)other_value.forwarding__policy(), legacy) : !single_value->field_forwarding__policy.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @PFCP_Types.Duplicating_Parameters.grouped_ie.");
}
return FALSE;
}

boolean Duplicating__Parameters_grouped__ie_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_destination__interface.is_bound()
 || (single_value->field_outer__header__creation.is_omit() || single_value->field_outer__header__creation.is_bound())
 || (single_value->field_transport__level__marking.is_omit() || single_value->field_transport__level__marking.is_bound())
 || (single_value->field_forwarding__policy.is_omit() || single_value->field_forwarding__policy.is_bound());
}

boolean Duplicating__Parameters_grouped__ie_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_destination__interface.is_value()
 && (single_value->field_outer__header__creation.is_omit() || single_value->field_outer__header__creation.is_value())
 && (single_value->field_transport__level__marking.is_omit() || single_value->field_transport__level__marking.is_value())
 && (single_value->field_forwarding__policy.is_omit() || single_value->field_forwarding__policy.is_value());
}

void Duplicating__Parameters_grouped__ie_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

Duplicating__Parameters_grouped__ie Duplicating__Parameters_grouped__ie_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @PFCP_Types.Duplicating_Parameters.grouped_ie.");
Duplicating__Parameters_grouped__ie ret_val;
if (single_value->field_destination__interface.is_bound()) {
ret_val.destination__interface() = single_value->field_destination__interface.valueof();
}
if (single_value->field_outer__header__creation.is_omit()) ret_val.outer__header__creation() = OMIT_VALUE;
else if (single_value->field_outer__header__creation.is_bound()) {
ret_val.outer__header__creation() = single_value->field_outer__header__creation.valueof();
}
if (single_value->field_transport__level__marking.is_omit()) ret_val.transport__level__marking() = OMIT_VALUE;
else if (single_value->field_transport__level__marking.is_bound()) {
ret_val.transport__level__marking() = single_value->field_transport__level__marking.valueof();
}
if (single_value->field_forwarding__policy.is_omit()) ret_val.forwarding__policy() = OMIT_VALUE;
else if (single_value->field_forwarding__policy.is_bound()) {
ret_val.forwarding__policy() = single_value->field_forwarding__policy.valueof();
}
return ret_val;
}

void Duplicating__Parameters_grouped__ie_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @PFCP_Types.Duplicating_Parameters.grouped_ie.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new Duplicating__Parameters_grouped__ie_template[list_length];
}

Duplicating__Parameters_grouped__ie_template& Duplicating__Parameters_grouped__ie_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @PFCP_Types.Duplicating_Parameters.grouped_ie.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @PFCP_Types.Duplicating_Parameters.grouped_ie.");
return value_list.list_value[list_index];
}

Destination__Interface_template& Duplicating__Parameters_grouped__ie_template::destination__interface()
{
set_specific();
return single_value->field_destination__interface;
}

const Destination__Interface_template& Duplicating__Parameters_grouped__ie_template::destination__interface() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field destination_interface of a non-specific template of type @PFCP_Types.Duplicating_Parameters.grouped_ie.");
return single_value->field_destination__interface;
}

Outer__Header__Creation_template& Duplicating__Parameters_grouped__ie_template::outer__header__creation()
{
set_specific();
return single_value->field_outer__header__creation;
}

const Outer__Header__Creation_template& Duplicating__Parameters_grouped__ie_template::outer__header__creation() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field outer_header_creation of a non-specific template of type @PFCP_Types.Duplicating_Parameters.grouped_ie.");
return single_value->field_outer__header__creation;
}

DL__Transport__Level__Marking_template& Duplicating__Parameters_grouped__ie_template::transport__level__marking()
{
set_specific();
return single_value->field_transport__level__marking;
}

const DL__Transport__Level__Marking_template& Duplicating__Parameters_grouped__ie_template::transport__level__marking() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field transport_level_marking of a non-specific template of type @PFCP_Types.Duplicating_Parameters.grouped_ie.");
return single_value->field_transport__level__marking;
}

Forwarding__Policy_template& Duplicating__Parameters_grouped__ie_template::forwarding__policy()
{
set_specific();
return single_value->field_forwarding__policy;
}

const Forwarding__Policy_template& Duplicating__Parameters_grouped__ie_template::forwarding__policy() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field forwarding_policy of a non-specific template of type @PFCP_Types.Duplicating_Parameters.grouped_ie.");
return single_value->field_forwarding__policy;
}

int Duplicating__Parameters_grouped__ie_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Duplicating_Parameters.grouped_ie which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_outer__header__creation.is_present()) ret_val++;
      if (single_value->field_transport__level__marking.is_present()) ret_val++;
      if (single_value->field_forwarding__policy.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @PFCP_Types.Duplicating_Parameters.grouped_ie containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Duplicating_Parameters.grouped_ie containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Duplicating_Parameters.grouped_ie containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Duplicating_Parameters.grouped_ie containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Duplicating_Parameters.grouped_ie containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Duplicating_Parameters.grouped_ie containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Duplicating_Parameters.grouped_ie containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Duplicating_Parameters.grouped_ie containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @PFCP_Types.Duplicating_Parameters.grouped_ie.");
  }
  return 0;
}

void Duplicating__Parameters_grouped__ie_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ destination_interface := ");
single_value->field_destination__interface.log();
TTCN_Logger::log_event_str(", outer_header_creation := ");
single_value->field_outer__header__creation.log();
TTCN_Logger::log_event_str(", transport_level_marking := ");
single_value->field_transport__level__marking.log();
TTCN_Logger::log_event_str(", forwarding_policy := ");
single_value->field_forwarding__policy.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void Duplicating__Parameters_grouped__ie_template::log_match(const Duplicating__Parameters_grouped__ie& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_destination__interface.match(match_value.destination__interface(), legacy)){
TTCN_Logger::log_logmatch_info(".destination_interface");
single_value->field_destination__interface.log_match(match_value.destination__interface(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.outer__header__creation().ispresent()){
if(!single_value->field_outer__header__creation.match(match_value.outer__header__creation(), legacy)){
TTCN_Logger::log_logmatch_info(".outer_header_creation");
single_value->field_outer__header__creation.log_match(match_value.outer__header__creation(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_outer__header__creation.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".outer_header_creation := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_outer__header__creation.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.transport__level__marking().ispresent()){
if(!single_value->field_transport__level__marking.match(match_value.transport__level__marking(), legacy)){
TTCN_Logger::log_logmatch_info(".transport_level_marking");
single_value->field_transport__level__marking.log_match(match_value.transport__level__marking(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_transport__level__marking.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".transport_level_marking := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_transport__level__marking.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.forwarding__policy().ispresent()){
if(!single_value->field_forwarding__policy.match(match_value.forwarding__policy(), legacy)){
TTCN_Logger::log_logmatch_info(".forwarding_policy");
single_value->field_forwarding__policy.log_match(match_value.forwarding__policy(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_forwarding__policy.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".forwarding_policy := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_forwarding__policy.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ destination_interface := ");
single_value->field_destination__interface.log_match(match_value.destination__interface(), legacy);
TTCN_Logger::log_event_str(", outer_header_creation := ");
if (match_value.outer__header__creation().ispresent()) {
single_value->field_outer__header__creation.log_match(match_value.outer__header__creation(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_outer__header__creation.log();
if (single_value->field_outer__header__creation.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", transport_level_marking := ");
if (match_value.transport__level__marking().ispresent()) {
single_value->field_transport__level__marking.log_match(match_value.transport__level__marking(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_transport__level__marking.log();
if (single_value->field_transport__level__marking.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", forwarding_policy := ");
if (match_value.forwarding__policy().ispresent()) {
single_value->field_forwarding__policy.log_match(match_value.forwarding__policy(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_forwarding__policy.log();
if (single_value->field_forwarding__policy.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void Duplicating__Parameters_grouped__ie_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (destination__interface().is_bound()) destination__interface().set_implicit_omit();
if (!outer__header__creation().is_bound()) outer__header__creation() = OMIT_VALUE;
else outer__header__creation().set_implicit_omit();
if (!transport__level__marking().is_bound()) transport__level__marking() = OMIT_VALUE;
else transport__level__marking().set_implicit_omit();
if (!forwarding__policy().is_bound()) forwarding__policy() = OMIT_VALUE;
else forwarding__policy().set_implicit_omit();
}

void Duplicating__Parameters_grouped__ie_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_destination__interface.encode_text(text_buf);
single_value->field_outer__header__creation.encode_text(text_buf);
single_value->field_transport__level__marking.encode_text(text_buf);
single_value->field_forwarding__policy.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @PFCP_Types.Duplicating_Parameters.grouped_ie.");
}
}

void Duplicating__Parameters_grouped__ie_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_destination__interface.decode_text(text_buf);
single_value->field_outer__header__creation.decode_text(text_buf);
single_value->field_transport__level__marking.decode_text(text_buf);
single_value->field_forwarding__policy.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new Duplicating__Parameters_grouped__ie_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @PFCP_Types.Duplicating_Parameters.grouped_ie.");
}
}

void Duplicating__Parameters_grouped__ie_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "set template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    Duplicating__Parameters_grouped__ie_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("set template of type @PFCP_Types.Duplicating_Parameters.grouped_ie has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) destination__interface().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) outer__header__creation().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) transport__level__marking().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) forwarding__policy().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "destination_interface")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          destination__interface().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "outer_header_creation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          outer__header__creation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "transport_level_marking")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          transport__level__marking().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "forwarding_policy")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          forwarding__policy().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @PFCP_Types.Duplicating_Parameters.grouped_ie: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    Duplicating__Parameters_grouped__ie_template* precondition = new Duplicating__Parameters_grouped__ie_template;
    precondition->set_param(*param.get_elem(0));
    Duplicating__Parameters_grouped__ie_template* implied_template = new Duplicating__Parameters_grouped__ie_template;
    implied_template->set_param(*param.get_elem(1));
    *this = Duplicating__Parameters_grouped__ie_template(precondition, implied_template);
  } break;
  default:
    param.type_error("set template", "@PFCP_Types.Duplicating_Parameters.grouped_ie");
  }
  is_ifpresent = param.get_ifpresent();
}

void Duplicating__Parameters_grouped__ie_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_destination__interface.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Duplicating_Parameters.grouped_ie");
single_value->field_outer__header__creation.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Duplicating_Parameters.grouped_ie");
single_value->field_transport__level__marking.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Duplicating_Parameters.grouped_ie");
single_value->field_forwarding__policy.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Duplicating_Parameters.grouped_ie");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@PFCP_Types.Duplicating_Parameters.grouped_ie");
}

boolean Duplicating__Parameters_grouped__ie_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean Duplicating__Parameters_grouped__ie_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

Duplicating__Parameters::Duplicating__Parameters()
{
}

Duplicating__Parameters::Duplicating__Parameters(const INTEGER& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const Duplicating__Parameters_grouped__ie& par_grouped__ie)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_grouped__ie(par_grouped__ie)
{
}

Duplicating__Parameters::Duplicating__Parameters(const Duplicating__Parameters& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @PFCP_Types.Duplicating_Parameters.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.grouped__ie().is_bound()) field_grouped__ie = other_value.grouped__ie();
else field_grouped__ie.clean_up();
}

void Duplicating__Parameters::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_grouped__ie.clean_up();
}

const TTCN_Typedescriptor_t* Duplicating__Parameters::get_descriptor() const { return &Duplicating__Parameters_descr_; }
Duplicating__Parameters& Duplicating__Parameters::operator=(const Duplicating__Parameters& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @PFCP_Types.Duplicating_Parameters.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.grouped__ie().is_bound()) field_grouped__ie = other_value.grouped__ie();
  else field_grouped__ie.clean_up();
}
return *this;
}

boolean Duplicating__Parameters::operator==(const Duplicating__Parameters& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_grouped__ie==other_value.field_grouped__ie;
}

boolean Duplicating__Parameters::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_grouped__ie.is_bound());
}
boolean Duplicating__Parameters::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_grouped__ie.is_value();
}
void Duplicating__Parameters::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", grouped_ie := ");
field_grouped__ie.log();
TTCN_Logger::log_event_str(" }");
}

void Duplicating__Parameters::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (grouped__ie().is_bound()) grouped__ie().set_implicit_omit();
}

void Duplicating__Parameters::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @PFCP_Types.Duplicating_Parameters has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) grouped__ie().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "grouped_ie")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          grouped__ie().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @PFCP_Types.Duplicating_Parameters: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@PFCP_Types.Duplicating_Parameters");
  }
}

void Duplicating__Parameters::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_grouped__ie.encode_text(text_buf);
}

void Duplicating__Parameters::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_grouped__ie.decode_text(text_buf);
}

void Duplicating__Parameters::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Duplicating__Parameters::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int Duplicating__Parameters::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::LIN2__BO__LAST_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::LIN2__BO__LAST_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, Duplicating__Parameters_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(Duplicating__Parameters_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(Duplicating__Parameters_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, Duplicating__Parameters_grouped__ie_descr_.raw->forceomit);
  decoded_field_length = field_grouped__ie.RAW_decode(Duplicating__Parameters_grouped__ie_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_elementIdentifier != 5) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int Duplicating__Parameters::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::LIN2__BO__LAST_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, Duplicating__Parameters_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, Duplicating__Parameters_grouped__ie_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::LIN2__BO__LAST_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 16;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &Duplicating__Parameters_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[1]->length = 16;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_grouped__ie.RAW_encode(Duplicating__Parameters_grouped__ie_descr_, *myleaf.body.node.nodes[2]);
  if (field_elementIdentifier != 5) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
  INTEGER new_val = 5;
  new_val.RAW_encode(General__Types::LIN2__BO__LAST_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct Duplicating__Parameters_template::single_value_struct {
INTEGER_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
Duplicating__Parameters_grouped__ie_template field_grouped__ie;
};

void Duplicating__Parameters_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_grouped__ie = ANY_VALUE;
}
}
}

void Duplicating__Parameters_template::copy_value(const Duplicating__Parameters& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.grouped__ie().is_bound()) {
  single_value->field_grouped__ie = other_value.grouped__ie();
} else {
  single_value->field_grouped__ie.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void Duplicating__Parameters_template::copy_template(const Duplicating__Parameters_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.grouped__ie().get_selection()) {
single_value->field_grouped__ie = other_value.grouped__ie();
} else {
single_value->field_grouped__ie.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Duplicating__Parameters_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Duplicating__Parameters_template(*other_value.implication_.precondition);
implication_.implied_template = new Duplicating__Parameters_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @PFCP_Types.Duplicating_Parameters.");
break;
}
set_selection(other_value);
}

Duplicating__Parameters_template::Duplicating__Parameters_template()
{
}

Duplicating__Parameters_template::Duplicating__Parameters_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

Duplicating__Parameters_template::Duplicating__Parameters_template(const Duplicating__Parameters& other_value)
{
copy_value(other_value);
}

Duplicating__Parameters_template::Duplicating__Parameters_template(const OPTIONAL<Duplicating__Parameters>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Duplicating__Parameters&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @PFCP_Types.Duplicating_Parameters from an unbound optional field.");
}
}

Duplicating__Parameters_template::Duplicating__Parameters_template(Duplicating__Parameters_template* p_precondition, Duplicating__Parameters_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

Duplicating__Parameters_template::Duplicating__Parameters_template(Dynamic_Match_Interface<Duplicating__Parameters>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<Duplicating__Parameters>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

Duplicating__Parameters_template::Duplicating__Parameters_template(const Duplicating__Parameters_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

Duplicating__Parameters_template::~Duplicating__Parameters_template()
{
clean_up();
}

Duplicating__Parameters_template& Duplicating__Parameters_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

Duplicating__Parameters_template& Duplicating__Parameters_template::operator=(const Duplicating__Parameters& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

Duplicating__Parameters_template& Duplicating__Parameters_template::operator=(const OPTIONAL<Duplicating__Parameters>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Duplicating__Parameters&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @PFCP_Types.Duplicating_Parameters.");
}
return *this;
}

Duplicating__Parameters_template& Duplicating__Parameters_template::operator=(const Duplicating__Parameters_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean Duplicating__Parameters_template::match(const Duplicating__Parameters& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.grouped__ie().is_bound()) return FALSE;
if(!single_value->field_grouped__ie.match(other_value.grouped__ie(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @PFCP_Types.Duplicating_Parameters.");
}
return FALSE;
}

boolean Duplicating__Parameters_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_grouped__ie.is_bound();
}

boolean Duplicating__Parameters_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_grouped__ie.is_value();
}

void Duplicating__Parameters_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

Duplicating__Parameters Duplicating__Parameters_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @PFCP_Types.Duplicating_Parameters.");
Duplicating__Parameters ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_grouped__ie.is_bound()) {
ret_val.grouped__ie() = single_value->field_grouped__ie.valueof();
}
return ret_val;
}

void Duplicating__Parameters_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @PFCP_Types.Duplicating_Parameters.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new Duplicating__Parameters_template[list_length];
}

Duplicating__Parameters_template& Duplicating__Parameters_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @PFCP_Types.Duplicating_Parameters.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @PFCP_Types.Duplicating_Parameters.");
return value_list.list_value[list_index];
}

INTEGER_template& Duplicating__Parameters_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const INTEGER_template& Duplicating__Parameters_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @PFCP_Types.Duplicating_Parameters.");
return single_value->field_elementIdentifier;
}

INTEGER_template& Duplicating__Parameters_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& Duplicating__Parameters_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @PFCP_Types.Duplicating_Parameters.");
return single_value->field_lengthIndicator;
}

Duplicating__Parameters_grouped__ie_template& Duplicating__Parameters_template::grouped__ie()
{
set_specific();
return single_value->field_grouped__ie;
}

const Duplicating__Parameters_grouped__ie_template& Duplicating__Parameters_template::grouped__ie() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field grouped_ie of a non-specific template of type @PFCP_Types.Duplicating_Parameters.");
return single_value->field_grouped__ie;
}

int Duplicating__Parameters_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Duplicating_Parameters which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @PFCP_Types.Duplicating_Parameters containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Duplicating_Parameters containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Duplicating_Parameters containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Duplicating_Parameters containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Duplicating_Parameters containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Duplicating_Parameters containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Duplicating_Parameters containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Duplicating_Parameters containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @PFCP_Types.Duplicating_Parameters.");
  }
  return 0;
}

void Duplicating__Parameters_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", grouped_ie := ");
single_value->field_grouped__ie.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void Duplicating__Parameters_template::log_match(const Duplicating__Parameters& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_grouped__ie.match(match_value.grouped__ie(), legacy)){
TTCN_Logger::log_logmatch_info(".grouped_ie");
single_value->field_grouped__ie.log_match(match_value.grouped__ie(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", grouped_ie := ");
single_value->field_grouped__ie.log_match(match_value.grouped__ie(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void Duplicating__Parameters_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (grouped__ie().is_bound()) grouped__ie().set_implicit_omit();
}

void Duplicating__Parameters_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_grouped__ie.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @PFCP_Types.Duplicating_Parameters.");
}
}

void Duplicating__Parameters_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_grouped__ie.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new Duplicating__Parameters_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @PFCP_Types.Duplicating_Parameters.");
}
}

void Duplicating__Parameters_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    Duplicating__Parameters_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @PFCP_Types.Duplicating_Parameters has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) grouped__ie().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "grouped_ie")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          grouped__ie().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @PFCP_Types.Duplicating_Parameters: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    Duplicating__Parameters_template* precondition = new Duplicating__Parameters_template;
    precondition->set_param(*param.get_elem(0));
    Duplicating__Parameters_template* implied_template = new Duplicating__Parameters_template;
    implied_template->set_param(*param.get_elem(1));
    *this = Duplicating__Parameters_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@PFCP_Types.Duplicating_Parameters");
  }
  is_ifpresent = param.get_ifpresent();
}

void Duplicating__Parameters_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Duplicating_Parameters");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Duplicating_Parameters");
single_value->field_grouped__ie.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Duplicating_Parameters");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@PFCP_Types.Duplicating_Parameters");
}

boolean Duplicating__Parameters_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean Duplicating__Parameters_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

Create__FAR::Create__FAR()
{
}

Create__FAR::Create__FAR(const INTEGER& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const Create__FAR_grouped__ie& par_grouped__ie)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_grouped__ie(par_grouped__ie)
{
}

Create__FAR::Create__FAR(const Create__FAR& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @PFCP_Types.Create_FAR.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.grouped__ie().is_bound()) field_grouped__ie = other_value.grouped__ie();
else field_grouped__ie.clean_up();
}

void Create__FAR::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_grouped__ie.clean_up();
}

const TTCN_Typedescriptor_t* Create__FAR::get_descriptor() const { return &Create__FAR_descr_; }
Create__FAR& Create__FAR::operator=(const Create__FAR& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @PFCP_Types.Create_FAR.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.grouped__ie().is_bound()) field_grouped__ie = other_value.grouped__ie();
  else field_grouped__ie.clean_up();
}
return *this;
}

boolean Create__FAR::operator==(const Create__FAR& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_grouped__ie==other_value.field_grouped__ie;
}

boolean Create__FAR::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_grouped__ie.is_bound());
}
boolean Create__FAR::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_grouped__ie.is_value();
}
void Create__FAR::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", grouped_ie := ");
field_grouped__ie.log();
TTCN_Logger::log_event_str(" }");
}

void Create__FAR::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (grouped__ie().is_bound()) grouped__ie().set_implicit_omit();
}

void Create__FAR::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @PFCP_Types.Create_FAR has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) grouped__ie().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "grouped_ie")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          grouped__ie().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @PFCP_Types.Create_FAR: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@PFCP_Types.Create_FAR");
  }
}

void Create__FAR::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_grouped__ie.encode_text(text_buf);
}

void Create__FAR::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_grouped__ie.decode_text(text_buf);
}

void Create__FAR::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Create__FAR::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int Create__FAR::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::LIN2__BO__LAST_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::LIN2__BO__LAST_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, Create__FAR_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(Create__FAR_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(Create__FAR_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, Create__FAR_grouped__ie_descr_.raw->forceomit);
  decoded_field_length = field_grouped__ie.RAW_decode(Create__FAR_grouped__ie_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_elementIdentifier != 3) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int Create__FAR::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::LIN2__BO__LAST_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, Create__FAR_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, Create__FAR_grouped__ie_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::LIN2__BO__LAST_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 16;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &Create__FAR_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[1]->length = 16;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_grouped__ie.RAW_encode(Create__FAR_grouped__ie_descr_, *myleaf.body.node.nodes[2]);
  if (field_elementIdentifier != 3) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
  INTEGER new_val = 3;
  new_val.RAW_encode(General__Types::LIN2__BO__LAST_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct Create__FAR_template::single_value_struct {
INTEGER_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
Create__FAR_grouped__ie_template field_grouped__ie;
};

void Create__FAR_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_grouped__ie = ANY_VALUE;
}
}
}

void Create__FAR_template::copy_value(const Create__FAR& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.grouped__ie().is_bound()) {
  single_value->field_grouped__ie = other_value.grouped__ie();
} else {
  single_value->field_grouped__ie.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void Create__FAR_template::copy_template(const Create__FAR_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.grouped__ie().get_selection()) {
single_value->field_grouped__ie = other_value.grouped__ie();
} else {
single_value->field_grouped__ie.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Create__FAR_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Create__FAR_template(*other_value.implication_.precondition);
implication_.implied_template = new Create__FAR_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @PFCP_Types.Create_FAR.");
break;
}
set_selection(other_value);
}

Create__FAR_template::Create__FAR_template()
{
}

Create__FAR_template::Create__FAR_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

Create__FAR_template::Create__FAR_template(const Create__FAR& other_value)
{
copy_value(other_value);
}

Create__FAR_template::Create__FAR_template(const OPTIONAL<Create__FAR>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Create__FAR&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @PFCP_Types.Create_FAR from an unbound optional field.");
}
}

Create__FAR_template::Create__FAR_template(Create__FAR_template* p_precondition, Create__FAR_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

Create__FAR_template::Create__FAR_template(Dynamic_Match_Interface<Create__FAR>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<Create__FAR>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

Create__FAR_template::Create__FAR_template(const Create__FAR_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

Create__FAR_template::~Create__FAR_template()
{
clean_up();
}

Create__FAR_template& Create__FAR_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

Create__FAR_template& Create__FAR_template::operator=(const Create__FAR& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

Create__FAR_template& Create__FAR_template::operator=(const OPTIONAL<Create__FAR>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Create__FAR&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @PFCP_Types.Create_FAR.");
}
return *this;
}

Create__FAR_template& Create__FAR_template::operator=(const Create__FAR_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean Create__FAR_template::match(const Create__FAR& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.grouped__ie().is_bound()) return FALSE;
if(!single_value->field_grouped__ie.match(other_value.grouped__ie(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @PFCP_Types.Create_FAR.");
}
return FALSE;
}

boolean Create__FAR_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_grouped__ie.is_bound();
}

boolean Create__FAR_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_grouped__ie.is_value();
}

void Create__FAR_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

Create__FAR Create__FAR_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @PFCP_Types.Create_FAR.");
Create__FAR ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_grouped__ie.is_bound()) {
ret_val.grouped__ie() = single_value->field_grouped__ie.valueof();
}
return ret_val;
}

void Create__FAR_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @PFCP_Types.Create_FAR.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new Create__FAR_template[list_length];
}

Create__FAR_template& Create__FAR_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @PFCP_Types.Create_FAR.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @PFCP_Types.Create_FAR.");
return value_list.list_value[list_index];
}

INTEGER_template& Create__FAR_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const INTEGER_template& Create__FAR_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @PFCP_Types.Create_FAR.");
return single_value->field_elementIdentifier;
}

INTEGER_template& Create__FAR_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& Create__FAR_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @PFCP_Types.Create_FAR.");
return single_value->field_lengthIndicator;
}

Create__FAR_grouped__ie_template& Create__FAR_template::grouped__ie()
{
set_specific();
return single_value->field_grouped__ie;
}

const Create__FAR_grouped__ie_template& Create__FAR_template::grouped__ie() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field grouped_ie of a non-specific template of type @PFCP_Types.Create_FAR.");
return single_value->field_grouped__ie;
}

int Create__FAR_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_FAR which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @PFCP_Types.Create_FAR containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_FAR containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_FAR containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_FAR containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_FAR containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_FAR containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_FAR containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_FAR containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @PFCP_Types.Create_FAR.");
  }
  return 0;
}

void Create__FAR_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", grouped_ie := ");
single_value->field_grouped__ie.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void Create__FAR_template::log_match(const Create__FAR& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_grouped__ie.match(match_value.grouped__ie(), legacy)){
TTCN_Logger::log_logmatch_info(".grouped_ie");
single_value->field_grouped__ie.log_match(match_value.grouped__ie(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", grouped_ie := ");
single_value->field_grouped__ie.log_match(match_value.grouped__ie(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void Create__FAR_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (grouped__ie().is_bound()) grouped__ie().set_implicit_omit();
}

void Create__FAR_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_grouped__ie.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @PFCP_Types.Create_FAR.");
}
}

void Create__FAR_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_grouped__ie.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new Create__FAR_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @PFCP_Types.Create_FAR.");
}
}

void Create__FAR_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    Create__FAR_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @PFCP_Types.Create_FAR has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) grouped__ie().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "grouped_ie")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          grouped__ie().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @PFCP_Types.Create_FAR: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    Create__FAR_template* precondition = new Create__FAR_template;
    precondition->set_param(*param.get_elem(0));
    Create__FAR_template* implied_template = new Create__FAR_template;
    implied_template->set_param(*param.get_elem(1));
    *this = Create__FAR_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@PFCP_Types.Create_FAR");
  }
  is_ifpresent = param.get_ifpresent();
}

void Create__FAR_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_FAR");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_FAR");
single_value->field_grouped__ie.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_FAR");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@PFCP_Types.Create_FAR");
}

boolean Create__FAR_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean Create__FAR_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PFCP__Session__Establishment__Request::PFCP__Session__Establishment__Request()
{
}

PFCP__Session__Establishment__Request::PFCP__Session__Establishment__Request(const Node__ID& par_node__id,
    const F__SEID& par_CP__F__SEID,
    const Create__PDR__list& par_create__PDR__list,
    const Create__FAR__list& par_create__FAR__list,
    const OPTIONAL< Create__URR__list >& par_create__URR__list,
    const OPTIONAL< Create__QER__list >& par_create__QER__list,
    const OPTIONAL< Create__BAR >& par_create__BAR,
    const OPTIONAL< PFCP__Session__Establishment__Request_create__traffic__endpoint__list >& par_create__traffic__endpoint__list,
    const OPTIONAL< PDN__Type >& par_pdn__type,
    const OPTIONAL< FQ__CSID__list >& par_node__list,
    const OPTIONAL< UP__Inactivity__Timer >& par_up__inactivity__timer)
  :   field_node__id(par_node__id),
  field_CP__F__SEID(par_CP__F__SEID),
  field_create__PDR__list(par_create__PDR__list),
  field_create__FAR__list(par_create__FAR__list),
  field_create__URR__list(par_create__URR__list),
  field_create__QER__list(par_create__QER__list),
  field_create__BAR(par_create__BAR),
  field_create__traffic__endpoint__list(par_create__traffic__endpoint__list),
  field_pdn__type(par_pdn__type),
  field_node__list(par_node__list),
  field_up__inactivity__timer(par_up__inactivity__timer)
{
}

PFCP__Session__Establishment__Request::PFCP__Session__Establishment__Request(const PFCP__Session__Establishment__Request& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @PFCP_Types.PFCP_Session_Establishment_Request.");
if (other_value.node__id().is_bound()) field_node__id = other_value.node__id();
else field_node__id.clean_up();
if (other_value.CP__F__SEID().is_bound()) field_CP__F__SEID = other_value.CP__F__SEID();
else field_CP__F__SEID.clean_up();
if (other_value.create__PDR__list().is_bound()) field_create__PDR__list = other_value.create__PDR__list();
else field_create__PDR__list.clean_up();
if (other_value.create__FAR__list().is_bound()) field_create__FAR__list = other_value.create__FAR__list();
else field_create__FAR__list.clean_up();
if (other_value.create__URR__list().is_bound()) field_create__URR__list = other_value.create__URR__list();
else field_create__URR__list.clean_up();
if (other_value.create__QER__list().is_bound()) field_create__QER__list = other_value.create__QER__list();
else field_create__QER__list.clean_up();
if (other_value.create__BAR().is_bound()) field_create__BAR = other_value.create__BAR();
else field_create__BAR.clean_up();
if (other_value.create__traffic__endpoint__list().is_bound()) field_create__traffic__endpoint__list = other_value.create__traffic__endpoint__list();
else field_create__traffic__endpoint__list.clean_up();
if (other_value.pdn__type().is_bound()) field_pdn__type = other_value.pdn__type();
else field_pdn__type.clean_up();
if (other_value.node__list().is_bound()) field_node__list = other_value.node__list();
else field_node__list.clean_up();
if (other_value.up__inactivity__timer().is_bound()) field_up__inactivity__timer = other_value.up__inactivity__timer();
else field_up__inactivity__timer.clean_up();
}

void PFCP__Session__Establishment__Request::clean_up()
{
field_node__id.clean_up();
field_CP__F__SEID.clean_up();
field_create__PDR__list.clean_up();
field_create__FAR__list.clean_up();
field_create__URR__list.clean_up();
field_create__QER__list.clean_up();
field_create__BAR.clean_up();
field_create__traffic__endpoint__list.clean_up();
field_pdn__type.clean_up();
field_node__list.clean_up();
field_up__inactivity__timer.clean_up();
}

const TTCN_Typedescriptor_t* PFCP__Session__Establishment__Request::get_descriptor() const { return &PFCP__Session__Establishment__Request_descr_; }
PFCP__Session__Establishment__Request& PFCP__Session__Establishment__Request::operator=(const PFCP__Session__Establishment__Request& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @PFCP_Types.PFCP_Session_Establishment_Request.");
  if (other_value.node__id().is_bound()) field_node__id = other_value.node__id();
  else field_node__id.clean_up();
  if (other_value.CP__F__SEID().is_bound()) field_CP__F__SEID = other_value.CP__F__SEID();
  else field_CP__F__SEID.clean_up();
  if (other_value.create__PDR__list().is_bound()) field_create__PDR__list = other_value.create__PDR__list();
  else field_create__PDR__list.clean_up();
  if (other_value.create__FAR__list().is_bound()) field_create__FAR__list = other_value.create__FAR__list();
  else field_create__FAR__list.clean_up();
  if (other_value.create__URR__list().is_bound()) field_create__URR__list = other_value.create__URR__list();
  else field_create__URR__list.clean_up();
  if (other_value.create__QER__list().is_bound()) field_create__QER__list = other_value.create__QER__list();
  else field_create__QER__list.clean_up();
  if (other_value.create__BAR().is_bound()) field_create__BAR = other_value.create__BAR();
  else field_create__BAR.clean_up();
  if (other_value.create__traffic__endpoint__list().is_bound()) field_create__traffic__endpoint__list = other_value.create__traffic__endpoint__list();
  else field_create__traffic__endpoint__list.clean_up();
  if (other_value.pdn__type().is_bound()) field_pdn__type = other_value.pdn__type();
  else field_pdn__type.clean_up();
  if (other_value.node__list().is_bound()) field_node__list = other_value.node__list();
  else field_node__list.clean_up();
  if (other_value.up__inactivity__timer().is_bound()) field_up__inactivity__timer = other_value.up__inactivity__timer();
  else field_up__inactivity__timer.clean_up();
}
return *this;
}

boolean PFCP__Session__Establishment__Request::operator==(const PFCP__Session__Establishment__Request& other_value) const
{
return field_node__id==other_value.field_node__id
  && field_CP__F__SEID==other_value.field_CP__F__SEID
  && field_create__PDR__list==other_value.field_create__PDR__list
  && field_create__FAR__list==other_value.field_create__FAR__list
  && field_create__URR__list==other_value.field_create__URR__list
  && field_create__QER__list==other_value.field_create__QER__list
  && field_create__BAR==other_value.field_create__BAR
  && field_create__traffic__endpoint__list==other_value.field_create__traffic__endpoint__list
  && field_pdn__type==other_value.field_pdn__type
  && field_node__list==other_value.field_node__list
  && field_up__inactivity__timer==other_value.field_up__inactivity__timer;
}

boolean PFCP__Session__Establishment__Request::is_bound() const
{
return (field_node__id.is_bound())
  || (field_CP__F__SEID.is_bound())
  || (field_create__PDR__list.is_bound())
  || (field_create__FAR__list.is_bound())
  || (OPTIONAL_OMIT == field_create__URR__list.get_selection() || field_create__URR__list.is_bound())
  || (OPTIONAL_OMIT == field_create__QER__list.get_selection() || field_create__QER__list.is_bound())
  || (OPTIONAL_OMIT == field_create__BAR.get_selection() || field_create__BAR.is_bound())
  || (OPTIONAL_OMIT == field_create__traffic__endpoint__list.get_selection() || field_create__traffic__endpoint__list.is_bound())
  || (OPTIONAL_OMIT == field_pdn__type.get_selection() || field_pdn__type.is_bound())
  || (OPTIONAL_OMIT == field_node__list.get_selection() || field_node__list.is_bound())
  || (OPTIONAL_OMIT == field_up__inactivity__timer.get_selection() || field_up__inactivity__timer.is_bound());
}
boolean PFCP__Session__Establishment__Request::is_value() const
{
return field_node__id.is_value()
  && field_CP__F__SEID.is_value()
  && field_create__PDR__list.is_value()
  && field_create__FAR__list.is_value()
  && (OPTIONAL_OMIT == field_create__URR__list.get_selection() || field_create__URR__list.is_value())
  && (OPTIONAL_OMIT == field_create__QER__list.get_selection() || field_create__QER__list.is_value())
  && (OPTIONAL_OMIT == field_create__BAR.get_selection() || field_create__BAR.is_value())
  && (OPTIONAL_OMIT == field_create__traffic__endpoint__list.get_selection() || field_create__traffic__endpoint__list.is_value())
  && (OPTIONAL_OMIT == field_pdn__type.get_selection() || field_pdn__type.is_value())
  && (OPTIONAL_OMIT == field_node__list.get_selection() || field_node__list.is_value())
  && (OPTIONAL_OMIT == field_up__inactivity__timer.get_selection() || field_up__inactivity__timer.is_value());
}
int PFCP__Session__Establishment__Request::size_of() const
{
  int ret_val = 4;
  if (field_create__URR__list.ispresent()) ret_val++;
  if (field_create__QER__list.ispresent()) ret_val++;
  if (field_create__BAR.ispresent()) ret_val++;
  if (field_create__traffic__endpoint__list.ispresent()) ret_val++;
  if (field_pdn__type.ispresent()) ret_val++;
  if (field_node__list.ispresent()) ret_val++;
  if (field_up__inactivity__timer.ispresent()) ret_val++;
  return ret_val;
}

void PFCP__Session__Establishment__Request::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ node_id := ");
field_node__id.log();
TTCN_Logger::log_event_str(", CP_F_SEID := ");
field_CP__F__SEID.log();
TTCN_Logger::log_event_str(", create_PDR_list := ");
field_create__PDR__list.log();
TTCN_Logger::log_event_str(", create_FAR_list := ");
field_create__FAR__list.log();
TTCN_Logger::log_event_str(", create_URR_list := ");
field_create__URR__list.log();
TTCN_Logger::log_event_str(", create_QER_list := ");
field_create__QER__list.log();
TTCN_Logger::log_event_str(", create_BAR := ");
field_create__BAR.log();
TTCN_Logger::log_event_str(", create_traffic_endpoint_list := ");
field_create__traffic__endpoint__list.log();
TTCN_Logger::log_event_str(", pdn_type := ");
field_pdn__type.log();
TTCN_Logger::log_event_str(", node_list := ");
field_node__list.log();
TTCN_Logger::log_event_str(", up_inactivity_timer := ");
field_up__inactivity__timer.log();
TTCN_Logger::log_event_str(" }");
}

void PFCP__Session__Establishment__Request::set_implicit_omit()
{
if (node__id().is_bound()) node__id().set_implicit_omit();
if (CP__F__SEID().is_bound()) CP__F__SEID().set_implicit_omit();
if (create__PDR__list().is_bound()) create__PDR__list().set_implicit_omit();
if (create__FAR__list().is_bound()) create__FAR__list().set_implicit_omit();
if (!create__URR__list().is_bound()) create__URR__list() = OMIT_VALUE;
else create__URR__list().set_implicit_omit();
if (!create__QER__list().is_bound()) create__QER__list() = OMIT_VALUE;
else create__QER__list().set_implicit_omit();
if (!create__BAR().is_bound()) create__BAR() = OMIT_VALUE;
else create__BAR().set_implicit_omit();
if (!create__traffic__endpoint__list().is_bound()) create__traffic__endpoint__list() = OMIT_VALUE;
else create__traffic__endpoint__list().set_implicit_omit();
if (!pdn__type().is_bound()) pdn__type() = OMIT_VALUE;
else pdn__type().set_implicit_omit();
if (!node__list().is_bound()) node__list() = OMIT_VALUE;
else node__list().set_implicit_omit();
if (!up__inactivity__timer().is_bound()) up__inactivity__timer() = OMIT_VALUE;
else up__inactivity__timer().set_implicit_omit();
}

void PFCP__Session__Establishment__Request::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "set value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (11<param.get_size()) {
      param.error("set value of type @PFCP_Types.PFCP_Session_Establishment_Request has 11 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) node__id().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) CP__F__SEID().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) create__PDR__list().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) create__FAR__list().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) create__URR__list().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) create__QER__list().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) create__BAR().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) create__traffic__endpoint__list().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) pdn__type().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) node__list().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) up__inactivity__timer().set_param(*param.get_elem(10));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "node_id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          node__id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "CP_F_SEID")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          CP__F__SEID().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "create_PDR_list")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          create__PDR__list().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "create_FAR_list")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          create__FAR__list().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "create_URR_list")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          create__URR__list().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "create_QER_list")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          create__QER__list().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "create_BAR")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          create__BAR().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "create_traffic_endpoint_list")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          create__traffic__endpoint__list().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pdn_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pdn__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "node_list")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          node__list().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "up_inactivity_timer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          up__inactivity__timer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @PFCP_Types.PFCP_Session_Establishment_Request: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("set value", "@PFCP_Types.PFCP_Session_Establishment_Request");
  }
}

void PFCP__Session__Establishment__Request::encode_text(Text_Buf& text_buf) const
{
field_node__id.encode_text(text_buf);
field_CP__F__SEID.encode_text(text_buf);
field_create__PDR__list.encode_text(text_buf);
field_create__FAR__list.encode_text(text_buf);
field_create__URR__list.encode_text(text_buf);
field_create__QER__list.encode_text(text_buf);
field_create__BAR.encode_text(text_buf);
field_create__traffic__endpoint__list.encode_text(text_buf);
field_pdn__type.encode_text(text_buf);
field_node__list.encode_text(text_buf);
field_up__inactivity__timer.encode_text(text_buf);
}

void PFCP__Session__Establishment__Request::decode_text(Text_Buf& text_buf)
{
field_node__id.decode_text(text_buf);
field_CP__F__SEID.decode_text(text_buf);
field_create__PDR__list.decode_text(text_buf);
field_create__FAR__list.decode_text(text_buf);
field_create__URR__list.decode_text(text_buf);
field_create__QER__list.decode_text(text_buf);
field_create__BAR.decode_text(text_buf);
field_create__traffic__endpoint__list.decode_text(text_buf);
field_pdn__type.decode_text(text_buf);
field_node__list.decode_text(text_buf);
field_up__inactivity__timer.decode_text(text_buf);
}

void PFCP__Session__Establishment__Request::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PFCP__Session__Establishment__Request::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PFCP__Session__Establishment__Request::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean, int, boolean, const RAW_Force_Omit* force_omit)
{
int prepaddlength = p_buf.increase_pos_padd(p_td.raw->prepadding);
limit -= prepaddlength;
int decoded_length = 0;
int field_map[11];
memset(field_map, 0, sizeof(field_map));
size_t nof_mand_fields = 0;
field_create__URR__list = OMIT_VALUE;
field_create__QER__list = OMIT_VALUE;
field_create__BAR = OMIT_VALUE;
field_create__traffic__endpoint__list = OMIT_VALUE;
field_pdn__type = OMIT_VALUE;
field_node__list = OMIT_VALUE;
field_up__inactivity__timer = OMIT_VALUE;
raw_order_t local_top_order;
if (p_td.raw->top_bit_order == TOP_BIT_INHERITED) local_top_order = top_bit_ord;
else if (p_td.raw->top_bit_order == TOP_BIT_RIGHT) local_top_order = ORDER_MSB;
else local_top_order = ORDER_LSB;
while (limit > 0) {
size_t fl_start_pos = p_buf.get_pos_bit();
if (field_map[0] == 0) {
RAW_Force_Omit field_0_force_omit(0, force_omit, Node__ID_descr_.raw->forceomit);
int decoded_field_length = field_node__id.RAW_decode(Node__ID_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_0_force_omit);
if (decoded_field_length >= 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
nof_mand_fields++;
field_map[0] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
}
}
if (field_map[1] == 0) {
RAW_Force_Omit field_1_force_omit(1, force_omit, F__SEID_descr_.raw->forceomit);
int decoded_field_length = field_CP__F__SEID.RAW_decode(F__SEID_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_1_force_omit);
if (decoded_field_length >= 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
nof_mand_fields++;
field_map[1] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
}
}
{
RAW_Force_Omit field_2_force_omit(2, force_omit, PFCP__Session__Establishment__Request_create__PDR__list_descr_.raw->forceomit);
int decoded_field_length = field_create__PDR__list.RAW_decode(PFCP__Session__Establishment__Request_create__PDR__list_descr_, p_buf, limit, local_top_order, TRUE, 1, field_map[2] == 0, &field_2_force_omit);
if (decoded_field_length >= 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
if (field_map[2] == 0) nof_mand_fields++;
field_map[2]++;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
}
}
{
RAW_Force_Omit field_3_force_omit(3, force_omit, PFCP__Session__Establishment__Request_create__FAR__list_descr_.raw->forceomit);
int decoded_field_length = field_create__FAR__list.RAW_decode(PFCP__Session__Establishment__Request_create__FAR__list_descr_, p_buf, limit, local_top_order, TRUE, 1, field_map[3] == 0, &field_3_force_omit);
if (decoded_field_length >= 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
if (field_map[3] == 0) nof_mand_fields++;
field_map[3]++;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
}
}
if (force_omit == NULL || !(*force_omit)(4)) {
RAW_Force_Omit field_4_force_omit(4, force_omit, PFCP__Session__Establishment__Request_create__URR__list_descr_.raw->forceomit);
int decoded_field_length = field_create__URR__list().RAW_decode(PFCP__Session__Establishment__Request_create__URR__list_descr_, p_buf, limit, local_top_order, TRUE, 1, field_map[4] == 0, &field_4_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[4]++;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
if (field_map[4] == 0) field_create__URR__list = OMIT_VALUE;
}
}
if (force_omit == NULL || !(*force_omit)(5)) {
RAW_Force_Omit field_5_force_omit(5, force_omit, PFCP__Session__Establishment__Request_create__QER__list_descr_.raw->forceomit);
int decoded_field_length = field_create__QER__list().RAW_decode(PFCP__Session__Establishment__Request_create__QER__list_descr_, p_buf, limit, local_top_order, TRUE, 1, field_map[5] == 0, &field_5_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[5]++;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
if (field_map[5] == 0) field_create__QER__list = OMIT_VALUE;
}
}
if (field_map[6] == 0 && (force_omit == NULL || !(*force_omit)(6))) {
RAW_Force_Omit field_6_force_omit(6, force_omit, Create__BAR_descr_.raw->forceomit);
int decoded_field_length = field_create__BAR().RAW_decode(Create__BAR_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_6_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[6] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_create__BAR = OMIT_VALUE;
}
}
if (field_map[7] == 0 && (force_omit == NULL || !(*force_omit)(7))) {
RAW_Force_Omit field_7_force_omit(7, force_omit, PFCP__Session__Establishment__Request_create__traffic__endpoint__list_descr_.raw->forceomit);
int decoded_field_length = field_create__traffic__endpoint__list().RAW_decode(PFCP__Session__Establishment__Request_create__traffic__endpoint__list_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_7_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[7] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_create__traffic__endpoint__list = OMIT_VALUE;
}
}
if (field_map[8] == 0 && (force_omit == NULL || !(*force_omit)(8))) {
RAW_Force_Omit field_8_force_omit(8, force_omit, PDN__Type_descr_.raw->forceomit);
int decoded_field_length = field_pdn__type().RAW_decode(PDN__Type_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_8_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[8] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_pdn__type = OMIT_VALUE;
}
}
if (force_omit == NULL || !(*force_omit)(9)) {
RAW_Force_Omit field_9_force_omit(9, force_omit, PFCP__Session__Establishment__Request_node__list_descr_.raw->forceomit);
int decoded_field_length = field_node__list().RAW_decode(PFCP__Session__Establishment__Request_node__list_descr_, p_buf, limit, local_top_order, TRUE, 1, field_map[9] == 0, &field_9_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[9]++;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
if (field_map[9] == 0) field_node__list = OMIT_VALUE;
}
}
if (field_map[10] == 0 && (force_omit == NULL || !(*force_omit)(10))) {
RAW_Force_Omit field_10_force_omit(10, force_omit, UP__Inactivity__Timer_descr_.raw->forceomit);
int decoded_field_length = field_up__inactivity__timer().RAW_decode(UP__Inactivity__Timer_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_10_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[10] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_up__inactivity__timer = OMIT_VALUE;
}
}
break;
}
if (nof_mand_fields != 4) return limit ? -1 : -TTCN_EncDec::ET_INCOMPL_MSG;
return decoded_length + prepaddlength + p_buf.increase_pos_padd(p_td.raw->padding);
}

int PFCP__Session__Establishment__Request::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 11;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(11);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, Node__ID_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, F__SEID_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, PFCP__Session__Establishment__Request_create__PDR__list_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, PFCP__Session__Establishment__Request_create__FAR__list_descr_.raw);
  if (field_create__URR__list.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, PFCP__Session__Establishment__Request_create__URR__list_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  if (field_create__QER__list.ispresent()) {
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, PFCP__Session__Establishment__Request_create__QER__list_descr_.raw);
  }
  else myleaf.body.node.nodes[5] = NULL;
  if (field_create__BAR.ispresent()) {
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, Create__BAR_descr_.raw);
  }
  else myleaf.body.node.nodes[6] = NULL;
  if (field_create__traffic__endpoint__list.ispresent()) {
  myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 7, PFCP__Session__Establishment__Request_create__traffic__endpoint__list_descr_.raw);
  }
  else myleaf.body.node.nodes[7] = NULL;
  if (field_pdn__type.ispresent()) {
  myleaf.body.node.nodes[8] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 8, PDN__Type_descr_.raw);
  }
  else myleaf.body.node.nodes[8] = NULL;
  if (field_node__list.ispresent()) {
  myleaf.body.node.nodes[9] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 9, PFCP__Session__Establishment__Request_node__list_descr_.raw);
  }
  else myleaf.body.node.nodes[9] = NULL;
  if (field_up__inactivity__timer.ispresent()) {
  myleaf.body.node.nodes[10] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 10, UP__Inactivity__Timer_descr_.raw);
  }
  else myleaf.body.node.nodes[10] = NULL;
  encoded_length += field_node__id.RAW_encode(Node__ID_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_CP__F__SEID.RAW_encode(F__SEID_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_create__PDR__list.RAW_encode(PFCP__Session__Establishment__Request_create__PDR__list_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_create__FAR__list.RAW_encode(PFCP__Session__Establishment__Request_create__FAR__list_descr_, *myleaf.body.node.nodes[3]);
  if (field_create__URR__list.ispresent()) {
  encoded_length += field_create__URR__list().RAW_encode(PFCP__Session__Establishment__Request_create__URR__list_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_create__QER__list.ispresent()) {
  encoded_length += field_create__QER__list().RAW_encode(PFCP__Session__Establishment__Request_create__QER__list_descr_, *myleaf.body.node.nodes[5]);
  }
  if (field_create__BAR.ispresent()) {
  encoded_length += field_create__BAR().RAW_encode(Create__BAR_descr_, *myleaf.body.node.nodes[6]);
  }
  if (field_create__traffic__endpoint__list.ispresent()) {
  encoded_length += field_create__traffic__endpoint__list().RAW_encode(PFCP__Session__Establishment__Request_create__traffic__endpoint__list_descr_, *myleaf.body.node.nodes[7]);
  }
  if (field_pdn__type.ispresent()) {
  encoded_length += field_pdn__type().RAW_encode(PDN__Type_descr_, *myleaf.body.node.nodes[8]);
  }
  if (field_node__list.ispresent()) {
  encoded_length += field_node__list().RAW_encode(PFCP__Session__Establishment__Request_node__list_descr_, *myleaf.body.node.nodes[9]);
  }
  if (field_up__inactivity__timer.ispresent()) {
  encoded_length += field_up__inactivity__timer().RAW_encode(UP__Inactivity__Timer_descr_, *myleaf.body.node.nodes[10]);
  }
  return myleaf.length = encoded_length;
}

struct PFCP__Session__Establishment__Request_template::single_value_struct {
Node__ID_template field_node__id;
F__SEID_template field_CP__F__SEID;
Create__PDR__list_template field_create__PDR__list;
Create__FAR__list_template field_create__FAR__list;
Create__URR__list_template field_create__URR__list;
Create__QER__list_template field_create__QER__list;
Create__BAR_template field_create__BAR;
PFCP__Session__Establishment__Request_create__traffic__endpoint__list_template field_create__traffic__endpoint__list;
PDN__Type_template field_pdn__type;
FQ__CSID__list_template field_node__list;
UP__Inactivity__Timer_template field_up__inactivity__timer;
};

void PFCP__Session__Establishment__Request_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_node__id = ANY_VALUE;
single_value->field_CP__F__SEID = ANY_VALUE;
single_value->field_create__PDR__list = ANY_VALUE;
single_value->field_create__FAR__list = ANY_VALUE;
single_value->field_create__URR__list = ANY_OR_OMIT;
single_value->field_create__QER__list = ANY_OR_OMIT;
single_value->field_create__BAR = ANY_OR_OMIT;
single_value->field_create__traffic__endpoint__list = ANY_OR_OMIT;
single_value->field_pdn__type = ANY_OR_OMIT;
single_value->field_node__list = ANY_OR_OMIT;
single_value->field_up__inactivity__timer = ANY_OR_OMIT;
}
}
}

void PFCP__Session__Establishment__Request_template::copy_value(const PFCP__Session__Establishment__Request& other_value)
{
single_value = new single_value_struct;
if (other_value.node__id().is_bound()) {
  single_value->field_node__id = other_value.node__id();
} else {
  single_value->field_node__id.clean_up();
}
if (other_value.CP__F__SEID().is_bound()) {
  single_value->field_CP__F__SEID = other_value.CP__F__SEID();
} else {
  single_value->field_CP__F__SEID.clean_up();
}
if (other_value.create__PDR__list().is_bound()) {
  single_value->field_create__PDR__list = other_value.create__PDR__list();
} else {
  single_value->field_create__PDR__list.clean_up();
}
if (other_value.create__FAR__list().is_bound()) {
  single_value->field_create__FAR__list = other_value.create__FAR__list();
} else {
  single_value->field_create__FAR__list.clean_up();
}
if (other_value.create__URR__list().is_bound()) {
  if (other_value.create__URR__list().ispresent()) single_value->field_create__URR__list = other_value.create__URR__list()();
  else single_value->field_create__URR__list = OMIT_VALUE;
} else {
  single_value->field_create__URR__list.clean_up();
}
if (other_value.create__QER__list().is_bound()) {
  if (other_value.create__QER__list().ispresent()) single_value->field_create__QER__list = other_value.create__QER__list()();
  else single_value->field_create__QER__list = OMIT_VALUE;
} else {
  single_value->field_create__QER__list.clean_up();
}
if (other_value.create__BAR().is_bound()) {
  if (other_value.create__BAR().ispresent()) single_value->field_create__BAR = other_value.create__BAR()();
  else single_value->field_create__BAR = OMIT_VALUE;
} else {
  single_value->field_create__BAR.clean_up();
}
if (other_value.create__traffic__endpoint__list().is_bound()) {
  if (other_value.create__traffic__endpoint__list().ispresent()) single_value->field_create__traffic__endpoint__list = other_value.create__traffic__endpoint__list()();
  else single_value->field_create__traffic__endpoint__list = OMIT_VALUE;
} else {
  single_value->field_create__traffic__endpoint__list.clean_up();
}
if (other_value.pdn__type().is_bound()) {
  if (other_value.pdn__type().ispresent()) single_value->field_pdn__type = other_value.pdn__type()();
  else single_value->field_pdn__type = OMIT_VALUE;
} else {
  single_value->field_pdn__type.clean_up();
}
if (other_value.node__list().is_bound()) {
  if (other_value.node__list().ispresent()) single_value->field_node__list = other_value.node__list()();
  else single_value->field_node__list = OMIT_VALUE;
} else {
  single_value->field_node__list.clean_up();
}
if (other_value.up__inactivity__timer().is_bound()) {
  if (other_value.up__inactivity__timer().ispresent()) single_value->field_up__inactivity__timer = other_value.up__inactivity__timer()();
  else single_value->field_up__inactivity__timer = OMIT_VALUE;
} else {
  single_value->field_up__inactivity__timer.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PFCP__Session__Establishment__Request_template::copy_template(const PFCP__Session__Establishment__Request_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.node__id().get_selection()) {
single_value->field_node__id = other_value.node__id();
} else {
single_value->field_node__id.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.CP__F__SEID().get_selection()) {
single_value->field_CP__F__SEID = other_value.CP__F__SEID();
} else {
single_value->field_CP__F__SEID.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.create__PDR__list().get_selection()) {
single_value->field_create__PDR__list = other_value.create__PDR__list();
} else {
single_value->field_create__PDR__list.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.create__FAR__list().get_selection()) {
single_value->field_create__FAR__list = other_value.create__FAR__list();
} else {
single_value->field_create__FAR__list.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.create__URR__list().get_selection()) {
single_value->field_create__URR__list = other_value.create__URR__list();
} else {
single_value->field_create__URR__list.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.create__QER__list().get_selection()) {
single_value->field_create__QER__list = other_value.create__QER__list();
} else {
single_value->field_create__QER__list.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.create__BAR().get_selection()) {
single_value->field_create__BAR = other_value.create__BAR();
} else {
single_value->field_create__BAR.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.create__traffic__endpoint__list().get_selection()) {
single_value->field_create__traffic__endpoint__list = other_value.create__traffic__endpoint__list();
} else {
single_value->field_create__traffic__endpoint__list.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.pdn__type().get_selection()) {
single_value->field_pdn__type = other_value.pdn__type();
} else {
single_value->field_pdn__type.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.node__list().get_selection()) {
single_value->field_node__list = other_value.node__list();
} else {
single_value->field_node__list.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.up__inactivity__timer().get_selection()) {
single_value->field_up__inactivity__timer = other_value.up__inactivity__timer();
} else {
single_value->field_up__inactivity__timer.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PFCP__Session__Establishment__Request_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PFCP__Session__Establishment__Request_template(*other_value.implication_.precondition);
implication_.implied_template = new PFCP__Session__Establishment__Request_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @PFCP_Types.PFCP_Session_Establishment_Request.");
break;
}
set_selection(other_value);
}

PFCP__Session__Establishment__Request_template::PFCP__Session__Establishment__Request_template()
{
}

PFCP__Session__Establishment__Request_template::PFCP__Session__Establishment__Request_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PFCP__Session__Establishment__Request_template::PFCP__Session__Establishment__Request_template(const PFCP__Session__Establishment__Request& other_value)
{
copy_value(other_value);
}

PFCP__Session__Establishment__Request_template::PFCP__Session__Establishment__Request_template(const OPTIONAL<PFCP__Session__Establishment__Request>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PFCP__Session__Establishment__Request&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @PFCP_Types.PFCP_Session_Establishment_Request from an unbound optional field.");
}
}

PFCP__Session__Establishment__Request_template::PFCP__Session__Establishment__Request_template(PFCP__Session__Establishment__Request_template* p_precondition, PFCP__Session__Establishment__Request_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PFCP__Session__Establishment__Request_template::PFCP__Session__Establishment__Request_template(Dynamic_Match_Interface<PFCP__Session__Establishment__Request>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PFCP__Session__Establishment__Request>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PFCP__Session__Establishment__Request_template::PFCP__Session__Establishment__Request_template(const PFCP__Session__Establishment__Request_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PFCP__Session__Establishment__Request_template::~PFCP__Session__Establishment__Request_template()
{
clean_up();
}

PFCP__Session__Establishment__Request_template& PFCP__Session__Establishment__Request_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PFCP__Session__Establishment__Request_template& PFCP__Session__Establishment__Request_template::operator=(const PFCP__Session__Establishment__Request& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PFCP__Session__Establishment__Request_template& PFCP__Session__Establishment__Request_template::operator=(const OPTIONAL<PFCP__Session__Establishment__Request>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PFCP__Session__Establishment__Request&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @PFCP_Types.PFCP_Session_Establishment_Request.");
}
return *this;
}

PFCP__Session__Establishment__Request_template& PFCP__Session__Establishment__Request_template::operator=(const PFCP__Session__Establishment__Request_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PFCP__Session__Establishment__Request_template::match(const PFCP__Session__Establishment__Request& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.node__id().is_bound()) return FALSE;
if(!single_value->field_node__id.match(other_value.node__id(), legacy))return FALSE;
if(!other_value.CP__F__SEID().is_bound()) return FALSE;
if(!single_value->field_CP__F__SEID.match(other_value.CP__F__SEID(), legacy))return FALSE;
if(!other_value.create__PDR__list().is_bound()) return FALSE;
if(!single_value->field_create__PDR__list.match(other_value.create__PDR__list(), legacy))return FALSE;
if(!other_value.create__FAR__list().is_bound()) return FALSE;
if(!single_value->field_create__FAR__list.match(other_value.create__FAR__list(), legacy))return FALSE;
if(!other_value.create__URR__list().is_bound()) return FALSE;
if((other_value.create__URR__list().ispresent() ? !single_value->field_create__URR__list.match((const Create__URR__list&)other_value.create__URR__list(), legacy) : !single_value->field_create__URR__list.match_omit(legacy)))return FALSE;
if(!other_value.create__QER__list().is_bound()) return FALSE;
if((other_value.create__QER__list().ispresent() ? !single_value->field_create__QER__list.match((const Create__QER__list&)other_value.create__QER__list(), legacy) : !single_value->field_create__QER__list.match_omit(legacy)))return FALSE;
if(!other_value.create__BAR().is_bound()) return FALSE;
if((other_value.create__BAR().ispresent() ? !single_value->field_create__BAR.match((const Create__BAR&)other_value.create__BAR(), legacy) : !single_value->field_create__BAR.match_omit(legacy)))return FALSE;
if(!other_value.create__traffic__endpoint__list().is_bound()) return FALSE;
if((other_value.create__traffic__endpoint__list().ispresent() ? !single_value->field_create__traffic__endpoint__list.match((const PFCP__Session__Establishment__Request_create__traffic__endpoint__list&)other_value.create__traffic__endpoint__list(), legacy) : !single_value->field_create__traffic__endpoint__list.match_omit(legacy)))return FALSE;
if(!other_value.pdn__type().is_bound()) return FALSE;
if((other_value.pdn__type().ispresent() ? !single_value->field_pdn__type.match((const PDN__Type&)other_value.pdn__type(), legacy) : !single_value->field_pdn__type.match_omit(legacy)))return FALSE;
if(!other_value.node__list().is_bound()) return FALSE;
if((other_value.node__list().ispresent() ? !single_value->field_node__list.match((const FQ__CSID__list&)other_value.node__list(), legacy) : !single_value->field_node__list.match_omit(legacy)))return FALSE;
if(!other_value.up__inactivity__timer().is_bound()) return FALSE;
if((other_value.up__inactivity__timer().ispresent() ? !single_value->field_up__inactivity__timer.match((const UP__Inactivity__Timer&)other_value.up__inactivity__timer(), legacy) : !single_value->field_up__inactivity__timer.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @PFCP_Types.PFCP_Session_Establishment_Request.");
}
return FALSE;
}

boolean PFCP__Session__Establishment__Request_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_node__id.is_bound()
 || single_value->field_CP__F__SEID.is_bound()
 || single_value->field_create__PDR__list.is_bound()
 || single_value->field_create__FAR__list.is_bound()
 || (single_value->field_create__URR__list.is_omit() || single_value->field_create__URR__list.is_bound())
 || (single_value->field_create__QER__list.is_omit() || single_value->field_create__QER__list.is_bound())
 || (single_value->field_create__BAR.is_omit() || single_value->field_create__BAR.is_bound())
 || (single_value->field_create__traffic__endpoint__list.is_omit() || single_value->field_create__traffic__endpoint__list.is_bound())
 || (single_value->field_pdn__type.is_omit() || single_value->field_pdn__type.is_bound())
 || (single_value->field_node__list.is_omit() || single_value->field_node__list.is_bound())
 || (single_value->field_up__inactivity__timer.is_omit() || single_value->field_up__inactivity__timer.is_bound());
}

boolean PFCP__Session__Establishment__Request_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_node__id.is_value()
 && single_value->field_CP__F__SEID.is_value()
 && single_value->field_create__PDR__list.is_value()
 && single_value->field_create__FAR__list.is_value()
 && (single_value->field_create__URR__list.is_omit() || single_value->field_create__URR__list.is_value())
 && (single_value->field_create__QER__list.is_omit() || single_value->field_create__QER__list.is_value())
 && (single_value->field_create__BAR.is_omit() || single_value->field_create__BAR.is_value())
 && (single_value->field_create__traffic__endpoint__list.is_omit() || single_value->field_create__traffic__endpoint__list.is_value())
 && (single_value->field_pdn__type.is_omit() || single_value->field_pdn__type.is_value())
 && (single_value->field_node__list.is_omit() || single_value->field_node__list.is_value())
 && (single_value->field_up__inactivity__timer.is_omit() || single_value->field_up__inactivity__timer.is_value());
}

void PFCP__Session__Establishment__Request_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PFCP__Session__Establishment__Request PFCP__Session__Establishment__Request_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @PFCP_Types.PFCP_Session_Establishment_Request.");
PFCP__Session__Establishment__Request ret_val;
if (single_value->field_node__id.is_bound()) {
ret_val.node__id() = single_value->field_node__id.valueof();
}
if (single_value->field_CP__F__SEID.is_bound()) {
ret_val.CP__F__SEID() = single_value->field_CP__F__SEID.valueof();
}
if (single_value->field_create__PDR__list.is_bound()) {
ret_val.create__PDR__list() = single_value->field_create__PDR__list.valueof();
}
if (single_value->field_create__FAR__list.is_bound()) {
ret_val.create__FAR__list() = single_value->field_create__FAR__list.valueof();
}
if (single_value->field_create__URR__list.is_omit()) ret_val.create__URR__list() = OMIT_VALUE;
else if (single_value->field_create__URR__list.is_bound()) {
ret_val.create__URR__list() = single_value->field_create__URR__list.valueof();
}
if (single_value->field_create__QER__list.is_omit()) ret_val.create__QER__list() = OMIT_VALUE;
else if (single_value->field_create__QER__list.is_bound()) {
ret_val.create__QER__list() = single_value->field_create__QER__list.valueof();
}
if (single_value->field_create__BAR.is_omit()) ret_val.create__BAR() = OMIT_VALUE;
else if (single_value->field_create__BAR.is_bound()) {
ret_val.create__BAR() = single_value->field_create__BAR.valueof();
}
if (single_value->field_create__traffic__endpoint__list.is_omit()) ret_val.create__traffic__endpoint__list() = OMIT_VALUE;
else if (single_value->field_create__traffic__endpoint__list.is_bound()) {
ret_val.create__traffic__endpoint__list() = single_value->field_create__traffic__endpoint__list.valueof();
}
if (single_value->field_pdn__type.is_omit()) ret_val.pdn__type() = OMIT_VALUE;
else if (single_value->field_pdn__type.is_bound()) {
ret_val.pdn__type() = single_value->field_pdn__type.valueof();
}
if (single_value->field_node__list.is_omit()) ret_val.node__list() = OMIT_VALUE;
else if (single_value->field_node__list.is_bound()) {
ret_val.node__list() = single_value->field_node__list.valueof();
}
if (single_value->field_up__inactivity__timer.is_omit()) ret_val.up__inactivity__timer() = OMIT_VALUE;
else if (single_value->field_up__inactivity__timer.is_bound()) {
ret_val.up__inactivity__timer() = single_value->field_up__inactivity__timer.valueof();
}
return ret_val;
}

void PFCP__Session__Establishment__Request_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @PFCP_Types.PFCP_Session_Establishment_Request.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PFCP__Session__Establishment__Request_template[list_length];
}

PFCP__Session__Establishment__Request_template& PFCP__Session__Establishment__Request_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @PFCP_Types.PFCP_Session_Establishment_Request.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @PFCP_Types.PFCP_Session_Establishment_Request.");
return value_list.list_value[list_index];
}

Node__ID_template& PFCP__Session__Establishment__Request_template::node__id()
{
set_specific();
return single_value->field_node__id;
}

const Node__ID_template& PFCP__Session__Establishment__Request_template::node__id() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field node_id of a non-specific template of type @PFCP_Types.PFCP_Session_Establishment_Request.");
return single_value->field_node__id;
}

F__SEID_template& PFCP__Session__Establishment__Request_template::CP__F__SEID()
{
set_specific();
return single_value->field_CP__F__SEID;
}

const F__SEID_template& PFCP__Session__Establishment__Request_template::CP__F__SEID() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field CP_F_SEID of a non-specific template of type @PFCP_Types.PFCP_Session_Establishment_Request.");
return single_value->field_CP__F__SEID;
}

Create__PDR__list_template& PFCP__Session__Establishment__Request_template::create__PDR__list()
{
set_specific();
return single_value->field_create__PDR__list;
}

const Create__PDR__list_template& PFCP__Session__Establishment__Request_template::create__PDR__list() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field create_PDR_list of a non-specific template of type @PFCP_Types.PFCP_Session_Establishment_Request.");
return single_value->field_create__PDR__list;
}

Create__FAR__list_template& PFCP__Session__Establishment__Request_template::create__FAR__list()
{
set_specific();
return single_value->field_create__FAR__list;
}

const Create__FAR__list_template& PFCP__Session__Establishment__Request_template::create__FAR__list() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field create_FAR_list of a non-specific template of type @PFCP_Types.PFCP_Session_Establishment_Request.");
return single_value->field_create__FAR__list;
}

Create__URR__list_template& PFCP__Session__Establishment__Request_template::create__URR__list()
{
set_specific();
return single_value->field_create__URR__list;
}

const Create__URR__list_template& PFCP__Session__Establishment__Request_template::create__URR__list() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field create_URR_list of a non-specific template of type @PFCP_Types.PFCP_Session_Establishment_Request.");
return single_value->field_create__URR__list;
}

Create__QER__list_template& PFCP__Session__Establishment__Request_template::create__QER__list()
{
set_specific();
return single_value->field_create__QER__list;
}

const Create__QER__list_template& PFCP__Session__Establishment__Request_template::create__QER__list() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field create_QER_list of a non-specific template of type @PFCP_Types.PFCP_Session_Establishment_Request.");
return single_value->field_create__QER__list;
}

Create__BAR_template& PFCP__Session__Establishment__Request_template::create__BAR()
{
set_specific();
return single_value->field_create__BAR;
}

const Create__BAR_template& PFCP__Session__Establishment__Request_template::create__BAR() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field create_BAR of a non-specific template of type @PFCP_Types.PFCP_Session_Establishment_Request.");
return single_value->field_create__BAR;
}

PFCP__Session__Establishment__Request_create__traffic__endpoint__list_template& PFCP__Session__Establishment__Request_template::create__traffic__endpoint__list()
{
set_specific();
return single_value->field_create__traffic__endpoint__list;
}

const PFCP__Session__Establishment__Request_create__traffic__endpoint__list_template& PFCP__Session__Establishment__Request_template::create__traffic__endpoint__list() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field create_traffic_endpoint_list of a non-specific template of type @PFCP_Types.PFCP_Session_Establishment_Request.");
return single_value->field_create__traffic__endpoint__list;
}

PDN__Type_template& PFCP__Session__Establishment__Request_template::pdn__type()
{
set_specific();
return single_value->field_pdn__type;
}

const PDN__Type_template& PFCP__Session__Establishment__Request_template::pdn__type() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field pdn_type of a non-specific template of type @PFCP_Types.PFCP_Session_Establishment_Request.");
return single_value->field_pdn__type;
}

FQ__CSID__list_template& PFCP__Session__Establishment__Request_template::node__list()
{
set_specific();
return single_value->field_node__list;
}

const FQ__CSID__list_template& PFCP__Session__Establishment__Request_template::node__list() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field node_list of a non-specific template of type @PFCP_Types.PFCP_Session_Establishment_Request.");
return single_value->field_node__list;
}

UP__Inactivity__Timer_template& PFCP__Session__Establishment__Request_template::up__inactivity__timer()
{
set_specific();
return single_value->field_up__inactivity__timer;
}

const UP__Inactivity__Timer_template& PFCP__Session__Establishment__Request_template::up__inactivity__timer() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field up_inactivity_timer of a non-specific template of type @PFCP_Types.PFCP_Session_Establishment_Request.");
return single_value->field_up__inactivity__timer;
}

int PFCP__Session__Establishment__Request_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.PFCP_Session_Establishment_Request which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 4;
      if (single_value->field_create__URR__list.is_present()) ret_val++;
      if (single_value->field_create__QER__list.is_present()) ret_val++;
      if (single_value->field_create__BAR.is_present()) ret_val++;
      if (single_value->field_create__traffic__endpoint__list.is_present()) ret_val++;
      if (single_value->field_pdn__type.is_present()) ret_val++;
      if (single_value->field_node__list.is_present()) ret_val++;
      if (single_value->field_up__inactivity__timer.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @PFCP_Types.PFCP_Session_Establishment_Request containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.PFCP_Session_Establishment_Request containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.PFCP_Session_Establishment_Request containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.PFCP_Session_Establishment_Request containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.PFCP_Session_Establishment_Request containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.PFCP_Session_Establishment_Request containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.PFCP_Session_Establishment_Request containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.PFCP_Session_Establishment_Request containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @PFCP_Types.PFCP_Session_Establishment_Request.");
  }
  return 0;
}

void PFCP__Session__Establishment__Request_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ node_id := ");
single_value->field_node__id.log();
TTCN_Logger::log_event_str(", CP_F_SEID := ");
single_value->field_CP__F__SEID.log();
TTCN_Logger::log_event_str(", create_PDR_list := ");
single_value->field_create__PDR__list.log();
TTCN_Logger::log_event_str(", create_FAR_list := ");
single_value->field_create__FAR__list.log();
TTCN_Logger::log_event_str(", create_URR_list := ");
single_value->field_create__URR__list.log();
TTCN_Logger::log_event_str(", create_QER_list := ");
single_value->field_create__QER__list.log();
TTCN_Logger::log_event_str(", create_BAR := ");
single_value->field_create__BAR.log();
TTCN_Logger::log_event_str(", create_traffic_endpoint_list := ");
single_value->field_create__traffic__endpoint__list.log();
TTCN_Logger::log_event_str(", pdn_type := ");
single_value->field_pdn__type.log();
TTCN_Logger::log_event_str(", node_list := ");
single_value->field_node__list.log();
TTCN_Logger::log_event_str(", up_inactivity_timer := ");
single_value->field_up__inactivity__timer.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PFCP__Session__Establishment__Request_template::log_match(const PFCP__Session__Establishment__Request& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_node__id.match(match_value.node__id(), legacy)){
TTCN_Logger::log_logmatch_info(".node_id");
single_value->field_node__id.log_match(match_value.node__id(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_CP__F__SEID.match(match_value.CP__F__SEID(), legacy)){
TTCN_Logger::log_logmatch_info(".CP_F_SEID");
single_value->field_CP__F__SEID.log_match(match_value.CP__F__SEID(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_create__PDR__list.match(match_value.create__PDR__list(), legacy)){
TTCN_Logger::log_logmatch_info(".create_PDR_list");
single_value->field_create__PDR__list.log_match(match_value.create__PDR__list(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_create__FAR__list.match(match_value.create__FAR__list(), legacy)){
TTCN_Logger::log_logmatch_info(".create_FAR_list");
single_value->field_create__FAR__list.log_match(match_value.create__FAR__list(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.create__URR__list().ispresent()){
if(!single_value->field_create__URR__list.match(match_value.create__URR__list(), legacy)){
TTCN_Logger::log_logmatch_info(".create_URR_list");
single_value->field_create__URR__list.log_match(match_value.create__URR__list(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_create__URR__list.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".create_URR_list := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_create__URR__list.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.create__QER__list().ispresent()){
if(!single_value->field_create__QER__list.match(match_value.create__QER__list(), legacy)){
TTCN_Logger::log_logmatch_info(".create_QER_list");
single_value->field_create__QER__list.log_match(match_value.create__QER__list(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_create__QER__list.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".create_QER_list := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_create__QER__list.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.create__BAR().ispresent()){
if(!single_value->field_create__BAR.match(match_value.create__BAR(), legacy)){
TTCN_Logger::log_logmatch_info(".create_BAR");
single_value->field_create__BAR.log_match(match_value.create__BAR(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_create__BAR.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".create_BAR := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_create__BAR.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.create__traffic__endpoint__list().ispresent()){
if(!single_value->field_create__traffic__endpoint__list.match(match_value.create__traffic__endpoint__list(), legacy)){
TTCN_Logger::log_logmatch_info(".create_traffic_endpoint_list");
single_value->field_create__traffic__endpoint__list.log_match(match_value.create__traffic__endpoint__list(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_create__traffic__endpoint__list.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".create_traffic_endpoint_list := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_create__traffic__endpoint__list.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.pdn__type().ispresent()){
if(!single_value->field_pdn__type.match(match_value.pdn__type(), legacy)){
TTCN_Logger::log_logmatch_info(".pdn_type");
single_value->field_pdn__type.log_match(match_value.pdn__type(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_pdn__type.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".pdn_type := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_pdn__type.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.node__list().ispresent()){
if(!single_value->field_node__list.match(match_value.node__list(), legacy)){
TTCN_Logger::log_logmatch_info(".node_list");
single_value->field_node__list.log_match(match_value.node__list(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_node__list.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".node_list := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_node__list.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.up__inactivity__timer().ispresent()){
if(!single_value->field_up__inactivity__timer.match(match_value.up__inactivity__timer(), legacy)){
TTCN_Logger::log_logmatch_info(".up_inactivity_timer");
single_value->field_up__inactivity__timer.log_match(match_value.up__inactivity__timer(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_up__inactivity__timer.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".up_inactivity_timer := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_up__inactivity__timer.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ node_id := ");
single_value->field_node__id.log_match(match_value.node__id(), legacy);
TTCN_Logger::log_event_str(", CP_F_SEID := ");
single_value->field_CP__F__SEID.log_match(match_value.CP__F__SEID(), legacy);
TTCN_Logger::log_event_str(", create_PDR_list := ");
single_value->field_create__PDR__list.log_match(match_value.create__PDR__list(), legacy);
TTCN_Logger::log_event_str(", create_FAR_list := ");
single_value->field_create__FAR__list.log_match(match_value.create__FAR__list(), legacy);
TTCN_Logger::log_event_str(", create_URR_list := ");
if (match_value.create__URR__list().ispresent()) {
single_value->field_create__URR__list.log_match(match_value.create__URR__list(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_create__URR__list.log();
if (single_value->field_create__URR__list.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", create_QER_list := ");
if (match_value.create__QER__list().ispresent()) {
single_value->field_create__QER__list.log_match(match_value.create__QER__list(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_create__QER__list.log();
if (single_value->field_create__QER__list.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", create_BAR := ");
if (match_value.create__BAR().ispresent()) {
single_value->field_create__BAR.log_match(match_value.create__BAR(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_create__BAR.log();
if (single_value->field_create__BAR.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", create_traffic_endpoint_list := ");
if (match_value.create__traffic__endpoint__list().ispresent()) {
single_value->field_create__traffic__endpoint__list.log_match(match_value.create__traffic__endpoint__list(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_create__traffic__endpoint__list.log();
if (single_value->field_create__traffic__endpoint__list.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", pdn_type := ");
if (match_value.pdn__type().ispresent()) {
single_value->field_pdn__type.log_match(match_value.pdn__type(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_pdn__type.log();
if (single_value->field_pdn__type.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", node_list := ");
if (match_value.node__list().ispresent()) {
single_value->field_node__list.log_match(match_value.node__list(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_node__list.log();
if (single_value->field_node__list.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", up_inactivity_timer := ");
if (match_value.up__inactivity__timer().ispresent()) {
single_value->field_up__inactivity__timer.log_match(match_value.up__inactivity__timer(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_up__inactivity__timer.log();
if (single_value->field_up__inactivity__timer.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PFCP__Session__Establishment__Request_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (node__id().is_bound()) node__id().set_implicit_omit();
if (CP__F__SEID().is_bound()) CP__F__SEID().set_implicit_omit();
if (create__PDR__list().is_bound()) create__PDR__list().set_implicit_omit();
if (create__FAR__list().is_bound()) create__FAR__list().set_implicit_omit();
if (!create__URR__list().is_bound()) create__URR__list() = OMIT_VALUE;
else create__URR__list().set_implicit_omit();
if (!create__QER__list().is_bound()) create__QER__list() = OMIT_VALUE;
else create__QER__list().set_implicit_omit();
if (!create__BAR().is_bound()) create__BAR() = OMIT_VALUE;
else create__BAR().set_implicit_omit();
if (!create__traffic__endpoint__list().is_bound()) create__traffic__endpoint__list() = OMIT_VALUE;
else create__traffic__endpoint__list().set_implicit_omit();
if (!pdn__type().is_bound()) pdn__type() = OMIT_VALUE;
else pdn__type().set_implicit_omit();
if (!node__list().is_bound()) node__list() = OMIT_VALUE;
else node__list().set_implicit_omit();
if (!up__inactivity__timer().is_bound()) up__inactivity__timer() = OMIT_VALUE;
else up__inactivity__timer().set_implicit_omit();
}

void PFCP__Session__Establishment__Request_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_node__id.encode_text(text_buf);
single_value->field_CP__F__SEID.encode_text(text_buf);
single_value->field_create__PDR__list.encode_text(text_buf);
single_value->field_create__FAR__list.encode_text(text_buf);
single_value->field_create__URR__list.encode_text(text_buf);
single_value->field_create__QER__list.encode_text(text_buf);
single_value->field_create__BAR.encode_text(text_buf);
single_value->field_create__traffic__endpoint__list.encode_text(text_buf);
single_value->field_pdn__type.encode_text(text_buf);
single_value->field_node__list.encode_text(text_buf);
single_value->field_up__inactivity__timer.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @PFCP_Types.PFCP_Session_Establishment_Request.");
}
}

void PFCP__Session__Establishment__Request_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_node__id.decode_text(text_buf);
single_value->field_CP__F__SEID.decode_text(text_buf);
single_value->field_create__PDR__list.decode_text(text_buf);
single_value->field_create__FAR__list.decode_text(text_buf);
single_value->field_create__URR__list.decode_text(text_buf);
single_value->field_create__QER__list.decode_text(text_buf);
single_value->field_create__BAR.decode_text(text_buf);
single_value->field_create__traffic__endpoint__list.decode_text(text_buf);
single_value->field_pdn__type.decode_text(text_buf);
single_value->field_node__list.decode_text(text_buf);
single_value->field_up__inactivity__timer.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PFCP__Session__Establishment__Request_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @PFCP_Types.PFCP_Session_Establishment_Request.");
}
}

void PFCP__Session__Establishment__Request_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "set template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PFCP__Session__Establishment__Request_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (11<param.get_size()) {
      param.error("set template of type @PFCP_Types.PFCP_Session_Establishment_Request has 11 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) node__id().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) CP__F__SEID().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) create__PDR__list().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) create__FAR__list().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) create__URR__list().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) create__QER__list().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) create__BAR().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) create__traffic__endpoint__list().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) pdn__type().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) node__list().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) up__inactivity__timer().set_param(*param.get_elem(10));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "node_id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          node__id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "CP_F_SEID")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          CP__F__SEID().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "create_PDR_list")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          create__PDR__list().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "create_FAR_list")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          create__FAR__list().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "create_URR_list")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          create__URR__list().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "create_QER_list")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          create__QER__list().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "create_BAR")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          create__BAR().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "create_traffic_endpoint_list")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          create__traffic__endpoint__list().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pdn_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pdn__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "node_list")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          node__list().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "up_inactivity_timer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          up__inactivity__timer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @PFCP_Types.PFCP_Session_Establishment_Request: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PFCP__Session__Establishment__Request_template* precondition = new PFCP__Session__Establishment__Request_template;
    precondition->set_param(*param.get_elem(0));
    PFCP__Session__Establishment__Request_template* implied_template = new PFCP__Session__Establishment__Request_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PFCP__Session__Establishment__Request_template(precondition, implied_template);
  } break;
  default:
    param.type_error("set template", "@PFCP_Types.PFCP_Session_Establishment_Request");
  }
  is_ifpresent = param.get_ifpresent();
}

void PFCP__Session__Establishment__Request_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_node__id.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.PFCP_Session_Establishment_Request");
single_value->field_CP__F__SEID.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.PFCP_Session_Establishment_Request");
single_value->field_create__PDR__list.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.PFCP_Session_Establishment_Request");
single_value->field_create__FAR__list.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.PFCP_Session_Establishment_Request");
single_value->field_create__URR__list.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.PFCP_Session_Establishment_Request");
single_value->field_create__QER__list.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.PFCP_Session_Establishment_Request");
single_value->field_create__BAR.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.PFCP_Session_Establishment_Request");
single_value->field_create__traffic__endpoint__list.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.PFCP_Session_Establishment_Request");
single_value->field_pdn__type.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.PFCP_Session_Establishment_Request");
single_value->field_node__list.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.PFCP_Session_Establishment_Request");
single_value->field_up__inactivity__timer.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.PFCP_Session_Establishment_Request");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@PFCP_Types.PFCP_Session_Establishment_Request");
}

boolean PFCP__Session__Establishment__Request_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PFCP__Session__Establishment__Request_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const Create__URR Create__URR__list::UNBOUND_ELEM;
Create__URR__list::Create__URR__list()
{
val_ptr = NULL;
}

Create__URR__list::Create__URR__list(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

Create__URR__list::Create__URR__list(const Create__URR__list& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @PFCP_Types.Create_URR_list.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

Create__URR__list::~Create__URR__list()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void Create__URR__list::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

Create__URR__list& Create__URR__list::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

Create__URR__list& Create__URR__list::operator=(const Create__URR__list& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @PFCP_Types.Create_URR_list.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean Create__URR__list::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @PFCP_Types.Create_URR_list.");
return val_ptr->n_elements == 0 ;
}

boolean Create__URR__list::operator==(const Create__URR__list& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @PFCP_Types.Create_URR_list.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @PFCP_Types.Create_URR_list.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

Create__URR& Create__URR__list::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @PFCP_Types.Create_URR_list using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (Create__URR**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new Create__URR(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new Create__URR;
}
return *val_ptr->value_elements[index_value];
}

Create__URR& Create__URR__list::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @PFCP_Types.Create_URR_list.");
return (*this)[(int)index_value];
}

const Create__URR& Create__URR__list::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @PFCP_Types.Create_URR_list.");
if (index_value < 0) TTCN_error("Accessing an element of type @PFCP_Types.Create_URR_list using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @PFCP_Types.Create_URR_list: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const Create__URR& Create__URR__list::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @PFCP_Types.Create_URR_list.");
return (*this)[(int)index_value];
}

Create__URR__list Create__URR__list::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

Create__URR__list Create__URR__list::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

Create__URR__list Create__URR__list::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

Create__URR__list Create__URR__list::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @PFCP_Types.Create_URR_list.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
Create__URR__list ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new Create__URR(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

Create__URR__list Create__URR__list::operator+(const Create__URR__list& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @PFCP_Types.Create_URR_list concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
Create__URR__list ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new Create__URR(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new Create__URR(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

Create__URR__list Create__URR__list::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @PFCP_Types.Create_URR_list.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@PFCP_Types.Create_URR_list","element");
Create__URR__list ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new Create__URR(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

Create__URR__list Create__URR__list::replace(int index, int len, const Create__URR__list& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @PFCP_Types.Create_URR_list.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @PFCP_Types.Create_URR_list.");
check_replace_arguments(val_ptr->n_elements, index, len, "@PFCP_Types.Create_URR_list","element");
Create__URR__list ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new Create__URR(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new Create__URR(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new Create__URR(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

Create__URR__list Create__URR__list::replace(int index, int len, const Create__URR__list_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void Create__URR__list::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @PFCP_Types.Create_URR_list.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (Create__URR**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new Create__URR(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (Create__URR**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @PFCP_Types.Create_URR_list: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (Create__URR**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean Create__URR__list::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int Create__URR__list::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @PFCP_Types.Create_URR_list.");
return val_ptr->n_elements;
}

int Create__URR__list::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @PFCP_Types.Create_URR_list.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void Create__URR__list::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void Create__URR__list::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void Create__URR__list::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@PFCP_Types.Create_URR_list");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@PFCP_Types.Create_URR_list");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void Create__URR__list::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @PFCP_Types.Create_URR_list.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void Create__URR__list::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @PFCP_Types.Create_URR_list.");
val_ptr->value_elements = (Create__URR**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new Create__URR;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void Create__URR__list::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Create__URR__list::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int Create__URR__list::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean /*no_err*/, int sel_field, boolean first_call, const RAW_Force_Omit*){
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int decoded_field_length=0;
  size_t start_of_field=0;
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int start_field=val_ptr->n_elements;
  if(p_td.raw->fieldlength || sel_field!=-1){
    int a=0;
    if(sel_field==-1) sel_field=p_td.raw->fieldlength;
    start_of_field=p_buf.get_pos_bit();
    for(a=0;a<sel_field;a++){
      decoded_field_length=(*this)[a+start_field].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        while(a>=0){
          delete &(*this)[a+start_field];
          a--;
          val_ptr->n_elements--;
        }
        p_buf.set_pos_bit(start_of_field);
        return decoded_field_length;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
    }
    if(a==0) val_ptr->n_elements=0;
  } else {
    if(limit==0){
      if(!first_call) return -1;
      val_ptr->n_elements=0;
      return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
    }
    int a=start_field;
    while(limit>0){
      start_of_field=p_buf.get_pos_bit();
      decoded_field_length=(*this)[a].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        delete &(*this)[a];
        val_ptr->n_elements--;
        p_buf.set_pos_bit(start_of_field);
        if(a>start_field){
        return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
        } else return -1;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
      a++;
    }
  }
 return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
}

int Create__URR__list::RAW_encode(const TTCN_Typedescriptor_t& p_td,RAW_enc_tree& myleaf) const{
  int encoded_length=0;
  int encoded_num_of_records=p_td.raw->fieldlength?smaller(val_ptr->n_elements, p_td.raw->fieldlength):val_ptr->n_elements;
  myleaf.isleaf=FALSE;
  myleaf.rec_of=TRUE;
  myleaf.body.node.num_of_nodes=encoded_num_of_records;
  myleaf.body.node.nodes=init_nodes_of_enc_tree(encoded_num_of_records);
  for(int a=0;a<encoded_num_of_records;a++){
    myleaf.body.node.nodes[a]=new RAW_enc_tree(TRUE,&myleaf,&(myleaf.curr_pos),a,p_td.oftype_descr->raw);
    encoded_length+=(*this)[a].RAW_encode(*p_td.oftype_descr,*myleaf.body.node.nodes[a]);
  }
 return myleaf.length=encoded_length;
}

void Create__URR__list_template::copy_value(const Create__URR__list& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @PFCP_Types.Create_URR_list with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (Create__URR_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new Create__URR_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new Create__URR_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void Create__URR__list_template::copy_template(const Create__URR__list_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (Create__URR_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new Create__URR_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new Create__URR_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Create__URR__list_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Create__URR__list_template(*other_value.implication_.precondition);
implication_.implied_template = new Create__URR__list_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @PFCP_Types.Create_URR_list.");
break;
}
set_selection(other_value);
}

boolean Create__URR__list_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const Create__URR__list_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const Create__URR__list*)value_ptr)[value_index], legacy);
else return ((const Create__URR__list_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

Create__URR__list_template::Create__URR__list_template()
{
}

Create__URR__list_template::Create__URR__list_template(template_sel other_value)
 : Base_Record_Of_Template(other_value)
{
check_single_selection(other_value);
}

Create__URR__list_template::Create__URR__list_template(null_type)
 : Base_Record_Of_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

Create__URR__list_template::Create__URR__list_template(const Create__URR__list& other_value)
{
copy_value(other_value);
}

Create__URR__list_template::Create__URR__list_template(const OPTIONAL<Create__URR__list>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Create__URR__list&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @PFCP_Types.Create_URR_list from an unbound optional field.");
}
}

Create__URR__list_template::Create__URR__list_template(Create__URR__list_template* p_precondition, Create__URR__list_template* p_implied_template)
 : Base_Record_Of_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

Create__URR__list_template::Create__URR__list_template(Dynamic_Match_Interface<Create__URR__list>* p_dyn_match)
 : Base_Record_Of_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<Create__URR__list>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

Create__URR__list_template::Create__URR__list_template(const Create__URR__list_template& other_value)
 : Base_Record_Of_Template()
{
copy_template(other_value);
}

Create__URR__list_template::~Create__URR__list_template()
{
clean_up();
}

void Create__URR__list_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

Create__URR__list_template& Create__URR__list_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

Create__URR__list_template& Create__URR__list_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

Create__URR__list_template& Create__URR__list_template::operator=(const Create__URR__list& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

Create__URR__list_template& Create__URR__list_template::operator=(const OPTIONAL<Create__URR__list>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Create__URR__list&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @PFCP_Types.Create_URR_list.");
}
return *this;
}

Create__URR__list_template& Create__URR__list_template::operator=(const Create__URR__list_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

Create__URR_template& Create__URR__list_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @PFCP_Types.Create_URR_list using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @PFCP_Types.Create_URR_list.");
    break;
}
return *single_value.value_elements[index_value];
}

Create__URR_template& Create__URR__list_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @PFCP_Types.Create_URR_list.");
return (*this)[(int)index_value];
}

const Create__URR_template& Create__URR__list_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @PFCP_Types.Create_URR_list using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @PFCP_Types.Create_URR_list.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @PFCP_Types.Create_URR_list: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const Create__URR_template& Create__URR__list_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @PFCP_Types.Create_URR_list.");
return (*this)[(int)index_value];
}

void Create__URR__list_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @PFCP_Types.Create_URR_list.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (Create__URR_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new Create__URR_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new Create__URR_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (Create__URR_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int Create__URR__list_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int Create__URR__list_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @PFCP_Types.Create_URR_list which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @PFCP_Types.Create_URR_list containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @PFCP_Types.Create_URR_list containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @PFCP_Types.Create_URR_list containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @PFCP_Types.Create_URR_list containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @PFCP_Types.Create_URR_list containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @PFCP_Types.Create_URR_list.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @PFCP_Types.Create_URR_list");
}

boolean Create__URR__list_template::match(const Create__URR__list& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_record_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @PFCP_Types.Create_URR_list.");
}
return FALSE;
}

boolean Create__URR__list_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

Create__URR__list Create__URR__list_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @PFCP_Types.Create_URR_list.");
Create__URR__list ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

Create__URR__list Create__URR__list_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

Create__URR__list Create__URR__list_template::replace(int index, int len, const Create__URR__list_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

Create__URR__list Create__URR__list_template::replace(int index, int len, const Create__URR__list& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void Create__URR__list_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new Create__URR__list_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @PFCP_Types.Create_URR_list.");
}
set_selection(template_type);
}

Create__URR__list_template& Create__URR__list_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @PFCP_Types.Create_URR_list.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @PFCP_Types.Create_URR_list.");
return value_list.list_value[list_index];
}

void Create__URR__list_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
if (permutation_starts_at(elem_count)) TTCN_Logger::log_event_str("permutation(");
single_value.value_elements[elem_count]->log();
if (permutation_ends_at(elem_count)) TTCN_Logger::log_char(')');
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void Create__URR__list_template::log_match(const Create__URR__list& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if(!single_value.value_elements[elem_count]->match(match_value[elem_count], legacy)){
TTCN_Logger::log_logmatch_info("[%d]", elem_count);
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
log_match_length(single_value.n_elements);
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
}
TTCN_Logger::log_event_str(" }");
log_match_length(single_value.n_elements);
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void Create__URR__list_template::encode_text(Text_Buf& text_buf) const
{
encode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @PFCP_Types.Create_URR_list.");
}
}

void Create__URR__list_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @PFCP_Types.Create_URR_list.");
single_value.value_elements = (Create__URR_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new Create__URR_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new Create__URR__list_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @PFCP_Types.Create_URR_list.");
}
}

boolean Create__URR__list_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean Create__URR__list_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void Create__URR__list_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void Create__URR__list_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "record of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    Create__URR__list_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List: {
    set_size(param.get_size());
    int curr_idx = 0;
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      switch (param.get_elem(p_i)->get_type()) {
      case Module_Param::MP_NotUsed:
        curr_idx++;
        break;
      case Module_Param::MP_Permutation_Template: {
        int perm_start_idx = curr_idx;
        Module_Param* param_i = param.get_elem(p_i);
        for (size_t perm_i=0; perm_i<param_i->get_size(); perm_i++) {
          (*this)[curr_idx].set_param(*(param_i->get_elem(perm_i)));
          curr_idx++;
        }
        int perm_end_idx = curr_idx - 1;
        add_permutation(perm_start_idx, perm_end_idx);
      } break;
      default:
        (*this)[curr_idx].set_param(*param.get_elem(p_i));
        curr_idx++;
      }
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    Create__URR__list_template* precondition = new Create__URR__list_template;
    precondition->set_param(*param.get_elem(0));
    Create__URR__list_template* implied_template = new Create__URR__list_template;
    implied_template->set_param(*param.get_elem(1));
    *this = Create__URR__list_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record of template", "@PFCP_Types.Create_URR_list");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void Create__URR__list_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_URR_list");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@PFCP_Types.Create_URR_list");
}

boolean Create__URR__list_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return number_of_permutations;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
Create__URR_grouped__ie::Create__URR_grouped__ie()
{
}

Create__URR_grouped__ie::Create__URR_grouped__ie(const URR__ID& par_urr__id,
    const Measurement__Method& par_measurement__method,
    const Reporting__Triggers& par_reporting__triggers,
    const OPTIONAL< Measurement__Period >& par_measurement__period,
    const OPTIONAL< Volume__Threshold >& par_volume__threshold,
    const OPTIONAL< Volume__Quota >& par_volume__quota,
    const OPTIONAL< Time__Threshold >& par_time__threshold,
    const OPTIONAL< Time__Quota >& par_time__quota,
    const OPTIONAL< Quota__Holding__Time >& par_quota__holding__time,
    const OPTIONAL< Dropped__DL__Traffic__Threshold >& par_dropped__dl__traffic__threshold,
    const OPTIONAL< Monitoring__Time >& par_monitoring__time,
    const OPTIONAL< Subsequent__Volume__Threshold >& par_subsequent__volume__threshold,
    const OPTIONAL< Subsequent__Time__Threshold >& par_subsequent__time__threshold,
    const OPTIONAL< Subsequent__Volume__Quota >& par_subsequent__volume__quota,
    const OPTIONAL< Subsequent__Time__Quota >& par_subsequent__time__quota,
    const OPTIONAL< Inactivity__Detection__Time >& par_inactivity__detection__time,
    const OPTIONAL< Linked__URR__ID >& par_linked__urr__id,
    const OPTIONAL< Measurement__Information >& par_measurement__information,
    const OPTIONAL< Time__Quota__Mechanism >& par_time__qouta__mechanism,
    const OPTIONAL< Aggregated__URR__list >& par_aggregated__urrs)
  :   field_urr__id(par_urr__id),
  field_measurement__method(par_measurement__method),
  field_reporting__triggers(par_reporting__triggers),
  field_measurement__period(par_measurement__period),
  field_volume__threshold(par_volume__threshold),
  field_volume__quota(par_volume__quota),
  field_time__threshold(par_time__threshold),
  field_time__quota(par_time__quota),
  field_quota__holding__time(par_quota__holding__time),
  field_dropped__dl__traffic__threshold(par_dropped__dl__traffic__threshold),
  field_monitoring__time(par_monitoring__time),
  field_subsequent__volume__threshold(par_subsequent__volume__threshold),
  field_subsequent__time__threshold(par_subsequent__time__threshold),
  field_subsequent__volume__quota(par_subsequent__volume__quota),
  field_subsequent__time__quota(par_subsequent__time__quota),
  field_inactivity__detection__time(par_inactivity__detection__time),
  field_linked__urr__id(par_linked__urr__id),
  field_measurement__information(par_measurement__information),
  field_time__qouta__mechanism(par_time__qouta__mechanism),
  field_aggregated__urrs(par_aggregated__urrs)
{
}

Create__URR_grouped__ie::Create__URR_grouped__ie(const Create__URR_grouped__ie& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @PFCP_Types.Create_URR.grouped_ie.");
if (other_value.urr__id().is_bound()) field_urr__id = other_value.urr__id();
else field_urr__id.clean_up();
if (other_value.measurement__method().is_bound()) field_measurement__method = other_value.measurement__method();
else field_measurement__method.clean_up();
if (other_value.reporting__triggers().is_bound()) field_reporting__triggers = other_value.reporting__triggers();
else field_reporting__triggers.clean_up();
if (other_value.measurement__period().is_bound()) field_measurement__period = other_value.measurement__period();
else field_measurement__period.clean_up();
if (other_value.volume__threshold().is_bound()) field_volume__threshold = other_value.volume__threshold();
else field_volume__threshold.clean_up();
if (other_value.volume__quota().is_bound()) field_volume__quota = other_value.volume__quota();
else field_volume__quota.clean_up();
if (other_value.time__threshold().is_bound()) field_time__threshold = other_value.time__threshold();
else field_time__threshold.clean_up();
if (other_value.time__quota().is_bound()) field_time__quota = other_value.time__quota();
else field_time__quota.clean_up();
if (other_value.quota__holding__time().is_bound()) field_quota__holding__time = other_value.quota__holding__time();
else field_quota__holding__time.clean_up();
if (other_value.dropped__dl__traffic__threshold().is_bound()) field_dropped__dl__traffic__threshold = other_value.dropped__dl__traffic__threshold();
else field_dropped__dl__traffic__threshold.clean_up();
if (other_value.monitoring__time().is_bound()) field_monitoring__time = other_value.monitoring__time();
else field_monitoring__time.clean_up();
if (other_value.subsequent__volume__threshold().is_bound()) field_subsequent__volume__threshold = other_value.subsequent__volume__threshold();
else field_subsequent__volume__threshold.clean_up();
if (other_value.subsequent__time__threshold().is_bound()) field_subsequent__time__threshold = other_value.subsequent__time__threshold();
else field_subsequent__time__threshold.clean_up();
if (other_value.subsequent__volume__quota().is_bound()) field_subsequent__volume__quota = other_value.subsequent__volume__quota();
else field_subsequent__volume__quota.clean_up();
if (other_value.subsequent__time__quota().is_bound()) field_subsequent__time__quota = other_value.subsequent__time__quota();
else field_subsequent__time__quota.clean_up();
if (other_value.inactivity__detection__time().is_bound()) field_inactivity__detection__time = other_value.inactivity__detection__time();
else field_inactivity__detection__time.clean_up();
if (other_value.linked__urr__id().is_bound()) field_linked__urr__id = other_value.linked__urr__id();
else field_linked__urr__id.clean_up();
if (other_value.measurement__information().is_bound()) field_measurement__information = other_value.measurement__information();
else field_measurement__information.clean_up();
if (other_value.time__qouta__mechanism().is_bound()) field_time__qouta__mechanism = other_value.time__qouta__mechanism();
else field_time__qouta__mechanism.clean_up();
if (other_value.aggregated__urrs().is_bound()) field_aggregated__urrs = other_value.aggregated__urrs();
else field_aggregated__urrs.clean_up();
}

void Create__URR_grouped__ie::clean_up()
{
field_urr__id.clean_up();
field_measurement__method.clean_up();
field_reporting__triggers.clean_up();
field_measurement__period.clean_up();
field_volume__threshold.clean_up();
field_volume__quota.clean_up();
field_time__threshold.clean_up();
field_time__quota.clean_up();
field_quota__holding__time.clean_up();
field_dropped__dl__traffic__threshold.clean_up();
field_monitoring__time.clean_up();
field_subsequent__volume__threshold.clean_up();
field_subsequent__time__threshold.clean_up();
field_subsequent__volume__quota.clean_up();
field_subsequent__time__quota.clean_up();
field_inactivity__detection__time.clean_up();
field_linked__urr__id.clean_up();
field_measurement__information.clean_up();
field_time__qouta__mechanism.clean_up();
field_aggregated__urrs.clean_up();
}

const TTCN_Typedescriptor_t* Create__URR_grouped__ie::get_descriptor() const { return &Create__URR_grouped__ie_descr_; }
Create__URR_grouped__ie& Create__URR_grouped__ie::operator=(const Create__URR_grouped__ie& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @PFCP_Types.Create_URR.grouped_ie.");
  if (other_value.urr__id().is_bound()) field_urr__id = other_value.urr__id();
  else field_urr__id.clean_up();
  if (other_value.measurement__method().is_bound()) field_measurement__method = other_value.measurement__method();
  else field_measurement__method.clean_up();
  if (other_value.reporting__triggers().is_bound()) field_reporting__triggers = other_value.reporting__triggers();
  else field_reporting__triggers.clean_up();
  if (other_value.measurement__period().is_bound()) field_measurement__period = other_value.measurement__period();
  else field_measurement__period.clean_up();
  if (other_value.volume__threshold().is_bound()) field_volume__threshold = other_value.volume__threshold();
  else field_volume__threshold.clean_up();
  if (other_value.volume__quota().is_bound()) field_volume__quota = other_value.volume__quota();
  else field_volume__quota.clean_up();
  if (other_value.time__threshold().is_bound()) field_time__threshold = other_value.time__threshold();
  else field_time__threshold.clean_up();
  if (other_value.time__quota().is_bound()) field_time__quota = other_value.time__quota();
  else field_time__quota.clean_up();
  if (other_value.quota__holding__time().is_bound()) field_quota__holding__time = other_value.quota__holding__time();
  else field_quota__holding__time.clean_up();
  if (other_value.dropped__dl__traffic__threshold().is_bound()) field_dropped__dl__traffic__threshold = other_value.dropped__dl__traffic__threshold();
  else field_dropped__dl__traffic__threshold.clean_up();
  if (other_value.monitoring__time().is_bound()) field_monitoring__time = other_value.monitoring__time();
  else field_monitoring__time.clean_up();
  if (other_value.subsequent__volume__threshold().is_bound()) field_subsequent__volume__threshold = other_value.subsequent__volume__threshold();
  else field_subsequent__volume__threshold.clean_up();
  if (other_value.subsequent__time__threshold().is_bound()) field_subsequent__time__threshold = other_value.subsequent__time__threshold();
  else field_subsequent__time__threshold.clean_up();
  if (other_value.subsequent__volume__quota().is_bound()) field_subsequent__volume__quota = other_value.subsequent__volume__quota();
  else field_subsequent__volume__quota.clean_up();
  if (other_value.subsequent__time__quota().is_bound()) field_subsequent__time__quota = other_value.subsequent__time__quota();
  else field_subsequent__time__quota.clean_up();
  if (other_value.inactivity__detection__time().is_bound()) field_inactivity__detection__time = other_value.inactivity__detection__time();
  else field_inactivity__detection__time.clean_up();
  if (other_value.linked__urr__id().is_bound()) field_linked__urr__id = other_value.linked__urr__id();
  else field_linked__urr__id.clean_up();
  if (other_value.measurement__information().is_bound()) field_measurement__information = other_value.measurement__information();
  else field_measurement__information.clean_up();
  if (other_value.time__qouta__mechanism().is_bound()) field_time__qouta__mechanism = other_value.time__qouta__mechanism();
  else field_time__qouta__mechanism.clean_up();
  if (other_value.aggregated__urrs().is_bound()) field_aggregated__urrs = other_value.aggregated__urrs();
  else field_aggregated__urrs.clean_up();
}
return *this;
}

boolean Create__URR_grouped__ie::operator==(const Create__URR_grouped__ie& other_value) const
{
return field_urr__id==other_value.field_urr__id
  && field_measurement__method==other_value.field_measurement__method
  && field_reporting__triggers==other_value.field_reporting__triggers
  && field_measurement__period==other_value.field_measurement__period
  && field_volume__threshold==other_value.field_volume__threshold
  && field_volume__quota==other_value.field_volume__quota
  && field_time__threshold==other_value.field_time__threshold
  && field_time__quota==other_value.field_time__quota
  && field_quota__holding__time==other_value.field_quota__holding__time
  && field_dropped__dl__traffic__threshold==other_value.field_dropped__dl__traffic__threshold
  && field_monitoring__time==other_value.field_monitoring__time
  && field_subsequent__volume__threshold==other_value.field_subsequent__volume__threshold
  && field_subsequent__time__threshold==other_value.field_subsequent__time__threshold
  && field_subsequent__volume__quota==other_value.field_subsequent__volume__quota
  && field_subsequent__time__quota==other_value.field_subsequent__time__quota
  && field_inactivity__detection__time==other_value.field_inactivity__detection__time
  && field_linked__urr__id==other_value.field_linked__urr__id
  && field_measurement__information==other_value.field_measurement__information
  && field_time__qouta__mechanism==other_value.field_time__qouta__mechanism
  && field_aggregated__urrs==other_value.field_aggregated__urrs;
}

boolean Create__URR_grouped__ie::is_bound() const
{
return (field_urr__id.is_bound())
  || (field_measurement__method.is_bound())
  || (field_reporting__triggers.is_bound())
  || (OPTIONAL_OMIT == field_measurement__period.get_selection() || field_measurement__period.is_bound())
  || (OPTIONAL_OMIT == field_volume__threshold.get_selection() || field_volume__threshold.is_bound())
  || (OPTIONAL_OMIT == field_volume__quota.get_selection() || field_volume__quota.is_bound())
  || (OPTIONAL_OMIT == field_time__threshold.get_selection() || field_time__threshold.is_bound())
  || (OPTIONAL_OMIT == field_time__quota.get_selection() || field_time__quota.is_bound())
  || (OPTIONAL_OMIT == field_quota__holding__time.get_selection() || field_quota__holding__time.is_bound())
  || (OPTIONAL_OMIT == field_dropped__dl__traffic__threshold.get_selection() || field_dropped__dl__traffic__threshold.is_bound())
  || (OPTIONAL_OMIT == field_monitoring__time.get_selection() || field_monitoring__time.is_bound())
  || (OPTIONAL_OMIT == field_subsequent__volume__threshold.get_selection() || field_subsequent__volume__threshold.is_bound())
  || (OPTIONAL_OMIT == field_subsequent__time__threshold.get_selection() || field_subsequent__time__threshold.is_bound())
  || (OPTIONAL_OMIT == field_subsequent__volume__quota.get_selection() || field_subsequent__volume__quota.is_bound())
  || (OPTIONAL_OMIT == field_subsequent__time__quota.get_selection() || field_subsequent__time__quota.is_bound())
  || (OPTIONAL_OMIT == field_inactivity__detection__time.get_selection() || field_inactivity__detection__time.is_bound())
  || (OPTIONAL_OMIT == field_linked__urr__id.get_selection() || field_linked__urr__id.is_bound())
  || (OPTIONAL_OMIT == field_measurement__information.get_selection() || field_measurement__information.is_bound())
  || (OPTIONAL_OMIT == field_time__qouta__mechanism.get_selection() || field_time__qouta__mechanism.is_bound())
  || (OPTIONAL_OMIT == field_aggregated__urrs.get_selection() || field_aggregated__urrs.is_bound());
}
boolean Create__URR_grouped__ie::is_value() const
{
return field_urr__id.is_value()
  && field_measurement__method.is_value()
  && field_reporting__triggers.is_value()
  && (OPTIONAL_OMIT == field_measurement__period.get_selection() || field_measurement__period.is_value())
  && (OPTIONAL_OMIT == field_volume__threshold.get_selection() || field_volume__threshold.is_value())
  && (OPTIONAL_OMIT == field_volume__quota.get_selection() || field_volume__quota.is_value())
  && (OPTIONAL_OMIT == field_time__threshold.get_selection() || field_time__threshold.is_value())
  && (OPTIONAL_OMIT == field_time__quota.get_selection() || field_time__quota.is_value())
  && (OPTIONAL_OMIT == field_quota__holding__time.get_selection() || field_quota__holding__time.is_value())
  && (OPTIONAL_OMIT == field_dropped__dl__traffic__threshold.get_selection() || field_dropped__dl__traffic__threshold.is_value())
  && (OPTIONAL_OMIT == field_monitoring__time.get_selection() || field_monitoring__time.is_value())
  && (OPTIONAL_OMIT == field_subsequent__volume__threshold.get_selection() || field_subsequent__volume__threshold.is_value())
  && (OPTIONAL_OMIT == field_subsequent__time__threshold.get_selection() || field_subsequent__time__threshold.is_value())
  && (OPTIONAL_OMIT == field_subsequent__volume__quota.get_selection() || field_subsequent__volume__quota.is_value())
  && (OPTIONAL_OMIT == field_subsequent__time__quota.get_selection() || field_subsequent__time__quota.is_value())
  && (OPTIONAL_OMIT == field_inactivity__detection__time.get_selection() || field_inactivity__detection__time.is_value())
  && (OPTIONAL_OMIT == field_linked__urr__id.get_selection() || field_linked__urr__id.is_value())
  && (OPTIONAL_OMIT == field_measurement__information.get_selection() || field_measurement__information.is_value())
  && (OPTIONAL_OMIT == field_time__qouta__mechanism.get_selection() || field_time__qouta__mechanism.is_value())
  && (OPTIONAL_OMIT == field_aggregated__urrs.get_selection() || field_aggregated__urrs.is_value());
}
int Create__URR_grouped__ie::size_of() const
{
  int ret_val = 3;
  if (field_measurement__period.ispresent()) ret_val++;
  if (field_volume__threshold.ispresent()) ret_val++;
  if (field_volume__quota.ispresent()) ret_val++;
  if (field_time__threshold.ispresent()) ret_val++;
  if (field_time__quota.ispresent()) ret_val++;
  if (field_quota__holding__time.ispresent()) ret_val++;
  if (field_dropped__dl__traffic__threshold.ispresent()) ret_val++;
  if (field_monitoring__time.ispresent()) ret_val++;
  if (field_subsequent__volume__threshold.ispresent()) ret_val++;
  if (field_subsequent__time__threshold.ispresent()) ret_val++;
  if (field_subsequent__volume__quota.ispresent()) ret_val++;
  if (field_subsequent__time__quota.ispresent()) ret_val++;
  if (field_inactivity__detection__time.ispresent()) ret_val++;
  if (field_linked__urr__id.ispresent()) ret_val++;
  if (field_measurement__information.ispresent()) ret_val++;
  if (field_time__qouta__mechanism.ispresent()) ret_val++;
  if (field_aggregated__urrs.ispresent()) ret_val++;
  return ret_val;
}

void Create__URR_grouped__ie::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ urr_id := ");
field_urr__id.log();
TTCN_Logger::log_event_str(", measurement_method := ");
field_measurement__method.log();
TTCN_Logger::log_event_str(", reporting_triggers := ");
field_reporting__triggers.log();
TTCN_Logger::log_event_str(", measurement_period := ");
field_measurement__period.log();
TTCN_Logger::log_event_str(", volume_threshold := ");
field_volume__threshold.log();
TTCN_Logger::log_event_str(", volume_quota := ");
field_volume__quota.log();
TTCN_Logger::log_event_str(", time_threshold := ");
field_time__threshold.log();
TTCN_Logger::log_event_str(", time_quota := ");
field_time__quota.log();
TTCN_Logger::log_event_str(", quota_holding_time := ");
field_quota__holding__time.log();
TTCN_Logger::log_event_str(", dropped_dl_traffic_threshold := ");
field_dropped__dl__traffic__threshold.log();
TTCN_Logger::log_event_str(", monitoring_time := ");
field_monitoring__time.log();
TTCN_Logger::log_event_str(", subsequent_volume_threshold := ");
field_subsequent__volume__threshold.log();
TTCN_Logger::log_event_str(", subsequent_time_threshold := ");
field_subsequent__time__threshold.log();
TTCN_Logger::log_event_str(", subsequent_volume_quota := ");
field_subsequent__volume__quota.log();
TTCN_Logger::log_event_str(", subsequent_time_quota := ");
field_subsequent__time__quota.log();
TTCN_Logger::log_event_str(", inactivity_detection_time := ");
field_inactivity__detection__time.log();
TTCN_Logger::log_event_str(", linked_urr_id := ");
field_linked__urr__id.log();
TTCN_Logger::log_event_str(", measurement_information := ");
field_measurement__information.log();
TTCN_Logger::log_event_str(", time_qouta_mechanism := ");
field_time__qouta__mechanism.log();
TTCN_Logger::log_event_str(", aggregated_urrs := ");
field_aggregated__urrs.log();
TTCN_Logger::log_event_str(" }");
}

void Create__URR_grouped__ie::set_implicit_omit()
{
if (urr__id().is_bound()) urr__id().set_implicit_omit();
if (measurement__method().is_bound()) measurement__method().set_implicit_omit();
if (reporting__triggers().is_bound()) reporting__triggers().set_implicit_omit();
if (!measurement__period().is_bound()) measurement__period() = OMIT_VALUE;
else measurement__period().set_implicit_omit();
if (!volume__threshold().is_bound()) volume__threshold() = OMIT_VALUE;
else volume__threshold().set_implicit_omit();
if (!volume__quota().is_bound()) volume__quota() = OMIT_VALUE;
else volume__quota().set_implicit_omit();
if (!time__threshold().is_bound()) time__threshold() = OMIT_VALUE;
else time__threshold().set_implicit_omit();
if (!time__quota().is_bound()) time__quota() = OMIT_VALUE;
else time__quota().set_implicit_omit();
if (!quota__holding__time().is_bound()) quota__holding__time() = OMIT_VALUE;
else quota__holding__time().set_implicit_omit();
if (!dropped__dl__traffic__threshold().is_bound()) dropped__dl__traffic__threshold() = OMIT_VALUE;
else dropped__dl__traffic__threshold().set_implicit_omit();
if (!monitoring__time().is_bound()) monitoring__time() = OMIT_VALUE;
else monitoring__time().set_implicit_omit();
if (!subsequent__volume__threshold().is_bound()) subsequent__volume__threshold() = OMIT_VALUE;
else subsequent__volume__threshold().set_implicit_omit();
if (!subsequent__time__threshold().is_bound()) subsequent__time__threshold() = OMIT_VALUE;
else subsequent__time__threshold().set_implicit_omit();
if (!subsequent__volume__quota().is_bound()) subsequent__volume__quota() = OMIT_VALUE;
else subsequent__volume__quota().set_implicit_omit();
if (!subsequent__time__quota().is_bound()) subsequent__time__quota() = OMIT_VALUE;
else subsequent__time__quota().set_implicit_omit();
if (!inactivity__detection__time().is_bound()) inactivity__detection__time() = OMIT_VALUE;
else inactivity__detection__time().set_implicit_omit();
if (!linked__urr__id().is_bound()) linked__urr__id() = OMIT_VALUE;
else linked__urr__id().set_implicit_omit();
if (!measurement__information().is_bound()) measurement__information() = OMIT_VALUE;
else measurement__information().set_implicit_omit();
if (!time__qouta__mechanism().is_bound()) time__qouta__mechanism() = OMIT_VALUE;
else time__qouta__mechanism().set_implicit_omit();
if (!aggregated__urrs().is_bound()) aggregated__urrs() = OMIT_VALUE;
else aggregated__urrs().set_implicit_omit();
}

void Create__URR_grouped__ie::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "set value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (20<param.get_size()) {
      param.error("set value of type @PFCP_Types.Create_URR.grouped_ie has 20 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) urr__id().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) measurement__method().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) reporting__triggers().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) measurement__period().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) volume__threshold().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) volume__quota().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) time__threshold().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) time__quota().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) quota__holding__time().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) dropped__dl__traffic__threshold().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) monitoring__time().set_param(*param.get_elem(10));
    if (param.get_size()>11 && param.get_elem(11)->get_type()!=Module_Param::MP_NotUsed) subsequent__volume__threshold().set_param(*param.get_elem(11));
    if (param.get_size()>12 && param.get_elem(12)->get_type()!=Module_Param::MP_NotUsed) subsequent__time__threshold().set_param(*param.get_elem(12));
    if (param.get_size()>13 && param.get_elem(13)->get_type()!=Module_Param::MP_NotUsed) subsequent__volume__quota().set_param(*param.get_elem(13));
    if (param.get_size()>14 && param.get_elem(14)->get_type()!=Module_Param::MP_NotUsed) subsequent__time__quota().set_param(*param.get_elem(14));
    if (param.get_size()>15 && param.get_elem(15)->get_type()!=Module_Param::MP_NotUsed) inactivity__detection__time().set_param(*param.get_elem(15));
    if (param.get_size()>16 && param.get_elem(16)->get_type()!=Module_Param::MP_NotUsed) linked__urr__id().set_param(*param.get_elem(16));
    if (param.get_size()>17 && param.get_elem(17)->get_type()!=Module_Param::MP_NotUsed) measurement__information().set_param(*param.get_elem(17));
    if (param.get_size()>18 && param.get_elem(18)->get_type()!=Module_Param::MP_NotUsed) time__qouta__mechanism().set_param(*param.get_elem(18));
    if (param.get_size()>19 && param.get_elem(19)->get_type()!=Module_Param::MP_NotUsed) aggregated__urrs().set_param(*param.get_elem(19));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "urr_id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          urr__id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "measurement_method")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          measurement__method().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reporting_triggers")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reporting__triggers().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "measurement_period")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          measurement__period().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "volume_threshold")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          volume__threshold().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "volume_quota")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          volume__quota().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "time_threshold")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          time__threshold().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "time_quota")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          time__quota().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "quota_holding_time")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          quota__holding__time().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dropped_dl_traffic_threshold")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dropped__dl__traffic__threshold().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "monitoring_time")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          monitoring__time().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "subsequent_volume_threshold")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          subsequent__volume__threshold().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "subsequent_time_threshold")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          subsequent__time__threshold().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "subsequent_volume_quota")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          subsequent__volume__quota().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "subsequent_time_quota")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          subsequent__time__quota().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "inactivity_detection_time")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          inactivity__detection__time().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "linked_urr_id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          linked__urr__id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "measurement_information")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          measurement__information().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "time_qouta_mechanism")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          time__qouta__mechanism().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "aggregated_urrs")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          aggregated__urrs().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @PFCP_Types.Create_URR.grouped_ie: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("set value", "@PFCP_Types.Create_URR.grouped_ie");
  }
}

void Create__URR_grouped__ie::encode_text(Text_Buf& text_buf) const
{
field_urr__id.encode_text(text_buf);
field_measurement__method.encode_text(text_buf);
field_reporting__triggers.encode_text(text_buf);
field_measurement__period.encode_text(text_buf);
field_volume__threshold.encode_text(text_buf);
field_volume__quota.encode_text(text_buf);
field_time__threshold.encode_text(text_buf);
field_time__quota.encode_text(text_buf);
field_quota__holding__time.encode_text(text_buf);
field_dropped__dl__traffic__threshold.encode_text(text_buf);
field_monitoring__time.encode_text(text_buf);
field_subsequent__volume__threshold.encode_text(text_buf);
field_subsequent__time__threshold.encode_text(text_buf);
field_subsequent__volume__quota.encode_text(text_buf);
field_subsequent__time__quota.encode_text(text_buf);
field_inactivity__detection__time.encode_text(text_buf);
field_linked__urr__id.encode_text(text_buf);
field_measurement__information.encode_text(text_buf);
field_time__qouta__mechanism.encode_text(text_buf);
field_aggregated__urrs.encode_text(text_buf);
}

void Create__URR_grouped__ie::decode_text(Text_Buf& text_buf)
{
field_urr__id.decode_text(text_buf);
field_measurement__method.decode_text(text_buf);
field_reporting__triggers.decode_text(text_buf);
field_measurement__period.decode_text(text_buf);
field_volume__threshold.decode_text(text_buf);
field_volume__quota.decode_text(text_buf);
field_time__threshold.decode_text(text_buf);
field_time__quota.decode_text(text_buf);
field_quota__holding__time.decode_text(text_buf);
field_dropped__dl__traffic__threshold.decode_text(text_buf);
field_monitoring__time.decode_text(text_buf);
field_subsequent__volume__threshold.decode_text(text_buf);
field_subsequent__time__threshold.decode_text(text_buf);
field_subsequent__volume__quota.decode_text(text_buf);
field_subsequent__time__quota.decode_text(text_buf);
field_inactivity__detection__time.decode_text(text_buf);
field_linked__urr__id.decode_text(text_buf);
field_measurement__information.decode_text(text_buf);
field_time__qouta__mechanism.decode_text(text_buf);
field_aggregated__urrs.decode_text(text_buf);
}

void Create__URR_grouped__ie::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Create__URR_grouped__ie::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int Create__URR_grouped__ie::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean, int, boolean, const RAW_Force_Omit* force_omit)
{
int prepaddlength = p_buf.increase_pos_padd(p_td.raw->prepadding);
limit -= prepaddlength;
int decoded_length = 0;
int field_map[20];
memset(field_map, 0, sizeof(field_map));
size_t nof_mand_fields = 0;
field_measurement__period = OMIT_VALUE;
field_volume__threshold = OMIT_VALUE;
field_volume__quota = OMIT_VALUE;
field_time__threshold = OMIT_VALUE;
field_time__quota = OMIT_VALUE;
field_quota__holding__time = OMIT_VALUE;
field_dropped__dl__traffic__threshold = OMIT_VALUE;
field_monitoring__time = OMIT_VALUE;
field_subsequent__volume__threshold = OMIT_VALUE;
field_subsequent__time__threshold = OMIT_VALUE;
field_subsequent__volume__quota = OMIT_VALUE;
field_subsequent__time__quota = OMIT_VALUE;
field_inactivity__detection__time = OMIT_VALUE;
field_linked__urr__id = OMIT_VALUE;
field_measurement__information = OMIT_VALUE;
field_time__qouta__mechanism = OMIT_VALUE;
field_aggregated__urrs = OMIT_VALUE;
raw_order_t local_top_order;
if (p_td.raw->top_bit_order == TOP_BIT_INHERITED) local_top_order = top_bit_ord;
else if (p_td.raw->top_bit_order == TOP_BIT_RIGHT) local_top_order = ORDER_MSB;
else local_top_order = ORDER_LSB;
while (limit > 0) {
size_t fl_start_pos = p_buf.get_pos_bit();
if (field_map[0] == 0) {
RAW_Force_Omit field_0_force_omit(0, force_omit, URR__ID_descr_.raw->forceomit);
int decoded_field_length = field_urr__id.RAW_decode(URR__ID_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_0_force_omit);
if (decoded_field_length >= 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
nof_mand_fields++;
field_map[0] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
}
}
if (field_map[1] == 0) {
RAW_Force_Omit field_1_force_omit(1, force_omit, Measurement__Method_descr_.raw->forceomit);
int decoded_field_length = field_measurement__method.RAW_decode(Measurement__Method_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_1_force_omit);
if (decoded_field_length >= 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
nof_mand_fields++;
field_map[1] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
}
}
if (field_map[2] == 0) {
RAW_Force_Omit field_2_force_omit(2, force_omit, Reporting__Triggers_descr_.raw->forceomit);
int decoded_field_length = field_reporting__triggers.RAW_decode(Reporting__Triggers_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
if (decoded_field_length >= 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
nof_mand_fields++;
field_map[2] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
}
}
if (field_map[3] == 0 && (force_omit == NULL || !(*force_omit)(3))) {
RAW_Force_Omit field_3_force_omit(3, force_omit, Measurement__Period_descr_.raw->forceomit);
int decoded_field_length = field_measurement__period().RAW_decode(Measurement__Period_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[3] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_measurement__period = OMIT_VALUE;
}
}
if (field_map[4] == 0 && (force_omit == NULL || !(*force_omit)(4))) {
RAW_Force_Omit field_4_force_omit(4, force_omit, Volume__Threshold_descr_.raw->forceomit);
int decoded_field_length = field_volume__threshold().RAW_decode(Volume__Threshold_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_4_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[4] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_volume__threshold = OMIT_VALUE;
}
}
if (field_map[5] == 0 && (force_omit == NULL || !(*force_omit)(5))) {
RAW_Force_Omit field_5_force_omit(5, force_omit, Volume__Quota_descr_.raw->forceomit);
int decoded_field_length = field_volume__quota().RAW_decode(Volume__Quota_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_5_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[5] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_volume__quota = OMIT_VALUE;
}
}
if (field_map[6] == 0 && (force_omit == NULL || !(*force_omit)(6))) {
RAW_Force_Omit field_6_force_omit(6, force_omit, Time__Threshold_descr_.raw->forceomit);
int decoded_field_length = field_time__threshold().RAW_decode(Time__Threshold_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_6_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[6] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_time__threshold = OMIT_VALUE;
}
}
if (field_map[7] == 0 && (force_omit == NULL || !(*force_omit)(7))) {
RAW_Force_Omit field_7_force_omit(7, force_omit, Time__Quota_descr_.raw->forceomit);
int decoded_field_length = field_time__quota().RAW_decode(Time__Quota_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_7_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[7] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_time__quota = OMIT_VALUE;
}
}
if (field_map[8] == 0 && (force_omit == NULL || !(*force_omit)(8))) {
RAW_Force_Omit field_8_force_omit(8, force_omit, Quota__Holding__Time_descr_.raw->forceomit);
int decoded_field_length = field_quota__holding__time().RAW_decode(Quota__Holding__Time_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_8_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[8] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_quota__holding__time = OMIT_VALUE;
}
}
if (field_map[9] == 0 && (force_omit == NULL || !(*force_omit)(9))) {
RAW_Force_Omit field_9_force_omit(9, force_omit, Dropped__DL__Traffic__Threshold_descr_.raw->forceomit);
int decoded_field_length = field_dropped__dl__traffic__threshold().RAW_decode(Dropped__DL__Traffic__Threshold_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_9_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[9] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_dropped__dl__traffic__threshold = OMIT_VALUE;
}
}
if (field_map[10] == 0 && (force_omit == NULL || !(*force_omit)(10))) {
RAW_Force_Omit field_10_force_omit(10, force_omit, Monitoring__Time_descr_.raw->forceomit);
int decoded_field_length = field_monitoring__time().RAW_decode(Monitoring__Time_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_10_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[10] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_monitoring__time = OMIT_VALUE;
}
}
if (field_map[11] == 0 && (force_omit == NULL || !(*force_omit)(11))) {
RAW_Force_Omit field_11_force_omit(11, force_omit, Subsequent__Volume__Threshold_descr_.raw->forceomit);
int decoded_field_length = field_subsequent__volume__threshold().RAW_decode(Subsequent__Volume__Threshold_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_11_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[11] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_subsequent__volume__threshold = OMIT_VALUE;
}
}
if (field_map[12] == 0 && (force_omit == NULL || !(*force_omit)(12))) {
RAW_Force_Omit field_12_force_omit(12, force_omit, Subsequent__Time__Threshold_descr_.raw->forceomit);
int decoded_field_length = field_subsequent__time__threshold().RAW_decode(Subsequent__Time__Threshold_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_12_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[12] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_subsequent__time__threshold = OMIT_VALUE;
}
}
if (field_map[13] == 0 && (force_omit == NULL || !(*force_omit)(13))) {
RAW_Force_Omit field_13_force_omit(13, force_omit, Subsequent__Volume__Quota_descr_.raw->forceomit);
int decoded_field_length = field_subsequent__volume__quota().RAW_decode(Subsequent__Volume__Quota_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_13_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[13] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_subsequent__volume__quota = OMIT_VALUE;
}
}
if (field_map[14] == 0 && (force_omit == NULL || !(*force_omit)(14))) {
RAW_Force_Omit field_14_force_omit(14, force_omit, Subsequent__Time__Quota_descr_.raw->forceomit);
int decoded_field_length = field_subsequent__time__quota().RAW_decode(Subsequent__Time__Quota_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_14_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[14] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_subsequent__time__quota = OMIT_VALUE;
}
}
if (field_map[15] == 0 && (force_omit == NULL || !(*force_omit)(15))) {
RAW_Force_Omit field_15_force_omit(15, force_omit, Inactivity__Detection__Time_descr_.raw->forceomit);
int decoded_field_length = field_inactivity__detection__time().RAW_decode(Inactivity__Detection__Time_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_15_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[15] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_inactivity__detection__time = OMIT_VALUE;
}
}
if (field_map[16] == 0 && (force_omit == NULL || !(*force_omit)(16))) {
RAW_Force_Omit field_16_force_omit(16, force_omit, Linked__URR__ID_descr_.raw->forceomit);
int decoded_field_length = field_linked__urr__id().RAW_decode(Linked__URR__ID_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_16_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[16] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_linked__urr__id = OMIT_VALUE;
}
}
if (field_map[17] == 0 && (force_omit == NULL || !(*force_omit)(17))) {
RAW_Force_Omit field_17_force_omit(17, force_omit, Measurement__Information_descr_.raw->forceomit);
int decoded_field_length = field_measurement__information().RAW_decode(Measurement__Information_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_17_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[17] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_measurement__information = OMIT_VALUE;
}
}
if (field_map[18] == 0 && (force_omit == NULL || !(*force_omit)(18))) {
RAW_Force_Omit field_18_force_omit(18, force_omit, Time__Quota__Mechanism_descr_.raw->forceomit);
int decoded_field_length = field_time__qouta__mechanism().RAW_decode(Time__Quota__Mechanism_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_18_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[18] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_time__qouta__mechanism = OMIT_VALUE;
}
}
if (force_omit == NULL || !(*force_omit)(19)) {
RAW_Force_Omit field_19_force_omit(19, force_omit, Create__URR_grouped__ie_aggregated__urrs_descr_.raw->forceomit);
int decoded_field_length = field_aggregated__urrs().RAW_decode(Create__URR_grouped__ie_aggregated__urrs_descr_, p_buf, limit, local_top_order, TRUE, 1, field_map[19] == 0, &field_19_force_omit);
if (decoded_field_length > 0) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[19]++;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
if (field_map[19] == 0) field_aggregated__urrs = OMIT_VALUE;
}
}
break;
}
if (nof_mand_fields != 3) return limit ? -1 : -TTCN_EncDec::ET_INCOMPL_MSG;
return decoded_length + prepaddlength + p_buf.increase_pos_padd(p_td.raw->padding);
}

int Create__URR_grouped__ie::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 20;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(20);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, URR__ID_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, Measurement__Method_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, Reporting__Triggers_descr_.raw);
  if (field_measurement__period.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, Measurement__Period_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  if (field_volume__threshold.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, Volume__Threshold_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  if (field_volume__quota.ispresent()) {
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, Volume__Quota_descr_.raw);
  }
  else myleaf.body.node.nodes[5] = NULL;
  if (field_time__threshold.ispresent()) {
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, Time__Threshold_descr_.raw);
  }
  else myleaf.body.node.nodes[6] = NULL;
  if (field_time__quota.ispresent()) {
  myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 7, Time__Quota_descr_.raw);
  }
  else myleaf.body.node.nodes[7] = NULL;
  if (field_quota__holding__time.ispresent()) {
  myleaf.body.node.nodes[8] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 8, Quota__Holding__Time_descr_.raw);
  }
  else myleaf.body.node.nodes[8] = NULL;
  if (field_dropped__dl__traffic__threshold.ispresent()) {
  myleaf.body.node.nodes[9] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 9, Dropped__DL__Traffic__Threshold_descr_.raw);
  }
  else myleaf.body.node.nodes[9] = NULL;
  if (field_monitoring__time.ispresent()) {
  myleaf.body.node.nodes[10] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 10, Monitoring__Time_descr_.raw);
  }
  else myleaf.body.node.nodes[10] = NULL;
  if (field_subsequent__volume__threshold.ispresent()) {
  myleaf.body.node.nodes[11] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 11, Subsequent__Volume__Threshold_descr_.raw);
  }
  else myleaf.body.node.nodes[11] = NULL;
  if (field_subsequent__time__threshold.ispresent()) {
  myleaf.body.node.nodes[12] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 12, Subsequent__Time__Threshold_descr_.raw);
  }
  else myleaf.body.node.nodes[12] = NULL;
  if (field_subsequent__volume__quota.ispresent()) {
  myleaf.body.node.nodes[13] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 13, Subsequent__Volume__Quota_descr_.raw);
  }
  else myleaf.body.node.nodes[13] = NULL;
  if (field_subsequent__time__quota.ispresent()) {
  myleaf.body.node.nodes[14] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 14, Subsequent__Time__Quota_descr_.raw);
  }
  else myleaf.body.node.nodes[14] = NULL;
  if (field_inactivity__detection__time.ispresent()) {
  myleaf.body.node.nodes[15] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 15, Inactivity__Detection__Time_descr_.raw);
  }
  else myleaf.body.node.nodes[15] = NULL;
  if (field_linked__urr__id.ispresent()) {
  myleaf.body.node.nodes[16] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 16, Linked__URR__ID_descr_.raw);
  }
  else myleaf.body.node.nodes[16] = NULL;
  if (field_measurement__information.ispresent()) {
  myleaf.body.node.nodes[17] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 17, Measurement__Information_descr_.raw);
  }
  else myleaf.body.node.nodes[17] = NULL;
  if (field_time__qouta__mechanism.ispresent()) {
  myleaf.body.node.nodes[18] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 18, Time__Quota__Mechanism_descr_.raw);
  }
  else myleaf.body.node.nodes[18] = NULL;
  if (field_aggregated__urrs.ispresent()) {
  myleaf.body.node.nodes[19] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 19, Create__URR_grouped__ie_aggregated__urrs_descr_.raw);
  }
  else myleaf.body.node.nodes[19] = NULL;
  encoded_length += field_urr__id.RAW_encode(URR__ID_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_measurement__method.RAW_encode(Measurement__Method_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_reporting__triggers.RAW_encode(Reporting__Triggers_descr_, *myleaf.body.node.nodes[2]);
  if (field_measurement__period.ispresent()) {
  encoded_length += field_measurement__period().RAW_encode(Measurement__Period_descr_, *myleaf.body.node.nodes[3]);
  }
  if (field_volume__threshold.ispresent()) {
  encoded_length += field_volume__threshold().RAW_encode(Volume__Threshold_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_volume__quota.ispresent()) {
  encoded_length += field_volume__quota().RAW_encode(Volume__Quota_descr_, *myleaf.body.node.nodes[5]);
  }
  if (field_time__threshold.ispresent()) {
  encoded_length += field_time__threshold().RAW_encode(Time__Threshold_descr_, *myleaf.body.node.nodes[6]);
  }
  if (field_time__quota.ispresent()) {
  encoded_length += field_time__quota().RAW_encode(Time__Quota_descr_, *myleaf.body.node.nodes[7]);
  }
  if (field_quota__holding__time.ispresent()) {
  encoded_length += field_quota__holding__time().RAW_encode(Quota__Holding__Time_descr_, *myleaf.body.node.nodes[8]);
  }
  if (field_dropped__dl__traffic__threshold.ispresent()) {
  encoded_length += field_dropped__dl__traffic__threshold().RAW_encode(Dropped__DL__Traffic__Threshold_descr_, *myleaf.body.node.nodes[9]);
  }
  if (field_monitoring__time.ispresent()) {
  encoded_length += field_monitoring__time().RAW_encode(Monitoring__Time_descr_, *myleaf.body.node.nodes[10]);
  }
  if (field_subsequent__volume__threshold.ispresent()) {
  encoded_length += field_subsequent__volume__threshold().RAW_encode(Subsequent__Volume__Threshold_descr_, *myleaf.body.node.nodes[11]);
  }
  if (field_subsequent__time__threshold.ispresent()) {
  encoded_length += field_subsequent__time__threshold().RAW_encode(Subsequent__Time__Threshold_descr_, *myleaf.body.node.nodes[12]);
  }
  if (field_subsequent__volume__quota.ispresent()) {
  encoded_length += field_subsequent__volume__quota().RAW_encode(Subsequent__Volume__Quota_descr_, *myleaf.body.node.nodes[13]);
  }
  if (field_subsequent__time__quota.ispresent()) {
  encoded_length += field_subsequent__time__quota().RAW_encode(Subsequent__Time__Quota_descr_, *myleaf.body.node.nodes[14]);
  }
  if (field_inactivity__detection__time.ispresent()) {
  encoded_length += field_inactivity__detection__time().RAW_encode(Inactivity__Detection__Time_descr_, *myleaf.body.node.nodes[15]);
  }
  if (field_linked__urr__id.ispresent()) {
  encoded_length += field_linked__urr__id().RAW_encode(Linked__URR__ID_descr_, *myleaf.body.node.nodes[16]);
  }
  if (field_measurement__information.ispresent()) {
  encoded_length += field_measurement__information().RAW_encode(Measurement__Information_descr_, *myleaf.body.node.nodes[17]);
  }
  if (field_time__qouta__mechanism.ispresent()) {
  encoded_length += field_time__qouta__mechanism().RAW_encode(Time__Quota__Mechanism_descr_, *myleaf.body.node.nodes[18]);
  }
  if (field_aggregated__urrs.ispresent()) {
  encoded_length += field_aggregated__urrs().RAW_encode(Create__URR_grouped__ie_aggregated__urrs_descr_, *myleaf.body.node.nodes[19]);
  }
  return myleaf.length = encoded_length;
}

struct Create__URR_grouped__ie_template::single_value_struct {
URR__ID_template field_urr__id;
Measurement__Method_template field_measurement__method;
Reporting__Triggers_template field_reporting__triggers;
Measurement__Period_template field_measurement__period;
Volume__Threshold_template field_volume__threshold;
Volume__Quota_template field_volume__quota;
Time__Threshold_template field_time__threshold;
Time__Quota_template field_time__quota;
Quota__Holding__Time_template field_quota__holding__time;
Dropped__DL__Traffic__Threshold_template field_dropped__dl__traffic__threshold;
Monitoring__Time_template field_monitoring__time;
Subsequent__Volume__Threshold_template field_subsequent__volume__threshold;
Subsequent__Time__Threshold_template field_subsequent__time__threshold;
Subsequent__Volume__Quota_template field_subsequent__volume__quota;
Subsequent__Time__Quota_template field_subsequent__time__quota;
Inactivity__Detection__Time_template field_inactivity__detection__time;
Linked__URR__ID_template field_linked__urr__id;
Measurement__Information_template field_measurement__information;
Time__Quota__Mechanism_template field_time__qouta__mechanism;
Aggregated__URR__list_template field_aggregated__urrs;
};

void Create__URR_grouped__ie_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_urr__id = ANY_VALUE;
single_value->field_measurement__method = ANY_VALUE;
single_value->field_reporting__triggers = ANY_VALUE;
single_value->field_measurement__period = ANY_OR_OMIT;
single_value->field_volume__threshold = ANY_OR_OMIT;
single_value->field_volume__quota = ANY_OR_OMIT;
single_value->field_time__threshold = ANY_OR_OMIT;
single_value->field_time__quota = ANY_OR_OMIT;
single_value->field_quota__holding__time = ANY_OR_OMIT;
single_value->field_dropped__dl__traffic__threshold = ANY_OR_OMIT;
single_value->field_monitoring__time = ANY_OR_OMIT;
single_value->field_subsequent__volume__threshold = ANY_OR_OMIT;
single_value->field_subsequent__time__threshold = ANY_OR_OMIT;
single_value->field_subsequent__volume__quota = ANY_OR_OMIT;
single_value->field_subsequent__time__quota = ANY_OR_OMIT;
single_value->field_inactivity__detection__time = ANY_OR_OMIT;
single_value->field_linked__urr__id = ANY_OR_OMIT;
single_value->field_measurement__information = ANY_OR_OMIT;
single_value->field_time__qouta__mechanism = ANY_OR_OMIT;
single_value->field_aggregated__urrs = ANY_OR_OMIT;
}
}
}

void Create__URR_grouped__ie_template::copy_value(const Create__URR_grouped__ie& other_value)
{
single_value = new single_value_struct;
if (other_value.urr__id().is_bound()) {
  single_value->field_urr__id = other_value.urr__id();
} else {
  single_value->field_urr__id.clean_up();
}
if (other_value.measurement__method().is_bound()) {
  single_value->field_measurement__method = other_value.measurement__method();
} else {
  single_value->field_measurement__method.clean_up();
}
if (other_value.reporting__triggers().is_bound()) {
  single_value->field_reporting__triggers = other_value.reporting__triggers();
} else {
  single_value->field_reporting__triggers.clean_up();
}
if (other_value.measurement__period().is_bound()) {
  if (other_value.measurement__period().ispresent()) single_value->field_measurement__period = other_value.measurement__period()();
  else single_value->field_measurement__period = OMIT_VALUE;
} else {
  single_value->field_measurement__period.clean_up();
}
if (other_value.volume__threshold().is_bound()) {
  if (other_value.volume__threshold().ispresent()) single_value->field_volume__threshold = other_value.volume__threshold()();
  else single_value->field_volume__threshold = OMIT_VALUE;
} else {
  single_value->field_volume__threshold.clean_up();
}
if (other_value.volume__quota().is_bound()) {
  if (other_value.volume__quota().ispresent()) single_value->field_volume__quota = other_value.volume__quota()();
  else single_value->field_volume__quota = OMIT_VALUE;
} else {
  single_value->field_volume__quota.clean_up();
}
if (other_value.time__threshold().is_bound()) {
  if (other_value.time__threshold().ispresent()) single_value->field_time__threshold = other_value.time__threshold()();
  else single_value->field_time__threshold = OMIT_VALUE;
} else {
  single_value->field_time__threshold.clean_up();
}
if (other_value.time__quota().is_bound()) {
  if (other_value.time__quota().ispresent()) single_value->field_time__quota = other_value.time__quota()();
  else single_value->field_time__quota = OMIT_VALUE;
} else {
  single_value->field_time__quota.clean_up();
}
if (other_value.quota__holding__time().is_bound()) {
  if (other_value.quota__holding__time().ispresent()) single_value->field_quota__holding__time = other_value.quota__holding__time()();
  else single_value->field_quota__holding__time = OMIT_VALUE;
} else {
  single_value->field_quota__holding__time.clean_up();
}
if (other_value.dropped__dl__traffic__threshold().is_bound()) {
  if (other_value.dropped__dl__traffic__threshold().ispresent()) single_value->field_dropped__dl__traffic__threshold = other_value.dropped__dl__traffic__threshold()();
  else single_value->field_dropped__dl__traffic__threshold = OMIT_VALUE;
} else {
  single_value->field_dropped__dl__traffic__threshold.clean_up();
}
if (other_value.monitoring__time().is_bound()) {
  if (other_value.monitoring__time().ispresent()) single_value->field_monitoring__time = other_value.monitoring__time()();
  else single_value->field_monitoring__time = OMIT_VALUE;
} else {
  single_value->field_monitoring__time.clean_up();
}
if (other_value.subsequent__volume__threshold().is_bound()) {
  if (other_value.subsequent__volume__threshold().ispresent()) single_value->field_subsequent__volume__threshold = other_value.subsequent__volume__threshold()();
  else single_value->field_subsequent__volume__threshold = OMIT_VALUE;
} else {
  single_value->field_subsequent__volume__threshold.clean_up();
}
if (other_value.subsequent__time__threshold().is_bound()) {
  if (other_value.subsequent__time__threshold().ispresent()) single_value->field_subsequent__time__threshold = other_value.subsequent__time__threshold()();
  else single_value->field_subsequent__time__threshold = OMIT_VALUE;
} else {
  single_value->field_subsequent__time__threshold.clean_up();
}
if (other_value.subsequent__volume__quota().is_bound()) {
  if (other_value.subsequent__volume__quota().ispresent()) single_value->field_subsequent__volume__quota = other_value.subsequent__volume__quota()();
  else single_value->field_subsequent__volume__quota = OMIT_VALUE;
} else {
  single_value->field_subsequent__volume__quota.clean_up();
}
if (other_value.subsequent__time__quota().is_bound()) {
  if (other_value.subsequent__time__quota().ispresent()) single_value->field_subsequent__time__quota = other_value.subsequent__time__quota()();
  else single_value->field_subsequent__time__quota = OMIT_VALUE;
} else {
  single_value->field_subsequent__time__quota.clean_up();
}
if (other_value.inactivity__detection__time().is_bound()) {
  if (other_value.inactivity__detection__time().ispresent()) single_value->field_inactivity__detection__time = other_value.inactivity__detection__time()();
  else single_value->field_inactivity__detection__time = OMIT_VALUE;
} else {
  single_value->field_inactivity__detection__time.clean_up();
}
if (other_value.linked__urr__id().is_bound()) {
  if (other_value.linked__urr__id().ispresent()) single_value->field_linked__urr__id = other_value.linked__urr__id()();
  else single_value->field_linked__urr__id = OMIT_VALUE;
} else {
  single_value->field_linked__urr__id.clean_up();
}
if (other_value.measurement__information().is_bound()) {
  if (other_value.measurement__information().ispresent()) single_value->field_measurement__information = other_value.measurement__information()();
  else single_value->field_measurement__information = OMIT_VALUE;
} else {
  single_value->field_measurement__information.clean_up();
}
if (other_value.time__qouta__mechanism().is_bound()) {
  if (other_value.time__qouta__mechanism().ispresent()) single_value->field_time__qouta__mechanism = other_value.time__qouta__mechanism()();
  else single_value->field_time__qouta__mechanism = OMIT_VALUE;
} else {
  single_value->field_time__qouta__mechanism.clean_up();
}
if (other_value.aggregated__urrs().is_bound()) {
  if (other_value.aggregated__urrs().ispresent()) single_value->field_aggregated__urrs = other_value.aggregated__urrs()();
  else single_value->field_aggregated__urrs = OMIT_VALUE;
} else {
  single_value->field_aggregated__urrs.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void Create__URR_grouped__ie_template::copy_template(const Create__URR_grouped__ie_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.urr__id().get_selection()) {
single_value->field_urr__id = other_value.urr__id();
} else {
single_value->field_urr__id.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.measurement__method().get_selection()) {
single_value->field_measurement__method = other_value.measurement__method();
} else {
single_value->field_measurement__method.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.reporting__triggers().get_selection()) {
single_value->field_reporting__triggers = other_value.reporting__triggers();
} else {
single_value->field_reporting__triggers.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.measurement__period().get_selection()) {
single_value->field_measurement__period = other_value.measurement__period();
} else {
single_value->field_measurement__period.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.volume__threshold().get_selection()) {
single_value->field_volume__threshold = other_value.volume__threshold();
} else {
single_value->field_volume__threshold.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.volume__quota().get_selection()) {
single_value->field_volume__quota = other_value.volume__quota();
} else {
single_value->field_volume__quota.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.time__threshold().get_selection()) {
single_value->field_time__threshold = other_value.time__threshold();
} else {
single_value->field_time__threshold.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.time__quota().get_selection()) {
single_value->field_time__quota = other_value.time__quota();
} else {
single_value->field_time__quota.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.quota__holding__time().get_selection()) {
single_value->field_quota__holding__time = other_value.quota__holding__time();
} else {
single_value->field_quota__holding__time.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.dropped__dl__traffic__threshold().get_selection()) {
single_value->field_dropped__dl__traffic__threshold = other_value.dropped__dl__traffic__threshold();
} else {
single_value->field_dropped__dl__traffic__threshold.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.monitoring__time().get_selection()) {
single_value->field_monitoring__time = other_value.monitoring__time();
} else {
single_value->field_monitoring__time.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.subsequent__volume__threshold().get_selection()) {
single_value->field_subsequent__volume__threshold = other_value.subsequent__volume__threshold();
} else {
single_value->field_subsequent__volume__threshold.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.subsequent__time__threshold().get_selection()) {
single_value->field_subsequent__time__threshold = other_value.subsequent__time__threshold();
} else {
single_value->field_subsequent__time__threshold.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.subsequent__volume__quota().get_selection()) {
single_value->field_subsequent__volume__quota = other_value.subsequent__volume__quota();
} else {
single_value->field_subsequent__volume__quota.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.subsequent__time__quota().get_selection()) {
single_value->field_subsequent__time__quota = other_value.subsequent__time__quota();
} else {
single_value->field_subsequent__time__quota.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.inactivity__detection__time().get_selection()) {
single_value->field_inactivity__detection__time = other_value.inactivity__detection__time();
} else {
single_value->field_inactivity__detection__time.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.linked__urr__id().get_selection()) {
single_value->field_linked__urr__id = other_value.linked__urr__id();
} else {
single_value->field_linked__urr__id.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.measurement__information().get_selection()) {
single_value->field_measurement__information = other_value.measurement__information();
} else {
single_value->field_measurement__information.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.time__qouta__mechanism().get_selection()) {
single_value->field_time__qouta__mechanism = other_value.time__qouta__mechanism();
} else {
single_value->field_time__qouta__mechanism.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.aggregated__urrs().get_selection()) {
single_value->field_aggregated__urrs = other_value.aggregated__urrs();
} else {
single_value->field_aggregated__urrs.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Create__URR_grouped__ie_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Create__URR_grouped__ie_template(*other_value.implication_.precondition);
implication_.implied_template = new Create__URR_grouped__ie_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @PFCP_Types.Create_URR.grouped_ie.");
break;
}
set_selection(other_value);
}

Create__URR_grouped__ie_template::Create__URR_grouped__ie_template()
{
}

Create__URR_grouped__ie_template::Create__URR_grouped__ie_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

Create__URR_grouped__ie_template::Create__URR_grouped__ie_template(const Create__URR_grouped__ie& other_value)
{
copy_value(other_value);
}

Create__URR_grouped__ie_template::Create__URR_grouped__ie_template(const OPTIONAL<Create__URR_grouped__ie>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Create__URR_grouped__ie&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @PFCP_Types.Create_URR.grouped_ie from an unbound optional field.");
}
}

Create__URR_grouped__ie_template::Create__URR_grouped__ie_template(Create__URR_grouped__ie_template* p_precondition, Create__URR_grouped__ie_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

Create__URR_grouped__ie_template::Create__URR_grouped__ie_template(Dynamic_Match_Interface<Create__URR_grouped__ie>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<Create__URR_grouped__ie>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

Create__URR_grouped__ie_template::Create__URR_grouped__ie_template(const Create__URR_grouped__ie_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

Create__URR_grouped__ie_template::~Create__URR_grouped__ie_template()
{
clean_up();
}

Create__URR_grouped__ie_template& Create__URR_grouped__ie_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

Create__URR_grouped__ie_template& Create__URR_grouped__ie_template::operator=(const Create__URR_grouped__ie& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

Create__URR_grouped__ie_template& Create__URR_grouped__ie_template::operator=(const OPTIONAL<Create__URR_grouped__ie>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Create__URR_grouped__ie&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @PFCP_Types.Create_URR.grouped_ie.");
}
return *this;
}

Create__URR_grouped__ie_template& Create__URR_grouped__ie_template::operator=(const Create__URR_grouped__ie_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean Create__URR_grouped__ie_template::match(const Create__URR_grouped__ie& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.urr__id().is_bound()) return FALSE;
if(!single_value->field_urr__id.match(other_value.urr__id(), legacy))return FALSE;
if(!other_value.measurement__method().is_bound()) return FALSE;
if(!single_value->field_measurement__method.match(other_value.measurement__method(), legacy))return FALSE;
if(!other_value.reporting__triggers().is_bound()) return FALSE;
if(!single_value->field_reporting__triggers.match(other_value.reporting__triggers(), legacy))return FALSE;
if(!other_value.measurement__period().is_bound()) return FALSE;
if((other_value.measurement__period().ispresent() ? !single_value->field_measurement__period.match((const Measurement__Period&)other_value.measurement__period(), legacy) : !single_value->field_measurement__period.match_omit(legacy)))return FALSE;
if(!other_value.volume__threshold().is_bound()) return FALSE;
if((other_value.volume__threshold().ispresent() ? !single_value->field_volume__threshold.match((const Volume__Threshold&)other_value.volume__threshold(), legacy) : !single_value->field_volume__threshold.match_omit(legacy)))return FALSE;
if(!other_value.volume__quota().is_bound()) return FALSE;
if((other_value.volume__quota().ispresent() ? !single_value->field_volume__quota.match((const Volume__Quota&)other_value.volume__quota(), legacy) : !single_value->field_volume__quota.match_omit(legacy)))return FALSE;
if(!other_value.time__threshold().is_bound()) return FALSE;
if((other_value.time__threshold().ispresent() ? !single_value->field_time__threshold.match((const Time__Threshold&)other_value.time__threshold(), legacy) : !single_value->field_time__threshold.match_omit(legacy)))return FALSE;
if(!other_value.time__quota().is_bound()) return FALSE;
if((other_value.time__quota().ispresent() ? !single_value->field_time__quota.match((const Time__Quota&)other_value.time__quota(), legacy) : !single_value->field_time__quota.match_omit(legacy)))return FALSE;
if(!other_value.quota__holding__time().is_bound()) return FALSE;
if((other_value.quota__holding__time().ispresent() ? !single_value->field_quota__holding__time.match((const Quota__Holding__Time&)other_value.quota__holding__time(), legacy) : !single_value->field_quota__holding__time.match_omit(legacy)))return FALSE;
if(!other_value.dropped__dl__traffic__threshold().is_bound()) return FALSE;
if((other_value.dropped__dl__traffic__threshold().ispresent() ? !single_value->field_dropped__dl__traffic__threshold.match((const Dropped__DL__Traffic__Threshold&)other_value.dropped__dl__traffic__threshold(), legacy) : !single_value->field_dropped__dl__traffic__threshold.match_omit(legacy)))return FALSE;
if(!other_value.monitoring__time().is_bound()) return FALSE;
if((other_value.monitoring__time().ispresent() ? !single_value->field_monitoring__time.match((const Monitoring__Time&)other_value.monitoring__time(), legacy) : !single_value->field_monitoring__time.match_omit(legacy)))return FALSE;
if(!other_value.subsequent__volume__threshold().is_bound()) return FALSE;
if((other_value.subsequent__volume__threshold().ispresent() ? !single_value->field_subsequent__volume__threshold.match((const Subsequent__Volume__Threshold&)other_value.subsequent__volume__threshold(), legacy) : !single_value->field_subsequent__volume__threshold.match_omit(legacy)))return FALSE;
if(!other_value.subsequent__time__threshold().is_bound()) return FALSE;
if((other_value.subsequent__time__threshold().ispresent() ? !single_value->field_subsequent__time__threshold.match((const Subsequent__Time__Threshold&)other_value.subsequent__time__threshold(), legacy) : !single_value->field_subsequent__time__threshold.match_omit(legacy)))return FALSE;
if(!other_value.subsequent__volume__quota().is_bound()) return FALSE;
if((other_value.subsequent__volume__quota().ispresent() ? !single_value->field_subsequent__volume__quota.match((const Subsequent__Volume__Quota&)other_value.subsequent__volume__quota(), legacy) : !single_value->field_subsequent__volume__quota.match_omit(legacy)))return FALSE;
if(!other_value.subsequent__time__quota().is_bound()) return FALSE;
if((other_value.subsequent__time__quota().ispresent() ? !single_value->field_subsequent__time__quota.match((const Subsequent__Time__Quota&)other_value.subsequent__time__quota(), legacy) : !single_value->field_subsequent__time__quota.match_omit(legacy)))return FALSE;
if(!other_value.inactivity__detection__time().is_bound()) return FALSE;
if((other_value.inactivity__detection__time().ispresent() ? !single_value->field_inactivity__detection__time.match((const Inactivity__Detection__Time&)other_value.inactivity__detection__time(), legacy) : !single_value->field_inactivity__detection__time.match_omit(legacy)))return FALSE;
if(!other_value.linked__urr__id().is_bound()) return FALSE;
if((other_value.linked__urr__id().ispresent() ? !single_value->field_linked__urr__id.match((const Linked__URR__ID&)other_value.linked__urr__id(), legacy) : !single_value->field_linked__urr__id.match_omit(legacy)))return FALSE;
if(!other_value.measurement__information().is_bound()) return FALSE;
if((other_value.measurement__information().ispresent() ? !single_value->field_measurement__information.match((const Measurement__Information&)other_value.measurement__information(), legacy) : !single_value->field_measurement__information.match_omit(legacy)))return FALSE;
if(!other_value.time__qouta__mechanism().is_bound()) return FALSE;
if((other_value.time__qouta__mechanism().ispresent() ? !single_value->field_time__qouta__mechanism.match((const Time__Quota__Mechanism&)other_value.time__qouta__mechanism(), legacy) : !single_value->field_time__qouta__mechanism.match_omit(legacy)))return FALSE;
if(!other_value.aggregated__urrs().is_bound()) return FALSE;
if((other_value.aggregated__urrs().ispresent() ? !single_value->field_aggregated__urrs.match((const Aggregated__URR__list&)other_value.aggregated__urrs(), legacy) : !single_value->field_aggregated__urrs.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @PFCP_Types.Create_URR.grouped_ie.");
}
return FALSE;
}

boolean Create__URR_grouped__ie_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_urr__id.is_bound()
 || single_value->field_measurement__method.is_bound()
 || single_value->field_reporting__triggers.is_bound()
 || (single_value->field_measurement__period.is_omit() || single_value->field_measurement__period.is_bound())
 || (single_value->field_volume__threshold.is_omit() || single_value->field_volume__threshold.is_bound())
 || (single_value->field_volume__quota.is_omit() || single_value->field_volume__quota.is_bound())
 || (single_value->field_time__threshold.is_omit() || single_value->field_time__threshold.is_bound())
 || (single_value->field_time__quota.is_omit() || single_value->field_time__quota.is_bound())
 || (single_value->field_quota__holding__time.is_omit() || single_value->field_quota__holding__time.is_bound())
 || (single_value->field_dropped__dl__traffic__threshold.is_omit() || single_value->field_dropped__dl__traffic__threshold.is_bound())
 || (single_value->field_monitoring__time.is_omit() || single_value->field_monitoring__time.is_bound())
 || (single_value->field_subsequent__volume__threshold.is_omit() || single_value->field_subsequent__volume__threshold.is_bound())
 || (single_value->field_subsequent__time__threshold.is_omit() || single_value->field_subsequent__time__threshold.is_bound())
 || (single_value->field_subsequent__volume__quota.is_omit() || single_value->field_subsequent__volume__quota.is_bound())
 || (single_value->field_subsequent__time__quota.is_omit() || single_value->field_subsequent__time__quota.is_bound())
 || (single_value->field_inactivity__detection__time.is_omit() || single_value->field_inactivity__detection__time.is_bound())
 || (single_value->field_linked__urr__id.is_omit() || single_value->field_linked__urr__id.is_bound())
 || (single_value->field_measurement__information.is_omit() || single_value->field_measurement__information.is_bound())
 || (single_value->field_time__qouta__mechanism.is_omit() || single_value->field_time__qouta__mechanism.is_bound())
 || (single_value->field_aggregated__urrs.is_omit() || single_value->field_aggregated__urrs.is_bound());
}

boolean Create__URR_grouped__ie_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_urr__id.is_value()
 && single_value->field_measurement__method.is_value()
 && single_value->field_reporting__triggers.is_value()
 && (single_value->field_measurement__period.is_omit() || single_value->field_measurement__period.is_value())
 && (single_value->field_volume__threshold.is_omit() || single_value->field_volume__threshold.is_value())
 && (single_value->field_volume__quota.is_omit() || single_value->field_volume__quota.is_value())
 && (single_value->field_time__threshold.is_omit() || single_value->field_time__threshold.is_value())
 && (single_value->field_time__quota.is_omit() || single_value->field_time__quota.is_value())
 && (single_value->field_quota__holding__time.is_omit() || single_value->field_quota__holding__time.is_value())
 && (single_value->field_dropped__dl__traffic__threshold.is_omit() || single_value->field_dropped__dl__traffic__threshold.is_value())
 && (single_value->field_monitoring__time.is_omit() || single_value->field_monitoring__time.is_value())
 && (single_value->field_subsequent__volume__threshold.is_omit() || single_value->field_subsequent__volume__threshold.is_value())
 && (single_value->field_subsequent__time__threshold.is_omit() || single_value->field_subsequent__time__threshold.is_value())
 && (single_value->field_subsequent__volume__quota.is_omit() || single_value->field_subsequent__volume__quota.is_value())
 && (single_value->field_subsequent__time__quota.is_omit() || single_value->field_subsequent__time__quota.is_value())
 && (single_value->field_inactivity__detection__time.is_omit() || single_value->field_inactivity__detection__time.is_value())
 && (single_value->field_linked__urr__id.is_omit() || single_value->field_linked__urr__id.is_value())
 && (single_value->field_measurement__information.is_omit() || single_value->field_measurement__information.is_value())
 && (single_value->field_time__qouta__mechanism.is_omit() || single_value->field_time__qouta__mechanism.is_value())
 && (single_value->field_aggregated__urrs.is_omit() || single_value->field_aggregated__urrs.is_value());
}

void Create__URR_grouped__ie_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

Create__URR_grouped__ie Create__URR_grouped__ie_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @PFCP_Types.Create_URR.grouped_ie.");
Create__URR_grouped__ie ret_val;
if (single_value->field_urr__id.is_bound()) {
ret_val.urr__id() = single_value->field_urr__id.valueof();
}
if (single_value->field_measurement__method.is_bound()) {
ret_val.measurement__method() = single_value->field_measurement__method.valueof();
}
if (single_value->field_reporting__triggers.is_bound()) {
ret_val.reporting__triggers() = single_value->field_reporting__triggers.valueof();
}
if (single_value->field_measurement__period.is_omit()) ret_val.measurement__period() = OMIT_VALUE;
else if (single_value->field_measurement__period.is_bound()) {
ret_val.measurement__period() = single_value->field_measurement__period.valueof();
}
if (single_value->field_volume__threshold.is_omit()) ret_val.volume__threshold() = OMIT_VALUE;
else if (single_value->field_volume__threshold.is_bound()) {
ret_val.volume__threshold() = single_value->field_volume__threshold.valueof();
}
if (single_value->field_volume__quota.is_omit()) ret_val.volume__quota() = OMIT_VALUE;
else if (single_value->field_volume__quota.is_bound()) {
ret_val.volume__quota() = single_value->field_volume__quota.valueof();
}
if (single_value->field_time__threshold.is_omit()) ret_val.time__threshold() = OMIT_VALUE;
else if (single_value->field_time__threshold.is_bound()) {
ret_val.time__threshold() = single_value->field_time__threshold.valueof();
}
if (single_value->field_time__quota.is_omit()) ret_val.time__quota() = OMIT_VALUE;
else if (single_value->field_time__quota.is_bound()) {
ret_val.time__quota() = single_value->field_time__quota.valueof();
}
if (single_value->field_quota__holding__time.is_omit()) ret_val.quota__holding__time() = OMIT_VALUE;
else if (single_value->field_quota__holding__time.is_bound()) {
ret_val.quota__holding__time() = single_value->field_quota__holding__time.valueof();
}
if (single_value->field_dropped__dl__traffic__threshold.is_omit()) ret_val.dropped__dl__traffic__threshold() = OMIT_VALUE;
else if (single_value->field_dropped__dl__traffic__threshold.is_bound()) {
ret_val.dropped__dl__traffic__threshold() = single_value->field_dropped__dl__traffic__threshold.valueof();
}
if (single_value->field_monitoring__time.is_omit()) ret_val.monitoring__time() = OMIT_VALUE;
else if (single_value->field_monitoring__time.is_bound()) {
ret_val.monitoring__time() = single_value->field_monitoring__time.valueof();
}
if (single_value->field_subsequent__volume__threshold.is_omit()) ret_val.subsequent__volume__threshold() = OMIT_VALUE;
else if (single_value->field_subsequent__volume__threshold.is_bound()) {
ret_val.subsequent__volume__threshold() = single_value->field_subsequent__volume__threshold.valueof();
}
if (single_value->field_subsequent__time__threshold.is_omit()) ret_val.subsequent__time__threshold() = OMIT_VALUE;
else if (single_value->field_subsequent__time__threshold.is_bound()) {
ret_val.subsequent__time__threshold() = single_value->field_subsequent__time__threshold.valueof();
}
if (single_value->field_subsequent__volume__quota.is_omit()) ret_val.subsequent__volume__quota() = OMIT_VALUE;
else if (single_value->field_subsequent__volume__quota.is_bound()) {
ret_val.subsequent__volume__quota() = single_value->field_subsequent__volume__quota.valueof();
}
if (single_value->field_subsequent__time__quota.is_omit()) ret_val.subsequent__time__quota() = OMIT_VALUE;
else if (single_value->field_subsequent__time__quota.is_bound()) {
ret_val.subsequent__time__quota() = single_value->field_subsequent__time__quota.valueof();
}
if (single_value->field_inactivity__detection__time.is_omit()) ret_val.inactivity__detection__time() = OMIT_VALUE;
else if (single_value->field_inactivity__detection__time.is_bound()) {
ret_val.inactivity__detection__time() = single_value->field_inactivity__detection__time.valueof();
}
if (single_value->field_linked__urr__id.is_omit()) ret_val.linked__urr__id() = OMIT_VALUE;
else if (single_value->field_linked__urr__id.is_bound()) {
ret_val.linked__urr__id() = single_value->field_linked__urr__id.valueof();
}
if (single_value->field_measurement__information.is_omit()) ret_val.measurement__information() = OMIT_VALUE;
else if (single_value->field_measurement__information.is_bound()) {
ret_val.measurement__information() = single_value->field_measurement__information.valueof();
}
if (single_value->field_time__qouta__mechanism.is_omit()) ret_val.time__qouta__mechanism() = OMIT_VALUE;
else if (single_value->field_time__qouta__mechanism.is_bound()) {
ret_val.time__qouta__mechanism() = single_value->field_time__qouta__mechanism.valueof();
}
if (single_value->field_aggregated__urrs.is_omit()) ret_val.aggregated__urrs() = OMIT_VALUE;
else if (single_value->field_aggregated__urrs.is_bound()) {
ret_val.aggregated__urrs() = single_value->field_aggregated__urrs.valueof();
}
return ret_val;
}

void Create__URR_grouped__ie_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @PFCP_Types.Create_URR.grouped_ie.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new Create__URR_grouped__ie_template[list_length];
}

Create__URR_grouped__ie_template& Create__URR_grouped__ie_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @PFCP_Types.Create_URR.grouped_ie.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @PFCP_Types.Create_URR.grouped_ie.");
return value_list.list_value[list_index];
}

URR__ID_template& Create__URR_grouped__ie_template::urr__id()
{
set_specific();
return single_value->field_urr__id;
}

const URR__ID_template& Create__URR_grouped__ie_template::urr__id() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field urr_id of a non-specific template of type @PFCP_Types.Create_URR.grouped_ie.");
return single_value->field_urr__id;
}

Measurement__Method_template& Create__URR_grouped__ie_template::measurement__method()
{
set_specific();
return single_value->field_measurement__method;
}

const Measurement__Method_template& Create__URR_grouped__ie_template::measurement__method() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field measurement_method of a non-specific template of type @PFCP_Types.Create_URR.grouped_ie.");
return single_value->field_measurement__method;
}

Reporting__Triggers_template& Create__URR_grouped__ie_template::reporting__triggers()
{
set_specific();
return single_value->field_reporting__triggers;
}

const Reporting__Triggers_template& Create__URR_grouped__ie_template::reporting__triggers() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reporting_triggers of a non-specific template of type @PFCP_Types.Create_URR.grouped_ie.");
return single_value->field_reporting__triggers;
}

Measurement__Period_template& Create__URR_grouped__ie_template::measurement__period()
{
set_specific();
return single_value->field_measurement__period;
}

const Measurement__Period_template& Create__URR_grouped__ie_template::measurement__period() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field measurement_period of a non-specific template of type @PFCP_Types.Create_URR.grouped_ie.");
return single_value->field_measurement__period;
}

Volume__Threshold_template& Create__URR_grouped__ie_template::volume__threshold()
{
set_specific();
return single_value->field_volume__threshold;
}

const Volume__Threshold_template& Create__URR_grouped__ie_template::volume__threshold() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field volume_threshold of a non-specific template of type @PFCP_Types.Create_URR.grouped_ie.");
return single_value->field_volume__threshold;
}

Volume__Quota_template& Create__URR_grouped__ie_template::volume__quota()
{
set_specific();
return single_value->field_volume__quota;
}

const Volume__Quota_template& Create__URR_grouped__ie_template::volume__quota() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field volume_quota of a non-specific template of type @PFCP_Types.Create_URR.grouped_ie.");
return single_value->field_volume__quota;
}

Time__Threshold_template& Create__URR_grouped__ie_template::time__threshold()
{
set_specific();
return single_value->field_time__threshold;
}

const Time__Threshold_template& Create__URR_grouped__ie_template::time__threshold() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field time_threshold of a non-specific template of type @PFCP_Types.Create_URR.grouped_ie.");
return single_value->field_time__threshold;
}

Time__Quota_template& Create__URR_grouped__ie_template::time__quota()
{
set_specific();
return single_value->field_time__quota;
}

const Time__Quota_template& Create__URR_grouped__ie_template::time__quota() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field time_quota of a non-specific template of type @PFCP_Types.Create_URR.grouped_ie.");
return single_value->field_time__quota;
}

Quota__Holding__Time_template& Create__URR_grouped__ie_template::quota__holding__time()
{
set_specific();
return single_value->field_quota__holding__time;
}

const Quota__Holding__Time_template& Create__URR_grouped__ie_template::quota__holding__time() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field quota_holding_time of a non-specific template of type @PFCP_Types.Create_URR.grouped_ie.");
return single_value->field_quota__holding__time;
}

Dropped__DL__Traffic__Threshold_template& Create__URR_grouped__ie_template::dropped__dl__traffic__threshold()
{
set_specific();
return single_value->field_dropped__dl__traffic__threshold;
}

const Dropped__DL__Traffic__Threshold_template& Create__URR_grouped__ie_template::dropped__dl__traffic__threshold() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field dropped_dl_traffic_threshold of a non-specific template of type @PFCP_Types.Create_URR.grouped_ie.");
return single_value->field_dropped__dl__traffic__threshold;
}

Monitoring__Time_template& Create__URR_grouped__ie_template::monitoring__time()
{
set_specific();
return single_value->field_monitoring__time;
}

const Monitoring__Time_template& Create__URR_grouped__ie_template::monitoring__time() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field monitoring_time of a non-specific template of type @PFCP_Types.Create_URR.grouped_ie.");
return single_value->field_monitoring__time;
}

Subsequent__Volume__Threshold_template& Create__URR_grouped__ie_template::subsequent__volume__threshold()
{
set_specific();
return single_value->field_subsequent__volume__threshold;
}

const Subsequent__Volume__Threshold_template& Create__URR_grouped__ie_template::subsequent__volume__threshold() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field subsequent_volume_threshold of a non-specific template of type @PFCP_Types.Create_URR.grouped_ie.");
return single_value->field_subsequent__volume__threshold;
}

Subsequent__Time__Threshold_template& Create__URR_grouped__ie_template::subsequent__time__threshold()
{
set_specific();
return single_value->field_subsequent__time__threshold;
}

const Subsequent__Time__Threshold_template& Create__URR_grouped__ie_template::subsequent__time__threshold() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field subsequent_time_threshold of a non-specific template of type @PFCP_Types.Create_URR.grouped_ie.");
return single_value->field_subsequent__time__threshold;
}

Subsequent__Volume__Quota_template& Create__URR_grouped__ie_template::subsequent__volume__quota()
{
set_specific();
return single_value->field_subsequent__volume__quota;
}

const Subsequent__Volume__Quota_template& Create__URR_grouped__ie_template::subsequent__volume__quota() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field subsequent_volume_quota of a non-specific template of type @PFCP_Types.Create_URR.grouped_ie.");
return single_value->field_subsequent__volume__quota;
}

Subsequent__Time__Quota_template& Create__URR_grouped__ie_template::subsequent__time__quota()
{
set_specific();
return single_value->field_subsequent__time__quota;
}

const Subsequent__Time__Quota_template& Create__URR_grouped__ie_template::subsequent__time__quota() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field subsequent_time_quota of a non-specific template of type @PFCP_Types.Create_URR.grouped_ie.");
return single_value->field_subsequent__time__quota;
}

Inactivity__Detection__Time_template& Create__URR_grouped__ie_template::inactivity__detection__time()
{
set_specific();
return single_value->field_inactivity__detection__time;
}

const Inactivity__Detection__Time_template& Create__URR_grouped__ie_template::inactivity__detection__time() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field inactivity_detection_time of a non-specific template of type @PFCP_Types.Create_URR.grouped_ie.");
return single_value->field_inactivity__detection__time;
}

Linked__URR__ID_template& Create__URR_grouped__ie_template::linked__urr__id()
{
set_specific();
return single_value->field_linked__urr__id;
}

const Linked__URR__ID_template& Create__URR_grouped__ie_template::linked__urr__id() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field linked_urr_id of a non-specific template of type @PFCP_Types.Create_URR.grouped_ie.");
return single_value->field_linked__urr__id;
}

Measurement__Information_template& Create__URR_grouped__ie_template::measurement__information()
{
set_specific();
return single_value->field_measurement__information;
}

const Measurement__Information_template& Create__URR_grouped__ie_template::measurement__information() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field measurement_information of a non-specific template of type @PFCP_Types.Create_URR.grouped_ie.");
return single_value->field_measurement__information;
}

Time__Quota__Mechanism_template& Create__URR_grouped__ie_template::time__qouta__mechanism()
{
set_specific();
return single_value->field_time__qouta__mechanism;
}

const Time__Quota__Mechanism_template& Create__URR_grouped__ie_template::time__qouta__mechanism() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field time_qouta_mechanism of a non-specific template of type @PFCP_Types.Create_URR.grouped_ie.");
return single_value->field_time__qouta__mechanism;
}

Aggregated__URR__list_template& Create__URR_grouped__ie_template::aggregated__urrs()
{
set_specific();
return single_value->field_aggregated__urrs;
}

const Aggregated__URR__list_template& Create__URR_grouped__ie_template::aggregated__urrs() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field aggregated_urrs of a non-specific template of type @PFCP_Types.Create_URR.grouped_ie.");
return single_value->field_aggregated__urrs;
}

int Create__URR_grouped__ie_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_URR.grouped_ie which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 3;
      if (single_value->field_measurement__period.is_present()) ret_val++;
      if (single_value->field_volume__threshold.is_present()) ret_val++;
      if (single_value->field_volume__quota.is_present()) ret_val++;
      if (single_value->field_time__threshold.is_present()) ret_val++;
      if (single_value->field_time__quota.is_present()) ret_val++;
      if (single_value->field_quota__holding__time.is_present()) ret_val++;
      if (single_value->field_dropped__dl__traffic__threshold.is_present()) ret_val++;
      if (single_value->field_monitoring__time.is_present()) ret_val++;
      if (single_value->field_subsequent__volume__threshold.is_present()) ret_val++;
      if (single_value->field_subsequent__time__threshold.is_present()) ret_val++;
      if (single_value->field_subsequent__volume__quota.is_present()) ret_val++;
      if (single_value->field_subsequent__time__quota.is_present()) ret_val++;
      if (single_value->field_inactivity__detection__time.is_present()) ret_val++;
      if (single_value->field_linked__urr__id.is_present()) ret_val++;
      if (single_value->field_measurement__information.is_present()) ret_val++;
      if (single_value->field_time__qouta__mechanism.is_present()) ret_val++;
      if (single_value->field_aggregated__urrs.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @PFCP_Types.Create_URR.grouped_ie containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_URR.grouped_ie containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_URR.grouped_ie containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_URR.grouped_ie containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_URR.grouped_ie containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_URR.grouped_ie containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_URR.grouped_ie containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @PFCP_Types.Create_URR.grouped_ie containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @PFCP_Types.Create_URR.grouped_ie.");
  }
  return 0;
}

void Create__URR_grouped__ie_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ urr_id := ");
single_value->field_urr__id.log();
TTCN_Logger::log_event_str(", measurement_method := ");
single_value->field_measurement__method.log();
TTCN_Logger::log_event_str(", reporting_triggers := ");
single_value->field_reporting__triggers.log();
TTCN_Logger::log_event_str(", measurement_period := ");
single_value->field_measurement__period.log();
TTCN_Logger::log_event_str(", volume_threshold := ");
single_value->field_volume__threshold.log();
TTCN_Logger::log_event_str(", volume_quota := ");
single_value->field_volume__quota.log();
TTCN_Logger::log_event_str(", time_threshold := ");
single_value->field_time__threshold.log();
TTCN_Logger::log_event_str(", time_quota := ");
single_value->field_time__quota.log();
TTCN_Logger::log_event_str(", quota_holding_time := ");
single_value->field_quota__holding__time.log();
TTCN_Logger::log_event_str(", dropped_dl_traffic_threshold := ");
single_value->field_dropped__dl__traffic__threshold.log();
TTCN_Logger::log_event_str(", monitoring_time := ");
single_value->field_monitoring__time.log();
TTCN_Logger::log_event_str(", subsequent_volume_threshold := ");
single_value->field_subsequent__volume__threshold.log();
TTCN_Logger::log_event_str(", subsequent_time_threshold := ");
single_value->field_subsequent__time__threshold.log();
TTCN_Logger::log_event_str(", subsequent_volume_quota := ");
single_value->field_subsequent__volume__quota.log();
TTCN_Logger::log_event_str(", subsequent_time_quota := ");
single_value->field_subsequent__time__quota.log();
TTCN_Logger::log_event_str(", inactivity_detection_time := ");
single_value->field_inactivity__detection__time.log();
TTCN_Logger::log_event_str(", linked_urr_id := ");
single_value->field_linked__urr__id.log();
TTCN_Logger::log_event_str(", measurement_information := ");
single_value->field_measurement__information.log();
TTCN_Logger::log_event_str(", time_qouta_mechanism := ");
single_value->field_time__qouta__mechanism.log();
TTCN_Logger::log_event_str(", aggregated_urrs := ");
single_value->field_aggregated__urrs.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void Create__URR_grouped__ie_template::log_match(const Create__URR_grouped__ie& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_urr__id.match(match_value.urr__id(), legacy)){
TTCN_Logger::log_logmatch_info(".urr_id");
single_value->field_urr__id.log_match(match_value.urr__id(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_measurement__method.match(match_value.measurement__method(), legacy)){
TTCN_Logger::log_logmatch_info(".measurement_method");
single_value->field_measurement__method.log_match(match_value.measurement__method(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_reporting__triggers.match(match_value.reporting__triggers(), legacy)){
TTCN_Logger::log_logmatch_info(".reporting_triggers");
single_value->field_reporting__triggers.log_match(match_value.reporting__triggers(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.measurement__period().ispresent()){
if(!single_value->field_measurement__period.match(match_value.measurement__period(), legacy)){
TTCN_Logger::log_logmatch_info(".measurement_period");
single_value->field_measurement__period.log_match(match_value.measurement__period(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_measurement__period.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".measurement_period := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_measurement__period.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.volume__threshold().ispresent()){
if(!single_value->field_volume__threshold.match(match_value.volume__threshold(), legacy)){
TTCN_Logger::log_logmatch_info(".volume_threshold");
single_value->field_volume__threshold.log_match(match_value.volume__threshold(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_volume__threshold.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".volume_threshold := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_volume__threshold.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.volume__quota().ispresent()){
if(!single_value->field_volume__quota.match(match_value.volume__quota(), legacy)){
TTCN_Logger::log_logmatch_info(".volume_quota");
single_value->field_volume__quota.log_match(match_value.volume__quota(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_volume__quota.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".volume_quota := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_volume__quota.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.time__threshold().ispresent()){
if(!single_value->field_time__threshold.match(match_value.time__threshold(), legacy)){
TTCN_Logger::log_logmatch_info(".time_threshold");
single_value->field_time__threshold.log_match(match_value.time__threshold(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_time__threshold.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".time_threshold := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_time__threshold.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.time__quota().ispresent()){
if(!single_value->field_time__quota.match(match_value.time__quota(), legacy)){
TTCN_Logger::log_logmatch_info(".time_quota");
single_value->field_time__quota.log_match(match_value.time__quota(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_time__quota.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".time_quota := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_time__quota.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.quota__holding__time().ispresent()){
if(!single_value->field_quota__holding__time.match(match_value.quota__holding__time(), legacy)){
TTCN_Logger::log_logmatch_info(".quota_holding_time");
single_value->field_quota__holding__time.log_match(match_value.quota__holding__time(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_quota__holding__time.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".quota_holding_time := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_quota__holding__time.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.dropped__dl__traffic__threshold().ispresent()){
if(!single_value->field_dropped__dl__traffic__threshold.match(match_value.dropped__dl__traffic__threshold(), legacy)){
TTCN_Logger::log_logmatch_info(".dropped_dl_traffic_threshold");
single_value->field_dropped__dl__traffic__threshold.log_match(match_value.dropped__dl__traffic__threshold(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_dropped__dl__traffic__threshold.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".dropped_dl_traffic_threshold := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_dropped__dl__traffic__threshold.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.monitoring__time().ispresent()){
if(!single_value->field_monitoring__time.match(match_value.monitoring__time(), legacy)){
TTCN_Logger::log_logmatch_info(".monitoring_time");
single_value->field_monitoring__time.log_match(match_value.monitoring__time(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_monitoring__time.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".monitoring_time := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_monitoring__time.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.subsequent__volume__threshold().ispresent()){
if(!single_value->field_subsequent__volume__threshold.match(match_value.subsequent__volume__threshold(), legacy)){
TTCN_Logger::log_logmatch_info(".subsequent_volume_threshold");
single_value->field_subsequent__volume__threshold.log_match(match_value.subsequent__volume__threshold(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_subsequent__volume__threshold.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".subsequent_volume_threshold := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_subsequent__volume__threshold.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.subsequent__time__threshold().ispresent()){
if(!single_value->field_subsequent__time__threshold.match(match_value.subsequent__time__threshold(), legacy)){
TTCN_Logger::log_logmatch_info(".subsequent_time_threshold");
single_value->field_subsequent__time__threshold.log_match(match_value.subsequent__time__threshold(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_subsequent__time__threshold.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".subsequent_time_threshold := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_subsequent__time__threshold.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.subsequent__volume__quota().ispresent()){
if(!single_value->field_subsequent__volume__quota.match(match_value.subsequent__volume__quota(), legacy)){
TTCN_Logger::log_logmatch_info(".subsequent_volume_quota");
single_value->field_subsequent__volume__quota.log_match(match_value.subsequent__volume__quota(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_subsequent__volume__quota.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".subsequent_volume_quota := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_subsequent__volume__quota.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.subsequent__time__quota().ispresent()){
if(!single_value->field_subsequent__time__quota.match(match_value.subsequent__time__quota(), legacy)){
TTCN_Logger::log_logmatch_info(".subsequent_time_quota");
single_value->field_subsequent__time__quota.log_match(match_value.subsequent__time__quota(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_subsequent__time__quota.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".subsequent_time_quota := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_subsequent__time__quota.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.inactivity__detection__time().ispresent()){
if(!single_value->field_inactivity__detection__time.match(match_value.inactivity__detection__time(), legacy)){
TTCN_Logger::log_logmatch_info(".inactivity_detection_time");
single_value->field_inactivity__detection__time.log_match(match_value.inactivity__detection__time(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_inactivity__detection__time.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".inactivity_detection_time := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_inactivity__detection__time.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.linked__urr__id().ispresent()){
if(!single_value->field_linked__urr__id.match(match_value.linked__urr__id(), legacy)){
TTCN_Logger::log_logmatch_info(".linked_urr_id");
single_value->field_linked__urr__id.log_match(match_value.linked__urr__id(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_linked__urr__id.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".linked_urr_id := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_linked__urr__id.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.measurement__information().ispresent()){
if(!single_value->field_measurement__information.match(match_value.measurement__information(), legacy)){
TTCN_Logger::log_logmatch_info(".measurement_information");
single_value->field_measurement__information.log_match(match_value.measurement__information(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_measurement__information.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".measurement_information := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_measurement__information.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.time__qouta__mechanism().ispresent()){
if(!single_value->field_time__qouta__mechanism.match(match_value.time__qouta__mechanism(), legacy)){
TTCN_Logger::log_logmatch_info(".time_qouta_mechanism");
single_value->field_time__qouta__mechanism.log_match(match_value.time__qouta__mechanism(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_time__qouta__mechanism.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".time_qouta_mechanism := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_time__qouta__mechanism.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.aggregated__urrs().ispresent()){
if(!single_value->field_aggregated__urrs.match(match_value.aggregated__urrs(), legacy)){
TTCN_Logger::log_logmatch_info(".aggregated_urrs");
single_value->field_aggregated__urrs.log_match(match_value.aggregated__urrs(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_aggregated__urrs.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".aggregated_urrs := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_aggregated__urrs.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ urr_id := ");
single_value->field_urr__id.log_match(match_value.urr__id(), legacy);
TTCN_Logger::log_event_str(", measurement_method := ");
single_value->field_measurement__method.log_match(match_value.measurement__method(), legacy);
TTCN_Logger::log_event_str(", reporting_triggers := ");
single_value->field_reporting__triggers.log_match(match_value.reporting__triggers(), legacy);
TTCN_Logger::log_event_str(", measurement_period := ");
if (match_value.measurement__period().ispresent()) {
single_value->field_measurement__period.log_match(match_value.measurement__period(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_measurement__period.log();
if (single_value->field_measurement__period.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", volume_threshold := ");
if (match_value.volume__threshold().ispresent()) {
single_value->field_volume__threshold.log_match(match_value.volume__threshold(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_volume__threshold.log();
if (single_value->field_volume__threshold.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", volume_quota := ");
if (match_value.volume__quota().ispresent()) {
single_value->field_volume__quota.log_match(match_value.volume__quota(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_volume__quota.log();
if (single_value->field_volume__quota.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", time_threshold := ");
if (match_value.time__threshold().ispresent()) {
single_value->field_time__threshold.log_match(match_value.time__threshold(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_time__threshold.log();
if (single_value->field_time__threshold.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", time_quota := ");
if (match_value.time__quota().ispresent()) {
single_value->field_time__quota.log_match(match_value.time__quota(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_time__quota.log();
if (single_value->field_time__quota.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", quota_holding_time := ");
if (match_value.quota__holding__time().ispresent()) {
single_value->field_quota__holding__time.log_match(match_value.quota__holding__time(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_quota__holding__time.log();
if (single_value->field_quota__holding__time.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", dropped_dl_traffic_threshold := ");
if (match_value.dropped__dl__traffic__threshold().ispresent()) {
single_value->field_dropped__dl__traffic__threshold.log_match(match_value.dropped__dl__traffic__threshold(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_dropped__dl__traffic__threshold.log();
if (single_value->field_dropped__dl__traffic__threshold.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", monitoring_time := ");
if (match_value.monitoring__time().ispresent()) {
single_value->field_monitoring__time.log_match(match_value.monitoring__time(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_monitoring__time.log();
if (single_value->field_monitoring__time.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", subsequent_volume_threshold := ");
if (match_value.subsequent__volume__threshold().ispresent()) {
single_value->field_subsequent__volume__threshold.log_match(match_value.subsequent__volume__threshold(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_subsequent__volume__threshold.log();
if (single_value->field_subsequent__volume__threshold.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", subsequent_time_threshold := ");
if (match_value.subsequent__time__threshold().ispresent()) {
single_value->field_subsequent__time__threshold.log_match(match_value.subsequent__time__threshold(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_subsequent__time__threshold.log();
if (single_value->field_subsequent__time__threshold.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", subsequent_volume_quota := ");
if (match_value.subsequent__volume__quota().ispresent()) {
single_value->field_subsequent__volume__quota.log_match(match_value.subsequent__volume__quota(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_subsequent__volume__quota.log();
if (single_value->field_subsequent__volume__quota.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", subsequent_time_quota := ");
if (match_value.subsequent__time__quota().ispresent()) {
single_value->field_subsequent__time__quota.log_match(match_value.subsequent__time__quota(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_subsequent__time__quota.log();
if (single_value->field_subsequent__time__quota.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", inactivity_detection_time := ");
if (match_value.inactivity__detection__time().ispresent()) {
single_value->field_inactivity__detection__time.log_match(match_value.inactivity__detection__time(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_inactivity__detection__time.log();
if (single_value->field_inactivity__detection__time.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", linked_urr_id := ");
if (match_value.linked__urr__id().ispresent()) {
single_value->field_linked__urr__id.log_match(match_value.linked__urr__id(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_linked__urr__id.log();
if (single_value->field_linked__urr__id.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", measurement_information := ");
if (match_value.measurement__information().ispresent()) {
single_value->field_measurement__information.log_match(match_value.measurement__information(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_measurement__information.log();
if (single_value->field_measurement__information.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", time_qouta_mechanism := ");
if (match_value.time__qouta__mechanism().ispresent()) {
single_value->field_time__qouta__mechanism.log_match(match_value.time__qouta__mechanism(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_time__qouta__mechanism.log();
if (single_value->field_time__qouta__mechanism.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", aggregated_urrs := ");
if (match_value.aggregated__urrs().ispresent()) {
single_value->field_aggregated__urrs.log_match(match_value.aggregated__urrs(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_aggregated__urrs.log();
if (single_value->field_aggregated__urrs.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void Create__URR_grouped__ie_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (urr__id().is_bound()) urr__id().set_implicit_omit();
if (measurement__method().is_bound()) measurement__method().set_implicit_omit();
if (reporting__triggers().is_bound()) reporting__triggers().set_implicit_omit();
if (!measurement__period().is_bound()) measurement__period() = OMIT_VALUE;
else measurement__period().set_implicit_omit();
if (!volume__threshold().is_bound()) volume__threshold() = OMIT_VALUE;
else volume__threshold().set_implicit_omit();
if (!volume__quota().is_bound()) volume__quota() = OMIT_VALUE;
else volume__quota().set_implicit_omit();
if (!time__threshold().is_bound()) time__threshold() = OMIT_VALUE;
else time__threshold().set_implicit_omit();
if (!time__quota().is_bound()) time__quota() = OMIT_VALUE;
else time__quota().set_implicit_omit();
if (!quota__holding__time().is_bound()) quota__holding__time() = OMIT_VALUE;
else quota__holding__time().set_implicit_omit();
if (!dropped__dl__traffic__threshold().is_bound()) dropped__dl__traffic__threshold() = OMIT_VALUE;
else dropped__dl__traffic__threshold().set_implicit_omit();
if (!monitoring__time().is_bound()) monitoring__time() = OMIT_VALUE;
else monitoring__time().set_implicit_omit();
if (!subsequent__volume__threshold().is_bound()) subsequent__volume__threshold() = OMIT_VALUE;
else subsequent__volume__threshold().set_implicit_omit();
if (!subsequent__time__threshold().is_bound()) subsequent__time__threshold() = OMIT_VALUE;
else subsequent__time__threshold().set_implicit_omit();
if (!subsequent__volume__quota().is_bound()) subsequent__volume__quota() = OMIT_VALUE;
else subsequent__volume__quota().set_implicit_omit();
if (!subsequent__time__quota().is_bound()) subsequent__time__quota() = OMIT_VALUE;
else subsequent__time__quota().set_implicit_omit();
if (!inactivity__detection__time().is_bound()) inactivity__detection__time() = OMIT_VALUE;
else inactivity__detection__time().set_implicit_omit();
if (!linked__urr__id().is_bound()) linked__urr__id() = OMIT_VALUE;
else linked__urr__id().set_implicit_omit();
if (!measurement__information().is_bound()) measurement__information() = OMIT_VALUE;
else measurement__information().set_implicit_omit();
if (!time__qouta__mechanism().is_bound()) time__qouta__mechanism() = OMIT_VALUE;
else time__qouta__mechanism().set_implicit_omit();
if (!aggregated__urrs().is_bound()) aggregated__urrs() = OMIT_VALUE;
else aggregated__urrs().set_implicit_omit();
}

void Create__URR_grouped__ie_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_urr__id.encode_text(text_buf);
single_value->field_measurement__method.encode_text(text_buf);
single_value->field_reporting__triggers.encode_text(text_buf);
single_value->field_measurement__period.encode_text(text_buf);
single_value->field_volume__threshold.encode_text(text_buf);
single_value->field_volume__quota.encode_text(text_buf);
single_value->field_time__threshold.encode_text(text_buf);
single_value->field_time__quota.encode_text(text_buf);
single_value->field_quota__holding__time.encode_text(text_buf);
single_value->field_dropped__dl__traffic__threshold.encode_text(text_buf);
single_value->field_monitoring__time.encode_text(text_buf);
single_value->field_subsequent__volume__threshold.encode_text(text_buf);
single_value->field_subsequent__time__threshold.encode_text(text_buf);
single_value->field_subsequent__volume__quota.encode_text(text_buf);
single_value->field_subsequent__time__quota.encode_text(text_buf);
single_value->field_inactivity__detection__time.encode_text(text_buf);
single_value->field_linked__urr__id.encode_text(text_buf);
single_value->field_measurement__information.encode_text(text_buf);
single_value->field_time__qouta__mechanism.encode_text(text_buf);
single_value->field_aggregated__urrs.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @PFCP_Types.Create_URR.grouped_ie.");
}
}

void Create__URR_grouped__ie_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_urr__id.decode_text(text_buf);
single_value->field_measurement__method.decode_text(text_buf);
single_value->field_reporting__triggers.decode_text(text_buf);
single_value->field_measurement__period.decode_text(text_buf);
single_value->field_volume__threshold.decode_text(text_buf);
single_value->field_volume__quota.decode_text(text_buf);
single_value->field_time__threshold.decode_text(text_buf);
single_value->field_time__quota.decode_text(text_buf);
single_value->field_quota__holding__time.decode_text(text_buf);
single_value->field_dropped__dl__traffic__threshold.decode_text(text_buf);
single_value->field_monitoring__time.decode_text(text_buf);
single_value->field_subsequent__volume__threshold.decode_text(text_buf);
single_value->field_subsequent__time__threshold.decode_text(text_buf);
single_value->field_subsequent__volume__quota.decode_text(text_buf);
single_value->field_subsequent__time__quota.decode_text(text_buf);
single_value->field_inactivity__detection__time.decode_text(text_buf);
single_value->field_linked__urr__id.decode_text(text_buf);
single_value->field_measurement__information.decode_text(text_buf);
single_value->field_time__qouta__mechanism.decode_text(text_buf);
single_value->field_aggregated__urrs.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new Create__URR_grouped__ie_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @PFCP_Types.Create_URR.grouped_ie.");
}
}

void Create__URR_grouped__ie_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "set template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    Create__URR_grouped__ie_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (20<param.get_size()) {
      param.error("set template of type @PFCP_Types.Create_URR.grouped_ie has 20 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) urr__id().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) measurement__method().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) reporting__triggers().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) measurement__period().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) volume__threshold().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) volume__quota().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) time__threshold().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) time__quota().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) quota__holding__time().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) dropped__dl__traffic__threshold().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) monitoring__time().set_param(*param.get_elem(10));
    if (param.get_size()>11 && param.get_elem(11)->get_type()!=Module_Param::MP_NotUsed) subsequent__volume__threshold().set_param(*param.get_elem(11));
    if (param.get_size()>12 && param.get_elem(12)->get_type()!=Module_Param::MP_NotUsed) subsequent__time__threshold().set_param(*param.get_elem(12));
    if (param.get_size()>13 && param.get_elem(13)->get_type()!=Module_Param::MP_NotUsed) subsequent__volume__quota().set_param(*param.get_elem(13));
    if (param.get_size()>14 && param.get_elem(14)->get_type()!=Module_Param::MP_NotUsed) subsequent__time__quota().set_param(*param.get_elem(14));
    if (param.get_size()>15 && param.get_elem(15)->get_type()!=Module_Param::MP_NotUsed) inactivity__detection__time().set_param(*param.get_elem(15));
    if (param.get_size()>16 && param.get_elem(16)->get_type()!=Module_Param::MP_NotUsed) linked__urr__id().set_param(*param.get_elem(16));
    if (param.get_size()>17 && param.get_elem(17)->get_type()!=Module_Param::MP_NotUsed) measurement__information().set_param(*param.get_elem(17));
    if (param.get_size()>18 && param.get_elem(18)->get_type()!=Module_Param::MP_NotUsed) time__qouta__mechanism().set_param(*param.get_elem(18));
    if (param.get_size()>19 && param.get_elem(19)->get_type()!=Module_Param::MP_NotUsed) aggregated__urrs().set_param(*param.get_elem(19));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "urr_id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          urr__id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "measurement_method")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          measurement__method().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reporting_triggers")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reporting__triggers().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "measurement_period")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          measurement__period().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "volume_threshold")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          volume__threshold().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "volume_quota")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          volume__quota().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "time_threshold")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          time__threshold().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "time_quota")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          time__quota().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "quota_holding_time")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          quota__holding__time().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dropped_dl_traffic_threshold")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dropped__dl__traffic__threshold().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "monitoring_time")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          monitoring__time().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "subsequent_volume_threshold")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          subsequent__volume__threshold().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "subsequent_time_threshold")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          subsequent__time__threshold().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "subsequent_volume_quota")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          subsequent__volume__quota().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "subsequent_time_quota")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          subsequent__time__quota().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "inactivity_detection_time")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          inactivity__detection__time().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "linked_urr_id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          linked__urr__id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "measurement_information")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          measurement__information().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "time_qouta_mechanism")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          time__qouta__mechanism().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "aggregated_urrs")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          aggregated__urrs().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @PFCP_Types.Create_URR.grouped_ie: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    Create__URR_grouped__ie_template* precondition = new Create__URR_grouped__ie_template;
    precondition->set_param(*param.get_elem(0));
    Create__URR_grouped__ie_template* implied_template = new Create__URR_grouped__ie_template;
    implied_template->set_param(*param.get_elem(1));
    *this = Create__URR_grouped__ie_template(precondition, implied_template);
  } break;
  default:
    param.type_error("set template", "@PFCP_Types.Create_URR.grouped_ie");
  }
  is_ifpresent = param.get_ifpresent();
}

void Create__URR_grouped__ie_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_urr__id.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_URR.grouped_ie");
single_value->field_measurement__method.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_URR.grouped_ie");
single_value->field_reporting__triggers.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_URR.grouped_ie");
single_value->field_measurement__period.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_URR.grouped_ie");
single_value->field_volume__threshold.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_URR.grouped_ie");
single_value->field_volume__quota.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_URR.grouped_ie");
single_value->field_time__threshold.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_URR.grouped_ie");
single_value->field_time__quota.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_URR.grouped_ie");
single_value->field_quota__holding__time.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_URR.grouped_ie");
single_value->field_dropped__dl__traffic__threshold.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_URR.grouped_ie");
single_value->field_monitoring__time.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_URR.grouped_ie");
single_value->field_subsequent__volume__threshold.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_URR.grouped_ie");
single_value->field_subsequent__time__threshold.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_URR.grouped_ie");
single_value->field_subsequent__volume__quota.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_URR.grouped_ie");
single_value->field_subsequent__time__quota.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_URR.grouped_ie");
single_value->field_inactivity__detection__time.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_URR.grouped_ie");
single_value->field_linked__urr__id.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_URR.grouped_ie");
single_value->field_measurement__information.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_URR.grouped_ie");
single_value->field_time__qouta__mechanism.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_URR.grouped_ie");
single_value->field_aggregated__urrs.check_restriction(t_res, t_name ? t_name : "@PFCP_Types.Create_URR.grouped_ie");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@PFCP_Types.Create_URR.grouped_ie");
}

boolean Create__URR_grouped__ie_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean Create__URR_grouped__ie_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const Aggregated__URR Aggregated__URR__list::UNBOUND_ELEM;
Aggregated__URR__list::Aggregated__URR__list()
{
val_ptr = NULL;
}

Aggregated__URR__list::Aggregated__URR__list(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

Aggregated__URR__list::Aggregated__URR__list(const Aggregated__URR__list& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @PFCP_Types.Aggregated_URR_list.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

Aggregated__URR__list::~Aggregated__URR__list()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void Aggregated__URR__list::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

Aggregated__URR__list& Aggregated__URR__list::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

Aggregated__URR__list& Aggregated__URR__list::operator=(const Aggregated__URR__list& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @PFCP_Types.Aggregated_URR_list.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean Aggregated__URR__list::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @PFCP_Types.Aggregated_URR_list.");
return val_ptr->n_elements == 0 ;
}

boolean Aggregated__URR__list::operator==(const Aggregated__URR__list& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @PFCP_Types.Aggregated_URR_list.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @PFCP_Types.Aggregated_URR_list.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

Aggregated__URR& Aggregated__URR__list::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @PFCP_Types.Aggregated_URR_list using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (Aggregated__URR**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new Aggregated__URR(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new Aggregated__URR;
}
return *val_ptr->value_elements[index_value];
}

Aggregated__URR& Aggregated__URR__list::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @PFCP_Types.Aggregated_URR_list.");
return (*this)[(int)index_value];
}

const Aggregated__URR& Aggregated__URR__list::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @PFCP_Types.Aggregated_URR_list.");
if (index_value < 0) TTCN_error("Accessing an element of type @PFCP_Types.Aggregated_URR_list using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @PFCP_Types.Aggregated_URR_list: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const Aggregated__URR& Aggregated__URR__list::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @PFCP_Types.Aggregated_URR_list.");
return (*this)[(int)index_value];
}

Aggregated__URR__list Aggregated__URR__list::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

Aggregated__URR__list Aggregated__URR__list::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

Aggregated__URR__list Aggregated__URR__list::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

Aggregated__URR__list Aggregated__URR__list::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @PFCP_Types.Aggregated_URR_list.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
Aggregated__URR__list ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new Aggregated__URR(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

Aggregated__URR__list Aggregated__URR__list::operator+(const Aggregated__URR__list& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @PFCP_Types.Aggregated_URR_list concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
Aggregated__URR__list ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new Aggregated__URR(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new Aggregated__URR(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

Aggregated__URR__list Aggregated__URR__list::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @PFCP_Types.Aggregated_URR_list.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@PFCP_Types.Aggregated_URR_list","element");
Aggregated__URR__list ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new Aggregated__URR(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

Aggregated__URR__list Aggregated__URR__list::replace(int index, int len, const Aggregated__URR__list& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @PFCP_Types.Aggregated_URR_list.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @PFCP_Types.Aggregated_URR_list.");
check_replace_arguments(val_ptr->n_elements, index, len, "@PFCP_Types.Aggregated_URR_list","element");
Aggregated__URR__list ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new Aggregated__URR(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new Aggregated__URR(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new Aggregated__URR(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

Aggregated__URR__list Aggregated__URR__list::replace(int index, int len, const Aggregated__URR__list_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void Aggregated__URR__list::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @PFCP_Types.Aggregated_URR_list.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (Aggregated__URR**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new Aggregated__URR(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (Aggregated__URR**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @PFCP_Types.Aggregated_URR_list: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (Aggregated__URR**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean Aggregated__URR__list::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int Aggregated__URR__list::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @PFCP_Types.Aggregated_URR_list.");
return val_ptr->n_elements;
}

int Aggregated__URR__list::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @PFCP_Types.Aggregated_URR_list.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void Aggregated__URR__list::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void Aggregated__URR__list::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void Aggregated__URR__list::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@PFCP_Types.Aggregated_URR_list");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@PFCP_Types.Aggregated_URR_list");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void Aggregated__URR__list::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @PFCP_Types.Aggregated_URR_list.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void Aggregated__URR__list::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @PFCP_Types.Aggregated_URR_list.");
val_ptr->value_elements = (Aggregated__URR**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new Aggregated__URR;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void Aggregated__URR__list::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Aggregated__URR__list::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int Aggregated__URR__list::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean /*no_err*/, int sel_field, boolean first_call, const RAW_Force_Omit*){
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int decoded_field_length=0;
  size_t start_of_field=0;
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int start_field=val_ptr->n_elements;
  if(p_td.raw->fieldlength || sel_field!=-1){
    int a=0;
    if(sel_field==-1) sel_field=p_td.raw->fieldlength;
    start_of_field=p_buf.get_pos_bit();
    for(a=0;a<sel_field;a++){
      decoded_field_length=(*this)[a+start_field].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        while(a>=0){
          delete &(*this)[a+start_field];
          a--;
          val_ptr->n_elements--;
        }
        p_buf.set_pos_bit(start_of_field);
        return decoded_field_length;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
    }
    if(a==0) val_ptr->n_elements=0;
  } else {
    if(limit==0){
      if(!first_call) return -1;
      val_ptr->n_elements=0;
      return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
    }
    int a=start_field;
    while(limit>0){
      start_of_field=p_buf.get_pos_bit();
      decoded_field_length=(*this)[a].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        delete &(*this)[a];
        val_ptr->n_elements--;
        p_buf.set_pos_bit(start_of_field);
        if(a>start_field){
        return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
        } else return -1;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
      a++;
    }
  }
 return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
}

int Aggregated__URR__list::RAW_encode(const TTCN_Typedescriptor_t& p_td,RAW_enc_tree& myleaf) const{
  int encoded_length=0;
  int encoded_num_of_records=p_td.raw->fieldlength?smaller(val_ptr->n_elements, p_td.raw->fieldlength):val_ptr->n_elements;
  myleaf.isleaf=FALSE;
  myleaf.rec_of=TRUE;
  myleaf.body.node.num_of_nodes=encoded_num_of_records;
  myleaf.body.node.nodes=init_nodes_of_enc_tree(encoded_num_of_records);
  for(int a=0;a<encoded_num_of_records;a++){
    myleaf.body.node.nodes[a]=new RAW_enc_tree(TRUE,&myleaf,&(myleaf.curr_pos),a,p_td.oftype_descr->raw);
    encoded_length+=(*this)[a].RAW_encode(*p_td.oftype_descr,*myleaf.body.node.nodes[a]);
  }
 return myleaf.length=encoded_length;
}

void Aggregated__URR__list_template::copy_value(const Aggregated__URR__list& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @PFCP_Types.Aggregated_URR_list with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (Aggregated__URR_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new Aggregated__URR_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new Aggregated__URR_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void Aggregated__URR__list_template::copy_template(const Aggregated__URR__list_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (Aggregated__URR_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new Aggregated__URR_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new Aggregated__URR_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Aggregated__URR__list_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Aggregated__URR__list_template(*other_value.implication_.precondition);
implication_.implied_template = new Aggregated__URR__list_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @PFCP_Types.Aggregated_URR_list.");
break;
}
set_selection(other_value);
}

boolean Aggregated__URR__list_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boole