/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier.exportfile;

import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfConstant_ClassRef;
import com.sun.javacard.offcardverifier.exportfile.EfElement;
import com.sun.javacard.offcardverifier.exportfile.EfField;
import com.sun.javacard.offcardverifier.exportfile.EfMethod;
import com.sun.javacard.offcardverifier.exportfile.EfNames;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Vector;

public class EfClass
extends EfElement {
    public short token;
    public int accessFlag;
    int nameIndex;
    public int[] supers;
    public int[] interfaces;
    public EfField[] fields;
    public EfMethod[] methods;
    private Vector<EfMethod> newMethodList;
    private Vector<EfField> newFields;
    private boolean sameVersion;
    private boolean refExists;
    private boolean isInterface;
    private static final int validFlags = 7697;
    private static final int abstractFinalFlags = 1040;
    private static final int shareableInterfaceFlags = 2560;

    EfClass(ExportFile ef) {
        super(ef);
    }

    public String thisName() {
        return ((EfConstant_ClassRef)this.ef.constantPool[this.nameIndex]).classname();
    }

    public String superName(int i) {
        return ((EfConstant_ClassRef)this.ef.constantPool[this.supers[i]]).classname();
    }

    public String interfaceName(int i) {
        return ((EfConstant_ClassRef)this.ef.constantPool[this.interfaces[i]]).classname();
    }

    void read() throws IOException {
        this.token = (short)this.ef.in.readUnsignedByte();
        this.accessFlag = this.ef.in.readUnsignedShort();
        this.nameIndex = this.ef.in.readUnsignedShort();
        this.ef.checkClassrefIndex(this.nameIndex);
        int exportSupersCount = this.ef.in.readUnsignedShort();
        this.supers = new int[exportSupersCount];
        for (int i = 0; i < exportSupersCount; ++i) {
            this.supers[i] = this.ef.in.readUnsignedShort();
            this.ef.checkClassrefIndex(this.supers[i]);
        }
        int exportInterfaceCount = this.ef.in.readUnsignedByte();
        this.interfaces = new int[exportInterfaceCount];
        for (int i = 0; i < exportInterfaceCount; ++i) {
            this.interfaces[i] = this.ef.in.readUnsignedShort();
            this.ef.checkClassrefIndex(this.interfaces[i]);
        }
        int exportFieldCount = this.ef.in.readUnsignedShort();
        this.fields = new EfField[exportFieldCount];
        for (int i = 0; i < exportFieldCount; ++i) {
            EfField fi = new EfField(this.ef, this.thisName());
            fi.read();
            this.fields[i] = fi;
        }
        int exportMethodsCount = this.ef.in.readUnsignedShort();
        this.methods = new EfMethod[exportMethodsCount];
        for (int i = 0; i < exportMethodsCount; ++i) {
            EfMethod mi = new EfMethod(this.ef, this.thisName());
            mi.read();
            this.methods[i] = mi;
        }
    }

    void verify(HashSet<String> classNames, BitSet classTokens) {
        String name = this.thisName();
        if (!EfNames.validClassName(name)) {
            throw new VerifierError("EfClass.20", name);
        }
        try {
            String pkgname;
            int lastslash = name.lastIndexOf(47);
            String string = pkgname = lastslash == -1 ? "" : name.substring(0, lastslash);
            if (!pkgname.equals(this.ef.thisName())) {
                throw new VerifierError("EfClass.6", EfNames.prettyClass(this.ef.thisName()));
            }
            if (this.supers.length == 0 && !name.equals("java/lang/Object")) {
                throw new VerifierError("EfClass.22");
            }
            if ((this.accessFlag & 0xFFFFE1EE) != 0) {
                throw new VerifierError("EfClass.1", this.accessFlag);
            }
            if (this.ef.minorVersion != 2 && (this.accessFlag & 0x1000) != 0) {
                throw new VerifierError("EfClass.1", this.accessFlag);
            }
            if ((this.accessFlag & 1) == 0) {
                throw new VerifierError("EfClass.2");
            }
            if ((this.accessFlag & 0x200) != 0) {
                if ((this.accessFlag & 0x400) == 0) {
                    throw new VerifierError("EfClass.3");
                }
                if ((this.accessFlag & 0x10) != 0) {
                    throw new VerifierError("EfClass.4");
                }
            }
            if ((this.accessFlag & 0x410) == 1040) {
                throw new VerifierError("EfClass.5");
            }
            boolean claimsToBeRemote = (this.accessFlag & 0x1000) != 0;
            boolean isActuallyRemote = this.thisName().equals("java/rmi/Remote");
            for (int i = 0; i < this.interfaces.length; ++i) {
                if (!this.interfaceName(i).equals("java/rmi/Remote")) continue;
                isActuallyRemote = true;
            }
            if (claimsToBeRemote != isActuallyRemote) {
                throw new VerifierError("EfClass.23", this.thisName());
            }
            boolean claimsToBeShareable = (this.accessFlag & 0x800) != 0;
            boolean isActuallyShareable = this.thisName().equals("javacard/framework/Shareable");
            for (int i = 0; i < this.interfaces.length; ++i) {
                if (!this.interfaceName(i).equals("javacard/framework/Shareable")) continue;
                isActuallyShareable = true;
            }
            if (isActuallyShareable != claimsToBeShareable) {
                throw new VerifierError("EfClass.7");
            }
            if ((this.ef.thisPackage().flags & 1) == 0 && (this.accessFlag & 0xA00) != 2560) {
                throw new VerifierError("EfClass.8");
            }
            if (!classNames.add(this.thisName())) {
                throw new VerifierError("EfClass.15");
            }
            if (classTokens.get(this.token)) {
                throw new VerifierError("EfClass.16", this.token);
            }
            classTokens.set(this.token);
            HashSet<String> superNames = new HashSet<String>();
            for (int i = 0; i < this.supers.length; ++i) {
                if (superNames.add(this.superName(i))) continue;
                throw new VerifierError("EfClass.17", EfNames.prettyClass(this.superName(i)));
            }
            if ((this.ef.thisPackage().flags & 1) != 0 && superNames.contains("javacard/framework/Applet") && (this.accessFlag & 0x400) == 0) {
                throw new VerifierError("EfClass.21", EfNames.prettyClass(this.ef.thisName()));
            }
            HashSet<String> interfaceNames = new HashSet<String>();
            for (int i = 0; i < this.interfaces.length; ++i) {
                if (interfaceNames.add(this.interfaceName(i))) continue;
                throw new VerifierError("EfClass.18", EfNames.prettyClass(this.interfaceName(i)));
            }
            boolean isInterface = (this.accessFlag & 0x200) != 0;
            HashSet<EfField> fieldNames = new HashSet<EfField>();
            BitSet staticFieldTokens = new BitSet();
            BitSet instanceFieldTokens = new BitSet();
            for (EfField element : this.fields) {
                element.verify(isInterface, fieldNames, staticFieldTokens, instanceFieldTokens);
            }
            HashSet<EfMethod> methodNames = new HashSet<EfMethod>();
            BitSet staticMethodTokens = new BitSet();
            BitSet virtualMethodTokens = new BitSet();
            int numStatMethods = 0;
            int numVirtMethods = 0;
            for (EfMethod element : this.methods) {
                if (element.isStaticOrInit()) {
                    ++numStatMethods;
                } else {
                    ++numVirtMethods;
                }
                element.verify(isInterface, methodNames, staticMethodTokens, virtualMethodTokens);
            }
            if (staticMethodTokens.length() != numStatMethods) {
                throw new VerifierError("EfMethod.15");
            }
            if (virtualMethodTokens.length() != numVirtMethods) {
                throw new VerifierError("EfMethod.15");
            }
        }
        catch (VerifierError e) {
            throw new VerifierError("EfClass.19", (Object)EfNames.prettyClass(this.thisName()), (Object)e.getMessage());
        }
    }

    public int declaredInstanceSize() {
        int size = 0;
        for (EfField f : this.fields) {
            int s;
            if (f.isStatic() || (s = f.token + f.wordSize()) <= size) continue;
            size = s;
        }
        return size;
    }

    public String toString() {
        return EfNames.prettyClass(this.thisName());
    }

    void compareTo(EfClass ec) {
        this.sameVersion = false;
        int ic1 = this.accessFlag & 0x200;
        if (ic1 == 0) {
            this.isInterface = false;
            if ((this.accessFlag & 0x10) < (ec.accessFlag & 0x10)) {
                throw new VerifierError("RevisionError.4", this.thisName());
            }
        } else {
            this.isInterface = true;
        }
        if ((this.accessFlag & 0x400) < (ec.accessFlag & 0x400)) {
            if (this.isInterface) {
                VerifierError.warning("RevisionWarning.2", this.thisName());
            } else {
                throw new VerifierError("RevisionError.5", this.thisName());
            }
        }
        if ((this.accessFlag & 0x1000) > (ec.accessFlag & 0x1000)) {
            throw new VerifierError("RevisionError.41", this.thisName());
        }
        if ((this.accessFlag & 0x800) > (ec.accessFlag & 0x800)) {
            throw new VerifierError("RevisionError.6", this.thisName());
        }
        this.compareCommon(ec);
        this.checkNewMethods(ec);
        this.checkNewFields(ec);
    }

    void checkEquality(EfClass ec) {
        this.sameVersion = true;
        int ic1 = this.accessFlag & 0x200;
        if (ic1 == 0 && (this.accessFlag & 0x10) != (ec.accessFlag & 0x10)) {
            throw new VerifierError("RevisionError.7", this.thisName());
        }
        if ((this.accessFlag & 0x400) != (ec.accessFlag & 0x400)) {
            throw new VerifierError("RevisionError.7", this.thisName());
        }
        if ((this.accessFlag & 0x800) != (ec.accessFlag & 0x800)) {
            throw new VerifierError("RevisionError.7", this.thisName());
        }
        this.compareCommon(ec);
    }

    void compareCommon(EfClass ec) {
        if (this.token != ec.token) {
            throw new VerifierError("RevisionError.8", this.thisName());
        }
        int ic1 = this.accessFlag & 0x200;
        int ic2 = ec.accessFlag & 0x200;
        if (ic1 != ic2) {
            throw new VerifierError("RevisionError.9", this.thisName());
        }
        if (ic1 == 0) {
            this.compareSuperClasses(ec);
        }
        this.compareInterfaces(ec);
        this.compareMethodLists(ec);
        this.compareFieldLists(ec);
    }

    private void compareSuperClasses(EfClass c2) {
        boolean found = false;
        int newSize = 0;
        int oldSize = 0;
        oldSize = this.supers.length;
        newSize = c2.supers.length;
        if (this.sameVersion && oldSize != newSize) {
            throw new VerifierError("RevisionError.10", this.thisName());
        }
        for (int i = 0; i < oldSize; ++i) {
            found = false;
            String fromOld = this.superName(i);
            for (int j = 0; j < newSize; ++j) {
                String fromNew = c2.superName(j);
                if (!fromOld.equals(fromNew)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new VerifierError("RevisionError.12", (Object)fromOld, (Object)this.thisName());
        }
    }

    private void compareInterfaces(EfClass c2) {
        boolean found = false;
        int newSize = 0;
        int oldSize = 0;
        oldSize = this.interfaces.length;
        newSize = c2.interfaces.length;
        if (this.sameVersion && oldSize != newSize) {
            throw new VerifierError("RevisionError.13", this.thisName());
        }
        for (int i = 0; i < oldSize; ++i) {
            found = false;
            String fromOld = this.interfaceName(i);
            for (int j = 0; j < newSize; ++j) {
                String fromNew = c2.interfaceName(j);
                if (!fromOld.equals(fromNew)) continue;
                found = true;
                break;
            }
            if (found) continue;
            if (this.isInterface) {
                throw new VerifierError("RevisionError.14", (Object)fromOld, (Object)this.thisName());
            }
            throw new VerifierError("RevisionError.15", (Object)fromOld, (Object)this.thisName());
        }
    }

    private void compareMethodLists(EfClass c2) {
        boolean found = false;
        EfMethod m1 = null;
        EfMethod m2 = null;
        this.newMethodList = new Vector(c2.methods.length);
        for (EfMethod element : c2.methods) {
            this.newMethodList.addElement(element);
        }
        int oldSize = this.methods.length;
        int newSize = this.newMethodList.size();
        if (this.sameVersion && oldSize != newSize) {
            throw new VerifierError("RevisionError.16", this.thisName());
        }
        for (int i = 0; i < oldSize; ++i) {
            found = false;
            m1 = this.methods[i];
            String methodName1 = m1.name();
            String des1 = m1.sig();
            for (int j = 0; j < this.newMethodList.size(); ++j) {
                m2 = this.newMethodList.get(j);
                String methodName2 = m2.name();
                String des2 = m2.sig();
                if (!methodName1.equals(methodName2) || !des1.equals(des2)) continue;
                found = true;
                this.newMethodList.removeElementAt(j);
                break;
            }
            if (found) {
                if (this.sameVersion) {
                    m1.checkEquality(m2);
                    continue;
                }
                boolean oldFinalNewNotFinal = (this.accessFlag & 0x10) > (c2.accessFlag & 0x10);
                m1.compareTo(m2, oldFinalNewNotFinal);
                continue;
            }
            throw new VerifierError("RevisionError.18", (Object)methodName1, (Object)this.thisName());
        }
    }

    private void checkNewMethods(EfClass c2) {
        if (this.newMethodList.size() > 0) {
            if (this.isInterface) {
                EfMethod m2 = this.newMethodList.get(0);
                throw new VerifierError("RevisionError.42", (Object)m2.name(), (Object)this.thisName());
            }
            if ((this.accessFlag & 0x10) > 0 || (c2.accessFlag & 0x10) > 0) {
                return;
            }
            int newSize = this.newMethodList.size();
            for (int i = 0; i < newSize; ++i) {
                EfMethod m2 = this.newMethodList.get(i);
                if ((m2.accessFlag & 8) != 0) continue;
                throw new VerifierError("RevisionError.19", (Object)m2.name(), (Object)this.thisName());
            }
        }
    }

    boolean compareFieldLists(EfClass c2) {
        boolean found = false;
        EfField f1 = null;
        EfField f2 = null;
        this.refExists = false;
        this.newFields = new Vector(c2.fields.length);
        for (EfField element : c2.fields) {
            this.newFields.addElement(element);
        }
        int oldSize = this.fields.length;
        int newSize = this.newFields.size();
        if (this.sameVersion) {
            if (oldSize != newSize) {
                throw new VerifierError("RevisionError.20", this.thisName());
            }
        } else if (oldSize == 0) {
            return true;
        }
        for (int i = 0; i < oldSize; ++i) {
            String descriptor;
            found = false;
            f1 = this.fields[i];
            String fieldName1 = f1.name();
            if (!this.refExists && (descriptor = f1.sig()).indexOf("L") >= 0) {
                this.refExists = true;
            }
            for (int j = 0; j < this.newFields.size(); ++j) {
                f2 = this.newFields.get(j);
                String fieldName2 = f2.name();
                if (!fieldName1.equals(fieldName2)) continue;
                found = true;
                this.newFields.removeElementAt(j);
                break;
            }
            if (found) {
                if (this.sameVersion) {
                    f1.checkEquality(f2);
                    continue;
                }
                f1.compareTo(f2);
                continue;
            }
            throw new VerifierError("RevisionError.21", (Object)fieldName1, (Object)this.thisName());
        }
        return true;
    }

    void checkNewFields(EfClass c2) {
        if (this.newFields.size() > 0 && this.refExists) {
            for (int i = 0; i < this.newFields.size(); ++i) {
                EfField f2 = this.newFields.get(i);
                String descriptor = f2.sig();
                if (descriptor.indexOf("L") >= 0 || (f2.accessFlag & 8) > 0) continue;
                throw new VerifierError("RevisionError.22", (Object)f2.name(), (Object)this.thisName());
            }
        }
    }

    public EfField getFieldForName(String fieldName) {
        for (EfField element : this.fields) {
            if (!element.name().equals(fieldName)) continue;
            return element;
        }
        return null;
    }

    public EfField getFieldForTokenAndFlag(int tokenValue, boolean isStatic) {
        for (EfField element : this.fields) {
            if (element.token != tokenValue || isStatic != element.isStatic()) continue;
            return element;
        }
        return null;
    }

    public String getConstantFieldNameByValueAndDesc(int value, String desc) {
        for (EfField aField : this.fields) {
            if (aField.token != 255 || !aField.sig().equals(desc) || aField.constantvalue().value() != value) continue;
            int lastSlash = this.thisName().lastIndexOf("/");
            return this.thisName().substring(lastSlash + 1) + "." + aField.name();
        }
        return null;
    }

    public EfMethod getMethodForTokenAndFlag(int tokenValue, boolean isStaticOrInit) {
        for (int i = 0; i < this.methods.length; ++i) {
            if (this.methods[i].token != tokenValue || isStaticOrInit != this.methods[i].isStaticOrInit()) continue;
            return this.methods[i];
        }
        return null;
    }

    public EfMethod getMethodForNameAndSig(String methodName, String mDesc) {
        for (EfMethod element : this.methods) {
            if (!element.name().equals(methodName) || !element.sig().equals(mDesc)) continue;
            return element;
        }
        return null;
    }

    public EfMethod getMethodFromSupers(int tokenValue, boolean isStaticOrInit) {
        for (int i = 0; i < this.supers.length; ++i) {
            EfMethod em;
            int classRef = Classref.refForName(((EfConstant_ClassRef)this.ef.constantPool[this.supers[i]]).classname());
            EfClass exportedClass = Classref.toExportClass(classRef);
            if (exportedClass == null || (em = exportedClass.getMethodForTokenAndFlag(this.token, false)) == null) continue;
            return em;
        }
        return null;
    }

    public int getPublicVirtualMethodCount() {
        int count = 0;
        for (EfMethod method : this.methods) {
            if (method.isStaticOrInit() || (method.accessFlag & 1) != 1 && (method.accessFlag & 4) != 4) continue;
            ++count;
        }
        return count;
    }
}

