/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.exportfile;

import com.sun.javacard.basicstructure.ClassDefinition;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.exportfile.EfConstantPool;
import com.sun.javacard.exportfile.EfField;
import com.sun.javacard.exportfile.EfMethod;
import com.sun.javacard.exportfile.ExportFileManager;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;

public class EfClass
extends ClassDefinition {
    public static final short ACC_SHAREABLE = 2048;
    public static final short ACC_REMOTE = 4096;
    private int name_index;
    private int[] super_class_indexes;
    private String[] super_class_names;
    private int[] interface_indexes;
    private String[] interface_names;
    private EfField[] fields;
    private EfMethod[] methods;
    private EfConstantPool constant_pool;

    public EfClass(EfConstantPool cp) {
        this.constant_pool = cp;
    }

    public EfClass(ClassDefinition a_class, boolean shareable_flag, String[] super_class_names, String[] interface_names, EfConstantPool constant_pool, EfField[] fields, EfMethod[] methods) {
        super(a_class);
        int i;
        this.access_flags &= 0xFFFFFFDF;
        if (shareable_flag) {
            this.access_flags |= 0x800;
        }
        if (a_class.isRemote()) {
            this.access_flags |= 0x1000;
        }
        if (Modifier.isInterface(this.access_flags)) {
            this.access_flags |= 0x400;
        }
        this.constant_pool = constant_pool;
        this.name_index = constant_pool.addConstantClassRef(this.class_name);
        this.super_class_names = super_class_names;
        this.super_class_indexes = new int[super_class_names.length];
        for (i = 0; i < super_class_names.length; ++i) {
            this.super_class_indexes[i] = constant_pool.addConstantClassRef(super_class_names[i]);
        }
        this.interface_names = interface_names;
        this.interface_indexes = new int[interface_names.length];
        for (i = 0; i < interface_names.length; ++i) {
            this.interface_indexes[i] = constant_pool.addConstantClassRef(interface_names[i]);
        }
        this.fields = fields;
        this.methods = methods;
    }

    public boolean isShareableType() {
        return (this.access_flags & 0x800) != 0;
    }

    public void parse(DataInputStream dis) throws IOException {
        int i;
        this.token = dis.readUnsignedByte();
        this.access_flags = dis.readShort();
        this.name_index = dis.readUnsignedShort();
        this.super_class_indexes = new int[dis.readUnsignedShort()];
        for (i = 0; i < this.super_class_indexes.length; ++i) {
            this.super_class_indexes[i] = dis.readUnsignedShort();
        }
        this.interface_indexes = new int[dis.readUnsignedByte()];
        for (i = 0; i < this.interface_indexes.length; ++i) {
            this.interface_indexes[i] = dis.readUnsignedShort();
        }
        this.fields = new EfField[dis.readUnsignedShort()];
        for (i = 0; i < this.fields.length; ++i) {
            this.fields[i] = new EfField(this.constant_pool);
            this.fields[i].parse(dis);
        }
        this.methods = new EfMethod[dis.readUnsignedShort()];
        for (i = 0; i < this.methods.length; ++i) {
            this.methods[i] = new EfMethod(this.constant_pool);
            this.methods[i].parse(dis);
        }
    }

    public void resolve() {
        int i;
        this.class_name = this.constant_pool.getConstantClassRef(this.name_index).getClassName();
        this.super_class_names = new String[this.super_class_indexes.length];
        for (i = 0; i < this.super_class_indexes.length; ++i) {
            this.super_class_names[i] = this.constant_pool.getConstantClassRef(this.super_class_indexes[i]).getClassName();
        }
        this.interface_names = new String[this.interface_indexes.length];
        for (i = 0; i < this.interface_indexes.length; ++i) {
            this.interface_names[i] = this.constant_pool.getConstantClassRef(this.interface_indexes[i]).getClassName();
        }
        for (EfField efField : this.fields) {
            efField.resolve();
        }
        for (EfMethod efMethod : this.methods) {
            efMethod.resolve();
        }
        if (this.isInterfaceType() && !this.isAbstract()) {
            Object[] args = new Object[]{this.getClassName().replace('/', '.')};
            Notifier.warning("flags.1", args);
            this.setAbstract(true);
        }
    }

    public void toText(PrintWriter pw, int tab_level) throws IOException {
        int i;
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < tab_level; ++i2) {
            sb.append("\t");
        }
        String indent = sb.toString();
        pw.println(indent + "class_info {" + "\t\t// " + this.class_name);
        pw.println(indent + "\ttoken\t" + this.token);
        boolean shareable = (this.access_flags & 0x800) != 0;
        boolean remote = (this.access_flags & 0x1000) != 0;
        int tmp_access_flags = this.access_flags & 0xFFFFF7FF & 0xFFFFEFFF;
        pw.print(indent + "\taccess_flags\t" + Modifier.toString(tmp_access_flags));
        if (shareable) {
            pw.print(" shareable");
        }
        if (remote) {
            pw.println(" remote");
        } else {
            pw.println();
        }
        pw.println(indent + "\tname_index\t" + this.name_index + "\t\t// " + this.class_name);
        pw.println(indent + "\texport_supers_count\t" + this.super_class_indexes.length);
        pw.println(indent + "\tsupers {");
        for (i = 0; i < this.super_class_indexes.length; ++i) {
            pw.println(indent + "\t\tconstant_pool_index\t" + this.super_class_indexes[i] + "\t\t// " + this.super_class_names[i]);
        }
        pw.println(indent + "\t}");
        pw.println(indent + "\texport_interfaces_count\t" + this.interface_indexes.length);
        pw.println(indent + "\tinterfaces {");
        for (i = 0; i < this.interface_indexes.length; ++i) {
            pw.println(indent + "\t\tconstant_pool_index\t" + this.interface_indexes[i] + "\t\t// " + this.interface_names[i]);
        }
        pw.println(indent + "\t}");
        pw.println(indent + "\texport_fields_count\t" + this.fields.length);
        pw.println(indent + "\tfields {");
        for (EfField efField : this.fields) {
            efField.toText(pw, tab_level + 1);
        }
        pw.println(indent + "\t}");
        pw.println(indent + "\texport_methods_count\t" + this.methods.length);
        pw.println(indent + "\tmethods {");
        for (EfMethod efMethod : this.methods) {
            efMethod.toText(pw, tab_level + 2);
        }
        pw.println(indent + "\t}");
        pw.println(indent + "}");
    }

    public void toBinary(DataOutputStream dos) throws IOException {
        dos.writeByte(this.token);
        dos.writeShort(this.access_flags);
        dos.writeShort(this.name_index);
        dos.writeShort(this.super_class_indexes.length);
        for (int element : this.super_class_indexes) {
            dos.writeShort(element);
        }
        dos.writeByte(this.interface_indexes.length);
        for (int element : this.interface_indexes) {
            dos.writeShort(element);
        }
        dos.writeShort(this.fields.length);
        for (EfField element : this.fields) {
            element.toBinary(dos);
        }
        dos.writeShort(this.methods.length);
        for (EfMethod element : this.methods) {
            element.toBinary(dos);
        }
        dos.flush();
    }

    public int getNameIndex() {
        return this.name_index;
    }

    public int[] getSuperClasses() {
        return this.super_class_indexes;
    }

    public String[] getSuperClassNames() {
        return this.super_class_names;
    }

    public int[] getInterfaces() {
        return this.interface_indexes;
    }

    public String[] getInterfaceNames() {
        return this.interface_names;
    }

    public EfMethod getMethod(String name, String descriptor) {
        for (EfMethod element : this.methods) {
            if (!element.getMethodName().equals(name) || !element.getMethodDescriptor().equals(descriptor)) continue;
            return element;
        }
        return null;
    }

    public EfMethod getMethod(int token) {
        for (EfMethod element : this.methods) {
            if (element.getMethodToken() != token) continue;
            return element;
        }
        return null;
    }

    public EfMethod[] getMethods() {
        return this.methods;
    }

    public EfField getField(String name, String descriptor) {
        for (EfField element : this.fields) {
            if (!element.getFieldName().equals(name) || !element.getFieldDescriptor().equals(descriptor)) continue;
            return element;
        }
        return null;
    }

    public EfField[] getFields() {
        return this.fields;
    }

    public boolean hasReferenceAPIField() {
        if (this.getFields().length == 0) {
            return false;
        }
        for (int i = 0; i < this.getFields().length; ++i) {
            EfField efField = this.getFields()[i];
            if (!efField.isReferenceType()) continue;
            return true;
        }
        return false;
    }

    public void printFields() {
        System.out.println("\n Fields of " + this.getClassName() + " (in exp file)");
        for (int i = 0; i < this.fields.length; ++i) {
            EfField f = this.fields[i];
            String s = "" + i + " " + f.getFieldToken() + " " + (f.isPublic() ? "public" : "") + " " + (f.isProtected() ? "protected" : "") + " " + (f.isStatic() ? "static" : "") + " " + (f.isFinal() ? "final" : "") + " " + f.getFieldDescriptor() + " " + f.getFieldName();
            System.out.println(s);
        }
    }

    public void printMethods() {
        System.out.println("\n Methods of " + this.getClassName() + " (in exp file)");
        for (int i = 0; i < this.methods.length; ++i) {
            EfMethod f = this.methods[i];
            String s = "" + i + " " + f.getMethodToken() + " " + (f.isPublic() ? "public" : "") + " " + (f.isProtected() ? "protected" : "") + " " + (f.isStatic() ? "static" : "") + " " + (f.isFinal() ? "final" : "") + " " + (f.isAbstract() ? "abstract" : "") + " " + f.getMethodDescriptor() + " " + f.getMethodName();
            System.out.println(s);
        }
    }

    @Override
    public boolean isRemote() {
        return (this.access_flags & 0x1000) != 0;
    }

    public String getSuperClassName(ExportFileManager efm) throws Exception {
        String super_class_name = super.getSuperClassName();
        if (super_class_name != null) {
            return super_class_name;
        }
        if (this.super_class_names.length == 1) {
            super.setSuperClassName(this.super_class_names[0]);
            return this.super_class_names[0];
        }
        int[] nSupers = new int[this.super_class_names.length];
        int found = -1;
        int maxSupers = -1;
        for (int i = 0; i < nSupers.length; ++i) {
            int n = efm.getClass(this.super_class_names[i]).getSuperClasses().length;
            if (n <= maxSupers) continue;
            n = maxSupers;
            found = i;
        }
        if (found >= 0) {
            super.setSuperClassName(this.super_class_names[found]);
            return this.super_class_names[found];
        }
        return null;
    }
}

