/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.validator;

import com.sun.javacard.util.StringUtils;
import com.sun.javacard.validator.ErrorKey;
import com.sun.javacard.validator.Module;
import com.sun.javacard.validator.ModuleJCRD;
import com.sun.javacard.validator.ValidValues;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.Manifest;

public class ClassicModuleJCRD
extends ModuleJCRD {
    private String classicPackageAID;
    private String RID;

    public ClassicModuleJCRD(Module module, File file) {
        super(module, file);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.classicPackageAID = this.getAttributeValue("Classic-Package-AID");
        if (this.classicPackageAID == null) {
            this.addError(ErrorKey.MissingAttribute, "Classic-Package-AID");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processInternal() {
        super.processInternal();
        if (!this.isOk()) {
            return;
        }
        if (!this.applicationType.equals("classic-applet")) {
            this.addError(ErrorKey.InvliadAttributeApplicationTypeInJCRD, this.applicationType, "classic applet", "classic-applet");
        }
        if (this.classicPackageAID != null && ValidValues.isValidAID(this.classicPackageAID, "Package AID", this)) {
            this.RID = StringUtils.getRIDFromAID(this.classicPackageAID);
        }
        if (this.getAttributeValue("Web-Context-Path", true) != null) {
            this.addError(ErrorKey.MustNotPresent, "Web-Context-Path", "Classic-Applet");
        }
        if (this.getAttributeValue("Web-Secure-Port-Number", true) != null) {
            this.addError(ErrorKey.MustNotPresent, "Web-Secure-Port-Number", "Classic-Applet");
        }
        if (this.getAttributeValue("Web-Secure-Access-Only", true) != null) {
            this.addError(ErrorKey.MustNotPresent, "Web-Secure-Access-Only", "Classic-Applet");
        }
        if (this.getAttributeValue("Web-Client-Auth-Required", true) != null) {
            this.addError(ErrorKey.MustNotPresent, "Web-Client-Auth-Required", "Classic-Applet");
        }
        if (this.getAttributeValue("User-Role-List", true) != null) {
            this.addError(ErrorKey.MustNotPresent, "User-Role-List", "Classic-Applet");
        }
        if (this.getAttributeValue("On-Card-Client-Role-List", true) != null) {
            this.addError(ErrorKey.MustNotPresent, "On-Card-Client-Role-List", "Classic-Applet");
        }
        if (this.getAttributeValue("On-Card-Clients-Credential-Auth-Type", true) != null) {
            this.addError(ErrorKey.MustNotPresent, "On-Card-Clients-Credential-Auth-Type", "Classic-Applet");
        }
        if (this.getAttributeValue("On-Card-Clients-Credential-Auth-Duration", true) != null) {
            this.addError(ErrorKey.MustNotPresent, "On-Card-Clients-Credential-Auth-Duration", "Classic-Applet");
        }
        for (String keyValue : this.jcrdKeyList) {
            if (keyValue.endsWith("-Mapped-To-Client-URI")) {
                this.addError(ErrorKey.MustNotPresent, "-Mapped-To-Client-URI", "Classic-Applet");
                continue;
            }
            if (keyValue.endsWith("-Mapped-To-Domain-Name")) {
                this.addError(ErrorKey.MustNotPresent, "-Mapped-To-Domain-Name", "Classic-Applet");
                continue;
            }
            if (keyValue.endsWith("-Mapped-To-Auth-Credential")) {
                this.addError(ErrorKey.MustNotPresent, "-Mapped-To-Auth-Credential", "Classic-Applet");
                continue;
            }
            if (keyValue.endsWith("-Credential-Auth-Type")) {
                this.addError(ErrorKey.MustNotPresent, "-Credential-Auth-Type", "Classic-Applet");
                continue;
            }
            if (keyValue.endsWith("-Credential-Auth-Duration")) {
                this.addError(ErrorKey.MustNotPresent, "-Credential-Auth-Duration", "Classic-Applet");
                continue;
            }
            if (!keyValue.endsWith("-Mapped-To-Auth-URI")) continue;
            this.addError(ErrorKey.MustNotPresent, "-Mapped-To-Auth-URI", "Classic-Applet");
        }
        Manifest manifest = null;
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(this.file);
            manifest = new Manifest(fis);
            fis.close();
            manifest.getMainAttributes().putValue("Sealed", "true");
            fos = new FileOutputStream(this.file);
            manifest.write(fos);
            fos.close();
        }
        catch (Exception e) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public String getAID() {
        return this.classicPackageAID;
    }

    String getRID() {
        return this.RID;
    }
}

