/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.appletcontainer;

import com.sun.javacard.appletcontainer.APDUComm;
import com.sun.javacard.appletcontainer.T0TransportLayer;
import com.sun.javacard.impl.NativeMethods;
import javacard.framework.APDUException;
import javacard.framework.ISOException;
import javacard.framework.JCSystem;
import javacard.framework.Util;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public final class T0APDUImpl
extends APDUComm {
    private static final short MAX_XFER_DATA_LENGTH = 128;
    private static final byte IFSC = 1;
    private static final short IFSD = 258;
    private byte[] scratchBuffer;
    private static final byte PRE_READ_LENGTH = 3;
    private static final byte INCOMIMG_LENGTH = 4;
    private static final byte RAM_SHORT_VARS_LENGTH = 5;
    private static final short BUFFER_OVERFLOW = -16383;
    private static final short READ_ERROR = -16381;
    private static final short WRITE_ERROR = -16380;
    private static final short INVALID_GET_RESPONSE = -16378;
    private static final byte ENVELOPE_INS = -62;
    private static final short MAX_LE = 256;
    private static final short MAX_EXT_LE = Short.MAX_VALUE;
    private static final byte ACK_NONE = 0;
    private static final byte ACK_INS = 1;
    private static final byte ACK_NOT_INS = 2;
    private byte noGetResponseFlag;
    private byte envelopeFlag;
    private T0TransportLayer transportLayer;

    public T0APDUImpl(int port) {
        this.transportLayer = new T0TransportLayer(port);
        this.buffer = this.transportLayer.initAPDUBuffer();
        this.ramByteVars = JCSystem.makeTransientByteArray((short)2, (byte)1);
        this.ramShortVars = JCSystem.makeTransientShortArray((short)5, (byte)1);
        this.scratchBuffer = this.transportLayer.t0InitScratchAPDUBuffer();
        this.noGetResponseFlag = this.thePackedBoolean.allocate();
        this.envelopeFlag = this.thePackedBoolean.allocate();
    }

    private short getLe() {
        if (this.ramShortVars[0] == 0) {
            if (this.getExtendedSupportFlag()) {
                return Short.MAX_VALUE;
            }
            return 256;
        }
        return this.ramShortVars[0];
    }

    private void setLe(short data) {
        this.ramShortVars[0] = (short)(data & Short.MAX_VALUE);
    }

    private short getIL() {
        return this.ramShortVars[4];
    }

    private void setIL(short data) {
        this.ramShortVars[4] = data;
    }

    private short getLr() {
        return this.ramShortVars[1];
    }

    private void setLr(short data) {
        this.ramShortVars[1] = data;
    }

    private short getLc() {
        return this.ramShortVars[2];
    }

    private void setLc(short data) {
        this.ramShortVars[2] = data;
    }

    private short getPreReadLength() {
        return this.ramShortVars[3];
    }

    private void setPreReadLength(short data) {
        this.ramShortVars[3] = data;
    }

    private byte getCurrState() {
        return this.ramByteVars[0];
    }

    private void setCurrState(byte data) {
        this.ramByteVars[0] = data;
    }

    private void resetCurrState() {
        this.ramByteVars[0] = 0;
    }

    @Override
    public byte getLogicalChannel() {
        return this.ramByteVars[1];
    }

    private void setLogicalChannel(byte data) {
        this.ramByteVars[1] = data;
    }

    protected boolean getNoGetResponseFlag() {
        return this.thePackedBoolean.get(this.noGetResponseFlag);
    }

    protected void setNoGetResponseFlag() {
        this.thePackedBoolean.set(this.noGetResponseFlag);
    }

    protected void resetNoGetResponseFlag() {
        this.thePackedBoolean.reset(this.noGetResponseFlag);
    }

    protected boolean getEnvelopeFlag() {
        return this.thePackedBoolean.get(this.envelopeFlag);
    }

    protected void setEnvelopeFlag() {
        this.thePackedBoolean.set(this.envelopeFlag);
    }

    protected void resetEnvelopeFlag() {
        this.thePackedBoolean.reset(this.envelopeFlag);
    }

    private byte getChannelInfo() {
        byte theAPDUChannel;
        if (this.isType16CLA(this.scratchBuffer)) {
            theAPDUChannel = (byte)(this.scratchBuffer[0] & 0xF);
            theAPDUChannel = (byte)(theAPDUChannel + 4);
        } else {
            theAPDUChannel = (byte)(this.scratchBuffer[0] & 0x20) != 0 ? (byte)0 : (byte)(this.scratchBuffer[0] & 3);
        }
        return theAPDUChannel;
    }

    @Override
    public short getInBlockSize() {
        return 1;
    }

    @Override
    public short getOutBlockSize() {
        return 258;
    }

    @Override
    public byte getProtocol() {
        return 0;
    }

    @Override
    public byte getNAD() {
        return 0;
    }

    private void getRemainingInbound() {
        if (this.getEnvelopeFlag()) {
            while (this.getEnvelopeFlag() || !this.getDeterminedLEFlag()) {
                short len = this.transportLayer.t0RcvData((short)5);
                if (len == 0) {
                    this.transportLayer.t0SetStatus((short)-28672);
                    short result = this.transportLayer.t0SndStatusRcvCommand();
                    len = this.processEnvelopeData((short)5);
                }
                if (len == -1) {
                    APDUException.throwIt((short)4);
                }
                short Lc = this.getLc();
                if ((Lc = (short)(Lc - len)) < 0) {
                    int bOff = 5;
                    if (Lc == -1) {
                        if (!this.getDeterminedLEFlag()) {
                            this.setDeterminedLEFlag();
                            Lc = 0;
                        } else {
                            this.resetEnvelopeFlag();
                            Lc = 0;
                        }
                    } else {
                        Lc = 0;
                        len = (short)(len - 2);
                        this.setDeterminedLEFlag();
                        this.resetEnvelopeFlag();
                    }
                }
                this.setLc(Lc);
            }
        }
    }

    @Override
    public short setOutgoing() throws APDUException {
        if (this.getOutgoingFlag()) {
            APDUException.throwIt((short)1);
        }
        this.getRemainingInbound();
        this.setOutgoingFlag();
        this.setCurrState((byte)3);
        return this.getLe();
    }

    @Override
    public short setOutgoingNoChaining() throws APDUException {
        if (this.getOutgoingFlag()) {
            APDUException.throwIt((short)1);
        }
        this.getRemainingInbound();
        this.setOutgoingFlag();
        this.setNoChainingFlag();
        this.setCurrState((byte)3);
        short le = this.getLe();
        if (le == Short.MAX_VALUE) {
            le = 256;
        }
        return (short)le;
    }

    @Override
    public void setOutgoingLength(short len) throws APDUException {
        if (!this.getOutgoingFlag()) {
            APDUException.throwIt((short)1);
        }
        if (this.getOutgoingLenSetFlag()) {
            APDUException.throwIt((short)1);
        }
        if (len > 256 && !this.getExtendedSupportFlag()) {
            APDUException.throwIt((short)3);
        }
        if (len > 256 && this.getNoChainingFlag()) {
            APDUException.throwIt((short)3);
        }
        if (len < 0) {
            APDUException.throwIt((short)3);
        }
        this.setOutgoingLenSetFlag();
        this.setCurrState((byte)4);
        this.setLr(len);
        if (len > 256) {
            this.setExtendedAPDUFlag();
        }
    }

    private void setIncoming() throws APDUException {
        if (this.getPreReadLength() != 0) {
            return;
        }
        if (this.getIncomingFlag() || this.getOutgoingFlag()) {
            APDUException.throwIt((short)1);
        }
        this.setIncomingFlag();
        short Lc = this.getLe();
        if (!this.getExtendedSupportFlag() && Lc > 256) {
            APDUException.throwIt((short)26368);
        }
        this.setLc(Lc);
        this.setIL(Lc);
        this.setLe((short)0);
    }

    @Override
    public short receiveBytes(short bOff) throws APDUException {
        short pre;
        if (!this.getIncomingFlag() || this.getOutgoingFlag()) {
            APDUException.throwIt((short)1);
        }
        short Lc = (short)(this.getLc() & Short.MAX_VALUE);
        if (bOff < 0) {
            APDUException.throwIt((short)2);
        }
        if ((pre = (short)(this.getPreReadLength() & Short.MAX_VALUE)) != 0) {
            this.setPreReadLength((short)0);
            if (Lc == 0) {
                this.setCurrState((byte)2);
            } else {
                this.setCurrState((byte)1);
            }
            return pre;
        }
        if (Lc != 0) {
            short len;
            if (!this.getEnvelopeFlag()) {
                len = this.transportLayer.t0RcvData(bOff);
                if (len < 0) {
                    APDUException.throwIt((short)4);
                }
            } else {
                len = this.transportLayer.t0RcvData(bOff);
                if (len < 0) {
                    APDUException.throwIt((short)4);
                }
                if (len == 0) {
                    this.transportLayer.t0SetStatus((short)-28672);
                    short result = this.transportLayer.t0SndStatusRcvCommand();
                    len = this.processEnvelopeData(bOff);
                }
            }
            this.transportLayer.t0CopyToAPDUBuffer(bOff, len);
            Lc = (short)(Lc - len);
            if (Lc < 0) {
                if (Lc == -1) {
                    Lc = 0;
                    len = (short)(len - 1);
                    this.setDeterminedLEFlag();
                } else {
                    Lc = 0;
                    len = (short)(len - 2);
                    this.setDeterminedLEFlag();
                    this.resetEnvelopeFlag();
                }
            }
            this.setLc(Lc);
            if (Lc == 0) {
                this.setCurrState((byte)2);
            } else {
                this.setCurrState((byte)1);
            }
            return len;
        }
        if (this.getEnvelopeFlag() && this.getDeterminedLEFlag()) {
            short len = this.transportLayer.t0RcvData(bOff);
            if (len < 0) {
                APDUException.throwIt((short)4);
            }
            if (len == 0) {
                Util.arrayFillNonAtomic(this.buffer, (short)0, (short)133, (byte)0);
                this.transportLayer.t0SetStatus((short)-28672);
                short result = this.transportLayer.t0SndStatusRcvCommand();
                len = this.processEnvelopeData(bOff);
            }
            this.transportLayer.t0CopyToAPDUBuffer(bOff, len);
            this.resetEnvelopeFlag();
        }
        this.setCurrState((byte)2);
        return 0;
    }

    @Override
    public short setIncomingAndReceive() throws APDUException {
        this.setIncoming();
        if (this.getExtendedAPDUFlag()) {
            return this.receiveBytes((short)7);
        }
        return this.receiveBytes((short)5);
    }

    private short send61xx(short len) {
        byte originChannel = this.getCLAChannel();
        short expLen = len;
        do {
            if (len >= 256) {
                this.transportLayer.t0SetStatus((short)24832);
            } else {
                this.transportLayer.t0SetStatus((short)(24832 + (short)(len & 0xFF)));
            }
            short newLen = this.transportLayer.t0SndGetResponse(originChannel);
            if (newLen == -16378) {
                this.setNoGetResponseFlag();
                APDUException.throwIt((short)170);
                continue;
            }
            if (newLen > 0) {
                this.setLe(newLen);
                expLen = this.getLe();
                continue;
            }
            APDUException.throwIt((short)4);
        } while (expLen > len);
        this.resetSendInProgressFlag();
        return expLen;
    }

    @Override
    public void sendBytes(short bOff, short len) throws APDUException {
        if (bOff < 0 || len < 0 || (short)(bOff + len) > 133) {
            APDUException.throwIt((short)2);
        }
        if (!this.getOutgoingLenSetFlag() || this.getNoGetResponseFlag()) {
            APDUException.throwIt((short)1);
        }
        if (len == 0) {
            return;
        }
        short Lr = this.getLr();
        if (len > Lr) {
            APDUException.throwIt((short)1);
        }
        short Le = this.getLe();
        if (this.getNoChainingFlag()) {
            short result;
            if (this.getIncomingFlag() || Lr < Le) {
                Le = this.send61xx(Lr);
                this.resetIncomingFlag();
            }
            while (len > Le) {
                if (!this.getSendInProgressFlag()) {
                    result = this.transportLayer.t0SndData(this.buffer, bOff, Le, (byte)1);
                    this.setSendInProgressFlag();
                } else {
                    result = this.transportLayer.t0SndData(this.buffer, bOff, Le, (byte)0);
                }
                if (result != 0) {
                    APDUException.throwIt((short)4);
                }
                bOff = (short)(bOff + Le);
                len = (short)(len - Le);
                Lr = (short)(Lr - Le);
                Le = this.send61xx(Lr);
            }
            if (!this.getSendInProgressFlag()) {
                result = this.transportLayer.t0SndData(this.buffer, bOff, len, (byte)1);
                this.setSendInProgressFlag();
            } else {
                result = this.transportLayer.t0SndData(this.buffer, bOff, len, (byte)0);
            }
            if (result != 0) {
                APDUException.throwIt((short)4);
            }
            Lr = (short)(Lr - len);
            Le = (short)(Le - len);
        } else {
            while (len > 0) {
                short temp = len;
                if (len != Lr || this.getIncomingFlag() || Lr != Le || this.getSendInProgressFlag()) {
                    temp = this.send61xx(len);
                    this.resetIncomingFlag();
                }
                short result = this.transportLayer.t0SndData(this.buffer, bOff, temp, (byte)1);
                this.setSendInProgressFlag();
                if (result != 0) {
                    APDUException.throwIt((short)4);
                }
                bOff = (short)(bOff + temp);
                len = (short)(len - temp);
                Le = Lr = (short)(Lr - temp);
            }
        }
        if (Lr == 0) {
            this.setCurrState((byte)6);
        } else {
            this.setCurrState((byte)5);
        }
        this.setLe(Le);
        this.setLr(Lr);
    }

    @Override
    public void sendBytesLong(byte[] outData, short bOff, short len) throws APDUException, SecurityException {
        NativeMethods.checkArrayArgs(outData, bOff, len);
        NativeMethods.checkPreviousContextAccess(outData);
        short sendLength = (short)this.buffer.length;
        while (len > 0) {
            if (len < sendLength) {
                sendLength = len;
            }
            Util.arrayCopy(outData, bOff, this.buffer, (short)0, sendLength);
            this.sendBytes((short)0, sendLength);
            len = (short)(len - sendLength);
            bOff = (short)(bOff + sendLength);
        }
    }

    @Override
    public byte getCurrentState() {
        return this.getCurrState();
    }

    @Override
    public byte[] getCurrentAPDUBuffer() throws SecurityException {
        return this.getBuffer();
    }

    @Override
    public byte getCLAChannel() {
        return this.getLogicalChannel();
    }

    @Override
    public void resetAPDU() {
        this.resetIncomingFlag();
        this.resetOutgoingFlag();
        this.resetOutgoingLenSetFlag();
        this.resetSendInProgressFlag();
        this.resetNoChainingFlag();
        this.resetNoGetResponseFlag();
        this.resetExtendedAPDUFlag();
        this.resetEnvelopeFlag();
        this.resetDeterminedLEFlag();
        this.setPreReadLength((short)0);
    }

    private short processEnvelopeData(short bOffset) {
        if (this.isISOInterindustryCLA(this.scratchBuffer) && this.scratchBuffer[1] == -62) {
            short len = this.transportLayer.t0RcvData(bOffset);
            if (len < 0) {
                APDUException.throwIt((short)4);
            }
            return len;
        }
        APDUException.throwIt((short)4);
        return -1;
    }

    private void processEnvelopeAPDU() throws APDUException {
        if (this.isISOInterindustryCLA(this.scratchBuffer) && this.scratchBuffer[1] == -62) {
            short apduLen = this.setIncomingAndReceive();
            for (short i = 0; i < apduLen; i = (short)(i + 1)) {
                this.scratchBuffer[i] = this.scratchBuffer[(short)(5 + i)];
            }
            Util.arrayFillNonAtomic(this.scratchBuffer, apduLen, (short)(133 - apduLen), (byte)0);
            short apduDataLen = (short)(apduLen - 5);
            this.resetAPDU();
            this.preProcessAPDU();
            this.setEnvelopeFlag();
            this.setLc(this.getLe());
            this.setIL(this.getLc());
            short shortLC = this.getLc();
            short extendedLC = Util.makeShort(this.scratchBuffer[5], this.scratchBuffer[6]);
            if (shortLC == apduDataLen) {
                this.setLe((short)0);
            } else if (shortLC == (short)(apduDataLen - 1)) {
                this.setLe(this.scratchBuffer[(short)(apduLen - 1)]);
            } else if (extendedLC > apduDataLen) {
                this.setExtendedAPDUFlag();
                this.setLc((short)(extendedLC - (apduDataLen - 2)));
                this.setIL(extendedLC);
                this.setLe((short)0);
            }
            this.undoIncomingAndReceiveForEnvelope((short)(extendedLC - this.getLc()));
            this.setLogicalChannel(this.getChannelInfo());
        }
        this.transportLayer.t0CopyToAPDUBuffer((short)0, (short)133);
    }

    private void undoIncomingAndReceiveForEnvelope(short totalLength) {
        this.setPreReadLength(totalLength);
        this.setCurrState((byte)0);
        this.setIncomingFlag();
        this.resetOutgoingFlag();
    }

    private void preProcessAPDU() {
        this.setLe((short)(this.scratchBuffer[4] & 0xFF));
        this.setLc((short)0);
        this.setIL((short)(this.scratchBuffer[4] & 0xFF));
        this.resetCurrState();
        this.setLogicalChannel(this.getChannelInfo());
        this.setLr((short)0);
    }

    @Override
    public void markExtendedSupport(boolean extAPDUOK) throws APDUException {
        if (!extAPDUOK) {
            this.resetExtendedSupportFlag();
            if (this.getExtendedAPDUFlag()) {
                ISOException.throwIt((short)26368);
            }
            if (this.getLe() == 0 && !this.getEnvelopeFlag()) {
                this.setLe((short)256);
            }
        } else {
            this.setExtendedSupportFlag();
            if (this.getLe() == 256 && !this.getEnvelopeFlag()) {
                this.setLe((short)Short.MAX_VALUE);
            }
        }
    }

    @Override
    public void complete(short status) throws APDUException {
        short result;
        Util.arrayFillNonAtomic(this.buffer, (short)0, (short)133, (byte)0);
        if (!this.getNoGetResponseFlag() && this.getSendInProgressFlag()) {
            short Le = (byte)this.getLe();
            short sendLen = 128;
            while (Le > 0) {
                if (Le < 128) {
                    sendLen = Le;
                }
                if ((result = this.transportLayer.t0SndData(this.buffer, (short)0, sendLen, (byte)0)) != 0) {
                    APDUException.throwIt((short)4);
                }
                Le = (short)(Le - sendLen);
            }
        }
        this.buffer[0] = (byte)(status >> 8);
        this.buffer[1] = (byte)status;
        if (status == 0) {
            result = this.transportLayer.t0RcvCommand();
        } else {
            this.getRemainingInbound();
            this.transportLayer.t0SetStatus(status);
            result = this.transportLayer.t0SndStatusRcvCommand();
            if (result == -14) {
                result = this.transportLayer.t0RcvCommand();
            }
        }
        if (result != 0) {
            APDUException.throwIt((short)4);
        }
        this.resetExtendedSupportFlag();
        this.resetAPDU();
        this.preProcessAPDU();
        this.processEnvelopeAPDU();
    }

    @Override
    public void undoIncomingAndReceive() {
        this.setPreReadLength((short)(this.buffer[4] - this.getLc() & Short.MAX_VALUE));
        this.setCurrState((byte)0);
    }

    @Override
    public void waitExtension() throws APDUException {
        short result;
        if (this.getNoChainingFlag()) {
            APDUException.throwIt((short)1);
        }
        if ((result = this.transportLayer.t0Wait()) != 0) {
            APDUException.throwIt((short)4);
        }
    }

    private boolean isExtended() {
        return this.getExtendedSupportFlag();
    }

    @Override
    public boolean isValidCLA() {
        byte cla = this.buffer[0];
        return (byte)(cla & 0xE0) != 32 && cla != -1;
    }

    @Override
    public boolean isCommandChainingCLA() {
        if (!this.isValidCLA()) {
            return false;
        }
        byte theCLAChaining = (byte)(this.buffer[0] & 0x10);
        return theCLAChaining == 16;
    }

    @Override
    public boolean isSecureMessagingCLA() {
        if (!this.isValidCLA()) {
            return false;
        }
        byte secureMsgFlag = this.isType16CLA(this.buffer) ? (byte)(this.buffer[0] & 0x20) : (byte)(this.buffer[0] & 0xC);
        return secureMsgFlag != 0;
    }

    @Override
    public boolean isISOInterindustryCLA() {
        return this.isISOInterindustryCLA(this.buffer);
    }

    private boolean isISOInterindustryCLA(byte[] aBuffer) {
        byte theCLAType = (byte)(aBuffer[0] & 0xFFFFFF80);
        return theCLAType == 0;
    }

    private boolean isType16CLA(byte[] aBuffer) {
        byte theCLAType = (byte)(aBuffer[0] & 0x40);
        return theCLAType == 64;
    }

    @Override
    public short getIncomingLength() {
        return this.getIL();
    }

    @Override
    public short getOffsetCdata() {
        if (!this.getExtendedAPDUFlag()) {
            return 5;
        }
        return 7;
    }

    @Override
    public void verifyLe() {
    }
}

