/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cm.impl;

import com.sun.cldc.io.ConnectionBaseInterface;
import com.sun.javacard.Logger;
import com.sun.javacard.appletcontainer.AppletServer;
import com.sun.javacard.cm.impl.ApplicationBundleImpl;
import com.sun.javacard.cm.impl.CMStatus;
import com.sun.javacard.cm.impl.IDManager;
import com.sun.javacard.cm.impl.OnCardClientAuth;
import com.sun.javacard.cm.impl.SecurityUtil;
import com.sun.javacard.cm.impl.jcrd.JCRuntimeDesc;
import com.sun.javacard.cm.impl.jcrd.ModuleInfo;
import com.sun.javacard.cm.impl.jcrd.UserRole;
import com.sun.javacard.cm.registries.SecureCommunicationInfoRegistry;
import com.sun.javacard.file.FileConnection;
import com.sun.javacard.impl.AppletMgr;
import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.jcre.Card;
import com.sun.javacard.jcre.TaskRegistryAccessor;
import com.sun.javacard.spi.cardmgmt.Application;
import com.sun.javacard.spi.cardmgmt.ApplicationGroup;
import com.sun.javacard.util.JCSystemAccessor;
import com.sun.javacard.util.PathLookupTable;
import com.sun.midp.ssl.Handshake;
import java.io.IOException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javacard.framework.Applet;
import javacard.framework.AppletEvent;
import javacard.framework.JCSystem;
import javacardx.facilities.Event;
import javacardx.facilities.EventNotificationListener;
import javacardx.facilities.EventRegistry;
import javacardx.facilities.ServiceFactory;
import javacardx.framework.ClassicSIOProxy;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javacardx.framework.TransientReference;
import javacardx.security.CredentialManager;
import javacardx.spi.cardmgmt.CardManagementPermission;
import javacardx.spi.framework.JCREPermission;
import org.mortbay.jetty.WebConnector;
import org.mortbay.jetty.WebServer;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class ApplicationImpl
extends Application {
    private static Vector<Application> createdApps = new Vector();
    private static ApplicationImplHelper appHelper = null;
    private int applicationId;
    private CredentialManager[] appCredentialManagers = null;
    private CredentialManager.SecurityRequirements[] appSecurityRequirements = null;
    private ModuleInfo moduleInfo;
    private String domainName;
    private Vector<String> cardHolderAuthorizedRoles;
    private boolean cleanUp = false;
    private Hashtable<String, String> runtimeConfig;
    private Vector<OnCardClientAuth> appLifetimeBoundClientAuths = null;
    private TransientReference<Vector<OnCardClientAuth>> cardSessionBoundClientAuths = new TransientReference<Object>(null);

    protected ApplicationImpl(ApplicationGroup applicationGroup, String moduleName, String appURI) throws IllegalArgumentException, NullPointerException {
        super(applicationGroup, moduleName, appURI);
        AccessController.checkPermission(new JCREPermission("callPermJCREEPO.CARDMGMT"));
        NativeMethods.setJCREentry(this, false);
        this.moduleInfo = ((ApplicationBundleImpl)applicationGroup).getJcrd().getModule(moduleName);
        this.domainName = ((ApplicationBundleImpl)applicationGroup).getJCContext().getProtectionDomain().getName();
        ApplicationBundleImpl app = (ApplicationBundleImpl)applicationGroup;
        this.cardHolderAuthorizedRoles = new Vector();
        if (app.getAppModule(moduleName).getJCAppDesc() != null) {
            this.cardHolderAuthorizedRoles = app.getAppModule(moduleName).getJCAppDesc().getCardHolderAuthorization();
        }
        createdApps.addElement(this);
    }

    public final Vector<String> getCardHolderAuthorizedRoles() {
        return this.cardHolderAuthorizedRoles;
    }

    public final CredentialManager getCredentialManager(int mode) {
        if (this.appCredentialManagers != null) {
            return this.appCredentialManagers[mode];
        }
        return null;
    }

    public final CredentialManager.SecurityRequirements getSecurityRequirements(int mode) {
        if (this.appSecurityRequirements != null) {
            return this.appSecurityRequirements[mode];
        }
        return null;
    }

    public final void setCredentialManager(CredentialManager credentialManager, int mode) {
        if (this.appCredentialManagers == null) {
            this.appCredentialManagers = new CredentialManager[6];
        }
        this.appCredentialManagers[mode] = credentialManager;
    }

    public final void setSecurityRequirements(CredentialManager.SecurityRequirements securityRequirements, int mode) {
        if (this.appSecurityRequirements == null) {
            this.appSecurityRequirements = new CredentialManager.SecurityRequirements[6];
        }
        this.appSecurityRequirements[mode] = securityRequirements;
    }

    public void setApplicationID(int id) {
        this.applicationId = id;
    }

    public int getApplicationId() {
        return this.applicationId;
    }

    public ModuleInfo getModuleInfo() {
        return this.moduleInfo;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void updateURI(String newURI) {
        this.appURI = newURI;
    }

    public void setCleanUp(boolean cleanUp) {
        this.cleanUp = cleanUp;
    }

    public boolean isCleanUp() {
        return this.cleanUp;
    }

    public boolean isClientAlreadyAuthorized(String role, ApplicationImpl client) {
        Vector<OnCardClientAuth> clientAuths;
        OnCardClientAuth auth = new OnCardClientAuth(role, client.appURI);
        if (this.cardSessionBoundClientAuths != null && (clientAuths = this.cardSessionBoundClientAuths.get()) != null && clientAuths.contains(auth)) {
            return true;
        }
        return this.appLifetimeBoundClientAuths != null && this.appLifetimeBoundClientAuths.contains(auth);
    }

    public void cacheClientAuthorization(String role, ApplicationImpl client, boolean sessionBound) {
        OnCardClientAuth auth = new OnCardClientAuth(role, client.appURI);
        Vector<OnCardClientAuth> clientAuths = null;
        if (sessionBound) {
            clientAuths = this.cardSessionBoundClientAuths.get();
            if (clientAuths == null) {
                clientAuths = new Vector(1, 1);
                this.cardSessionBoundClientAuths.set(clientAuths);
            }
        } else {
            clientAuths = this.appLifetimeBoundClientAuths;
            if (clientAuths == null) {
                clientAuths = this.appLifetimeBoundClientAuths = new Vector(1, 1);
            }
        }
        if (!clientAuths.contains(auth)) {
            clientAuths.addElement(auth);
        }
    }

    public void clearClientAuthorization(ApplicationImpl client) {
        Vector<OnCardClientAuth> clientAuths;
        OnCardClientAuth auth = new OnCardClientAuth(null, client.appURI);
        if (this.cardSessionBoundClientAuths != null && (clientAuths = this.cardSessionBoundClientAuths.get()) != null) {
            while (clientAuths.removeElement(auth)) {
            }
        }
        if (this.appLifetimeBoundClientAuths != null) {
            while (this.appLifetimeBoundClientAuths.removeElement(auth)) {
            }
        }
    }

    @Override
    public boolean delete() throws SecurityException, AccessControlException {
        Application[] appsToDelete = new Application[]{this};
        return appHelper.deleteApps(appsToDelete);
    }

    public static boolean delete(Application[] applications) throws AccessControlException {
        return appHelper.deleteApps(applications);
    }

    public static int lookupApplicationId(String instanceURI) {
        if (Card.quickTestingWarLoaded) {
            return 0;
        }
        if (instanceURI.equals("///cardmanager")) {
            return 0;
        }
        ApplicationImpl app = (ApplicationImpl)ApplicationImpl.lookup(instanceURI);
        if (app != null) {
            return app.getApplicationId();
        }
        return -1;
    }

    public static Application lookup(String appURI) {
        return appHelper.lookupApplication(appURI);
    }

    public static String getAppURIForAppId(int appId) {
        for (Application app : createdApps) {
            if (((ApplicationImpl)app).getApplicationId() != appId) continue;
            return app.getAppURI();
        }
        return null;
    }

    public static Hashtable<String, Vector<String>> getRole2URIMappingTable(String appURI) {
        Hashtable<String, Vector<String>> userRole2AuthURIs = null;
        ApplicationImpl app = (ApplicationImpl)ApplicationImpl.lookup(appURI);
        Vector<UserRole> userRoles = app.getModuleInfo().getUserRoleList();
        if (userRoles != null) {
            userRole2AuthURIs = new Hashtable<String, Vector<String>>();
            for (UserRole ur : userRoles) {
                userRole2AuthURIs.put(ur.getUserRoleName(), ur.getAuthURIs());
            }
        }
        return userRole2AuthURIs;
    }

    public static Vector<String> getCardHolderRolesRequiredForAuthorization(String appURI) {
        Logger.verbose("Get allowed card holder role reqd. for \"" + appURI + "\" context");
        ApplicationImpl app = (ApplicationImpl)ApplicationImpl.lookup(appURI);
        return app.getCardHolderAuthorizedRoles();
    }

    public static boolean isSecureWebRequired(String appURI) {
        ApplicationImpl app = (ApplicationImpl)ApplicationImpl.lookup(appURI);
        if (app == null) {
            return false;
        }
        String moduleName = app.getModuleName();
        ApplicationGroup appBundle = app.getApplicationGroup();
        JCRuntimeDesc jcrd = ((ApplicationBundleImpl)appBundle).getJcrd();
        ModuleInfo mi = jcrd.getModule(moduleName);
        return mi.isWebSecureAccessOnly();
    }

    public static Vector<String> getRolesAllowed(String appURI) {
        Logger.verbose("Get allowed role names for \"" + appURI + "\" context");
        Hashtable<String, Vector<String>> role2UriTable = ApplicationImpl.getRole2URIMappingTable(appURI);
        if (role2UriTable == null) {
            return null;
        }
        Vector<String> userNames = null;
        Enumeration<String> en = role2UriTable.keys();
        while (en.hasMoreElements()) {
            if (userNames == null) {
                userNames = new Vector<String>();
            }
            String key = en.nextElement();
            userNames.addElement(key);
        }
        return userNames;
    }

    static void addToAppsList(Application app) {
        createdApps.addElement(app);
    }

    public static Vector<Application> getCreatedApps() {
        return createdApps;
    }

    void setRuntimeConfig(Hashtable<String, String> runtimeConfig) {
        this.runtimeConfig = runtimeConfig;
    }

    public String getAppProperty(String propName) {
        String value;
        String string = value = this.runtimeConfig != null ? this.runtimeConfig.get(propName) : null;
        if (value != null) {
            if (value.equals("<<REMOVED>>")) {
                return null;
            }
        } else {
            JCRuntimeDesc jcrd = ((ApplicationBundleImpl)this.getApplicationGroup()).getJcrd();
            value = jcrd.getAppProperty(propName);
        }
        NativeMethods.transferOwnershipToPreviousContext(value);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
    private static void callAppletUninstall(Applet app, int bundleType) {
        block7: {
            try {
                if (bundleType == 12) {
                    Object object = ClassicSIOProxy.CLASSIC_APPLET_CONTAINER_MUTEX;
                    synchronized (object) {
                        ((AppletEvent)((Object)app)).uninstall();
                        if (JCSystem.getTransactionDepth() != 0) {
                            JCSystem.abortTransaction();
                        }
                        break block7;
                    }
                }
                ((AppletEvent)((Object)app)).uninstall();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public static native int deleteApp(short[] var0);

    static {
        appHelper = new ApplicationImplHelper();
        NativeMethods.setJCREentry(appHelper, false);
    }

    static class ApplicationImplHelper {
        ApplicationImplHelper() {
        }

        Application lookupApplication(String appURI) {
            String searchURI = appURI;
            if (!appURI.startsWith("///") && !appURI.startsWith("//aid")) {
                searchURI = "//" + appURI;
            }
            for (Application app : createdApps) {
                if (!app.getAppURI().equals(searchURI)) continue;
                return app;
            }
            return null;
        }

        @TransactionType(value=TransactionTypeValue.REQUIRES_NEW)
        boolean deleteApps(Application[] apps) throws AccessControlException {
            AccessController.checkPermission(new CardManagementPermission("application.delete"));
            short[] appList = new short[apps.length];
            NativeMethods.setNonPreemptive(Thread.currentThread());
            EventRegistry eventRegistry = EventRegistry.getEventRegistry();
            PathLookupTable<ServiceFactory> serviceRegistry = JCSystemAccessor.getJCSystemAccessor().getServiceRegistry();
            PathLookupTable<EventNotificationListener> eventRegistryList = JCSystemAccessor.getJCSystemAccessor().getEventRegistry();
            for (int i = 0; i < apps.length; ++i) {
                int appId = ((ApplicationImpl)apps[i]).getApplicationId();
                appList[i] = (short)appId;
                ApplicationBundleImpl bundleImpl = (ApplicationBundleImpl)((ApplicationImpl)apps[i]).getApplicationGroup();
                byte bundleType = ((ApplicationImpl)apps[i]).getType();
                if (bundleType == 12 || bundleType == 11) {
                    Logger.verbose("    Deleting Applet Application Instance");
                    Applet app = AppletMgr.findAppletWithAppId(appId);
                    if (app != null) {
                        short appContextId = NativeMethods.getObjectContextAndOwner(app);
                        byte isSelected = AppletServer.getAppletServer().getContextStatus(appContextId);
                        if (isSelected > 0) {
                            Logger.verbose("Delete Aborted:[ Applet Selected on a Logical Channel]");
                            CMStatus.getInstance().setLastError(4043);
                            CMStatus.getInstance().setLastErrorMsg("Applet Selected on a Logical Channel");
                            throw new NullPointerException("Instance Deletion Failed, Applet Selected on a Logical Channel");
                        }
                        if (AppletEvent.class.isAssignableFrom(app.getClass())) {
                            ApplicationImpl.callAppletUninstall(app, bundleType);
                        }
                    } else if (!((ApplicationImpl)apps[i]).isCleanUp()) {
                        throw new NullPointerException("Applet is not Registered");
                    }
                }
                Event deleting = new Event(((ApplicationImpl)apps[i]).appURI, "event:///standard/app/deleting", null);
                eventRegistry.notifyListeners(deleting);
                if (bundleType == 12 || bundleType == 11) {
                    Logger.verbose("    Removing Applet from Applet Container");
                    AppletMgr.removeApplet(appId);
                } else {
                    Logger.verbose("    Deleting Web Application Instance");
                    Logger.verbose("    Closing Secure Ports");
                    int port = SecureCommunicationInfoRegistry.getPortFromContext(((ApplicationImpl)apps[i]).appURI);
                    Logger.debug("Removing port from porrtmap and reservedlist");
                    if (port != -1) {
                        SecureCommunicationInfoRegistry.removeFromPortMap(port);
                        SecureCommunicationInfoRegistry.removeFromReservedList(port);
                    }
                    Logger.debug("Removing secure port from redirect tables");
                    WebConnector conn = SecureCommunicationInfoRegistry.removeFromRedirectTable(((ApplicationImpl)apps[i]).appURI);
                    if (conn == null) {
                        conn = SecureCommunicationInfoRegistry.removeFromDynamicRedirectTable(((ApplicationImpl)apps[i]).appURI);
                    }
                    if (conn != null) {
                        try {
                            Logger.debug("Closing the connector");
                            conn.stop();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    Logger.verbose("    Unregister application instance from Web Container");
                    WebServer.getWebServer().removeHandler(((ApplicationImpl)apps[i]).appURI);
                }
                if (bundleType == 10 || bundleType == 11) {
                    this.deleteFiles(((ApplicationImpl)apps[i]).appURI);
                }
                Logger.verbose("    Removing SSL sessions");
                Handshake.deleteSessions((int)appId);
                Logger.verbose("    Clearing on-card client authentication sessions");
                ApplicationImplHelper.clearAuthorizations((ApplicationImpl)apps[i]);
                ConnectionBaseInterface uc = (ConnectionBaseInterface)NativeMethods.getConnection(((ApplicationImpl)apps[i]).applicationId);
                while (uc != null) {
                    try {
                        uc.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    uc = (ConnectionBaseInterface)NativeMethods.getConnection(((ApplicationImpl)apps[i]).applicationId);
                }
                serviceRegistry.deleteEntries(((ApplicationImpl)apps[i]).appURI);
                eventRegistryList.deleteEntries(((ApplicationImpl)apps[i]).appURI);
                TaskRegistryAccessor.getTaskRegistryAccessor().unregister(((ApplicationImpl)apps[i]).appURI);
                createdApps.removeElement(apps[i]);
                bundleImpl.removeApp(((ApplicationImpl)apps[i]).appURI);
                IDManager.removeAppId(((ApplicationImpl)apps[i]).applicationId);
            }
            Logger.verbose("    Finding if any dependency");
            if (serviceRegistry.containsDependency(appList)) {
                CMStatus.getInstance().setLastError(4043);
                CMStatus.getInstance().setLastErrorMsg("Failed to delete application because of dependency from ServiceRegistry Entries");
                throw new NullPointerException("Instance Deletion Failed, Failed to delete application because of dependency from ServiceRegistry Entries ");
            }
            if (eventRegistryList.containsDependency(appList)) {
                CMStatus.getInstance().setLastError(4043);
                CMStatus.getInstance().setLastErrorMsg("Failed to delete application because of dependency from EventRegistry Entries");
                throw new NullPointerException("Instance Deletion Failed, Failed to delete application because of dependency from EventRegistry Entries ");
            }
            if (TaskRegistryAccessor.getTaskRegistryAccessor().containsDependency(appList)) {
                CMStatus.getInstance().setLastError(4043);
                CMStatus.getInstance().setLastErrorMsg("Failed to delete application because of dependency from TaskRegistry Entries");
                throw new NullPointerException("Instance Deletion Failed, Failed to delete application because of dependency from TaskRegistry Entries");
            }
            if (ApplicationImpl.deleteApp(appList) == 0) {
                if (appList.length == 1 && ((ApplicationImpl)apps[0]).isCleanUp()) {
                    System.gc();
                } else {
                    CMStatus.getInstance().setLastError(4043);
                    CMStatus.getInstance().setLastErrorMsg("Failed to delete application because of dependency");
                    throw new NullPointerException("Instance Deletion Failed, Failed to delete application because of dependency");
                }
            }
            Logger.verbose("    Updating Application PD Matrix");
            int size = appList.length;
            for (int j = 0; j < size; ++j) {
                SecurityUtil.resetAppPDMatrix(appList[j]);
                Event deleted = new Event(((ApplicationImpl)apps[j]).appURI, "event:///standard/app/deleted", null);
                eventRegistry.notifyListeners(deleted);
                Logger.verbose("Instance " + ((ApplicationImpl)apps[j]).appURI + " removed.");
            }
            return true;
        }

        private void deleteFiles(String appURI) {
            String fileURI = FileConnection.getFromMap(appURI);
            FileConnection fc = new FileConnection(fileURI);
            fc.setPathInternal(appURI);
            try {
                Enumeration<String> list = fc.list();
                if (list != null) {
                    while (list.hasMoreElements()) {
                        String thisNode = list.nextElement();
                        if (thisNode.equals("docroot")) continue;
                        FileConnection child = new FileConnection(fileURI + "/" + thisNode);
                        child.deleteInternal();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private static void clearAuthorizations(ApplicationImpl client) {
            Enumeration e = createdApps.elements();
            while (e.hasMoreElements()) {
                ApplicationImpl server = (ApplicationImpl)e.nextElement();
                server.clearClientAuthorization(client);
            }
        }
    }
}

