/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cm.impl.wad;

import com.sun.javacard.cm.impl.wad.AuthConstraint;
import com.sun.javacard.cm.impl.wad.UserDataConstraint;
import com.sun.javacard.cm.impl.wad.WebResourceCollection;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class SecurityConstraint {
    Vector<String> displayNames;
    Vector<WebResourceCollection> webResources;
    Vector<AuthConstraint> authConstraints;
    Vector<UserDataConstraint> userDataConstraints;

    public SecurityConstraint(Vector<String> displayNames, Vector<WebResourceCollection> webResources, Vector<AuthConstraint> authConstraints, Vector<UserDataConstraint> userDataConstraints) {
        this.displayNames = displayNames;
        this.webResources = webResources;
        this.authConstraints = authConstraints;
        this.userDataConstraints = userDataConstraints;
    }

    public Vector<String> getDisplayNames() {
        return this.displayNames;
    }

    public Vector<WebResourceCollection> getWebResourceCollections() {
        return this.webResources;
    }

    public Vector<AuthConstraint> getAuthConstraints() {
        return this.authConstraints;
    }

    public Vector<UserDataConstraint> getUserDataConstraints() {
        return this.userDataConstraints;
    }

    public Vector<String> getAuthConstraintRoles() {
        Vector<String> roles = null;
        if (this.authConstraints != null) {
            for (AuthConstraint aConstraint : this.authConstraints) {
                if (aConstraint == null) continue;
                roles = aConstraint.getRoleNames();
            }
        }
        return roles;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.displayNames != null) {
            for (String dn : this.displayNames) {
                if (dn == null) continue;
                sb.append("\t\tDisplay Name: ");
                sb.append(dn + "\n");
            }
        }
        if (this.webResources != null) {
            sb.append("\t\tWeb Resource Collection: \n");
            for (WebResourceCollection wrc : this.webResources) {
                if (wrc == null) continue;
                sb.append(wrc.toString());
            }
        }
        if (this.authConstraints != null) {
            sb.append("\t\tAuth Constraint: \n");
            for (AuthConstraint ac : this.authConstraints) {
                if (ac == null) continue;
                sb.append(ac.toString());
            }
        }
        if (this.userDataConstraints != null) {
            sb.append("\t\tUser Data Constraint: \n");
            for (UserDataConstraint udc : this.userDataConstraints) {
                if (udc == null) continue;
                sb.append(udc.toString());
            }
        }
        return sb.toString();
    }
}

