/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.security;

import com.sun.javacard.Logger;
import com.sun.javacard.security.Principal;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.security.Authenticator;
import org.mortbay.jetty.security.SecurityHandler;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.util.URIUtil;

public class JCAuthenticator
implements Authenticator {
    public static final String JC_URI = "com.sun.javacard.URI";
    public static final String JC_AUTHENTICATED = "com.sun.javacard.Auth";
    public static final String JC_AUTHORIZED_ROLES = "com.sun.javacard.Roles";
    public static final String JC_SECURITY_CHECK = "/jc_security_check";
    public static final String JC_USERNAME = "jc_username";
    public static final String JC_AUTH_METHOD_PREFIX = "JC-";
    public static final String JC_CRED_PARAM_PREFIX = "jc_";
    private String formErrorPage;
    private String formErrorPath;
    private String formLoginPage;
    private String formLoginPath;
    private String credentialParam;
    private String authMethod;

    public JCAuthenticator(String authMethod) {
        this.authMethod = authMethod;
        String authScheme = authMethod.substring(JC_AUTH_METHOD_PREFIX.length());
        this.credentialParam = JC_CRED_PARAM_PREFIX + authScheme;
    }

    @Override
    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setLoginPage(String path) {
        if (!path.startsWith("/")) {
            Logger.debug("javacard-login-page must start with /");
            path = "/" + path;
        }
        this.formLoginPage = path;
        this.formLoginPath = path;
        if (this.formLoginPath.indexOf(63) > 0) {
            this.formLoginPath = this.formLoginPath.substring(0, this.formLoginPath.indexOf(63));
        }
    }

    public String getLoginPage() {
        return this.formLoginPage;
    }

    public void setErrorPage(String path) {
        if (path == null || path.trim().length() == 0) {
            this.formErrorPath = null;
            this.formErrorPage = null;
        } else {
            if (!path.startsWith("/")) {
                Logger.debug("form-error-page must start with /");
                path = "/" + path;
            }
            this.formErrorPage = path;
            this.formErrorPath = path;
            if (this.formErrorPath != null && this.formErrorPath.indexOf(63) > 0) {
                this.formErrorPath = this.formErrorPath.substring(0, this.formErrorPath.indexOf(63));
            }
        }
    }

    public String getErrorPage() {
        return this.formErrorPage;
    }

    @Override
    public Principal authenticate(UserRealm realm, String pathInContext, Request request, Response response) throws IOException {
        String uri = pathInContext;
        String nuri = null;
        HttpSession session = request.getSession(response != null);
        Logger.debug("JCAuthenticator------------>1");
        if (session == null) {
            return null;
        }
        Logger.debug("JCAuthenticator------------>2");
        if (uri.endsWith(JC_SECURITY_CHECK)) {
            if (response == null) {
                return null;
            }
            JCCredential JC_cred = new JCCredential();
            Logger.debug("hello");
            Object credential = request.getParameter(this.credentialParam);
            if (credential == null) {
                int content_length = request.getContentLength();
                String content_type = request.getContentType();
                if (content_length > 0 && content_type.equals("application/octet-stream")) {
                    byte[] content = new byte[content_length];
                    DataInputStream is = new DataInputStream(request.getInputStream());
                    is.readFully(content);
                    credential = content;
                }
            }
            Vector authorizedRoles = (Vector)session.getAttribute(JC_AUTHORIZED_ROLES);
            request.setAuthorizedRoles(authorizedRoles);
            JC_cred.authenticate(realm, request.getParameter(JC_USERNAME), credential, request, this.authMethod);
            Logger.debug("JCAuthenticator------------>3");
            nuri = (String)session.getAttribute(JC_URI);
            if ((nuri == null || nuri.length() == 0) && (nuri = request.getContextPath()).length() == 0) {
                nuri = "/";
            }
            Logger.debug("JCAuthenticator------------>4");
            if (JC_cred.userPrincipal != null) {
                if (JC_cred.userPrincipal.getName().equals("forbidden")) {
                    response.sendError(403);
                    return null;
                }
                Logger.debug("JC authentication OK for " + JC_cred.jcUserName);
                session.removeAttribute(JC_AUTHORIZED_ROLES);
                session.removeAttribute(JC_URI);
                Logger.debug("JCAuthenticator------------>6");
                request.setAuthType(this.authMethod);
                request.setUserPrincipal(JC_cred.userPrincipal);
                session.setAttribute(JC_AUTHENTICATED, JC_cred);
                Logger.debug("JCAuthenticator------------>7");
                response.setContentLength(0);
                response.sendRedirect(response.encodeRedirectURL(nuri));
                Logger.debug("JCAuthenticator------------>8");
            } else {
                Logger.debug("Java Card Platform authentication FAILED for " + JC_cred.jcUserName + " response status code =" + response.getReason());
                if (this.formErrorPage == null) {
                    response.sendError(403);
                } else {
                    response.setContentLength(0);
                    response.sendRedirect(response.encodeRedirectURL(URIUtil.addPaths(request.getContextPath(), this.formErrorPage)));
                }
            }
            return null;
        }
        JCCredential JC_cred = (JCCredential)session.getAttribute(JC_AUTHENTICATED);
        if (JC_cred != null) {
            if (JC_cred.userPrincipal == null) {
                JC_cred.authenticate(realm, request);
            } else if (!realm.reauthenticate(JC_cred.userPrincipal)) {
                JC_cred.userPrincipal = null;
            }
            if (JC_cred.userPrincipal != null) {
                Logger.debug("JC Authenticated for " + JC_cred.userPrincipal.getName());
                request.setAuthType(this.authMethod);
                request.setUserPrincipal(JC_cred.userPrincipal);
                return JC_cred.userPrincipal;
            }
            session.setAttribute(JC_AUTHENTICATED, null);
        }
        if (this.isLoginOrErrorPage(pathInContext)) {
            return SecurityHandler.__NOBODY;
        }
        if (response != null) {
            Vector<String> authorizedRoles = request.getAuthorizedRoles();
            session.setAttribute(JC_AUTHORIZED_ROLES, authorizedRoles);
            if (request.getQueryString() != null) {
                uri = uri + "?" + request.getQueryString();
            }
            session.setAttribute(JC_URI, request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + URIUtil.addPaths(request.getContextPath(), uri));
            response.setContentLength(0);
            response.sendRedirect(response.encodeRedirectURL(URIUtil.addPaths(request.getContextPath(), this.formLoginPage)));
        }
        return null;
    }

    public boolean isLoginOrErrorPage(String pathInContext) {
        return pathInContext != null && (pathInContext.equals(this.formErrorPath) || pathInContext.equals(this.formLoginPath));
    }

    private static class JCCredential
    implements HttpSessionBindingListener {
        String jcUserName;
        Object jcCredential;
        transient Principal userPrincipal;
        transient UserRealm realm;
        transient String authMethod;

        private JCCredential() {
        }

        void authenticate(UserRealm realm, String user, Object credential, Request request, String authMethod) {
            this.jcUserName = user;
            this.jcCredential = credential;
            this.authMethod = authMethod;
            this.userPrincipal = realm.authenticate(user, this.jcCredential, request, authMethod);
            if (this.userPrincipal != null) {
                this.realm = realm;
            }
        }

        void authenticate(UserRealm realm, Request request) {
            this.userPrincipal = realm.authenticate(this.jcUserName, this.jcCredential, request, this.authMethod);
            if (this.userPrincipal != null) {
                this.realm = realm;
            }
        }

        @Override
        public void valueBound(HttpSessionBindingEvent event) {
        }

        @Override
        public void valueUnbound(HttpSessionBindingEvent event) {
            Logger.debug("Logout " + this.jcUserName);
            if (this.realm != null && this.userPrincipal != null) {
                this.realm.logout(this.userPrincipal);
            }
        }

        public int hashCode() {
            return this.jcUserName.hashCode() + this.jcCredential.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof JCCredential)) {
                return false;
            }
            JCCredential fc = (JCCredential)o;
            return this.jcUserName.equals(fc.jcUserName) && this.jcCredential.equals(fc.jcCredential);
        }

        public String toString() {
            return "Cred[" + this.jcUserName + "]";
        }
    }
}

