/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.util;

import com.sun.javacard.ClassLoader;
import com.sun.javacard.ClassicLibraryClassLoader;
import com.sun.javacard.ContextManager;
import com.sun.javacard.Logger;
import com.sun.javacard.appletcontainer.APDUDispatcher;
import com.sun.javacard.cm.impl.ApplicationBundleImpl;
import com.sun.javacard.cm.impl.ApplicationImpl;
import com.sun.javacard.cm.impl.ApplicationModule;
import com.sun.javacard.cm.impl.jcad.JCPlatformAppDesc;
import com.sun.javacard.cm.impl.jcrd.ClientRole;
import com.sun.javacard.cm.impl.jcrd.JCRuntimeDesc;
import com.sun.javacard.cm.impl.jcrd.ModuleInfo;
import com.sun.javacard.cm.impl.jcrd.UserRole;
import com.sun.javacard.cm.impl.wad.WebAppDesc;
import com.sun.javacard.cm.registries.SecureCommunicationInfoRegistry;
import com.sun.javacard.impl.AppletMgr;
import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.jcre.JCRuntime;
import com.sun.javacard.spi.cardmgmt.Application;
import com.sun.javacard.spi.security.ProtectionDomain;
import com.sun.javacard.util.APDUUtil;
import com.sun.javacard.util.PathLookupTable;
import com.sun.javacard.util.URIUtils;
import com.sun.midp.pki.X509Certificate;
import java.security.AccessControlException;
import java.security.Permission;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javacard.framework.AID;
import javacard.framework.Applet;
import javacard.framework.Shareable;
import javacard.framework.SystemException;
import javacard.security.CryptoException;
import javacard.security.Key;
import javacard.security.Signature;
import javacardx.facilities.EventNotificationListener;
import javacardx.facilities.ServiceFactory;
import javacardx.facilities.ServiceRegistry;
import javacardx.framework.Authenticator;
import javacardx.framework.ClassicSIOProxy;
import javacardx.security.CredentialManager;
import javacardx.spi.security.CryptoProvider;
import javax.microedition.pki.Certificate;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.WebConnector;
import org.mortbay.jetty.WebServer;
import org.mortbay.jetty.security.SslSocketConnector;

public class JCSystemAccessor {
    static JCSystemAccessor instance;
    private PathLookupTable<ServiceFactory> serviceRegistryLink;
    private PathLookupTable<EventNotificationListener> eventRegistryLink;

    public static void instantiateJCSystemAccessor() {
        if (instance == null) {
            instance = new JCSystemAccessor();
            NativeMethods.setJCREentry(instance, false);
        }
    }

    private JCSystemAccessor() {
    }

    public static JCSystemAccessor getJCSystemAccessor() {
        return instance;
    }

    public int getContextIdForAppURI(String appURI) throws IllegalArgumentException {
        ApplicationImpl app = (ApplicationImpl)Application.lookup(appURI);
        if (app == null) {
            throw new IllegalArgumentException();
        }
        return ((ApplicationBundleImpl)app.getApplicationGroup()).getFirewallId();
    }

    public int getAppIdForAppURI(String appURI) {
        int appId = ApplicationImpl.lookupApplicationId(appURI);
        if (appId == -1) {
            throw new IllegalArgumentException();
        }
        return appId;
    }

    public ProtectionDomain getPDForApp(String appURI) {
        ApplicationBundleImpl appBImpl = null;
        Application app = Application.lookup(appURI);
        if (app == null) {
            throw new IllegalArgumentException();
        }
        appBImpl = (ApplicationBundleImpl)app.getApplicationGroup();
        if (appBImpl != null) {
            ProtectionDomain pd = appBImpl.getJCContext().getProtectionDomain();
            return pd;
        }
        return null;
    }

    public String getBaseAppURI(int currentFwId, String uri) {
        if (!URIUtils.hasScheme(uri) && !uri.startsWith("/")) {
            return null;
        }
        if (URIUtils.isInStandardNamespace(uri = URIUtils.normalize(uri))) {
            return null;
        }
        Enumeration<Application> apps = ApplicationBundleImpl.getBundleForFwId(currentFwId).getApplications();
        while (apps.hasMoreElements()) {
            ApplicationImpl app = (ApplicationImpl)apps.nextElement();
            String appURI = app.getAppURI();
            if (!URIUtils.isInNamespace(uri, appURI)) continue;
            return appURI;
        }
        throw new IllegalArgumentException("URI not from same application group");
    }

    public boolean isContextInRedirectTable(String appContext) {
        return SecureCommunicationInfoRegistry.isContextInRedirectTable(appContext);
    }

    public boolean isContextInStaticRedirectTable(String appContext) {
        return SecureCommunicationInfoRegistry.isContextInStaticRedirectTable(appContext);
    }

    public boolean isContextInDynamicRedirectTable(String appContext) {
        return SecureCommunicationInfoRegistry.isContextInDynamicRedirectTable(appContext);
    }

    public void addToRedirectTable(String context, WebConnector conn) {
        SecureCommunicationInfoRegistry.addToRedirectTable(context, conn);
    }

    public void addToDynamicRedirectTable(String context, WebConnector conn) {
        SecureCommunicationInfoRegistry.addToDynamicRedirectTable(context, conn);
    }

    public void addToPortMap(int port, ApplicationImpl application) {
        SecureCommunicationInfoRegistry.addToPortMap(port, application);
    }

    public int getPortFromContext(String appContext) {
        return SecureCommunicationInfoRegistry.getPortFromContext(appContext);
    }

    public ApplicationImpl getApplicationFromPortMap(int port) {
        return SecureCommunicationInfoRegistry.getApplicationFromPortMap(port);
    }

    public String getAppURIFromPortMap(int port) {
        ApplicationImpl app = this.getApplicationFromPortMap(port);
        if (app != null) {
            return app.getAppURI();
        }
        return null;
    }

    public String getAppProperty(String appURI, String propName) {
        ApplicationImpl app = (ApplicationImpl)Application.lookup(appURI);
        return app.getAppProperty(propName);
    }

    public String getURI(int appId) {
        return ApplicationImpl.getAppURIForAppId(appId);
    }

    public int getCurrentThreadPriority() {
        return Thread.currentThread().getPriority();
    }

    public void interruptThread(Thread th) {
        th.interrupt();
    }

    public Locale createDefaultLocale() {
        int i;
        String language = JCRuntime.getProperty("user.language", "en");
        String region = JCRuntime.getProperty("user.region", null);
        String country = region != null ? ((i = region.indexOf(95)) >= 0 ? region.substring(0, i) : region) : JCRuntime.getProperty("user.country", "");
        Locale defaultLocale = new Locale(language, country);
        NativeMethods.setJCREentry(defaultLocale, false);
        return defaultLocale;
    }

    public boolean isClientInRole(String appURI, String srvURI, String clientURI, String role, String rsrcURI) {
        Vector<String> credAliasesVector;
        ApplicationImpl srvApp = (ApplicationImpl)Application.lookup(appURI);
        ModuleInfo srvModuleInfo = srvApp.getModuleInfo();
        ClientRole srvOnCardClientRole = srvModuleInfo.getClientRoleByRoleName(role);
        if (srvOnCardClientRole == null) {
            return false;
        }
        Vector<String> clientURIs = srvOnCardClientRole.getClientURIs();
        if (clientURIs != null) {
            for (String uri : clientURIs) {
                if (!URIUtils.isAIDBasedURI(uri)) {
                    int ndx;
                    String s;
                    if (uri.equals(clientURI)) {
                        Logger.debug("###  isClientInRoleImpl: ClientURI matched server's JCRD Client URIs = " + uri + " ###\n");
                        return true;
                    }
                    if (!uri.endsWith("/*") || !clientURI.startsWith(s = uri.substring(0, ndx = uri.length() - 1)) || clientURI.length() < uri.length()) continue;
                    return true;
                }
                if (!uri.equalsIgnoreCase(clientURI)) continue;
                Logger.debug("###  isClientInRoleImpl: ClientURI matched server's JCRD Client URIs = " + uri + " ###\n");
                return true;
            }
        }
        ApplicationImpl clientApp = (ApplicationImpl)Application.lookup(clientURI);
        Vector<String> clientDNs = srvOnCardClientRole.getProtectionDomains();
        if (clientDNs != null) {
            ProtectionDomain clientDomain = ((ApplicationBundleImpl)clientApp.getApplicationGroup()).doGetProtectionDomain();
            for (String dn : clientDNs) {
                if (!clientDomain.isBoundToDomain(dn)) continue;
                Logger.debug("###  isClientInRoleImpl: Client domain name matched server's JCRD Client PDs = " + dn + " ###\n");
                return true;
            }
        }
        if ((credAliasesVector = srvOnCardClientRole.getAuthCredentials()) == null) {
            return false;
        }
        String duration = srvOnCardClientRole.getCredentialAuthDuration();
        if (duration == null) {
            duration = srvModuleInfo.getOnCardClientsCredentialAuthDuration();
        }
        if (!duration.equals("access") && srvApp.isClientAlreadyAuthorized(role, clientApp)) {
            return true;
        }
        CredentialManager srvCM = this.lookupCredentialManager(srvURI, (byte)5);
        if (srvCM == null) {
            return false;
        }
        CredentialManager clientCM = this.lookupCredentialManager(clientURI, (byte)4);
        if (clientCM == null) {
            return false;
        }
        Object[] credAliases = null;
        if (credAliasesVector != null) {
            credAliases = new String[credAliasesVector.size()];
            credAliasesVector.copyInto(credAliases);
        }
        NativeMethods.transferOwnershipUsingSecondObject(credAliases, srvCM);
        rsrcURI = new String(rsrcURI);
        NativeMethods.transferOwnershipUsingSecondObject(rsrcURI, srvCM);
        Object[] trustedCredentials = srvCM.getTrustedCredentials((String[])credAliases, rsrcURI, (byte)5);
        if (trustedCredentials == null) {
            return false;
        }
        Key[] srvTrustedKeys = new Key[trustedCredentials.length];
        try {
            srvTrustedKeys = this.getKeys(trustedCredentials);
        }
        catch (Exception e) {
            return false;
        }
        String[] srvTrustedKeysKeyTypes = this.getKeyTypes(srvTrustedKeys);
        NativeMethods.transferOwnershipUsingSecondObject(srvTrustedKeysKeyTypes, clientCM);
        rsrcURI = new String(rsrcURI);
        NativeMethods.transferOwnershipUsingSecondObject(rsrcURI, clientCM);
        Key[] clientKeys = clientCM.getCredentials(srvTrustedKeysKeyTypes, rsrcURI, (byte)4);
        if (clientKeys == null) {
            return false;
        }
        for (Key clientKey : clientKeys) {
            for (Key srvKey : srvTrustedKeys) {
                String sigAlgo = this.canBePaired(srvKey, clientKey);
                if (sigAlgo == null || !this.isKeyPairMatched(srvKey, clientKey, sigAlgo)) continue;
                if (!duration.equals("access")) {
                    srvApp.cacheClientAuthorization(role, clientApp, duration.equals("card-session"));
                }
                return true;
            }
        }
        return false;
    }

    private Key[] getKeys(Object[] credentials) throws Exception {
        Key[] keys = new Key[credentials.length];
        int index = 0;
        for (Object credential : credentials) {
            keys[index++] = credential instanceof Certificate ? ((X509Certificate)credential).getPublicKey() : (Key)credential;
        }
        return keys;
    }

    private String[] getKeyTypes(Key[] keys) {
        Vector<String> keyTypes = new Vector<String>(8);
        for (Key key : keys) {
            if (key.getTypeName().equals("DES") || key.getTypeName().startsWith("DES_")) {
                keyTypes.addElement("DES");
                continue;
            }
            if (key.getTypeName().equals("AES") || key.getTypeName().startsWith("AES_")) {
                keyTypes.addElement("AES");
                continue;
            }
            if (key.getTypeName().equals("KOREAN_SEED") || key.getTypeName().startsWith("KOREAN_SEED_")) {
                keyTypes.addElement("KOREAN_SEED");
                continue;
            }
            if (key.getTypeName().equals("HMAC") || key.getTypeName().startsWith("HMAC_")) {
                keyTypes.addElement("HMAC");
                continue;
            }
            if (key.getTypeName().equals("RSA_PUBLIC")) {
                keyTypes.addElement("RSA_PRIVATE");
                continue;
            }
            if (key.getTypeName().equals("DSA_PUBLIC")) {
                keyTypes.addElement("DSA_PRIVATE");
                continue;
            }
            if (key.getTypeName().equals("EC_F2M_PUBLIC")) {
                keyTypes.addElement("EC_F2M_PRIVATE");
                continue;
            }
            if (!key.getTypeName().equals("EC_FP_PUBLIC")) continue;
            keyTypes.addElement("EC_FP_PRIVATE");
        }
        Object[] _keyTypes = new String[keyTypes.size()];
        keyTypes.copyInto(_keyTypes);
        return _keyTypes;
    }

    private boolean isKeyPairMatched(Key srvKey, Key clientKey, String sigAlgo) {
        byte[] origTxt = "client apps authentication".getBytes();
        try {
            byte[] signature = new byte[origTxt.length * 2];
            Signature sig = (Signature)CryptoProvider.getAlgorithmImpl(sigAlgo, false);
            sig.init(clientKey, (byte)1);
            short sigLen = sig.sign(origTxt, (short)0, (short)origTxt.length, signature, (short)0);
            sig.init(srvKey, (byte)2);
            if (sig.verify(origTxt, (short)0, (short)origTxt.length, signature, (short)0, sigLen)) {
                Logger.debug("### Key pair is matched ###");
                return true;
            }
            Logger.debug("### Key pair is NOT matched ###");
            return false;
        }
        catch (CryptoException ce) {
            Logger.debug("isKeyPairMatched: " + ce);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private String canBePaired(Key srvKey, Key clientKey) {
        if (srvKey.getTypeName().equals("DES") || srvKey.getTypeName().startsWith("DES_")) {
            if (clientKey.getTypeName().equals("DES") || clientKey.getTypeName().startsWith("DES_")) {
                return "signature.DES_MAC8_ISO9797_M2";
            }
        } else if (srvKey.getTypeName().equals("AES") || srvKey.getTypeName().startsWith("AES_")) {
            if (clientKey.getTypeName().equals("AES") || clientKey.getTypeName().startsWith("AES_")) {
                return "signature.AES_MAC_128_NOPAD";
            }
        } else if (srvKey.getTypeName().equals("KOREAN_SEED") || srvKey.getTypeName().startsWith("KOREAN_SEED_")) {
            if (clientKey.getTypeName().equals("KOREAN_SEED") || clientKey.getTypeName().startsWith("KOREAN_SEED_")) {
                return "signature.KOREAN_SEED_MAC_NOPAD";
            }
        } else if (srvKey.getTypeName().equals("HMAC") || srvKey.getTypeName().startsWith("HMAC_")) {
            if (clientKey.getTypeName().equals("HMAC") || clientKey.getTypeName().startsWith("HMAC_")) {
                return "signature.HMAC_MD5";
            }
        } else if (srvKey.getTypeName().equals("RSA_PUBLIC")) {
            if (clientKey.getTypeName().equals("RSA_PRIVATE") || clientKey.getTypeName().startsWith("RSA_PRIVATE_")) {
                return "signature.RSA_SHA_PKCS1";
            }
        } else if (srvKey.getTypeName().equals("DSA_PUBLIC")) {
            if (clientKey.getTypeName().equals("DSA_PRIVATE") || clientKey.getTypeName().startsWith("DSA_PRIVATE_")) {
                return "signature.DSA_SHA";
            }
        } else if (srvKey.getTypeName().equals("EC_F2M_PUBLIC") ? clientKey.getTypeName().equals("EC_F2M_PRIVATE") || clientKey.getTypeName().startsWith("EC_F2M_PRIVATE_") : srvKey.getTypeName().equals("EC_FP_PUBLIC") && (clientKey.getTypeName().equals("EC_FP_PRIVATE") || clientKey.getTypeName().startsWith("EC_FP_PRIVATE_"))) {
            return "signature.ECDSA_SHA";
        }
        return null;
    }

    public boolean isUserInRole(String appURI, String role) {
        ApplicationImpl app = (ApplicationImpl)Application.lookup(appURI);
        ModuleInfo moduleInfo = app.getModuleInfo();
        UserRole userRole = moduleInfo.getUserRoleByRoleName(role);
        if (userRole == null) {
            return false;
        }
        Vector<String> authURIs = userRole.getAuthURIs();
        if (authURIs == null) {
            return false;
        }
        Request curRequest = ContextManager.getCurrentRequest();
        String curUserId = curRequest.getRemoteUser();
        if (curUserId != null) {
            Logger.debug("### Current user identity = " + curUserId + " ###\n");
            for (String uri : authURIs) {
                if (!uri.startsWith("sio:///standard/auth/user/session/") && !uri.startsWith("sio:///standard/auth/holder/session/") || uri.indexOf(curUserId) == -1) continue;
                Logger.debug("###  TRY_SESSION ### URI = " + uri + " ###\n");
                return true;
            }
        }
        Logger.debug("### TRY_GLOBAL ###\n");
        for (String uri : authURIs) {
            if (!uri.startsWith("sio:///standard/auth/holder/global/")) continue;
            Logger.debug("### TRY_GLOBAL ### URI = " + uri + " ###\n");
            Shareable auth = ServiceRegistry.getServiceRegistry().lookup(uri);
            if (auth == null || !(auth instanceof Authenticator)) continue;
            return ((Authenticator)auth).isValidated();
        }
        return false;
    }

    public CredentialManager lookupCredentialManager(String appURI, byte mode) {
        ApplicationImpl app = (ApplicationImpl)Application.lookup(appURI);
        if (app == null) {
            return null;
        }
        CredentialManager cm = app.getCredentialManager(mode);
        if (cm == null) {
            cm = app.getCredentialManager(0);
        }
        if (cm == null) {
            cm = ((ApplicationBundleImpl)app.getApplicationGroup()).doGetCredentialManager();
        }
        return cm;
    }

    public CredentialManager.SecurityRequirements lookupSecurityRequirements(String appURI, byte mode) {
        ApplicationImpl app = (ApplicationImpl)Application.lookup(appURI);
        if (app == null) {
            return null;
        }
        CredentialManager.SecurityRequirements sr = app.getSecurityRequirements(mode);
        if (sr == null) {
            sr = app.getSecurityRequirements(0);
        }
        if (sr == null) {
            sr = ((ApplicationBundleImpl)app.getApplicationGroup()).doGetSecurityRequirements();
        }
        return sr;
    }

    public CredentialManager getCredentialManager(String appURI, byte mode) {
        ApplicationImpl app = (ApplicationImpl)Application.lookup(appURI);
        if (app == null) {
            return null;
        }
        return app.getCredentialManager(mode);
    }

    public CredentialManager.SecurityRequirements getSecurityRequirements(String appURI, byte mode) {
        ApplicationImpl app = (ApplicationImpl)Application.lookup(appURI);
        if (app == null) {
            return null;
        }
        return app.getSecurityRequirements(mode);
    }

    public void setCredentialManager(String appURI, CredentialManager manager, byte mode) {
        ApplicationImpl app = (ApplicationImpl)Application.lookup(appURI);
        if (app == null) {
            return;
        }
        app.setCredentialManager(manager, mode);
    }

    public void setSecurityRequirements(String appURI, CredentialManager.SecurityRequirements requirements, byte mode) {
        ApplicationImpl app = (ApplicationImpl)Application.lookup(appURI);
        if (app == null) {
            return;
        }
        app.setSecurityRequirements(requirements, mode);
    }

    public boolean isClientAuthRequired(int firewallId, String endpointURI, byte mode) {
        ApplicationBundleImpl appBImpl = null;
        if (firewallId != -1) {
            appBImpl = ApplicationBundleImpl.getBundleForFwId(firewallId);
        }
        if (appBImpl == null) assert (false) : "Error looking up current application bundle.";
        if (appBImpl.getType() != 10) {
            return false;
        }
        JCRuntimeDesc jcrd = appBImpl.getJcrd();
        ModuleInfo moduleInfo = jcrd.getModule("");
        return moduleInfo.isWebClientAuthRequired();
    }

    public boolean isIntegrityRequired(int firewallId, String endpointURI, byte mode) {
        ApplicationBundleImpl appBImpl = null;
        if (firewallId != -1) {
            appBImpl = ApplicationBundleImpl.getBundleForFwId(firewallId);
        }
        if (appBImpl == null) assert (false) : "Error looking up current application bundle.";
        if (appBImpl.getType() != 10) {
            return false;
        }
        ApplicationModule appModule = appBImpl.getAppModule("");
        WebAppDesc webAppDesc = appModule.getWebAppDesc();
        return webAppDesc.isIntegrityRequired();
    }

    public boolean isConfidentialityRequired(int firewallId, String endpointURI, byte mode) {
        ApplicationBundleImpl appBImpl = null;
        if (firewallId != -1) {
            appBImpl = ApplicationBundleImpl.getBundleForFwId(firewallId);
        }
        if (appBImpl == null) assert (false) : "Error looking up current application bundle.";
        if (appBImpl.getType() != 10) {
            return false;
        }
        ApplicationModule appModule = appBImpl.getAppModule("");
        WebAppDesc webAppDesc = appModule.getWebAppDesc();
        return webAppDesc.isConfidentialityRequired();
    }

    public int startNewConnector(String appURI) {
        int port;
        block2: {
            port = -1;
            SslSocketConnector conn = new SslSocketConnector();
            conn.setPort(port);
            this.addToDynamicRedirectTable(appURI, conn);
            WebServer webServer = WebServer.getWebServer();
            webServer.addDynamicConnector(conn);
            try {
                conn.start();
                port = conn.getLocalPort();
                ApplicationImpl appImpl = (ApplicationImpl)Application.lookup(appURI);
                this.addToPortMap(port, appImpl);
            }
            catch (Throwable e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"Unexpected failure starting SSL.");
            }
        }
        return port;
    }

    public int startNewConnector(ApplicationImpl appImpl, int port) {
        block2: {
            SslSocketConnector conn = new SslSocketConnector();
            conn.setPort(port);
            this.addToRedirectTable(appImpl.getAppURI(), conn);
            WebServer webServer = WebServer.getWebServer();
            webServer.addConnector(conn);
            try {
                conn.start();
                this.addToPortMap(port, appImpl);
            }
            catch (Throwable e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"Unexpected failure starting SSL.");
            }
        }
        return port;
    }

    public void checkPermissionHelper(String uri, Permission perm) throws AccessControlException {
        ApplicationBundleImpl appBImpl = null;
        Application app = Application.lookup(uri);
        appBImpl = (ApplicationBundleImpl)app.getApplicationGroup();
        if (appBImpl == null) assert (false) : "Error looking up current application.";
        ProtectionDomain pd = appBImpl.getJCContext().getProtectionDomain();
        if (!pd.implies(perm)) {
            throw new AccessControlException("permission not granted" + perm);
        }
    }

    public Vector<String> getDynamicallyLoadedClassList(String appURI) {
        Vector<String> classList;
        Application app = Application.lookup(appURI);
        ApplicationBundleImpl appBundle = (ApplicationBundleImpl)app.getApplicationGroup();
        ApplicationModule appModule = appBundle.getAppModule(app.getModuleName());
        JCPlatformAppDesc jcad = appModule.getJCAppDesc();
        Vector<String> vector = classList = jcad != null ? jcad.getDynamicallyLoadedClasses() : null;
        if (classList != null) {
            NativeMethods.transferOwnershipToPreviousContext(classList);
        }
        return classList;
    }

    public boolean isAppClassic(AID appAID) {
        String appURI = APDUUtil.getURIForAID(appAID);
        return this.isAppClassic(appURI);
    }

    public boolean isAppClassic(String appURI) {
        Application app = Application.lookup(appURI);
        if (app == null) {
            return false;
        }
        return app.getType() == 12;
    }

    public boolean isAppWebApp(String appURI) {
        return Application.lookup(appURI).getType() == 10;
    }

    public boolean isAppExtendedApplet(String appURI) {
        return Application.lookup(appURI).getType() == 11;
    }

    public void setServiceRegistry(PathLookupTable<ServiceFactory> registry) {
        this.serviceRegistryLink = registry;
    }

    public PathLookupTable<ServiceFactory> getServiceRegistry() {
        return this.serviceRegistryLink;
    }

    public void setEventRegistry(PathLookupTable<EventNotificationListener> registry) {
        this.eventRegistryLink = registry;
    }

    public PathLookupTable<EventNotificationListener> getEventRegistry() {
        return this.eventRegistryLink;
    }

    public void checkCODArrayCreation(int appId) {
        APDUDispatcher dispatcher;
        Thread ct = Thread.currentThread();
        if (ct instanceof APDUDispatcher && appId != (dispatcher = (APDUDispatcher)ct).getChannelManager().getCurrentAppID()) {
            throw new SystemException(3);
        }
    }

    public void checkAPDUObjectAccess(int currentAppId) throws SecurityException {
        Thread ct = Thread.currentThread();
        if (!(ct instanceof APDUDispatcher)) {
            throw new SecurityException();
        }
        APDUDispatcher dispatcher = (APDUDispatcher)ct;
        if (!dispatcher.inProcessMethod()) {
            throw new SecurityException();
        }
        String appURI = this.getURI(currentAppId);
        if (appURI == null) {
            throw new SecurityException();
        }
        AID appAID = APDUUtil.getAIDForURI(appURI);
        if (dispatcher.getChannelManager().getCurrentAppID() != currentAppId || AppletMgr.getAppStateForAppWithAID(appAID) != 2) {
            throw new SecurityException();
        }
    }

    public byte getAssignedChannelImpl() {
        Thread ct = Thread.currentThread();
        if (ct instanceof APDUDispatcher) {
            APDUDispatcher dispatcher = (APDUDispatcher)ct;
            return dispatcher.getChannelManager().getCurrentChannel();
        }
        return 0;
    }

    public String getURIImpl(AID aid) {
        if (aid == null) {
            throw new NullPointerException();
        }
        String uri = APDUUtil.getURIForAID(aid);
        if (Application.lookup(uri) == null) {
            return null;
        }
        return uri;
    }

    public Shareable processShareable(Shareable sio, boolean calledByClassicApp) {
        ClassicSIOProxy sioProxy = null;
        if (!(sio instanceof ClassicSIOProxy)) {
            return null;
        }
        sioProxy = (ClassicSIOProxy)((Object)sio);
        Shareable containedSIO = sioProxy.getSIO();
        String sioOwnerURI = this.getURI(NativeMethods.getObjectOwnerId(containedSIO));
        boolean sioOwnedByClassicApp = this.isAppClassic(sioOwnerURI);
        if (calledByClassicApp && sioOwnedByClassicApp) {
            return containedSIO;
        }
        if (!calledByClassicApp && !sioOwnedByClassicApp) {
            return containedSIO;
        }
        return (Shareable)((Object)sioProxy);
    }

    public ClassicSIOProxy proxyLookup(Shareable sio, boolean calledByJCRE, AID classicAppAID) throws InstantiationException {
        Applet classicApplet;
        ClassLoader appClassLoader = null;
        ClassicLibraryClassLoader classicLibraryClassLoader = null;
        String proxyAppPkgName = null;
        String proxyLibPkgName = null;
        if (calledByJCRE) {
            classicApplet = AppletMgr.findAppTableEntry((AID)classicAppAID).theApplet;
            String classicAppletPkgName = NativeMethods.getPkgNameForObject(classicApplet);
            proxyAppPkgName = classicAppletPkgName + "/proxy";
            String sioPkgName = NativeMethods.getPkgNameForObject(sio);
            appClassLoader = ApplicationBundleImpl.getBundleForFwId(NativeMethods.objectContext(classicApplet)).getClassLoader();
            if (!sioPkgName.equals(classicAppletPkgName)) {
                classicLibraryClassLoader = ClassicLibraryClassLoader.getClassicLibraryClassLoader();
                proxyLibPkgName = sioPkgName + "/proxy";
            }
        } else {
            classicApplet = AppletMgr.findAppletWithAppId(NativeMethods.getPreviousAppId());
            proxyAppPkgName = NativeMethods.getPkgNameForJCRECaller();
            appClassLoader = ApplicationBundleImpl.getBundleForFwId(NativeMethods.getPreviousContext()).getClassLoader();
        }
        String[] targetInterfaces = NativeMethods.getImplementedSIListForObject(sio);
        ClassicSIOProxy proxy = this.loadProxyClass(proxyAppPkgName, appClassLoader, targetInterfaces, classicApplet, sio);
        if (proxy == null && classicLibraryClassLoader != null) {
            proxy = this.loadProxyClass(proxyLibPkgName, classicLibraryClassLoader, targetInterfaces, classicApplet, sio);
        }
        return proxy;
    }

    private ClassicSIOProxy loadProxyClass(String proxyPkgName, ClassLoader proxyClassLoader, String[] targetInterfaces, Object classicApplet, Shareable sio) throws InstantiationException {
        ClassicSIOProxy proxy = this.findProxy(proxyPkgName, proxyClassLoader, targetInterfaces, true);
        if (proxy == null && (proxy = this.findProxy(proxyPkgName, proxyClassLoader, targetInterfaces, false)) == null) {
            return null;
        }
        NativeMethods.transferOwnershipUsingSecondObject(proxy, classicApplet);
        proxy.setSIO(sio);
        return proxy;
    }

    private ClassicSIOProxy findProxy(String pkgName, ClassLoader proxyPkgClassLoader, String[] targetInterfaces, boolean exactMatch) throws InstantiationException {
        int proxyClassCount = 1;
        while (true) {
            Class<?> klass;
            String proxyClassName = pkgName + "/Proxy" + proxyClassCount;
            try {
                proxyClassName = proxyClassName.replace('/', '.');
                NativeMethods.transferOwnershipUsingSecondObject(proxyClassName, proxyPkgClassLoader);
                klass = proxyPkgClassLoader.loadClass(proxyClassName);
            }
            catch (ClassNotFoundException e) {
                break;
            }
            String[] siListForProxy = NativeMethods.getImplementedSIListForClass(klass);
            if (siListForProxy == null) break;
            if (this.SIListsMatch(targetInterfaces, siListForProxy, exactMatch)) {
                try {
                    return (ClassicSIOProxy)klass.newInstance();
                }
                catch (Exception e) {
                    throw new InstantiationException();
                }
            }
            ++proxyClassCount;
        }
        return null;
    }

    private boolean SIListsMatch(String[] targetInterfaces, String[] proxyInterfaces, boolean exactMatch) {
        if (exactMatch && proxyInterfaces.length != targetInterfaces.length) {
            return false;
        }
        for (String interfaceName : targetInterfaces) {
            boolean nameMatch = false;
            for (String proxyInterfaceName : proxyInterfaces) {
                if (!interfaceName.equals(proxyInterfaceName)) continue;
                nameMatch = true;
                break;
            }
            if (nameMatch) continue;
            return false;
        }
        return true;
    }

    public Class<?> getClassForName(String className) throws ClassNotFoundException {
        return Class.forName(className);
    }
}

