/*
 * Decompiled with CFR 0.152.
 */
package javacard.security;

import com.sun.javacard.impl.JCCryptoAccessor;
import com.sun.javacard.util.JCSystemAccessor;
import javacard.security.CryptoException;
import javacard.security.Key;
import javacardx.framework.JCSystem;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class KeyBuilder {
    public static final String SERVICE_NAME = "keyBuilder";
    public static final byte TYPE_DES_TRANSIENT_RESET = 1;
    public static final byte TYPE_DES_TRANSIENT_DESELECT = 2;
    public static final byte TYPE_DES = 3;
    public static final byte TYPE_RSA_PUBLIC = 4;
    public static final byte TYPE_RSA_PRIVATE = 5;
    public static final byte TYPE_RSA_CRT_PRIVATE = 6;
    public static final byte TYPE_DSA_PUBLIC = 7;
    public static final byte TYPE_DSA_PRIVATE = 8;
    public static final byte TYPE_EC_F2M_PUBLIC = 9;
    public static final byte TYPE_EC_F2M_PRIVATE = 10;
    public static final byte TYPE_EC_FP_PUBLIC = 11;
    public static final byte TYPE_EC_FP_PRIVATE = 12;
    public static final byte TYPE_AES_TRANSIENT_RESET = 13;
    public static final byte TYPE_AES_TRANSIENT_DESELECT = 14;
    public static final byte TYPE_AES = 15;
    public static final byte TYPE_KOREAN_SEED_TRANSIENT_RESET = 16;
    public static final byte TYPE_KOREAN_SEED_TRANSIENT_DESELECT = 17;
    public static final byte TYPE_KOREAN_SEED = 18;
    public static final byte TYPE_HMAC_TRANSIENT_RESET = 19;
    public static final byte TYPE_HMAC_TRANSIENT_DESELECT = 20;
    public static final byte TYPE_HMAC = 21;
    public static final byte TYPE_RSA_PRIVATE_TRANSIENT_RESET = 22;
    public static final byte TYPE_RSA_PRIVATE_TRANSIENT_DESELECT = 23;
    public static final byte TYPE_RSA_CRT_PRIVATE_TRANSIENT_RESET = 24;
    public static final byte TYPE_RSA_CRT_PRIVATE_TRANSIENT_DESELECT = 25;
    public static final byte TYPE_DSA_PRIVATE_TRANSIENT_RESET = 26;
    public static final byte TYPE_DSA_PRIVATE_TRANSIENT_DESELECT = 27;
    public static final byte TYPE_EC_F2M_PRIVATE_TRANSIENT_RESET = 28;
    public static final byte TYPE_EC_F2M_PRIVATE_TRANSIENT_DESELECT = 29;
    public static final byte TYPE_EC_FP_PRIVATE_TRANSIENT_RESET = 30;
    public static final byte TYPE_EC_FP_PRIVATE_TRANSIENT_DESELECT = 31;
    public static final byte ALG_TYPE_DES = 1;
    public static final byte ALG_TYPE_AES = 2;
    public static final byte ALG_TYPE_DSA_PUBLIC = 3;
    public static final byte ALG_TYPE_DSA_PRIVATE = 4;
    public static final byte ALG_TYPE_EC_F2M_PUBLIC = 5;
    public static final byte ALG_TYPE_EC_F2M_PRIVATE = 6;
    public static final byte ALG_TYPE_EC_FP_PUBLIC = 7;
    public static final byte ALG_TYPE_EC_FP_PRIVATE = 8;
    public static final byte ALG_TYPE_HMAC = 9;
    public static final byte ALG_TYPE_KOREAN_SEED = 10;
    public static final byte ALG_TYPE_RSA_PUBLIC = 11;
    public static final byte ALG_TYPE_RSA_PRIVATE = 12;
    public static final byte ALG_TYPE_RSA_CRT_PRIVATE = 13;
    public static final short LENGTH_DES = 64;
    public static final short LENGTH_DES3_2KEY = 128;
    public static final short LENGTH_DES3_3KEY = 192;
    public static final short LENGTH_RSA_512 = 512;
    public static final short LENGTH_RSA_736 = 736;
    public static final short LENGTH_RSA_768 = 768;
    public static final short LENGTH_RSA_896 = 896;
    public static final short LENGTH_RSA_1024 = 1024;
    public static final short LENGTH_RSA_1280 = 1280;
    public static final short LENGTH_RSA_1536 = 1536;
    public static final short LENGTH_RSA_1984 = 1984;
    public static final short LENGTH_RSA_2048 = 2048;
    public static final short LENGTH_RSA_4096 = 4096;
    public static final short LENGTH_DSA_512 = 512;
    public static final short LENGTH_DSA_768 = 768;
    public static final short LENGTH_DSA_1024 = 1024;
    public static final short LENGTH_EC_FP_112 = 112;
    public static final short LENGTH_EC_F2M_113 = 113;
    public static final short LENGTH_EC_FP_128 = 128;
    public static final short LENGTH_EC_F2M_131 = 131;
    public static final short LENGTH_EC_FP_160 = 160;
    public static final short LENGTH_EC_F2M_163 = 163;
    public static final short LENGTH_EC_FP_192 = 192;
    public static final short LENGTH_EC_F2M_193 = 193;
    public static final short LENGTH_EC_FP_224 = 224;
    public static final short LENGTH_EC_FP_256 = 256;
    public static final short LENGTH_EC_FP_384 = 384;
    public static final short LENGTH_EC_FP_521 = 521;
    public static final short LENGTH_AES_128 = 128;
    public static final short LENGTH_AES_192 = 192;
    public static final short LENGTH_AES_256 = 256;
    public static final short LENGTH_KOREAN_SEED_128 = 128;
    public static final short LENGTH_HMAC_SHA_1_BLOCK_64 = 64;
    public static final short LENGTH_HMAC_SHA_256_BLOCK_64 = 64;
    public static final short LENGTH_HMAC_SHA_384_BLOCK_128 = 128;
    public static final short LENGTH_HMAC_SHA_512_BLOCK_128 = 128;
    private static JCCryptoAccessor cryptoAccessorInstance = JCCryptoAccessor.getInstance();

    private KeyBuilder() {
    }

    public static Key buildKey(byte keyType, short keyLength, boolean keyEncryption) throws CryptoException {
        Key key = null;
        switch (keyType) {
            case 1: {
                key = KeyBuilder.buildKey("DES_TRANSIENT_RESET", keyLength, keyEncryption);
                break;
            }
            case 2: {
                KeyBuilder.checkCallFromWebApp();
                key = KeyBuilder.buildKey("DES_TRANSIENT_DESELECT", keyLength, keyEncryption);
                break;
            }
            case 3: {
                key = KeyBuilder.buildKey("DES", keyLength, keyEncryption);
                break;
            }
            case 4: {
                key = KeyBuilder.buildKey("RSA_PUBLIC", keyLength, keyEncryption);
                break;
            }
            case 5: {
                key = KeyBuilder.buildKey("RSA_PRIVATE", keyLength, keyEncryption);
                break;
            }
            case 6: {
                key = KeyBuilder.buildKey("RSA_CRT_PRIVATE", keyLength, keyEncryption);
                break;
            }
            case 7: {
                key = KeyBuilder.buildKey("DSA_PUBLIC", keyLength, keyEncryption);
                break;
            }
            case 8: {
                key = KeyBuilder.buildKey("DSA_PRIVATE", keyLength, keyEncryption);
                break;
            }
            case 9: {
                key = KeyBuilder.buildKey("EC_F2M_PUBLIC", keyLength, keyEncryption);
                break;
            }
            case 10: {
                key = KeyBuilder.buildKey("EC_F2M_PRIVATE", keyLength, keyEncryption);
                break;
            }
            case 11: {
                key = KeyBuilder.buildKey("EC_FP_PUBLIC", keyLength, keyEncryption);
                break;
            }
            case 12: {
                key = KeyBuilder.buildKey("EC_FP_PRIVATE", keyLength, keyEncryption);
                break;
            }
            case 13: {
                key = KeyBuilder.buildKey("AES_TRANSIENT_RESET", keyLength, keyEncryption);
                break;
            }
            case 14: {
                KeyBuilder.checkCallFromWebApp();
                key = KeyBuilder.buildKey("AES_TRANSIENT_DESELECT", keyLength, keyEncryption);
                break;
            }
            case 15: {
                key = KeyBuilder.buildKey("AES", keyLength, keyEncryption);
                break;
            }
            case 16: {
                key = KeyBuilder.buildKey("KOREAN_SEED_TRANSIENT_RESET", keyLength, keyEncryption);
                break;
            }
            case 17: {
                KeyBuilder.checkCallFromWebApp();
                key = KeyBuilder.buildKey("KOREAN_SEED_TRANSIENT_DESELECT", keyLength, keyEncryption);
                break;
            }
            case 18: {
                key = KeyBuilder.buildKey("KOREAN_SEED", keyLength, keyEncryption);
                break;
            }
            case 19: {
                key = KeyBuilder.buildKey("HMAC_TRANSIENT_RESET", keyLength, keyEncryption);
                break;
            }
            case 20: {
                KeyBuilder.checkCallFromWebApp();
                key = KeyBuilder.buildKey("HMAC_TRANSIENT_DESELECT", keyLength, keyEncryption);
                break;
            }
            case 21: {
                key = KeyBuilder.buildKey("HMAC", keyLength, keyEncryption);
                break;
            }
            case 22: {
                key = KeyBuilder.buildKey("RSA_PRIVATE_TRANSIENT_RESET", keyLength, keyEncryption);
                break;
            }
            case 23: {
                KeyBuilder.checkCallFromWebApp();
                key = KeyBuilder.buildKey("RSA_PRIVATE_TRANSIENT_DESELECT", keyLength, keyEncryption);
                break;
            }
            case 24: {
                key = KeyBuilder.buildKey("RSA_CRT_PRIVATE_TRANSIENT_RESET", keyLength, keyEncryption);
                break;
            }
            case 25: {
                KeyBuilder.checkCallFromWebApp();
                key = KeyBuilder.buildKey("RSA_CRT_PRIVATE_TRANSIENT_DESELECT", keyLength, keyEncryption);
                break;
            }
            case 26: {
                key = KeyBuilder.buildKey("DSA_PRIVATE_TRANSIENT_RESET", keyLength, keyEncryption);
                break;
            }
            case 27: {
                KeyBuilder.checkCallFromWebApp();
                key = KeyBuilder.buildKey("DSA_PRIVATE_TRANSIENT_DESELECT", keyLength, keyEncryption);
                break;
            }
            case 28: {
                key = KeyBuilder.buildKey("EC_F2M_PRIVATE_TRANSIENT_RESET", keyLength, keyEncryption);
                break;
            }
            case 29: {
                KeyBuilder.checkCallFromWebApp();
                key = KeyBuilder.buildKey("EC_F2M_PRIVATE_TRANSIENT_DESELECT", keyLength, keyEncryption);
                break;
            }
            case 30: {
                key = KeyBuilder.buildKey("EC_FP_PRIVATE_TRANSIENT_RESET", keyLength, keyEncryption);
                break;
            }
            case 31: {
                KeyBuilder.checkCallFromWebApp();
                key = KeyBuilder.buildKey("EC_FP_PRIVATE_TRANSIENT_DESELECT", keyLength, keyEncryption);
                break;
            }
            default: {
                CryptoException.throwIt((short)3);
            }
        }
        return key;
    }

    public static Key buildKey(byte algorithmicKeyType, byte keyMemoryType, short keyLength, boolean keyEncryption) throws CryptoException {
        byte keyType = KeyBuilder.getKeyType(algorithmicKeyType, keyMemoryType);
        if (keyType == 0) {
            CryptoException.throwIt((short)3);
        }
        return KeyBuilder.buildKey(keyType, keyLength, keyEncryption);
    }

    private static byte getKeyType(byte algorithmicKeyType, byte keyMemoryType) {
        switch (algorithmicKeyType) {
            case 1: {
                switch (keyMemoryType) {
                    case 0: {
                        return 3;
                    }
                    case 2: {
                        return 2;
                    }
                    case 1: {
                        return 1;
                    }
                }
                return 0;
            }
            case 2: {
                switch (keyMemoryType) {
                    case 0: {
                        return 15;
                    }
                    case 2: {
                        return 14;
                    }
                    case 1: {
                        return 13;
                    }
                }
                return 0;
            }
            case 7: {
                if (keyMemoryType != 0) {
                    return 0;
                }
                return 11;
            }
            case 8: {
                if (keyMemoryType != 0) {
                    return 0;
                }
                return 12;
            }
            case 11: {
                if (keyMemoryType != 0) {
                    return 0;
                }
                return 4;
            }
            case 12: {
                if (keyMemoryType != 0) {
                    return 0;
                }
                return 5;
            }
        }
        return 0;
    }

    public static Key buildKey(String keyType, short keyLength, boolean keyEncryption) throws CryptoException {
        if (keyType == null) {
            throw new NullPointerException();
        }
        if (keyType.endsWith("_DESELECT")) {
            KeyBuilder.checkCallFromWebApp();
        }
        StringBuilder sb = new StringBuilder(SERVICE_NAME);
        sb.append(".");
        sb.append(keyType);
        sb.append(".");
        sb.append(keyLength);
        Object o = cryptoAccessorInstance.getAlgorithmImpl(sb.toString(), keyEncryption);
        if (o == null) {
            CryptoException.throwIt((short)3);
        }
        return (Key)o;
    }

    public static Key buildKey(String keyType, String provider, short keyLength, boolean keyEncryption) throws CryptoException {
        if (keyType == null || provider == null) {
            throw new NullPointerException();
        }
        if (keyType.endsWith("_DESELECT")) {
            KeyBuilder.checkCallFromWebApp();
        }
        StringBuilder sb = new StringBuilder(SERVICE_NAME);
        sb.append(".");
        sb.append(keyType);
        sb.append(".");
        sb.append(keyLength);
        Object o = cryptoAccessorInstance.getAlgorithmImpl(sb.toString(), provider, keyEncryption);
        if (o == null) {
            CryptoException.throwIt((short)3);
        }
        return (Key)o;
    }

    private static void checkCallFromWebApp() {
        String appURI = JCSystem.getURI();
        if (JCSystemAccessor.getJCSystemAccessor().isAppWebApp(appURI)) {
            CryptoException.throwIt((short)3);
        }
    }
}

