/*
 * Decompiled with CFR 0.152.
 */
package javacardx.framework;

import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.util.JCSystemAccessor;
import javacard.framework.Shareable;
import javacardx.framework.JCSystem;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
public abstract class ClassicSIOProxy {
    public static final Object CLASSIC_APPLET_CONTAINER_MUTEX = new Object();
    private static final ClassicSIOProxyHelper helper = new ClassicSIOProxyHelper();
    private Shareable actual;

    private static void flagIllegalCaller() {
        String myUri = JCSystem.getURI();
        if (myUri != null && !JCSystemAccessor.getJCSystemAccessor().isAppClassic(myUri)) {
            throw new SecurityException("Illegal ClassicSIOProxy access");
        }
    }

    public final Shareable getSIO() {
        ClassicSIOProxy.flagIllegalCaller();
        return this.actual;
    }

    public final void setSIO(Shareable sio) {
        ClassicSIOProxy.flagIllegalCaller();
        if (this.actual != null) {
            throw new IllegalStateException("ClassicSIOProxy.setSIO()");
        }
        this.actual = sio;
    }

    protected final Object processParam(Object obj) throws ClassNotFoundException, InstantiationException {
        return helper.processParamHelper(obj);
    }

    protected final Object processReturn(Object obj) throws ClassNotFoundException, InstantiationException {
        return helper.processReturnHelper(obj);
    }

    static {
        NativeMethods.allowMonitorEnter(CLASSIC_APPLET_CONTAINER_MUTEX);
        NativeMethods.setJCREentry(helper, false);
    }

    private static class ClassicSIOProxyHelper {
        private ClassicSIOProxyHelper() {
        }

        Object processReturnHelper(Object obj) throws ClassNotFoundException, InstantiationException {
            ClassicSIOProxy.flagIllegalCaller();
            if (obj == null) {
                return null;
            }
            if (obj instanceof Shareable[]) {
                throw new SecurityException("Attempt to use SIO array as Shareable parameter");
            }
            if (obj instanceof ClassicSIOProxy) {
                return ((ClassicSIOProxy)obj).actual;
            }
            if (obj instanceof Shareable) {
                return JCSystemAccessor.getJCSystemAccessor().proxyLookup((Shareable)obj, false, null);
            }
            return obj;
        }

        Object processParamHelper(Object obj) throws ClassNotFoundException, InstantiationException {
            ClassicSIOProxy.flagIllegalCaller();
            if (obj == null) {
                return null;
            }
            if (obj instanceof Shareable[]) {
                throw new SecurityException("Attempt to use SIO array as Shareable parameter");
            }
            if (obj instanceof ClassicSIOProxy) {
                return ((ClassicSIOProxy)obj).actual;
            }
            if (obj instanceof Shareable) {
                return JCSystemAccessor.getJCSystemAccessor().proxyLookup((Shareable)obj, false, null);
            }
            return obj;
        }
    }
}

