/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.IOException;
import java.io.InterruptedIOException;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javax.servlet.ServletInputStream;
import org.mortbay.io.Buffer;
import org.mortbay.io.BufferCache;
import org.mortbay.io.BufferUtil;
import org.mortbay.io.Buffers;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.EndPoint;
import org.mortbay.io.View;
import org.mortbay.jetty.EofException;
import org.mortbay.jetty.HttpException;
import org.mortbay.jetty.HttpHeaderValues;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.HttpMethods;
import org.mortbay.jetty.HttpVersions;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class HttpParser {
    public static final int STATE_START = -11;
    public static final int STATE_FIELD0 = -10;
    public static final int STATE_SPACE1 = -9;
    public static final int STATE_FIELD1 = -8;
    public static final int STATE_SPACE2 = -7;
    public static final int STATE_END0 = -6;
    public static final int STATE_END1 = -5;
    public static final int STATE_FIELD2 = -4;
    public static final int STATE_HEADER = -3;
    public static final int STATE_HEADER_NAME = -2;
    public static final int STATE_HEADER_VALUE = -1;
    public static final int STATE_END = 0;
    public static final int STATE_EOF_CONTENT = 1;
    public static final int STATE_CONTENT = 2;
    public static final int STATE_CHUNKED_CONTENT = 3;
    public static final int STATE_CHUNK_SIZE = 4;
    public static final int STATE_CHUNK_PARAMS = 5;
    public static final int STATE_CHUNK = 6;
    protected int state = -11;
    protected byte eol;
    protected int length;
    protected int contentLength;
    protected int contentPosition;
    protected int chunkLength;
    protected int chunkPosition;
    private Buffers buffers;
    EndPoint endp;
    private Buffer header;
    private Buffer body;
    private Buffer buffer;
    View contentView = new View();
    private int headerBufferSize;
    private int contentBufferSize;
    private EventHandler handler;
    private BufferCache.CachedBuffer cached;
    private View tok0;
    private View tok1;
    private String multiLineValue;
    private boolean response = false;

    public HttpParser(Buffer buffer, EventHandler handler) {
        this.header = buffer;
        this.buffer = buffer;
        this.handler = handler;
        if (buffer != null) {
            this.tok0 = new View(buffer);
            this.tok1 = new View(buffer);
            this.tok0.setPutIndex(this.tok0.getReadIndex());
            this.tok1.setPutIndex(this.tok1.getReadIndex());
        }
    }

    public HttpParser(Buffers buffers, EndPoint endp, EventHandler handler, int headerBufferSize, int contentBufferSize) {
        this.buffers = buffers;
        this.endp = endp;
        this.handler = handler;
        this.headerBufferSize = headerBufferSize;
        this.contentBufferSize = contentBufferSize;
    }

    public int getState() {
        return this.state;
    }

    public boolean isState(int state) {
        return this.state == state;
    }

    public void setState(int state) {
        this.state = state;
        this.contentLength = -3;
    }

    public boolean inHeaderState() {
        return this.state < 0;
    }

    public boolean inContentState() {
        return this.state > 0;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public boolean isChunking() {
        return this.contentLength == -2;
    }

    public String toString(Buffer buf) {
        return "state=" + this.state + " length=" + this.length + " buf=" + buf.hashCode();
    }

    public void parse() throws IOException {
        if (this.state == 0) {
            this.reset(false);
        }
        if (this.state != -11) {
            throw new IllegalStateException("!START");
        }
        while (this.state != 0) {
            this.parseNext();
        }
    }

    public long parseAvailable() throws IOException {
        long total;
        long len = this.parseNext();
        long l = total = len > 0L ? len : 0L;
        while (this.state != 0 && this.buffer != null && this.buffer.length() > 0) {
            len = this.parseNext();
            if (len <= 0L) continue;
            total += len;
        }
        return total;
    }

    public long parseNext() throws IOException {
        byte ch;
        long total_filled = -1L;
        if (this.buffer == null) {
            this.buffer = this.header = this.buffers.getBuffer(this.headerBufferSize);
            this.tok0 = new View(this.header);
            this.tok1 = new View(this.header);
            this.tok0.setPutIndex(this.tok0.getReadIndex());
            this.tok1.setPutIndex(this.tok1.getReadIndex());
        }
        if (this.state == 0) {
            throw new IllegalStateException("STATE_END");
        }
        if (this.state == 2 && this.contentPosition == this.contentLength) {
            this.state = 0;
            this.handler.messageComplete(this.contentPosition);
            return total_filled;
        }
        int length = this.buffer.length();
        if (length == 0) {
            int filled = -1;
            if (this.body != null && this.buffer != this.body) {
                this.buffer = this.body;
                filled = this.buffer.length();
            }
            if (this.buffer.getMarkIndex() == 0 && this.buffer.getWriteIndex() == this.buffer.capacity()) {
                throw new IOException("FULL");
            }
            if (this.endp != null && filled <= 0) {
                if (this.buffer == this.body) {
                    this.buffer.compact();
                }
                if (this.buffer.space() == 0) {
                    throw new IOException("FULL");
                }
                try {
                    if (total_filled < 0L) {
                        total_filled = 0L;
                    }
                    if ((filled = this.endp.fill(this.buffer)) > 0) {
                        total_filled += (long)filled;
                    }
                }
                catch (IOException e) {
                    this.reset(true);
                    throw e instanceof EofException ? e : new EofException(e);
                }
            }
            if (filled < 0 && this.state == 1) {
                this.state = 0;
                this.handler.messageComplete(this.contentPosition);
                return total_filled;
            }
            if (filled < 0) {
                this.reset(true);
                throw new EofException();
            }
            length = this.buffer.length();
        }
        byte[] array = this.buffer.array();
        while (this.state < 0 && length-- > 0) {
            ch = this.buffer.get();
            if (this.eol == 13 && ch == 10) {
                this.eol = (byte)10;
                continue;
            }
            this.eol = 0;
            switch (this.state) {
                case -11: {
                    this.contentLength = -3;
                    this.cached = null;
                    if (ch <= 32) break;
                    this.buffer.mark();
                    this.state = -10;
                    break;
                }
                case -10: {
                    if (ch == 32) {
                        this.tok0.update(this.buffer.getMarkIndex(), this.buffer.getReadIndex() - 1);
                        this.state = -9;
                        break;
                    }
                    if (ch >= 32) break;
                    throw new HttpException(400);
                }
                case -9: {
                    if (ch > 32) {
                        this.buffer.mark();
                        this.state = -8;
                        this.response = ch >= 49 && ch <= 53;
                        break;
                    }
                    if (ch >= 32) break;
                    throw new HttpException(400);
                }
                case -8: {
                    if (ch == 32) {
                        this.tok1.update(this.buffer.getMarkIndex(), this.buffer.getReadIndex() - 1);
                        this.state = -7;
                        break;
                    }
                    if (ch >= 32) break;
                    this.handler.startRequest(HttpMethods.CACHE.lookup(this.tok0), this.buffer.sliceFromMark(), null);
                    this.state = 0;
                    this.handler.headerComplete();
                    this.handler.messageComplete(this.contentPosition);
                    return total_filled;
                }
                case -7: {
                    if (ch > 32) {
                        this.buffer.mark();
                        this.state = -4;
                        break;
                    }
                    if (ch >= 32) break;
                    this.handler.startRequest(HttpMethods.CACHE.lookup(this.tok0), this.tok1, null);
                    this.state = 0;
                    this.handler.headerComplete();
                    this.handler.messageComplete(this.contentPosition);
                    return total_filled;
                }
                case -4: {
                    if (ch != 13 && ch != 10) break;
                    if (this.response) {
                        this.handler.startResponse(HttpVersions.CACHE.lookup(this.tok0), BufferUtil.toInt(this.tok1), this.buffer.sliceFromMark());
                    } else {
                        this.handler.startRequest(HttpMethods.CACHE.lookup(this.tok0), this.tok1, HttpVersions.CACHE.lookup(this.buffer.sliceFromMark()));
                    }
                    this.eol = ch;
                    this.state = -3;
                    this.tok0.setPutIndex(this.tok0.getReadIndex());
                    this.tok1.setPutIndex(this.tok1.getReadIndex());
                    this.multiLineValue = null;
                    return total_filled;
                }
                case -3: {
                    if (ch == 58 || ch == 32 || ch == 9) {
                        this.length = -1;
                        this.state = -1;
                        break;
                    }
                    if (this.cached != null || this.tok0.length() > 0 || this.tok1.length() > 0 || this.multiLineValue != null) {
                        BufferCache.CachedBuffer header = this.cached != null ? this.cached : HttpHeaders.CACHE.lookup(this.tok0);
                        this.cached = null;
                        Buffer value = this.multiLineValue == null ? this.tok1 : new ByteArrayBuffer(this.multiLineValue);
                        int ho = HttpHeaders.CACHE.getOrdinal(header);
                        if (ho >= 0) {
                            int vo = -1;
                            switch (ho) {
                                case 12: {
                                    if (this.contentLength == -2) break;
                                    this.contentLength = BufferUtil.toInt(value);
                                    if (this.contentLength > 0) break;
                                    this.contentLength = 0;
                                    break;
                                }
                                case 1: {
                                    value = HttpHeaderValues.CACHE.lookup(value);
                                    break;
                                }
                                case 5: {
                                    value = HttpHeaderValues.CACHE.lookup(value);
                                    vo = HttpHeaderValues.CACHE.getOrdinal(value);
                                    if (HttpHeaderValues.CHUNKED_ORDINAL == vo) {
                                        this.contentLength = -2;
                                        break;
                                    }
                                    String c = value.toString();
                                    if (c.endsWith("chunked")) {
                                        this.contentLength = -2;
                                        break;
                                    }
                                    if (c.indexOf("chunked") < 0) break;
                                    throw new HttpException(400, null);
                                }
                            }
                        }
                        this.handler.parsedHeader(header, value);
                        this.tok0.setPutIndex(this.tok0.getReadIndex());
                        this.tok1.setPutIndex(this.tok1.getReadIndex());
                        this.multiLineValue = null;
                    }
                    if (ch == 13 || ch == 10) {
                        if (this.contentLength == -3) {
                            this.contentLength = this.response ? -1 : 0;
                        }
                        this.contentPosition = 0;
                        this.eol = ch;
                        switch (this.contentLength) {
                            case -1: {
                                this.state = 1;
                                if (this.body == null && this.buffers != null) {
                                    this.body = this.buffers.getBuffer(this.contentBufferSize);
                                }
                                this.handler.headerComplete();
                                break;
                            }
                            case -2: {
                                this.state = 3;
                                if (this.body == null && this.buffers != null) {
                                    this.body = this.buffers.getBuffer(this.contentBufferSize);
                                }
                                this.handler.headerComplete();
                                break;
                            }
                            case 0: {
                                this.state = 0;
                                this.handler.headerComplete();
                                this.handler.messageComplete(this.contentPosition);
                                break;
                            }
                            default: {
                                this.state = 2;
                                if (this.buffers != null && this.body == null && this.buffer == this.header && this.contentLength >= this.header.capacity() - this.header.getReadIndex()) {
                                    this.body = this.buffers.getBuffer(this.contentBufferSize);
                                }
                                this.handler.headerComplete();
                            }
                        }
                        return total_filled;
                    }
                    this.length = 1;
                    this.buffer.mark();
                    this.state = -2;
                    if (array != null) {
                        this.cached = HttpHeaders.CACHE.getBest(array, this.buffer.getMarkIndex(), length + 1);
                    }
                    if (this.cached == null) break;
                    this.length = this.cached.length();
                    this.buffer.setGetIndex(this.buffer.getMarkIndex() + this.length);
                    length = this.buffer.length();
                    break;
                }
                case -2: {
                    if (ch == 13 || ch == 10) {
                        if (this.length > 0) {
                            this.tok0.update(this.buffer.getMarkIndex(), this.buffer.getMarkIndex() + this.length);
                        }
                        this.eol = ch;
                        this.state = -3;
                        break;
                    }
                    if (ch == 58) {
                        if (this.length > 0 && this.cached == null) {
                            this.tok0.update(this.buffer.getMarkIndex(), this.buffer.getMarkIndex() + this.length);
                        }
                        this.length = -1;
                        this.state = -1;
                        break;
                    }
                    if (ch == 32 || ch == 9) break;
                    if (this.length == -1) {
                        this.buffer.mark();
                    }
                    this.length = this.buffer.getReadIndex() - this.buffer.getMarkIndex();
                    break;
                }
                case -1: {
                    if (ch == 13 || ch == 10) {
                        if (this.length > 0) {
                            if (this.tok1.length() == 0) {
                                this.tok1.update(this.buffer.getMarkIndex(), this.buffer.getMarkIndex() + this.length);
                            } else {
                                if (this.multiLineValue == null) {
                                    this.multiLineValue = this.tok1.toString();
                                }
                                this.tok1.update(this.buffer.getMarkIndex(), this.buffer.getMarkIndex() + this.length);
                                this.multiLineValue = this.multiLineValue + " " + this.tok1.toString();
                            }
                        }
                        this.eol = ch;
                        this.state = -3;
                        break;
                    }
                    if (ch == 32 || ch == 9) break;
                    if (this.length == -1) {
                        this.buffer.mark();
                    }
                    this.length = this.buffer.getReadIndex() - this.buffer.getMarkIndex();
                }
            }
        }
        length = this.buffer.length();
        while (this.state > 0 && length > 0) {
            if (this.eol == 13 && this.buffer.peek() == 10) {
                this.eol = this.buffer.get();
                length = this.buffer.length();
                continue;
            }
            this.eol = 0;
            switch (this.state) {
                case 1: {
                    Buffer chunk = this.buffer.get(this.buffer.length());
                    this.contentPosition += chunk.length();
                    this.contentView.update(chunk);
                    this.handler.content(chunk);
                    return total_filled;
                }
                case 2: {
                    int remaining = this.contentLength - this.contentPosition;
                    if (remaining == 0) {
                        this.state = 0;
                        this.handler.messageComplete(this.contentPosition);
                        return total_filled;
                    }
                    if (length >= remaining) {
                        length = remaining;
                        this.state = 0;
                    }
                    Buffer chunk = this.buffer.get(length);
                    this.contentPosition += chunk.length();
                    this.contentView.update(chunk);
                    this.handler.content(chunk);
                    return total_filled;
                }
                case 3: {
                    ch = this.buffer.peek();
                    if (ch == 13 || ch == 10) {
                        this.eol = this.buffer.get();
                        break;
                    }
                    if (ch <= 32) {
                        this.buffer.get();
                        break;
                    }
                    this.chunkLength = 0;
                    this.chunkPosition = 0;
                    this.state = 4;
                    break;
                }
                case 4: {
                    ch = this.buffer.get();
                    if (ch == 13 || ch == 10) {
                        this.eol = ch;
                        if (this.chunkLength == 0) {
                            this.state = 0;
                            this.handler.messageComplete(this.contentPosition);
                            return total_filled;
                        }
                        this.state = 6;
                        break;
                    }
                    if (ch <= 32 || ch == 59) {
                        this.state = 5;
                        break;
                    }
                    if (ch >= 48 && ch <= 57) {
                        this.chunkLength = this.chunkLength * 16 + ch - 48;
                        break;
                    }
                    if (ch >= 97 && ch <= 102) {
                        this.chunkLength = this.chunkLength * 16 + 10 + ch - 97;
                        break;
                    }
                    if (ch >= 65 && ch <= 70) {
                        this.chunkLength = this.chunkLength * 16 + 10 + ch - 65;
                        break;
                    }
                    throw new IOException("bad chunk char: " + ch);
                }
                case 5: {
                    ch = this.buffer.get();
                    if (ch != 13 && ch != 10) break;
                    this.eol = ch;
                    if (this.chunkLength == 0) {
                        this.state = 0;
                        this.handler.messageComplete(this.contentPosition);
                        return total_filled;
                    }
                    this.state = 6;
                    break;
                }
                case 6: {
                    int remaining = this.chunkLength - this.chunkPosition;
                    if (remaining == 0) {
                        this.state = 3;
                        break;
                    }
                    if (length > remaining) {
                        length = remaining;
                    }
                    Buffer chunk = this.buffer.get(length);
                    this.contentPosition += chunk.length();
                    this.chunkPosition += chunk.length();
                    this.contentView.update(chunk);
                    this.handler.content(chunk);
                    return total_filled;
                }
            }
            length = this.buffer.length();
        }
        return total_filled;
    }

    public void reset(boolean returnBuffers) {
        this.state = -11;
        this.contentLength = -3;
        this.contentPosition = 0;
        this.length = 0;
        this.response = false;
        if (this.buffer != null && this.buffer.length() > 0 && this.eol == 13 && this.buffer.peek() == 10) {
            this.buffer.skip(1);
            this.eol = (byte)10;
        }
        if (this.body != null) {
            if (this.body.hasContent()) {
                this.header.setMarkIndex(-1);
                this.header.compact();
                this.body.skip(this.header.put(this.body));
            }
            if (this.body.length() == 0) {
                if (this.buffers != null && returnBuffers) {
                    this.buffers.returnBuffer(this.body);
                }
                this.body = null;
            } else {
                this.body.setMarkIndex(-1);
                this.body.compact();
            }
        }
        if (this.header != null) {
            this.header.setMarkIndex(-1);
            if (!this.header.hasContent() && this.buffers != null && returnBuffers) {
                this.buffers.returnBuffer(this.header);
                this.header = null;
                this.buffer = null;
            } else {
                this.header.compact();
                this.tok0.update(this.header);
                this.tok0.update(0, 0);
                this.tok1.update(this.header);
                this.tok1.update(0, 0);
            }
        }
        this.buffer = this.header;
    }

    Buffer getHeaderBuffer() {
        return this.header;
    }

    public static class Input
    extends ServletInputStream {
        protected HttpParser parser;
        protected EndPoint endp;
        protected long maxIdleTime;
        protected View view;

        public Input(HttpParser parser, long maxIdleTime) {
            this.parser = parser;
            this.endp = parser.endp;
            this.maxIdleTime = maxIdleTime;
            this.view = this.parser.contentView;
        }

        private boolean blockForContent() throws IOException {
            if (this.view.length() > 0) {
                return true;
            }
            if (this.parser.isState(0)) {
                return false;
            }
            if (this.endp == null) {
                this.parser.parseNext();
            } else if (this.endp.isBlocking()) {
                long filled = this.parser.parseNext();
                while (this.view.length() == 0 && filled != 0L && !this.parser.isState(0)) {
                    filled = this.parser.parseNext();
                }
            } else {
                long filled = this.parser.parseNext();
                boolean blocked = false;
                while (this.view.length() == 0 && !this.parser.isState(0)) {
                    if (filled > 0L) {
                        blocked = false;
                    } else if (filled == 0L) {
                        if (blocked) {
                            throw new InterruptedIOException("timeout");
                        }
                        blocked = true;
                        this.endp.blockReadable(this.maxIdleTime);
                    }
                    filled = this.parser.parseNext();
                }
            }
            return this.view.length() > 0;
        }

        @Override
        public int read() throws IOException {
            int c = -1;
            if (this.blockForContent()) {
                c = 0xFF & this.view.get();
            }
            return c;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int l = -1;
            if (this.blockForContent()) {
                l = this.view.get(b, off, len);
            }
            return l;
        }

        @Override
        public int available() throws IOException {
            return this.view.length();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.view.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.view.reset();
        }
    }

    public static abstract class EventHandler {
        public abstract void startRequest(Buffer var1, Buffer var2, Buffer var3) throws IOException;

        public abstract void startResponse(Buffer var1, int var2, Buffer var3) throws IOException;

        public void parsedHeader(Buffer name, Buffer value) {
        }

        public void headerComplete() throws IOException {
        }

        public abstract void content(Buffer var1) throws IOException;

        public void messageComplete(int contextLength) {
        }
    }
}

