/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.util.Enumeration;
import java.util.Hashtable;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.util.EmptyLists;
import org.mortbay.util.Loader;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class Holder
extends AbstractLifeCycle {
    protected transient Class<?> clazz;
    protected String className;
    protected String displayName;
    protected Hashtable<String, String> initParams;
    protected boolean extInstance;
    protected String name;
    protected ServletHandler servletHandler;

    protected Holder() {
    }

    protected Holder(Class<?> held) {
        this.clazz = held;
        if (held != null) {
            this.className = held.getName();
            this.name = held.getName();
        }
    }

    @Override
    public void doStart() throws Exception {
        if (this.clazz == null) {
            this.clazz = Loader.loadClass(Holder.class, this.className, null);
        }
    }

    @Override
    public void doStop() {
        if (!this.extInstance) {
            this.clazz = null;
        }
    }

    public String getClassName() {
        return this.className;
    }

    public Class<?> getHeldClass() {
        return this.clazz;
    }

    public String getDisplayName() {
        return this.name;
    }

    public String getInitParameter(String param) {
        if (this.initParams == null) {
            return null;
        }
        return this.initParams.get(param);
    }

    public Enumeration<String> getInitParameterNames() {
        if (this.initParams == null) {
            return EmptyLists.EMPTY_VECTOR.elements();
        }
        return this.initParams.keys();
    }

    public Hashtable<String, String> getInitParameters() {
        return this.initParams;
    }

    public String getName() {
        return this.name;
    }

    public ServletHandler getServletHandler() {
        return this.servletHandler;
    }

    public synchronized Object newInstance() throws InstantiationException, IllegalAccessException {
        if (this.clazz == null) {
            throw new InstantiationException("!" + this.className);
        }
        return this.clazz.newInstance();
    }

    public void setClassName(String className) {
        this.className = className;
        this.clazz = null;
    }

    public void setHeldClass(Class<?> held) {
        this.clazz = held;
        this.className = held != null ? held.getName() : null;
    }

    public void setDisplayName(String name) {
        this.name = name;
    }

    public void setInitParameter(String param, String value) {
        if (this.initParams == null) {
            this.initParams = new Hashtable(3);
        }
        this.initParams.put(param, value);
    }

    public void setInitParameters(Hashtable<String, String> map) {
        this.initParams = map;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setServletHandler(ServletHandler servletHandler) {
        this.servletHandler = servletHandler;
    }

    public String toString() {
        return this.name;
    }
}

