/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import com.sun.javacard.Logger;
import com.sun.javacard.file.FileConnection;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import org.mortbay.thread.BoundedThreadPool;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class IO
extends BoundedThreadPool {
    public static final String CRLF = "\r\n";
    public static final byte[] CRLF_BYTES = new byte[]{13, 10};
    public static final int bufferSize = 16384;
    static boolean OK = false;
    private static NullOS nullStream = new NullOS();
    private static NullWrite nullWriter = new NullWrite();

    public static IO getInstance() throws IOException {
        if (!OK) {
            throw new IOException("IO.java - static initialization failed");
        }
        return Singleton.instance;
    }

    public static void copyThread(InputStream in, OutputStream out) {
        try {
            Job job = new Job(in, out);
            if (!IO.getInstance().dispatch(job)) {
                job.run();
            }
        }
        catch (Exception e) {
            Logger.debug(e);
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        IO.copy(in, out, -1L);
    }

    public static void copyThread(Reader in, Writer out) {
        try {
            Job job = new Job(in, out);
            if (!IO.getInstance().dispatch(job)) {
                job.run();
            }
        }
        catch (Exception e) {
            Logger.debug(e);
        }
    }

    public static void copy(Reader in, Writer out) throws IOException {
        IO.copy(in, out, -1L);
    }

    public static void copy(InputStream in, OutputStream out, long byteCount) throws IOException {
        byte[] buffer = new byte[16384];
        int len = 16384;
        if (byteCount >= 0L) {
            while (byteCount > 0L && (len = byteCount < 16384L ? in.read(buffer, 0, (int)byteCount) : in.read(buffer, 0, 16384)) != -1) {
                byteCount -= (long)len;
                out.write(buffer, 0, len);
            }
        } else {
            while ((len = in.read(buffer, 0, 16384)) >= 0) {
                out.write(buffer, 0, len);
            }
        }
    }

    public static void copy(Reader in, Writer out, long byteCount) throws IOException {
        char[] buffer = new char[16384];
        int len = 16384;
        if (byteCount >= 0L) {
            while (byteCount > 0L && (len = byteCount < 16384L ? in.read(buffer, 0, (int)byteCount) : in.read(buffer, 0, 16384)) != -1) {
                byteCount -= (long)len;
                out.write(buffer, 0, len);
            }
        } else {
            while ((len = in.read(buffer, 0, 16384)) != -1) {
                out.write(buffer, 0, len);
            }
        }
    }

    public static String toString(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IO.copy(in, out);
        return new String(out.toByteArray());
    }

    public static boolean delete(FileConnection file) {
        boolean done = false;
        try {
            if (!file.exists()) {
                return false;
            }
            if (file.isDirectory()) {
                FileConnection[] files = file.listFiles();
                for (int i = 0; files != null && i < files.length; ++i) {
                    IO.delete(files[i]);
                }
            }
            done = file.delete();
        }
        catch (IOException e) {
            Logger.debug("fileConnection resulted in IOException");
            e.printStackTrace();
        }
        return done;
    }

    public static void close(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException e) {
            Logger.debug(e);
        }
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        IO.copy(in, bout);
        return bout.toByteArray();
    }

    public static void close(OutputStream os) {
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (IOException e) {
            Logger.debug(e);
        }
    }

    public static OutputStream getNullStream() {
        return nullStream;
    }

    public static Writer getNullWriter() {
        return nullWriter;
    }

    static class NullWrite
    extends Writer {
        NullWrite() {
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(char[] b) {
        }

        @Override
        public void write(char[] b, int o, int l) {
        }

        @Override
        public void write(int b) {
        }

        @Override
        public void write(String s) {
        }

        @Override
        public void write(String s, int o, int l) {
        }
    }

    static class NullOS
    extends OutputStream {
        NullOS() {
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(byte[] b) {
        }

        @Override
        public void write(byte[] b, int i, int l) {
        }

        @Override
        public void write(int b) {
        }
    }

    static class Job
    implements Runnable {
        InputStream in;
        OutputStream out;
        Reader read;
        Writer write;

        Job(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
            this.read = null;
            this.write = null;
        }

        Job(Reader read, Writer write) {
            this.in = null;
            this.out = null;
            this.read = read;
            this.write = write;
        }

        @Override
        public void run() {
            try {
                if (this.in != null) {
                    IO.copy(this.in, this.out, -1L);
                } else {
                    IO.copy(this.read, this.write, -1L);
                }
            }
            catch (IOException e) {
                Logger.debug(e);
                try {
                    if (this.out != null) {
                        this.out.close();
                    }
                    if (this.write != null) {
                        this.write.close();
                    }
                }
                catch (IOException e2) {
                    Logger.debug(e2);
                }
            }
        }
    }

    private static class Singleton {
        static final IO instance = new IO();

        private Singleton() {
        }

        static {
            Logger.debug("org.mortbay.jetty.IO.STATIC() -> ");
            try {
                instance.start();
                OK = true;
            }
            catch (Exception e) {
                Logger.debug(e);
            }
        }
    }
}

