/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import com.sun.javacard.Logger;
import java.io.IOException;
import java.io.InputStream;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class TypeUtil {
    public static final int CR = 13;
    public static final int LF = 10;

    public static int parseInt(String s, int offset, int length, int base) throws NumberFormatException {
        int value = 0;
        if (length < 0) {
            length = s.length() - offset;
        }
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(offset + i);
            int digit = c - 48;
            if (!(digit >= 0 && digit < base && digit < 10 || (digit = 10 + c - 65) >= 10 && digit < base)) {
                digit = 10 + c - 97;
            }
            if (digit < 0 || digit >= base) {
                throw new NumberFormatException(s.substring(offset, offset + length));
            }
            value = value * base + digit;
        }
        return value;
    }

    public static int parseInt(byte[] b, int offset, int length, int base) throws NumberFormatException {
        int value = 0;
        if (length < 0) {
            length = b.length - offset;
        }
        for (int i = 0; i < length; ++i) {
            char c = (char)(0xFF & b[offset + i]);
            int digit = c - 48;
            if (!(digit >= 0 && digit < base && digit < 10 || (digit = 10 + c - 65) >= 10 && digit < base)) {
                digit = 10 + c - 97;
            }
            if (digit < 0 || digit >= base) {
                throw new NumberFormatException(new String(b, offset, length));
            }
            value = value * base + digit;
        }
        return value;
    }

    public static byte[] parseBytes(String s, int base) {
        byte[] bytes = new byte[s.length() / 2];
        for (int i = 0; i < s.length(); i += 2) {
            bytes[i / 2] = (byte)TypeUtil.parseInt(s, i, 2, base);
        }
        return bytes;
    }

    public static String toString(byte[] bytes, int base) {
        StringBuffer buf = new StringBuffer();
        for (byte element : bytes) {
            int bi = 0xFF & element;
            int c = 48 + bi / base % base;
            if (c > 57) {
                c = 97 + c - 48 - 10;
            }
            buf.append((char)c);
            c = 48 + bi % base;
            if (c > 57) {
                c = 97 + c - 48 - 10;
            }
            buf.append((char)c);
        }
        return buf.toString();
    }

    public static byte convertHexDigit(byte b) {
        if (b >= 48 && b <= 57) {
            return (byte)(b - 48);
        }
        if (b >= 97 && b <= 102) {
            return (byte)(b - 97 + 10);
        }
        if (b >= 65 && b <= 70) {
            return (byte)(b - 65 + 10);
        }
        return 0;
    }

    public static String toHexString(byte[] b) {
        StringBuffer buf = new StringBuffer();
        for (byte element : b) {
            int bi = 0xFF & element;
            int c = 48 + bi / 16 % 16;
            if (c > 57) {
                c = 65 + c - 48 - 10;
            }
            buf.append((char)c);
            c = 48 + bi % 16;
            if (c > 57) {
                c = 97 + c - 48 - 10;
            }
            buf.append((char)c);
        }
        return buf.toString();
    }

    public static String toHexString(byte[] b, int offset, int length) {
        StringBuffer buf = new StringBuffer();
        for (int i = offset; i < offset + length; ++i) {
            int bi = 0xFF & b[i];
            int c = 48 + bi / 16 % 16;
            if (c > 57) {
                c = 65 + c - 48 - 10;
            }
            buf.append((char)c);
            c = 48 + bi % 16;
            if (c > 57) {
                c = 97 + c - 48 - 10;
            }
            buf.append((char)c);
        }
        return buf.toString();
    }

    public static byte[] fromHexString(String s) {
        if (s.length() % 2 != 0) {
            throw new IllegalArgumentException(s);
        }
        byte[] array = new byte[s.length() / 2];
        for (int i = 0; i < array.length; ++i) {
            int b = Integer.parseInt(s.substring(i * 2, i * 2 + 2), 16);
            array[i] = (byte)(0xFF & b);
        }
        return array;
    }

    public static void dump(Class<?> c) {
        Logger.debug("Dump: " + c);
    }

    public static byte[] readLine(InputStream in) throws IOException {
        byte[] old_buf;
        byte[] buf = new byte[256];
        int i = 0;
        int loops = 0;
        int ch = 0;
        while ((ch = in.read()) >= 0) {
            if (++loops == 1 && ch == 10) continue;
            if (ch == 13 || ch == 10) break;
            if (i >= buf.length) {
                old_buf = buf;
                buf = new byte[old_buf.length + 256];
                System.arraycopy(old_buf, 0, buf, 0, old_buf.length);
            }
            buf[i++] = (byte)ch;
        }
        if (ch == -1 && i == 0) {
            return null;
        }
        if (ch == 13 && in.available() >= 1 && in.markSupported()) {
            in.mark(1);
            ch = in.read();
            if (ch != 10) {
                in.reset();
            }
        }
        old_buf = buf;
        buf = new byte[i];
        System.arraycopy(old_buf, 0, buf, 0, i);
        return buf;
    }
}

