/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.checkers;

import com.sun.javacard.basicstructure.MethodDefinition;
import com.sun.javacard.classfile.JClassFile;
import com.sun.javacard.classfile.JField;
import com.sun.javacard.classfile.JMethod;
import com.sun.javacard.classfile.JPackage;
import com.sun.javacard.classfile.attributes.JAttribute;
import com.sun.javacard.classfile.attributes.JCodeAttr;
import com.sun.javacard.classfile.attributes.JLocalVarTableAttr;
import com.sun.javacard.classfile.attributes.JLocalVariable;
import com.sun.javacard.classfile.attributes.JRuntimeVisibleAnnotationsAttribute;
import com.sun.javacard.classfile.instructions.JInstrByteIndex;
import com.sun.javacard.classfile.instructions.JInstrClassRef;
import com.sun.javacard.classfile.instructions.JInstrCpByteRef;
import com.sun.javacard.classfile.instructions.JInstrCpShortRef;
import com.sun.javacard.classfile.instructions.JInstrFieldRef;
import com.sun.javacard.classfile.instructions.JInstrMethodRef;
import com.sun.javacard.classfile.instructions.JInstruction;
import com.sun.javacard.classfile.instructions.JavaByteCode;
import com.sun.javacard.converter.ConversionProfile;
import com.sun.javacard.converter.ConverterException;
import com.sun.javacard.converter.checkers.BCCheckingTable;
import com.sun.javacard.converter.util.DataType;
import com.sun.javacard.converter.util.MethodDescriptor;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcField;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.JcPackage;
import com.sun.javacard.jcfile.instructions.JcInstrLookupSwitch;
import com.sun.javacard.jcfile.instructions.JcInstrTableSwitch;
import com.sun.javacard.jcfile.instructions.JcInstruction;
import java.lang.reflect.Modifier;
import java.util.ResourceBundle;

public class SubsetChecker {
    protected static ResourceBundle messages = ResourceBundle.getBundle("com/sun/javacard/converter/MessagesBundle");
    ConversionProfile conversion_profile;

    public SubsetChecker(ConversionProfile conversionProfile) {
        this.conversion_profile = conversionProfile;
    }

    public void check(JPackage jPackage) {
        JClassFile[] jClassFileArray = jPackage.getClasses();
        this.checkPackage(jPackage);
        try {
            for (JClassFile jClassFile : jClassFileArray) {
                this.checkClass(jClassFile);
            }
        }
        catch (ConverterException converterException) {
            // empty catch block
        }
    }

    private void checkPackage(JPackage jPackage) {
        String string = jPackage.getPackageName();
        if (string.length() > 255) {
            Notifier.error("subset.60");
        }
    }

    private void checkClass(JClassFile jClassFile) throws ConverterException {
        Object[] objectArray;
        if (jClassFile.isInterfaceType() && !jClassFile.isAbstract()) {
            objectArray = new Object[]{jClassFile.getClassName().replace('/', '.')};
            Notifier.warning("flags.1", objectArray);
            jClassFile.setAbstract(true);
        }
        this.checkClassAttributes(jClassFile);
        objectArray = jClassFile.getFields();
        Object[] objectArray2 = objectArray;
        int n = objectArray2.length;
        for (int i = 0; i < n; ++i) {
            JField jField = objectArray2[i];
            this.checkField(jField, jClassFile);
        }
        for (Object object : objectArray2 = jClassFile.getMethods()) {
            this.checkMethod((JMethod)object, jClassFile.getClassName());
        }
    }

    private void checkClassAttributes(JClassFile jClassFile) throws ConverterException {
        JAttribute[] jAttributeArray = jClassFile.getAttributes();
        for (int i = 0; i < jAttributeArray.length; ++i) {
            if (!(jAttributeArray[i] instanceof JRuntimeVisibleAnnotationsAttribute)) continue;
            Object[] objectArray = new Object[]{jClassFile.getClassName().replace('/', '.')};
            Notifier.warning("subset.66", objectArray);
        }
    }

    private void checkField(JField jField, JClassFile jClassFile) {
        Object[] objectArray;
        int n;
        String string = jClassFile.getClassName();
        String string2 = jField.getFieldDescriptor();
        String string3 = jField.getFieldName();
        String string4 = this.checkType(string2);
        if (string4 != null) {
            Object[] objectArray2 = new Object[]{string.replace('/', '.'), string4, string3};
            Notifier.error("subset.1", objectArray2);
        }
        if (Modifier.isVolatile(n = jField.getAccessFlags())) {
            objectArray = new Object[]{string.replace('/', '.'), "volatile", string3};
            Notifier.error("subset.2", objectArray);
        }
        if (Modifier.isTransient(n)) {
            objectArray = new Object[]{string.replace('/', '.'), "transient", string3};
            Notifier.error("subset.2", objectArray);
        }
        if (!(!jClassFile.isInterfaceType() || DataType.isPrimitiveType(string2) && Modifier.isStatic(n) && Modifier.isFinal(n))) {
            objectArray = new Object[]{string.replace('/', '.'), string3};
            Notifier.error("subset.63", objectArray);
        }
        if (!this.conversion_profile.mask && Modifier.isStatic(n) && (this.conversion_profile.applets_profile == null || this.conversion_profile.applets_profile.length == 0) && jField.getValue() != null && DataType.isArrayType(string2)) {
            objectArray = new Object[]{string.replace('/', '.'), string3};
            Notifier.error("subset.22", objectArray);
        }
    }

    private void checkMethod(JMethod jMethod, String string) throws ConverterException {
        Object[] objectArray;
        int n = jMethod.getAccessFlags();
        String string2 = jMethod.getMethodName();
        String string3 = jMethod.getMethodDescriptor();
        if (Modifier.isSynchronized(n)) {
            objectArray = new Object[]{string.replace('/', '.'), "synchronized", string2};
            Notifier.error("subset.4", objectArray);
        }
        if (Modifier.isStrict(n)) {
            objectArray = new Object[]{string.replace('/', '.'), "strictfp", string2};
            Notifier.error("subset.4", objectArray);
        }
        if (Modifier.isNative(n) && !this.conversion_profile.mask) {
            objectArray = new Object[]{string.replace('/', '.'), "native", string2};
            Notifier.error("subset.4", objectArray);
        }
        if (Modifier.isTransient(n)) {
            objectArray = new Object[]{string.replace('/', '.'), string2};
            Notifier.error("subset.7", objectArray);
        }
        objectArray = MethodDescriptor.getParamDescriptors(string3);
        for (String string4 : objectArray) {
            String string5 = this.checkType(string4);
            if (string5 == null) continue;
            Object[] objectArray2 = new Object[]{string.replace('/', '.'), string5, string2};
            Notifier.error("subset.5", objectArray2);
        }
        String string6 = MethodDescriptor.getReturnDescriptor(string3);
        String string7 = this.checkType(string6);
        if (string7 != null && string7 != null) {
            Object[] objectArray3 = new Object[]{string.replace('/', '.'), string7, string2};
            Notifier.error("subset.6", objectArray3);
        }
        this.checkLocalVariables(jMethod, string);
        this.checkByteCodes(jMethod, string);
    }

    private void checkLocalVariables(JMethod jMethod, String string) throws ConverterException {
        JCodeAttr jCodeAttr = jMethod.getCodeAttr();
        if (jCodeAttr == null) {
            return;
        }
        JLocalVarTableAttr jLocalVarTableAttr = jCodeAttr.getLocalVarTableAttr();
        if (this.conversion_profile.debug && jLocalVarTableAttr == null && jCodeAttr.getMaxLocals() > 0) {
            Object[] objectArray = new String[]{string.replace('/', '.')};
            Notifier.error("locals.1", objectArray);
            throw new ConverterException();
        }
        if (jLocalVarTableAttr == null) {
            return;
        }
        JLocalVariable[] jLocalVariableArray = jLocalVarTableAttr.getLocalVars();
        int n = MethodDescriptor.getParamDescriptors(jMethod.getMethodDescriptor()).length;
        if (!jMethod.isStatic()) {
            ++n;
        }
        for (int i = n; i < jLocalVariableArray.length; ++i) {
            JLocalVariable jLocalVariable = jLocalVariableArray[i];
            if (DataType.getType(jLocalVariable.getDescriptor()) != 8) continue;
            Object[] objectArray = new String[]{string.replace('/', '.'), "char"};
            Notifier.error("subset.40", objectArray);
        }
    }

    private void checkByteCodes(JMethod jMethod, String string) {
        String string2 = jMethod.getMethodName();
        block15: for (JInstruction jInstruction = jMethod.getCode(); jInstruction != null; jInstruction = jInstruction.getNextInstr()) {
            Object[] objectArray;
            int n = jInstruction.getOpcode();
            if (string2.equals("<clinit>")) {
                if (BCCheckingTable.isClinitUnsupported(n)) {
                    objectArray = new Object[]{string.replace('/', '.'), JavaByteCode.getMnemonic(n)};
                    Notifier.error(jInstruction.getSourceLineNumber(), "subset.20", objectArray);
                } else if (BCCheckingTable.isClinitUnreasonable(n)) {
                    Object[] objectArray2 = new Object[]{string.replace('/', '.'), JavaByteCode.getMnemonic(n)};
                    Notifier.error(jInstruction.getSourceLineNumber(), "subset.21", objectArray2);
                }
            } else if (!BCCheckingTable.isAlwaysSupported(n)) {
                this.reportErrforUnsupportedByteCode(string, string2, jMethod.getMethodDescriptor(), jInstruction);
            }
            switch (n) {
                case 193: {
                    objectArray = ((JInstrClassRef)jInstruction).getClassName();
                    Object[] objectArray3 = this.checkType((String)objectArray);
                    if (objectArray3 == null) continue block15;
                    Object[] objectArray4 = new Object[]{string.replace('/', '.'), objectArray3};
                    Notifier.error(jInstruction.getSourceLineNumber(), "subset.31", objectArray4);
                    continue block15;
                }
                case 192: {
                    objectArray = ((JInstrClassRef)jInstruction).getClassName();
                    Object[] objectArray3 = this.checkType((String)objectArray);
                    if (objectArray3 == null) continue block15;
                    Object[] objectArray4 = new Object[]{string.replace('/', '.'), objectArray3};
                    Notifier.error(jInstruction.getSourceLineNumber(), "subset.32", objectArray4);
                    continue block15;
                }
                case 189: {
                    objectArray = ((JInstrClassRef)jInstruction).getClassName();
                    if (!objectArray.startsWith("[")) continue block15;
                    Object[] objectArray3 = new Object[]{string.replace('/', '.')};
                    Notifier.error(jInstruction.getSourceLineNumber(), "subset.45", objectArray3);
                    continue block15;
                }
                case 188: {
                    Object[] objectArray3;
                    int n2 = ((JInstrByteIndex)jInstruction).getIndex();
                    switch (n2) {
                        case 5: {
                            objectArray3 = new Object[]{string.replace('/', '.'), "char[]"};
                            Notifier.error(jInstruction.getSourceLineNumber(), "subset.33", objectArray3);
                            break;
                        }
                        case 6: {
                            objectArray3 = new Object[]{string.replace('/', '.'), "float[]"};
                            Notifier.error(jInstruction.getSourceLineNumber(), "subset.33", objectArray3);
                            break;
                        }
                        case 7: {
                            objectArray3 = new Object[]{string.replace('/', '.'), "double[]"};
                            Notifier.error(jInstruction.getSourceLineNumber(), "subset.33", objectArray3);
                            break;
                        }
                        case 11: {
                            objectArray3 = new Object[]{string.replace('/', '.'), "long[]"};
                            Notifier.error(jInstruction.getSourceLineNumber(), "subset.33", objectArray3);
                            break;
                        }
                        case 10: {
                            if (this.conversion_profile.int_supported) break;
                            objectArray3 = new Object[]{string.replace('/', '.'), "int[]"};
                            Notifier.error(jInstruction.getSourceLineNumber(), "subset.33", objectArray3);
                        }
                    }
                    continue block15;
                }
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    Object object;
                    objectArray = (JInstrMethodRef)jInstruction;
                    Object[] objectArray3 = objectArray.getDescriptor();
                    Object[] objectArray4 = objectArray.getClassName();
                    String string3 = objectArray.getMethodName();
                    for (String string4 : object = MethodDescriptor.getParamDescriptors((String)objectArray3)) {
                        String string5 = this.checkType(string4);
                        if (string5 == null) continue;
                        Object[] objectArray2 = new Object[]{string.replace('/', '.'), string5, Names.getMethodNameInJavaStyle(string3, (String)objectArray3), objectArray4.replace('/', '.')};
                        Notifier.error(jInstruction.getSourceLineNumber(), "subset.34", objectArray2);
                    }
                    String string6 = MethodDescriptor.getReturnDescriptor((String)objectArray3);
                    String string7 = this.checkType(string6);
                    if (string7 == null) continue block15;
                    Object[] objectArray5 = new Object[]{string.replace('/', '.'), string7, Names.getMethodNameInJavaStyle(string3, (String)objectArray3), objectArray4.replace('/', '.')};
                    Notifier.error(jInstruction.getSourceLineNumber(), "subset.35", objectArray5);
                    continue block15;
                }
                case 178: 
                case 179: 
                case 180: 
                case 181: {
                    objectArray = (JInstrFieldRef)jInstruction;
                    Object[] objectArray3 = objectArray.getClassName();
                    Object[] objectArray4 = objectArray.getFieldName();
                    String string3 = objectArray.getDescriptor();
                    Object object = this.checkType(string3);
                    if (object == null) continue block15;
                    Object[] objectArray6 = new Object[]{string.replace('/', '.'), object, objectArray4, objectArray3.replace('/', '.')};
                    Notifier.error(jInstruction.getSourceLineNumber(), "subset.36", objectArray6);
                    continue block15;
                }
            }
        }
    }

    private String checkType(String string) {
        int n = DataType.getType(string);
        switch (n) {
            case 8: {
                return "char";
            }
            case 6: {
                return "double";
            }
            case 5: {
                return "float";
            }
            case 4: {
                return "long";
            }
            case 10: {
                if (DataType.isMultiDimensionArray(string)) {
                    return messages.getString("other.1");
                }
                if (string.equals("Ljava/lang/String;")) {
                    return "String";
                }
                if (string.equals("[Ljava/lang/String;")) {
                    return "String[]";
                }
                if (string.equals("[C")) {
                    return "char[]";
                }
                if (string.equals("[D")) {
                    return "double[]";
                }
                if (string.equals("[F")) {
                    return "float[]";
                }
                if (!string.equals("[J")) break;
                return "long[]";
            }
        }
        return null;
    }

    private void reportErrforUnsupportedByteCode(String string, String string2, String string3, JInstruction jInstruction) {
        int n = jInstruction.getOpcode();
        int n2 = jInstruction.getSourceLineNumber();
        switch (n) {
            case 57: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                Object[] objectArray = new String[]{string.replace('/', '.'), "double"};
                Notifier.error(n2, "subset.40", objectArray);
                break;
            }
            case 56: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                Object[] objectArray = new String[]{string.replace('/', '.'), "float"};
                Notifier.error(n2, "subset.40", objectArray);
                break;
            }
            case 55: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                Object[] objectArray = new String[]{string.replace('/', '.'), "long"};
                Notifier.error(n2, "subset.40", objectArray);
                break;
            }
            case 14: 
            case 15: {
                Object[] objectArray = new String[]{string.replace('/', '.'), "double"};
                Notifier.error(n2, "subset.41", objectArray);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                Object[] objectArray = new String[]{string.replace('/', '.'), "float"};
                Notifier.error(n2, "subset.41", objectArray);
                break;
            }
            case 9: 
            case 10: {
                Object[] objectArray = new String[]{string.replace('/', '.'), "long"};
                Notifier.error(n2, "subset.41", objectArray);
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                Object[] objectArray;
                int n3 = n == 18 ? ((JInstrCpByteRef)jInstruction).getValueType() : ((JInstrCpShortRef)jInstruction).getValueType();
                if (n3 == 5) {
                    objectArray = new String[]{string.replace('/', '.'), "float"};
                    Notifier.error(n2, "subset.41", objectArray);
                }
                if (n3 == 20) {
                    objectArray = new String[]{string.replace('/', '.'), "String"};
                    Notifier.error(n2, "subset.41", objectArray);
                }
                if (n3 == 4) {
                    objectArray = new String[]{string.replace('/', '.'), "long"};
                    Notifier.error(n2, "subset.41", objectArray);
                }
                if (n3 != 6) break;
                objectArray = new String[]{string.replace('/', '.'), "double"};
                Notifier.error(n2, "subset.41", objectArray);
                break;
            }
            case 146: {
                Object[] objectArray = new String[]{string.replace('/', '.'), "char"};
                Notifier.error(n2, "subset.42", objectArray);
                break;
            }
            case 135: {
                Object[] objectArray = new String[]{string.replace('/', '.'), "double"};
                Notifier.error(n2, "subset.43", objectArray);
                break;
            }
            case 134: {
                Object[] objectArray = new String[]{string.replace('/', '.'), "float"};
                Notifier.error(n2, "subset.43", objectArray);
                break;
            }
            case 133: {
                Object[] objectArray = new String[]{string.replace('/', '.'), "long"};
                Notifier.error(n2, "subset.43", objectArray);
                break;
            }
            case 194: 
            case 195: {
                Notifier.error(n2, "subset.44", string.replace('/', '.'));
                break;
            }
            case 197: {
                Notifier.error(n2, "subset.45", string.replace('/', '.'));
                break;
            }
            case 200: 
            case 201: {
                Object[] objectArray = new String[]{string.replace('/', '.'), Names.getMethodNameInJavaStyle(string2, string3)};
                Notifier.error("subset.46", objectArray);
                break;
            }
        }
    }

    public void check(JcPackage jcPackage) {
        JcClass[] jcClassArray = jcPackage.getClasses();
        if (jcClassArray.length > 255) {
            Notifier.error("subset.10", jcPackage.getPackageName());
        }
        for (JcClass jcClass : jcClassArray) {
            this.checkClass(jcPackage, jcClass);
        }
        this.checkAccessControl(jcPackage);
    }

    private void checkClass(JcPackage jcPackage, JcClass jcClass) {
        String string = jcClass.getClassName();
        if (jcClass.isInterfaceType() && jcClass.getSuperInterfaces().length > 14) {
            Notifier.error("subset.9", string.replace('/', '.'));
        }
        if (jcClass.getSuperInterfaces().length > 15 && !jcClass.isInterfaceType()) {
            Notifier.error("subset.8", string.replace('/', '.'));
        }
        int n = 0;
        int n2 = 0;
        JcField[] jcFieldArray = jcClass.getFields();
        for (int i = 0; i < jcFieldArray.length; ++i) {
            int n3 = jcFieldArray[i].getAccessFlags();
            if (Modifier.isStatic(n3)) {
                if (!Modifier.isPublic(n3) && !Modifier.isProtected(n3) || jcFieldArray[i].isFinal()) continue;
                ++n;
                continue;
            }
            String string2 = jcFieldArray[i].getFieldDescriptor();
            if (DataType.getType(string2) == 3) {
                n2 += 2;
                continue;
            }
            ++n2;
        }
        if (n > 256) {
            Notifier.error("subset.11", string.replace('/', '.'));
        }
        if (n > 255 && jcClass.isAPIElement(jcPackage)) {
            Notifier.error("subset.61", string.replace('/', '.'));
        }
        String[] stringArray = jcClass.getPublicSuperClasses();
        for (String string3 : stringArray) {
            JcClass jcClass2 = jcPackage.getClass(string3);
            if (jcClass2 == null) continue;
            jcFieldArray = jcClass2.getFields();
            for (JcField jcField : jcFieldArray) {
                int n4 = jcField.getAccessFlags();
                if (Modifier.isStatic(n4)) continue;
                String string4 = jcField.getFieldDescriptor();
                if (DataType.getType(string4) == 3) {
                    n2 += 2;
                    continue;
                }
                ++n2;
            }
        }
        if (n2 > 255) {
            Notifier.error("subset.12", string.replace('/', '.'));
        }
        Object[] objectArray = jcClass.getMethods();
        int n5 = 0;
        for (Object object : objectArray) {
            int n6 = ((MethodDefinition)object).getAccessFlags();
            if (Modifier.isStatic(n6)) {
                if (!Modifier.isPublic(n6) && !Modifier.isProtected(n6)) continue;
                ++n5;
                continue;
            }
            if (!((MethodDefinition)object).getMethodName().equals("<init>") || !Modifier.isPublic(n6) && !Modifier.isProtected(n6)) continue;
            ++n5;
        }
        if (n5 > 256) {
            Notifier.error("subset.13", string.replace('/', '.'));
        }
        if (n5 > 255 && jcClass.isAPIElement(jcPackage)) {
            Notifier.error("subset.62", string.replace('/', '.'));
        }
        if (jcClass.getPublicMethodTable().getMethods().length > 128) {
            if (jcClass.isInterfaceType()) {
                Notifier.error("subset.19", string.replace('/', '.'));
            } else {
                Notifier.error("subset.14", string.replace('/', '.'));
            }
        }
        if (jcClass.getPackageMethodTable().getMethods().length > 128) {
            Notifier.error("subset.15", string.replace('/', '.'));
        }
        for (Object object : objectArray) {
            this.checkMethod((JcMethod)object, string);
        }
    }

    private void checkAccessControl(JcPackage jcPackage) {
        JcClass[] jcClassArray;
        for (JcClass jcClass : jcClassArray = jcPackage.getClasses()) {
            int n;
            Object object;
            String[] stringArray;
            if (jcClass.isInterfaceType()) {
                if (!Modifier.isPublic(jcClass.getAccessFlags())) continue;
                stringArray = jcClass.getSuperInterfaces();
                object = stringArray;
                int n2 = ((String[])object).length;
                for (int i = 0; i < n2; ++i) {
                    Object object2 = object[i];
                    JcClass jcClass2 = jcPackage.getClass((String)object2);
                    if (jcClass2 == null || Modifier.isPublic(n = jcClass2.getAccessFlags())) continue;
                    Object[] objectArray = new String[]{jcClass.getClassName().replace('/', '.'), jcClass2.getClassName().replace('/', '.')};
                    Notifier.error("subset.50", objectArray);
                }
                continue;
            }
            stringArray = jcClass.getSuperClassName();
            if (stringArray == null || (object = jcPackage.getClass((String)stringArray)) == null) continue;
            JcMethod[] jcMethodArray = jcClass.getMethods();
            MethodDefinition[] methodDefinitionArray = ((JcClass)object).getPackageMethodTable().getMethods();
            JcMethod[] jcMethodArray2 = jcMethodArray;
            int n3 = jcMethodArray2.length;
            for (n = 0; n < n3; ++n) {
                JcMethod jcMethod = jcMethodArray2[n];
                int n4 = jcMethod.getAccessFlags();
                if (!Modifier.isPublic(n4) && !Modifier.isProtected(n4)) continue;
                for (MethodDefinition methodDefinition : methodDefinitionArray) {
                    if (!jcMethod.getMethodSignature().equals(methodDefinition.getMethodSignature())) continue;
                    Object[] objectArray = new String[]{jcClass.getClassName().replace('/', '.'), Names.getMethodNameInJavaStyle(jcMethod.getMethodName(), jcMethod.getMethodDescriptor())};
                    Notifier.error("subset.51", objectArray);
                }
            }
        }
    }

    private void checkMethod(JcMethod jcMethod, String string) {
        String string2 = jcMethod.getMethodName();
        if (jcMethod.getMaxLocals() + jcMethod.getNargs() > 255) {
            Object[] objectArray = new Object[]{string.replace('/', '.'), string2};
            Notifier.error("subset.16", objectArray);
        }
        this.checkByteCode(jcMethod, string);
    }

    private void checkByteCode(JcMethod jcMethod, String string) {
        String string2 = jcMethod.getMethodName();
        int n = 0;
        block4: for (JcInstruction jcInstruction = jcMethod.getCode(); jcInstruction != null; jcInstruction = jcInstruction.getNextInstr()) {
            n += jcInstruction.getSizeInBytes();
            int n2 = jcInstruction.getOpcode();
            switch (n2) {
                case 117: 
                case 118: {
                    int n3 = ((JcInstrLookupSwitch)jcInstruction).getNumMatchPairs();
                    if (n3 <= 65536) continue block4;
                    Object[] objectArray = new Object[]{string.replace('/', '.'), string2};
                    Notifier.error("subset.18", objectArray);
                    continue block4;
                }
                case 115: 
                case 116: {
                    JcInstrTableSwitch jcInstrTableSwitch = (JcInstrTableSwitch)jcInstruction;
                    int n4 = jcInstrTableSwitch.getHighValue() - jcInstrTableSwitch.getLowValue() + 1;
                    if (n4 <= 65536) continue block4;
                    Object[] objectArray = new Object[]{string.replace('/', '.'), string2};
                    Notifier.error("subset.18", objectArray);
                    continue block4;
                }
            }
        }
        if (n > Short.MAX_VALUE) {
            Object[] objectArray = new Object[]{string.replace('/', '.'), string2};
            Notifier.error("subset.17", objectArray);
        }
    }
}

