/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.mask;

import com.sun.javacard.jcasm.ExceptionTable;
import com.sun.javacard.jcasm.ExceptionTableEntry;
import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.FieldDescriptor;
import com.sun.javacard.jcasm.Globals;
import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.Instruction;
import com.sun.javacard.jcasm.InterfaceTable;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Member;
import com.sun.javacard.jcasm.MethodIdentifier;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.Operand;
import com.sun.javacard.jcasm.RemoteMethodInfo;
import com.sun.javacard.jcasm.SignaturePool;
import com.sun.javacard.jcasm.Statement;
import com.sun.javacard.jcasm.StaticFieldInitializer;
import com.sun.javacard.jcasm.SuperInterface;
import com.sun.javacard.jcasm.cap.ExportComponent;
import com.sun.javacard.jcasm.cap.StaticFieldComponent;
import com.sun.javacard.jcasm.cap.TypeDescriptorEntry;
import com.sun.javacard.jcasm.mask.Main;
import com.sun.javacard.jcasm.mask.OutputFormatter;
import com.sun.javacard.jcasm.mask.PackageDirectory;
import com.sun.javacard.jcasm.mask.PackageTableEntry;
import com.sun.javacard.jcasm.mask.PackageTableManager;
import com.sun.javacard.jcasm.mask.RomMask;
import com.sun.javacard.jcasm.mask.TableManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class CrefOutputFormatter
extends OutputFormatter {
    public static final int METHOD_LIMIT = Short.MAX_VALUE;
    public static CrefOutputFormatter cof;
    protected StringBuffer preamble;
    protected StringBuffer rom;
    protected StringBuffer rom_AidAndPkgTblEntries;
    protected StringBuffer rom_GrtObjectPkgFilledTable;
    protected StringBuffer exceptionsAndExports;
    protected StringBuffer exceptionTableLinkedList;
    protected int romLength = 0;
    protected StringBuffer staticFields;
    protected String packageTableField;
    protected String packageContextTableField;
    Vector<String> nativeMethods = new Vector();
    protected StringBuffer staticInit;
    protected int staticInitSize = 0;
    protected int npackages = 0;
    static final int exceptionEntrySize = 8;
    static int exceptionTableHeaderSize;
    static final String BYTE_CLASS_NAME = "[B";
    protected int exportComponentLength;
    protected int nExceptionEntries = 0;
    protected int nextExceptionTable = 0;
    protected StringBuffer defineList;
    protected int m_apiPkgCount = -1;
    protected Hashtable<JCPackage, StaticFieldComponent> packageFields;
    PackageDirectory packageDirectory;
    protected Vector<String> suppressionVector;
    static TableManager objectManager;
    static TableManager exportedRefManager;
    static PackageTableManager ptm;
    static StringBuffer initializedArrays;
    private JCPackage currentPackage;
    private int currentEEPROMAddr;
    private int m_romBase = 0;
    private int m_e2Base = 32768;
    private int romAddrForExceptionsAndExports = 0;
    public static final int ARRAY_HEADER_SIZE = 7;
    static final byte OBJECT_TYPE_BYTE_ARRAY = -128;
    static final byte OBJECT_TYPE_BOOLEAN_ARRAY = 96;
    static final byte OBJECT_TYPE_SHORT_ARRAY = -96;
    static final byte OBJECT_TYPE_INT_ARRAY = -64;
    int currentRomAddr;

    public CrefOutputFormatter(BufferedReader bufferedReader) throws IOException {
        super(bufferedReader);
        String string;
        cof = this;
        this.preamble = new StringBuffer();
        this.preamble.append("#include \"profile.h\"" + Msg.eol);
        this.preamble.append("#include \"opcode.h\"" + Msg.eol);
        this.preamble.append("#include \"mask.h\"" + Msg.eol);
        this.rom = new StringBuffer();
        this.rom_AidAndPkgTblEntries = new StringBuffer();
        this.rom_GrtObjectPkgFilledTable = new StringBuffer();
        this.exceptionsAndExports = new StringBuffer();
        this.staticFields = new StringBuffer();
        this.staticInit = new StringBuffer();
        this.defineList = new StringBuffer();
        this.packageDirectory = new PackageDirectory();
        this.suppressionVector = new Vector();
        this.packageFields = new Hashtable();
        objectManager = new TableManager(1);
        exportedRefManager = new TableManager(0);
        ptm = new PackageTableManager();
        initializedArrays = new StringBuffer();
        try {
            string = this.getMapEntry("ROMBASE");
            if (string != null) {
                this.m_romBase = Integer.decode(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            Msg.error("cref.0", null);
        }
        try {
            string = this.getMapEntry("E2BASE");
            if (string != null) {
                this.m_e2Base = Integer.decode(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            Msg.error("cref.1", null);
        }
        try {
            string = this.getMapEntry("API_PACKAGES_COUNT");
            if (string != null) {
                this.m_apiPkgCount = Integer.decode(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            Msg.error("cref.0", null);
        }
        string = this.getMapEntry("NOEXPORTCOMPONENT");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                this.suppressionVector.addElement(stringTokenizer.nextToken().trim());
            }
        }
        this.packageTableField = this.getMapEntry("PACKAGE_TABLE");
        this.packageContextTableField = this.getMapEntry("PACKAGE_CONTEXT_TABLE");
        if (this.packageTableField == null || this.packageContextTableField == null) {
            Msg.error("cref.4", null);
            Main.printStatus();
        }
        this.currentEEPROMAddr = this.m_e2Base;
        if (Main.FLAG_32_BIT) {
            exceptionTableHeaderSize = 9;
        }
    }

    void addNativeMethodToMask(JCMethod jCMethod) {
        int n = 0;
        String string = null;
        String string2 = jCMethod.getName();
        string = string2 = "Java_NativeMethod_" + string2.substring(0, string2.indexOf("(")).replace('/', '_');
        while (this.nativeMethods.contains(string2)) {
            string2 = string + "_" + n;
        }
        this.nativeMethods.add(string2);
    }

    public static TableManager getExportedRefManager() {
        return exportedRefManager;
    }

    public static JCPackage getCurrentPackage() {
        return CrefOutputFormatter.cof.currentPackage;
    }

    @Override
    public void format(RomMask romMask) {
        this.pass1(romMask);
        if (Globals.errors == 0) {
            this.pass2(romMask);
        }
    }

    int getCurrentEEPROMAddr() {
        return this.currentEEPROMAddr;
    }

    void setCurrentEEPROMAddr(int n) {
        this.currentEEPROMAddr = n;
    }

    private int prepareRemotePackageForMasking(JCPackage jCPackage) {
        int n = 0;
        int n2 = 0;
        Enumeration<JCClass> enumeration = jCPackage.classElements();
        while (enumeration.hasMoreElements()) {
            JCClass jCClass = enumeration.nextElement();
            jCClass.relocate(n++);
        }
        n2 = jCPackage.getSignaturePool().getSize();
        return n2;
    }

    protected void pass1(RomMask romMask) {
        String string = this.getMapEntry("INSTALLER_APPLET_PACKAGE");
        if (string == null) {
            Msg.warn("cref.8", null);
        }
        short s = 1;
        this.currentRomAddr = this.m_romBase;
        int n = -1;
        Enumeration<JCPackage> enumeration = romMask.packageElements();
        while (enumeration.hasMoreElements()) {
            Object object;
            int n2;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            JCPackage jCPackage = enumeration.nextElement();
            this.packageDirectory.addPackage(jCPackage.getIdentifier());
            if (jCPackage.getName().equals(string) && jCPackage.appletCount() == 0) {
                Msg.warn("cref.9", null);
            }
            if (jCPackage.appletCount() > 0) {
                if (jCPackage.getName().equals(string)) {
                    ptm.addAppletPackageContext(this.packageDirectory.indexOf(jCPackage.getIdentifier()), true);
                } else {
                    ptm.addAppletPackageContext(this.packageDirectory.indexOf(jCPackage.getIdentifier()), false);
                }
            }
            ++n;
            PackageTableEntry packageTableEntry = ptm.addPackage(jCPackage);
            StaticFieldComponent staticFieldComponent = new StaticFieldComponent(jCPackage);
            this.packageFields.put(jCPackage, staticFieldComponent);
            if (jCPackage.hasRemote()) {
                packageTableEntry.setPkgNameInfo(jCPackage.getName().getBytes());
                n2 = this.prepareRemotePackageForMasking(jCPackage);
                jCPackage.getSignaturePool().relocate(n3);
                n3 += 2;
                n3 += jCPackage.getSignaturePool().getSize();
                jCPackage.purgeSignaturePool();
            }
            Enumeration<JCClass> enumeration2 = jCPackage.classElements();
            while (enumeration2.hasMoreElements()) {
                JCClass jCClass = enumeration2.nextElement();
                staticFieldComponent.add(jCClass);
                jCClass.relocate(n3);
                if (jCClass.isExported()) {
                    exportedRefManager.addExportedReference(jCClass, n3, n);
                }
                n3 += jCClass.size();
                if (Modifier.isInterface(jCClass.getAttributes())) continue;
                Enumeration<JCMethod> enumeration3 = jCClass.methodElements();
                while (enumeration3.hasMoreElements()) {
                    object = enumeration3.nextElement();
                    ((Member)object).relocate(n5);
                    if (((JCMethod)object).isGRTCandidate()) {
                        exportedRefManager.addExportedReference(object, n5, n);
                    }
                    n5 += ((JCMethod)object).size();
                    if (!Modifier.isNative(((Member)object).getAttributes())) continue;
                    this.addNativeMethodToMask((JCMethod)object);
                    ((JCMethod)object).setNativeToken(s);
                    s = (short)(s + 1);
                    ++n5;
                }
            }
            for (n2 = 1; n2 <= 4; ++n2) {
                for (Field field : staticFieldComponent.getSegment(n2)) {
                    object = field.getDescriptor();
                    if (Modifier.isFinal(field.getAttributes()) && ((FieldDescriptor)object).isPrimitive()) continue;
                    if (field.isExportCompCandidate()) {
                        exportedRefManager.addExportedReference(field, n4, n);
                    }
                    field.relocate(n4);
                    n4 += field.size();
                }
            }
            packageTableEntry.setStaticRefFieldCount(staticFieldComponent.getReferenceFieldCount());
            packageTableEntry.setPackageComponentLocation(0, this.currentRomAddr, n3);
            this.currentRomAddr += n3;
            packageTableEntry.setPackageComponentLocation(1, this.currentRomAddr, n5);
            this.currentRomAddr += n5;
            packageTableEntry.setPackageComponentLocation(2, this.currentEEPROMAddr, n4);
            this.currentEEPROMAddr += n4;
        }
        exportedRefManager.resolveExportAddresses();
        ptm.createAndAddPackageTableInfo(romMask);
        this.romAddrForExceptionsAndExports = CrefOutputFormatter.cof.currentRomAddr;
        initializedArrays.append("/* Static Initialized Array Data @" + Msg.toAddressString(this.currentEEPROMAddr) + "*/" + Msg.eol);
    }

    protected void pass2(RomMask romMask) {
        int n = this.romAddrForExceptionsAndExports;
        Enumeration<JCPackage> enumeration = romMask.packageElements();
        while (enumeration.hasMoreElements()) {
            int n2;
            Object object;
            this.nExceptionEntries = 0;
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            StringBuffer stringBuffer3 = new StringBuffer();
            this.currentPackage = enumeration.nextElement();
            PackageTableEntry packageTableEntry = ptm.getPackageEntry(this.currentPackage);
            boolean bl = this.suppressionVector.contains(this.currentPackage.getName());
            ExportComponent exportComponent = new ExportComponent(this.currentPackage);
            ExportComponent.setOutputMode(1);
            String string = this.getMapEntry(this.currentPackage.getName());
            if (string != null) {
                this.defineList.append("#define " + string + " " + this.npackages + "\t/* " + this.currentPackage.getName() + " */" + Msg.eol);
            }
            ++this.npackages;
            if (this.currentPackage.is22Package()) {
                stringBuffer.append(Msg.eol + "/* " + this.currentPackage.getName() + " Signature Pool Length and Signature Pool */" + Msg.eol);
                stringBuffer.append("HIGH(" + Msg.toHexString((short)this.currentPackage.getSignaturePool().getSize()) + "), ");
                stringBuffer.append("LOW(" + Msg.toHexString((short)this.currentPackage.getSignaturePool().getSize()) + "), ");
                if (this.currentPackage.getSignaturePool().getSize() > 0) {
                    object = this.currentPackage.getSignaturePool();
                    for (n2 = 0; n2 < ((SignaturePool)object).methodSignaturePool.size(); ++n2) {
                        TypeDescriptorEntry typeDescriptorEntry = ((SignaturePool)object).methodSignaturePool.elementAt(n2);
                        byte[] byArray = typeDescriptorEntry.getData();
                        stringBuffer.append(Msg.toHexString(byArray, ", ") + ", ");
                    }
                    stringBuffer.append(Msg.eol);
                }
            }
            object = this.currentPackage.classElements();
            while (object.hasMoreElements()) {
                JCClass jCClass = object.nextElement();
                if (!bl) {
                    exportComponent.add(jCClass);
                }
                if (!this.outputClassInfo(jCClass, stringBuffer, packageTableEntry)) continue;
                this.outputFieldMappingInfo(jCClass);
                this.outputMethods(jCClass, stringBuffer2, stringBuffer3, packageTableEntry);
            }
            if (this.nExceptionEntries > 0) {
                object = this.getExceptionTableHeader();
                this.exceptionsAndExports.append(((StringBuffer)object).toString());
                this.exceptionsAndExports.append(stringBuffer3.toString());
            }
            this.rom.append(Msg.eol + "/* Class Component for " + this.currentPackage.getName() + " */" + Msg.eol);
            this.rom.append(stringBuffer);
            this.rom.append(Msg.eol + "/* Method Component for " + this.currentPackage.getName() + " */" + Msg.eol);
            this.rom.append(stringBuffer2);
            object = exportComponent.toByteArray();
            this.exceptionsAndExports.append("/* Export Component for " + this.currentPackage.getName() + "@" + Msg.toAddressString(this.romAddrForExceptionsAndExports) + " */" + Msg.eol);
            for (n2 = 3; n2 < ((Object)object).length; ++n2) {
                this.exceptionsAndExports.append(Msg.toHexString((byte)object[n2]) + ", ");
                if (n2 % 8 != 7) continue;
                this.exceptionsAndExports.append(Msg.eol);
            }
            ptm.getPackageEntry(this.currentPackage).setPackageComponentLocation(3, this.romAddrForExceptionsAndExports, ((Object)object).length - 3);
            this.exceptionsAndExports.append(Msg.eol);
            this.exportComponentLength += ((Object)object).length - 3;
            this.romAddrForExceptionsAndExports += ((Object)object).length - 3;
            this.outputStaticFields(romMask, packageTableEntry);
        }
        this.defineList.append("#define VM_ARRAY_IMPLEMENTATION_PKG " + this.packageDirectory.indexOf(this.currentPackage.getIdentifier()));
        this.defineList.append(Msg.eol);
        this.defineList.append(Msg.eol);
        this.currentRomAddr = this.romAddrForExceptionsAndExports;
        this.staticInitSize += exportedRefManager.addToMask(initializedArrays);
        this.defineList.append("#define GLOBAL_REFERENCE_TABLE_ADDRESS " + Msg.toAddressString(CrefOutputFormatter.exportedRefManager.tableLocation) + Msg.eol);
        this.staticInitSize += objectManager.addToMask(initializedArrays);
        this.defineList.append("#define OBJECT_TABLE_ADDRESS " + Msg.toAddressString(CrefOutputFormatter.objectManager.tableLocation) + Msg.eol);
        this.staticInitSize += ptm.createAndAddPackageLocTable(initializedArrays);
        this.defineList.append("#define PACKAGE_LOCATION_TABLE_ADDRESS " + Msg.toAddressString(CrefOutputFormatter.ptm.packageLocTableAddress) + Msg.eol);
        this.defineList.append(Msg.eol);
        this.defineList.append("#define EXPORT_COMPONENT_BASE " + Msg.toAddressString(n) + Msg.eol);
        this.romLength = this.currentRomAddr - this.m_romBase;
        this.defineList.append("#define INITIAL_EXCEPTION_TABLE_LIST " + Msg.toAddressString(this.nextExceptionTable) + Msg.eol);
        this.rom.append(this.rom_AidAndPkgTblEntries);
        this.rom.append(Msg.eol + "/* Exception and Export information */" + Msg.eol);
        this.rom.append(this.exceptionsAndExports);
        this.rom.append(this.rom_GrtObjectPkgFilledTable);
        if (this.m_romBase + this.romLength >= this.m_e2Base) {
            Msg.error("cref.2", null);
            Main.printStatus();
        }
        this.defineList.append("#define ROMSIZE " + this.romLength + Msg.eol);
        this.defineList.append("#define EEPROM_IMAGE_SIZE " + (this.currentEEPROMAddr - this.m_e2Base) + Msg.eol);
        this.defineList.append("#define NPACKAGES " + this.npackages + Msg.eol);
        this.staticInit.append(initializedArrays);
        if (this.m_apiPkgCount != -1) {
            this.defineList.append("#define API_PACKAGES_COUNT " + this.m_apiPkgCount + Msg.eol);
        }
    }

    protected boolean outputClassInfo(JCClass jCClass, StringBuffer stringBuffer, PackageTableEntry packageTableEntry) {
        int n;
        String string = null;
        int n2 = packageTableEntry.componentInfoReference[0].compLocation;
        int n3 = jCClass.getRelocAddr();
        stringBuffer.append(Msg.eol + "/* class@" + Msg.toAddressString(n3 + n2) + ":" + Msg.toHexString((short)n3) + ": " + Modifier.toString(jCClass.getAttributes()) + " " + jCClass.getName() + " */" + Msg.eol);
        string = this.getMapEntry(jCClass.getName());
        if (string != null) {
            this.defineList.append("#define " + string + " " + Msg.toHexString((short)n3) + "\t/* " + jCClass.getName() + " */" + Msg.eol);
        }
        int n4 = n = jCClass.isShareable() ? 64 : 0;
        if (Modifier.isInterface(jCClass.getAttributes())) {
            int n5;
            n |= 0x80;
            if (jCClass.isRemote()) {
                n |= 0x20;
            }
            if ((n5 = jCClass.superInterfaceVector.size()) > 15) {
                Object[] objectArray = new Object[]{jCClass.getName()};
                Msg.error("cref.3", objectArray);
                Main.printStatus();
            }
            stringBuffer.append(Msg.toHexString((byte)(n | n5 & 0xF)) + ", ");
            for (SuperInterface superInterface : jCClass.superInterfaceVector) {
                n3 = superInterface.resolve().getRelocAddr();
                if (!superInterface.resolve().getParentPackage().equals(this.currentPackage)) {
                    n3 = exportedRefManager.getExportedReference(superInterface.resolve());
                }
                stringBuffer.append("HIGH(" + Msg.toHexString((short)n3) + "), ");
                stringBuffer.append("LOW(" + Msg.toHexString((short)n3) + "), ");
                stringBuffer.append(Msg.eol);
            }
            if (jCClass.isRemote()) {
                this.addRemoteClassInfo(jCClass, stringBuffer);
            }
            return false;
        }
        n |= jCClass.interfaceVector.size() & 0xF;
        if (jCClass.isRemote()) {
            n |= 0x20;
        }
        stringBuffer.append(Msg.toHexString((byte)n) + ", ");
        JCClass jCClass2 = jCClass.getSuperClass();
        n3 = jCClass2 == null ? 65535 : (!jCClass2.getParentPackage().equals(this.currentPackage) ? exportedRefManager.getExportedReference(jCClass2) : jCClass2.getRelocAddr());
        stringBuffer.append("HIGH(" + Msg.toHexString((short)n3) + "), ");
        stringBuffer.append("LOW(" + Msg.toHexString((short)n3) + "), ");
        int n6 = 0;
        for (JCClass jCClass3 = jCClass; jCClass3 != null; jCClass3 = jCClass3.getSuperClass()) {
            n6 += jCClass3.getInstanceSize();
        }
        stringBuffer.append(Msg.toHexString((byte)n6) + ", ");
        int n7 = jCClass.getFirstReferenceToken();
        if (n7 != 255) {
            n7 += jCClass.getInstanceBase();
        }
        stringBuffer.append(Msg.toHexString((byte)n7) + ", ");
        stringBuffer.append(Msg.toHexString((byte)jCClass.getReferenceCount()) + ", ");
        stringBuffer.append(Msg.toHexString((byte)jCClass.publicMethodTable.getBase()) + ", ");
        stringBuffer.append(Msg.toHexString((byte)jCClass.publicMethodTable.getCount()) + ", ");
        int n8 = jCClass.packageMethodTable.getFixedPkgMethodTableBase();
        stringBuffer.append(Msg.toHexString((byte)n8) + ", ");
        stringBuffer.append(Msg.toHexString((byte)jCClass.packageMethodTable.getCount()) + ", ");
        stringBuffer.append(Msg.eol);
        Object object2 = jCClass.publicMethodTable.elements();
        while (object2.hasMoreElements()) {
            JCMethod object3 = object2.nextElement();
            n3 = object3.getParentClass().getParentPackage().equals(this.currentPackage) ? (object3.isGRTCandidate() ? exportedRefManager.getExportedReference(object3) : object3.getRelocAddr()) : exportedRefManager.getExportedReference(object3);
            stringBuffer.append("HIGH(" + Msg.toHexString((short)n3) + "), ");
            stringBuffer.append("LOW(" + Msg.toHexString((short)n3) + "),\t\t/* " + object3.getName() + " */" + Msg.eol);
        }
        object2 = jCClass.packageMethodTable.elements();
        while (object2.hasMoreElements()) {
            JCMethod jCMethod = object2.nextElement();
            n3 = jCMethod.getRelocAddr();
            if (n3 > Short.MAX_VALUE) {
                n3 = exportedRefManager.getExportedReference(jCMethod);
            }
            stringBuffer.append("HIGH(" + Msg.toHexString((short)n3) + "), ");
            stringBuffer.append("LOW(" + Msg.toHexString((short)n3) + "),\t\t/* " + jCMethod.getName() + " */" + Msg.eol);
        }
        if (jCClass.interfaceVector.size() > 0) {
            stringBuffer.append(Msg.eol + "/* Implemented interface info */" + Msg.eol);
        }
        for (InterfaceTable interfaceTable : jCClass.interfaceVector) {
            byte[] byArray = interfaceTable.toByteArray();
            JCClass jCClass3 = interfaceTable.resolve();
            n3 = jCClass3.getParentPackage().equals(this.currentPackage) ? jCClass3.getRelocAddr() : exportedRefManager.getExportedReference(jCClass3);
            stringBuffer.append("HIGH(" + Msg.toHexString((short)n3) + "), ");
            stringBuffer.append("LOW(" + Msg.toHexString((short)n3) + "), ");
            for (int i = 2; i < byArray.length; ++i) {
                stringBuffer.append(byArray[i] + ", ");
            }
            stringBuffer.append(Msg.eol);
        }
        if (jCClass.isRemote()) {
            this.addRemoteClassInfo(jCClass, stringBuffer);
        }
        return true;
    }

    void outputFieldMappingInfo(JCClass jCClass) {
        Enumeration<Field> enumeration = jCClass.fieldElements();
        while (enumeration.hasMoreElements()) {
            String string;
            Field field = enumeration.nextElement();
            int n = field.getAttributes();
            if (Modifier.isStatic(n) && !Modifier.isFinal(n)) {
                int n2 = PackageTableManager.getCompBaseAddress(this.currentPackage, 2);
                string = this.getMapEntry(field.getName());
                if (string != null) {
                    int n3 = field.getRelocAddr();
                    this.defineList.append("#define " + string + " " + Msg.toAddressString(n3 += n2) + "\t/* " + field.getName() + " */" + Msg.eol);
                }
            }
            if (Modifier.isStatic(n) || (string = this.getMapEntry(field.getName())) == null) continue;
            this.defineList.append("#define " + string + " " + field.getFieldIdentifier().getFieldToken() + "\t/* " + field.getName() + " */" + Msg.eol);
        }
    }

    protected void addRemoteClassInfo(JCClass jCClass, StringBuffer stringBuffer) {
        JCPackage jCPackage = jCClass.getParentPackage();
        if (Modifier.isInterface(jCClass.getAttributes())) {
            String string = jCClass.getName();
            string = string.substring(string.lastIndexOf("/") + 1);
            stringBuffer.append(Msg.eol + "/* Remote interface name length name for " + string + " */" + Msg.eol);
            stringBuffer.append(Msg.toHexString((byte)string.length()) + ", ");
            byte[] byArray = string.getBytes();
            stringBuffer.append(Msg.toHexString(byArray, ", ") + ", " + Msg.eol);
        } else {
            Object object;
            stringBuffer.append(Msg.eol + "/* Remote Method Information Table Count */" + Msg.eol);
            stringBuffer.append(Msg.toHexString((byte)jCClass.remoteMethods.size()) + ", " + Msg.eol);
            if (jCClass.remoteMethods.size() > 0) {
                stringBuffer.append(Msg.eol + "/* Remote Method Information Table */" + Msg.eol);
                for (RemoteMethodInfo object22 : jCClass.remoteMethods) {
                    int n = jCPackage.getSignaturePool().getAddressForOffset(object22.methodSigOffset);
                    stringBuffer.append("HIGH(" + Msg.toHexString(object22.remoteMethodHash) + "), ");
                    stringBuffer.append("LOW(" + Msg.toHexString(object22.remoteMethodHash) + "), ");
                    stringBuffer.append("HIGH(" + Msg.toHexString((short)n) + "), ");
                    stringBuffer.append("LOW(" + Msg.toHexString((short)n) + "), ");
                    stringBuffer.append(Msg.toHexString(object22.flagAndToken) + ", ");
                    stringBuffer.append("\t\t/* " + object22.methodNameAndDesc + " */" + Msg.eol);
                }
            }
            stringBuffer.append(Msg.eol + "/* Anti Hash Collision String Length and String itself */" + Msg.eol);
            if (jCClass.getAntiHashCollisionString() == null) {
                stringBuffer.append(Msg.toHexString((byte)0) + ", ");
            } else {
                object = jCClass.getAntiHashCollisionString();
                stringBuffer.append(Msg.toHexString((byte)((String)object).length()) + ", ");
                stringBuffer.append(Msg.toHexString(((String)object).getBytes(), ", ") + ", " + Msg.eol);
            }
            object = jCClass.getName();
            object = ((String)object).substring(((String)object).lastIndexOf("/") + 1);
            stringBuffer.append(Msg.eol + "/* Class Name Length and Class Name */" + Msg.eol);
            stringBuffer.append(Msg.toHexString((byte)((String)object).length()) + ", ");
            byte[] byArray = ((String)object).getBytes();
            stringBuffer.append(Msg.toHexString(byArray, ", ") + ", " + Msg.eol);
            stringBuffer.append(Msg.eol + "/* Remote interface count and information */" + Msg.eol);
            stringBuffer.append(Msg.toHexString((byte)jCClass.remoteInterfaceVector.size()) + ", ");
            stringBuffer.append(Msg.eol);
            for (InterfaceTable interfaceTable : jCClass.remoteInterfaceVector) {
                int n = 0;
                JCClass jCClass2 = interfaceTable.resolve();
                n = jCClass2.getParentPackage().equals(this.currentPackage) ? jCClass2.getRelocAddr() : exportedRefManager.getExportedReference(jCClass2);
                stringBuffer.append("HIGH(" + Msg.toHexString((short)n) + "), ");
                stringBuffer.append("LOW(" + Msg.toHexString((short)n) + "), ");
                stringBuffer.append("\t\t/*" + interfaceTable.resolve().getName() + "*/");
            }
        }
    }

    protected StringBuffer getExceptionTableHeader() {
        int n = exceptionTableHeaderSize;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("/* Exception table information for " + this.currentPackage.getName() + "@" + Msg.toAddressString(this.romAddrForExceptionsAndExports) + " */" + Msg.eol);
        if (Main.FLAG_32_BIT) {
            stringBuffer.append(Msg.toHexString((byte)(this.nextExceptionTable >> 24)) + ", ");
            stringBuffer.append(Msg.toHexString((byte)(this.nextExceptionTable >> 16)) + ", ");
            stringBuffer.append(Msg.toHexString((byte)(this.nextExceptionTable >> 8)) + ", ");
            stringBuffer.append(Msg.toHexString((byte)this.nextExceptionTable) + ", ");
        } else {
            stringBuffer.append("HIGH(" + Msg.toHexString((short)this.nextExceptionTable) + "), ");
            stringBuffer.append("LOW(" + Msg.toHexString((short)this.nextExceptionTable) + "), ");
        }
        this.nextExceptionTable = this.romAddrForExceptionsAndExports;
        this.romAddrForExceptionsAndExports += exceptionTableHeaderSize;
        if (Main.FLAG_32_BIT) {
            stringBuffer.append(Msg.toHexString((byte)(this.romAddrForExceptionsAndExports >> 24)) + ", ");
            stringBuffer.append(Msg.toHexString((byte)(this.romAddrForExceptionsAndExports >> 16)) + ", ");
            stringBuffer.append(Msg.toHexString((byte)(this.romAddrForExceptionsAndExports >> 8)) + ", ");
            stringBuffer.append(Msg.toHexString((byte)this.romAddrForExceptionsAndExports) + ", ");
        } else {
            stringBuffer.append("HIGH(" + Msg.toHexString((short)this.romAddrForExceptionsAndExports) + "), ");
            stringBuffer.append("LOW(" + Msg.toHexString((short)this.romAddrForExceptionsAndExports) + "), ");
        }
        stringBuffer.append(Msg.toHexString((byte)this.packageDirectory.indexOf(this.currentPackage.getIdentifier())) + ", " + Msg.eol);
        stringBuffer.append(this.nExceptionEntries + ", ");
        stringBuffer.append(Msg.eol);
        this.romAddrForExceptionsAndExports += this.nExceptionEntries * 8 + 1;
        this.romLength += (n += this.nExceptionEntries * 8 + 1);
        return stringBuffer;
    }

    protected void outputMethods(JCClass jCClass, StringBuffer stringBuffer, StringBuffer stringBuffer2, PackageTableEntry packageTableEntry) {
        int n = packageTableEntry.componentInfoReference[1].compLocation;
        Enumeration<JCMethod> enumeration = jCClass.methodElements();
        while (enumeration.hasMoreElements()) {
            Object object;
            JCMethod jCMethod = enumeration.nextElement();
            int n2 = jCMethod.getRelocAddr();
            String string = this.getMapEntry(jCMethod.getName());
            if (string != null) {
                this.defineList.append("#define " + string + " " + Msg.toHexString((short)n2) + "\t/* " + jCMethod.getName() + " */" + Msg.eol);
                if (string.equals("MAIN_METHOD_OFFSET")) {
                    this.defineList.append("#define MAIN_METHOD_PKGID " + Msg.toHexString((short)this.packageDirectory.indexOf(this.currentPackage.getIdentifier())) + "\t/* " + this.currentPackage.getName() + " */" + Msg.eol);
                }
            }
            int n3 = jCMethod.getRelocAddr();
            stringBuffer.append(Msg.eol + "/* method@" + Msg.toAddressString(n3 + n) + ":" + Msg.toHexString((short)n3) + ": " + Modifier.toString(jCMethod.getAttributes()) + " " + jCMethod.getName() + " */" + Msg.eol);
            byte[] byArray = jCMethod.getMethodHeader();
            stringBuffer.append(Msg.toHexString(byArray, ", ") + ", " + Msg.eol);
            if (Modifier.isAbstract(jCMethod.getAttributes())) continue;
            if (Modifier.isNative(jCMethod.getAttributes())) {
                short s = jCMethod.getNativeToken();
                stringBuffer.append(Msg.toHexString((byte)s) + ", " + Msg.eol);
                continue;
            }
            Object object2 = jCMethod.statementElements();
            while (object2.hasMoreElements()) {
                object = object2.nextElement();
                this.format((Statement)object, jCMethod, stringBuffer, n);
                stringBuffer.append(", " + Msg.eol);
            }
            object2 = jCMethod.getExceptionTable();
            if (object2 == null) continue;
            object = ((ExceptionTable)object2).elements();
            while (object.hasMoreElements()) {
                ExceptionTableEntry exceptionTableEntry = (ExceptionTableEntry)object.nextElement();
                short s = (short)exceptionTableEntry.getStartOffset();
                short s2 = (short)exceptionTableEntry.getActiveLength();
                if (exceptionTableEntry.isOuterMost()) {
                    s2 = (short)(s2 | 0x8000);
                }
                short s3 = (short)exceptionTableEntry.getHandlerOffset();
                short s4 = (short)exceptionTableEntry.getCatchIndex();
                stringBuffer2.append(this.formatBigEndian(s) + ", " + this.formatBigEndian(s2) + ", " + this.formatBigEndian(s3) + ", " + this.formatBigEndian(s4) + ", " + Msg.eol);
                ++this.nExceptionEntries;
            }
        }
    }

    protected void outputStaticFields(RomMask romMask, PackageTableEntry packageTableEntry) {
        int n = packageTableEntry.componentInfoReference[2].compLocation;
        int n2 = 0;
        int n3 = 0;
        StaticFieldComponent staticFieldComponent = this.packageFields.get(this.currentPackage);
        for (int i = 1; i <= 4; ++i) {
            for (Field field : staticFieldComponent.getSegment(i)) {
                int n4;
                int n5 = field.getAttributes();
                if (!Modifier.isStatic(n5)) continue;
                FieldDescriptor fieldDescriptor = field.getDescriptor();
                if (Modifier.isFinal(field.getAttributes()) && fieldDescriptor.isPrimitive()) continue;
                n2 = field.getRelocAddr();
                n3 = n2 + n;
                StaticFieldInitializer staticFieldInitializer = field.getFieldInitializer();
                if (staticFieldInitializer != null && staticFieldInitializer.isPrimitive()) {
                    n4 = staticFieldInitializer.getPrimitiveData();
                    switch (field.size()) {
                        case 1: {
                            this.staticInit.append(Msg.toHexString((byte)n4) + ",");
                            ++this.staticInitSize;
                            break;
                        }
                        case 2: {
                            this.staticInit.append(Msg.to16BitHexString(n4));
                            this.staticInitSize += 2;
                            break;
                        }
                        case 4: {
                            this.staticInit.append(Msg.to32BitHexString(n4));
                            this.staticInitSize += 4;
                            break;
                        }
                        default: {
                            throw new InternalError();
                        }
                    }
                    this.staticInit.append("\t/* " + field.getName() + " @ " + Msg.toAddressString(n3) + ":" + Msg.toHexString((short)n2) + " */" + Msg.eol);
                    continue;
                }
                if (staticFieldInitializer != null && !staticFieldInitializer.isPrimitive()) {
                    int n6;
                    int n7;
                    byte[] byArray;
                    n4 = objectManager.addObject(this.currentEEPROMAddr);
                    this.staticInit.append(Msg.to16BitHexString(n4));
                    this.staticInit.append("\t/* " + field.getName() + " @ " + Msg.toAddressString(n3) + ":" + Msg.toHexString((short)n2) + " */" + Msg.eol);
                    this.staticInitSize += 2;
                    String string = fieldDescriptor.getDescriptorString();
                    int[] nArray = staticFieldInitializer.getArrayData();
                    if (string.equals(BYTE_CLASS_NAME)) {
                        byArray = new byte[nArray.length + 7];
                        byArray[0] = -128;
                        n7 = ((JCClass)romMask.classSymbolTable.get(BYTE_CLASS_NAME)).getRelocAddr();
                        for (n6 = 0; n6 < nArray.length; ++n6) {
                            byArray[7 + n6] = (byte)nArray[n6];
                        }
                        this.currentEEPROMAddr += 7 + nArray.length;
                    } else if (string.equals("[Z")) {
                        byArray = new byte[nArray.length + 7];
                        byArray[0] = 96;
                        n7 = ((JCClass)romMask.classSymbolTable.get("[Z")).getRelocAddr();
                        for (n6 = 0; n6 < nArray.length; ++n6) {
                            byArray[7 + n6] = (byte)nArray[n6];
                        }
                        this.currentEEPROMAddr += 7 + nArray.length;
                    } else if (string.equals("[S")) {
                        byArray = new byte[nArray.length * 2 + 7];
                        byArray[0] = -96;
                        n7 = ((JCClass)romMask.classSymbolTable.get("[S")).getRelocAddr();
                        for (n6 = 0; n6 < nArray.length; ++n6) {
                            byArray[7 + n6 * 2] = (byte)(nArray[n6] >> 8);
                            byArray[7 + n6 * 2 + 1] = (byte)nArray[n6];
                        }
                        this.currentEEPROMAddr += 7 + nArray.length * 2;
                    } else if (string.equals("[I")) {
                        byArray = new byte[nArray.length * 4 + 7];
                        byArray[0] = -64;
                        n7 = ((JCClass)romMask.classSymbolTable.get("[I")).getRelocAddr();
                        for (n6 = 0; n6 < nArray.length; ++n6) {
                            byArray[7 + n6 * 4] = (byte)(nArray[n6] >> 24);
                            byArray[7 + n6 * 4 + 1] = (byte)(nArray[n6] >> 16);
                            byArray[7 + n6 * 4 + 2] = (byte)(nArray[n6] >> 8);
                            byArray[7 + n6 * 4 + 3] = (byte)nArray[n6];
                        }
                        this.currentEEPROMAddr += 7 + nArray.length * 4;
                    } else {
                        throw new InternalError();
                    }
                    n6 = ptm.getPkgContextForIndex(this.packageDirectory.indexOf(this.currentPackage.getIdentifier()));
                    byArray[1] = (byte)(n6 << 4);
                    byArray[2] = (byte)(n7 >> 8);
                    byArray[3] = (byte)n7;
                    byArray[4] = (byte)PackageTableManager.VMArrayImplementationPkg;
                    byArray[5] = (byte)(nArray.length >> 8);
                    byArray[6] = (byte)nArray.length;
                    initializedArrays.append(Msg.toHexString(byArray, ", ") + "," + Msg.eol);
                    this.staticInitSize += byArray.length;
                    continue;
                }
                if (field.getName().equals(this.packageTableField)) {
                    this.staticInit.append(Msg.to16BitHexString(PackageTableManager.packageTableReference));
                    this.staticInit.append("\t/* " + field.getName() + " @ " + Msg.toAddressString(n3) + ":" + Msg.toHexString((short)n2) + " */" + Msg.eol);
                    continue;
                }
                if (field.getName().equals(this.packageContextTableField)) {
                    this.staticInit.append(Msg.to16BitHexString(PackageTableManager.packageContextTableReference));
                    this.staticInit.append("\t/* " + field.getName() + " @ " + Msg.toAddressString(n3) + ":" + Msg.toHexString((short)n2) + " */" + Msg.eol);
                    continue;
                }
                switch (field.size()) {
                    case 1: {
                        this.staticInit.append("0,");
                        ++this.staticInitSize;
                        break;
                    }
                    case 2: {
                        this.staticInit.append("0, 0,");
                        this.staticInitSize += 2;
                        break;
                    }
                    case 4: {
                        this.staticInit.append("0, 0, 0, 0,");
                        this.staticInitSize += 4;
                        break;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
                this.staticInit.append("\t/* " + field.getName() + " @ " + Msg.toAddressString(n3) + ":" + Msg.toHexString((short)n2) + " */" + Msg.eol);
            }
        }
    }

    protected void format(Statement statement, JCMethod jCMethod, StringBuffer stringBuffer, int n) {
        if (statement.getInstruction() == null) {
            return;
        }
        int n2 = jCMethod.getRelocAddr() + jCMethod.getHeaderSize() + statement.getRelPc();
        int n3 = n2 + n;
        stringBuffer.append("/* " + Msg.toAddressString(n3) + ":" + Msg.toHexString((short)n2) + ": */ ");
        this.format(statement.getInstruction(), stringBuffer);
    }

    protected void format(Instruction instruction, StringBuffer stringBuffer) {
        stringBuffer.append("_" + instruction.getMnemonic().toUpperCase());
        Enumeration<Operand> enumeration = instruction.operandElements();
        while (enumeration.hasMoreElements()) {
            Operand operand = enumeration.nextElement();
            this.format(operand, stringBuffer);
        }
    }

    protected void format(Operand operand, StringBuffer stringBuffer) {
        if (operand.getType() == 8) {
            Info info = operand.resolve();
            switch (info.getType()) {
                case 1: 
                case 4: 
                case 6: {
                    int n;
                    if (info.resolve() instanceof JCMethod) {
                        JCPackage jCPackage = ((JCMethod)info.resolve()).getParentClass().getParentPackage();
                        if (jCPackage.equals(this.currentPackage)) {
                            n = ((JCMethod)info.resolve()).getRelocAddr();
                            if (n > Short.MAX_VALUE) {
                                n = exportedRefManager.getExportedReference(info.resolve());
                            }
                        } else {
                            n = exportedRefManager.getExportedReference(info.resolve());
                        }
                    } else {
                        JCPackage jCPackage = ((JCClass)info.resolve()).getParentPackage();
                        n = jCPackage.equals(this.currentPackage) ? info.resolve().getRelocAddr() : exportedRefManager.getExportedReference(info.resolve());
                    }
                    stringBuffer.append(", HIGH(" + Msg.toHexString((short)n) + "), LOW(" + Msg.toHexString((short)n) + ")");
                    break;
                }
                case 5: {
                    JCPackage jCPackage = ((Field)info.resolve()).getParentClass().getParentPackage();
                    int n = jCPackage.equals(this.currentPackage) ? info.resolve().getRelocAddr() : exportedRefManager.getExportedReference(info.resolve());
                    stringBuffer.append(", HIGH(" + Msg.toHexString((short)n) + "), LOW(" + Msg.toHexString((short)n) + ")");
                    break;
                }
                case 3: {
                    int n;
                    JCMethod jCMethod = (JCMethod)info.resolve();
                    MethodIdentifier methodIdentifier = jCMethod.getMethodIdentifier();
                    int n2 = methodIdentifier.getMethodToken();
                    JCClass jCClass = jCMethod.getParentClass();
                    if (jCClass.packageMethodTable.isPkgMethod(jCMethod)) {
                        n = jCClass.packageMethodTable.getFixedPkgMethodTableBase() - jCClass.packageMethodTable.getBase();
                        n2 += n;
                    }
                    n = jCMethod.getParams();
                    stringBuffer.append(", " + Msg.toHexString((byte)n) + ", " + Msg.toHexString((byte)n2));
                    break;
                }
                case 2: {
                    Field field = (Field)info.resolve();
                    JCClass jCClass = field.getParentClass();
                    int n = field.getFieldIdentifier().getFieldToken();
                    int n3 = n + jCClass.getInstanceBase();
                    stringBuffer.append(", " + Msg.toHexString((byte)n3 >> 8) + ", " + Msg.toHexString((byte)n3));
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        } else if (operand.getType() == 7) {
            Info info = operand.resolve();
            switch (info.getType()) {
                case 2: {
                    Field field = (Field)info.resolve();
                    JCClass jCClass = field.getParentClass();
                    int n = field.getFieldIdentifier().getFieldToken();
                    int n4 = n + jCClass.getInstanceBase();
                    stringBuffer.append(", " + Msg.toHexString((byte)n4));
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        } else if (operand.size() == 1) {
            if (operand.getValue() >= 0) {
                stringBuffer.append(", " + operand.getValue());
            } else {
                stringBuffer.append(", LOW(" + operand.getValue() + ")");
            }
        } else if (operand.size() == 2) {
            stringBuffer.append(", " + (operand.getValue() >> 8 & 0xFF) + ", " + (operand.getValue() & 0xFF));
        } else if (operand.size() == 4) {
            stringBuffer.append(", " + (operand.getValue() >> 24 & 0xFF) + ", " + (operand.getValue() >> 16 & 0xFF));
            stringBuffer.append(", " + (operand.getValue() >> 8 & 0xFF) + ", " + (operand.getValue() & 0xFF));
        }
    }

    public String formatBigEndian(short s) {
        return "HIGH(" + Msg.toHexString(s) + "), " + "LOW(" + Msg.toHexString(s) + ")";
    }

    public void writeNativeMethods() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(Main.outputPath + "javacardnatives.h"));
            FileOutputStream fileOutputStream2 = new FileOutputStream(new File(Main.outputPath + "javacardnatives.c"));
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            PrintWriter printWriter2 = new PrintWriter(fileOutputStream2);
            printWriter.println("/************Auto-generated file. DO NOT EDIT*************/" + Msg.eol);
            printWriter2.println("/************Auto-generated file. DO NOT EDIT*************/" + Msg.eol);
            printWriter.println("#ifndef ____JAVA_CARD_NATIVES_H_____");
            printWriter.println("#define ____JAVA_CARD_NATIVES_H_____" + Msg.eol);
            printWriter2.println("#include \"javacardnatives.h\"");
            stringBuffer2.append("void (*nativeMethods[" + (this.nativeMethods.size() + 1) + "])()= {" + Msg.eol + "\t0," + Msg.eol);
            for (String string : this.nativeMethods) {
                stringBuffer.append("void " + string + "();" + Msg.eol);
                stringBuffer2.append("\t" + string + ", " + Msg.eol);
            }
            stringBuffer.append("extern void (*nativeMethods[" + (this.nativeMethods.size() + 1) + "])();" + Msg.eol);
            stringBuffer2.append("};" + Msg.eol);
            printWriter.println(stringBuffer);
            printWriter2.println(stringBuffer2);
            printWriter.println("#endif /*____JAVA_CARD_NATIVES_H_____*/");
            printWriter.flush();
            printWriter.close();
            printWriter2.flush();
            printWriter2.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void write(OutputStream outputStream) {
        this.writeNativeMethods();
        PrintWriter printWriter = new PrintWriter(outputStream);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com/sun/javacard/jcasm/MessagesBundle");
        Object[] objectArray = new Object[]{new Integer(0), new Integer(55)};
        printWriter.println("/*");
        printWriter.println(" * " + MessageFormat.format(resourceBundle.getString("crefbanner.1"), null));
        printWriter.println(" *");
        printWriter.println(" * " + MessageFormat.format(resourceBundle.getString("crefbanner.2"), null));
        printWriter.println(" * " + MessageFormat.format(resourceBundle.getString("maskMain.0"), objectArray));
        String string = resourceBundle.getString("main.2");
        int n = string.indexOf("\n");
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        String string4 = resourceBundle.getString("main.3");
        string3 = string4 + string3;
        printWriter.println(" * " + MessageFormat.format(string2, null));
        printWriter.println(" * " + MessageFormat.format(string3, null));
        printWriter.println(" */");
        printWriter.println(" ");
        printWriter.println("#ifdef __MASK_HEADER__" + Msg.eol);
        printWriter.println(this.defineList.toString());
        printWriter.println("#else" + Msg.eol);
        printWriter.println(this.preamble.toString());
        printWriter.println("ROM_ARRAY(u8, rommask) = {");
        printWriter.println(this.rom.toString());
        printWriter.println("};");
        printWriter.println("ROM_ARRAY(u8, staticinit) = {");
        if (this.staticInit.length() == 0) {
            printWriter.println(" NULL ");
        } else {
            printWriter.print(this.staticInit.toString());
        }
        printWriter.println("};");
        printWriter.println("#endif /* __MASK_HEADER__ */" + Msg.eol);
        printWriter.flush();
    }

    static {
        exceptionTableHeaderSize = 5;
    }
}

