/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Type;

public class TypeBase
extends Type {
    public Object value;
    public int kind;
    public static final int VOID = 1;
    public static final int BOOLEAN = 2;
    public static final int BYTE = 3;
    public static final int SHORT = 4;
    public static final int INT = 5;
    public static final int INT2 = 6;

    public TypeBase(int n) {
        this.kind = n;
    }

    public TypeBase(int n, Object object) {
        this.kind = n;
        this.value = object;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof TypeBase && ((TypeBase)object).kind == this.kind;
    }

    @Override
    public boolean isSubtype(Type type) {
        return type instanceof TypeBase && ((TypeBase)type).kind == this.kind;
    }

    @Override
    public Type lub(Type type) {
        if (type instanceof TypeBase && ((TypeBase)type).kind == this.kind) {
            return this;
        }
        return null;
    }

    public int hashCode() {
        return this.kind;
    }

    @Override
    public int wordSize() {
        return this.kind == 5 ? 2 : 1;
    }

    @Override
    public Type normalize() {
        switch (this.kind) {
            case 2: 
            case 3: {
                TypeBase typeBase = new TypeBase(4);
                typeBase.beforeNormalization = this;
                return typeBase;
            }
        }
        return this;
    }

    @Override
    String toStringAux() {
        switch (this.kind) {
            case 1: {
                return "void";
            }
            case 2: {
                return "boolean";
            }
            case 3: {
                return "byte";
            }
            case 4: {
                return "short";
            }
            case 5: {
                return "int";
            }
            case 6: {
                return "int";
            }
        }
        return "<??" + this.kind + "??>";
    }
}

