/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugproxy.classic;

import com.sun.javacard.debugproxy.Log;
import com.sun.javacard.debugproxy.classic.HandlerState;
import java.io.DataInputStream;

public interface VMPacketHandler {
    public CommandCode getCode();

    public void processResponseData(HandlerState var1, DataInputStream var2, int var3) throws Exception;

    public static enum CommandCode {
        NONE(0),
        SET_STATE(1),
        GET_PARAMETER(2),
        SET_PARAMETER(3),
        START(4),
        GET_PACKAGES_LIST(5),
        EVENTS(6),
        CLEAR_EVENTS(7),
        GET_STACK(8),
        SET_LOCAL_VARIABLES(9),
        STATE_CHANGED(10),
        GET_LOCAL_VARIABLES(11),
        GET_STATIC_FIELD(12),
        SET_STATIC_FIELD(13),
        GET_INSTANCE_FIELD(14),
        SET_INSTANCE_FIELD(15),
        GET_OBJECT_CLASS(16),
        GET_ARRAY_LENGTH(17),
        GET_ARRAY_VALUES(18),
        SET_ARRAY_VALUES(19),
        SET_PACKAGES_INFO(20),
        INVOKE_METHOD(21),
        NEW_ARRAY(22),
        NEW_INSTANCE(23),
        GET_INFO(24),
        IS_COLLECTED(25),
        GET_STRING_VALUE(26),
        UNKNOWN(255);

        int tag;

        public static CommandCode findCommandCodeByTag(int tag) {
            Log.LOG(4, "findCommandCodeByTag: TAG value: " + (tag &= 0x1F));
            for (CommandCode code : CommandCode.values()) {
                if (code.getCode() != tag) continue;
                return code;
            }
            return UNKNOWN;
        }

        private CommandCode(int tag) {
            this.tag = tag & 0xFF | 0x40;
        }

        public int getTag() {
            return this.tag;
        }

        public int getCode() {
            return this.tag & 0x1F;
        }

        public int getResponseTag() {
            return this.tag & 0x80;
        }
    }
}

