/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.classfile;

import com.sun.javacard.basicstructure.PackageDefinition;
import com.sun.javacard.classfile.JClassFile;
import com.sun.javacard.classfile.JField;
import com.sun.javacard.classfile.JMethod;
import com.sun.javacard.converter.util.Notifier;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class JPackage
extends PackageDefinition {
    private JClassFile[] java_classes;

    public JPackage(String package_name) {
        this.package_name = package_name;
    }

    public JClassFile getClass(String class_name) {
        int i = 0;
        while (i < this.java_classes.length) {
            if (this.java_classes[i].getClassName().equals(class_name)) {
                return this.java_classes[i];
            }
            ++i;
        }
        return null;
    }

    public JClassFile[] getClasses() {
        return this.java_classes;
    }

    public JField getField(String class_name, String field_name, String descriptor) {
        JClassFile java_class = this.getClass(class_name);
        if (java_class == null) {
            return null;
        }
        JField[] java_fields = java_class.getFields();
        int i = 0;
        while (i < java_fields.length) {
            if (java_fields[i].getFieldName().equals(field_name) && java_fields[i].getFieldDescriptor().equals(descriptor)) {
                return java_fields[i];
            }
            ++i;
        }
        return null;
    }

    public JMethod getMethod(String class_name, String method_name, String descriptor) {
        JClassFile java_class = this.getClass(class_name);
        if (java_class == null) {
            return null;
        }
        JMethod[] java_methods = java_class.getMethods();
        int i = 0;
        while (i < java_methods.length) {
            if (java_methods[i].getMethodName().equals(method_name) && java_methods[i].getMethodDescriptor().equals(descriptor)) {
                return java_methods[i];
            }
            ++i;
        }
        return null;
    }

    public void parse(File[] classes) {
        this.java_classes = new JClassFile[classes.length];
        int i = 0;
        while (i < classes.length) {
            JClassFile java_class = new JClassFile();
            DataInputStream dis = null;
            try {
                Notifier.progress("progress.1", classes[i].getCanonicalPath());
                dis = new DataInputStream(new BufferedInputStream(new FileInputStream(classes[i])));
                java_class.parse(dis);
                this.java_classes[i] = java_class;
            }
            catch (IOException iOException) {
                Notifier.error("converter.1", classes[i].getName());
            }
            ++i;
        }
    }

    public void resolve() {
        int i = 0;
        while (i < this.java_classes.length) {
            this.java_classes[i].resolve();
            ++i;
        }
    }

    public void setClasses(JClassFile[] java_classes) {
        this.java_classes = java_classes;
    }
}

