/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugcomponent;

import com.sun.javacard.debugcomponent.DebugComponent;
import com.sun.javacard.jcfile.JcLocalVariable;
import com.sun.javacard.jcfile.JcMethod;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class VariableInfo {
    private int index;
    private int name_index;
    private String name;
    private int descriptor_index;
    private String descriptor;
    private int start_pc;
    private int end_pc;

    public VariableInfo(JcMethod jc_method, JcLocalVariable local_var, DebugComponent debug_comp) {
        this.build(jc_method, local_var, debug_comp);
    }

    private void build(JcMethod jc_method, JcLocalVariable local_var, DebugComponent debug_comp) {
        this.index = local_var.getJcIndex();
        this.name = local_var.getName();
        this.name_index = debug_comp.addString(this.name);
        this.descriptor = local_var.getDescriptor();
        this.descriptor_index = debug_comp.addString(this.descriptor);
        this.start_pc = this.getPC(jc_method, local_var.getJcStartPCLabel());
        this.end_pc = this.getPC(jc_method, local_var.getJcEndPCLabel());
    }

    /*
     * Unable to fully structure code
     */
    private int getPC(JcMethod jc_method, int label) {
        code = jc_method.getCode();
        pc = 0;
        if (label != -1) ** GOTO lbl12
        while (code != null) {
            pc += code.getSizeInBytes();
            code = code.getNextInstr();
        }
        return pc;
lbl-1000:
        // 1 sources

        {
            if (label == code.getLabel()) {
                return code.getPC();
            }
            code = code.getNextInstr();
lbl12:
            // 2 sources

            ** while (code != null)
        }
lbl13:
        // 1 sources

        return -1;
    }

    public int getSize() {
        return 9;
    }

    public void toBinary(DataOutputStream dos) throws IOException {
        dos.writeByte(this.index);
        dos.writeShort(this.name_index);
        dos.writeShort(this.descriptor_index);
        dos.writeShort(this.start_pc);
        dos.writeShort(this.end_pc - this.start_pc);
    }

    public void toText(PrintWriter pw, int tab_level) throws IOException {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < tab_level) {
            sb.append("\t");
            ++i;
        }
        String indent = sb.toString();
        pw.println(String.valueOf(indent) + "variable_info { ");
        pw.println(String.valueOf(indent) + "\tname_index " + "\t\t//" + this.name);
        pw.println(String.valueOf(indent) + "\tdescriptor_index " + this.descriptor_index + "\t\t//" + this.descriptor);
        pw.println(String.valueOf(indent) + "\tstart_pc " + this.start_pc);
        pw.println(String.valueOf(indent) + "\tlength " + (this.end_pc - this.start_pc));
        pw.println(String.valueOf(indent) + "}");
        pw.flush();
    }
}

