/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.exportfile;

import com.sun.javacard.basicstructure.PackageDefinition;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.exportfile.EfConstant;
import com.sun.javacard.exportfile.EfConstantClassRef;
import com.sun.javacard.exportfile.EfConstantInteger;
import com.sun.javacard.exportfile.EfConstantPackage;
import com.sun.javacard.exportfile.EfConstantUtf8;
import com.sun.javacard.exportfile.ExportFileFormatError;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class EfConstantPool {
    Vector constants;

    public EfConstantPool() {
        this.constants = new Vector(50);
    }

    public EfConstantPool(int size) {
        this.constants = new Vector(size);
    }

    public int addConstantClassRef(String class_name) {
        EfConstantClassRef class_constant;
        Object[] consts = new EfConstant[this.constants.size()];
        this.constants.copyInto(consts);
        int i = 0;
        while (i < consts.length) {
            if (consts[i] instanceof EfConstantClassRef && (class_constant = (EfConstantClassRef)consts[i]).getClassName().equals(class_name)) {
                return i;
            }
            ++i;
        }
        class_constant = new EfConstantClassRef(this, class_name);
        this.constants.addElement(class_constant);
        return this.constants.size() - 1;
    }

    public int addConstantInteger(int value) {
        EfConstantInteger integer_constant;
        Object[] consts = new EfConstant[this.constants.size()];
        this.constants.copyInto(consts);
        int i = 0;
        while (i < consts.length) {
            if (consts[i] instanceof EfConstantInteger && (integer_constant = (EfConstantInteger)consts[i]).getIntValue() == value) {
                return i;
            }
            ++i;
        }
        integer_constant = new EfConstantInteger(this, value);
        this.constants.addElement(integer_constant);
        return this.constants.size() - 1;
    }

    public int addConstantPackage(PackageDefinition a_package, byte flags) {
        Object[] consts = new EfConstant[this.constants.size()];
        this.constants.copyInto(consts);
        int i = 0;
        while (i < consts.length) {
            if (consts[i] instanceof EfConstantPackage) {
                EfConstantPackage package_constant = (EfConstantPackage)consts[i];
                if (package_constant.getPackageName().equals(a_package.getPackageName())) {
                    return i;
                }
                throw new ConverterInternalError();
            }
            ++i;
        }
        EfConstantPackage package_constant = new EfConstantPackage(this, a_package, flags);
        this.constants.addElement(package_constant);
        return this.constants.size() - 1;
    }

    public int addConstantUtf8(String utf8String) {
        EfConstantUtf8 utf8_constant;
        Object[] consts = new EfConstant[this.constants.size()];
        this.constants.copyInto(consts);
        int i = 0;
        while (i < consts.length) {
            if (consts[i] instanceof EfConstantUtf8 && (utf8_constant = (EfConstantUtf8)consts[i]).getUtf8String().equals(utf8String)) {
                return i;
            }
            ++i;
        }
        utf8_constant = new EfConstantUtf8(this, utf8String);
        this.constants.addElement(utf8_constant);
        return this.constants.size() - 1;
    }

    public EfConstant getAt(int index) {
        try {
            return (EfConstant)this.constants.elementAt(index);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ExportFileFormatError();
        }
    }

    public EfConstantClassRef getConstantClassRef(int index) {
        EfConstant constant = this.getAt(index);
        if (!(constant instanceof EfConstantClassRef)) {
            throw new ExportFileFormatError();
        }
        return (EfConstantClassRef)constant;
    }

    public EfConstantInteger getConstantInteger(int index) {
        EfConstant constant = this.getAt(index);
        if (!(constant instanceof EfConstantInteger)) {
            throw new ExportFileFormatError();
        }
        return (EfConstantInteger)constant;
    }

    public EfConstantPackage getConstantPackage(int index) {
        EfConstant constant = this.getAt(index);
        if (!(constant instanceof EfConstantPackage)) {
            throw new ExportFileFormatError();
        }
        return (EfConstantPackage)constant;
    }

    public EfConstantUtf8 getConstantUtf8(int index) {
        EfConstant constant = this.getAt(index);
        if (!(constant instanceof EfConstantUtf8)) {
            throw new ExportFileFormatError();
        }
        return (EfConstantUtf8)constant;
    }

    public EfConstant[] getConstants() {
        Object[] defined_constants = new EfConstant[this.constants.size()];
        this.constants.copyInto(defined_constants);
        return defined_constants;
    }

    public int getSize() {
        return this.constants.size();
    }

    public void parse(DataInputStream dis) throws IOException {
        int size = dis.readUnsignedShort();
        int i = 0;
        while (i < size) {
            EfConstant constant;
            byte tag = dis.readByte();
            switch (tag) {
                case 13: {
                    constant = new EfConstantPackage(this);
                    break;
                }
                case 7: {
                    constant = new EfConstantClassRef(this);
                    break;
                }
                case 3: {
                    constant = new EfConstantInteger(this);
                    break;
                }
                case 1: {
                    constant = new EfConstantUtf8(this);
                    break;
                }
                default: {
                    return;
                }
            }
            constant.parse(dis);
            this.constants.addElement(constant);
            ++i;
        }
    }

    public void resolve() {
        Enumeration e = this.constants.elements();
        while (e.hasMoreElements()) {
            EfConstant constant = (EfConstant)e.nextElement();
            constant.resolve();
        }
    }

    public void toBinary(DataOutputStream dos) throws IOException {
        dos.writeShort(this.constants.size());
        Enumeration e = this.constants.elements();
        while (e.hasMoreElements()) {
            EfConstant constant = (EfConstant)e.nextElement();
            constant.toBinary(dos);
        }
    }

    public void toText(PrintWriter pw, int tab_level) throws IOException {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < tab_level) {
            sb.append("\t");
            ++i;
        }
        String indent = sb.toString();
        Enumeration e = this.constants.elements();
        while (e.hasMoreElements()) {
            EfConstant constant = (EfConstant)e.nextElement();
            constant.toText(pw, tab_level);
        }
    }
}

