/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.exportfile;

import com.sun.javacard.basicstructure.FieldDefinition;
import com.sun.javacard.converter.util.DataType;
import com.sun.javacard.exportfile.EfAttribute;
import com.sun.javacard.exportfile.EfConstantPool;
import com.sun.javacard.exportfile.EfConstantValueAttribute;
import com.sun.javacard.exportfile.ExportFileFormatError;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;

public class EfField
extends FieldDefinition {
    private int name_index;
    private int descriptor_index;
    private EfAttribute[] attributes;
    private EfConstantPool constant_pool;

    public EfField(FieldDefinition a_field, EfConstantPool cp) {
        super(a_field);
        this.constant_pool = cp;
        this.name_index = this.constant_pool.addConstantUtf8(this.field_name);
        this.descriptor_index = this.constant_pool.addConstantUtf8(this.descriptor);
        if (Modifier.isStatic(this.access_flags) && Modifier.isFinal(this.access_flags) && DataType.getType(this.descriptor) != 10) {
            if (this.value.length == 0) {
                throw new ExportFileFormatError();
            }
            this.attributes = new EfAttribute[1];
            this.attributes[0] = new EfConstantValueAttribute(cp, this.value[0]);
        } else {
            this.attributes = new EfAttribute[0];
        }
    }

    public EfField(EfConstantPool cp) {
        this.constant_pool = cp;
    }

    public EfAttribute getAttribute() {
        if (this.attributes != null) {
            return this.attributes[0];
        }
        return null;
    }

    public int getDescriptorIndex() {
        return this.descriptor_index;
    }

    public int getNameIndex() {
        return this.name_index;
    }

    public void parse(DataInputStream dis) throws IOException {
        this.token = dis.readUnsignedByte();
        this.access_flags = dis.readShort();
        this.name_index = dis.readUnsignedShort();
        this.descriptor_index = dis.readUnsignedShort();
        int attr_count = dis.readUnsignedShort();
        if (attr_count == 1) {
            this.attributes = new EfAttribute[1];
            this.attributes[0] = new EfConstantValueAttribute(this.constant_pool);
            this.attributes[0].parse(dis);
        } else if (attr_count == 0) {
            this.attributes = new EfAttribute[0];
        } else {
            throw new ExportFileFormatError();
        }
    }

    public void resolve() {
        this.field_name = this.constant_pool.getConstantUtf8(this.name_index).getUtf8String();
        this.descriptor = this.constant_pool.getConstantUtf8(this.descriptor_index).getUtf8String();
        int i = 0;
        while (i < this.attributes.length) {
            this.attributes[i].resolve();
            if (this.attributes[i] instanceof EfConstantValueAttribute) {
                this.value = new int[1];
                this.value[0] = ((EfConstantValueAttribute)this.attributes[i]).getValue();
            }
            ++i;
        }
    }

    public void toBinary(DataOutputStream dos) throws IOException {
        dos.writeByte(this.token);
        dos.writeShort(this.access_flags);
        dos.writeShort(this.name_index);
        dos.writeShort(this.descriptor_index);
        dos.writeShort(this.attributes.length);
        int i = 0;
        while (i < this.attributes.length) {
            this.attributes[i].toBinary(dos);
            ++i;
        }
    }

    public void toText(PrintWriter pw, int tab_level) throws IOException {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < tab_level) {
            sb.append("\t");
            ++i;
        }
        String indent = sb.toString();
        pw.println(String.valueOf(indent) + "field_info {");
        pw.println(String.valueOf(indent) + "\ttoken\t" + this.token);
        pw.println(String.valueOf(indent) + "\taccess_flags\t" + Modifier.toString(this.access_flags));
        pw.println(String.valueOf(indent) + "\tname_index\t" + this.name_index + "\t\t// " + this.field_name);
        pw.println(String.valueOf(indent) + "\tDescriptor_Index\t" + this.descriptor_index + "\t\t// " + this.descriptor);
        pw.println(String.valueOf(indent) + "\tattributes_count\t" + this.attributes.length);
        if (this.attributes != null) {
            pw.println(String.valueOf(indent) + "\tattributes {");
            int i2 = 0;
            while (i2 < this.attributes.length) {
                this.attributes[i2].toText(pw, tab_level + 1);
                ++i2;
            }
            pw.println(String.valueOf(indent) + "\t}");
        }
        pw.println(String.valueOf(indent) + "}");
    }
}

