/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.Operand;
import com.sun.javacard.jcasm.Token;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;

public class Instruction {
    public static final int NOP = 0;
    public static final int ACONST_NULL = 1;
    public static final int SCONST_M1 = 2;
    public static final int SCONST_0 = 3;
    public static final int SCONST_1 = 4;
    public static final int SCONST_2 = 5;
    public static final int SCONST_3 = 6;
    public static final int SCONST_4 = 7;
    public static final int SCONST_5 = 8;
    public static final int ICONST_M1 = 9;
    public static final int ICONST_0 = 10;
    public static final int ICONST_1 = 11;
    public static final int ICONST_2 = 12;
    public static final int ICONST_3 = 13;
    public static final int ICONST_4 = 14;
    public static final int ICONST_5 = 15;
    public static final int BSPUSH = 16;
    public static final int SSPUSH = 17;
    public static final int BIPUSH = 18;
    public static final int SIPUSH = 19;
    public static final int IIPUSH = 20;
    public static final int ALOAD = 21;
    public static final int SLOAD = 22;
    public static final int ILOAD = 23;
    public static final int ALOAD_0 = 24;
    public static final int ALOAD_1 = 25;
    public static final int ALOAD_2 = 26;
    public static final int ALOAD_3 = 27;
    public static final int SLOAD_0 = 28;
    public static final int SLOAD_1 = 29;
    public static final int SLOAD_2 = 30;
    public static final int SLOAD_3 = 31;
    public static final int ILOAD_0 = 32;
    public static final int ILOAD_1 = 33;
    public static final int ILOAD_2 = 34;
    public static final int ILOAD_3 = 35;
    public static final int AALOAD = 36;
    public static final int BALOAD = 37;
    public static final int SALOAD = 38;
    public static final int IALOAD = 39;
    public static final int ASTORE = 40;
    public static final int SSTORE = 41;
    public static final int ISTORE = 42;
    public static final int ASTORE_0 = 43;
    public static final int ASTORE_1 = 44;
    public static final int ASTORE_2 = 45;
    public static final int ASTORE_3 = 46;
    public static final int SSTORE_0 = 47;
    public static final int SSTORE_1 = 48;
    public static final int SSTORE_2 = 49;
    public static final int SSTORE_3 = 50;
    public static final int ISTORE_0 = 51;
    public static final int ISTORE_1 = 52;
    public static final int ISTORE_2 = 53;
    public static final int ISTORE_3 = 54;
    public static final int AASTORE = 55;
    public static final int BASTORE = 56;
    public static final int SASTORE = 57;
    public static final int IASTORE = 58;
    public static final int POP = 59;
    public static final int POP2 = 60;
    public static final int DUP = 61;
    public static final int DUP2 = 62;
    public static final int DUP_X = 63;
    public static final int SWAP_X = 64;
    public static final int SADD = 65;
    public static final int IADD = 66;
    public static final int SSUB = 67;
    public static final int ISUB = 68;
    public static final int SMUL = 69;
    public static final int IMUL = 70;
    public static final int SDIV = 71;
    public static final int IDIV = 72;
    public static final int SREM = 73;
    public static final int IREM = 74;
    public static final int SNEG = 75;
    public static final int INEG = 76;
    public static final int SSHL = 77;
    public static final int ISHL = 78;
    public static final int SSHR = 79;
    public static final int ISHR = 80;
    public static final int SUSHR = 81;
    public static final int IUSHR = 82;
    public static final int SAND = 83;
    public static final int IAND = 84;
    public static final int SOR = 85;
    public static final int IOR = 86;
    public static final int SXOR = 87;
    public static final int IXOR = 88;
    public static final int SINC = 89;
    public static final int IINC = 90;
    public static final int S2B = 91;
    public static final int S2I = 92;
    public static final int I2B = 93;
    public static final int I2S = 94;
    public static final int ICMP = 95;
    public static final int IFEQ = 96;
    public static final int IFNE = 97;
    public static final int IFLT = 98;
    public static final int IFGE = 99;
    public static final int IFGT = 100;
    public static final int IFLE = 101;
    public static final int IFNULL = 102;
    public static final int IFNONNULL = 103;
    public static final int IF_ACMPEQ = 104;
    public static final int IF_ACMPNE = 105;
    public static final int IF_SCMPEQ = 106;
    public static final int IF_SCMPNE = 107;
    public static final int IF_SCMPLT = 108;
    public static final int IF_SCMPGE = 109;
    public static final int IF_SCMPGT = 110;
    public static final int IF_SCMPLE = 111;
    public static final int GOTO = 112;
    public static final int JSR = 113;
    public static final int RET = 114;
    public static final int STABLESWITCH = 115;
    public static final int ITABLESWITCH = 116;
    public static final int SLOOKUPSWITCH = 117;
    public static final int ILOOKUPSWITCH = 118;
    public static final int ARETURN = 119;
    public static final int SRETURN = 120;
    public static final int IRETURN = 121;
    public static final int RETURN = 122;
    public static final int GETSTATIC_A = 123;
    public static final int GETSTATIC_B = 124;
    public static final int GETSTATIC_S = 125;
    public static final int GETSTATIC_I = 126;
    public static final int PUTSTATIC_A = 127;
    public static final int PUTSTATIC_B = 128;
    public static final int PUTSTATIC_S = 129;
    public static final int PUTSTATIC_I = 130;
    public static final int GETFIELD_A = 131;
    public static final int GETFIELD_B = 132;
    public static final int GETFIELD_S = 133;
    public static final int GETFIELD_I = 134;
    public static final int PUTFIELD_A = 135;
    public static final int PUTFIELD_B = 136;
    public static final int PUTFIELD_S = 137;
    public static final int PUTFIELD_I = 138;
    public static final int INVOKEVIRTUAL = 139;
    public static final int INVOKESPECIAL = 140;
    public static final int INVOKESTATIC = 141;
    public static final int INVOKEINTERFACE = 142;
    public static final int NEW = 143;
    public static final int NEWARRAY = 144;
    public static final int ANEWARRAY = 145;
    public static final int ARRAYLENGTH = 146;
    public static final int ATHROW = 147;
    public static final int CHECKCAST = 148;
    public static final int INSTANCEOF = 149;
    public static final int SINC_W = 150;
    public static final int IINC_W = 151;
    public static final int IFEQ_W = 152;
    public static final int IFNE_W = 153;
    public static final int IFLT_W = 154;
    public static final int IFGE_W = 155;
    public static final int IFGT_W = 156;
    public static final int IFLE_W = 157;
    public static final int IFNULL_W = 158;
    public static final int IFNONNULL_W = 159;
    public static final int IF_ACMPEQ_W = 160;
    public static final int IF_ACMPNE_W = 161;
    public static final int IF_SCMPEQ_W = 162;
    public static final int IF_SCMPNE_W = 163;
    public static final int IF_SCMPLT_W = 164;
    public static final int IF_SCMPGE_W = 165;
    public static final int IF_SCMPGT_W = 166;
    public static final int IF_SCMPLE_W = 167;
    public static final int GOTO_W = 168;
    public static final int GETFIELD_A_W = 169;
    public static final int GETFIELD_B_W = 170;
    public static final int GETFIELD_S_W = 171;
    public static final int GETFIELD_I_W = 172;
    public static final int GETFIELD_A_THIS = 173;
    public static final int GETFIELD_B_THIS = 174;
    public static final int GETFIELD_S_THIS = 175;
    public static final int GETFIELD_I_THIS = 176;
    public static final int PUTFIELD_A_W = 177;
    public static final int PUTFIELD_B_W = 178;
    public static final int PUTFIELD_S_W = 179;
    public static final int PUTFIELD_I_W = 180;
    public static final int PUTFIELD_A_THIS = 181;
    public static final int PUTFIELD_B_THIS = 182;
    public static final int PUTFIELD_S_THIS = 183;
    public static final int PUTFIELD_I_THIS = 184;
    public static final int IMPDEP1 = 254;
    public static final int IMPDEP2 = 255;
    protected static final String[] mnemonicTable = new String[]{"nop", "aconst_null", "sconst_m1", "sconst_0", "sconst_1", "sconst_2", "sconst_3", "sconst_4", "sconst_5", "iconst_m1", "iconst_0", "iconst_1", "iconst_2", "iconst_3", "iconst_4", "iconst_5", "bspush", "sspush", "bipush", "sipush", "iipush", "aload", "sload", "iload", "aload_0", "aload_1", "aload_2", "aload_3", "sload_0", "sload_1", "sload_2", "sload_3", "iload_0", "iload_1", "iload_2", "iload_3", "aaload", "baload", "saload", "iaload", "astore", "sstore", "istore", "astore_0", "astore_1", "astore_2", "astore_3", "sstore_0", "sstore_1", "sstore_2", "sstore_3", "istore_0", "istore_1", "istore_2", "istore_3", "aastore", "bastore", "sastore", "iastore", "pop", "pop2", "dup", "dup2", "dup_x", "swap_x", "sadd", "iadd", "ssub", "isub", "smul", "imul", "sdiv", "idiv", "srem", "irem", "sneg", "ineg", "sshl", "ishl", "sshr", "ishr", "sushr", "iushr", "sand", "iand", "sor", "ior", "sxor", "ixor", "sinc", "iinc", "s2b", "s2i", "i2b", "i2s", "icmp", "ifeq", "ifne", "iflt", "ifge", "ifgt", "ifle", "ifnull", "ifnonnull", "if_acmpeq", "if_acmpne", "if_scmpeq", "if_scmpne", "if_scmplt", "if_scmpge", "if_scmpgt", "if_scmple", "goto", "jsr", "ret", "stableswitch", "itableswitch", "slookupswitch", "ilookupswitch", "areturn", "sreturn", "ireturn", "return", "getstatic_a", "getstatic_b", "getstatic_s", "getstatic_i", "putstatic_a", "putstatic_b", "putstatic_s", "putstatic_i", "getfield_a", "getfield_b", "getfield_s", "getfield_i", "putfield_a", "putfield_b", "putfield_s", "putfield_i", "invokevirtual", "invokespecial", "invokestatic", "invokeinterface", "new", "newarray", "anewarray", "arraylength", "athrow", "checkcast", "instanceof", "sinc_w", "iinc_w", "ifeq_w", "ifne_w", "iflt_w", "ifge_w", "ifgt_w", "ifle_w", "ifnull_w", "ifnonnull_w", "if_acmpeq_w", "if_acmpne_w", "if_scmpeq_w", "if_scmpne_w", "if_scmplt_w", "if_scmpge_w", "if_scmpgt_w", "if_scmple_w", "goto_w", "getfield_a_w", "getfield_b_w", "getfield_s_w", "getfield_i_w", "getfield_a_this", "getfield_b_this", "getfield_s_this", "getfield_i_this", "putfield_a_w", "putfield_b_w", "putfield_s_w", "putfield_i_w", "putfield_a_this", "putfield_b_this", "putfield_s_this", "putfield_i_this", "reserved185", "reserved186", "reserved187", "reserved188", "reserved189", "reserved190", "reserved191", "reserved192", "reserved193", "reserved194", "reserved195", "reserved196", "reserved197", "reserved198", "reserved199", "reserved200", "reserved201", "reserved202", "reserved203", "reserved204", "reserved205", "reserved206", "reserved207", "reserved208", "reserved209", "reserved210", "reserved211", "reserved212", "reserved213", "reserved214", "reserved215", "reserved216", "reserved217", "reserved218", "reserved219", "reserved220", "reserved221", "reserved222", "reserved223", "reserved224", "reserved225", "reserved226", "reserved227", "reserved228", "reserved229", "reserved230", "reserved231", "reserved232", "reserved233", "reserved234", "reserved235", "reserved236", "reserved237", "reserved238", "reserved239", "reserved240", "reserved241", "reserved242", "reserved243", "reserved244", "reserved245", "reserved246", "reserved247", "reserved248", "reserved249", "reserved250", "reserved251", "reserved252", "reserved253", "impdep1", "impdep2"};
    protected int opcode;
    protected int lineNumber;
    protected int column;
    protected Vector operandVector;

    public Instruction(int opcode, Token tok) {
        this.opcode = opcode;
        this.lineNumber = tok.beginLine;
        this.column = tok.beginColumn;
    }

    public void addOperand(Operand o) {
        if (this.operandVector == null) {
            this.operandVector = new Vector(2);
        }
        this.operandVector.addElement(o);
    }

    public Enumeration elements() {
        return new OperandEnumerator(this.operandVector);
    }

    public String getMnemonic() {
        return mnemonicTable[this.opcode];
    }

    public static String getMnemonic(int opcode) {
        return mnemonicTable[opcode];
    }

    public int getOpcode() {
        return this.opcode;
    }

    protected void methodFixup(Hashtable symtab, int relPc) {
        Enumeration e = this.operandElements();
        while (e.hasMoreElements()) {
            Operand o = (Operand)e.nextElement();
            o.methodFixup(symtab, relPc);
        }
    }

    public Enumeration operandElements() {
        return new OperandEnumerator(this.operandVector);
    }

    public int size() {
        int size = 1;
        Enumeration e = this.operandElements();
        while (e.hasMoreElements()) {
            size += ((Operand)e.nextElement()).size();
        }
        return size;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getMnemonic());
        Enumeration e = this.operandElements();
        while (e.hasMoreElements()) {
            Operand o = (Operand)e.nextElement();
            sb.append(" " + o.toString());
        }
        return sb.toString();
    }

    static class OperandEnumerator
    implements Enumeration {
        Enumeration enumerator;

        OperandEnumerator(Vector v) {
            if (v != null) {
                this.enumerator = v.elements();
            }
        }

        public boolean hasMoreElements() {
            if (this.enumerator == null) {
                return false;
            }
            return this.enumerator.hasMoreElements();
        }

        public Object nextElement() {
            if (this.enumerator == null) {
                throw new NoSuchElementException("OperandEnumerator");
            }
            return this.enumerator.nextElement();
        }
    }
}

