/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.Assert;
import com.sun.javacard.jcasm.Globals;
import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.Token;
import java.util.Hashtable;

public class Operand {
    public static final int TYPE_BYTE = 1;
    public static final int TYPE_UNSIGNED_BYTE = 2;
    public static final int TYPE_SHORT = 3;
    public static final int TYPE_UNSIGNED_SHORT = 4;
    public static final int TYPE_INTEGER = 5;
    public static final int TYPE_UNSIGNED_INTEGER = 6;
    public static final int TYPE_BYTE_CONSTANT_POOL_INDEX = 7;
    public static final int TYPE_CONSTANT_POOL_INDEX = 8;
    public static final int TYPE_LOCAL_INDEX = 9;
    public static final int TYPE_BYTE_BRANCH = 10;
    public static final int TYPE_SHORT_BRANCH = 11;
    public static final int TYPE_ARRAY = 12;
    protected int lineNumber;
    protected int column;
    protected int type;
    protected int intValue;
    protected String stringValue;
    private boolean needsFixup;
    protected Info resolvedTo;

    public Operand(int data, int type, Token tok) {
        this.intValue = data;
        this.type = type;
        if (tok != null) {
            this.lineNumber = tok.beginLine;
            this.column = tok.beginColumn;
        }
    }

    public Operand(String data, int type, Token tok) {
        this.stringValue = data.toLowerCase();
        this.type = type;
        if (tok != null) {
            this.lineNumber = tok.beginLine;
            this.column = tok.beginColumn;
        }
        this.needsFixup = true;
    }

    public int getColumn() {
        return this.column;
    }

    public int getLine() {
        return this.lineNumber;
    }

    public int getType() {
        return this.type;
    }

    public int getValue() {
        return this.intValue;
    }

    public boolean isResolved() {
        return this.resolvedTo != null;
    }

    protected void methodFixup(Hashtable symtab, int relPc) {
        if (!this.needsFixup) {
            return;
        }
        Integer datum = (Integer)symtab.get(this.stringValue);
        if (datum == null) {
            Object[] arguments = new Object[]{this.stringValue, new Integer(this.lineNumber), new Integer(this.column)};
            Msg.error("operand.0", arguments);
            return;
        }
        int targetAddr = datum;
        switch (this.type) {
            case 11: {
                this.intValue = targetAddr - relPc;
                if (this.intValue < Short.MIN_VALUE || this.intValue > Short.MAX_VALUE) {
                    this.intValue = 0;
                    Object[] arguments = new Object[]{"?", this.stringValue, new Integer(this.lineNumber), new Integer(this.column)};
                    Msg.error("parser.ShortBranch", arguments);
                }
                this.needsFixup = false;
                break;
            }
            case 10: {
                this.intValue = targetAddr - relPc;
                if (this.intValue < -128 || this.intValue > 127) {
                    this.intValue = 0;
                    Object[] arguments = new Object[]{"?", this.stringValue, new Integer(this.lineNumber), new Integer(this.column)};
                    Msg.error("parser.ByteBranch", arguments);
                    ++Globals.errors;
                }
                this.needsFixup = false;
                break;
            }
        }
    }

    public Info resolve() {
        Assert.PreCondition(this.resolvedTo != null, "resolvedTo != null");
        Assert.PreCondition(this.type == 8 || this.type == 7, "type");
        return this.resolvedTo;
    }

    public void resolve(Info info) {
        Assert.PreCondition(info != null, "info != null");
        Assert.PreCondition(this.type == 8 || this.type == 7, "type");
        this.resolvedTo = info;
    }

    public int size() {
        int size = 0;
        switch (this.type) {
            case 1: 
            case 2: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                size = 1;
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 11: {
                size = 2;
                break;
            }
            case 5: 
            case 6: {
                size = 4;
                break;
            }
            default: {
                Assert.Assert(false, "type");
            }
        }
        return size;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        switch (this.size()) {
            case 1: {
                sb.append(Msg.toHexString((byte)this.intValue));
                break;
            }
            case 2: {
                sb.append(Msg.toHexString((short)this.intValue));
                break;
            }
            case 4: {
                sb.append(Msg.toHexString(this.intValue));
                break;
            }
        }
        return sb.toString();
    }
}

