/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcfile.instructions;

import com.sun.javacard.jcfile.instructions.JcByteCode;

public abstract class JcInstruction {
    protected int label = -1;
    protected int opcode;
    protected JcInstruction prev_instr = null;
    protected JcInstruction next_instr = null;
    protected int source_line_number;
    protected int pc;

    public JcInstruction(int opcode) {
        this.opcode = opcode;
    }

    public int getLabel() {
        return this.label;
    }

    public String getMnemonic() {
        return JcByteCode.getMnemonic(this.opcode);
    }

    public JcInstruction getNextInstr() {
        return this.next_instr;
    }

    public int getOpcode() {
        return this.opcode;
    }

    public int getPC() {
        return this.pc;
    }

    public JcInstruction getPrevInstr() {
        return this.prev_instr;
    }

    public abstract int getSizeInBytes();

    public int getSourceLineNumber() {
        return this.source_line_number;
    }

    public void setLabel(int label) {
        this.label = label;
    }

    public void setNextInstr(JcInstruction next_instr) {
        this.next_instr = next_instr;
    }

    public void setOpcode(int opcode) {
        this.opcode = opcode;
    }

    public void setPC(int pc) {
        this.pc = pc;
    }

    public void setPrevInstr(JcInstruction prev_instr) {
        this.prev_instr = prev_instr;
    }

    public void setSourceLineNumber(int line_num) {
        this.source_line_number = line_num;
    }
}

