/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.nbtasks;

import com.sun.javacard.nbtasks.JCToolTask;
import java.io.File;
import java.io.FileFilter;
import org.apache.tools.ant.BuildException;

public class JCConverterTask
extends JCToolTask {
    public JCConverterTask() {
        super("com.sun.javacard.converter.Main");
    }

    public void execute() throws BuildException {
        if (!this.isClassicApplication() && !this.isClassicLibrary()) {
            return;
        }
        String string = this.getExportPath();
        string = string != null && string.length() > 0 ? string + File.pathSeparator : "";
        this.createArg().setValue("-exportpath");
        File file = this.getFileProp("javacard.home");
        StringBuilder stringBuilder = new StringBuilder(file.getAbsolutePath());
        if (!stringBuilder.toString().endsWith(File.separator)) {
            stringBuilder.append(File.separator);
        }
        stringBuilder.append("api_export_files");
        string = string + stringBuilder.toString();
        this.createArg().setValue(string);
        File file2 = this.getFileProp("build.classes.dir");
        this.createArg().setValue("-classdir");
        this.createArg().setFile(file2);
        File file3 = this.getFileProp("dist.dir");
        this.createArg().setValue("-d");
        this.createArg().setFile(file3);
        this.createArg().setValue("-i");
        this.setAdditionalArguments();
        this.createArg().setValue(this.getPackageName());
        this.createArg().setValue(this.getPackageAID());
        this.createArg().setValue("1.0");
        super.execute();
    }

    protected void setAdditionalArguments() throws BuildException {
    }

    protected String getPackageName() throws BuildException {
        File file = this.getFileProp("build.classes.dir");
        File[] fileArray = null;
        fileArray = JCConverterTask.searchFiles(file, "class");
        if (fileArray == null || fileArray.length == 0) {
            throw new BuildException("No classes found in directory: " + file);
        }
        String string = fileArray[0].getParent();
        string = string.substring(file.getPath().length() + 1);
        return string.replace(File.separatorChar, '.');
    }

    protected String getPackageAID() {
        String string = this.getProp("package.aid");
        string = string.substring("//aid/".length());
        string = string.replaceAll("/", "");
        String string2 = "";
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[2];
        int n = 0;
        while (n < cArray.length) {
            cArray2[0] = cArray[n++];
            cArray2[1] = cArray[n++];
            string2 = string2 + "0x" + new String(cArray2) + ":";
        }
        return string2.substring(0, string2.length() - 1);
    }

    static File[] searchFiles(File file, final String string) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.getName().endsWith("." + string);
                }
            });
            if (fileArray == null || fileArray.length == 0) {
                File file2;
                File[] fileArray2 = file.listFiles();
                int n = fileArray2.length;
                for (int i = 0; i < n && ((fileArray = JCConverterTask.searchFiles(file2 = fileArray2[i], string)) == null || fileArray.length == 0); ++i) {
                }
            }
            return fileArray;
        }
        return null;
    }
}

