/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.checkers;

import com.sun.javacard.basicstructure.ClassDefinition;
import com.sun.javacard.basicstructure.MethodDefinition;
import com.sun.javacard.basicstructure.PackageDefinition;
import com.sun.javacard.converter.ConverterException;
import com.sun.javacard.converter.util.DataType;
import com.sun.javacard.converter.util.MethodDescriptor;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.converter.util.Strings;
import com.sun.javacard.exportfile.EfClass;
import com.sun.javacard.exportfile.EfExportFile;
import com.sun.javacard.exportfile.EfField;
import com.sun.javacard.exportfile.EfMethod;
import com.sun.javacard.exportfile.ExportFileManager;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcException;
import com.sun.javacard.jcfile.JcField;
import com.sun.javacard.jcfile.JcImportTokenTable;
import com.sun.javacard.jcfile.JcImportTokenTableEntry;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.JcPackage;
import com.sun.javacard.jcfile.constants.JcConstantClassRef;
import com.sun.javacard.jcfile.constants.JcConstantFieldRef;
import com.sun.javacard.jcfile.constants.JcConstantMethodRef;
import com.sun.javacard.jcfile.constants.JcConstantSuperMethodRef;
import com.sun.javacard.jcfile.instructions.JcInstrClassRef;
import com.sun.javacard.jcfile.instructions.JcInstrFieldRef;
import com.sun.javacard.jcfile.instructions.JcInstrInterfaceRef;
import com.sun.javacard.jcfile.instructions.JcInstrMethodRef;
import com.sun.javacard.jcfile.instructions.JcInstruction;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Vector;

public class ReferenceChecker {
    private static final int NO_LINE_NUMBER = -1;
    private JcPackage jc_package;
    private JcImportTokenTable token_table;
    private String this_package_name;
    private ExportFileManager ex_manager;
    private boolean check_export_only;

    public ReferenceChecker(JcPackage jc_package, ExportFileManager ex_manager, boolean check_export_only) {
        this.jc_package = jc_package;
        this.this_package_name = jc_package.getPackageName();
        this.token_table = new JcImportTokenTable();
        this.ex_manager = ex_manager;
        this.check_export_only = check_export_only;
    }

    public void check() throws Exception {
        JcClass[] jc_classes = this.jc_package.getClasses();
        int i = 0;
        while (i < jc_classes.length) {
            JcClass jc_class = jc_classes[i];
            this.checkClass(jc_class);
            ++i;
        }
        PackageDefinition[] import_packages = this.constructImportPackageInfos();
        if (import_packages.length > 128) {
            Notifier.error("subset.52");
            throw new ConverterException();
        }
        ReferenceChecker.checkPackageAIDs(import_packages);
        this.token_table.setImportPackageInfos(import_packages);
        this.jc_package.setImportTokenTable(this.token_table);
    }

    private void checkClass(JcClass jc_class) throws Exception {
        int class_access_flags = jc_class.getAccessFlags();
        if (!this.check_export_only || Modifier.isPublic(class_access_flags)) {
            String super_class_name = jc_class.getSuperClassName();
            if (super_class_name != null) {
                if (Names.getPackageName(super_class_name).equals(this.this_package_name)) {
                    Object[] args;
                    if (this.jc_package.getClass(super_class_name) == null) {
                        args = new String[]{jc_class.getClassName().replace('/', '.'), super_class_name.replace('/', '.')};
                        Notifier.error("linking.3", args);
                    } else if (!jc_class.isInterfaceType() && this.jc_package.getClass(super_class_name).isInterfaceType()) {
                        args = new String[]{jc_class.getClassName().replace('/', '.'), super_class_name.replace('/', '.')};
                        Notifier.error("linking.23", args);
                    }
                } else {
                    EfClass ef_super_class = this.ex_manager.getClass(super_class_name);
                    if (ef_super_class == null) {
                        Object[] args = new String[]{jc_class.getClassName().replace('/', '.'), super_class_name.replace('/', '.'), Names.getExportFileName(Names.getPackageName(super_class_name))};
                        Notifier.error("linking.2", args);
                    } else {
                        this.token_table.addClassEntry(super_class_name, ef_super_class.getClassToken());
                    }
                }
            }
            if (Notifier.getErrorCount() > 0) {
                return;
            }
            this.checkSuperInterfaces(jc_class);
            JcField[] jc_fields = jc_class.getFields();
            int j = 0;
            while (j < jc_fields.length) {
                JcField jc_field = jc_fields[j];
                int field_access_flags = jc_field.getAccessFlags();
                if (!this.check_export_only || Modifier.isPublic(field_access_flags) || Modifier.isProtected(field_access_flags)) {
                    this.checkFieldDescriptor(jc_class, jc_class.getClassName(), jc_field.getFieldName(), jc_field.getFieldDescriptor(), -1);
                }
                ++j;
            }
            JcMethod[] jc_methods = jc_class.getMethods();
            int j2 = 0;
            while (j2 < jc_methods.length) {
                JcMethod jc_method = jc_methods[j2];
                int method_access_flags = jc_method.getAccessFlags();
                if (!this.check_export_only || Modifier.isPublic(method_access_flags) || Modifier.isProtected(method_access_flags)) {
                    this.checkMethodDescriptor(jc_class, jc_class.getClassName(), jc_method.getMethodName(), jc_method.getMethodDescriptor(), -1);
                }
                if (!this.check_export_only) {
                    this.checkBytecode(jc_class, jc_method);
                    this.checkExceptionTable(jc_class, jc_method);
                }
                ++j2;
            }
        }
    }

    private void checkSuperInterfaces(JcClass jc_class) throws Exception {
        String[] super_interfaces = this.check_export_only ? jc_class.getPublicSuperInterfaces() : jc_class.getSuperInterfaces();
        int i = 0;
        while (i < super_interfaces.length) {
            String super_interface = super_interfaces[i];
            if (Names.getPackageName(super_interface).equals(this.this_package_name)) {
                Object[] args;
                if (this.jc_package.getClass(super_interface) == null) {
                    args = new String[]{jc_class.getClassName().replace('/', '.'), super_interface.replace('/', '.')};
                    Notifier.error("linking.5", args);
                } else if (jc_class.isInterfaceType() && !this.jc_package.getClass(super_interface).isInterfaceType()) {
                    args = new String[]{jc_class.getClassName().replace('/', '.'), super_interface.replace('/', '.')};
                    Notifier.error("linking.24", args);
                }
            } else {
                EfClass ef_super_interface = this.ex_manager.getClass(super_interface);
                if (ef_super_interface == null) {
                    Object[] args = new String[]{jc_class.getClassName().replace('/', '.'), super_interface.replace('/', '.'), Names.getExportFileName(Names.getPackageName(super_interface))};
                    Notifier.error("linking.4", args);
                } else {
                    this.token_table.addClassEntry(super_interface, ef_super_interface.getClassToken());
                }
            }
            ++i;
        }
    }

    private String checkField(JcClass jc_class, String class_name, String field_name, String descriptor, int line_number) throws Exception {
        if (Names.getPackageName(class_name).equals(this.this_package_name)) {
            JcClass jc_field_class = this.jc_package.getClass(class_name);
            if (jc_field_class == null) {
                Object[] args = new String[]{jc_class.getClassName().replace('/', '.'), class_name.replace('/', '.')};
                Notifier.error(line_number, "linking.7", args);
                Object[] args1 = new String[]{jc_class.getClassName().replace('/', '.'), field_name, class_name.replace('/', '.'), DataType.getTypeString(descriptor)};
                Notifier.error(line_number, "linking.13", args1);
            } else if (this.jc_package.getField(class_name, field_name, descriptor) == null) {
                boolean done = false;
                boolean class_not_found = false;
                String current_name = jc_field_class.getClassName();
                while (!done) {
                    if (this.jc_package.getClass(current_name) != null) {
                        String super_name = this.jc_package.getClass(current_name).getSuperClassName();
                        if (this.jc_package.getClass(super_name) != null) {
                            current_name = super_name;
                            if (this.jc_package.getField(current_name, field_name, descriptor) == null) continue;
                            done = true;
                            return current_name;
                        }
                        current_name = super_name;
                        EfClass ef_class = this.ex_manager.getClass(current_name);
                        if (ef_class.getField(field_name, descriptor) != null) {
                            done = true;
                            this.token_table.addFieldEntry(current_name, this.ex_manager.getClass(current_name).getClassToken(), field_name, ef_class.getField(field_name, descriptor).getFieldToken());
                            return current_name;
                        }
                        String[] super_names = ef_class.getSuperClassNames();
                        int k = 0;
                        while (k < super_names.length) {
                            ef_class = this.ex_manager.getClass(super_names[k]);
                            if (ef_class.getField(field_name, descriptor) != null) {
                                done = true;
                                this.token_table.addFieldEntry(super_names[k], this.ex_manager.getClass(super_names[k]).getClassToken(), field_name, ef_class.getField(field_name, descriptor).getFieldToken());
                                return super_names[k];
                            }
                            ++k;
                        }
                        done = true;
                        class_not_found = true;
                        continue;
                    }
                    done = true;
                    class_not_found = true;
                }
                if (class_not_found) {
                    int access_flags = jc_field_class.getAccessFlags();
                    Object[] args = new String[]{jc_class.getClassName().replace('/', '.'), field_name, class_name.replace('/', '.'), DataType.getTypeString(descriptor)};
                    if (Modifier.isInterface(access_flags)) {
                        Notifier.error(line_number, "linking.19", args);
                    } else {
                        Notifier.error(line_number, "linking.13", args);
                    }
                }
            }
        } else {
            EfClass ef_class = this.ex_manager.getClass(class_name);
            if (ef_class == null) {
                Object[] args = new String[]{jc_class.getClassName().replace('/', '.'), class_name.replace('/', '.'), Names.getExportFileName(Names.getPackageName(class_name))};
                Notifier.error(line_number, "linking.6", args);
                throw new ConverterException();
            }
            EfField ef_field = this.ex_manager.getField(class_name, field_name, descriptor);
            if (ef_field == null) {
                boolean found = false;
                EfClass efc = this.ex_manager.getClass(class_name);
                String[] supers = efc.getSuperClassNames();
                int i = 0;
                while (!found && i < supers.length) {
                    EfField ef_field1 = this.ex_manager.getField(supers[i], field_name, descriptor);
                    if (ef_field1 != null) {
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (!found) {
                    Object[] args = new Object[]{jc_class.getClassName().replace('/', '.'), field_name, class_name.replace('/', '.'), Names.getExportFileName(Names.getPackageName(class_name))};
                    int access_flags = ef_class.getAccessFlags();
                    if (Modifier.isInterface(access_flags)) {
                        Notifier.error(line_number, "linking.18", args);
                    } else {
                        Notifier.error(line_number, "linking.12", args);
                    }
                }
            } else {
                this.token_table.addFieldEntry(class_name, ef_class.getClassToken(), field_name, ef_field.getFieldToken());
            }
        }
        return null;
    }

    private void checkFieldDescriptor(JcClass jc_class, String class_name, String field_name, String descriptor, int line_number) throws Exception {
        String referenced_class = Names.getClassNameFromDescriptor(descriptor);
        if (referenced_class == null) {
            return;
        }
        if (Names.getPackageName(referenced_class).equals(this.this_package_name)) {
            if (this.jc_package.getClass(referenced_class) == null) {
                Object[] args = new String[]{jc_class.getClassName().replace('/', '.'), referenced_class.replace('/', '.'), class_name.replace('/', '.') + "." + field_name};
                Notifier.error(line_number, "linking.14", args);
            }
        } else {
            EfClass ef_referenced_class = this.ex_manager.getClass(referenced_class);
            if (ef_referenced_class == null) {
                Object[] args_1 = new String[]{jc_class.getClassName().replace('/', '.'), referenced_class.replace('/', '.'), Names.getExportFileName(Names.getPackageName(referenced_class))};
                Notifier.error(line_number, "linking.6", args_1);
                Object[] args_2 = new String[]{jc_class.getClassName().replace('/', '.'), referenced_class.replace('/', '.'), class_name.replace('/', '.') + "." + field_name};
                Notifier.error(line_number, "linking.14", args_2);
            } else {
                this.token_table.addClassEntry(referenced_class, ef_referenced_class.getClassToken());
            }
        }
    }

    private String checkMethod(JcClass jc_class, String class_name, String method_name, String descriptor, int line_number) throws Exception {
        String result = null;
        if (Names.getPackageName(class_name).equals(this.this_package_name)) {
            JcClass jc_method_class = this.jc_package.getClass(class_name);
            if (jc_method_class == null) {
                Object[] args = new String[]{jc_class.getClassName().replace('/', '.'), class_name.replace('/', '.')};
                Notifier.error(line_number, "linking.7", args);
                Object[] args1 = new Object[]{jc_class.getClassName().replace('/', '.'), Names.getMethodNameInJavaStyle(method_name, descriptor), class_name.replace('/', '.')};
                Notifier.error(line_number, "linking.9", args1);
            } else if (this.jc_package.getMethod(class_name, method_name, descriptor) == null) {
                if (!this.checkMethodTable(jc_method_class, method_name, descriptor)) {
                    Object[] args = new Object[]{jc_class.getClassName().replace('/', '.'), Names.getMethodNameInJavaStyle(method_name, descriptor), class_name.replace('/', '.')};
                    int access_flags = jc_method_class.getAccessFlags();
                    if (Modifier.isInterface(access_flags)) {
                        Notifier.error(line_number, "linking.17", args);
                    } else {
                        String current_class_name = jc_method_class.getClassName();
                        ClassDefinition current_class = null;
                        while ((current_class_name = (current_class = Names.getPackageName(current_class_name).equals(this.jc_package.getPackageName()) && this.jc_package.getClass(current_class_name) != null ? this.jc_package.getClass(current_class_name) : this.ex_manager.getClass(current_class_name)).getSuperClassName()) != null) {
                            if (Names.getPackageName(current_class_name).equals(this.jc_package.getPackageName()) && this.jc_package.getClass(current_class_name) != null) {
                                JcClass jc_class_to_check = this.jc_package.getClass(current_class_name);
                                JcMethod jc_method_found = jc_class_to_check.getMethod(method_name, descriptor);
                                if (jc_method_found == null) continue;
                                return current_class_name;
                            }
                            EfClass ef_class_to_check = this.ex_manager.getClass(current_class_name);
                            int method_token = ef_class_to_check.getMethod(method_name, descriptor).getMethodToken();
                            this.token_table.addMethodEntry(current_class_name, ef_class_to_check.getClassToken(), method_name, descriptor, method_token);
                            return current_class_name;
                        }
                        Notifier.error(line_number, "linking.9", args);
                    }
                } else {
                    String current_class_name = jc_method_class.getClassName();
                    ClassDefinition current_class = null;
                    while ((current_class_name = (current_class = Names.getPackageName(current_class_name).equals(this.jc_package.getPackageName()) && this.jc_package.getClass(current_class_name) != null ? this.jc_package.getClass(current_class_name) : this.ex_manager.getClass(current_class_name)).getSuperClassName()) != null) {
                        if (Names.getPackageName(current_class_name).equals(this.jc_package.getPackageName()) && this.jc_package.getClass(current_class_name) != null) {
                            JcClass jc_class_to_check = this.jc_package.getClass(current_class_name);
                            JcMethod jc_method_found = jc_class_to_check.getMethod(method_name, descriptor);
                            if (jc_method_found == null) continue;
                            result = current_class_name;
                        } else {
                            EfClass ef_class_to_check = this.ex_manager.getClass(current_class_name);
                            int method_token = ef_class_to_check.getMethod(method_name, descriptor).getMethodToken();
                            this.token_table.addMethodEntry(current_class_name, ef_class_to_check.getClassToken(), method_name, descriptor, method_token);
                            result = current_class_name;
                        }
                        break;
                    }
                }
            }
        } else {
            EfClass ef_class = this.ex_manager.getClass(class_name);
            if (ef_class == null) {
                Object[] args = new String[]{jc_class.getClassName().replace('/', '.'), class_name.replace('/', '.'), Names.getExportFileName(Names.getPackageName(class_name))};
                Notifier.error(line_number, "linking.6", args);
                Object[] args1 = new String[]{jc_class.getClassName().replace('/', '.'), Names.getMethodNameInJavaStyle(method_name, descriptor), class_name.replace('/', '.'), Names.getExportFileName(Names.getPackageName(class_name))};
                Notifier.error(line_number, "linking.8", args1);
            } else {
                EfMethod ef_method = this.ex_manager.getMethod(class_name, method_name, descriptor);
                if (ef_method == null) {
                    Object[] args = new String[]{jc_class.getClassName().replace('/', '.'), Names.getMethodNameInJavaStyle(method_name, descriptor), class_name.replace('/', '.'), Names.getExportFileName(Names.getPackageName(class_name))};
                    int access_flags = ef_class.getAccessFlags();
                    if (Modifier.isInterface(access_flags)) {
                        Notifier.error(line_number, "linking.16", args);
                    } else {
                        Notifier.error(line_number, "linking.8", args);
                    }
                } else {
                    this.token_table.addMethodEntry(class_name, ef_class.getClassToken(), method_name, descriptor, ef_method.getMethodToken());
                }
            }
        }
        return result;
    }

    private boolean checkMethodTable(JcClass jc_method_class, String method_name, String descriptor) {
        MethodDefinition[] pub_methods = jc_method_class.getPublicMethodTable().getMethods();
        int i = 0;
        while (i < pub_methods.length) {
            if (pub_methods[i].getMethodName().equals(method_name) && pub_methods[i].getMethodDescriptor().equals(descriptor)) {
                return true;
            }
            ++i;
        }
        MethodDefinition[] pac_methods = jc_method_class.getPackageMethodTable().getMethods();
        int i2 = 0;
        while (i2 < pac_methods.length) {
            if (pac_methods[i2].getMethodName().equals(method_name) && pac_methods[i2].getMethodDescriptor().equals(descriptor)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    private void checkMethodDescriptor(JcClass jc_class, String class_name, String method_name, String descriptor, int line_number) throws Exception {
        String[] param_descs = MethodDescriptor.getParamDescriptors(descriptor);
        int i = 0;
        while (i < param_descs.length) {
            String referenced_class = Names.getClassNameFromDescriptor(param_descs[i]);
            if (referenced_class != null) {
                if (Names.getPackageName(referenced_class).equals(this.this_package_name)) {
                    if (this.jc_package.getClass(referenced_class) == null) {
                        Object[] args = new String[]{jc_class.getClassName().replace('/', '.'), referenced_class.replace('/', '.'), class_name.replace('/', '.') + "." + Names.getMethodNameInJavaStyle(method_name, descriptor)};
                        Notifier.error(line_number, "linking.10", args);
                    }
                } else {
                    EfClass ef_referenced_class = this.ex_manager.getClass(referenced_class);
                    if (ef_referenced_class == null) {
                        Object[] args_1 = new String[]{jc_class.getClassName().replace('/', '.'), referenced_class.replace('/', '.'), Names.getExportFileName(Names.getPackageName(referenced_class))};
                        Notifier.error(line_number, "linking.6", args_1);
                        Object[] args_2 = new String[]{jc_class.getClassName().replace('/', '.'), referenced_class.replace('/', '.'), class_name.replace('/', '.') + "." + Names.getMethodNameInJavaStyle(method_name, descriptor)};
                        Notifier.error(line_number, "linking.10", args_2);
                    } else {
                        this.token_table.addClassEntry(referenced_class, ef_referenced_class.getClassToken());
                    }
                }
            }
            ++i;
        }
        String return_desc = MethodDescriptor.getReturnDescriptor(descriptor);
        String referenced_class = Names.getClassNameFromDescriptor(return_desc);
        if (referenced_class != null) {
            if (Names.getPackageName(referenced_class).equals(this.this_package_name)) {
                if (this.jc_package.getClass(referenced_class) == null) {
                    Object[] args = new Object[]{jc_class.getClassName().replace('/', '.'), referenced_class.replace('/', '.'), class_name.replace('/', '.') + "." + Names.getMethodNameInJavaStyle(method_name, descriptor)};
                    Notifier.error(line_number, "linking.11", args);
                }
            } else {
                EfClass ef_referenced_class = this.ex_manager.getClass(referenced_class);
                if (ef_referenced_class == null) {
                    Object[] args_1 = new String[]{jc_class.getClassName().replace('/', '.'), referenced_class.replace('/', '.'), Names.getExportFileName(Names.getPackageName(referenced_class))};
                    Notifier.error(line_number, "linking.6", args_1);
                    Object[] args_2 = new Object[]{jc_class.getClassName().replace('/', '.'), referenced_class.replace('/', '.'), class_name.replace('/', '.') + "." + Names.getMethodNameInJavaStyle(method_name, descriptor)};
                    Notifier.error(line_number, "linking.11", args_2);
                } else {
                    this.token_table.addClassEntry(referenced_class, ef_referenced_class.getClassToken());
                }
            }
        }
    }

    private void checkBytecode(JcClass jc_class, JcMethod jc_method) throws Exception {
        JcInstruction code = jc_method.getCode();
        while (code != null) {
            String descriptor;
            String class_name;
            JcConstantClassRef class_ref;
            int line_number = code.getSourceLineNumber();
            if (code instanceof JcInstrClassRef && (class_ref = ((JcInstrClassRef)code).getClassRef()) != null) {
                class_name = class_ref.getClassName();
                if (Names.getPackageName(class_name).equals(this.this_package_name)) {
                    if (this.jc_package.getClass(class_name) == null) {
                        Object[] args = new String[]{jc_class.getClassName().replace('/', '.'), class_name.replace('/', '.')};
                        if (code instanceof JcInstrInterfaceRef) {
                            Notifier.error(line_number, "linking.21", args);
                        } else {
                            Notifier.error(line_number, "linking.7", args);
                        }
                    }
                } else {
                    EfClass ef_class = this.ex_manager.getClass(class_name);
                    if (ef_class == null) {
                        Object[] args = new String[]{jc_class.getClassName().replace('/', '.'), class_name.replace('/', '.'), Names.getExportFileName(Names.getPackageName(class_name))};
                        if (code instanceof JcInstrInterfaceRef) {
                            Notifier.error(line_number, "linking.20", args);
                        } else {
                            Notifier.error(line_number, "linking.6", args);
                        }
                    } else {
                        this.token_table.addClassEntry(class_name, ef_class.getClassToken());
                    }
                }
            }
            if (code instanceof JcInstrFieldRef) {
                String field_name;
                JcConstantFieldRef field_ref = ((JcInstrFieldRef)code).getFieldRef();
                class_name = field_ref.getClassName();
                String newClassName = this.checkField(jc_class, class_name, field_name = field_ref.getFieldName(), descriptor = field_ref.getDescriptor(), line_number);
                if (newClassName != null) {
                    class_name = newClassName;
                    field_ref.setClassName(class_name);
                }
                this.checkFieldDescriptor(jc_class, class_name, field_name, descriptor, line_number);
            }
            if (code instanceof JcInstrMethodRef) {
                JcConstantMethodRef method_ref = ((JcInstrMethodRef)code).getMethodRef();
                class_name = method_ref.getClassName();
                String method_name = method_ref.getMethodName();
                descriptor = method_ref.getDescriptor();
                if (!(method_ref instanceof JcConstantSuperMethodRef)) {
                    String new_class_name = this.checkMethod(jc_class, class_name, method_name, descriptor, line_number);
                    if (new_class_name != null) {
                        class_name = new_class_name;
                        method_ref.setClassName(new_class_name);
                    }
                    this.checkMethodDescriptor(jc_class, class_name, method_name, descriptor, line_number);
                }
            }
            code = code.getNextInstr();
        }
    }

    private void checkExceptionTable(JcClass jc_class, JcMethod jc_method) throws Exception {
        JcException[] exceptions = jc_method.getExceptions();
        int i = 0;
        while (i < exceptions.length) {
            String catch_type = exceptions[i].getCatchTypeClassRef().getClassName();
            if (!catch_type.equals("finally")) {
                if (Names.getPackageName(catch_type).equals(this.this_package_name)) {
                    if (this.jc_package.getClass(catch_type) == null) {
                        Object[] args = new Object[]{jc_class.getClassName().replace('/', '.'), catch_type.replace('/', ',')};
                        Notifier.error(-1, "linking.15", args);
                    }
                } else {
                    EfClass ef_catch_type = this.ex_manager.getClass(catch_type);
                    if (ef_catch_type == null) {
                        Object[] args_1 = new String[]{jc_class.getClassName().replace('/', '.'), catch_type.replace('/', ','), Names.getExportFileName(Names.getPackageName(catch_type))};
                        Notifier.error("linking.6", args_1);
                        Object[] args_2 = new Object[]{jc_class.getClassName().replace('/', '.'), catch_type.replace('/', ',')};
                        Notifier.error(-1, "linking.15", args_2);
                    } else {
                        this.token_table.addClassEntry(catch_type, ef_catch_type.getClassToken());
                    }
                }
            }
            ++i;
        }
    }

    private PackageDefinition[] constructImportPackageInfos() throws Exception {
        JcImportTokenTableEntry[] entries = this.token_table.getEntries();
        Vector<EfExportFile> vector = new Vector<EfExportFile>(20);
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getType() == 0) {
                EfExportFile a_package = this.ex_manager.getExportFile(entries[i].getName());
                vector.addElement(a_package);
            }
            ++i;
        }
        Object[] import_packages = new PackageDefinition[vector.size()];
        vector.copyInto(import_packages);
        return import_packages;
    }

    private static void checkPackageAIDs(PackageDefinition[] import_packages) throws ConverterException {
        HashSet<String> hs = new HashSet<String>();
        int i = 0;
        while (i < import_packages.length) {
            byte[] pAID = import_packages[i].getAID();
            String s = Strings.toHexString(pAID, ":");
            if (hs.contains(s)) {
                Object[] args = new Object[]{s};
                Notifier.error("binary.57", args);
                throw new ConverterException();
            }
            hs.add(s);
            ++i;
        }
    }
}

