/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.nbtasks;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public abstract class JCServerTask
extends Task {
    boolean inNetBeans() {
        return System.getProperty("netbeans.home") != null;
    }

    protected void startServer() {
        if (this.inNetBeans()) {
            return;
        }
        File file = this.getFileProp("javacard.emulator");
        String[] stringArray = new String[]{file.getAbsolutePath(), "-ramsize", this.getRamSize(), "-e2psize", this.getE2pSize(), "-corsize", this.getCorSize(), "-e2pfile", this.getEepromFile().getAbsolutePath(), "-loggerlevel", this.getLoggerLevel().toLowerCase(), "-httpport", this.getHttpPort(), "-contactedport", this.getContactedPort(), "-contactedprotocol", this.getContactedProtocol(), "-contactlessport", this.getContactlessPort(), this.isSuspend() ? "" : "-nosuspend"};
    }

    protected void resumeServer() {
        if (this.inNetBeans()) {
            return;
        }
        File file = this.getFileProp("javacard.emulator");
        String[] stringArray = new String[]{file.getAbsolutePath(), "-resume"};
    }

    protected void stopServer() {
        if (this.inNetBeans()) {
            return;
        }
    }

    protected void restartServer() {
        if (this.inNetBeans()) {
            return;
        }
        this.stopServer();
        this.startServer();
    }

    private String getPlatformID() {
        return this.getProp("javacard.instance.id");
    }

    private String getDeviceID() {
        return this.getProp("javacard.device.name");
    }

    private String getJCDKHome() {
        return this.getProp("javacard.home");
    }

    private boolean isSuspend() {
        return !this.getBool("javacard.device.nosuspend");
    }

    private String getContactedPort() {
        return this.getProp("javacard.device.contactedPort");
    }

    private String getContactedProtocol() {
        return this.getProp("javacard.device.contactedProtocol");
    }

    private String getContactlessPort() {
        return this.getProp("javacard.device.contactlessPort");
    }

    private String getCorSize() {
        return this.getProp("javacard.device.corSize");
    }

    private String getE2pSize() {
        return this.getProp("javacard.device.e2pSize");
    }

    private File getEepromFile() {
        File file = this.getFileProp("javacard.device.eeprom.folder", true);
        String string = this.getProp("javacard.device.name");
        String string2 = this.getProp("javacard.device.eprom.file.extension", false);
        if (string2 == null) {
            string2 = "eprom";
        }
        File file2 = new File(file, string + '.' + string2);
        return file2;
    }

    private String getHttpPort() {
        return this.getProp("javacard.device.httpPort");
    }

    private String getLoggerLevel() {
        return this.getProp("javacard.device.loggerLevel");
    }

    private String getProxy2cjcrePort() {
        return this.getProp("javacard.device.proxy2cjcrePort");
    }

    private String getRamSize() {
        return this.getProp("javacard.device.ramSize");
    }

    protected boolean getBool(String string) {
        String string2 = this.getProp(string, false);
        return string2 == null ? false : Boolean.valueOf(string2);
    }

    protected String getProp(String string) throws BuildException {
        return this.getProp(string, true);
    }

    protected String getProp(String string, boolean bl) throws BuildException {
        String string2 = this.getProject().getProperty(string);
        if (bl && string2 == null) {
            throw new BuildException(string + " not set");
        }
        return string2;
    }

    protected File getFileProp(String string) throws BuildException {
        return this.getFileProp(string, true);
    }

    protected File getFileProp(String string, boolean bl) throws BuildException {
        String string2 = this.getProp(string, bl);
        if (string2 != null) {
            string2 = string2.replace('/', File.separatorChar);
            File file = new File(string2);
            File[] fileArray = File.listRoots();
            boolean bl2 = false;
            if (file != null) {
                for (File file2 : fileArray) {
                    String string3;
                    if (string2.startsWith(file2.getAbsolutePath())) {
                        bl2 = true;
                        break;
                    }
                    File file3 = new File(file2.getAbsolutePath().toUpperCase());
                    if (!file3.exists() || !(string3 = string2.toUpperCase()).startsWith(file3.getAbsolutePath())) continue;
                    bl2 = true;
                    break;
                }
            }
            if (bl2) {
                this.log("Resolved " + string + " as absolute file " + file);
                return file;
            }
            file = new File(this.getProject().getBaseDir(), string2);
            this.log("Resolved " + string + " as relative file " + file);
            return file;
        }
        throw new AssertionError();
    }
}

