/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.scriptgen;

import com.sun.javacard.scriptgen.Download;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class CAP {
    public static final int SUCCESS = 0;
    public static final int FAILURE = 1;
    public static final int MAX_COMPONENT = 256;
    protected static ResourceBundle msg;
    public static final int PKG_MINOR_NUM = 10;
    public static final int PKG_MAJOR_NUM = 11;
    public static final int PKG_AID_LEN = 12;
    private String pkgName;
    private ZipFile zipFile;
    private ZipEntry[] components = new ZipEntry[256];
    private boolean[] seenList = new boolean[256];
    private int numberOfCustomComponents;
    private PrintWriter scriptWriter = new PrintWriter(System.out, true);
    private PrintWriter logWriter = new PrintWriter(System.err, true);
    private String installerAID = "";
    private boolean capVerified;
    private byte f_flags;
    private boolean noBeginEnd;

    public CAP(String string, PrintWriter printWriter, ResourceBundle resourceBundle, String string2) throws Exception {
        this.logWriter = printWriter;
        this.capVerified = false;
        msg = resourceBundle;
        this.pkgName = string2;
        try {
            this.zipFile = new ZipFile(string);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{exception.toString()};
            this.logWriter.println(MessageFormat.format(resourceBundle.getString("CAP.constructor"), objectArray));
            throw new Exception();
        }
    }

    public int genScript(PrintWriter printWriter) {
        this.scriptWriter = printWriter;
        return this.genScript();
    }

    public int genScript(PrintWriter printWriter, boolean bl) {
        this.scriptWriter = printWriter;
        this.noBeginEnd = bl;
        return this.genScript();
    }

    public int genScript() {
        if (this.zipFile == null) {
            return 1;
        }
        if (!this.capVerified && this.verifyCAP() != 0) {
            return 1;
        }
        this.genBeginCAP("");
        for (int i = 1; i < Download.DOWNLOAD_ORDER.length; ++i) {
            if (i == Download.DOWNLOAD_ORDER[11]) continue;
            if (this.components[i] == null) {
                if (i == Download.DOWNLOAD_ORDER[3] && (this.f_flags & 4) != 4 || i == Download.DOWNLOAD_ORDER[10] && (this.f_flags & 2) != 2) continue;
                Object[] objectArray = new Object[]{new Integer(Download.ORDER_TO_TAG[i])};
                this.logWriter.println(MessageFormat.format(msg.getString("CAP.missingComp"), objectArray));
                return 1;
            }
            if (this.genComponent(this.zipFile, this.components[i], Download.ORDER_TO_TAG[i]) == 0) continue;
            return 1;
        }
        this.genEOF();
        return 0;
    }

    public int verifyCAP() {
        if (this.capVerified) {
            return 0;
        }
        Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (this.sortComponent(zipEntry, this.components, this.pkgName) == 0) continue;
            return 1;
        }
        if (this.verifyHeader(this.zipFile, this.components[Download.DOWNLOAD_ORDER[1]]) != 0) {
            return 1;
        }
        this.capVerified = true;
        return 0;
    }

    public int verifyHeader(ZipFile zipFile, ZipEntry zipEntry) {
        int n = 0;
        byte by = 0;
        Object[] objectArray = new Object[]{zipEntry.getName()};
        try {
            short s;
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            byte[] byArray = new byte[286];
            int n2 = inputStream.read(byArray);
            if (n2 <= 0) {
                this.logWriter.println(MessageFormat.format(msg.getString("CAP.read1"), objectArray));
                n = 1;
                inputStream.close();
                return n;
            }
            if (byArray[0] != 1) {
                this.logWriter.println(MessageFormat.format(msg.getString("CAP.tag1"), objectArray));
                n = 1;
            }
            if ((s = (short)(((short)byArray[1] << 8) + (short)byArray[2])) != n2 - 3) {
                this.logWriter.println(MessageFormat.format(msg.getString("CAP.size1"), objectArray));
                n = 1;
            }
            if (byArray[3] != -34 || byArray[4] != -54 || byArray[5] != -1 || byArray[6] != -19) {
                this.logWriter.println(MessageFormat.format(msg.getString("CAP.magic"), objectArray));
                n = 1;
            }
            if (byArray[7] > 2) {
                this.logWriter.println(MessageFormat.format(msg.getString("CAP.minor"), objectArray));
                n = 1;
            }
            if (byArray[8] > 2) {
                this.logWriter.println(MessageFormat.format(msg.getString("CAP.major"), objectArray));
                n = 1;
            }
            this.f_flags = byArray[9];
            if ((this.f_flags & 1) == 1) {
                // empty if block
            }
            if ((this.f_flags & 2) == 2 && !this.isComponentPresent(Download.DOWNLOAD_ORDER[10])) {
                this.logWriter.println(MessageFormat.format(msg.getString("CAP.expMissing"), objectArray));
                n = 1;
            }
            if ((this.f_flags & 4) == 4 && !this.isComponentPresent(Download.DOWNLOAD_ORDER[3])) {
                this.logWriter.println(MessageFormat.format(msg.getString("CAP.appMissing"), objectArray));
                n = 1;
            }
            if ((by = byArray[12]) > 16 || by < 5) {
                this.logWriter.println(MessageFormat.format(msg.getString("CAP.aidLength"), objectArray));
                n = 1;
            }
            inputStream.close();
        }
        catch (Exception exception) {
            Object[] objectArray2 = new Object[]{exception.toString()};
            this.logWriter.println(MessageFormat.format(msg.getString("CAP.verifyHeader"), objectArray2));
            n = 1;
        }
        return n;
    }

    int sortComponent(ZipEntry zipEntry, ZipEntry[] zipEntryArray, String string) {
        Object object;
        int n;
        String string2 = zipEntry.getName();
        int n2 = 0;
        boolean bl = false;
        if (string == null) {
            bl = true;
        }
        if ((n = string2.lastIndexOf(47)) >= 0 && n < string2.length()) {
            object = string2.substring(0, n);
            string2 = string2.substring(n + 1).toLowerCase();
            if (string != null && ((String)object).replace('/', '.').equals(string + ".javacard")) {
                bl = true;
            }
        }
        object = new Object[]{string2};
        n2 = bl && string2.equals("header.cap") ? Download.DOWNLOAD_ORDER[1] : (bl && string2.equals("directory.cap") ? Download.DOWNLOAD_ORDER[2] : (bl && string2.equals("applet.cap") ? Download.DOWNLOAD_ORDER[3] : (bl && string2.equals("import.cap") ? Download.DOWNLOAD_ORDER[4] : (bl && string2.equals("constantpool.cap") ? Download.DOWNLOAD_ORDER[5] : (bl && string2.equals("class.cap") ? Download.DOWNLOAD_ORDER[6] : (bl && string2.equals("method.cap") ? Download.DOWNLOAD_ORDER[7] : (bl && string2.equals("staticfield.cap") ? Download.DOWNLOAD_ORDER[8] : (bl && string2.equals("export.cap") ? Download.DOWNLOAD_ORDER[10] : (bl && string2.equals("reflocation.cap") ? Download.DOWNLOAD_ORDER[9] : (bl && string2.equals("descriptor.cap") ? Download.DOWNLOAD_ORDER[11] : ++this.numberOfCustomComponents + 11))))))))));
        if (this.seenList[n2]) {
            this.logWriter.println(MessageFormat.format(msg.getString("CAP.dup"), (Object[])object));
            return 1;
        }
        this.seenList[n2] = true;
        zipEntryArray[n2] = zipEntry;
        return 0;
    }

    public int genComponent(ZipFile zipFile, ZipEntry zipEntry, int n) {
        int n2 = 0;
        try {
            int n3;
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            byte[] byArray = new byte[32];
            this.scriptWriter.println();
            this.scriptWriter.println("// " + zipEntry.getName());
            this.genCOMP(n);
            while ((n3 = inputStream.read(byArray, 0, byArray.length)) != -1 && (n2 = this.genData(n, byArray, n3)) == 0) {
            }
            inputStream.close();
            this.genEOC(n);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{exception.toString()};
            this.logWriter.println(MessageFormat.format(msg.getString("CAP.genEx: "), objectArray));
            n2 = 1;
        }
        return n2;
    }

    protected int genData(int n, byte[] byArray, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(" ");
            stringBuffer.append(this.toHex(byArray[i]));
        }
        return this.genAPDU(-76, n, stringBuffer.toString(), n2);
    }

    protected int genAPDU(int n, int n2, String string, int n3) {
        String string2 = "";
        block0 : switch (n) {
            case -76: {
                switch (n2) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        string2 = this.toHex((byte)-128) + " " + this.toHex((byte)-76) + " " + this.toHex(Download.COMPONENT_TAGS[n2]) + " 0x00 " + this.toHex((byte)n3) + string + " 0x7F;";
                        break block0;
                    }
                }
                return 0;
            }
            case -70: {
                string2 = System.getProperty("line.separator", "\n");
            }
            case -80: {
                if (this.noBeginEnd) break;
            }
            case -78: 
            case -68: {
                string2 = string2 + this.toHex((byte)-128) + " " + this.toHex((byte)n) + (n2 >= 0 ? " " + this.toHex((byte)n2) : " 0x00") + " 0x00 " + (n3 > 0 ? " " + this.toHex((byte)n3) : "0x00") + (string == null || string.length() <= 0 ? "" : " " + string) + " 0x7F;";
                break;
            }
            default: {
                return 0;
            }
        }
        this.scriptWriter.println(string2);
        return 0;
    }

    public int genBeginCAP(String string) {
        return this.genAPDU(-80, 0, string, string.length());
    }

    public int genEOF() {
        return this.genAPDU(-70, 0, null, 0);
    }

    public int genCOMP(int n) {
        return this.genAPDU(-78, n, null, 0);
    }

    public int genEOC(int n) {
        return this.genAPDU(-68, n, null, 0);
    }

    private String toHex(byte by) {
        String string = "";
        String string2 = Integer.toHexString(by & 0xFF).toUpperCase();
        string = string2.length() == 1 ? "0x0" + string2 : "0x" + string2;
        return string;
    }

    public boolean isComponentPresent(byte by) {
        boolean bl = true;
        try {
            if (this.components[by] == null) {
                bl = false;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }
}

