/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.implBiometry;

import com.sun.javacard.impl.NativeMethods;
import javacard.framework.JCSystem;
import javacard.framework.Util;
import javacardx.biometry.BioException;
import javacardx.biometry.OwnerBioTemplate;

public class PasswordBioImpl
implements OwnerBioTemplate {
    private byte[] passwd;
    private byte[] tryLimit = new byte[1];
    private byte origTryLimit;
    public static final byte MIN_PASSWD_LEN = 5;
    public static final byte MAX_PASSWD_LEN = 50;
    private boolean[] validatedAndInitCalled;
    private byte dataLenEnrolled;
    private byte[] matchDataLen;
    private boolean initialized;

    public PasswordBioImpl(byte tryL) {
        this.tryLimit[0] = tryL;
        this.origTryLimit = tryL;
        this.initialized = false;
        this.validatedAndInitCalled = JCSystem.makeTransientBooleanArray((short)3, (byte)1);
        this.validatedAndInitCalled[0] = false;
        this.validatedAndInitCalled[1] = false;
        this.validatedAndInitCalled[2] = false;
        this.matchDataLen = JCSystem.makeTransientByteArray((short)1, (byte)1);
        this.passwd = new byte[50];
    }

    public void init(byte[] bArray, short offset, short length) throws BioException {
        if (length < 0 || length > 50) {
            BioException.throwIt((short)2);
        }
        NativeMethods.checkArrayArgs(bArray, offset, length);
        this.initialized = false;
        this.validatedAndInitCalled[0] = false;
        this.validatedAndInitCalled[1] = true;
        this.validatedAndInitCalled[2] = false;
        if (this.passwd != null && JCSystem.isObjectDeletionSupported()) {
            JCSystem.requestObjectDeletion();
        }
        Util.arrayCopy(bArray, offset, this.passwd, (short)0, length);
        this.dataLenEnrolled = (byte)length;
    }

    public void update(byte[] bArray, short offset, short length) throws BioException {
        if (!this.validatedAndInitCalled[1]) {
            BioException.throwIt((short)5);
        }
        if (this.dataLenEnrolled + (byte)length > 50) {
            BioException.throwIt((short)2);
        }
        Util.arrayCopy(bArray, offset, this.passwd, this.dataLenEnrolled, length);
        this.dataLenEnrolled = (byte)(this.dataLenEnrolled + length);
    }

    public void doFinal() throws BioException {
        if (!this.validatedAndInitCalled[1]) {
            BioException.throwIt((short)5);
        }
        if (this.dataLenEnrolled < 5) {
            BioException.throwIt((short)2);
        }
        this.validatedAndInitCalled[1] = false;
        this.initialized = true;
    }

    public byte getBioType() {
        return 31;
    }

    public short getVersion(byte[] dest, short offset) {
        NativeMethods.checkArrayArgs(dest, offset, (short)3);
        short s2 = offset;
        offset = (short)(offset + 1);
        dest[s2] = 1;
        short s3 = offset;
        offset = (short)(offset + 1);
        dest[s3] = 0;
        dest[offset] = 0;
        return 3;
    }

    public short getPublicTemplateData(short publicOffset, byte[] dest, short destOffset, short length) throws BioException {
        if (!this.initialized) {
            BioException.throwIt((short)4);
        }
        if (length < 4) {
            BioException.throwIt((short)1);
        }
        NativeMethods.checkArrayArgs(dest, destOffset, (short)4);
        this.getVersion(dest, destOffset);
        dest[(short)(destOffset + 3)] = (byte)this.passwd.length;
        return 4;
    }

    public byte getTriesRemaining() {
        return this.tryLimit[0];
    }

    public short initMatch(byte[] candidate, short offset, short length) throws BioException {
        if (!this.initialized) {
            BioException.throwIt((short)4);
        }
        if (this.tryLimit[0] == 0) {
            BioException.throwIt((short)5);
        }
        Util.arrayFillNonAtomic(this.tryLimit, (short)0, (short)1, (byte)(this.tryLimit[0] - 1));
        NativeMethods.checkArrayArgs(candidate, offset, length);
        this.validatedAndInitCalled[0] = false;
        if (length > this.dataLenEnrolled) {
            return 0;
        }
        this.matchDataLen[0] = (byte)length;
        if (Util.arrayCompare(this.passwd, (short)0, candidate, offset, length) != 0) {
            return 0;
        }
        if (length < this.dataLenEnrolled) {
            this.validatedAndInitCalled[2] = true;
            return -1;
        }
        this.validatedAndInitCalled[0] = true;
        Util.arrayFillNonAtomic(this.tryLimit, (short)0, (short)1, this.origTryLimit);
        return 16384;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isValidated() {
        return this.validatedAndInitCalled[0];
    }

    public short match(byte[] candidate, short offset, short length) throws BioException {
        if (!this.validatedAndInitCalled[2]) {
            BioException.throwIt((short)5);
        }
        if (this.matchDataLen[0] + length > this.dataLenEnrolled) {
            this.validatedAndInitCalled[2] = false;
            return 0;
        }
        if (Util.arrayCompare(this.passwd, this.matchDataLen[0], candidate, offset, length) != 0) {
            this.validatedAndInitCalled[2] = false;
            return 0;
        }
        if (this.matchDataLen[0] + length == this.dataLenEnrolled) {
            this.validatedAndInitCalled[0] = true;
            this.validatedAndInitCalled[2] = false;
            Util.arrayFillNonAtomic(this.tryLimit, (short)0, (short)1, this.origTryLimit);
            return 16384;
        }
        this.matchDataLen[0] = (byte)(this.matchDataLen[0] + length);
        return -1;
    }

    public void reset() {
        this.validatedAndInitCalled[0] = false;
    }

    public void resetUnblockAndSetTryLimit(byte newTryLimit) throws BioException {
        if (newTryLimit < 1) {
            BioException.throwIt((short)1);
        }
        this.validatedAndInitCalled[0] = false;
        this.tryLimit[0] = newTryLimit;
        this.origTryLimit = newTryLimit;
    }
}

