/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apdutool;

import com.sun.javacard.apdutool.Msg;
import com.sun.javacard.apdutool.ReaderWriter;
import com.sun.javacard.apdutool.ReaderWriterError;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;
import javax.comm.CommPort;
import javax.comm.CommPortIdentifier;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;

public class Main {
    public static boolean noBanner = false;
    public static boolean printATR = true;
    private static Vector inputList = new Vector();
    private static String logSpec = "-";
    private static PrintWriter logWriter;
    private static String hostName;
    private static int port;
    private static int timeout;
    private static String serialPort;

    static {
        hostName = "localhost";
        port = 9025;
        timeout = 0;
        serialPort = null;
    }

    private static void banner() {
        Object[] args = new Object[]{new Integer(0), new Integer(15)};
        Msg.info("main.3", args);
        Msg.info("main.7", null);
    }

    public static void main(String[] argv) {
        Object[] args;
        int i = 0;
        while (i < argv.length && argv[i].startsWith("-")) {
            if (argv[i].equals("-help")) {
                Main.usage(false);
                System.exit(0);
            } else if (argv[i].equals("-h")) {
                if (++i < argv.length) {
                    hostName = argv[i];
                } else {
                    Main.usage(true);
                }
            } else if (argv[i].startsWith("-h")) {
                hostName = argv[i].substring(2);
            } else if (argv[i].equals("-nobanner")) {
                noBanner = true;
            } else if (argv[i].equals("-noatr")) {
                printATR = false;
            } else if (argv[i].equals("-p")) {
                if (++i < argv.length) {
                    try {
                        port = Integer.parseInt(argv[i]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        Main.usage(true);
                    }
                } else {
                    Main.usage(true);
                }
            } else if (argv[i].startsWith("-p")) {
                try {
                    port = Integer.parseInt(argv[i].substring(2));
                }
                catch (NumberFormatException numberFormatException) {
                    Main.usage(true);
                }
            } else if (argv[i].equals("-o")) {
                if (++i < argv.length) {
                    logSpec = argv[i];
                } else {
                    Main.usage(true);
                }
            } else if (argv[i].startsWith("-o")) {
                logSpec = argv[i].substring(2);
            } else if (argv[i].equals("-s")) {
                if (++i < argv.length) {
                    serialPort = argv[i];
                } else {
                    Main.usage(true);
                }
            } else if (argv[i].startsWith("-s")) {
                serialPort = argv[i].substring(2);
            } else if (argv[i].equals("-version")) {
                Main.banner();
                System.exit(0);
            } else {
                if (argv[i].equals("--")) {
                    ++i;
                    break;
                }
                Object[] args2 = new Object[]{argv[i]};
                Msg.error("main.6", args2);
                Main.usage(true);
            }
            ++i;
        }
        if (!noBanner) {
            Main.banner();
        }
        try {
            while (i < argv.length) {
                String fName;
                if ((fName = argv[i++]).equals("-")) {
                    inputList.addElement(argv[i]);
                    continue;
                }
                if (fName.startsWith("@")) {
                    Main.readListFromFile(inputList, fName.substring(1));
                    continue;
                }
                inputList.addElement(new File(fName).getCanonicalPath());
            }
            if (inputList.isEmpty()) {
                inputList.addElement("-");
            }
            logWriter = logSpec.equals("-") ? new PrintWriter(System.out, true) : new PrintWriter(new FileWriter(new File(logSpec).getCanonicalPath()));
        }
        catch (IOException e) {
            System.err.println(e);
            System.exit(1);
        }
        Socket sock = null;
        SerialPort sPort = null;
        if (serialPort == null) {
            if (!noBanner) {
                args = new Object[]{hostName, String.valueOf(port)};
                Msg.info("main.0", args);
            }
            sock = Main.openSocket(hostName, port);
            if (!noBanner) {
                Msg.info("main.2", null);
            }
        } else {
            if (!noBanner) {
                args = new Object[]{serialPort};
                Msg.info("main.1", args);
            }
            sPort = (SerialPort)Main.openCommPort(serialPort);
            if (!noBanner) {
                Msg.info("main.2", null);
            }
        }
        Enumeration enumeration = inputList.elements();
        while (enumeration.hasMoreElements()) {
            BufferedInputStream inputStream;
            String inSpec = (String)enumeration.nextElement();
            try {
                inputStream = inSpec.equals("-") ? new BufferedInputStream(System.in) : new BufferedInputStream(new FileInputStream(inSpec));
            }
            catch (IOException e) {
                System.err.println(e);
                continue;
            }
            try {
                ReaderWriter rw = sPort == null ? new ReaderWriter((InputStream)inputStream, sock, logWriter) : new ReaderWriter((InputStream)inputStream, sPort, logWriter);
                rw.setPrintATR(printATR);
                rw.run();
            }
            catch (ReaderWriterError e) {
                System.err.println(e);
            }
            catch (IOException e) {
                System.err.println(e);
                continue;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        logWriter.flush();
        if (!logSpec.equals("-")) {
            logWriter.close();
        }
        System.exit(0);
    }

    private static CommPort openCommPort(String port) {
        String canonicalPort;
        CommPort commPort = null;
        CommPortIdentifier portId = null;
        try {
            canonicalPort = new File(port).getCanonicalPath();
        }
        catch (IOException iOException) {
            canonicalPort = port;
        }
        try {
            portId = CommPortIdentifier.getPortIdentifier((String)canonicalPort);
        }
        catch (NoSuchPortException e) {
            System.err.println((Object)e);
            System.exit(1);
        }
        try {
            commPort = portId.open("apdutool", 30000);
        }
        catch (PortInUseException e) {
            System.err.println((Object)e);
            System.exit(1);
        }
        return commPort;
    }

    private static Socket openSocket(String hostname, int port) {
        Socket sock = null;
        try {
            sock = new Socket(hostName, port);
        }
        catch (UnknownHostException unknownHostException) {
            Object[] args = new Object[]{hostName};
            Msg.error("main.4", args);
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println(e);
            System.exit(1);
        }
        catch (IllegalArgumentException e) {
            Object[] args = new Object[]{e.getLocalizedMessage()};
            Msg.error("main.8", args);
            System.exit(1);
        }
        return sock;
    }

    static void readListFromFile(Vector list, String fName) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(fName));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                list.addElement(line);
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            System.err.println(e);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void usage(boolean isError) {
        if (isError) {
            Msg.error("main.5", null);
            System.exit(1);
        } else {
            Msg.info("main.5", null);
        }
    }
}

