/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.appletcontainer;

import com.sun.javacard.Logger;
import com.sun.javacard.appletcontainer.APDUDispatcher;
import com.sun.javacard.impl.AppletMgr;
import com.sun.javacard.impl.CommandLineOptions;
import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.impl.PrivAccess;
import javacard.framework.AID;
import javacardx.framework.ClassicSIOProxy;

public class AppletServer {
    private static AppletServer appletServer;
    private static int contactedPort;
    private static int contactlessPort;
    private static boolean AppletContainerIntialized;
    private APDUDispatcher contactedAPDUDispatcher;
    private APDUDispatcher contactlessAPDUDispatcher;

    public static AppletServer getAppletServer() {
        return appletServer;
    }

    public void reset() {
    }

    public void start() {
        Logger.info("    APDU Dispatcher(s) .... Starting");
        if (!AppletContainerIntialized) {
            AppletMgr.init();
            Object obj = ClassicSIOProxy.CLASSIC_APPLET_CONTAINER_MUTEX;
            AppletContainerIntialized = true;
        }
        this.contactedAPDUDispatcher = new APDUDispatcher(contactedPort, 0, CommandLineOptions.getContactedProtocol());
        this.contactlessAPDUDispatcher = new APDUDispatcher(contactlessPort, 1, -111);
        NativeMethods.setJCREentry(this.contactedAPDUDispatcher, false);
        NativeMethods.setJCREentry(this.contactlessAPDUDispatcher, false);
        this.contactedAPDUDispatcher.start();
        this.contactlessAPDUDispatcher.start();
    }

    public APDUDispatcher getContactedAPDUDispatcher() {
        return this.contactedAPDUDispatcher;
    }

    public boolean isAppletActive(AID theApplet) {
        byte[] contactedAppIDs = this.contactedAPDUDispatcher.getChannelManager().getActiveAppIDs();
        byte[] contactlessAppIDs = this.contactlessAPDUDispatcher.getChannelManager().getActiveAppIDs();
        for (byte id : contactedAppIDs) {
            if (!theApplet.equals(PrivAccess.getPrivAccess().getAID(id))) continue;
            return true;
        }
        for (byte id : contactlessAppIDs) {
            if (!theApplet.equals(PrivAccess.getPrivAccess().getAID(id))) continue;
            return true;
        }
        return false;
    }

    public byte getContextStatus(short context) {
        byte status = 0;
        status = this.contactedAPDUDispatcher.getChannelManager().getContextStatus(context, status);
        return this.contactlessAPDUDispatcher.getChannelManager().getContextStatus(context, status);
    }

    public boolean isContextActiveOnAnotherChannel(short context, byte interfaceId) {
        byte status = 0;
        byte firewallId = (byte)(context >> 8 & 0xFF);
        if (interfaceId == 0) {
            if (this.contactedAPDUDispatcher.getChannelManager().isAppContextActiveOnAnotherChannel(firewallId)) {
                return true;
            }
            return this.contactlessAPDUDispatcher.getChannelManager().getContextStatus(context, status) > 0;
        }
        if (this.contactlessAPDUDispatcher.getChannelManager().isAppContextActiveOnAnotherChannel(firewallId)) {
            return true;
        }
        return this.contactedAPDUDispatcher.getChannelManager().getContextStatus(context, status) > 0;
    }

    static {
        contactedPort = 9025;
        contactlessPort = 9026;
        AppletContainerIntialized = false;
        appletServer = new AppletServer();
        NativeMethods.setJCREentry(appletServer, false);
        int port = CommandLineOptions.getContactedPort();
        if (port != -1) {
            contactedPort = port;
        }
        if ((port = CommandLineOptions.getContactlessPort()) != -1) {
            contactlessPort = port;
        }
    }
}

