/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import com.sun.javacard.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.io.Buffer;
import org.mortbay.io.WriterOutputStream;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.HttpContent;
import org.mortbay.jetty.InclusiveByteRange;
import org.mortbay.jetty.MimeTypes;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.resource.Resource;
import org.mortbay.resource.ResourceFactory;
import org.mortbay.util.IO;
import org.mortbay.util.LazyList;
import org.mortbay.util.MultiPartOutputStream;
import org.mortbay.util.URIUtil;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class DefaultServlet
implements ResourceFactory {
    private ServletConfig config;
    private ContextHandler.Context context;
    private boolean acceptRanges = true;
    private boolean dirAllowed = false;
    private boolean redirectWelcome = true;
    private boolean gzip = true;
    private Resource resourceBase;
    MimeTypes mimeTypes;
    private LazyList<String> welcomes;
    private boolean aliases = false;
    private boolean useFileMappedBuffer = true;

    public void init(ServletConfig config) {
        this.config = config;
        this.context = (ContextHandler.Context)config.getServletContext();
        this.mimeTypes = this.context.getContextHandler().getMimeTypes();
        this.welcomes = this.context.getContextHandler().getWelcomeFiles();
        if (this.welcomes == null) {
            this.welcomes = LazyList.array2List(new String[]{"index.jsp", "index.html"});
        }
        this.acceptRanges = this.getInitBoolean("acceptRanges", this.acceptRanges);
        this.dirAllowed = this.getInitBoolean("dirAllowed", this.dirAllowed);
        this.redirectWelcome = this.getInitBoolean("redirectWelcome", this.redirectWelcome);
        this.gzip = this.getInitBoolean("gzip", this.gzip);
        this.aliases = this.getInitBoolean("aliases", this.aliases);
        this.useFileMappedBuffer = this.getInitBoolean("useFileMappedBuffer", this.useFileMappedBuffer);
        try {
            Logger.debug("\nIn org.mortbay.jetty.servlet.DefaultServlet.init() -> " + this.context.getResource("/"));
            this.resourceBase = Resource.newResource(this.context.getResource("/"));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private boolean getInitBoolean(String name, boolean dft) {
        String value = this.config.getInitParameter(name);
        if (value == null || value.length() == 0) {
            return dft;
        }
        return value.startsWith("t") || value.startsWith("T") || value.startsWith("y") || value.startsWith("Y") || value.startsWith("1");
    }

    @Override
    public Resource getResource(String pathInContext) {
        if (this.resourceBase == null) {
            Logger.debug("DefaultServlet.getResource -> Returning NULL " + pathInContext);
            return null;
        }
        Resource r = null;
        try {
            r = this.resourceBase.addPath(pathInContext);
            if (!this.aliases && r.getAlias() != null) {
                if (r.exists()) {
                    Logger.debug("Aliased resource: " + r + "==" + r.getAlias());
                }
                return r;
            }
        }
        catch (IOException e) {
            Logger.debug(e);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String accept;
        Logger.debug("DefaultServlet.doGet -> " + request.getRequestURI());
        Logger.debug("                        " + request.getServletPath());
        String servletPath = null;
        String pathInfo = null;
        Enumeration reqRanges = null;
        Boolean included = (Boolean)request.getAttribute("org.mortbay.jetty.included");
        if (included != null && included.booleanValue()) {
            servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
            pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
            if (servletPath == null) {
                servletPath = request.getServletPath();
                pathInfo = request.getPathInfo();
            }
        } else {
            included = Boolean.FALSE;
            servletPath = request.getServletPath();
            pathInfo = request.getPathInfo();
            reqRanges = request.getHeaders("Range");
            if (reqRanges != null && !reqRanges.hasMoreElements()) {
                reqRanges = null;
            }
        }
        String pathInContext = URIUtil.addPaths(servletPath, pathInfo);
        boolean endsWithSlash = pathInContext.endsWith("/");
        boolean gzip = false;
        if (this.gzip && reqRanges == null && !endsWithSlash && (accept = request.getHeader("Accept-Encoding")) != null && accept.indexOf("gzip") >= 0) {
            gzip = true;
        }
        Resource resource = null;
        HttpContent content = null;
        try {
            gzip = false;
            resource = this.getResource(pathInContext);
            Logger.debug("DefaultServlet.doGet -> 111111 #  " + resource);
            if (resource == null || !resource.exists()) {
                response.sendError(404);
            } else if (!resource.isDirectory()) {
                if (gzip) {
                    response.setHeader("Content-Encoding", "gzip");
                    response.setHeader("Content-Type", this.context.getMimeType(pathInContext));
                }
                content = new UnCachedContent(resource);
                if (included.booleanValue() || this.passConditionalHeaders(request, response, resource, content)) {
                    this.sendData(request, response, included, resource, content, reqRanges);
                }
            } else {
                String welcome = null;
                if (!endsWithSlash && !pathInContext.equals("/")) {
                    StringBuffer buf = request.getRequestURL();
                    buf.append('/');
                    String q = request.getQueryString();
                    if (q != null && q.length() != 0) {
                        buf.append('?');
                        buf.append(q);
                    }
                    response.setContentLength(0);
                    response.sendRedirect(response.encodeRedirectURL(buf.toString()));
                } else {
                    welcome = this.getWelcomeFile(resource);
                    if (null != welcome) {
                        String ipath = URIUtil.addPaths(pathInContext, welcome);
                        if (this.redirectWelcome) {
                            response.setContentLength(0);
                            String q = request.getQueryString();
                            if (q != null && q.length() != 0) {
                                response.sendRedirect(URIUtil.addPaths(this.context.getContextPath(), ipath) + "?" + q);
                            } else {
                                response.sendRedirect(URIUtil.addPaths(this.context.getContextPath(), ipath));
                            }
                        } else {
                            RequestDispatcher dispatcher = request.getRequestDispatcher(ipath);
                            if (dispatcher != null) {
                                if (included.booleanValue()) {
                                    dispatcher.include(request, response);
                                } else {
                                    dispatcher.forward(request, response);
                                }
                            }
                        }
                    } else {
                        content = new UnCachedContent(resource);
                        if (included.booleanValue() || this.passConditionalHeaders(request, response, resource, content)) {
                            this.sendDirectory(request, response, resource, pathInContext.length() > 1);
                        }
                    }
                }
            }
        }
        catch (IllegalArgumentException e) {
            Logger.debug(e);
        }
        finally {
            response.flushBuffer();
            if (content != null) {
                content.release();
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private String getWelcomeFile(Resource resource) throws IOException {
        if (!resource.isDirectory() || this.welcomes == null) {
            return null;
        }
        for (String element : this.welcomes) {
            Resource welcome = resource.addPath(element);
            if (!welcome.exists()) continue;
            return element;
        }
        return null;
    }

    protected boolean passConditionalHeaders(HttpServletRequest request, HttpServletResponse response, Resource resource, HttpContent content) throws IOException {
        if (!request.getMethod().equals("HEAD")) {
            if (content != null) {
                String ifms = request.getHeader("If-Modified-Since");
                Buffer mdlm = content.getLastModified();
                if (ifms != null && mdlm != null && ifms.equals(mdlm.toString())) {
                    response.reset();
                    response.setStatus(304);
                    response.flushBuffer();
                    return false;
                }
            }
            long date = 0L;
            date = request.getDateHeader("If-Unmodified-Since");
            if (date > 0L && resource.lastModified() / 1000L > date / 1000L) {
                response.sendError(412);
                return false;
            }
            date = request.getDateHeader("If-Modified-Since");
            if (date > 0L && resource.lastModified() / 1000L <= date / 1000L) {
                response.reset();
                response.setStatus(304);
                response.flushBuffer();
                return false;
            }
        }
        return true;
    }

    protected void sendDirectory(HttpServletRequest request, HttpServletResponse response, Resource resource, boolean parent) throws IOException {
        if (!this.dirAllowed) {
            response.sendError(404);
            return;
        }
        byte[] data = null;
        String base = URIUtil.addPaths(request.getRequestURI(), "/");
        String dir = resource.getListHTML(base, parent);
        if (dir == null) {
            response.sendError(403, "No directory");
            return;
        }
        data = dir.getBytes("UTF-8");
        response.setContentType("text/html; charset=UTF-8");
        response.setContentLength(data.length);
        response.getOutputStream().write(data);
    }

    protected void sendData(HttpServletRequest request, HttpServletResponse response, boolean include, Resource resource, HttpContent content, Enumeration<String> reqRanges) throws IOException {
        long content_length = resource.length();
        OutputStream out = null;
        try {
            out = response.getOutputStream();
        }
        catch (IllegalStateException e) {
            out = new WriterOutputStream(response.getWriter());
        }
        if (reqRanges == null || !reqRanges.hasMoreElements()) {
            if (include) {
                resource.writeTo(out, 0L, content_length);
            } else if (out instanceof HttpConnection.Output) {
                ((HttpConnection.Output)out).sendContent(content);
            } else {
                this.writeHeaders(response, content, content_length);
                resource.writeTo(out, 0L, content_length);
            }
        } else {
            Vector<InclusiveByteRange> ranges = InclusiveByteRange.satisfiableRanges(reqRanges, content_length);
            if (ranges == null || ranges.size() == 0) {
                this.writeHeaders(response, content, content_length);
                response.setStatus(416);
                response.setHeader("Content-Range", InclusiveByteRange.to416HeaderRangeString(content_length));
                resource.writeTo(out, 0L, content_length);
                return;
            }
            if (ranges.size() == 1) {
                InclusiveByteRange singleSatisfiableRange = ranges.elementAt(0);
                long singleLength = singleSatisfiableRange.getSize(content_length);
                this.writeHeaders(response, content, singleLength);
                response.setStatus(206);
                response.setHeader("Content-Range", singleSatisfiableRange.toHeaderRangeString(content_length));
                resource.writeTo(out, singleSatisfiableRange.getFirst(content_length), singleLength);
                return;
            }
            this.writeHeaders(response, content, -1L);
            String mimetype = content.getContentType().toString();
            MultiPartOutputStream multi = new MultiPartOutputStream(out);
            response.setStatus(206);
            String ctp = request.getHeader("Request-Range") != null ? "multipart/x-byteranges; boundary=" : "multipart/byteranges; boundary=";
            response.setContentType(ctp + multi.getBoundary());
            InputStream in = resource.getInputStream();
            long pos = 0L;
            for (int i = 0; i < ranges.size(); ++i) {
                InclusiveByteRange ibr = ranges.elementAt(i);
                String header = "Content-Range: " + ibr.toHeaderRangeString(content_length);
                multi.startPart(mimetype, new String[]{header});
                long start = ibr.getFirst(content_length);
                long size = ibr.getSize(content_length);
                if (in != null) {
                    if (start < pos) {
                        in.close();
                        in = resource.getInputStream();
                        pos = 0L;
                    }
                    if (pos < start) {
                        in.skip(start - pos);
                        pos = start;
                    }
                    IO.copy(in, multi, size);
                    pos += size;
                    continue;
                }
                resource.writeTo(multi, start, size);
            }
            if (in != null) {
                in.close();
            }
            multi.close();
        }
    }

    protected void writeHeaders(HttpServletResponse response, HttpContent content, long count) {
        if (content.getContentType() != null) {
            response.setContentType(content.getContentType().toString());
        }
        if (content.getLastModified() != null) {
            response.setHeader("Last-Modified", content.getLastModified().toString());
        } else {
            response.setDateHeader("Last-Modified", content.getResource().lastModified());
        }
        if (count != -1L) {
            if (response instanceof Response) {
                ((Response)response).setLongContentLength(count);
            } else if (count < Integer.MAX_VALUE) {
                response.setContentLength((int)count);
            } else {
                response.setHeader("Content-Length", "" + count);
            }
        }
        if (this.acceptRanges) {
            response.setHeader("Accept-Ranges", "bytes");
        }
    }

    public void destroy() {
    }

    private class UnCachedContent
    implements HttpContent {
        Resource resource;

        UnCachedContent(Resource resource) {
            this.resource = resource;
        }

        @Override
        public Buffer getContentType() {
            return DefaultServlet.this.mimeTypes.getMimeByExtension(this.resource.toString());
        }

        @Override
        public Buffer getLastModified() {
            return null;
        }

        @Override
        public Buffer getBuffer() {
            return null;
        }

        @Override
        public long getContentLength() {
            return this.resource.length();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.resource.getInputStream();
        }

        @Override
        public Resource getResource() {
            return this.resource;
        }

        @Override
        public void release() {
            this.resource.release();
            this.resource = null;
        }
    }
}

