/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import com.sun.javacard.ContextManager;
import com.sun.javacard.Logger;
import com.sun.javacard.security.Principal;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javacardx.framework.TransientReference;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.security.SecurityHandler;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.jetty.servlet.Holder;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class ServletHolder
extends Holder {
    private int initOrder;
    private boolean initOnStartup = false;
    private Hashtable<String, String> roleMap;
    private String forcedPath;
    private String runAs;
    private UserRealm realm;
    private transient Stack<Servlet> servlets;
    private transient Servlet servlet;
    private transient Config config;
    private TransientReference<Long> unavailable = new TransientReference<Long>(0L);
    private transient UnavailableException unavailableEx;

    public ServletHolder() {
    }

    public ServletHolder(Servlet servlet) {
        this.setServlet(servlet);
    }

    public ServletHolder(Class<? extends Servlet> servlet) {
        super(servlet);
    }

    public synchronized void setServlet(Servlet servlet) {
        this.extInstance = true;
        this.servlet = servlet;
        this.setHeldClass(servlet.getClass());
        if (this.getName() == null) {
            this.setName(servlet.getClass().getName());
        }
    }

    public int getInitOrder() {
        return this.initOrder;
    }

    public void setInitOrder(int order) {
        this.initOnStartup = true;
        this.initOrder = order;
    }

    public int compareTo(Object o) {
        if (o instanceof ServletHolder) {
            int c;
            ServletHolder sh = (ServletHolder)o;
            if (sh == this) {
                return 0;
            }
            if (sh.initOrder < this.initOrder) {
                return 1;
            }
            if (sh.initOrder > this.initOrder) {
                return -1;
            }
            int n = c = this.className != null && sh.className != null ? this.className.compareTo(sh.className) : 0;
            if (c == 0) {
                c = this.name.compareTo(sh.name);
            }
            if (c == 0) {
                c = this.hashCode() > o.hashCode() ? 1 : -1;
            }
            return c;
        }
        return 1;
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public synchronized void setUserRoleLink(String name, String link) {
        if (this.roleMap == null) {
            this.roleMap = new Hashtable();
        }
        this.roleMap.put(name, link);
    }

    public String getUserRoleLink(String name) {
        if (this.roleMap == null) {
            return name;
        }
        String link = this.roleMap.get(name);
        return link == null ? name : link;
    }

    public void setRunAs(String role) {
        this.runAs = role;
    }

    public String getRunAs() {
        return this.runAs;
    }

    public String getForcedPath() {
        return this.forcedPath;
    }

    public void setForcedPath(String forcedPath) {
        this.forcedPath = forcedPath;
    }

    @Override
    public void doStart() throws Exception {
        this.unavailableEx = null;
        this.unavailable.set(0L);
        super.doStart();
        Class<Servlet> cls = Servlet.class;
        if (!cls.isAssignableFrom(this.clazz)) {
            IllegalStateException ex = new IllegalStateException("Servlet " + this.clazz + " is not a javax.servlet.Servlet");
            super.stop();
            throw ex;
        }
        this.config = new Config();
        if (this.runAs != null) {
            this.realm = ((SecurityHandler)ContextManager.getCurrentContext().getContextHandler().getChildHandlerByClass(SecurityHandler.class)).getUserRealm();
        }
        if (this.initOnStartup) {
            if (this.servlet == null) {
                this.servlet = (Servlet)this.newInstance();
            }
            try {
                this.initServlet(this.servlet, this.config);
            }
            catch (Throwable e) {
                this.servlet = null;
                this.config = null;
            }
            if (this.servlets != null && this.servlet != null) {
                this.servlets.push(this.servlet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStop() {
        Principal user = null;
        try {
            if (this.runAs != null && this.realm != null) {
                user = this.realm.pushRole(null, this.runAs);
            }
            if (!this.extInstance) {
                if (this.servlet != null) {
                    this.servlet.destroy();
                }
                this.servlet = null;
            }
            while (this.servlets != null && this.servlets.size() > 0) {
                Servlet s = this.servlets.pop();
                s.destroy();
            }
            this.config = null;
        }
        finally {
            super.doStop();
            if (this.runAs != null && this.realm != null && user != null) {
                this.realm.popRole(user);
            }
        }
    }

    private void handlePreviousUnavailability() throws ServletException {
        if (this.unavailableEx != null && this.unavailableEx.isPermanent()) {
            throw this.unavailableEx;
        }
        if (this.unavailable.get() != null && this.unavailable.get() != 0L) {
            long time = this.unavailable.get();
            if (time < 0L || time > 0L && System.currentTimeMillis() < time) {
                throw this.unavailableEx;
            }
            this.unavailable.set(0L);
            this.unavailableEx = null;
        }
    }

    public synchronized Servlet getServlet() throws ServletException {
        this.handlePreviousUnavailability();
        try {
            if (this.servlets != null) {
                Servlet servlet = null;
                if (this.servlets.size() == 0) {
                    servlet = (Servlet)this.newInstance();
                    if (this.config == null) {
                        this.config = new Config();
                    }
                    this.initServlet(servlet, this.config);
                } else {
                    servlet = this.servlets.pop();
                }
                return servlet;
            }
            if (this.servlet == null) {
                this.servlet = (Servlet)this.newInstance();
                if (this.config == null) {
                    this.config = new Config();
                }
                this.initServlet(this.servlet, this.config);
            }
            return this.servlet;
        }
        catch (UnavailableException e) {
            this.servlet = null;
            this.config = null;
            return this.makeUnavailable(e);
        }
        catch (ServletException e) {
            this.servlet = null;
            this.config = null;
            throw e;
        }
        catch (Throwable e) {
            this.servlet = null;
            this.config = null;
            throw new ServletException("init", e);
        }
    }

    private Servlet makeUnavailable(UnavailableException e) throws UnavailableException {
        this.unavailableEx = e;
        if (e.isPermanent()) {
            this.unavailable.set(-1L);
        } else if (this.unavailableEx.getUnavailableSeconds() > 0) {
            this.unavailable.set(System.currentTimeMillis() + (long)(1000 * this.unavailableEx.getUnavailableSeconds()));
        } else {
            this.unavailable.set(System.currentTimeMillis() + 5000L);
        }
        throw this.unavailableEx;
    }

    private void initServlet(Servlet servlet, ServletConfig config) throws ServletException {
        Principal user = null;
        try {
            if (this.runAs != null && this.realm != null) {
                user = this.realm.pushRole(null, this.runAs);
            }
            servlet.init(config);
        }
        catch (Exception e) {
            throw new ServletException(e);
        }
        finally {
            if (this.runAs != null && this.realm != null && user != null) {
                this.realm.popRole(user);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(ServletRequest request, ServletResponse response) throws ServletException, UnavailableException, IOException {
        ServletHolder servletHolder;
        Servlet servlet;
        if (this.clazz == null) {
            throw new UnavailableException("Servlet or filter class not set");
        }
        this.handlePreviousUnavailability();
        Servlet servlet2 = servlet = !this.initOnStartup || this.servlets != null ? this.getServlet() : this.servlet;
        if (servlet == null) {
            throw new UnavailableException("Could not instantiate " + this.clazz, 10);
        }
        boolean servlet_error = true;
        Principal user = null;
        Request base_request = null;
        try {
            if (this.forcedPath != null) {
                request.setAttribute("org.apache.catalina.jsp_file", this.forcedPath);
            }
            if (this.runAs != null && this.realm != null) {
                base_request = HttpConnection.getCurrentConnection().getRequest();
                user = this.realm.pushRole(base_request.getUserPrincipal(), this.runAs);
                base_request.setUserPrincipal(user);
            }
            servlet.service(request, response);
            servlet_error = false;
            if (this.runAs != null && this.realm != null && user != null && base_request != null) {
                user = this.realm.popRole(user);
                base_request.setUserPrincipal(user);
            }
            if (servlet_error) {
                request.setAttribute("javax.servlet.error.servlet_name", this.getName());
            }
            servletHolder = this;
        }
        catch (UnavailableException e) {
            ServletHolder servletHolder2;
            try {
                if (this.servlets != null) {
                    try {
                        this.stop();
                    }
                    catch (Exception e2) {
                        Logger.debug(e2);
                    }
                }
                this.makeUnavailable(e);
                if (this.runAs != null && this.realm != null && user != null && base_request != null) {
                    user = this.realm.popRole(user);
                    base_request.setUserPrincipal(user);
                }
                if (servlet_error) {
                    request.setAttribute("javax.servlet.error.servlet_name", this.getName());
                }
                servletHolder2 = this;
            }
            catch (Throwable throwable) {
                if (this.runAs != null && this.realm != null && user != null && base_request != null) {
                    user = this.realm.popRole(user);
                    base_request.setUserPrincipal(user);
                }
                if (servlet_error) {
                    request.setAttribute("javax.servlet.error.servlet_name", this.getName());
                }
                ServletHolder servletHolder3 = this;
                synchronized (servletHolder3) {
                    if (this.servlets != null) {
                        try {
                            this.servlets.push(servlet);
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                    }
                }
                throw throwable;
            }
            synchronized (servletHolder2) {
                if (this.servlets != null) {
                    try {
                        this.servlets.push(servlet);
                    }
                    catch (Exception e3) {
                        // empty catch block
                    }
                }
            }
        }
        synchronized (servletHolder) {
            if (this.servlets != null) {
                try {
                    this.servlets.push(servlet);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    class Config
    implements ServletConfig {
        Config() {
        }

        @Override
        public String getServletName() {
            return ServletHolder.this.getName();
        }

        @Override
        public ServletContext getServletContext() {
            return ServletHolder.this.servletHandler.getServletContext();
        }

        @Override
        public String getInitParameter(String param) {
            return ServletHolder.this.getInitParameter(param);
        }

        @Override
        public Enumeration<String> getInitParameterNames() {
            return ServletHolder.this.getInitParameterNames();
        }
    }
}

