/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apduio;

import java.util.Hashtable;

public class Apdu {
    public static final int COMMAND_ARRAY_SIZE = 6;
    public static final int CLA = 0;
    public static final int INS = 1;
    public static final int P1 = 2;
    public static final int P2 = 3;
    public static final int P3 = 4;
    public static final int CASE_1 = 1;
    public static final int CASE_2S = 2;
    public static final int CASE_3S = 3;
    public static final int CASE_4S = 4;
    public static final int CASE_2E = 5;
    public static final int CASE_3E = 6;
    public static final int CASE_4E = 7;
    public static final int LOGICAL_CHN_MASK = 3;
    public static final int APDU_TYPE_MASK = 240;
    static final int CMD_HDR_BYTES = 4;
    public byte[] command = new byte[6];
    public int Lc = 0;
    public byte[] dataIn = null;
    public int Le = 0;
    public byte[] dataOut = null;
    public byte[] sw1sw2 = new byte[2];
    public boolean isExtended;
    public boolean formatOP;
    public static final Hashtable<Object, String> STATUS_CODES = new Hashtable<Object, String>(){
        {
            this.put((short)-28672, "No Error");
            this.put((short)24832, "Response Bytes Remaining");
            this.put((short)26368, "Wrong length");
            this.put((short)27010, "Security Condition is not Satisfied");
            this.put((short)27011, "Invalid File");
            this.put((short)27012, "Invalid Data");
            this.put((short)27013, "Conditions are not Satisfied");
            this.put((short)27014, "Command is not Allowed");
            this.put((short)27033, "Applet Selection Failed");
            this.put((short)27264, "Wrong Data");
            this.put((short)27265, "Function is not Supported");
            this.put((short)27266, "File not Found");
            this.put((short)27267, "Record not Found");
            this.put((short)27270, "Incorrect Parameters (P1,P2)");
            this.put((short)27392, "Incorrect Parameters (P1,P2)");
            this.put((short)27648, "Correct Expected Length (Le)");
            this.put((short)27904, "INS value is not Supported");
            this.put((short)28160, "CLA value is not Supported");
            this.put((short)28416, "No Precise Diagnosis");
            this.put((short)27268, "Not enough Memory Space in the File");
            this.put((short)26753, "Card does not Support the operation on the specified Logical Channel");
            this.put((short)26754, "Card does not support Secure Messaging");
            this.put((short)25088, "Warning, Card State is Unchanged");
            this.put((short)26755, "Last Command in chain is Expected");
            this.put((short)26756, "Command Chaining is not Supported");
        }
    };

    public Apdu(byte[] b) {
        this();
        this.command[0] = b[0];
        this.command[1] = b[1];
        this.command[2] = b[2];
        this.command[3] = b[3];
        byte[] di = new byte[b.length - 5];
        System.arraycopy(b, 5, di, 0, di.length);
        this.setDataIn(di);
        this.setLe(127);
    }

    public Apdu() {
    }

    public byte[] getCommand() {
        byte[] commandBytes = new byte[4];
        System.arraycopy(this.command, 0, commandBytes, 0, 4);
        return commandBytes;
    }

    public byte[] getDataIn() {
        return this.dataIn;
    }

    public void setDataIn(byte[] dataIn) {
        this.dataIn = dataIn;
        if (dataIn == null) {
            this.Lc = 0;
        } else {
            if (dataIn.length > Short.MAX_VALUE) {
                throw new IllegalArgumentException();
            }
            this.Lc = dataIn.length;
            if (dataIn.length > 255) {
                this.isExtended = true;
            }
        }
    }

    public void setLc(int Lc) {
        if (Lc < 0 || Lc > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.Lc = Lc;
        this.dataIn = new byte[Lc];
    }

    public void setDataIn(byte[] dataIn, int length) {
        if (length < 0 || length > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.dataIn = dataIn;
        this.Lc = length;
    }

    public int getLc() {
        return this.Lc;
    }

    public void setDataOut(byte[] dataOut) {
        this.dataOut = dataOut;
        if (dataOut == null) {
            this.Le = 0;
        } else {
            if (dataOut.length > Short.MAX_VALUE) {
                throw new IllegalArgumentException();
            }
            this.Le = dataOut.length;
        }
    }

    public void setLe(int Le) {
        if (Le < 0 || Le > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.Le = Le;
        this.dataOut = new byte[Le];
    }

    public void setDataOut(byte[] dataOut, int length) {
        if (length < 0 || length > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.dataOut = dataOut;
        if (dataOut == null && length == 0) {
            this.Le = 0;
        } else {
            if (dataOut == null && length > 0) {
                throw new IllegalArgumentException();
            }
            if (dataOut != null && dataOut.length < length) {
                throw new IllegalArgumentException();
            }
        }
        this.Le = length;
    }

    public int getLe() {
        return this.Le;
    }

    public byte[] getDataOut() {
        return this.dataOut;
    }

    public byte[] getSw1Sw2() {
        return this.sw1sw2;
    }

    public int getStatus() {
        return ((this.sw1sw2[0] & 0xFF) << 8 | this.sw1sw2[1] & 0xFF) & 0xFFFF;
    }

    public int getCase() {
        if (this.Lc == 0 && this.Le == 0) {
            return 1;
        }
        if (this.Lc == 0 && this.Le >= 0 && this.Le <= 256) {
            return 2;
        }
        if (this.Lc == 0 && this.Le > 256) {
            return 5;
        }
        if (this.Lc > 0 && this.Lc <= 255 && this.Le == 0) {
            return 3;
        }
        if (this.Lc >= 256 && this.Le == 0) {
            return 6;
        }
        if (this.Lc > 0 && this.Lc <= 255 && this.Le > 0 && this.Le < 256) {
            return 4;
        }
        return 7;
    }

    public byte getChannelInfo() {
        return this.command[0];
    }

    public byte makeISOInterIndustryCLA(byte CLAByte) {
        boolean extChannel;
        boolean bl = extChannel = (CLAByte & 0x40) != 0;
        if (extChannel) {
            return (byte)(CLAByte & 0xF | 0x40);
        }
        return (byte)(CLAByte & 3);
    }

    public byte[] getCommandApduBytes() {
        byte[] apduBytes;
        switch (this.getCase()) {
            case 1: {
                apduBytes = new byte[4];
                System.arraycopy(this.command, 0, apduBytes, 0, 4);
                break;
            }
            case 2: {
                apduBytes = new byte[5];
                System.arraycopy(this.command, 0, apduBytes, 0, 4);
                apduBytes[4] = (byte)this.Le;
                break;
            }
            case 5: {
                apduBytes = new byte[7];
                System.arraycopy(this.command, 0, apduBytes, 0, 4);
                apduBytes[4] = 0;
                apduBytes[5] = (byte)(this.Le >> 8 & 0xFF);
                apduBytes[6] = (byte)(this.Le & 0xFF);
                break;
            }
            case 3: {
                apduBytes = new byte[5 + this.Lc];
                System.arraycopy(this.command, 0, apduBytes, 0, 4);
                apduBytes[4] = (byte)this.Lc;
                System.arraycopy(this.dataIn, 0, apduBytes, 5, this.Lc);
                break;
            }
            case 6: {
                apduBytes = new byte[7 + this.Lc];
                System.arraycopy(this.command, 0, apduBytes, 0, 4);
                apduBytes[4] = 0;
                apduBytes[5] = (byte)(this.Lc >> 8 & 0xFF);
                apduBytes[6] = (byte)(this.Lc & 0xFF);
                System.arraycopy(this.dataIn, 0, apduBytes, 7, this.Lc);
                break;
            }
            case 4: {
                apduBytes = new byte[5 + this.Lc + 1];
                System.arraycopy(this.command, 0, apduBytes, 0, 4);
                apduBytes[4] = (byte)this.Lc;
                System.arraycopy(this.dataIn, 0, apduBytes, 5, this.Lc);
                apduBytes[5 + this.Lc] = (byte)this.Le;
                break;
            }
            default: {
                apduBytes = new byte[7 + this.Lc + 2];
                System.arraycopy(this.command, 0, apduBytes, 0, 4);
                apduBytes[4] = 0;
                apduBytes[5] = (byte)(this.Lc >> 8 & 0xFF);
                apduBytes[6] = (byte)(this.Lc & 0xFF);
                System.arraycopy(this.dataIn, 0, apduBytes, 7, this.Lc);
                apduBytes[7 + this.Lc] = (byte)(this.Le >> 8 & 0xFF);
                apduBytes[8 + this.Lc] = (byte)(this.Le & 0xFF);
            }
        }
        return apduBytes;
    }

    public byte[] getResponseApduBytes() {
        byte[] newApdu = this.isExtended ? new byte[7 + this.Lc + 2 + this.Le + 2] : new byte[5 + this.Lc + 1 + this.Le + 2];
        System.arraycopy(this.command, 0, newApdu, 0, 4);
        if (this.isExtended) {
            newApdu[4] = 0;
            newApdu[5] = (byte)(this.Lc >> 8 & 0xFF);
            newApdu[6] = (byte)(this.Lc & 0xFF);
        } else {
            newApdu[4] = (byte)this.Lc;
        }
        if (this.isExtended) {
            if (this.Lc != 0) {
                System.arraycopy(this.dataIn, 0, newApdu, 7, this.Lc);
            }
        } else if (this.Lc != 0) {
            System.arraycopy(this.dataIn, 0, newApdu, 5, this.Lc);
        }
        if (this.isExtended) {
            newApdu[7 + this.Lc] = (byte)(this.Le >> 8 & 0xFF);
            newApdu[7 + this.Lc + 1] = (byte)(this.Le & 0xFF);
        } else {
            newApdu[5 + this.Lc] = (byte)this.Le;
        }
        if (this.isExtended) {
            if (this.dataOut.length != 0) {
                System.arraycopy(this.dataOut, 0, newApdu, 7 + this.Lc + 2, this.Le);
            }
        } else if (this.dataOut.length != 0) {
            System.arraycopy(this.dataOut, 0, newApdu, 5 + this.Lc + 1, this.Le);
        }
        System.arraycopy(this.sw1sw2, 0, newApdu, newApdu.length - 2, 2);
        return newApdu;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("CLA: " + Apdu.byteHexString(this.command[0]) + ", ");
        sb.append("INS: " + Apdu.byteHexString(this.command[1]) + ", ");
        sb.append("P1: " + Apdu.byteHexString(this.command[2]) + ", ");
        sb.append("P2: " + Apdu.byteHexString(this.command[3]) + ", ");
        if (this.isExtended) {
            sb.append("Lc: " + Apdu.byteHexString(0) + ", ");
            sb.append(Apdu.byteHexString((byte)(this.Lc >> 8)) + ", ");
            sb.append(Apdu.byteHexString((byte)(this.Lc & 0xFF)));
        } else {
            sb.append("Lc: " + Apdu.byteHexString(this.Lc));
        }
        for (i = 0; i < this.Lc; ++i) {
            sb.append(", " + Apdu.byteHexString(this.dataIn[i]));
        }
        if (this.formatOP) {
            sb.append("\n");
            short status = (short)((short)this.sw1sw2[0] & 0xFF);
            status = (short)((short)(status << 8) | (short)((short)this.sw1sw2[1] & 0xFF));
            String statusStr = STATUS_CODES.get(status);
            sb.append("Status : " + statusStr);
            sb.append(" (SW1: " + Apdu.byteHexString(this.sw1sw2[0]));
            sb.append(" SW2: " + Apdu.byteHexString(this.sw1sw2[1]) + ")");
            if (this.Le > 0 && this.dataOut != null) {
                sb.append(" ,Data: ");
                for (int i2 = 0; i2 < this.Le && i2 < this.dataOut.length; ++i2) {
                    sb.append(Apdu.byteHexString(this.dataOut[i2]) + " ");
                }
            }
        } else {
            if (this.isExtended) {
                sb.append("Le: " + Apdu.byteHexString(0) + ", ");
                sb.append(Apdu.byteHexString((byte)(this.Le >> 8)) + ", ");
                sb.append(Apdu.byteHexString((byte)(this.Le & 0xFF)));
            } else {
                sb.append(", Le: " + Apdu.byteHexString(this.Le));
            }
            if (this.dataOut != null) {
                for (i = 0; i < this.Le && i < this.dataOut.length; ++i) {
                    sb.append(", " + Apdu.byteHexString(this.dataOut[i]));
                }
            }
            sb.append(", SW1: " + Apdu.byteHexString(this.sw1sw2[0]));
            sb.append(", SW2: " + Apdu.byteHexString(this.sw1sw2[1]));
        }
        return sb.toString();
    }

    private static String byteHexString(int data) {
        StringBuffer sb = new StringBuffer();
        if ((data & 0xFF) < 16) {
            sb.append("0");
        }
        sb.append(Integer.toHexString(data & 0xFF));
        return sb.toString();
    }
}

