/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.rmiclientlib;

import com.sun.javacard.clientlib.CardAccessor;
import com.sun.javacard.javax.smartcard.rmiclient.CardObjectFactory;
import com.sun.javacard.rmiclientlib.JCCardObjectFactory;
import com.sun.javacard.rmiclientlib.JCCardProxyFactory;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class JCRMIConnect {
    static boolean debug = false;
    private static ResourceBundle _messages = PropertyResourceBundle.getBundle("com/sun/javacard/javax/smartcard/rmiclient/MessagesBundle");
    private CardAccessor ca;
    protected byte[] selectResponse;
    protected byte format;
    private static final byte FCI_TAG = 111;
    private static final byte APPLICATION_TAG = 110;
    private static final byte RMI_TAG = 94;
    private static final short RMI_VERSION = 514;
    public static final byte REF_WITH_CLASS_NAME = 0;
    public static final byte REF_WITH_INTERFACE_NAMES = 16;
    private static String[] dig = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    public JCRMIConnect(CardAccessor ca) {
        this.ca = ca;
    }

    public Remote getInitialReference() throws Exception {
        CardObjectFactory customObjectFactory = null;
        customObjectFactory = this.format == 0 ? new JCCardObjectFactory() : new JCCardProxyFactory();
        try {
            int SW = (this.selectResponse[0] & 0xFF) << 8 | this.selectResponse[1] & 0xFF;
            if (SW != 36864) {
                throw new RemoteException(_messages.getString("fail.3") + Integer.toHexString(0xFFFF & SW));
            }
            int fciOffset = 2;
            if (this.selectResponse[2] != 111) {
                throw new RemoteException(_messages.getString("unsupported.2"));
            }
            int appOffset = 4;
            if (this.selectResponse[4] != 110) {
                throw new RemoteException(_messages.getString("unsupported.3"));
            }
            int rmiOffset = 6;
            if (this.selectResponse[6] != 94) {
                throw new RemoteException(_messages.getString("unsupported.4"));
            }
            int versionOffset = 8;
            int version = this.selectResponse[8] << 8 | this.selectResponse[9] & 0xFF;
            if (version != 514) {
                throw new RemoteException(_messages.getString("unsupported.5"));
            }
            int invokeINSOffset = 10;
            byte invoke_ins = this.selectResponse[10];
            customObjectFactory.setINSByte(invoke_ins);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new RemoteException(_messages.getString("response.too_short"));
        }
        int tagOffset = 11;
        try {
            return (Remote)customObjectFactory.getObject(this.selectResponse, 11, Remote.class, this.ca);
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Throwable e) {
            throw new RemoteException(_messages.getString("fail.4"), e);
        }
    }

    public byte[] selectApplet(byte[] aid, byte format) throws Exception {
        this.format = format;
        byte[] apdu = new byte[aid.length + 6];
        byte[] SelectHeader = new byte[]{0, -92, 4, format};
        System.arraycopy(SelectHeader, 0, apdu, 0, SelectHeader.length);
        apdu[4] = (byte)aid.length;
        System.arraycopy(aid, 0, apdu, 5, aid.length);
        apdu[apdu.length - 1] = 127;
        if (debug) {
            JCRMIConnect.printArray(apdu);
        }
        this.selectResponse = this.ca.exchangeAPDU(apdu);
        if (debug) {
            JCRMIConnect.printArray(this.selectResponse);
        }
        return this.selectResponse;
    }

    private static void printArray(byte[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            if (i != 0 && i % 16 == 0) {
                System.out.println();
            }
            System.out.print(JCRMIConnect.getHexString(arr[i]) + " ");
        }
        System.out.println();
    }

    static String getHexString(byte b) {
        return dig[(b & 0xFF) >> 4] + dig[b & 0xF];
    }
}

