/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.validator;

import com.sun.javacard.validator.ErrorKey;
import com.sun.javacard.validator.Module;
import com.sun.javacard.validator.ModuleJCRD;
import com.sun.javacard.validator.ValidValues;
import java.io.File;

public class WebModuleJCRD
extends ModuleJCRD {
    private String webContextPath = null;
    private int webSecurePortNumber = -1;
    private boolean webClientAuthRequired = false;
    private boolean webSecureAccessOnly = false;

    public WebModuleJCRD(Module module, File file) {
        super(module, file);
    }

    public String getWebContextPath() {
        return this.webContextPath;
    }

    public void setWebContextPath(String webContextPath) {
        this.webContextPath = webContextPath;
    }

    public int getWebSecurePortNumber() {
        return this.webSecurePortNumber;
    }

    public void setWebSecurePortNumber(int webSecurePortNumber) {
        this.webSecurePortNumber = webSecurePortNumber;
    }

    public boolean isWebClientAuthRequired() {
        return this.webClientAuthRequired;
    }

    public void setWebClientAuthRequired(boolean webClientAuthRequired) {
        this.webClientAuthRequired = webClientAuthRequired;
    }

    public boolean isWebSecureAccessOnly() {
        return this.webSecureAccessOnly;
    }

    public void setWebSecureAccessOnly(boolean webSecureAccessOnly) {
        this.webSecureAccessOnly = webSecureAccessOnly;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.isOk()) {
            return;
        }
        if (!this.applicationType.equals("web")) {
            this.addError(ErrorKey.InvliadAttributeApplicationTypeInJCRD, this.applicationType, "web application", "web");
        }
        this.webContextPath = this.getAttributeValue("Web-Context-Path");
        if (this.webContextPath == null) {
            this.addError(ErrorKey.MissingAttribute, "Web-Context-Path");
        } else if (this.webContextPath.equals("/platform") || this.webContextPath.equals("/standard") || this.webContextPath.equals("/default") || this.webContextPath.equals("/cardmanager") || this.webContextPath.startsWith("/platform/") || this.webContextPath.startsWith("/standard/") || this.webContextPath.startsWith("/default/") || this.webContextPath.startsWith("/cardmanager/")) {
            this.addWarning(ErrorKey.CanNotUseReservedNameForWebContextPath, this.webContextPath);
        }
        String str = null;
        str = this.getAttributeValue("Web-Secure-Port-Number", false);
        if (str != null) {
            try {
                this.webSecurePortNumber = Integer.parseInt(str);
            }
            catch (Exception e) {
                this.addError(ErrorKey.InvalidAttributeValue, str, "Web-Secure-Port-Number");
            }
        }
        if ((str = this.getAttributeValue("Web-Secure-Access-Only")) != null) {
            if (ValidValues.isValidBoolean(str)) {
                this.webSecureAccessOnly = "true".equals(str);
            } else {
                this.addError(ErrorKey.InvalidAttributeValue, str, "Web-Secure-Access-Only");
            }
        }
        if ((str = this.getAttributeValue("Web-Client-Auth-Required")) != null) {
            if (ValidValues.isValidBoolean(str)) {
                this.webClientAuthRequired = "true".equals(str);
            } else {
                this.addError(ErrorKey.InvalidAttributeValue, str, "Web-Client-Auth-Required");
            }
        }
        if (this.getAttributeValue("Classic-Package-AID", true) != null) {
            this.addError(ErrorKey.MustNotPresent, "Classic-Package-AID", "Web");
        }
    }

    @Override
    public void processInternal() {
        super.processInternal();
        if (!this.isOk()) {
            return;
        }
    }
}

