/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.mask;

import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.PackageIdentifier;
import com.sun.javacard.jcasm.SymbolTable;
import java.util.Enumeration;
import java.util.Vector;

public class RomMask {
    protected Vector packageVector = new Vector();
    protected SymbolTable classSymbolTable = new SymbolTable();
    protected SymbolTable methodSymbolTable = new SymbolTable();
    protected SymbolTable fieldSymbolTable = new SymbolTable();

    public void addPackage(JCPackage p) {
        if (p == null) {
            return;
        }
        if (this.containsPackage(p.getIdentifier())) {
            Object[] args = new Object[]{p.getIdentifier().toString()};
            Msg.error("mask.1", args);
            return;
        }
        if (this.containsPackage(p.getName())) {
            Object[] args = new Object[]{p.getName()};
            Msg.error("mask.1", args);
            return;
        }
        this.packageVector.addElement(p);
        this.classSymbolTable.merge(p.symbolTable);
        Enumeration e = p.classElements();
        while (e.hasMoreElements()) {
            JCClass c = (JCClass)e.nextElement();
            this.methodSymbolTable.merge(c.methodSymbolTable);
            this.fieldSymbolTable.merge(c.fieldSymbolTable);
        }
    }

    public boolean containsPackage(PackageIdentifier id) {
        Enumeration e = this.packageVector.elements();
        while (e.hasMoreElements()) {
            JCPackage q = (JCPackage)e.nextElement();
            if (!q.getIdentifier().equals(id)) continue;
            return true;
        }
        return false;
    }

    public boolean containsPackage(String pkgName) {
        Enumeration e = this.packageVector.elements();
        while (e.hasMoreElements()) {
            JCPackage q = (JCPackage)e.nextElement();
            if (!q.getName().equals(pkgName)) continue;
            return true;
        }
        return false;
    }

    public Enumeration packageElements() {
        return this.packageVector.elements();
    }

    public SymbolTable getClassSymbolTable() {
        return this.classSymbolTable;
    }

    public SymbolTable getMethodSymbolTable() {
        return this.methodSymbolTable;
    }

    public int getSymbolCount() {
        return this.classSymbolTable.size() + this.fieldSymbolTable.size() + this.methodSymbolTable.size();
    }
}

