/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier.exportfile;

import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfConstantInfo;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;
import java.io.IOException;

class EfConstant_Utf8
extends EfConstantInfo {
    String contents;

    EfConstant_Utf8(ExportFile ef) {
        super(ef);
    }

    @Override
    void read() throws IOException {
        int numbytes = this.ef.in.readUnsignedShort();
        char[] data = new char[numbytes];
        int bytesRead = 0;
        int pos = 0;
        while (bytesRead < numbytes) {
            int b2;
            int b1 = this.ef.in.readUnsignedByte();
            if ((b1 & 0x80) == 0) {
                if (b1 == 0) {
                    throw new VerifierError("EfConstant_Utf8.1");
                }
                data[pos] = (char)b1;
                ++bytesRead;
            } else if ((b1 & 0xE0) == 192) {
                b2 = this.ef.in.readUnsignedByte();
                if ((b2 & 0xC0) != 128) {
                    throw new VerifierError("EfConstant_Utf8.2");
                }
                data[pos] = (char)((b1 & 0x1F) << 6 | b2 & 0x3F);
                bytesRead += 2;
            } else if ((b1 & 0xF0) == 224) {
                b2 = this.ef.in.readUnsignedByte();
                int b3 = this.ef.in.readUnsignedByte();
                if ((b2 & 0xC0) != 128 || (b3 & 0xC0) != 128) {
                    throw new VerifierError("EfConstant_Utf8.2");
                }
                data[pos] = (char)((b1 & 0xF) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F);
                bytesRead += 3;
            } else {
                throw new VerifierError("EfConstant_Utf8.2");
            }
            ++pos;
        }
        this.contents = new String(data, 0, pos);
    }

    @Override
    void validate() {
    }
}

