/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.nbtasks;

import com.sun.javacard.AID;
import com.sun.javacard.filemodels.DeploymentXmlAppletEntry;
import com.sun.javacard.filemodels.DeploymentXmlInstanceEntry;
import com.sun.javacard.filemodels.DeploymentXmlModel;
import com.sun.javacard.nbtasks.JCInstallerTask;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.tools.ant.BuildException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteTask
extends JCInstallerTask {
    private String instanceID;
    private File instancesFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws BuildException {
        if (this.isWebApplication()) {
            this.validateInstanceID();
        } else {
            this.validateInstancesFile();
        }
        if (this.isWebApplication()) {
            this.createArg().setValue("delete");
            if (this.instanceID != null) {
                this.createArg().setValue("--instance");
                this.createArg().setValue(this.instanceID);
            }
            super.execute();
        } else {
            try {
                DeploymentXmlModel deploymentXmlModel;
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.instancesFile));
                try {
                    deploymentXmlModel = new DeploymentXmlModel((InputStream)bufferedInputStream);
                }
                finally {
                    bufferedInputStream.close();
                }
                for (DeploymentXmlAppletEntry deploymentXmlAppletEntry : deploymentXmlModel.getData()) {
                    AID aID = deploymentXmlAppletEntry.getAppletAid();
                    this.deleteForOneApplet(aID, deploymentXmlAppletEntry.getData());
                }
            }
            catch (IOException iOException) {
                throw new BuildException((Throwable)iOException);
            }
        }
    }

    private void deleteForOneApplet(AID aID, List<? extends DeploymentXmlInstanceEntry> list) throws BuildException {
        for (DeploymentXmlInstanceEntry deploymentXmlInstanceEntry : list) {
            String string = deploymentXmlInstanceEntry.getDeploymentParams();
            AID aID2 = deploymentXmlInstanceEntry.getInstanceAID();
            this.deleteOneInstanceForOneApplet(aID, aID2, string);
        }
    }

    private void deleteOneInstanceForOneApplet(AID aID, AID aID2, String string) throws BuildException {
        String string2 = aID.toString();
        String string3 = aID2.toString();
        String string4 = string.trim();
        if (string4.length() <= 0) {
            string4 = null;
        }
        super.clearArgs();
        this.createArg().setValue("delete");
        if (string3 != null) {
            this.createArg().setValue("--instance");
            this.createArg().setValue(string3);
        }
        super.execute();
    }

    private void validateInstanceID() throws BuildException {
        if (this.instanceID == null) {
            this.instanceID = this.getProject().getProperty("webcontextpath");
        }
        if (this.instanceID == null) {
            throw new BuildException("InstanceID value not specified");
        }
        this.instanceID = this.instanceID.trim();
        if (this.instanceID.length() <= 0) {
            throw new BuildException("Empty value for InstanceID");
        }
    }

    private void validateInstancesFile() {
        if (this.instancesFile == null) {
            this.instancesFile = new File(this.getProject().getBaseDir(), "nbproject" + File.separatorChar + "deployment.xml");
        }
        if (!this.instancesFile.exists()) {
            throw new BuildException(this.instancesFile.getPath() + " does not exist");
        }
        if (!this.instancesFile.isFile()) {
            throw new BuildException(this.instancesFile.getPath() + " is not a regular file");
        }
    }

    public String getInstanceID() {
        return this.instanceID;
    }

    public void setInstanceID(String string) {
        this.instanceID = string;
    }
}

