/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.nbtasks;

import com.sun.javacard.nbtasks.JCToolTask;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

public class JCPackagerTask
extends JCToolTask {
    private boolean overwrite;

    public JCPackagerTask() {
        this(true);
    }

    public JCPackagerTask(boolean bl) {
        super(System.getProperty("packager.task") == null ? "com.sun.javacard.packager.Main" : System.getProperty("packager.task"));
        this.overwrite = bl;
    }

    public void execute() throws BuildException {
        Object object;
        boolean bl;
        this.createArg().setValue("create");
        assert (this.getProject() != null);
        assert (this.getProject().getBaseDir() != null);
        Project project = this.getProject();
        File file = project.getBaseDir();
        if (file == null) {
            throw new BuildException("Basedir not set");
        }
        File file2 = this.getFileProp("dist.bundle", true);
        this.createArg().setValue("--out");
        this.createArg().setFile(file2);
        if (this.overwrite) {
            file2.delete();
            this.createArg().setValue("--force");
        }
        if (this.isClassicLibrary()) {
            this.createArg().setValue("--packageaid");
            this.createArg().setValue(this.getProject().getProperty("package.aid"));
        }
        if (bl = this.getBool("sign.bundle")) {
            this.createArg().setValue("--sign");
            this.createArg().setValue("-K");
            this.createArg().setFile(new File(this.getProp("keystore.resolved")));
            this.createArg().setValue("-S");
            this.createArg().setValue(this.getProp("sign.storepass"));
            this.createArg().setValue("-P");
            this.createArg().setValue(this.getProp("sign.passkey"));
            this.createArg().setValue("-A");
            this.createArg().setValue(this.getProp("sign.alias"));
        }
        this.createArg().setValue("--type");
        this.createArg().setValue(this.getType());
        if ((this.isClassicLibrary() || this.isClassicApplication()) && ((String)(object = this.getExportPath())).length() > 0) {
            this.createArg().setValue("--exportpath");
            this.createArg().setValue((String)object);
        }
        this.setAdditionalArguments();
        object = this.getFileProp("build.dir");
        if (!((File)object).exists()) {
            throw new BuildException(((File)object).getAbsolutePath() + " does not exist");
        }
        if (!((File)object).isDirectory()) {
            throw new BuildException(((File)object).getAbsolutePath() + " is not a folder");
        }
        this.createArg().setFile((File)object);
        this.log("Execute\n" + this.getCommandLine(), 3);
        super.execute();
        if (!file2.exists()) {
            throw new BuildException("Creation of " + file2 + " was not successful. See Packager output");
        }
    }

    protected void setAdditionalArguments() throws BuildException {
    }
}

