/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apduio;

import com.sun.javacard.apduio.Apdu;
import com.sun.javacard.apduio.ClientProtocol;
import com.sun.javacard.jpcsclite.ConnectionType;
import com.sun.javacard.jpcsclite.PCSCLite;
import com.sun.javacard.jpcsclite.State;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class ClientPCSCProtocol
extends ClientProtocol {
    protected ConnectionType ctx;
    protected static ResourceBundle _messages = ResourceBundle.getBundle("com/sun/javacard/apduio/MessagesBundle");

    public void setAuto61xx(boolean state) {
    }

    public boolean getAuto61xx() {
        return true;
    }

    @Override
    public void exchangeApdu(Apdu apdu) throws IOException {
        byte[] cmd = apdu.getCommandApduBytes();
        byte[] res = this.ctx.getCard().Transmit(cmd, 0, cmd.length);
        if (res.length < 2) {
            throw new IOException(_messages.getString("pcsc.8"));
        }
        apdu.setDataOut(res, res.length - 2);
        apdu.sw1sw2 = new byte[2];
        System.arraycopy(res, res.length - 2, apdu.sw1sw2, 0, 2);
    }

    public byte[] openCard(int readerNumber) throws Exception {
        try {
            this.ctx = new ConnectionType();
            this.ctx.establishContext(PCSCLite.SCOPE_SYSTEM, null, null);
            String[] sa = this.ctx.getReaders();
            if (sa == null) {
                throw new RuntimeException(_messages.getString("pcsc.9"));
            }
            for (int i = 0; i < sa.length; ++i) {
                Object[] args = new Object[]{"" + i, sa[i]};
                System.out.println(MessageFormat.format(_messages.getString("pcsc.10"), args));
            }
            if (sa.length == 0) {
                throw new Exception(_messages.getString("pcsc.7"));
            }
            if (sa.length > 1) {
                Object[] args = new Object[]{sa[readerNumber]};
                System.out.println(MessageFormat.format(_messages.getString("pcsc.11"), args));
            }
            State[] rsa = new State[]{new State(sa[readerNumber])};
            this.ctx.statusChange(1000, rsa);
            if ((rsa[0].getEventState() & PCSCLite.STATE_PRESENT) != PCSCLite.STATE_PRESENT) {
                throw new Exception(_messages.getString("pcsc.6"));
            }
            if ((rsa[0].getEventState() & PCSCLite.STATE_MUTE) == PCSCLite.STATE_MUTE) {
                throw new Exception(_messages.getString("pcsc.5"));
            }
            byte[] atr = rsa[0].getrgbAtr();
            this.ctx.connect(sa[readerNumber], PCSCLite.SHARE_SHARED, PCSCLite.PROTOCOL_T1 | PCSCLite.PROTOCOL_T0);
            State rs = this.ctx.getCard().getStatus();
            return atr;
        }
        catch (Exception e) {
            System.out.println(e);
            throw e;
        }
        catch (UnsatisfiedLinkError e) {
            System.out.println(e);
            throw new Exception(_messages.getString("pcsc.4"));
        }
        catch (Throwable e) {
            System.out.println(e);
            throw new Exception(_messages.getString("pcsc.3"));
        }
    }

    public void closeCard() {
        if (this.ctx == null) {
            return;
        }
        try {
            this.ctx.getCard().Disconnect(PCSCLite.RESET_CARD);
            this.ctx.releaseContext();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

